//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.14

use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Eq)]
#[sea_orm(table_name = "reward")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i32,
    pub title: String,
    #[sea_orm(column_type = "Text")]
    pub description: String,
    pub character_id: i32,
    #[sea_orm(column_type = "custom(\"enum_text\")", nullable)]
    pub enum_value: Option<String>,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(
        belongs_to = "super::character::Entity",
        from = "Column::CharacterId",
        to = "super::character::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Character,
    #[sea_orm(has_one = "super::reward_armor::Entity")]
    RewardArmor,
    #[sea_orm(has_one = "super::reward_equipment::Entity")]
    RewardEquipment,
    #[sea_orm(has_one = "super::reward_shield::Entity")]
    RewardShield,
    #[sea_orm(has_one = "super::reward_weapon::Entity")]
    RewardWeapon,
}

impl Related<super::character::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Character.def()
    }
}

impl Related<super::reward_armor::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::RewardArmor.def()
    }
}

impl Related<super::reward_equipment::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::RewardEquipment.def()
    }
}

impl Related<super::reward_shield::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::RewardShield.def()
    }
}

impl Related<super::reward_weapon::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::RewardWeapon.def()
    }
}

impl Related<super::armor::Entity> for Entity {
    fn to() -> RelationDef {
        super::reward_armor::Relation::Armor.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::reward_armor::Relation::Reward.def().rev())
    }
}

impl Related<super::equipment::Entity> for Entity {
    fn to() -> RelationDef {
        super::reward_equipment::Relation::Equipment.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::reward_equipment::Relation::Reward.def().rev())
    }
}

impl Related<super::shield::Entity> for Entity {
    fn to() -> RelationDef {
        super::reward_shield::Relation::Shield.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::reward_shield::Relation::Reward.def().rev())
    }
}

impl Related<super::weapon::Entity> for Entity {
    fn to() -> RelationDef {
        super::reward_weapon::Relation::Weapon.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::reward_weapon::Relation::Reward.def().rev())
    }
}

impl ActiveModelBehavior for ActiveModel {}
