use serde::Deserialize;

use crate::utils::to_enum;

pub fn find_enum<T: for<'a> Deserialize<'a>>(enum_name: &str) -> Option<T> {
    let title = to_enum(enum_name);
    let title = format!("\"{title}\"");
    serde_json::from_str::<T>(&title).ok()
}
