import { writeText, readText } from '@tauri-apps/plugin-clipboard-manager';
import { tauri } from './tauri.svelte';

export async function to_clipboard(text: string): Promise<void> {
    await tauri.wait_tauri();
    if (tauri.is_tauri) {
        await writeText(text);
    } else {
        navigator.clipboard.writeText(text);
    }
}

export async function get_clipboard(): Promise<string> {
    await tauri.wait_tauri();
    if (tauri.is_tauri) {
        return await readText();
    } else {
        return await navigator.clipboard.readText();
    }
}
