import { of } from 'rxjs';
import { filter, map, mergeMap, switchMap, tap } from 'rxjs/operators';
import { Ok, Result } from '../index.js';
export function resultMap(mapper) {
    return function (source) {
        return source.pipe(map(function (result) { return result.map(mapper); }));
    };
}
export function resultMapErr(mapper) {
    return function (source) {
        return source.pipe(map(function (result) { return result.mapErr(mapper); }));
    };
}
export function resultMapTo(value) {
    return function (source) {
        return source.pipe(map(function (result) { return result.map(function () { return value; }); }));
    };
}
export function resultMapErrTo(value) {
    return function (source) {
        return source.pipe(map(function (result) { return result.mapErr(function () { return value; }); }));
    };
}
export function elseMap(mapper) {
    return function (source) {
        return source.pipe(map(function (result) {
            if (result.isErr()) {
                return mapper(result.error);
            }
            else {
                return result.value;
            }
        }));
    };
}
export function elseMapTo(value) {
    return function (source) {
        return source.pipe(map(function (result) {
            if (result.isErr()) {
                return value;
            }
            else {
                return result.value;
            }
        }));
    };
}
export function resultSwitchMap(mapper) {
    return function (source) {
        return source.pipe(switchMap(function (result) {
            if (result.isOk()) {
                return mapper(result.value);
            }
            else {
                return of(result);
            }
        }), map(function (result) {
            if (Result.isResult(result)) {
                return result;
            }
            else {
                return new Ok(result);
            }
        }));
    };
}
export function resultMergeMap(mapper) {
    return function (source) {
        return source.pipe(mergeMap(function (result) {
            if (result.isOk()) {
                return mapper(result.value);
            }
            else {
                return of(result);
            }
        }), map(function (result) {
            if (Result.isResult(result)) {
                return result;
            }
            else {
                return new Ok(result);
            }
        }));
    };
}
export function filterResultOk() {
    return function (source) {
        return source.pipe(filter(function (result) { return result.isOk(); }), map(function (result) { return result.value; }));
    };
}
export function filterResultErr() {
    return function (source) {
        return source.pipe(filter(function (result) { return result.isErr(); }), map(function (result) { return result.error; }));
    };
}
export function tapResultErr(tapFn) {
    return function (source) {
        return source.pipe(tap(function (r) {
            if (!r.isOk()) {
                tapFn(r.error);
            }
        }));
    };
}
export function tapResultOk(tapFn) {
    return function (source) {
        return source.pipe(tap(function (r) {
            if (r.isOk()) {
                tapFn(r.value);
            }
        }));
    };
}
//# sourceMappingURL=index.js.map