"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resultMap = resultMap;
exports.resultMapErr = resultMapErr;
exports.resultMapTo = resultMapTo;
exports.resultMapErrTo = resultMapErrTo;
exports.elseMap = elseMap;
exports.elseMapTo = elseMapTo;
exports.resultSwitchMap = resultSwitchMap;
exports.resultMergeMap = resultMergeMap;
exports.filterResultOk = filterResultOk;
exports.filterResultErr = filterResultErr;
exports.tapResultErr = tapResultErr;
exports.tapResultOk = tapResultOk;
var rxjs_1 = require("rxjs");
var operators_1 = require("rxjs/operators");
var index_js_1 = require("../index.js");
function resultMap(mapper) {
    return function (source) {
        return source.pipe((0, operators_1.map)(function (result) { return result.map(mapper); }));
    };
}
function resultMapErr(mapper) {
    return function (source) {
        return source.pipe((0, operators_1.map)(function (result) { return result.mapErr(mapper); }));
    };
}
function resultMapTo(value) {
    return function (source) {
        return source.pipe((0, operators_1.map)(function (result) { return result.map(function () { return value; }); }));
    };
}
function resultMapErrTo(value) {
    return function (source) {
        return source.pipe((0, operators_1.map)(function (result) { return result.mapErr(function () { return value; }); }));
    };
}
function elseMap(mapper) {
    return function (source) {
        return source.pipe((0, operators_1.map)(function (result) {
            if (result.isErr()) {
                return mapper(result.error);
            }
            else {
                return result.value;
            }
        }));
    };
}
function elseMapTo(value) {
    return function (source) {
        return source.pipe((0, operators_1.map)(function (result) {
            if (result.isErr()) {
                return value;
            }
            else {
                return result.value;
            }
        }));
    };
}
function resultSwitchMap(mapper) {
    return function (source) {
        return source.pipe((0, operators_1.switchMap)(function (result) {
            if (result.isOk()) {
                return mapper(result.value);
            }
            else {
                return (0, rxjs_1.of)(result);
            }
        }), (0, operators_1.map)(function (result) {
            if (index_js_1.Result.isResult(result)) {
                return result;
            }
            else {
                return new index_js_1.Ok(result);
            }
        }));
    };
}
function resultMergeMap(mapper) {
    return function (source) {
        return source.pipe((0, operators_1.mergeMap)(function (result) {
            if (result.isOk()) {
                return mapper(result.value);
            }
            else {
                return (0, rxjs_1.of)(result);
            }
        }), (0, operators_1.map)(function (result) {
            if (index_js_1.Result.isResult(result)) {
                return result;
            }
            else {
                return new index_js_1.Ok(result);
            }
        }));
    };
}
function filterResultOk() {
    return function (source) {
        return source.pipe((0, operators_1.filter)(function (result) { return result.isOk(); }), (0, operators_1.map)(function (result) { return result.value; }));
    };
}
function filterResultErr() {
    return function (source) {
        return source.pipe((0, operators_1.filter)(function (result) { return result.isErr(); }), (0, operators_1.map)(function (result) { return result.error; }));
    };
}
function tapResultErr(tapFn) {
    return function (source) {
        return source.pipe((0, operators_1.tap)(function (r) {
            if (!r.isOk()) {
                tapFn(r.error);
            }
        }));
    };
}
function tapResultOk(tapFn) {
    return function (source) {
        return source.pipe((0, operators_1.tap)(function (r) {
            if (r.isOk()) {
                tapFn(r.value);
            }
        }));
    };
}
//# sourceMappingURL=index.js.map