'use strict';

var require$$0$5 = require('chokidar');
var require$$0$1 = require('fs');
var path$1 = require('path');
var require$$0$2 = require('node:util');
var require$$1$2 = require('util');
var require$$2$1 = require('os');
var require$$3 = require('crypto');
var require$$4 = require('net');
var require$$5 = require('url');
var require$$3$1 = require('child_process');
var require$$0$3 = require('events');
var ts = require('typescript');
var require$$1$3 = require('fs/promises');
var require$$0$4 = require('@jridgewell/trace-mapping');
var compiler = require('svelte/compiler');
var require$$1$4 = require('perf_hooks');
var sade = require('sade');
var pc = require('picocolors');

function _interopNamespaceDefault(e) {
	var n = Object.create(null);
	if (e) {
		Object.keys(e).forEach(function (k) {
			if (k !== 'default') {
				var d = Object.getOwnPropertyDescriptor(e, k);
				Object.defineProperty(n, k, d.get ? d : {
					enumerable: true,
					get: function () { return e[k]; }
				});
			}
		});
	}
	n.default = e;
	return Object.freeze(n);
}

var require$$0__namespace = /*#__PURE__*/_interopNamespaceDefault(require$$0$1);
var path__namespace = /*#__PURE__*/_interopNamespaceDefault(path$1);

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getAugmentedNamespace(n) {
  if (n.__esModule) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			if (this instanceof a) {
				var args = [null];
				args.push.apply(args, arguments);
				var Ctor = Function.bind.apply(f, args);
				return new Ctor();
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

var dist = {};

var builder = {};

var apiBuilder = {};

var async = {};

var walker = {};

var utils$6 = {};

Object.defineProperty(utils$6, "__esModule", { value: true });
utils$6.convertSlashes = utils$6.cleanPath = void 0;
const path_1$g = path$1;
function cleanPath(path) {
    let normalized = (0, path_1$g.normalize)(path);
    if (normalized.length > 1 && normalized[normalized.length - 1] === path_1$g.sep)
        normalized = normalized.substring(0, normalized.length - 1);
    return normalized;
}
utils$6.cleanPath = cleanPath;
const SLASHES_REGEX = /[\\/]/g;
function convertSlashes(path, separator) {
    return path.replace(SLASHES_REGEX, separator);
}
utils$6.convertSlashes = convertSlashes;

var joinPath$4 = {};

Object.defineProperty(joinPath$4, "__esModule", { value: true });
joinPath$4.build = joinPath$4.joinDirectoryPath = void 0;
function joinPathWithBasePath(filename, directoryPath) {
    return directoryPath + filename;
}
function joinPathWithRelativePath(root) {
    return function (filename, directoryPath) {
        return directoryPath.substring(root.length) + filename;
    };
}
function joinPath$3(filename) {
    return filename;
}
function joinDirectoryPath(filename, directoryPath, separator) {
    return directoryPath + filename + separator;
}
joinPath$4.joinDirectoryPath = joinDirectoryPath;
function build$7(root, options) {
    const { relativePaths, includeBasePath } = options;
    return relativePaths && root
        ? joinPathWithRelativePath(root)
        : includeBasePath
            ? joinPathWithBasePath
            : joinPath$3;
}
joinPath$4.build = build$7;

var pushDirectory$2 = {};

Object.defineProperty(pushDirectory$2, "__esModule", { value: true });
pushDirectory$2.build = void 0;
function pushDirectoryWithRelativePath(root) {
    return function (directoryPath, paths) {
        paths.push((directoryPath || ".").substring(root.length));
    };
}
function pushDirectoryFilterWithRelativePath(root) {
    return function (directoryPath, paths, filters) {
        const relativePath = directoryPath.substring(root.length);
        if (filters.every((filter) => filter(relativePath, true))) {
            paths.push(relativePath);
        }
    };
}
const pushDirectory$1 = (directoryPath, paths) => {
    paths.push(directoryPath || ".");
};
const pushDirectoryFilter = (directoryPath, paths, filters) => {
    if (filters.every((filter) => filter(directoryPath, true))) {
        paths.push(directoryPath);
    }
};
const empty$2 = () => { };
function build$6(root, options) {
    const { includeDirs, filters, relativePaths } = options;
    if (!includeDirs)
        return empty$2;
    if (relativePaths)
        return filters && filters.length
            ? pushDirectoryFilterWithRelativePath(root)
            : pushDirectoryWithRelativePath(root);
    return filters && filters.length ? pushDirectoryFilter : pushDirectory$1;
}
pushDirectory$2.build = build$6;

var pushFile$2 = {};

Object.defineProperty(pushFile$2, "__esModule", { value: true });
pushFile$2.build = void 0;
const pushFileFilterAndCount = (filename, _paths, counts, filters) => {
    if (filters.every((filter) => filter(filename, false)))
        counts.files++;
};
const pushFileFilter = (filename, paths, _counts, filters) => {
    if (filters.every((filter) => filter(filename, false)))
        paths.push(filename);
};
const pushFileCount = (_filename, _paths, counts, _filters) => {
    counts.files++;
};
const pushFile$1 = (filename, paths) => {
    paths.push(filename);
};
const empty$1 = () => { };
function build$5(options) {
    const { excludeFiles, filters, onlyCounts } = options;
    if (excludeFiles)
        return empty$1;
    if (filters && filters.length) {
        return onlyCounts ? pushFileFilterAndCount : pushFileFilter;
    }
    else if (onlyCounts) {
        return pushFileCount;
    }
    else {
        return pushFile$1;
    }
}
pushFile$2.build = build$5;

var getArray$2 = {};

Object.defineProperty(getArray$2, "__esModule", { value: true });
getArray$2.build = void 0;
const getArray$1 = (paths) => {
    return paths;
};
const getArrayGroup = () => {
    return [""].slice(0, 0);
};
function build$4(options) {
    return options.group ? getArrayGroup : getArray$1;
}
getArray$2.build = build$4;

var groupFiles$2 = {};

Object.defineProperty(groupFiles$2, "__esModule", { value: true });
groupFiles$2.build = void 0;
const groupFiles$1 = (groups, directory, files) => {
    groups.push({ directory, files, dir: directory });
};
const empty = () => { };
function build$3(options) {
    return options.group ? groupFiles$1 : empty;
}
groupFiles$2.build = build$3;

var resolveSymlink$1 = {};

var __importDefault$u = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(resolveSymlink$1, "__esModule", { value: true });
resolveSymlink$1.build = void 0;
const fs_1$4 = __importDefault$u(require$$0$1);
const resolveSymlinksAsync = function (path, state, callback) {
    const { queue, options: { suppressErrors }, } = state;
    queue.enqueue();
    fs_1$4.default.realpath(path, (error, resolvedPath) => {
        if (error) {
            queue.dequeue(suppressErrors ? null : error, state);
            return;
        }
        fs_1$4.default.lstat(resolvedPath, (_error, stat) => {
            callback(stat, resolvedPath);
            queue.dequeue(null, state);
        });
    });
};
const resolveSymlinksSync = function (path, state, callback) {
    try {
        const resolvedPath = fs_1$4.default.realpathSync(path);
        const stat = fs_1$4.default.lstatSync(resolvedPath);
        callback(stat, resolvedPath);
    }
    catch (e) {
        if (!state.options.suppressErrors)
            throw e;
    }
};
function build$2(options, isSynchronous) {
    if (!options.resolveSymlinks)
        return null;
    return isSynchronous ? resolveSymlinksSync : resolveSymlinksAsync;
}
resolveSymlink$1.build = build$2;

var invokeCallback$1 = {};

Object.defineProperty(invokeCallback$1, "__esModule", { value: true });
invokeCallback$1.build = void 0;
const onlyCountsSync = (state) => {
    return state.counts;
};
const groupsSync = (state) => {
    return state.groups;
};
const defaultSync = (state) => {
    return state.paths;
};
const limitFilesSync = (state) => {
    return state.paths.slice(0, state.options.maxFiles);
};
const onlyCountsAsync = (state, error, callback) => {
    report(error, callback, state.counts, state.options.suppressErrors);
    return null;
};
const defaultAsync = (state, error, callback) => {
    report(error, callback, state.paths, state.options.suppressErrors);
    return null;
};
const limitFilesAsync = (state, error, callback) => {
    report(error, callback, state.paths.slice(0, state.options.maxFiles), state.options.suppressErrors);
    return null;
};
const groupsAsync = (state, error, callback) => {
    report(error, callback, state.groups, state.options.suppressErrors);
    return null;
};
function report(error, callback, output, suppressErrors) {
    if (error && !suppressErrors)
        callback(error, output);
    else
        callback(null, output);
}
function build$1(options, isSynchronous) {
    const { onlyCounts, group, maxFiles } = options;
    if (onlyCounts)
        return isSynchronous
            ? onlyCountsSync
            : onlyCountsAsync;
    else if (group)
        return isSynchronous
            ? groupsSync
            : groupsAsync;
    else if (maxFiles)
        return isSynchronous
            ? limitFilesSync
            : limitFilesAsync;
    else
        return isSynchronous
            ? defaultSync
            : defaultAsync;
}
invokeCallback$1.build = build$1;

var walkDirectory$1 = {};

var __importDefault$t = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(walkDirectory$1, "__esModule", { value: true });
walkDirectory$1.build = void 0;
const fs_1$3 = __importDefault$t(require$$0$1);
const readdirOpts = { withFileTypes: true };
const walkAsync = (state, directoryPath, currentDepth, callback) => {
    state.queue.enqueue();
    if (currentDepth < 0) {
        state.queue.dequeue(null, state);
        return;
    }
    state.counts.directories++;
    fs_1$3.default.readdir(directoryPath || ".", readdirOpts, function process(error, entries = []) {
        callback(entries, directoryPath, currentDepth);
        state.queue.dequeue(state.options.suppressErrors ? null : error, state);
    });
};
const walkSync = (state, directoryPath, currentDepth, callback) => {
    if (currentDepth < 0) {
        return;
    }
    state.counts.directories++;
    let entries = [];
    try {
        entries = fs_1$3.default.readdirSync(directoryPath || ".", readdirOpts);
    }
    catch (e) {
        if (!state.options.suppressErrors)
            throw e;
    }
    callback(entries, directoryPath, currentDepth);
};
function build(isSynchronous) {
    return isSynchronous ? walkSync : walkAsync;
}
walkDirectory$1.build = build;

var queue = {};

Object.defineProperty(queue, "__esModule", { value: true });
queue.Queue = void 0;
class Queue {
    onQueueEmpty;
    count = 0;
    constructor(onQueueEmpty) {
        this.onQueueEmpty = onQueueEmpty;
    }
    enqueue() {
        this.count++;
    }
    dequeue(error, output) {
        if (--this.count === 0 || error)
            this.onQueueEmpty(error, output);
    }
}
queue.Queue = Queue;

var counter = {};

Object.defineProperty(counter, "__esModule", { value: true });
counter.Counter = void 0;
class Counter {
    _files = 0;
    _directories = 0;
    set files(num) {
        this._files = num;
    }
    get files() {
        return this._files;
    }
    set directories(num) {
        this._directories = num;
    }
    get directories() {
        return this._directories;
    }
    get dirs() {
        return this._directories;
    }
}
counter.Counter = Counter;

var __createBinding$1 = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault$1 = (commonjsGlobal && commonjsGlobal.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar$1 = (commonjsGlobal && commonjsGlobal.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding$1(result, mod, k);
    __setModuleDefault$1(result, mod);
    return result;
};
Object.defineProperty(walker, "__esModule", { value: true });
walker.Walker = void 0;
const path_1$f = path$1;
const utils_1$M = utils$6;
const joinPath$2 = __importStar$1(joinPath$4);
const pushDirectory = __importStar$1(pushDirectory$2);
const pushFile = __importStar$1(pushFile$2);
const getArray = __importStar$1(getArray$2);
const groupFiles = __importStar$1(groupFiles$2);
const resolveSymlink = __importStar$1(resolveSymlink$1);
const invokeCallback = __importStar$1(invokeCallback$1);
const walkDirectory = __importStar$1(walkDirectory$1);
const queue_1 = queue;
const counter_1 = counter;
class Walker {
    root;
    isSynchronous;
    state;
    joinPath;
    pushDirectory;
    pushFile;
    getArray;
    groupFiles;
    resolveSymlink;
    walkDirectory;
    callbackInvoker;
    constructor(root, options, callback) {
        this.isSynchronous = !callback;
        this.callbackInvoker = invokeCallback.build(options, this.isSynchronous);
        this.state = {
            paths: [""].slice(0, 0),
            groups: [],
            counts: new counter_1.Counter(),
            options,
            queue: new queue_1.Queue((error, state) => this.callbackInvoker(state, error, callback)),
        };
        this.root = this.normalizePath(root);
        this.joinPath = joinPath$2.build(this.root, options);
        this.pushDirectory = pushDirectory.build(this.root, options);
        this.pushFile = pushFile.build(options);
        this.getArray = getArray.build(options);
        this.groupFiles = groupFiles.build(options);
        this.resolveSymlink = resolveSymlink.build(options, this.isSynchronous);
        this.walkDirectory = walkDirectory.build(this.isSynchronous);
    }
    start() {
        this.walkDirectory(this.state, this.root, this.state.options.maxDepth, this.walk);
        return this.isSynchronous ? this.callbackInvoker(this.state, null) : null;
    }
    normalizePath(path) {
        const { resolvePaths, normalizePath, pathSeparator } = this.state.options;
        const pathNeedsCleaning = (process.platform === "win32" && path.includes("/")) ||
            path.startsWith(".");
        if (resolvePaths)
            path = (0, path_1$f.resolve)(path);
        if (normalizePath || pathNeedsCleaning)
            path = (0, utils_1$M.cleanPath)(path);
        if (path === ".")
            return "";
        const needsSeperator = path[path.length - 1] !== pathSeparator;
        return (0, utils_1$M.convertSlashes)(needsSeperator ? path + pathSeparator : path, pathSeparator);
    }
    walk = (entries, directoryPath, depth) => {
        const { paths, options: { filters, resolveSymlinks, exclude, maxFiles, signal }, } = this.state;
        if ((signal && signal.aborted) || (maxFiles && paths.length > maxFiles))
            return;
        this.pushDirectory(directoryPath, paths, filters);
        const files = this.getArray(this.state.paths);
        for (let i = 0; i < entries.length; ++i) {
            const entry = entries[i];
            if (entry.isFile() || (entry.isSymbolicLink() && !resolveSymlinks)) {
                const filename = this.joinPath(entry.name, directoryPath);
                this.pushFile(filename, files, this.state.counts, filters);
            }
            else if (entry.isDirectory()) {
                let path = joinPath$2.joinDirectoryPath(entry.name, directoryPath, this.state.options.pathSeparator);
                if (exclude && exclude(entry.name, path))
                    continue;
                this.walkDirectory(this.state, path, depth - 1, this.walk);
            }
            else if (entry.isSymbolicLink() && resolveSymlinks) {
                let path = joinPath$2.joinDirectoryPath(entry.name, directoryPath, this.state.options.pathSeparator);
                this.resolveSymlink(path, this.state, (stat, resolvedPath) => {
                    if (stat.isDirectory()) {
                        resolvedPath = this.normalizePath(resolvedPath);
                        if (exclude && exclude(entry.name, resolvedPath))
                            return;
                        this.walkDirectory(this.state, resolvedPath, depth - 1, this.walk);
                    }
                    else {
                        this.pushFile(resolvedPath, files, this.state.counts, filters);
                    }
                });
            }
        }
        this.groupFiles(this.state.groups, directoryPath, files);
    };
}
walker.Walker = Walker;

Object.defineProperty(async, "__esModule", { value: true });
async.callback = async.promise = void 0;
const walker_1$1 = walker;
function promise(root, options) {
    return new Promise((resolve, reject) => {
        callback(root, options, (err, output) => {
            if (err)
                return reject(err);
            resolve(output);
        });
    });
}
async.promise = promise;
function callback(root, options, callback) {
    let walker = new walker_1$1.Walker(root, options, callback);
    walker.start();
}
async.callback = callback;

var sync$1 = {};

Object.defineProperty(sync$1, "__esModule", { value: true });
sync$1.sync = void 0;
const walker_1 = walker;
function sync(root, options) {
    const walker = new walker_1.Walker(root, options);
    return walker.start();
}
sync$1.sync = sync;

Object.defineProperty(apiBuilder, "__esModule", { value: true });
apiBuilder.APIBuilder = void 0;
const async_1 = async;
const sync_1 = sync$1;
class APIBuilder {
    root;
    options;
    constructor(root, options) {
        this.root = root;
        this.options = options;
    }
    withPromise() {
        return (0, async_1.promise)(this.root, this.options);
    }
    withCallback(cb) {
        (0, async_1.callback)(this.root, this.options, cb);
    }
    sync() {
        return (0, sync_1.sync)(this.root, this.options);
    }
}
apiBuilder.APIBuilder = APIBuilder;

var utils$5 = {};

var constants;
var hasRequiredConstants;
function requireConstants () {
	if (hasRequiredConstants) return constants;
	hasRequiredConstants = 1;
	const path = path$1;
	const WIN_SLASH = '\\\\/';
	const WIN_NO_SLASH = `[^${WIN_SLASH}]`;
	const DOT_LITERAL = '\\.';
	const PLUS_LITERAL = '\\+';
	const QMARK_LITERAL = '\\?';
	const SLASH_LITERAL = '\\/';
	const ONE_CHAR = '(?=.)';
	const QMARK = '[^/]';
	const END_ANCHOR = `(?:${SLASH_LITERAL}|$)`;
	const START_ANCHOR = `(?:^|${SLASH_LITERAL})`;
	const DOTS_SLASH = `${DOT_LITERAL}{1,2}${END_ANCHOR}`;
	const NO_DOT = `(?!${DOT_LITERAL})`;
	const NO_DOTS = `(?!${START_ANCHOR}${DOTS_SLASH})`;
	const NO_DOT_SLASH = `(?!${DOT_LITERAL}{0,1}${END_ANCHOR})`;
	const NO_DOTS_SLASH = `(?!${DOTS_SLASH})`;
	const QMARK_NO_DOT = `[^.${SLASH_LITERAL}]`;
	const STAR = `${QMARK}*?`;
	const POSIX_CHARS = {
	  DOT_LITERAL,
	  PLUS_LITERAL,
	  QMARK_LITERAL,
	  SLASH_LITERAL,
	  ONE_CHAR,
	  QMARK,
	  END_ANCHOR,
	  DOTS_SLASH,
	  NO_DOT,
	  NO_DOTS,
	  NO_DOT_SLASH,
	  NO_DOTS_SLASH,
	  QMARK_NO_DOT,
	  STAR,
	  START_ANCHOR
	};
	const WINDOWS_CHARS = {
	  ...POSIX_CHARS,
	  SLASH_LITERAL: `[${WIN_SLASH}]`,
	  QMARK: WIN_NO_SLASH,
	  STAR: `${WIN_NO_SLASH}*?`,
	  DOTS_SLASH: `${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$)`,
	  NO_DOT: `(?!${DOT_LITERAL})`,
	  NO_DOTS: `(?!(?:^|[${WIN_SLASH}])${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
	  NO_DOT_SLASH: `(?!${DOT_LITERAL}{0,1}(?:[${WIN_SLASH}]|$))`,
	  NO_DOTS_SLASH: `(?!${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
	  QMARK_NO_DOT: `[^.${WIN_SLASH}]`,
	  START_ANCHOR: `(?:^|[${WIN_SLASH}])`,
	  END_ANCHOR: `(?:[${WIN_SLASH}]|$)`
	};
	const POSIX_REGEX_SOURCE = {
	  alnum: 'a-zA-Z0-9',
	  alpha: 'a-zA-Z',
	  ascii: '\\x00-\\x7F',
	  blank: ' \\t',
	  cntrl: '\\x00-\\x1F\\x7F',
	  digit: '0-9',
	  graph: '\\x21-\\x7E',
	  lower: 'a-z',
	  print: '\\x20-\\x7E ',
	  punct: '\\-!"#$%&\'()\\*+,./:;<=>?@[\\]^_`{|}~',
	  space: ' \\t\\r\\n\\v\\f',
	  upper: 'A-Z',
	  word: 'A-Za-z0-9_',
	  xdigit: 'A-Fa-f0-9'
	};
	constants = {
	  MAX_LENGTH: 1024 * 64,
	  POSIX_REGEX_SOURCE,
	  REGEX_BACKSLASH: /\\(?![*+?^${}(|)[\]])/g,
	  REGEX_NON_SPECIAL_CHARS: /^[^@![\].,$*+?^{}()|\\/]+/,
	  REGEX_SPECIAL_CHARS: /[-*+?.^${}(|)[\]]/,
	  REGEX_SPECIAL_CHARS_BACKREF: /(\\?)((\W)(\3*))/g,
	  REGEX_SPECIAL_CHARS_GLOBAL: /([-*+?.^${}(|)[\]])/g,
	  REGEX_REMOVE_BACKSLASH: /(?:\[.*?[^\\]\]|\\(?=.))/g,
	  REPLACEMENTS: {
	    '***': '*',
	    '**/**': '**',
	    '**/**/**': '**'
	  },
	  CHAR_0: 48,
	  CHAR_9: 57,
	  CHAR_UPPERCASE_A: 65,
	  CHAR_LOWERCASE_A: 97,
	  CHAR_UPPERCASE_Z: 90,
	  CHAR_LOWERCASE_Z: 122,
	  CHAR_LEFT_PARENTHESES: 40,
	  CHAR_RIGHT_PARENTHESES: 41,
	  CHAR_ASTERISK: 42,
	  CHAR_AMPERSAND: 38,
	  CHAR_AT: 64,
	  CHAR_BACKWARD_SLASH: 92,
	  CHAR_CARRIAGE_RETURN: 13,
	  CHAR_CIRCUMFLEX_ACCENT: 94,
	  CHAR_COLON: 58,
	  CHAR_COMMA: 44,
	  CHAR_DOT: 46,
	  CHAR_DOUBLE_QUOTE: 34,
	  CHAR_EQUAL: 61,
	  CHAR_EXCLAMATION_MARK: 33,
	  CHAR_FORM_FEED: 12,
	  CHAR_FORWARD_SLASH: 47,
	  CHAR_GRAVE_ACCENT: 96,
	  CHAR_HASH: 35,
	  CHAR_HYPHEN_MINUS: 45,
	  CHAR_LEFT_ANGLE_BRACKET: 60,
	  CHAR_LEFT_CURLY_BRACE: 123,
	  CHAR_LEFT_SQUARE_BRACKET: 91,
	  CHAR_LINE_FEED: 10,
	  CHAR_NO_BREAK_SPACE: 160,
	  CHAR_PERCENT: 37,
	  CHAR_PLUS: 43,
	  CHAR_QUESTION_MARK: 63,
	  CHAR_RIGHT_ANGLE_BRACKET: 62,
	  CHAR_RIGHT_CURLY_BRACE: 125,
	  CHAR_RIGHT_SQUARE_BRACKET: 93,
	  CHAR_SEMICOLON: 59,
	  CHAR_SINGLE_QUOTE: 39,
	  CHAR_SPACE: 32,
	  CHAR_TAB: 9,
	  CHAR_UNDERSCORE: 95,
	  CHAR_VERTICAL_LINE: 124,
	  CHAR_ZERO_WIDTH_NOBREAK_SPACE: 65279,
	  SEP: path.sep,
	  extglobChars(chars) {
	    return {
	      '!': { type: 'negate', open: '(?:(?!(?:', close: `))${chars.STAR})` },
	      '?': { type: 'qmark', open: '(?:', close: ')?' },
	      '+': { type: 'plus', open: '(?:', close: ')+' },
	      '*': { type: 'star', open: '(?:', close: ')*' },
	      '@': { type: 'at', open: '(?:', close: ')' }
	    };
	  },
	  globChars(win32) {
	    return win32 === true ? WINDOWS_CHARS : POSIX_CHARS;
	  }
	};
	return constants;
}

var hasRequiredUtils$2;
function requireUtils$2 () {
	if (hasRequiredUtils$2) return utils$5;
	hasRequiredUtils$2 = 1;
	(function (exports) {
		const path = path$1;
		const win32 = process.platform === 'win32';
		const {
		  REGEX_BACKSLASH,
		  REGEX_REMOVE_BACKSLASH,
		  REGEX_SPECIAL_CHARS,
		  REGEX_SPECIAL_CHARS_GLOBAL
		} = requireConstants();
		exports.isObject = val => val !== null && typeof val === 'object' && !Array.isArray(val);
		exports.hasRegexChars = str => REGEX_SPECIAL_CHARS.test(str);
		exports.isRegexChar = str => str.length === 1 && exports.hasRegexChars(str);
		exports.escapeRegex = str => str.replace(REGEX_SPECIAL_CHARS_GLOBAL, '\\$1');
		exports.toPosixSlashes = str => str.replace(REGEX_BACKSLASH, '/');
		exports.removeBackslashes = str => {
		  return str.replace(REGEX_REMOVE_BACKSLASH, match => {
		    return match === '\\' ? '' : match;
		  });
		};
		exports.supportsLookbehinds = () => {
		  const segs = process.version.slice(1).split('.').map(Number);
		  if (segs.length === 3 && segs[0] >= 9 || (segs[0] === 8 && segs[1] >= 10)) {
		    return true;
		  }
		  return false;
		};
		exports.isWindows = options => {
		  if (options && typeof options.windows === 'boolean') {
		    return options.windows;
		  }
		  return win32 === true || path.sep === '\\';
		};
		exports.escapeLast = (input, char, lastIdx) => {
		  const idx = input.lastIndexOf(char, lastIdx);
		  if (idx === -1) return input;
		  if (input[idx - 1] === '\\') return exports.escapeLast(input, char, idx - 1);
		  return `${input.slice(0, idx)}\\${input.slice(idx)}`;
		};
		exports.removePrefix = (input, state = {}) => {
		  let output = input;
		  if (output.startsWith('./')) {
		    output = output.slice(2);
		    state.prefix = './';
		  }
		  return output;
		};
		exports.wrapOutput = (input, state = {}, options = {}) => {
		  const prepend = options.contains ? '' : '^';
		  const append = options.contains ? '' : '$';
		  let output = `${prepend}(?:${input})${append}`;
		  if (state.negated === true) {
		    output = `(?:^(?!${output}).*$)`;
		  }
		  return output;
		};
	} (utils$5));
	return utils$5;
}

var scan_1;
var hasRequiredScan;
function requireScan () {
	if (hasRequiredScan) return scan_1;
	hasRequiredScan = 1;
	const utils = requireUtils$2();
	const {
	  CHAR_ASTERISK,
	  CHAR_AT,
	  CHAR_BACKWARD_SLASH,
	  CHAR_COMMA,
	  CHAR_DOT,
	  CHAR_EXCLAMATION_MARK,
	  CHAR_FORWARD_SLASH,
	  CHAR_LEFT_CURLY_BRACE,
	  CHAR_LEFT_PARENTHESES,
	  CHAR_LEFT_SQUARE_BRACKET,
	  CHAR_PLUS,
	  CHAR_QUESTION_MARK,
	  CHAR_RIGHT_CURLY_BRACE,
	  CHAR_RIGHT_PARENTHESES,
	  CHAR_RIGHT_SQUARE_BRACKET
	} = requireConstants();
	const isPathSeparator = code => {
	  return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
	};
	const depth = token => {
	  if (token.isPrefix !== true) {
	    token.depth = token.isGlobstar ? Infinity : 1;
	  }
	};
	const scan = (input, options) => {
	  const opts = options || {};
	  const length = input.length - 1;
	  const scanToEnd = opts.parts === true || opts.scanToEnd === true;
	  const slashes = [];
	  const tokens = [];
	  const parts = [];
	  let str = input;
	  let index = -1;
	  let start = 0;
	  let lastIndex = 0;
	  let isBrace = false;
	  let isBracket = false;
	  let isGlob = false;
	  let isExtglob = false;
	  let isGlobstar = false;
	  let braceEscaped = false;
	  let backslashes = false;
	  let negated = false;
	  let negatedExtglob = false;
	  let finished = false;
	  let braces = 0;
	  let prev;
	  let code;
	  let token = { value: '', depth: 0, isGlob: false };
	  const eos = () => index >= length;
	  const peek = () => str.charCodeAt(index + 1);
	  const advance = () => {
	    prev = code;
	    return str.charCodeAt(++index);
	  };
	  while (index < length) {
	    code = advance();
	    let next;
	    if (code === CHAR_BACKWARD_SLASH) {
	      backslashes = token.backslashes = true;
	      code = advance();
	      if (code === CHAR_LEFT_CURLY_BRACE) {
	        braceEscaped = true;
	      }
	      continue;
	    }
	    if (braceEscaped === true || code === CHAR_LEFT_CURLY_BRACE) {
	      braces++;
	      while (eos() !== true && (code = advance())) {
	        if (code === CHAR_BACKWARD_SLASH) {
	          backslashes = token.backslashes = true;
	          advance();
	          continue;
	        }
	        if (code === CHAR_LEFT_CURLY_BRACE) {
	          braces++;
	          continue;
	        }
	        if (braceEscaped !== true && code === CHAR_DOT && (code = advance()) === CHAR_DOT) {
	          isBrace = token.isBrace = true;
	          isGlob = token.isGlob = true;
	          finished = true;
	          if (scanToEnd === true) {
	            continue;
	          }
	          break;
	        }
	        if (braceEscaped !== true && code === CHAR_COMMA) {
	          isBrace = token.isBrace = true;
	          isGlob = token.isGlob = true;
	          finished = true;
	          if (scanToEnd === true) {
	            continue;
	          }
	          break;
	        }
	        if (code === CHAR_RIGHT_CURLY_BRACE) {
	          braces--;
	          if (braces === 0) {
	            braceEscaped = false;
	            isBrace = token.isBrace = true;
	            finished = true;
	            break;
	          }
	        }
	      }
	      if (scanToEnd === true) {
	        continue;
	      }
	      break;
	    }
	    if (code === CHAR_FORWARD_SLASH) {
	      slashes.push(index);
	      tokens.push(token);
	      token = { value: '', depth: 0, isGlob: false };
	      if (finished === true) continue;
	      if (prev === CHAR_DOT && index === (start + 1)) {
	        start += 2;
	        continue;
	      }
	      lastIndex = index + 1;
	      continue;
	    }
	    if (opts.noext !== true) {
	      const isExtglobChar = code === CHAR_PLUS
	        || code === CHAR_AT
	        || code === CHAR_ASTERISK
	        || code === CHAR_QUESTION_MARK
	        || code === CHAR_EXCLAMATION_MARK;
	      if (isExtglobChar === true && peek() === CHAR_LEFT_PARENTHESES) {
	        isGlob = token.isGlob = true;
	        isExtglob = token.isExtglob = true;
	        finished = true;
	        if (code === CHAR_EXCLAMATION_MARK && index === start) {
	          negatedExtglob = true;
	        }
	        if (scanToEnd === true) {
	          while (eos() !== true && (code = advance())) {
	            if (code === CHAR_BACKWARD_SLASH) {
	              backslashes = token.backslashes = true;
	              code = advance();
	              continue;
	            }
	            if (code === CHAR_RIGHT_PARENTHESES) {
	              isGlob = token.isGlob = true;
	              finished = true;
	              break;
	            }
	          }
	          continue;
	        }
	        break;
	      }
	    }
	    if (code === CHAR_ASTERISK) {
	      if (prev === CHAR_ASTERISK) isGlobstar = token.isGlobstar = true;
	      isGlob = token.isGlob = true;
	      finished = true;
	      if (scanToEnd === true) {
	        continue;
	      }
	      break;
	    }
	    if (code === CHAR_QUESTION_MARK) {
	      isGlob = token.isGlob = true;
	      finished = true;
	      if (scanToEnd === true) {
	        continue;
	      }
	      break;
	    }
	    if (code === CHAR_LEFT_SQUARE_BRACKET) {
	      while (eos() !== true && (next = advance())) {
	        if (next === CHAR_BACKWARD_SLASH) {
	          backslashes = token.backslashes = true;
	          advance();
	          continue;
	        }
	        if (next === CHAR_RIGHT_SQUARE_BRACKET) {
	          isBracket = token.isBracket = true;
	          isGlob = token.isGlob = true;
	          finished = true;
	          break;
	        }
	      }
	      if (scanToEnd === true) {
	        continue;
	      }
	      break;
	    }
	    if (opts.nonegate !== true && code === CHAR_EXCLAMATION_MARK && index === start) {
	      negated = token.negated = true;
	      start++;
	      continue;
	    }
	    if (opts.noparen !== true && code === CHAR_LEFT_PARENTHESES) {
	      isGlob = token.isGlob = true;
	      if (scanToEnd === true) {
	        while (eos() !== true && (code = advance())) {
	          if (code === CHAR_LEFT_PARENTHESES) {
	            backslashes = token.backslashes = true;
	            code = advance();
	            continue;
	          }
	          if (code === CHAR_RIGHT_PARENTHESES) {
	            finished = true;
	            break;
	          }
	        }
	        continue;
	      }
	      break;
	    }
	    if (isGlob === true) {
	      finished = true;
	      if (scanToEnd === true) {
	        continue;
	      }
	      break;
	    }
	  }
	  if (opts.noext === true) {
	    isExtglob = false;
	    isGlob = false;
	  }
	  let base = str;
	  let prefix = '';
	  let glob = '';
	  if (start > 0) {
	    prefix = str.slice(0, start);
	    str = str.slice(start);
	    lastIndex -= start;
	  }
	  if (base && isGlob === true && lastIndex > 0) {
	    base = str.slice(0, lastIndex);
	    glob = str.slice(lastIndex);
	  } else if (isGlob === true) {
	    base = '';
	    glob = str;
	  } else {
	    base = str;
	  }
	  if (base && base !== '' && base !== '/' && base !== str) {
	    if (isPathSeparator(base.charCodeAt(base.length - 1))) {
	      base = base.slice(0, -1);
	    }
	  }
	  if (opts.unescape === true) {
	    if (glob) glob = utils.removeBackslashes(glob);
	    if (base && backslashes === true) {
	      base = utils.removeBackslashes(base);
	    }
	  }
	  const state = {
	    prefix,
	    input,
	    start,
	    base,
	    glob,
	    isBrace,
	    isBracket,
	    isGlob,
	    isExtglob,
	    isGlobstar,
	    negated,
	    negatedExtglob
	  };
	  if (opts.tokens === true) {
	    state.maxDepth = 0;
	    if (!isPathSeparator(code)) {
	      tokens.push(token);
	    }
	    state.tokens = tokens;
	  }
	  if (opts.parts === true || opts.tokens === true) {
	    let prevIndex;
	    for (let idx = 0; idx < slashes.length; idx++) {
	      const n = prevIndex ? prevIndex + 1 : start;
	      const i = slashes[idx];
	      const value = input.slice(n, i);
	      if (opts.tokens) {
	        if (idx === 0 && start !== 0) {
	          tokens[idx].isPrefix = true;
	          tokens[idx].value = prefix;
	        } else {
	          tokens[idx].value = value;
	        }
	        depth(tokens[idx]);
	        state.maxDepth += tokens[idx].depth;
	      }
	      if (idx !== 0 || value !== '') {
	        parts.push(value);
	      }
	      prevIndex = i;
	    }
	    if (prevIndex && prevIndex + 1 < input.length) {
	      const value = input.slice(prevIndex + 1);
	      parts.push(value);
	      if (opts.tokens) {
	        tokens[tokens.length - 1].value = value;
	        depth(tokens[tokens.length - 1]);
	        state.maxDepth += tokens[tokens.length - 1].depth;
	      }
	    }
	    state.slashes = slashes;
	    state.parts = parts;
	  }
	  return state;
	};
	scan_1 = scan;
	return scan_1;
}

var parse_1;
var hasRequiredParse;
function requireParse () {
	if (hasRequiredParse) return parse_1;
	hasRequiredParse = 1;
	const constants = requireConstants();
	const utils = requireUtils$2();
	const {
	  MAX_LENGTH,
	  POSIX_REGEX_SOURCE,
	  REGEX_NON_SPECIAL_CHARS,
	  REGEX_SPECIAL_CHARS_BACKREF,
	  REPLACEMENTS
	} = constants;
	const expandRange = (args, options) => {
	  if (typeof options.expandRange === 'function') {
	    return options.expandRange(...args, options);
	  }
	  args.sort();
	  const value = `[${args.join('-')}]`;
	  try {
	    new RegExp(value);
	  } catch (ex) {
	    return args.map(v => utils.escapeRegex(v)).join('..');
	  }
	  return value;
	};
	const syntaxError = (type, char) => {
	  return `Missing ${type}: "${char}" - use "\\\\${char}" to match literal characters`;
	};
	const parse = (input, options) => {
	  if (typeof input !== 'string') {
	    throw new TypeError('Expected a string');
	  }
	  input = REPLACEMENTS[input] || input;
	  const opts = { ...options };
	  const max = typeof opts.maxLength === 'number' ? Math.min(MAX_LENGTH, opts.maxLength) : MAX_LENGTH;
	  let len = input.length;
	  if (len > max) {
	    throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
	  }
	  const bos = { type: 'bos', value: '', output: opts.prepend || '' };
	  const tokens = [bos];
	  const capture = opts.capture ? '' : '?:';
	  const win32 = utils.isWindows(options);
	  const PLATFORM_CHARS = constants.globChars(win32);
	  const EXTGLOB_CHARS = constants.extglobChars(PLATFORM_CHARS);
	  const {
	    DOT_LITERAL,
	    PLUS_LITERAL,
	    SLASH_LITERAL,
	    ONE_CHAR,
	    DOTS_SLASH,
	    NO_DOT,
	    NO_DOT_SLASH,
	    NO_DOTS_SLASH,
	    QMARK,
	    QMARK_NO_DOT,
	    STAR,
	    START_ANCHOR
	  } = PLATFORM_CHARS;
	  const globstar = opts => {
	    return `(${capture}(?:(?!${START_ANCHOR}${opts.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
	  };
	  const nodot = opts.dot ? '' : NO_DOT;
	  const qmarkNoDot = opts.dot ? QMARK : QMARK_NO_DOT;
	  let star = opts.bash === true ? globstar(opts) : STAR;
	  if (opts.capture) {
	    star = `(${star})`;
	  }
	  if (typeof opts.noext === 'boolean') {
	    opts.noextglob = opts.noext;
	  }
	  const state = {
	    input,
	    index: -1,
	    start: 0,
	    dot: opts.dot === true,
	    consumed: '',
	    output: '',
	    prefix: '',
	    backtrack: false,
	    negated: false,
	    brackets: 0,
	    braces: 0,
	    parens: 0,
	    quotes: 0,
	    globstar: false,
	    tokens
	  };
	  input = utils.removePrefix(input, state);
	  len = input.length;
	  const extglobs = [];
	  const braces = [];
	  const stack = [];
	  let prev = bos;
	  let value;
	  const eos = () => state.index === len - 1;
	  const peek = state.peek = (n = 1) => input[state.index + n];
	  const advance = state.advance = () => input[++state.index] || '';
	  const remaining = () => input.slice(state.index + 1);
	  const consume = (value = '', num = 0) => {
	    state.consumed += value;
	    state.index += num;
	  };
	  const append = token => {
	    state.output += token.output != null ? token.output : token.value;
	    consume(token.value);
	  };
	  const negate = () => {
	    let count = 1;
	    while (peek() === '!' && (peek(2) !== '(' || peek(3) === '?')) {
	      advance();
	      state.start++;
	      count++;
	    }
	    if (count % 2 === 0) {
	      return false;
	    }
	    state.negated = true;
	    state.start++;
	    return true;
	  };
	  const increment = type => {
	    state[type]++;
	    stack.push(type);
	  };
	  const decrement = type => {
	    state[type]--;
	    stack.pop();
	  };
	  const push = tok => {
	    if (prev.type === 'globstar') {
	      const isBrace = state.braces > 0 && (tok.type === 'comma' || tok.type === 'brace');
	      const isExtglob = tok.extglob === true || (extglobs.length && (tok.type === 'pipe' || tok.type === 'paren'));
	      if (tok.type !== 'slash' && tok.type !== 'paren' && !isBrace && !isExtglob) {
	        state.output = state.output.slice(0, -prev.output.length);
	        prev.type = 'star';
	        prev.value = '*';
	        prev.output = star;
	        state.output += prev.output;
	      }
	    }
	    if (extglobs.length && tok.type !== 'paren') {
	      extglobs[extglobs.length - 1].inner += tok.value;
	    }
	    if (tok.value || tok.output) append(tok);
	    if (prev && prev.type === 'text' && tok.type === 'text') {
	      prev.value += tok.value;
	      prev.output = (prev.output || '') + tok.value;
	      return;
	    }
	    tok.prev = prev;
	    tokens.push(tok);
	    prev = tok;
	  };
	  const extglobOpen = (type, value) => {
	    const token = { ...EXTGLOB_CHARS[value], conditions: 1, inner: '' };
	    token.prev = prev;
	    token.parens = state.parens;
	    token.output = state.output;
	    const output = (opts.capture ? '(' : '') + token.open;
	    increment('parens');
	    push({ type, value, output: state.output ? '' : ONE_CHAR });
	    push({ type: 'paren', extglob: true, value: advance(), output });
	    extglobs.push(token);
	  };
	  const extglobClose = token => {
	    let output = token.close + (opts.capture ? ')' : '');
	    let rest;
	    if (token.type === 'negate') {
	      let extglobStar = star;
	      if (token.inner && token.inner.length > 1 && token.inner.includes('/')) {
	        extglobStar = globstar(opts);
	      }
	      if (extglobStar !== star || eos() || /^\)+$/.test(remaining())) {
	        output = token.close = `)$))${extglobStar}`;
	      }
	      if (token.inner.includes('*') && (rest = remaining()) && /^\.[^\\/.]+$/.test(rest)) {
	        const expression = parse(rest, { ...options, fastpaths: false }).output;
	        output = token.close = `)${expression})${extglobStar})`;
	      }
	      if (token.prev.type === 'bos') {
	        state.negatedExtglob = true;
	      }
	    }
	    push({ type: 'paren', extglob: true, value, output });
	    decrement('parens');
	  };
	  if (opts.fastpaths !== false && !/(^[*!]|[/()[\]{}"])/.test(input)) {
	    let backslashes = false;
	    let output = input.replace(REGEX_SPECIAL_CHARS_BACKREF, (m, esc, chars, first, rest, index) => {
	      if (first === '\\') {
	        backslashes = true;
	        return m;
	      }
	      if (first === '?') {
	        if (esc) {
	          return esc + first + (rest ? QMARK.repeat(rest.length) : '');
	        }
	        if (index === 0) {
	          return qmarkNoDot + (rest ? QMARK.repeat(rest.length) : '');
	        }
	        return QMARK.repeat(chars.length);
	      }
	      if (first === '.') {
	        return DOT_LITERAL.repeat(chars.length);
	      }
	      if (first === '*') {
	        if (esc) {
	          return esc + first + (rest ? star : '');
	        }
	        return star;
	      }
	      return esc ? m : `\\${m}`;
	    });
	    if (backslashes === true) {
	      if (opts.unescape === true) {
	        output = output.replace(/\\/g, '');
	      } else {
	        output = output.replace(/\\+/g, m => {
	          return m.length % 2 === 0 ? '\\\\' : (m ? '\\' : '');
	        });
	      }
	    }
	    if (output === input && opts.contains === true) {
	      state.output = input;
	      return state;
	    }
	    state.output = utils.wrapOutput(output, state, options);
	    return state;
	  }
	  while (!eos()) {
	    value = advance();
	    if (value === '\u0000') {
	      continue;
	    }
	    if (value === '\\') {
	      const next = peek();
	      if (next === '/' && opts.bash !== true) {
	        continue;
	      }
	      if (next === '.' || next === ';') {
	        continue;
	      }
	      if (!next) {
	        value += '\\';
	        push({ type: 'text', value });
	        continue;
	      }
	      const match = /^\\+/.exec(remaining());
	      let slashes = 0;
	      if (match && match[0].length > 2) {
	        slashes = match[0].length;
	        state.index += slashes;
	        if (slashes % 2 !== 0) {
	          value += '\\';
	        }
	      }
	      if (opts.unescape === true) {
	        value = advance();
	      } else {
	        value += advance();
	      }
	      if (state.brackets === 0) {
	        push({ type: 'text', value });
	        continue;
	      }
	    }
	    if (state.brackets > 0 && (value !== ']' || prev.value === '[' || prev.value === '[^')) {
	      if (opts.posix !== false && value === ':') {
	        const inner = prev.value.slice(1);
	        if (inner.includes('[')) {
	          prev.posix = true;
	          if (inner.includes(':')) {
	            const idx = prev.value.lastIndexOf('[');
	            const pre = prev.value.slice(0, idx);
	            const rest = prev.value.slice(idx + 2);
	            const posix = POSIX_REGEX_SOURCE[rest];
	            if (posix) {
	              prev.value = pre + posix;
	              state.backtrack = true;
	              advance();
	              if (!bos.output && tokens.indexOf(prev) === 1) {
	                bos.output = ONE_CHAR;
	              }
	              continue;
	            }
	          }
	        }
	      }
	      if ((value === '[' && peek() !== ':') || (value === '-' && peek() === ']')) {
	        value = `\\${value}`;
	      }
	      if (value === ']' && (prev.value === '[' || prev.value === '[^')) {
	        value = `\\${value}`;
	      }
	      if (opts.posix === true && value === '!' && prev.value === '[') {
	        value = '^';
	      }
	      prev.value += value;
	      append({ value });
	      continue;
	    }
	    if (state.quotes === 1 && value !== '"') {
	      value = utils.escapeRegex(value);
	      prev.value += value;
	      append({ value });
	      continue;
	    }
	    if (value === '"') {
	      state.quotes = state.quotes === 1 ? 0 : 1;
	      if (opts.keepQuotes === true) {
	        push({ type: 'text', value });
	      }
	      continue;
	    }
	    if (value === '(') {
	      increment('parens');
	      push({ type: 'paren', value });
	      continue;
	    }
	    if (value === ')') {
	      if (state.parens === 0 && opts.strictBrackets === true) {
	        throw new SyntaxError(syntaxError('opening', '('));
	      }
	      const extglob = extglobs[extglobs.length - 1];
	      if (extglob && state.parens === extglob.parens + 1) {
	        extglobClose(extglobs.pop());
	        continue;
	      }
	      push({ type: 'paren', value, output: state.parens ? ')' : '\\)' });
	      decrement('parens');
	      continue;
	    }
	    if (value === '[') {
	      if (opts.nobracket === true || !remaining().includes(']')) {
	        if (opts.nobracket !== true && opts.strictBrackets === true) {
	          throw new SyntaxError(syntaxError('closing', ']'));
	        }
	        value = `\\${value}`;
	      } else {
	        increment('brackets');
	      }
	      push({ type: 'bracket', value });
	      continue;
	    }
	    if (value === ']') {
	      if (opts.nobracket === true || (prev && prev.type === 'bracket' && prev.value.length === 1)) {
	        push({ type: 'text', value, output: `\\${value}` });
	        continue;
	      }
	      if (state.brackets === 0) {
	        if (opts.strictBrackets === true) {
	          throw new SyntaxError(syntaxError('opening', '['));
	        }
	        push({ type: 'text', value, output: `\\${value}` });
	        continue;
	      }
	      decrement('brackets');
	      const prevValue = prev.value.slice(1);
	      if (prev.posix !== true && prevValue[0] === '^' && !prevValue.includes('/')) {
	        value = `/${value}`;
	      }
	      prev.value += value;
	      append({ value });
	      if (opts.literalBrackets === false || utils.hasRegexChars(prevValue)) {
	        continue;
	      }
	      const escaped = utils.escapeRegex(prev.value);
	      state.output = state.output.slice(0, -prev.value.length);
	      if (opts.literalBrackets === true) {
	        state.output += escaped;
	        prev.value = escaped;
	        continue;
	      }
	      prev.value = `(${capture}${escaped}|${prev.value})`;
	      state.output += prev.value;
	      continue;
	    }
	    if (value === '{' && opts.nobrace !== true) {
	      increment('braces');
	      const open = {
	        type: 'brace',
	        value,
	        output: '(',
	        outputIndex: state.output.length,
	        tokensIndex: state.tokens.length
	      };
	      braces.push(open);
	      push(open);
	      continue;
	    }
	    if (value === '}') {
	      const brace = braces[braces.length - 1];
	      if (opts.nobrace === true || !brace) {
	        push({ type: 'text', value, output: value });
	        continue;
	      }
	      let output = ')';
	      if (brace.dots === true) {
	        const arr = tokens.slice();
	        const range = [];
	        for (let i = arr.length - 1; i >= 0; i--) {
	          tokens.pop();
	          if (arr[i].type === 'brace') {
	            break;
	          }
	          if (arr[i].type !== 'dots') {
	            range.unshift(arr[i].value);
	          }
	        }
	        output = expandRange(range, opts);
	        state.backtrack = true;
	      }
	      if (brace.comma !== true && brace.dots !== true) {
	        const out = state.output.slice(0, brace.outputIndex);
	        const toks = state.tokens.slice(brace.tokensIndex);
	        brace.value = brace.output = '\\{';
	        value = output = '\\}';
	        state.output = out;
	        for (const t of toks) {
	          state.output += (t.output || t.value);
	        }
	      }
	      push({ type: 'brace', value, output });
	      decrement('braces');
	      braces.pop();
	      continue;
	    }
	    if (value === '|') {
	      if (extglobs.length > 0) {
	        extglobs[extglobs.length - 1].conditions++;
	      }
	      push({ type: 'text', value });
	      continue;
	    }
	    if (value === ',') {
	      let output = value;
	      const brace = braces[braces.length - 1];
	      if (brace && stack[stack.length - 1] === 'braces') {
	        brace.comma = true;
	        output = '|';
	      }
	      push({ type: 'comma', value, output });
	      continue;
	    }
	    if (value === '/') {
	      if (prev.type === 'dot' && state.index === state.start + 1) {
	        state.start = state.index + 1;
	        state.consumed = '';
	        state.output = '';
	        tokens.pop();
	        prev = bos;
	        continue;
	      }
	      push({ type: 'slash', value, output: SLASH_LITERAL });
	      continue;
	    }
	    if (value === '.') {
	      if (state.braces > 0 && prev.type === 'dot') {
	        if (prev.value === '.') prev.output = DOT_LITERAL;
	        const brace = braces[braces.length - 1];
	        prev.type = 'dots';
	        prev.output += value;
	        prev.value += value;
	        brace.dots = true;
	        continue;
	      }
	      if ((state.braces + state.parens) === 0 && prev.type !== 'bos' && prev.type !== 'slash') {
	        push({ type: 'text', value, output: DOT_LITERAL });
	        continue;
	      }
	      push({ type: 'dot', value, output: DOT_LITERAL });
	      continue;
	    }
	    if (value === '?') {
	      const isGroup = prev && prev.value === '(';
	      if (!isGroup && opts.noextglob !== true && peek() === '(' && peek(2) !== '?') {
	        extglobOpen('qmark', value);
	        continue;
	      }
	      if (prev && prev.type === 'paren') {
	        const next = peek();
	        let output = value;
	        if (next === '<' && !utils.supportsLookbehinds()) {
	          throw new Error('Node.js v10 or higher is required for regex lookbehinds');
	        }
	        if ((prev.value === '(' && !/[!=<:]/.test(next)) || (next === '<' && !/<([!=]|\w+>)/.test(remaining()))) {
	          output = `\\${value}`;
	        }
	        push({ type: 'text', value, output });
	        continue;
	      }
	      if (opts.dot !== true && (prev.type === 'slash' || prev.type === 'bos')) {
	        push({ type: 'qmark', value, output: QMARK_NO_DOT });
	        continue;
	      }
	      push({ type: 'qmark', value, output: QMARK });
	      continue;
	    }
	    if (value === '!') {
	      if (opts.noextglob !== true && peek() === '(') {
	        if (peek(2) !== '?' || !/[!=<:]/.test(peek(3))) {
	          extglobOpen('negate', value);
	          continue;
	        }
	      }
	      if (opts.nonegate !== true && state.index === 0) {
	        negate();
	        continue;
	      }
	    }
	    if (value === '+') {
	      if (opts.noextglob !== true && peek() === '(' && peek(2) !== '?') {
	        extglobOpen('plus', value);
	        continue;
	      }
	      if ((prev && prev.value === '(') || opts.regex === false) {
	        push({ type: 'plus', value, output: PLUS_LITERAL });
	        continue;
	      }
	      if ((prev && (prev.type === 'bracket' || prev.type === 'paren' || prev.type === 'brace')) || state.parens > 0) {
	        push({ type: 'plus', value });
	        continue;
	      }
	      push({ type: 'plus', value: PLUS_LITERAL });
	      continue;
	    }
	    if (value === '@') {
	      if (opts.noextglob !== true && peek() === '(' && peek(2) !== '?') {
	        push({ type: 'at', extglob: true, value, output: '' });
	        continue;
	      }
	      push({ type: 'text', value });
	      continue;
	    }
	    if (value !== '*') {
	      if (value === '$' || value === '^') {
	        value = `\\${value}`;
	      }
	      const match = REGEX_NON_SPECIAL_CHARS.exec(remaining());
	      if (match) {
	        value += match[0];
	        state.index += match[0].length;
	      }
	      push({ type: 'text', value });
	      continue;
	    }
	    if (prev && (prev.type === 'globstar' || prev.star === true)) {
	      prev.type = 'star';
	      prev.star = true;
	      prev.value += value;
	      prev.output = star;
	      state.backtrack = true;
	      state.globstar = true;
	      consume(value);
	      continue;
	    }
	    let rest = remaining();
	    if (opts.noextglob !== true && /^\([^?]/.test(rest)) {
	      extglobOpen('star', value);
	      continue;
	    }
	    if (prev.type === 'star') {
	      if (opts.noglobstar === true) {
	        consume(value);
	        continue;
	      }
	      const prior = prev.prev;
	      const before = prior.prev;
	      const isStart = prior.type === 'slash' || prior.type === 'bos';
	      const afterStar = before && (before.type === 'star' || before.type === 'globstar');
	      if (opts.bash === true && (!isStart || (rest[0] && rest[0] !== '/'))) {
	        push({ type: 'star', value, output: '' });
	        continue;
	      }
	      const isBrace = state.braces > 0 && (prior.type === 'comma' || prior.type === 'brace');
	      const isExtglob = extglobs.length && (prior.type === 'pipe' || prior.type === 'paren');
	      if (!isStart && prior.type !== 'paren' && !isBrace && !isExtglob) {
	        push({ type: 'star', value, output: '' });
	        continue;
	      }
	      while (rest.slice(0, 3) === '/**') {
	        const after = input[state.index + 4];
	        if (after && after !== '/') {
	          break;
	        }
	        rest = rest.slice(3);
	        consume('/**', 3);
	      }
	      if (prior.type === 'bos' && eos()) {
	        prev.type = 'globstar';
	        prev.value += value;
	        prev.output = globstar(opts);
	        state.output = prev.output;
	        state.globstar = true;
	        consume(value);
	        continue;
	      }
	      if (prior.type === 'slash' && prior.prev.type !== 'bos' && !afterStar && eos()) {
	        state.output = state.output.slice(0, -(prior.output + prev.output).length);
	        prior.output = `(?:${prior.output}`;
	        prev.type = 'globstar';
	        prev.output = globstar(opts) + (opts.strictSlashes ? ')' : '|$)');
	        prev.value += value;
	        state.globstar = true;
	        state.output += prior.output + prev.output;
	        consume(value);
	        continue;
	      }
	      if (prior.type === 'slash' && prior.prev.type !== 'bos' && rest[0] === '/') {
	        const end = rest[1] !== void 0 ? '|$' : '';
	        state.output = state.output.slice(0, -(prior.output + prev.output).length);
	        prior.output = `(?:${prior.output}`;
	        prev.type = 'globstar';
	        prev.output = `${globstar(opts)}${SLASH_LITERAL}|${SLASH_LITERAL}${end})`;
	        prev.value += value;
	        state.output += prior.output + prev.output;
	        state.globstar = true;
	        consume(value + advance());
	        push({ type: 'slash', value: '/', output: '' });
	        continue;
	      }
	      if (prior.type === 'bos' && rest[0] === '/') {
	        prev.type = 'globstar';
	        prev.value += value;
	        prev.output = `(?:^|${SLASH_LITERAL}|${globstar(opts)}${SLASH_LITERAL})`;
	        state.output = prev.output;
	        state.globstar = true;
	        consume(value + advance());
	        push({ type: 'slash', value: '/', output: '' });
	        continue;
	      }
	      state.output = state.output.slice(0, -prev.output.length);
	      prev.type = 'globstar';
	      prev.output = globstar(opts);
	      prev.value += value;
	      state.output += prev.output;
	      state.globstar = true;
	      consume(value);
	      continue;
	    }
	    const token = { type: 'star', value, output: star };
	    if (opts.bash === true) {
	      token.output = '.*?';
	      if (prev.type === 'bos' || prev.type === 'slash') {
	        token.output = nodot + token.output;
	      }
	      push(token);
	      continue;
	    }
	    if (prev && (prev.type === 'bracket' || prev.type === 'paren') && opts.regex === true) {
	      token.output = value;
	      push(token);
	      continue;
	    }
	    if (state.index === state.start || prev.type === 'slash' || prev.type === 'dot') {
	      if (prev.type === 'dot') {
	        state.output += NO_DOT_SLASH;
	        prev.output += NO_DOT_SLASH;
	      } else if (opts.dot === true) {
	        state.output += NO_DOTS_SLASH;
	        prev.output += NO_DOTS_SLASH;
	      } else {
	        state.output += nodot;
	        prev.output += nodot;
	      }
	      if (peek() !== '*') {
	        state.output += ONE_CHAR;
	        prev.output += ONE_CHAR;
	      }
	    }
	    push(token);
	  }
	  while (state.brackets > 0) {
	    if (opts.strictBrackets === true) throw new SyntaxError(syntaxError('closing', ']'));
	    state.output = utils.escapeLast(state.output, '[');
	    decrement('brackets');
	  }
	  while (state.parens > 0) {
	    if (opts.strictBrackets === true) throw new SyntaxError(syntaxError('closing', ')'));
	    state.output = utils.escapeLast(state.output, '(');
	    decrement('parens');
	  }
	  while (state.braces > 0) {
	    if (opts.strictBrackets === true) throw new SyntaxError(syntaxError('closing', '}'));
	    state.output = utils.escapeLast(state.output, '{');
	    decrement('braces');
	  }
	  if (opts.strictSlashes !== true && (prev.type === 'star' || prev.type === 'bracket')) {
	    push({ type: 'maybe_slash', value: '', output: `${SLASH_LITERAL}?` });
	  }
	  if (state.backtrack === true) {
	    state.output = '';
	    for (const token of state.tokens) {
	      state.output += token.output != null ? token.output : token.value;
	      if (token.suffix) {
	        state.output += token.suffix;
	      }
	    }
	  }
	  return state;
	};
	parse.fastpaths = (input, options) => {
	  const opts = { ...options };
	  const max = typeof opts.maxLength === 'number' ? Math.min(MAX_LENGTH, opts.maxLength) : MAX_LENGTH;
	  const len = input.length;
	  if (len > max) {
	    throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
	  }
	  input = REPLACEMENTS[input] || input;
	  const win32 = utils.isWindows(options);
	  const {
	    DOT_LITERAL,
	    SLASH_LITERAL,
	    ONE_CHAR,
	    DOTS_SLASH,
	    NO_DOT,
	    NO_DOTS,
	    NO_DOTS_SLASH,
	    STAR,
	    START_ANCHOR
	  } = constants.globChars(win32);
	  const nodot = opts.dot ? NO_DOTS : NO_DOT;
	  const slashDot = opts.dot ? NO_DOTS_SLASH : NO_DOT;
	  const capture = opts.capture ? '' : '?:';
	  const state = { negated: false, prefix: '' };
	  let star = opts.bash === true ? '.*?' : STAR;
	  if (opts.capture) {
	    star = `(${star})`;
	  }
	  const globstar = opts => {
	    if (opts.noglobstar === true) return star;
	    return `(${capture}(?:(?!${START_ANCHOR}${opts.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
	  };
	  const create = str => {
	    switch (str) {
	      case '*':
	        return `${nodot}${ONE_CHAR}${star}`;
	      case '.*':
	        return `${DOT_LITERAL}${ONE_CHAR}${star}`;
	      case '*.*':
	        return `${nodot}${star}${DOT_LITERAL}${ONE_CHAR}${star}`;
	      case '*/*':
	        return `${nodot}${star}${SLASH_LITERAL}${ONE_CHAR}${slashDot}${star}`;
	      case '**':
	        return nodot + globstar(opts);
	      case '**/*':
	        return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${slashDot}${ONE_CHAR}${star}`;
	      case '**/*.*':
	        return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${slashDot}${star}${DOT_LITERAL}${ONE_CHAR}${star}`;
	      case '**/.*':
	        return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${DOT_LITERAL}${ONE_CHAR}${star}`;
	      default: {
	        const match = /^(.*?)\.(\w+)$/.exec(str);
	        if (!match) return;
	        const source = create(match[1]);
	        if (!source) return;
	        return source + DOT_LITERAL + match[2];
	      }
	    }
	  };
	  const output = utils.removePrefix(input, state);
	  let source = create(output);
	  if (source && opts.strictSlashes !== true) {
	    source += `${SLASH_LITERAL}?`;
	  }
	  return source;
	};
	parse_1 = parse;
	return parse_1;
}

var picomatch_1;
var hasRequiredPicomatch$1;
function requirePicomatch$1 () {
	if (hasRequiredPicomatch$1) return picomatch_1;
	hasRequiredPicomatch$1 = 1;
	const path = path$1;
	const scan = requireScan();
	const parse = requireParse();
	const utils = requireUtils$2();
	const constants = requireConstants();
	const isObject = val => val && typeof val === 'object' && !Array.isArray(val);
	const picomatch = (glob, options, returnState = false) => {
	  if (Array.isArray(glob)) {
	    const fns = glob.map(input => picomatch(input, options, returnState));
	    const arrayMatcher = str => {
	      for (const isMatch of fns) {
	        const state = isMatch(str);
	        if (state) return state;
	      }
	      return false;
	    };
	    return arrayMatcher;
	  }
	  const isState = isObject(glob) && glob.tokens && glob.input;
	  if (glob === '' || (typeof glob !== 'string' && !isState)) {
	    throw new TypeError('Expected pattern to be a non-empty string');
	  }
	  const opts = options || {};
	  const posix = utils.isWindows(options);
	  const regex = isState
	    ? picomatch.compileRe(glob, options)
	    : picomatch.makeRe(glob, options, false, true);
	  const state = regex.state;
	  delete regex.state;
	  let isIgnored = () => false;
	  if (opts.ignore) {
	    const ignoreOpts = { ...options, ignore: null, onMatch: null, onResult: null };
	    isIgnored = picomatch(opts.ignore, ignoreOpts, returnState);
	  }
	  const matcher = (input, returnObject = false) => {
	    const { isMatch, match, output } = picomatch.test(input, regex, options, { glob, posix });
	    const result = { glob, state, regex, posix, input, output, match, isMatch };
	    if (typeof opts.onResult === 'function') {
	      opts.onResult(result);
	    }
	    if (isMatch === false) {
	      result.isMatch = false;
	      return returnObject ? result : false;
	    }
	    if (isIgnored(input)) {
	      if (typeof opts.onIgnore === 'function') {
	        opts.onIgnore(result);
	      }
	      result.isMatch = false;
	      return returnObject ? result : false;
	    }
	    if (typeof opts.onMatch === 'function') {
	      opts.onMatch(result);
	    }
	    return returnObject ? result : true;
	  };
	  if (returnState) {
	    matcher.state = state;
	  }
	  return matcher;
	};
	picomatch.test = (input, regex, options, { glob, posix } = {}) => {
	  if (typeof input !== 'string') {
	    throw new TypeError('Expected input to be a string');
	  }
	  if (input === '') {
	    return { isMatch: false, output: '' };
	  }
	  const opts = options || {};
	  const format = opts.format || (posix ? utils.toPosixSlashes : null);
	  let match = input === glob;
	  let output = (match && format) ? format(input) : input;
	  if (match === false) {
	    output = format ? format(input) : input;
	    match = output === glob;
	  }
	  if (match === false || opts.capture === true) {
	    if (opts.matchBase === true || opts.basename === true) {
	      match = picomatch.matchBase(input, regex, options, posix);
	    } else {
	      match = regex.exec(output);
	    }
	  }
	  return { isMatch: Boolean(match), match, output };
	};
	picomatch.matchBase = (input, glob, options, posix = utils.isWindows(options)) => {
	  const regex = glob instanceof RegExp ? glob : picomatch.makeRe(glob, options);
	  return regex.test(path.basename(input));
	};
	picomatch.isMatch = (str, patterns, options) => picomatch(patterns, options)(str);
	picomatch.parse = (pattern, options) => {
	  if (Array.isArray(pattern)) return pattern.map(p => picomatch.parse(p, options));
	  return parse(pattern, { ...options, fastpaths: false });
	};
	picomatch.scan = (input, options) => scan(input, options);
	picomatch.compileRe = (state, options, returnOutput = false, returnState = false) => {
	  if (returnOutput === true) {
	    return state.output;
	  }
	  const opts = options || {};
	  const prepend = opts.contains ? '' : '^';
	  const append = opts.contains ? '' : '$';
	  let source = `${prepend}(?:${state.output})${append}`;
	  if (state && state.negated === true) {
	    source = `^(?!${source}).*$`;
	  }
	  const regex = picomatch.toRegex(source, options);
	  if (returnState === true) {
	    regex.state = state;
	  }
	  return regex;
	};
	picomatch.makeRe = (input, options = {}, returnOutput = false, returnState = false) => {
	  if (!input || typeof input !== 'string') {
	    throw new TypeError('Expected a non-empty string');
	  }
	  let parsed = { negated: false, fastpaths: true };
	  if (options.fastpaths !== false && (input[0] === '.' || input[0] === '*')) {
	    parsed.output = parse.fastpaths(input, options);
	  }
	  if (!parsed.output) {
	    parsed = parse(input, options);
	  }
	  return picomatch.compileRe(parsed, options, returnOutput, returnState);
	};
	picomatch.toRegex = (source, options) => {
	  try {
	    const opts = options || {};
	    return new RegExp(source, opts.flags || (opts.nocase ? 'i' : ''));
	  } catch (err) {
	    if (options && options.debug === true) throw err;
	    return /$^/;
	  }
	};
	picomatch.constants = constants;
	picomatch_1 = picomatch;
	return picomatch_1;
}

var picomatch;
var hasRequiredPicomatch;
function requirePicomatch () {
	if (hasRequiredPicomatch) return picomatch;
	hasRequiredPicomatch = 1;
	picomatch = requirePicomatch$1();
	return picomatch;
}

Object.defineProperty(builder, "__esModule", { value: true });
builder.Builder = void 0;
const path_1$e = path$1;
const api_builder_1 = apiBuilder;
var pm = null;
try {
    require.resolve("picomatch");
    pm = requirePicomatch();
}
catch (_e) {
}
class Builder {
    globCache = {};
    options = {
        maxDepth: Infinity,
        suppressErrors: true,
        pathSeparator: path_1$e.sep,
        filters: [],
    };
    constructor(options) {
        this.options = { ...this.options, ...options };
    }
    group() {
        this.options.group = true;
        return this;
    }
    withPathSeparator(separator) {
        this.options.pathSeparator = separator;
        return this;
    }
    withBasePath() {
        this.options.includeBasePath = true;
        return this;
    }
    withRelativePaths() {
        this.options.relativePaths = true;
        return this;
    }
    withDirs() {
        this.options.includeDirs = true;
        return this;
    }
    withMaxDepth(depth) {
        this.options.maxDepth = depth;
        return this;
    }
    withMaxFiles(limit) {
        this.options.maxFiles = limit;
        return this;
    }
    withFullPaths() {
        this.options.resolvePaths = true;
        this.options.includeBasePath = true;
        return this;
    }
    withErrors() {
        this.options.suppressErrors = false;
        return this;
    }
    withSymlinks() {
        this.options.resolveSymlinks = true;
        return this.withFullPaths();
    }
    withAbortSignal(signal) {
        this.options.signal = signal;
        return this;
    }
    normalize() {
        this.options.normalizePath = true;
        return this;
    }
    filter(predicate) {
        this.options.filters.push(predicate);
        return this;
    }
    onlyDirs() {
        this.options.excludeFiles = true;
        this.options.includeDirs = true;
        return this;
    }
    exclude(predicate) {
        this.options.exclude = predicate;
        return this;
    }
    onlyCounts() {
        this.options.onlyCounts = true;
        return this;
    }
    crawl(root) {
        return new api_builder_1.APIBuilder(root || ".", this.options);
    }
    crawlWithOptions(root, options) {
        this.options = { ...this.options, ...options };
        return new api_builder_1.APIBuilder(root || ".", this.options);
    }
    glob(...patterns) {
        return this.globWithOptions(patterns, { dot: true });
    }
    globWithOptions(patterns, options) {
        if (!pm) {
            throw new Error(`Please install picomatch: "npm i picomatch" to use glob matching.`);
        }
        var isMatch = this.globCache[patterns.join("\0")];
        if (!isMatch) {
            isMatch = pm(patterns, options);
            this.globCache[patterns.join("\0")] = isMatch;
        }
        this.options.filters.push((path) => isMatch(path));
        return this;
    }
}
builder.Builder = Builder;

var src$1 = {};

var types = {};

Object.defineProperty(types, "__esModule", { value: true });

(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    var desc = Object.getOwnPropertyDescriptor(m, k);
	    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	      desc = { enumerable: true, get: function() { return m[k]; } };
	    }
	    Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	__exportStar(types, exports);
} (src$1));
getDefaultExportFromCjs(src$1);

(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    var desc = Object.getOwnPropertyDescriptor(m, k);
	    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	      desc = { enumerable: true, get: function() { return m[k]; } };
	    }
	    Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.fdir = void 0;
	const builder_1 = builder;
	Object.defineProperty(exports, "fdir", { enumerable: true, get: function () { return builder_1.Builder; } });
	__exportStar(src$1, exports);
} (dist));
getDefaultExportFromCjs(dist);

var src = {};

var server$1 = {};

var main$8 = {};

var is$4 = {};

Object.defineProperty(is$4, "__esModule", { value: true });
is$4.thenable = is$4.typedArray = is$4.stringArray = is$4.array = is$4.func = is$4.error = is$4.number = is$4.string = is$4.boolean = void 0;
function boolean$2(value) {
    return value === true || value === false;
}
is$4.boolean = boolean$2;
function string$2(value) {
    return typeof value === 'string' || value instanceof String;
}
is$4.string = string$2;
function number$2(value) {
    return typeof value === 'number' || value instanceof Number;
}
is$4.number = number$2;
function error$4(value) {
    return value instanceof Error;
}
is$4.error = error$4;
function func$2(value) {
    return typeof value === 'function';
}
is$4.func = func$2;
function array$2(value) {
    return Array.isArray(value);
}
is$4.array = array$2;
function stringArray$2(value) {
    return array$2(value) && value.every(elem => string$2(elem));
}
is$4.stringArray = stringArray$2;
function typedArray$2(value, check) {
    return Array.isArray(value) && value.every(check);
}
is$4.typedArray = typedArray$2;
function thenable(value) {
    return value && func$2(value.then);
}
is$4.thenable = thenable;

var server = {};

var main$7 = {};

var main$6 = {};

var ril$1 = {};

var api$4 = {};

var messages$3 = {};

var is$3 = {};

var hasRequiredIs$1;
function requireIs$1 () {
	if (hasRequiredIs$1) return is$3;
	hasRequiredIs$1 = 1;
	Object.defineProperty(is$3, "__esModule", { value: true });
	is$3.stringArray = is$3.array = is$3.func = is$3.error = is$3.number = is$3.string = is$3.boolean = void 0;
	function boolean(value) {
	    return value === true || value === false;
	}
	is$3.boolean = boolean;
	function string(value) {
	    return typeof value === 'string' || value instanceof String;
	}
	is$3.string = string;
	function number(value) {
	    return typeof value === 'number' || value instanceof Number;
	}
	is$3.number = number;
	function error(value) {
	    return value instanceof Error;
	}
	is$3.error = error;
	function func(value) {
	    return typeof value === 'function';
	}
	is$3.func = func;
	function array(value) {
	    return Array.isArray(value);
	}
	is$3.array = array;
	function stringArray(value) {
	    return array(value) && value.every(elem => string(elem));
	}
	is$3.stringArray = stringArray;
	return is$3;
}

var hasRequiredMessages$1;
function requireMessages$1 () {
	if (hasRequiredMessages$1) return messages$3;
	hasRequiredMessages$1 = 1;
	Object.defineProperty(messages$3, "__esModule", { value: true });
	messages$3.Message = messages$3.NotificationType9 = messages$3.NotificationType8 = messages$3.NotificationType7 = messages$3.NotificationType6 = messages$3.NotificationType5 = messages$3.NotificationType4 = messages$3.NotificationType3 = messages$3.NotificationType2 = messages$3.NotificationType1 = messages$3.NotificationType0 = messages$3.NotificationType = messages$3.RequestType9 = messages$3.RequestType8 = messages$3.RequestType7 = messages$3.RequestType6 = messages$3.RequestType5 = messages$3.RequestType4 = messages$3.RequestType3 = messages$3.RequestType2 = messages$3.RequestType1 = messages$3.RequestType = messages$3.RequestType0 = messages$3.AbstractMessageSignature = messages$3.ParameterStructures = messages$3.ResponseError = messages$3.ErrorCodes = void 0;
	const is = requireIs$1();
	var ErrorCodes;
	(function (ErrorCodes) {
	    ErrorCodes.ParseError = -32700;
	    ErrorCodes.InvalidRequest = -32600;
	    ErrorCodes.MethodNotFound = -32601;
	    ErrorCodes.InvalidParams = -32602;
	    ErrorCodes.InternalError = -32603;
	    ErrorCodes.jsonrpcReservedErrorRangeStart = -32099;
	    ErrorCodes.serverErrorStart = -32099;
	    ErrorCodes.MessageWriteError = -32099;
	    ErrorCodes.MessageReadError = -32098;
	    ErrorCodes.PendingResponseRejected = -32097;
	    ErrorCodes.ConnectionInactive = -32096;
	    ErrorCodes.ServerNotInitialized = -32002;
	    ErrorCodes.UnknownErrorCode = -32001;
	    ErrorCodes.jsonrpcReservedErrorRangeEnd = -32000;
	    ErrorCodes.serverErrorEnd = -32000;
	})(ErrorCodes || (messages$3.ErrorCodes = ErrorCodes = {}));
	class ResponseError extends Error {
	    constructor(code, message, data) {
	        super(message);
	        this.code = is.number(code) ? code : ErrorCodes.UnknownErrorCode;
	        this.data = data;
	        Object.setPrototypeOf(this, ResponseError.prototype);
	    }
	    toJson() {
	        const result = {
	            code: this.code,
	            message: this.message
	        };
	        if (this.data !== undefined) {
	            result.data = this.data;
	        }
	        return result;
	    }
	}
	messages$3.ResponseError = ResponseError;
	class ParameterStructures {
	    constructor(kind) {
	        this.kind = kind;
	    }
	    static is(value) {
	        return value === ParameterStructures.auto || value === ParameterStructures.byName || value === ParameterStructures.byPosition;
	    }
	    toString() {
	        return this.kind;
	    }
	}
	messages$3.ParameterStructures = ParameterStructures;
	ParameterStructures.auto = new ParameterStructures('auto');
	ParameterStructures.byPosition = new ParameterStructures('byPosition');
	ParameterStructures.byName = new ParameterStructures('byName');
	class AbstractMessageSignature {
	    constructor(method, numberOfParams) {
	        this.method = method;
	        this.numberOfParams = numberOfParams;
	    }
	    get parameterStructures() {
	        return ParameterStructures.auto;
	    }
	}
	messages$3.AbstractMessageSignature = AbstractMessageSignature;
	class RequestType0 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 0);
	    }
	}
	messages$3.RequestType0 = RequestType0;
	class RequestType extends AbstractMessageSignature {
	    constructor(method, _parameterStructures = ParameterStructures.auto) {
	        super(method, 1);
	        this._parameterStructures = _parameterStructures;
	    }
	    get parameterStructures() {
	        return this._parameterStructures;
	    }
	}
	messages$3.RequestType = RequestType;
	class RequestType1 extends AbstractMessageSignature {
	    constructor(method, _parameterStructures = ParameterStructures.auto) {
	        super(method, 1);
	        this._parameterStructures = _parameterStructures;
	    }
	    get parameterStructures() {
	        return this._parameterStructures;
	    }
	}
	messages$3.RequestType1 = RequestType1;
	class RequestType2 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 2);
	    }
	}
	messages$3.RequestType2 = RequestType2;
	class RequestType3 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 3);
	    }
	}
	messages$3.RequestType3 = RequestType3;
	class RequestType4 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 4);
	    }
	}
	messages$3.RequestType4 = RequestType4;
	class RequestType5 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 5);
	    }
	}
	messages$3.RequestType5 = RequestType5;
	class RequestType6 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 6);
	    }
	}
	messages$3.RequestType6 = RequestType6;
	class RequestType7 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 7);
	    }
	}
	messages$3.RequestType7 = RequestType7;
	class RequestType8 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 8);
	    }
	}
	messages$3.RequestType8 = RequestType8;
	class RequestType9 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 9);
	    }
	}
	messages$3.RequestType9 = RequestType9;
	class NotificationType extends AbstractMessageSignature {
	    constructor(method, _parameterStructures = ParameterStructures.auto) {
	        super(method, 1);
	        this._parameterStructures = _parameterStructures;
	    }
	    get parameterStructures() {
	        return this._parameterStructures;
	    }
	}
	messages$3.NotificationType = NotificationType;
	class NotificationType0 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 0);
	    }
	}
	messages$3.NotificationType0 = NotificationType0;
	class NotificationType1 extends AbstractMessageSignature {
	    constructor(method, _parameterStructures = ParameterStructures.auto) {
	        super(method, 1);
	        this._parameterStructures = _parameterStructures;
	    }
	    get parameterStructures() {
	        return this._parameterStructures;
	    }
	}
	messages$3.NotificationType1 = NotificationType1;
	class NotificationType2 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 2);
	    }
	}
	messages$3.NotificationType2 = NotificationType2;
	class NotificationType3 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 3);
	    }
	}
	messages$3.NotificationType3 = NotificationType3;
	class NotificationType4 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 4);
	    }
	}
	messages$3.NotificationType4 = NotificationType4;
	class NotificationType5 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 5);
	    }
	}
	messages$3.NotificationType5 = NotificationType5;
	class NotificationType6 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 6);
	    }
	}
	messages$3.NotificationType6 = NotificationType6;
	class NotificationType7 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 7);
	    }
	}
	messages$3.NotificationType7 = NotificationType7;
	class NotificationType8 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 8);
	    }
	}
	messages$3.NotificationType8 = NotificationType8;
	class NotificationType9 extends AbstractMessageSignature {
	    constructor(method) {
	        super(method, 9);
	    }
	}
	messages$3.NotificationType9 = NotificationType9;
	var Message;
	(function (Message) {
	    function isRequest(message) {
	        const candidate = message;
	        return candidate && is.string(candidate.method) && (is.string(candidate.id) || is.number(candidate.id));
	    }
	    Message.isRequest = isRequest;
	    function isNotification(message) {
	        const candidate = message;
	        return candidate && is.string(candidate.method) && message.id === void 0;
	    }
	    Message.isNotification = isNotification;
	    function isResponse(message) {
	        const candidate = message;
	        return candidate && (candidate.result !== void 0 || !!candidate.error) && (is.string(candidate.id) || is.number(candidate.id) || candidate.id === null);
	    }
	    Message.isResponse = isResponse;
	})(Message || (messages$3.Message = Message = {}));
	return messages$3;
}

var linkedMap$1 = {};

var hasRequiredLinkedMap$1;
function requireLinkedMap$1 () {
	if (hasRequiredLinkedMap$1) return linkedMap$1;
	hasRequiredLinkedMap$1 = 1;
	var _a;
	Object.defineProperty(linkedMap$1, "__esModule", { value: true });
	linkedMap$1.LRUCache = linkedMap$1.LinkedMap = linkedMap$1.Touch = void 0;
	var Touch;
	(function (Touch) {
	    Touch.None = 0;
	    Touch.First = 1;
	    Touch.AsOld = Touch.First;
	    Touch.Last = 2;
	    Touch.AsNew = Touch.Last;
	})(Touch || (linkedMap$1.Touch = Touch = {}));
	class LinkedMap {
	    constructor() {
	        this[_a] = 'LinkedMap';
	        this._map = new Map();
	        this._head = undefined;
	        this._tail = undefined;
	        this._size = 0;
	        this._state = 0;
	    }
	    clear() {
	        this._map.clear();
	        this._head = undefined;
	        this._tail = undefined;
	        this._size = 0;
	        this._state++;
	    }
	    isEmpty() {
	        return !this._head && !this._tail;
	    }
	    get size() {
	        return this._size;
	    }
	    get first() {
	        return this._head?.value;
	    }
	    get last() {
	        return this._tail?.value;
	    }
	    has(key) {
	        return this._map.has(key);
	    }
	    get(key, touch = Touch.None) {
	        const item = this._map.get(key);
	        if (!item) {
	            return undefined;
	        }
	        if (touch !== Touch.None) {
	            this.touch(item, touch);
	        }
	        return item.value;
	    }
	    set(key, value, touch = Touch.None) {
	        let item = this._map.get(key);
	        if (item) {
	            item.value = value;
	            if (touch !== Touch.None) {
	                this.touch(item, touch);
	            }
	        }
	        else {
	            item = { key, value, next: undefined, previous: undefined };
	            switch (touch) {
	                case Touch.None:
	                    this.addItemLast(item);
	                    break;
	                case Touch.First:
	                    this.addItemFirst(item);
	                    break;
	                case Touch.Last:
	                    this.addItemLast(item);
	                    break;
	                default:
	                    this.addItemLast(item);
	                    break;
	            }
	            this._map.set(key, item);
	            this._size++;
	        }
	        return this;
	    }
	    delete(key) {
	        return !!this.remove(key);
	    }
	    remove(key) {
	        const item = this._map.get(key);
	        if (!item) {
	            return undefined;
	        }
	        this._map.delete(key);
	        this.removeItem(item);
	        this._size--;
	        return item.value;
	    }
	    shift() {
	        if (!this._head && !this._tail) {
	            return undefined;
	        }
	        if (!this._head || !this._tail) {
	            throw new Error('Invalid list');
	        }
	        const item = this._head;
	        this._map.delete(item.key);
	        this.removeItem(item);
	        this._size--;
	        return item.value;
	    }
	    forEach(callbackfn, thisArg) {
	        const state = this._state;
	        let current = this._head;
	        while (current) {
	            if (thisArg) {
	                callbackfn.bind(thisArg)(current.value, current.key, this);
	            }
	            else {
	                callbackfn(current.value, current.key, this);
	            }
	            if (this._state !== state) {
	                throw new Error(`LinkedMap got modified during iteration.`);
	            }
	            current = current.next;
	        }
	    }
	    keys() {
	        const state = this._state;
	        let current = this._head;
	        const iterator = {
	            [Symbol.iterator]: () => {
	                return iterator;
	            },
	            next: () => {
	                if (this._state !== state) {
	                    throw new Error(`LinkedMap got modified during iteration.`);
	                }
	                if (current) {
	                    const result = { value: current.key, done: false };
	                    current = current.next;
	                    return result;
	                }
	                else {
	                    return { value: undefined, done: true };
	                }
	            }
	        };
	        return iterator;
	    }
	    values() {
	        const state = this._state;
	        let current = this._head;
	        const iterator = {
	            [Symbol.iterator]: () => {
	                return iterator;
	            },
	            next: () => {
	                if (this._state !== state) {
	                    throw new Error(`LinkedMap got modified during iteration.`);
	                }
	                if (current) {
	                    const result = { value: current.value, done: false };
	                    current = current.next;
	                    return result;
	                }
	                else {
	                    return { value: undefined, done: true };
	                }
	            }
	        };
	        return iterator;
	    }
	    entries() {
	        const state = this._state;
	        let current = this._head;
	        const iterator = {
	            [Symbol.iterator]: () => {
	                return iterator;
	            },
	            next: () => {
	                if (this._state !== state) {
	                    throw new Error(`LinkedMap got modified during iteration.`);
	                }
	                if (current) {
	                    const result = { value: [current.key, current.value], done: false };
	                    current = current.next;
	                    return result;
	                }
	                else {
	                    return { value: undefined, done: true };
	                }
	            }
	        };
	        return iterator;
	    }
	    [(_a = Symbol.toStringTag, Symbol.iterator)]() {
	        return this.entries();
	    }
	    trimOld(newSize) {
	        if (newSize >= this.size) {
	            return;
	        }
	        if (newSize === 0) {
	            this.clear();
	            return;
	        }
	        let current = this._head;
	        let currentSize = this.size;
	        while (current && currentSize > newSize) {
	            this._map.delete(current.key);
	            current = current.next;
	            currentSize--;
	        }
	        this._head = current;
	        this._size = currentSize;
	        if (current) {
	            current.previous = undefined;
	        }
	        this._state++;
	    }
	    addItemFirst(item) {
	        if (!this._head && !this._tail) {
	            this._tail = item;
	        }
	        else if (!this._head) {
	            throw new Error('Invalid list');
	        }
	        else {
	            item.next = this._head;
	            this._head.previous = item;
	        }
	        this._head = item;
	        this._state++;
	    }
	    addItemLast(item) {
	        if (!this._head && !this._tail) {
	            this._head = item;
	        }
	        else if (!this._tail) {
	            throw new Error('Invalid list');
	        }
	        else {
	            item.previous = this._tail;
	            this._tail.next = item;
	        }
	        this._tail = item;
	        this._state++;
	    }
	    removeItem(item) {
	        if (item === this._head && item === this._tail) {
	            this._head = undefined;
	            this._tail = undefined;
	        }
	        else if (item === this._head) {
	            if (!item.next) {
	                throw new Error('Invalid list');
	            }
	            item.next.previous = undefined;
	            this._head = item.next;
	        }
	        else if (item === this._tail) {
	            if (!item.previous) {
	                throw new Error('Invalid list');
	            }
	            item.previous.next = undefined;
	            this._tail = item.previous;
	        }
	        else {
	            const next = item.next;
	            const previous = item.previous;
	            if (!next || !previous) {
	                throw new Error('Invalid list');
	            }
	            next.previous = previous;
	            previous.next = next;
	        }
	        item.next = undefined;
	        item.previous = undefined;
	        this._state++;
	    }
	    touch(item, touch) {
	        if (!this._head || !this._tail) {
	            throw new Error('Invalid list');
	        }
	        if ((touch !== Touch.First && touch !== Touch.Last)) {
	            return;
	        }
	        if (touch === Touch.First) {
	            if (item === this._head) {
	                return;
	            }
	            const next = item.next;
	            const previous = item.previous;
	            if (item === this._tail) {
	                previous.next = undefined;
	                this._tail = previous;
	            }
	            else {
	                next.previous = previous;
	                previous.next = next;
	            }
	            item.previous = undefined;
	            item.next = this._head;
	            this._head.previous = item;
	            this._head = item;
	            this._state++;
	        }
	        else if (touch === Touch.Last) {
	            if (item === this._tail) {
	                return;
	            }
	            const next = item.next;
	            const previous = item.previous;
	            if (item === this._head) {
	                next.previous = undefined;
	                this._head = next;
	            }
	            else {
	                next.previous = previous;
	                previous.next = next;
	            }
	            item.next = undefined;
	            item.previous = this._tail;
	            this._tail.next = item;
	            this._tail = item;
	            this._state++;
	        }
	    }
	    toJSON() {
	        const data = [];
	        this.forEach((value, key) => {
	            data.push([key, value]);
	        });
	        return data;
	    }
	    fromJSON(data) {
	        this.clear();
	        for (const [key, value] of data) {
	            this.set(key, value);
	        }
	    }
	}
	linkedMap$1.LinkedMap = LinkedMap;
	class LRUCache extends LinkedMap {
	    constructor(limit, ratio = 1) {
	        super();
	        this._limit = limit;
	        this._ratio = Math.min(Math.max(0, ratio), 1);
	    }
	    get limit() {
	        return this._limit;
	    }
	    set limit(limit) {
	        this._limit = limit;
	        this.checkTrim();
	    }
	    get ratio() {
	        return this._ratio;
	    }
	    set ratio(ratio) {
	        this._ratio = Math.min(Math.max(0, ratio), 1);
	        this.checkTrim();
	    }
	    get(key, touch = Touch.AsNew) {
	        return super.get(key, touch);
	    }
	    peek(key) {
	        return super.get(key, Touch.None);
	    }
	    set(key, value) {
	        super.set(key, value, Touch.Last);
	        this.checkTrim();
	        return this;
	    }
	    checkTrim() {
	        if (this.size > this._limit) {
	            this.trimOld(Math.round(this._limit * this._ratio));
	        }
	    }
	}
	linkedMap$1.LRUCache = LRUCache;
	return linkedMap$1;
}

var disposable$1 = {};

var hasRequiredDisposable;
function requireDisposable () {
	if (hasRequiredDisposable) return disposable$1;
	hasRequiredDisposable = 1;
	Object.defineProperty(disposable$1, "__esModule", { value: true });
	disposable$1.Disposable = void 0;
	var Disposable;
	(function (Disposable) {
	    function create(func) {
	        return {
	            dispose: func
	        };
	    }
	    Disposable.create = create;
	})(Disposable || (disposable$1.Disposable = Disposable = {}));
	return disposable$1;
}

var events$1 = {};

var ral$2 = {};

var hasRequiredRal;
function requireRal () {
	if (hasRequiredRal) return ral$2;
	hasRequiredRal = 1;
	Object.defineProperty(ral$2, "__esModule", { value: true });
	let _ral;
	function RAL() {
	    if (_ral === undefined) {
	        throw new Error(`No runtime abstraction layer installed`);
	    }
	    return _ral;
	}
	(function (RAL) {
	    function install(ral) {
	        if (ral === undefined) {
	            throw new Error(`No runtime abstraction layer provided`);
	        }
	        _ral = ral;
	    }
	    RAL.install = install;
	})(RAL || (RAL = {}));
	ral$2.default = RAL;
	return ral$2;
}

var hasRequiredEvents$1;
function requireEvents$1 () {
	if (hasRequiredEvents$1) return events$1;
	hasRequiredEvents$1 = 1;
	Object.defineProperty(events$1, "__esModule", { value: true });
	events$1.Emitter = events$1.Event = void 0;
	const ral_1 = requireRal();
	var Event;
	(function (Event) {
	    const _disposable = { dispose() { } };
	    Event.None = function () { return _disposable; };
	})(Event || (events$1.Event = Event = {}));
	class CallbackList {
	    add(callback, context = null, bucket) {
	        if (!this._callbacks) {
	            this._callbacks = [];
	            this._contexts = [];
	        }
	        this._callbacks.push(callback);
	        this._contexts.push(context);
	        if (Array.isArray(bucket)) {
	            bucket.push({ dispose: () => this.remove(callback, context) });
	        }
	    }
	    remove(callback, context = null) {
	        if (!this._callbacks) {
	            return;
	        }
	        let foundCallbackWithDifferentContext = false;
	        for (let i = 0, len = this._callbacks.length; i < len; i++) {
	            if (this._callbacks[i] === callback) {
	                if (this._contexts[i] === context) {
	                    this._callbacks.splice(i, 1);
	                    this._contexts.splice(i, 1);
	                    return;
	                }
	                else {
	                    foundCallbackWithDifferentContext = true;
	                }
	            }
	        }
	        if (foundCallbackWithDifferentContext) {
	            throw new Error('When adding a listener with a context, you should remove it with the same context');
	        }
	    }
	    invoke(...args) {
	        if (!this._callbacks) {
	            return [];
	        }
	        const ret = [], callbacks = this._callbacks.slice(0), contexts = this._contexts.slice(0);
	        for (let i = 0, len = callbacks.length; i < len; i++) {
	            try {
	                ret.push(callbacks[i].apply(contexts[i], args));
	            }
	            catch (e) {
	                (0, ral_1.default)().console.error(e);
	            }
	        }
	        return ret;
	    }
	    isEmpty() {
	        return !this._callbacks || this._callbacks.length === 0;
	    }
	    dispose() {
	        this._callbacks = undefined;
	        this._contexts = undefined;
	    }
	}
	class Emitter {
	    constructor(_options) {
	        this._options = _options;
	    }
	    get event() {
	        if (!this._event) {
	            this._event = (listener, thisArgs, disposables) => {
	                if (!this._callbacks) {
	                    this._callbacks = new CallbackList();
	                }
	                if (this._options && this._options.onFirstListenerAdd && this._callbacks.isEmpty()) {
	                    this._options.onFirstListenerAdd(this);
	                }
	                this._callbacks.add(listener, thisArgs);
	                const result = {
	                    dispose: () => {
	                        if (!this._callbacks) {
	                            return;
	                        }
	                        this._callbacks.remove(listener, thisArgs);
	                        result.dispose = Emitter._noop;
	                        if (this._options && this._options.onLastListenerRemove && this._callbacks.isEmpty()) {
	                            this._options.onLastListenerRemove(this);
	                        }
	                    }
	                };
	                if (Array.isArray(disposables)) {
	                    disposables.push(result);
	                }
	                return result;
	            };
	        }
	        return this._event;
	    }
	    fire(event) {
	        if (this._callbacks) {
	            this._callbacks.invoke.call(this._callbacks, event);
	        }
	    }
	    dispose() {
	        if (this._callbacks) {
	            this._callbacks.dispose();
	            this._callbacks = undefined;
	        }
	    }
	}
	events$1.Emitter = Emitter;
	Emitter._noop = function () { };
	return events$1;
}

var cancellation$1 = {};

var hasRequiredCancellation$1;
function requireCancellation$1 () {
	if (hasRequiredCancellation$1) return cancellation$1;
	hasRequiredCancellation$1 = 1;
	Object.defineProperty(cancellation$1, "__esModule", { value: true });
	cancellation$1.CancellationTokenSource = cancellation$1.CancellationToken = void 0;
	const ral_1 = requireRal();
	const Is = requireIs$1();
	const events_1 = requireEvents$1();
	var CancellationToken;
	(function (CancellationToken) {
	    CancellationToken.None = Object.freeze({
	        isCancellationRequested: false,
	        onCancellationRequested: events_1.Event.None
	    });
	    CancellationToken.Cancelled = Object.freeze({
	        isCancellationRequested: true,
	        onCancellationRequested: events_1.Event.None
	    });
	    function is(value) {
	        const candidate = value;
	        return candidate && (candidate === CancellationToken.None
	            || candidate === CancellationToken.Cancelled
	            || (Is.boolean(candidate.isCancellationRequested) && !!candidate.onCancellationRequested));
	    }
	    CancellationToken.is = is;
	})(CancellationToken || (cancellation$1.CancellationToken = CancellationToken = {}));
	const shortcutEvent = Object.freeze(function (callback, context) {
	    const handle = (0, ral_1.default)().timer.setTimeout(callback.bind(context), 0);
	    return { dispose() { handle.dispose(); } };
	});
	class MutableToken {
	    constructor() {
	        this._isCancelled = false;
	    }
	    cancel() {
	        if (!this._isCancelled) {
	            this._isCancelled = true;
	            if (this._emitter) {
	                this._emitter.fire(undefined);
	                this.dispose();
	            }
	        }
	    }
	    get isCancellationRequested() {
	        return this._isCancelled;
	    }
	    get onCancellationRequested() {
	        if (this._isCancelled) {
	            return shortcutEvent;
	        }
	        if (!this._emitter) {
	            this._emitter = new events_1.Emitter();
	        }
	        return this._emitter.event;
	    }
	    dispose() {
	        if (this._emitter) {
	            this._emitter.dispose();
	            this._emitter = undefined;
	        }
	    }
	}
	class CancellationTokenSource {
	    get token() {
	        if (!this._token) {
	            this._token = new MutableToken();
	        }
	        return this._token;
	    }
	    cancel() {
	        if (!this._token) {
	            this._token = CancellationToken.Cancelled;
	        }
	        else {
	            this._token.cancel();
	        }
	    }
	    dispose() {
	        if (!this._token) {
	            this._token = CancellationToken.None;
	        }
	        else if (this._token instanceof MutableToken) {
	            this._token.dispose();
	        }
	    }
	}
	cancellation$1.CancellationTokenSource = CancellationTokenSource;
	return cancellation$1;
}

var sharedArrayCancellation = {};

var hasRequiredSharedArrayCancellation;
function requireSharedArrayCancellation () {
	if (hasRequiredSharedArrayCancellation) return sharedArrayCancellation;
	hasRequiredSharedArrayCancellation = 1;
	Object.defineProperty(sharedArrayCancellation, "__esModule", { value: true });
	sharedArrayCancellation.SharedArrayReceiverStrategy = sharedArrayCancellation.SharedArraySenderStrategy = void 0;
	const cancellation_1 = requireCancellation$1();
	var CancellationState;
	(function (CancellationState) {
	    CancellationState.Continue = 0;
	    CancellationState.Cancelled = 1;
	})(CancellationState || (CancellationState = {}));
	class SharedArraySenderStrategy {
	    constructor() {
	        this.buffers = new Map();
	    }
	    enableCancellation(request) {
	        if (request.id === null) {
	            return;
	        }
	        const buffer = new SharedArrayBuffer(4);
	        const data = new Int32Array(buffer, 0, 1);
	        data[0] = CancellationState.Continue;
	        this.buffers.set(request.id, buffer);
	        request.$cancellationData = buffer;
	    }
	    async sendCancellation(_conn, id) {
	        const buffer = this.buffers.get(id);
	        if (buffer === undefined) {
	            return;
	        }
	        const data = new Int32Array(buffer, 0, 1);
	        Atomics.store(data, 0, CancellationState.Cancelled);
	    }
	    cleanup(id) {
	        this.buffers.delete(id);
	    }
	    dispose() {
	        this.buffers.clear();
	    }
	}
	sharedArrayCancellation.SharedArraySenderStrategy = SharedArraySenderStrategy;
	class SharedArrayBufferCancellationToken {
	    constructor(buffer) {
	        this.data = new Int32Array(buffer, 0, 1);
	    }
	    get isCancellationRequested() {
	        return Atomics.load(this.data, 0) === CancellationState.Cancelled;
	    }
	    get onCancellationRequested() {
	        throw new Error(`Cancellation over SharedArrayBuffer doesn't support cancellation events`);
	    }
	}
	class SharedArrayBufferCancellationTokenSource {
	    constructor(buffer) {
	        this.token = new SharedArrayBufferCancellationToken(buffer);
	    }
	    cancel() {
	    }
	    dispose() {
	    }
	}
	class SharedArrayReceiverStrategy {
	    constructor() {
	        this.kind = 'request';
	    }
	    createCancellationTokenSource(request) {
	        const buffer = request.$cancellationData;
	        if (buffer === undefined) {
	            return new cancellation_1.CancellationTokenSource();
	        }
	        return new SharedArrayBufferCancellationTokenSource(buffer);
	    }
	}
	sharedArrayCancellation.SharedArrayReceiverStrategy = SharedArrayReceiverStrategy;
	return sharedArrayCancellation;
}

var messageReader$1 = {};

var semaphore$1 = {};

var hasRequiredSemaphore$1;
function requireSemaphore$1 () {
	if (hasRequiredSemaphore$1) return semaphore$1;
	hasRequiredSemaphore$1 = 1;
	Object.defineProperty(semaphore$1, "__esModule", { value: true });
	semaphore$1.Semaphore = void 0;
	const ral_1 = requireRal();
	class Semaphore {
	    constructor(capacity = 1) {
	        if (capacity <= 0) {
	            throw new Error('Capacity must be greater than 0');
	        }
	        this._capacity = capacity;
	        this._active = 0;
	        this._waiting = [];
	    }
	    lock(thunk) {
	        return new Promise((resolve, reject) => {
	            this._waiting.push({ thunk, resolve, reject });
	            this.runNext();
	        });
	    }
	    get active() {
	        return this._active;
	    }
	    runNext() {
	        if (this._waiting.length === 0 || this._active === this._capacity) {
	            return;
	        }
	        (0, ral_1.default)().timer.setImmediate(() => this.doRunNext());
	    }
	    doRunNext() {
	        if (this._waiting.length === 0 || this._active === this._capacity) {
	            return;
	        }
	        const next = this._waiting.shift();
	        this._active++;
	        if (this._active > this._capacity) {
	            throw new Error(`To many thunks active`);
	        }
	        try {
	            const result = next.thunk();
	            if (result instanceof Promise) {
	                result.then((value) => {
	                    this._active--;
	                    next.resolve(value);
	                    this.runNext();
	                }, (err) => {
	                    this._active--;
	                    next.reject(err);
	                    this.runNext();
	                });
	            }
	            else {
	                this._active--;
	                next.resolve(result);
	                this.runNext();
	            }
	        }
	        catch (err) {
	            this._active--;
	            next.reject(err);
	            this.runNext();
	        }
	    }
	}
	semaphore$1.Semaphore = Semaphore;
	return semaphore$1;
}

var hasRequiredMessageReader$1;
function requireMessageReader$1 () {
	if (hasRequiredMessageReader$1) return messageReader$1;
	hasRequiredMessageReader$1 = 1;
	Object.defineProperty(messageReader$1, "__esModule", { value: true });
	messageReader$1.ReadableStreamMessageReader = messageReader$1.AbstractMessageReader = messageReader$1.MessageReader = void 0;
	const ral_1 = requireRal();
	const Is = requireIs$1();
	const events_1 = requireEvents$1();
	const semaphore_1 = requireSemaphore$1();
	var MessageReader;
	(function (MessageReader) {
	    function is(value) {
	        let candidate = value;
	        return candidate && Is.func(candidate.listen) && Is.func(candidate.dispose) &&
	            Is.func(candidate.onError) && Is.func(candidate.onClose) && Is.func(candidate.onPartialMessage);
	    }
	    MessageReader.is = is;
	})(MessageReader || (messageReader$1.MessageReader = MessageReader = {}));
	class AbstractMessageReader {
	    constructor() {
	        this.errorEmitter = new events_1.Emitter();
	        this.closeEmitter = new events_1.Emitter();
	        this.partialMessageEmitter = new events_1.Emitter();
	    }
	    dispose() {
	        this.errorEmitter.dispose();
	        this.closeEmitter.dispose();
	    }
	    get onError() {
	        return this.errorEmitter.event;
	    }
	    fireError(error) {
	        this.errorEmitter.fire(this.asError(error));
	    }
	    get onClose() {
	        return this.closeEmitter.event;
	    }
	    fireClose() {
	        this.closeEmitter.fire(undefined);
	    }
	    get onPartialMessage() {
	        return this.partialMessageEmitter.event;
	    }
	    firePartialMessage(info) {
	        this.partialMessageEmitter.fire(info);
	    }
	    asError(error) {
	        if (error instanceof Error) {
	            return error;
	        }
	        else {
	            return new Error(`Reader received error. Reason: ${Is.string(error.message) ? error.message : 'unknown'}`);
	        }
	    }
	}
	messageReader$1.AbstractMessageReader = AbstractMessageReader;
	var ResolvedMessageReaderOptions;
	(function (ResolvedMessageReaderOptions) {
	    function fromOptions(options) {
	        let charset;
	        let contentDecoder;
	        const contentDecoders = new Map();
	        let contentTypeDecoder;
	        const contentTypeDecoders = new Map();
	        if (options === undefined || typeof options === 'string') {
	            charset = options ?? 'utf-8';
	        }
	        else {
	            charset = options.charset ?? 'utf-8';
	            if (options.contentDecoder !== undefined) {
	                contentDecoder = options.contentDecoder;
	                contentDecoders.set(contentDecoder.name, contentDecoder);
	            }
	            if (options.contentDecoders !== undefined) {
	                for (const decoder of options.contentDecoders) {
	                    contentDecoders.set(decoder.name, decoder);
	                }
	            }
	            if (options.contentTypeDecoder !== undefined) {
	                contentTypeDecoder = options.contentTypeDecoder;
	                contentTypeDecoders.set(contentTypeDecoder.name, contentTypeDecoder);
	            }
	            if (options.contentTypeDecoders !== undefined) {
	                for (const decoder of options.contentTypeDecoders) {
	                    contentTypeDecoders.set(decoder.name, decoder);
	                }
	            }
	        }
	        if (contentTypeDecoder === undefined) {
	            contentTypeDecoder = (0, ral_1.default)().applicationJson.decoder;
	            contentTypeDecoders.set(contentTypeDecoder.name, contentTypeDecoder);
	        }
	        return { charset, contentDecoder, contentDecoders, contentTypeDecoder, contentTypeDecoders };
	    }
	    ResolvedMessageReaderOptions.fromOptions = fromOptions;
	})(ResolvedMessageReaderOptions || (ResolvedMessageReaderOptions = {}));
	class ReadableStreamMessageReader extends AbstractMessageReader {
	    constructor(readable, options) {
	        super();
	        this.readable = readable;
	        this.options = ResolvedMessageReaderOptions.fromOptions(options);
	        this.buffer = (0, ral_1.default)().messageBuffer.create(this.options.charset);
	        this._partialMessageTimeout = 10000;
	        this.nextMessageLength = -1;
	        this.messageToken = 0;
	        this.readSemaphore = new semaphore_1.Semaphore(1);
	    }
	    set partialMessageTimeout(timeout) {
	        this._partialMessageTimeout = timeout;
	    }
	    get partialMessageTimeout() {
	        return this._partialMessageTimeout;
	    }
	    listen(callback) {
	        this.nextMessageLength = -1;
	        this.messageToken = 0;
	        this.partialMessageTimer = undefined;
	        this.callback = callback;
	        const result = this.readable.onData((data) => {
	            this.onData(data);
	        });
	        this.readable.onError((error) => this.fireError(error));
	        this.readable.onClose(() => this.fireClose());
	        return result;
	    }
	    onData(data) {
	        try {
	            this.buffer.append(data);
	            while (true) {
	                if (this.nextMessageLength === -1) {
	                    const headers = this.buffer.tryReadHeaders(true);
	                    if (!headers) {
	                        return;
	                    }
	                    const contentLength = headers.get('content-length');
	                    if (!contentLength) {
	                        this.fireError(new Error(`Header must provide a Content-Length property.\n${JSON.stringify(Object.fromEntries(headers))}`));
	                        return;
	                    }
	                    const length = parseInt(contentLength);
	                    if (isNaN(length)) {
	                        this.fireError(new Error(`Content-Length value must be a number. Got ${contentLength}`));
	                        return;
	                    }
	                    this.nextMessageLength = length;
	                }
	                const body = this.buffer.tryReadBody(this.nextMessageLength);
	                if (body === undefined) {
	                    this.setPartialMessageTimer();
	                    return;
	                }
	                this.clearPartialMessageTimer();
	                this.nextMessageLength = -1;
	                this.readSemaphore.lock(async () => {
	                    const bytes = this.options.contentDecoder !== undefined
	                        ? await this.options.contentDecoder.decode(body)
	                        : body;
	                    const message = await this.options.contentTypeDecoder.decode(bytes, this.options);
	                    this.callback(message);
	                }).catch((error) => {
	                    this.fireError(error);
	                });
	            }
	        }
	        catch (error) {
	            this.fireError(error);
	        }
	    }
	    clearPartialMessageTimer() {
	        if (this.partialMessageTimer) {
	            this.partialMessageTimer.dispose();
	            this.partialMessageTimer = undefined;
	        }
	    }
	    setPartialMessageTimer() {
	        this.clearPartialMessageTimer();
	        if (this._partialMessageTimeout <= 0) {
	            return;
	        }
	        this.partialMessageTimer = (0, ral_1.default)().timer.setTimeout((token, timeout) => {
	            this.partialMessageTimer = undefined;
	            if (token === this.messageToken) {
	                this.firePartialMessage({ messageToken: token, waitingTime: timeout });
	                this.setPartialMessageTimer();
	            }
	        }, this._partialMessageTimeout, this.messageToken, this._partialMessageTimeout);
	    }
	}
	messageReader$1.ReadableStreamMessageReader = ReadableStreamMessageReader;
	return messageReader$1;
}

var messageWriter$1 = {};

var hasRequiredMessageWriter$1;
function requireMessageWriter$1 () {
	if (hasRequiredMessageWriter$1) return messageWriter$1;
	hasRequiredMessageWriter$1 = 1;
	Object.defineProperty(messageWriter$1, "__esModule", { value: true });
	messageWriter$1.WriteableStreamMessageWriter = messageWriter$1.AbstractMessageWriter = messageWriter$1.MessageWriter = void 0;
	const ral_1 = requireRal();
	const Is = requireIs$1();
	const semaphore_1 = requireSemaphore$1();
	const events_1 = requireEvents$1();
	const ContentLength = 'Content-Length: ';
	const CRLF = '\r\n';
	var MessageWriter;
	(function (MessageWriter) {
	    function is(value) {
	        let candidate = value;
	        return candidate && Is.func(candidate.dispose) && Is.func(candidate.onClose) &&
	            Is.func(candidate.onError) && Is.func(candidate.write);
	    }
	    MessageWriter.is = is;
	})(MessageWriter || (messageWriter$1.MessageWriter = MessageWriter = {}));
	class AbstractMessageWriter {
	    constructor() {
	        this.errorEmitter = new events_1.Emitter();
	        this.closeEmitter = new events_1.Emitter();
	    }
	    dispose() {
	        this.errorEmitter.dispose();
	        this.closeEmitter.dispose();
	    }
	    get onError() {
	        return this.errorEmitter.event;
	    }
	    fireError(error, message, count) {
	        this.errorEmitter.fire([this.asError(error), message, count]);
	    }
	    get onClose() {
	        return this.closeEmitter.event;
	    }
	    fireClose() {
	        this.closeEmitter.fire(undefined);
	    }
	    asError(error) {
	        if (error instanceof Error) {
	            return error;
	        }
	        else {
	            return new Error(`Writer received error. Reason: ${Is.string(error.message) ? error.message : 'unknown'}`);
	        }
	    }
	}
	messageWriter$1.AbstractMessageWriter = AbstractMessageWriter;
	var ResolvedMessageWriterOptions;
	(function (ResolvedMessageWriterOptions) {
	    function fromOptions(options) {
	        if (options === undefined || typeof options === 'string') {
	            return { charset: options ?? 'utf-8', contentTypeEncoder: (0, ral_1.default)().applicationJson.encoder };
	        }
	        else {
	            return { charset: options.charset ?? 'utf-8', contentEncoder: options.contentEncoder, contentTypeEncoder: options.contentTypeEncoder ?? (0, ral_1.default)().applicationJson.encoder };
	        }
	    }
	    ResolvedMessageWriterOptions.fromOptions = fromOptions;
	})(ResolvedMessageWriterOptions || (ResolvedMessageWriterOptions = {}));
	class WriteableStreamMessageWriter extends AbstractMessageWriter {
	    constructor(writable, options) {
	        super();
	        this.writable = writable;
	        this.options = ResolvedMessageWriterOptions.fromOptions(options);
	        this.errorCount = 0;
	        this.writeSemaphore = new semaphore_1.Semaphore(1);
	        this.writable.onError((error) => this.fireError(error));
	        this.writable.onClose(() => this.fireClose());
	    }
	    async write(msg) {
	        return this.writeSemaphore.lock(async () => {
	            const payload = this.options.contentTypeEncoder.encode(msg, this.options).then((buffer) => {
	                if (this.options.contentEncoder !== undefined) {
	                    return this.options.contentEncoder.encode(buffer);
	                }
	                else {
	                    return buffer;
	                }
	            });
	            return payload.then((buffer) => {
	                const headers = [];
	                headers.push(ContentLength, buffer.byteLength.toString(), CRLF);
	                headers.push(CRLF);
	                return this.doWrite(msg, headers, buffer);
	            }, (error) => {
	                this.fireError(error);
	                throw error;
	            });
	        });
	    }
	    async doWrite(msg, headers, data) {
	        try {
	            await this.writable.write(headers.join(''), 'ascii');
	            return this.writable.write(data);
	        }
	        catch (error) {
	            this.handleError(error, msg);
	            return Promise.reject(error);
	        }
	    }
	    handleError(error, msg) {
	        this.errorCount++;
	        this.fireError(error, msg, this.errorCount);
	    }
	    end() {
	        this.writable.end();
	    }
	}
	messageWriter$1.WriteableStreamMessageWriter = WriteableStreamMessageWriter;
	return messageWriter$1;
}

var messageBuffer$1 = {};

var hasRequiredMessageBuffer;
function requireMessageBuffer () {
	if (hasRequiredMessageBuffer) return messageBuffer$1;
	hasRequiredMessageBuffer = 1;
	Object.defineProperty(messageBuffer$1, "__esModule", { value: true });
	messageBuffer$1.AbstractMessageBuffer = void 0;
	const CR = 13;
	const LF = 10;
	const CRLF = '\r\n';
	class AbstractMessageBuffer {
	    constructor(encoding = 'utf-8') {
	        this._encoding = encoding;
	        this._chunks = [];
	        this._totalLength = 0;
	    }
	    get encoding() {
	        return this._encoding;
	    }
	    append(chunk) {
	        const toAppend = typeof chunk === 'string' ? this.fromString(chunk, this._encoding) : chunk;
	        this._chunks.push(toAppend);
	        this._totalLength += toAppend.byteLength;
	    }
	    tryReadHeaders(lowerCaseKeys = false) {
	        if (this._chunks.length === 0) {
	            return undefined;
	        }
	        let state = 0;
	        let chunkIndex = 0;
	        let offset = 0;
	        let chunkBytesRead = 0;
	        row: while (chunkIndex < this._chunks.length) {
	            const chunk = this._chunks[chunkIndex];
	            offset = 0;
	            while (offset < chunk.length) {
	                const value = chunk[offset];
	                switch (value) {
	                    case CR:
	                        switch (state) {
	                            case 0:
	                                state = 1;
	                                break;
	                            case 2:
	                                state = 3;
	                                break;
	                            default:
	                                state = 0;
	                        }
	                        break;
	                    case LF:
	                        switch (state) {
	                            case 1:
	                                state = 2;
	                                break;
	                            case 3:
	                                state = 4;
	                                offset++;
	                                break row;
	                            default:
	                                state = 0;
	                        }
	                        break;
	                    default:
	                        state = 0;
	                }
	                offset++;
	            }
	            chunkBytesRead += chunk.byteLength;
	            chunkIndex++;
	        }
	        if (state !== 4) {
	            return undefined;
	        }
	        const buffer = this._read(chunkBytesRead + offset);
	        const result = new Map();
	        const headers = this.toString(buffer, 'ascii').split(CRLF);
	        if (headers.length < 2) {
	            return result;
	        }
	        for (let i = 0; i < headers.length - 2; i++) {
	            const header = headers[i];
	            const index = header.indexOf(':');
	            if (index === -1) {
	                throw new Error(`Message header must separate key and value using ':'\n${header}`);
	            }
	            const key = header.substr(0, index);
	            const value = header.substr(index + 1).trim();
	            result.set(lowerCaseKeys ? key.toLowerCase() : key, value);
	        }
	        return result;
	    }
	    tryReadBody(length) {
	        if (this._totalLength < length) {
	            return undefined;
	        }
	        return this._read(length);
	    }
	    get numberOfBytes() {
	        return this._totalLength;
	    }
	    _read(byteCount) {
	        if (byteCount === 0) {
	            return this.emptyBuffer();
	        }
	        if (byteCount > this._totalLength) {
	            throw new Error(`Cannot read so many bytes!`);
	        }
	        if (this._chunks[0].byteLength === byteCount) {
	            const chunk = this._chunks[0];
	            this._chunks.shift();
	            this._totalLength -= byteCount;
	            return this.asNative(chunk);
	        }
	        if (this._chunks[0].byteLength > byteCount) {
	            const chunk = this._chunks[0];
	            const result = this.asNative(chunk, byteCount);
	            this._chunks[0] = chunk.slice(byteCount);
	            this._totalLength -= byteCount;
	            return result;
	        }
	        const result = this.allocNative(byteCount);
	        let resultOffset = 0;
	        let chunkIndex = 0;
	        while (byteCount > 0) {
	            const chunk = this._chunks[chunkIndex];
	            if (chunk.byteLength > byteCount) {
	                const chunkPart = chunk.slice(0, byteCount);
	                result.set(chunkPart, resultOffset);
	                resultOffset += byteCount;
	                this._chunks[chunkIndex] = chunk.slice(byteCount);
	                this._totalLength -= byteCount;
	                byteCount -= byteCount;
	            }
	            else {
	                result.set(chunk, resultOffset);
	                resultOffset += chunk.byteLength;
	                this._chunks.shift();
	                this._totalLength -= chunk.byteLength;
	                byteCount -= chunk.byteLength;
	            }
	        }
	        return result;
	    }
	}
	messageBuffer$1.AbstractMessageBuffer = AbstractMessageBuffer;
	return messageBuffer$1;
}

var connection$3 = {};

var hasRequiredConnection$1;
function requireConnection$1 () {
	if (hasRequiredConnection$1) return connection$3;
	hasRequiredConnection$1 = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.createMessageConnection = exports.ConnectionOptions = exports.MessageStrategy = exports.CancellationStrategy = exports.CancellationSenderStrategy = exports.CancellationReceiverStrategy = exports.RequestCancellationReceiverStrategy = exports.IdCancellationReceiverStrategy = exports.ConnectionStrategy = exports.ConnectionError = exports.ConnectionErrors = exports.LogTraceNotification = exports.SetTraceNotification = exports.TraceFormat = exports.TraceValues = exports.Trace = exports.NullLogger = exports.ProgressType = exports.ProgressToken = void 0;
		const ral_1 = requireRal();
		const Is = requireIs$1();
		const messages_1 = requireMessages$1();
		const linkedMap_1 = requireLinkedMap$1();
		const events_1 = requireEvents$1();
		const cancellation_1 = requireCancellation$1();
		var CancelNotification;
		(function (CancelNotification) {
		    CancelNotification.type = new messages_1.NotificationType('$/cancelRequest');
		})(CancelNotification || (CancelNotification = {}));
		var ProgressToken;
		(function (ProgressToken) {
		    function is(value) {
		        return typeof value === 'string' || typeof value === 'number';
		    }
		    ProgressToken.is = is;
		})(ProgressToken || (exports.ProgressToken = ProgressToken = {}));
		var ProgressNotification;
		(function (ProgressNotification) {
		    ProgressNotification.type = new messages_1.NotificationType('$/progress');
		})(ProgressNotification || (ProgressNotification = {}));
		class ProgressType {
		    constructor() {
		    }
		}
		exports.ProgressType = ProgressType;
		var StarRequestHandler;
		(function (StarRequestHandler) {
		    function is(value) {
		        return Is.func(value);
		    }
		    StarRequestHandler.is = is;
		})(StarRequestHandler || (StarRequestHandler = {}));
		exports.NullLogger = Object.freeze({
		    error: () => { },
		    warn: () => { },
		    info: () => { },
		    log: () => { }
		});
		var Trace;
		(function (Trace) {
		    Trace[Trace["Off"] = 0] = "Off";
		    Trace[Trace["Messages"] = 1] = "Messages";
		    Trace[Trace["Compact"] = 2] = "Compact";
		    Trace[Trace["Verbose"] = 3] = "Verbose";
		})(Trace || (exports.Trace = Trace = {}));
		var TraceValues;
		(function (TraceValues) {
		    TraceValues.Off = 'off';
		    TraceValues.Messages = 'messages';
		    TraceValues.Compact = 'compact';
		    TraceValues.Verbose = 'verbose';
		})(TraceValues || (exports.TraceValues = TraceValues = {}));
		(function (Trace) {
		    function fromString(value) {
		        if (!Is.string(value)) {
		            return Trace.Off;
		        }
		        value = value.toLowerCase();
		        switch (value) {
		            case 'off':
		                return Trace.Off;
		            case 'messages':
		                return Trace.Messages;
		            case 'compact':
		                return Trace.Compact;
		            case 'verbose':
		                return Trace.Verbose;
		            default:
		                return Trace.Off;
		        }
		    }
		    Trace.fromString = fromString;
		    function toString(value) {
		        switch (value) {
		            case Trace.Off:
		                return 'off';
		            case Trace.Messages:
		                return 'messages';
		            case Trace.Compact:
		                return 'compact';
		            case Trace.Verbose:
		                return 'verbose';
		            default:
		                return 'off';
		        }
		    }
		    Trace.toString = toString;
		})(Trace || (exports.Trace = Trace = {}));
		var TraceFormat;
		(function (TraceFormat) {
		    TraceFormat["Text"] = "text";
		    TraceFormat["JSON"] = "json";
		})(TraceFormat || (exports.TraceFormat = TraceFormat = {}));
		(function (TraceFormat) {
		    function fromString(value) {
		        if (!Is.string(value)) {
		            return TraceFormat.Text;
		        }
		        value = value.toLowerCase();
		        if (value === 'json') {
		            return TraceFormat.JSON;
		        }
		        else {
		            return TraceFormat.Text;
		        }
		    }
		    TraceFormat.fromString = fromString;
		})(TraceFormat || (exports.TraceFormat = TraceFormat = {}));
		var SetTraceNotification;
		(function (SetTraceNotification) {
		    SetTraceNotification.type = new messages_1.NotificationType('$/setTrace');
		})(SetTraceNotification || (exports.SetTraceNotification = SetTraceNotification = {}));
		var LogTraceNotification;
		(function (LogTraceNotification) {
		    LogTraceNotification.type = new messages_1.NotificationType('$/logTrace');
		})(LogTraceNotification || (exports.LogTraceNotification = LogTraceNotification = {}));
		var ConnectionErrors;
		(function (ConnectionErrors) {
		    ConnectionErrors[ConnectionErrors["Closed"] = 1] = "Closed";
		    ConnectionErrors[ConnectionErrors["Disposed"] = 2] = "Disposed";
		    ConnectionErrors[ConnectionErrors["AlreadyListening"] = 3] = "AlreadyListening";
		})(ConnectionErrors || (exports.ConnectionErrors = ConnectionErrors = {}));
		class ConnectionError extends Error {
		    constructor(code, message) {
		        super(message);
		        this.code = code;
		        Object.setPrototypeOf(this, ConnectionError.prototype);
		    }
		}
		exports.ConnectionError = ConnectionError;
		var ConnectionStrategy;
		(function (ConnectionStrategy) {
		    function is(value) {
		        const candidate = value;
		        return candidate && Is.func(candidate.cancelUndispatched);
		    }
		    ConnectionStrategy.is = is;
		})(ConnectionStrategy || (exports.ConnectionStrategy = ConnectionStrategy = {}));
		var IdCancellationReceiverStrategy;
		(function (IdCancellationReceiverStrategy) {
		    function is(value) {
		        const candidate = value;
		        return candidate && (candidate.kind === undefined || candidate.kind === 'id') && Is.func(candidate.createCancellationTokenSource) && (candidate.dispose === undefined || Is.func(candidate.dispose));
		    }
		    IdCancellationReceiverStrategy.is = is;
		})(IdCancellationReceiverStrategy || (exports.IdCancellationReceiverStrategy = IdCancellationReceiverStrategy = {}));
		var RequestCancellationReceiverStrategy;
		(function (RequestCancellationReceiverStrategy) {
		    function is(value) {
		        const candidate = value;
		        return candidate && candidate.kind === 'request' && Is.func(candidate.createCancellationTokenSource) && (candidate.dispose === undefined || Is.func(candidate.dispose));
		    }
		    RequestCancellationReceiverStrategy.is = is;
		})(RequestCancellationReceiverStrategy || (exports.RequestCancellationReceiverStrategy = RequestCancellationReceiverStrategy = {}));
		var CancellationReceiverStrategy;
		(function (CancellationReceiverStrategy) {
		    CancellationReceiverStrategy.Message = Object.freeze({
		        createCancellationTokenSource(_) {
		            return new cancellation_1.CancellationTokenSource();
		        }
		    });
		    function is(value) {
		        return IdCancellationReceiverStrategy.is(value) || RequestCancellationReceiverStrategy.is(value);
		    }
		    CancellationReceiverStrategy.is = is;
		})(CancellationReceiverStrategy || (exports.CancellationReceiverStrategy = CancellationReceiverStrategy = {}));
		var CancellationSenderStrategy;
		(function (CancellationSenderStrategy) {
		    CancellationSenderStrategy.Message = Object.freeze({
		        sendCancellation(conn, id) {
		            return conn.sendNotification(CancelNotification.type, { id });
		        },
		        cleanup(_) { }
		    });
		    function is(value) {
		        const candidate = value;
		        return candidate && Is.func(candidate.sendCancellation) && Is.func(candidate.cleanup);
		    }
		    CancellationSenderStrategy.is = is;
		})(CancellationSenderStrategy || (exports.CancellationSenderStrategy = CancellationSenderStrategy = {}));
		var CancellationStrategy;
		(function (CancellationStrategy) {
		    CancellationStrategy.Message = Object.freeze({
		        receiver: CancellationReceiverStrategy.Message,
		        sender: CancellationSenderStrategy.Message
		    });
		    function is(value) {
		        const candidate = value;
		        return candidate && CancellationReceiverStrategy.is(candidate.receiver) && CancellationSenderStrategy.is(candidate.sender);
		    }
		    CancellationStrategy.is = is;
		})(CancellationStrategy || (exports.CancellationStrategy = CancellationStrategy = {}));
		var MessageStrategy;
		(function (MessageStrategy) {
		    function is(value) {
		        const candidate = value;
		        return candidate && Is.func(candidate.handleMessage);
		    }
		    MessageStrategy.is = is;
		})(MessageStrategy || (exports.MessageStrategy = MessageStrategy = {}));
		var ConnectionOptions;
		(function (ConnectionOptions) {
		    function is(value) {
		        const candidate = value;
		        return candidate && (CancellationStrategy.is(candidate.cancellationStrategy) || ConnectionStrategy.is(candidate.connectionStrategy) || MessageStrategy.is(candidate.messageStrategy));
		    }
		    ConnectionOptions.is = is;
		})(ConnectionOptions || (exports.ConnectionOptions = ConnectionOptions = {}));
		var ConnectionState;
		(function (ConnectionState) {
		    ConnectionState[ConnectionState["New"] = 1] = "New";
		    ConnectionState[ConnectionState["Listening"] = 2] = "Listening";
		    ConnectionState[ConnectionState["Closed"] = 3] = "Closed";
		    ConnectionState[ConnectionState["Disposed"] = 4] = "Disposed";
		})(ConnectionState || (ConnectionState = {}));
		function createMessageConnection(messageReader, messageWriter, _logger, options) {
		    const logger = _logger !== undefined ? _logger : exports.NullLogger;
		    let sequenceNumber = 0;
		    let notificationSequenceNumber = 0;
		    let unknownResponseSequenceNumber = 0;
		    const version = '2.0';
		    let starRequestHandler = undefined;
		    const requestHandlers = new Map();
		    let starNotificationHandler = undefined;
		    const notificationHandlers = new Map();
		    const progressHandlers = new Map();
		    let timer;
		    let messageQueue = new linkedMap_1.LinkedMap();
		    let responsePromises = new Map();
		    let knownCanceledRequests = new Set();
		    let requestTokens = new Map();
		    let trace = Trace.Off;
		    let traceFormat = TraceFormat.Text;
		    let tracer;
		    let state = ConnectionState.New;
		    const errorEmitter = new events_1.Emitter();
		    const closeEmitter = new events_1.Emitter();
		    const unhandledNotificationEmitter = new events_1.Emitter();
		    const unhandledProgressEmitter = new events_1.Emitter();
		    const disposeEmitter = new events_1.Emitter();
		    const cancellationStrategy = (options && options.cancellationStrategy) ? options.cancellationStrategy : CancellationStrategy.Message;
		    function createRequestQueueKey(id) {
		        if (id === null) {
		            throw new Error(`Can't send requests with id null since the response can't be correlated.`);
		        }
		        return 'req-' + id.toString();
		    }
		    function createResponseQueueKey(id) {
		        if (id === null) {
		            return 'res-unknown-' + (++unknownResponseSequenceNumber).toString();
		        }
		        else {
		            return 'res-' + id.toString();
		        }
		    }
		    function createNotificationQueueKey() {
		        return 'not-' + (++notificationSequenceNumber).toString();
		    }
		    function addMessageToQueue(queue, message) {
		        if (messages_1.Message.isRequest(message)) {
		            queue.set(createRequestQueueKey(message.id), message);
		        }
		        else if (messages_1.Message.isResponse(message)) {
		            queue.set(createResponseQueueKey(message.id), message);
		        }
		        else {
		            queue.set(createNotificationQueueKey(), message);
		        }
		    }
		    function cancelUndispatched(_message) {
		        return undefined;
		    }
		    function isListening() {
		        return state === ConnectionState.Listening;
		    }
		    function isClosed() {
		        return state === ConnectionState.Closed;
		    }
		    function isDisposed() {
		        return state === ConnectionState.Disposed;
		    }
		    function closeHandler() {
		        if (state === ConnectionState.New || state === ConnectionState.Listening) {
		            state = ConnectionState.Closed;
		            closeEmitter.fire(undefined);
		        }
		    }
		    function readErrorHandler(error) {
		        errorEmitter.fire([error, undefined, undefined]);
		    }
		    function writeErrorHandler(data) {
		        errorEmitter.fire(data);
		    }
		    messageReader.onClose(closeHandler);
		    messageReader.onError(readErrorHandler);
		    messageWriter.onClose(closeHandler);
		    messageWriter.onError(writeErrorHandler);
		    function triggerMessageQueue() {
		        if (timer || messageQueue.size === 0) {
		            return;
		        }
		        timer = (0, ral_1.default)().timer.setImmediate(() => {
		            timer = undefined;
		            processMessageQueue();
		        });
		    }
		    function handleMessage(message) {
		        if (messages_1.Message.isRequest(message)) {
		            handleRequest(message);
		        }
		        else if (messages_1.Message.isNotification(message)) {
		            handleNotification(message);
		        }
		        else if (messages_1.Message.isResponse(message)) {
		            handleResponse(message);
		        }
		        else {
		            handleInvalidMessage(message);
		        }
		    }
		    function processMessageQueue() {
		        if (messageQueue.size === 0) {
		            return;
		        }
		        const message = messageQueue.shift();
		        try {
		            const messageStrategy = options?.messageStrategy;
		            if (MessageStrategy.is(messageStrategy)) {
		                messageStrategy.handleMessage(message, handleMessage);
		            }
		            else {
		                handleMessage(message);
		            }
		        }
		        finally {
		            triggerMessageQueue();
		        }
		    }
		    const callback = (message) => {
		        try {
		            if (messages_1.Message.isNotification(message) && message.method === CancelNotification.type.method) {
		                const cancelId = message.params.id;
		                const key = createRequestQueueKey(cancelId);
		                const toCancel = messageQueue.get(key);
		                if (messages_1.Message.isRequest(toCancel)) {
		                    const strategy = options?.connectionStrategy;
		                    const response = (strategy && strategy.cancelUndispatched) ? strategy.cancelUndispatched(toCancel, cancelUndispatched) : cancelUndispatched(toCancel);
		                    if (response && (response.error !== undefined || response.result !== undefined)) {
		                        messageQueue.delete(key);
		                        requestTokens.delete(cancelId);
		                        response.id = toCancel.id;
		                        traceSendingResponse(response, message.method, Date.now());
		                        messageWriter.write(response).catch(() => logger.error(`Sending response for canceled message failed.`));
		                        return;
		                    }
		                }
		                const cancellationToken = requestTokens.get(cancelId);
		                if (cancellationToken !== undefined) {
		                    cancellationToken.cancel();
		                    traceReceivedNotification(message);
		                    return;
		                }
		                else {
		                    knownCanceledRequests.add(cancelId);
		                }
		            }
		            addMessageToQueue(messageQueue, message);
		        }
		        finally {
		            triggerMessageQueue();
		        }
		    };
		    function handleRequest(requestMessage) {
		        if (isDisposed()) {
		            return;
		        }
		        function reply(resultOrError, method, startTime) {
		            const message = {
		                jsonrpc: version,
		                id: requestMessage.id
		            };
		            if (resultOrError instanceof messages_1.ResponseError) {
		                message.error = resultOrError.toJson();
		            }
		            else {
		                message.result = resultOrError === undefined ? null : resultOrError;
		            }
		            traceSendingResponse(message, method, startTime);
		            messageWriter.write(message).catch(() => logger.error(`Sending response failed.`));
		        }
		        function replyError(error, method, startTime) {
		            const message = {
		                jsonrpc: version,
		                id: requestMessage.id,
		                error: error.toJson()
		            };
		            traceSendingResponse(message, method, startTime);
		            messageWriter.write(message).catch(() => logger.error(`Sending response failed.`));
		        }
		        function replySuccess(result, method, startTime) {
		            if (result === undefined) {
		                result = null;
		            }
		            const message = {
		                jsonrpc: version,
		                id: requestMessage.id,
		                result: result
		            };
		            traceSendingResponse(message, method, startTime);
		            messageWriter.write(message).catch(() => logger.error(`Sending response failed.`));
		        }
		        traceReceivedRequest(requestMessage);
		        const element = requestHandlers.get(requestMessage.method);
		        let type;
		        let requestHandler;
		        if (element) {
		            type = element.type;
		            requestHandler = element.handler;
		        }
		        const startTime = Date.now();
		        if (requestHandler || starRequestHandler) {
		            const tokenKey = requestMessage.id ?? String(Date.now());
		            const cancellationSource = IdCancellationReceiverStrategy.is(cancellationStrategy.receiver)
		                ? cancellationStrategy.receiver.createCancellationTokenSource(tokenKey)
		                : cancellationStrategy.receiver.createCancellationTokenSource(requestMessage);
		            if (requestMessage.id !== null && knownCanceledRequests.has(requestMessage.id)) {
		                cancellationSource.cancel();
		            }
		            if (requestMessage.id !== null) {
		                requestTokens.set(tokenKey, cancellationSource);
		            }
		            try {
		                let handlerResult;
		                if (requestHandler) {
		                    if (requestMessage.params === undefined) {
		                        if (type !== undefined && type.numberOfParams !== 0) {
		                            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InvalidParams, `Request ${requestMessage.method} defines ${type.numberOfParams} params but received none.`), requestMessage.method, startTime);
		                            return;
		                        }
		                        handlerResult = requestHandler(cancellationSource.token);
		                    }
		                    else if (Array.isArray(requestMessage.params)) {
		                        if (type !== undefined && type.parameterStructures === messages_1.ParameterStructures.byName) {
		                            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InvalidParams, `Request ${requestMessage.method} defines parameters by name but received parameters by position`), requestMessage.method, startTime);
		                            return;
		                        }
		                        handlerResult = requestHandler(...requestMessage.params, cancellationSource.token);
		                    }
		                    else {
		                        if (type !== undefined && type.parameterStructures === messages_1.ParameterStructures.byPosition) {
		                            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InvalidParams, `Request ${requestMessage.method} defines parameters by position but received parameters by name`), requestMessage.method, startTime);
		                            return;
		                        }
		                        handlerResult = requestHandler(requestMessage.params, cancellationSource.token);
		                    }
		                }
		                else if (starRequestHandler) {
		                    handlerResult = starRequestHandler(requestMessage.method, requestMessage.params, cancellationSource.token);
		                }
		                const promise = handlerResult;
		                if (!handlerResult) {
		                    requestTokens.delete(tokenKey);
		                    replySuccess(handlerResult, requestMessage.method, startTime);
		                }
		                else if (promise.then) {
		                    promise.then((resultOrError) => {
		                        requestTokens.delete(tokenKey);
		                        reply(resultOrError, requestMessage.method, startTime);
		                    }, error => {
		                        requestTokens.delete(tokenKey);
		                        if (error instanceof messages_1.ResponseError) {
		                            replyError(error, requestMessage.method, startTime);
		                        }
		                        else if (error && Is.string(error.message)) {
		                            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed with message: ${error.message}`), requestMessage.method, startTime);
		                        }
		                        else {
		                            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed unexpectedly without providing any details.`), requestMessage.method, startTime);
		                        }
		                    });
		                }
		                else {
		                    requestTokens.delete(tokenKey);
		                    reply(handlerResult, requestMessage.method, startTime);
		                }
		            }
		            catch (error) {
		                requestTokens.delete(tokenKey);
		                if (error instanceof messages_1.ResponseError) {
		                    reply(error, requestMessage.method, startTime);
		                }
		                else if (error && Is.string(error.message)) {
		                    replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed with message: ${error.message}`), requestMessage.method, startTime);
		                }
		                else {
		                    replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed unexpectedly without providing any details.`), requestMessage.method, startTime);
		                }
		            }
		        }
		        else {
		            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.MethodNotFound, `Unhandled method ${requestMessage.method}`), requestMessage.method, startTime);
		        }
		    }
		    function handleResponse(responseMessage) {
		        if (isDisposed()) {
		            return;
		        }
		        if (responseMessage.id === null) {
		            if (responseMessage.error) {
		                logger.error(`Received response message without id: Error is: \n${JSON.stringify(responseMessage.error, undefined, 4)}`);
		            }
		            else {
		                logger.error(`Received response message without id. No further error information provided.`);
		            }
		        }
		        else {
		            const key = responseMessage.id;
		            const responsePromise = responsePromises.get(key);
		            traceReceivedResponse(responseMessage, responsePromise);
		            if (responsePromise !== undefined) {
		                responsePromises.delete(key);
		                try {
		                    if (responseMessage.error) {
		                        const error = responseMessage.error;
		                        responsePromise.reject(new messages_1.ResponseError(error.code, error.message, error.data));
		                    }
		                    else if (responseMessage.result !== undefined) {
		                        responsePromise.resolve(responseMessage.result);
		                    }
		                    else {
		                        throw new Error('Should never happen.');
		                    }
		                }
		                catch (error) {
		                    if (error.message) {
		                        logger.error(`Response handler '${responsePromise.method}' failed with message: ${error.message}`);
		                    }
		                    else {
		                        logger.error(`Response handler '${responsePromise.method}' failed unexpectedly.`);
		                    }
		                }
		            }
		        }
		    }
		    function handleNotification(message) {
		        if (isDisposed()) {
		            return;
		        }
		        let type = undefined;
		        let notificationHandler;
		        if (message.method === CancelNotification.type.method) {
		            const cancelId = message.params.id;
		            knownCanceledRequests.delete(cancelId);
		            traceReceivedNotification(message);
		            return;
		        }
		        else {
		            const element = notificationHandlers.get(message.method);
		            if (element) {
		                notificationHandler = element.handler;
		                type = element.type;
		            }
		        }
		        if (notificationHandler || starNotificationHandler) {
		            try {
		                traceReceivedNotification(message);
		                if (notificationHandler) {
		                    if (message.params === undefined) {
		                        if (type !== undefined) {
		                            if (type.numberOfParams !== 0 && type.parameterStructures !== messages_1.ParameterStructures.byName) {
		                                logger.error(`Notification ${message.method} defines ${type.numberOfParams} params but received none.`);
		                            }
		                        }
		                        notificationHandler();
		                    }
		                    else if (Array.isArray(message.params)) {
		                        const params = message.params;
		                        if (message.method === ProgressNotification.type.method && params.length === 2 && ProgressToken.is(params[0])) {
		                            notificationHandler({ token: params[0], value: params[1] });
		                        }
		                        else {
		                            if (type !== undefined) {
		                                if (type.parameterStructures === messages_1.ParameterStructures.byName) {
		                                    logger.error(`Notification ${message.method} defines parameters by name but received parameters by position`);
		                                }
		                                if (type.numberOfParams !== message.params.length) {
		                                    logger.error(`Notification ${message.method} defines ${type.numberOfParams} params but received ${params.length} arguments`);
		                                }
		                            }
		                            notificationHandler(...params);
		                        }
		                    }
		                    else {
		                        if (type !== undefined && type.parameterStructures === messages_1.ParameterStructures.byPosition) {
		                            logger.error(`Notification ${message.method} defines parameters by position but received parameters by name`);
		                        }
		                        notificationHandler(message.params);
		                    }
		                }
		                else if (starNotificationHandler) {
		                    starNotificationHandler(message.method, message.params);
		                }
		            }
		            catch (error) {
		                if (error.message) {
		                    logger.error(`Notification handler '${message.method}' failed with message: ${error.message}`);
		                }
		                else {
		                    logger.error(`Notification handler '${message.method}' failed unexpectedly.`);
		                }
		            }
		        }
		        else {
		            unhandledNotificationEmitter.fire(message);
		        }
		    }
		    function handleInvalidMessage(message) {
		        if (!message) {
		            logger.error('Received empty message.');
		            return;
		        }
		        logger.error(`Received message which is neither a response nor a notification message:\n${JSON.stringify(message, null, 4)}`);
		        const responseMessage = message;
		        if (Is.string(responseMessage.id) || Is.number(responseMessage.id)) {
		            const key = responseMessage.id;
		            const responseHandler = responsePromises.get(key);
		            if (responseHandler) {
		                responseHandler.reject(new Error('The received response has neither a result nor an error property.'));
		            }
		        }
		    }
		    function stringifyTrace(params) {
		        if (params === undefined || params === null) {
		            return undefined;
		        }
		        switch (trace) {
		            case Trace.Verbose:
		                return JSON.stringify(params, null, 4);
		            case Trace.Compact:
		                return JSON.stringify(params);
		            default:
		                return undefined;
		        }
		    }
		    function traceSendingRequest(message) {
		        if (trace === Trace.Off || !tracer) {
		            return;
		        }
		        if (traceFormat === TraceFormat.Text) {
		            let data = undefined;
		            if ((trace === Trace.Verbose || trace === Trace.Compact) && message.params) {
		                data = `Params: ${stringifyTrace(message.params)}\n\n`;
		            }
		            tracer.log(`Sending request '${message.method} - (${message.id})'.`, data);
		        }
		        else {
		            logLSPMessage('send-request', message);
		        }
		    }
		    function traceSendingNotification(message) {
		        if (trace === Trace.Off || !tracer) {
		            return;
		        }
		        if (traceFormat === TraceFormat.Text) {
		            let data = undefined;
		            if (trace === Trace.Verbose || trace === Trace.Compact) {
		                if (message.params) {
		                    data = `Params: ${stringifyTrace(message.params)}\n\n`;
		                }
		                else {
		                    data = 'No parameters provided.\n\n';
		                }
		            }
		            tracer.log(`Sending notification '${message.method}'.`, data);
		        }
		        else {
		            logLSPMessage('send-notification', message);
		        }
		    }
		    function traceSendingResponse(message, method, startTime) {
		        if (trace === Trace.Off || !tracer) {
		            return;
		        }
		        if (traceFormat === TraceFormat.Text) {
		            let data = undefined;
		            if (trace === Trace.Verbose || trace === Trace.Compact) {
		                if (message.error && message.error.data) {
		                    data = `Error data: ${stringifyTrace(message.error.data)}\n\n`;
		                }
		                else {
		                    if (message.result) {
		                        data = `Result: ${stringifyTrace(message.result)}\n\n`;
		                    }
		                    else if (message.error === undefined) {
		                        data = 'No result returned.\n\n';
		                    }
		                }
		            }
		            tracer.log(`Sending response '${method} - (${message.id})'. Processing request took ${Date.now() - startTime}ms`, data);
		        }
		        else {
		            logLSPMessage('send-response', message);
		        }
		    }
		    function traceReceivedRequest(message) {
		        if (trace === Trace.Off || !tracer) {
		            return;
		        }
		        if (traceFormat === TraceFormat.Text) {
		            let data = undefined;
		            if ((trace === Trace.Verbose || trace === Trace.Compact) && message.params) {
		                data = `Params: ${stringifyTrace(message.params)}\n\n`;
		            }
		            tracer.log(`Received request '${message.method} - (${message.id})'.`, data);
		        }
		        else {
		            logLSPMessage('receive-request', message);
		        }
		    }
		    function traceReceivedNotification(message) {
		        if (trace === Trace.Off || !tracer || message.method === LogTraceNotification.type.method) {
		            return;
		        }
		        if (traceFormat === TraceFormat.Text) {
		            let data = undefined;
		            if (trace === Trace.Verbose || trace === Trace.Compact) {
		                if (message.params) {
		                    data = `Params: ${stringifyTrace(message.params)}\n\n`;
		                }
		                else {
		                    data = 'No parameters provided.\n\n';
		                }
		            }
		            tracer.log(`Received notification '${message.method}'.`, data);
		        }
		        else {
		            logLSPMessage('receive-notification', message);
		        }
		    }
		    function traceReceivedResponse(message, responsePromise) {
		        if (trace === Trace.Off || !tracer) {
		            return;
		        }
		        if (traceFormat === TraceFormat.Text) {
		            let data = undefined;
		            if (trace === Trace.Verbose || trace === Trace.Compact) {
		                if (message.error && message.error.data) {
		                    data = `Error data: ${stringifyTrace(message.error.data)}\n\n`;
		                }
		                else {
		                    if (message.result) {
		                        data = `Result: ${stringifyTrace(message.result)}\n\n`;
		                    }
		                    else if (message.error === undefined) {
		                        data = 'No result returned.\n\n';
		                    }
		                }
		            }
		            if (responsePromise) {
		                const error = message.error ? ` Request failed: ${message.error.message} (${message.error.code}).` : '';
		                tracer.log(`Received response '${responsePromise.method} - (${message.id})' in ${Date.now() - responsePromise.timerStart}ms.${error}`, data);
		            }
		            else {
		                tracer.log(`Received response ${message.id} without active response promise.`, data);
		            }
		        }
		        else {
		            logLSPMessage('receive-response', message);
		        }
		    }
		    function logLSPMessage(type, message) {
		        if (!tracer || trace === Trace.Off) {
		            return;
		        }
		        const lspMessage = {
		            isLSPMessage: true,
		            type,
		            message,
		            timestamp: Date.now()
		        };
		        tracer.log(lspMessage);
		    }
		    function throwIfClosedOrDisposed() {
		        if (isClosed()) {
		            throw new ConnectionError(ConnectionErrors.Closed, 'Connection is closed.');
		        }
		        if (isDisposed()) {
		            throw new ConnectionError(ConnectionErrors.Disposed, 'Connection is disposed.');
		        }
		    }
		    function throwIfListening() {
		        if (isListening()) {
		            throw new ConnectionError(ConnectionErrors.AlreadyListening, 'Connection is already listening');
		        }
		    }
		    function throwIfNotListening() {
		        if (!isListening()) {
		            throw new Error('Call listen() first.');
		        }
		    }
		    function undefinedToNull(param) {
		        if (param === undefined) {
		            return null;
		        }
		        else {
		            return param;
		        }
		    }
		    function nullToUndefined(param) {
		        if (param === null) {
		            return undefined;
		        }
		        else {
		            return param;
		        }
		    }
		    function isNamedParam(param) {
		        return param !== undefined && param !== null && !Array.isArray(param) && typeof param === 'object';
		    }
		    function computeSingleParam(parameterStructures, param) {
		        switch (parameterStructures) {
		            case messages_1.ParameterStructures.auto:
		                if (isNamedParam(param)) {
		                    return nullToUndefined(param);
		                }
		                else {
		                    return [undefinedToNull(param)];
		                }
		            case messages_1.ParameterStructures.byName:
		                if (!isNamedParam(param)) {
		                    throw new Error(`Received parameters by name but param is not an object literal.`);
		                }
		                return nullToUndefined(param);
		            case messages_1.ParameterStructures.byPosition:
		                return [undefinedToNull(param)];
		            default:
		                throw new Error(`Unknown parameter structure ${parameterStructures.toString()}`);
		        }
		    }
		    function computeMessageParams(type, params) {
		        let result;
		        const numberOfParams = type.numberOfParams;
		        switch (numberOfParams) {
		            case 0:
		                result = undefined;
		                break;
		            case 1:
		                result = computeSingleParam(type.parameterStructures, params[0]);
		                break;
		            default:
		                result = [];
		                for (let i = 0; i < params.length && i < numberOfParams; i++) {
		                    result.push(undefinedToNull(params[i]));
		                }
		                if (params.length < numberOfParams) {
		                    for (let i = params.length; i < numberOfParams; i++) {
		                        result.push(null);
		                    }
		                }
		                break;
		        }
		        return result;
		    }
		    const connection = {
		        sendNotification: (type, ...args) => {
		            throwIfClosedOrDisposed();
		            let method;
		            let messageParams;
		            if (Is.string(type)) {
		                method = type;
		                const first = args[0];
		                let paramStart = 0;
		                let parameterStructures = messages_1.ParameterStructures.auto;
		                if (messages_1.ParameterStructures.is(first)) {
		                    paramStart = 1;
		                    parameterStructures = first;
		                }
		                let paramEnd = args.length;
		                const numberOfParams = paramEnd - paramStart;
		                switch (numberOfParams) {
		                    case 0:
		                        messageParams = undefined;
		                        break;
		                    case 1:
		                        messageParams = computeSingleParam(parameterStructures, args[paramStart]);
		                        break;
		                    default:
		                        if (parameterStructures === messages_1.ParameterStructures.byName) {
		                            throw new Error(`Received ${numberOfParams} parameters for 'by Name' notification parameter structure.`);
		                        }
		                        messageParams = args.slice(paramStart, paramEnd).map(value => undefinedToNull(value));
		                        break;
		                }
		            }
		            else {
		                const params = args;
		                method = type.method;
		                messageParams = computeMessageParams(type, params);
		            }
		            const notificationMessage = {
		                jsonrpc: version,
		                method: method,
		                params: messageParams
		            };
		            traceSendingNotification(notificationMessage);
		            return messageWriter.write(notificationMessage).catch((error) => {
		                logger.error(`Sending notification failed.`);
		                throw error;
		            });
		        },
		        onNotification: (type, handler) => {
		            throwIfClosedOrDisposed();
		            let method;
		            if (Is.func(type)) {
		                starNotificationHandler = type;
		            }
		            else if (handler) {
		                if (Is.string(type)) {
		                    method = type;
		                    notificationHandlers.set(type, { type: undefined, handler });
		                }
		                else {
		                    method = type.method;
		                    notificationHandlers.set(type.method, { type, handler });
		                }
		            }
		            return {
		                dispose: () => {
		                    if (method !== undefined) {
		                        notificationHandlers.delete(method);
		                    }
		                    else {
		                        starNotificationHandler = undefined;
		                    }
		                }
		            };
		        },
		        onProgress: (_type, token, handler) => {
		            if (progressHandlers.has(token)) {
		                throw new Error(`Progress handler for token ${token} already registered`);
		            }
		            progressHandlers.set(token, handler);
		            return {
		                dispose: () => {
		                    progressHandlers.delete(token);
		                }
		            };
		        },
		        sendProgress: (_type, token, value) => {
		            return connection.sendNotification(ProgressNotification.type, { token, value });
		        },
		        onUnhandledProgress: unhandledProgressEmitter.event,
		        sendRequest: (type, ...args) => {
		            throwIfClosedOrDisposed();
		            throwIfNotListening();
		            let method;
		            let messageParams;
		            let token = undefined;
		            if (Is.string(type)) {
		                method = type;
		                const first = args[0];
		                const last = args[args.length - 1];
		                let paramStart = 0;
		                let parameterStructures = messages_1.ParameterStructures.auto;
		                if (messages_1.ParameterStructures.is(first)) {
		                    paramStart = 1;
		                    parameterStructures = first;
		                }
		                let paramEnd = args.length;
		                if (cancellation_1.CancellationToken.is(last)) {
		                    paramEnd = paramEnd - 1;
		                    token = last;
		                }
		                const numberOfParams = paramEnd - paramStart;
		                switch (numberOfParams) {
		                    case 0:
		                        messageParams = undefined;
		                        break;
		                    case 1:
		                        messageParams = computeSingleParam(parameterStructures, args[paramStart]);
		                        break;
		                    default:
		                        if (parameterStructures === messages_1.ParameterStructures.byName) {
		                            throw new Error(`Received ${numberOfParams} parameters for 'by Name' request parameter structure.`);
		                        }
		                        messageParams = args.slice(paramStart, paramEnd).map(value => undefinedToNull(value));
		                        break;
		                }
		            }
		            else {
		                const params = args;
		                method = type.method;
		                messageParams = computeMessageParams(type, params);
		                const numberOfParams = type.numberOfParams;
		                token = cancellation_1.CancellationToken.is(params[numberOfParams]) ? params[numberOfParams] : undefined;
		            }
		            const id = sequenceNumber++;
		            let disposable;
		            if (token) {
		                disposable = token.onCancellationRequested(() => {
		                    const p = cancellationStrategy.sender.sendCancellation(connection, id);
		                    if (p === undefined) {
		                        logger.log(`Received no promise from cancellation strategy when cancelling id ${id}`);
		                        return Promise.resolve();
		                    }
		                    else {
		                        return p.catch(() => {
		                            logger.log(`Sending cancellation messages for id ${id} failed`);
		                        });
		                    }
		                });
		            }
		            const requestMessage = {
		                jsonrpc: version,
		                id: id,
		                method: method,
		                params: messageParams
		            };
		            traceSendingRequest(requestMessage);
		            if (typeof cancellationStrategy.sender.enableCancellation === 'function') {
		                cancellationStrategy.sender.enableCancellation(requestMessage);
		            }
		            return new Promise(async (resolve, reject) => {
		                const resolveWithCleanup = (r) => {
		                    resolve(r);
		                    cancellationStrategy.sender.cleanup(id);
		                    disposable?.dispose();
		                };
		                const rejectWithCleanup = (r) => {
		                    reject(r);
		                    cancellationStrategy.sender.cleanup(id);
		                    disposable?.dispose();
		                };
		                const responsePromise = { method: method, timerStart: Date.now(), resolve: resolveWithCleanup, reject: rejectWithCleanup };
		                try {
		                    await messageWriter.write(requestMessage);
		                    responsePromises.set(id, responsePromise);
		                }
		                catch (error) {
		                    logger.error(`Sending request failed.`);
		                    responsePromise.reject(new messages_1.ResponseError(messages_1.ErrorCodes.MessageWriteError, error.message ? error.message : 'Unknown reason'));
		                    throw error;
		                }
		            });
		        },
		        onRequest: (type, handler) => {
		            throwIfClosedOrDisposed();
		            let method = null;
		            if (StarRequestHandler.is(type)) {
		                method = undefined;
		                starRequestHandler = type;
		            }
		            else if (Is.string(type)) {
		                method = null;
		                if (handler !== undefined) {
		                    method = type;
		                    requestHandlers.set(type, { handler: handler, type: undefined });
		                }
		            }
		            else {
		                if (handler !== undefined) {
		                    method = type.method;
		                    requestHandlers.set(type.method, { type, handler });
		                }
		            }
		            return {
		                dispose: () => {
		                    if (method === null) {
		                        return;
		                    }
		                    if (method !== undefined) {
		                        requestHandlers.delete(method);
		                    }
		                    else {
		                        starRequestHandler = undefined;
		                    }
		                }
		            };
		        },
		        hasPendingResponse: () => {
		            return responsePromises.size > 0;
		        },
		        trace: async (_value, _tracer, sendNotificationOrTraceOptions) => {
		            let _sendNotification = false;
		            let _traceFormat = TraceFormat.Text;
		            if (sendNotificationOrTraceOptions !== undefined) {
		                if (Is.boolean(sendNotificationOrTraceOptions)) {
		                    _sendNotification = sendNotificationOrTraceOptions;
		                }
		                else {
		                    _sendNotification = sendNotificationOrTraceOptions.sendNotification || false;
		                    _traceFormat = sendNotificationOrTraceOptions.traceFormat || TraceFormat.Text;
		                }
		            }
		            trace = _value;
		            traceFormat = _traceFormat;
		            if (trace === Trace.Off) {
		                tracer = undefined;
		            }
		            else {
		                tracer = _tracer;
		            }
		            if (_sendNotification && !isClosed() && !isDisposed()) {
		                await connection.sendNotification(SetTraceNotification.type, { value: Trace.toString(_value) });
		            }
		        },
		        onError: errorEmitter.event,
		        onClose: closeEmitter.event,
		        onUnhandledNotification: unhandledNotificationEmitter.event,
		        onDispose: disposeEmitter.event,
		        end: () => {
		            messageWriter.end();
		        },
		        dispose: () => {
		            if (isDisposed()) {
		                return;
		            }
		            state = ConnectionState.Disposed;
		            disposeEmitter.fire(undefined);
		            const error = new messages_1.ResponseError(messages_1.ErrorCodes.PendingResponseRejected, 'Pending response rejected since connection got disposed');
		            for (const promise of responsePromises.values()) {
		                promise.reject(error);
		            }
		            responsePromises = new Map();
		            requestTokens = new Map();
		            knownCanceledRequests = new Set();
		            messageQueue = new linkedMap_1.LinkedMap();
		            if (Is.func(messageWriter.dispose)) {
		                messageWriter.dispose();
		            }
		            if (Is.func(messageReader.dispose)) {
		                messageReader.dispose();
		            }
		        },
		        listen: () => {
		            throwIfClosedOrDisposed();
		            throwIfListening();
		            state = ConnectionState.Listening;
		            messageReader.listen(callback);
		        },
		        inspect: () => {
		            (0, ral_1.default)().console.log('inspect');
		        }
		    };
		    connection.onNotification(LogTraceNotification.type, (params) => {
		        if (trace === Trace.Off || !tracer) {
		            return;
		        }
		        const verbose = trace === Trace.Verbose || trace === Trace.Compact;
		        tracer.log(params.message, verbose ? params.verbose : undefined);
		    });
		    connection.onNotification(ProgressNotification.type, (params) => {
		        const handler = progressHandlers.get(params.token);
		        if (handler) {
		            handler(params.value);
		        }
		        else {
		            unhandledProgressEmitter.fire(params);
		        }
		    });
		    return connection;
		}
		exports.createMessageConnection = createMessageConnection;
	} (connection$3));
	return connection$3;
}

var hasRequiredApi$1;
function requireApi$1 () {
	if (hasRequiredApi$1) return api$4;
	hasRequiredApi$1 = 1;
	(function (exports) {
		/// <reference path="../../typings/thenable.d.ts" />
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.ProgressType = exports.ProgressToken = exports.createMessageConnection = exports.NullLogger = exports.ConnectionOptions = exports.ConnectionStrategy = exports.AbstractMessageBuffer = exports.WriteableStreamMessageWriter = exports.AbstractMessageWriter = exports.MessageWriter = exports.ReadableStreamMessageReader = exports.AbstractMessageReader = exports.MessageReader = exports.SharedArrayReceiverStrategy = exports.SharedArraySenderStrategy = exports.CancellationToken = exports.CancellationTokenSource = exports.Emitter = exports.Event = exports.Disposable = exports.LRUCache = exports.Touch = exports.LinkedMap = exports.ParameterStructures = exports.NotificationType9 = exports.NotificationType8 = exports.NotificationType7 = exports.NotificationType6 = exports.NotificationType5 = exports.NotificationType4 = exports.NotificationType3 = exports.NotificationType2 = exports.NotificationType1 = exports.NotificationType0 = exports.NotificationType = exports.ErrorCodes = exports.ResponseError = exports.RequestType9 = exports.RequestType8 = exports.RequestType7 = exports.RequestType6 = exports.RequestType5 = exports.RequestType4 = exports.RequestType3 = exports.RequestType2 = exports.RequestType1 = exports.RequestType0 = exports.RequestType = exports.Message = exports.RAL = void 0;
		exports.MessageStrategy = exports.CancellationStrategy = exports.CancellationSenderStrategy = exports.CancellationReceiverStrategy = exports.ConnectionError = exports.ConnectionErrors = exports.LogTraceNotification = exports.SetTraceNotification = exports.TraceFormat = exports.TraceValues = exports.Trace = void 0;
		const messages_1 = requireMessages$1();
		Object.defineProperty(exports, "Message", { enumerable: true, get: function () { return messages_1.Message; } });
		Object.defineProperty(exports, "RequestType", { enumerable: true, get: function () { return messages_1.RequestType; } });
		Object.defineProperty(exports, "RequestType0", { enumerable: true, get: function () { return messages_1.RequestType0; } });
		Object.defineProperty(exports, "RequestType1", { enumerable: true, get: function () { return messages_1.RequestType1; } });
		Object.defineProperty(exports, "RequestType2", { enumerable: true, get: function () { return messages_1.RequestType2; } });
		Object.defineProperty(exports, "RequestType3", { enumerable: true, get: function () { return messages_1.RequestType3; } });
		Object.defineProperty(exports, "RequestType4", { enumerable: true, get: function () { return messages_1.RequestType4; } });
		Object.defineProperty(exports, "RequestType5", { enumerable: true, get: function () { return messages_1.RequestType5; } });
		Object.defineProperty(exports, "RequestType6", { enumerable: true, get: function () { return messages_1.RequestType6; } });
		Object.defineProperty(exports, "RequestType7", { enumerable: true, get: function () { return messages_1.RequestType7; } });
		Object.defineProperty(exports, "RequestType8", { enumerable: true, get: function () { return messages_1.RequestType8; } });
		Object.defineProperty(exports, "RequestType9", { enumerable: true, get: function () { return messages_1.RequestType9; } });
		Object.defineProperty(exports, "ResponseError", { enumerable: true, get: function () { return messages_1.ResponseError; } });
		Object.defineProperty(exports, "ErrorCodes", { enumerable: true, get: function () { return messages_1.ErrorCodes; } });
		Object.defineProperty(exports, "NotificationType", { enumerable: true, get: function () { return messages_1.NotificationType; } });
		Object.defineProperty(exports, "NotificationType0", { enumerable: true, get: function () { return messages_1.NotificationType0; } });
		Object.defineProperty(exports, "NotificationType1", { enumerable: true, get: function () { return messages_1.NotificationType1; } });
		Object.defineProperty(exports, "NotificationType2", { enumerable: true, get: function () { return messages_1.NotificationType2; } });
		Object.defineProperty(exports, "NotificationType3", { enumerable: true, get: function () { return messages_1.NotificationType3; } });
		Object.defineProperty(exports, "NotificationType4", { enumerable: true, get: function () { return messages_1.NotificationType4; } });
		Object.defineProperty(exports, "NotificationType5", { enumerable: true, get: function () { return messages_1.NotificationType5; } });
		Object.defineProperty(exports, "NotificationType6", { enumerable: true, get: function () { return messages_1.NotificationType6; } });
		Object.defineProperty(exports, "NotificationType7", { enumerable: true, get: function () { return messages_1.NotificationType7; } });
		Object.defineProperty(exports, "NotificationType8", { enumerable: true, get: function () { return messages_1.NotificationType8; } });
		Object.defineProperty(exports, "NotificationType9", { enumerable: true, get: function () { return messages_1.NotificationType9; } });
		Object.defineProperty(exports, "ParameterStructures", { enumerable: true, get: function () { return messages_1.ParameterStructures; } });
		const linkedMap_1 = requireLinkedMap$1();
		Object.defineProperty(exports, "LinkedMap", { enumerable: true, get: function () { return linkedMap_1.LinkedMap; } });
		Object.defineProperty(exports, "LRUCache", { enumerable: true, get: function () { return linkedMap_1.LRUCache; } });
		Object.defineProperty(exports, "Touch", { enumerable: true, get: function () { return linkedMap_1.Touch; } });
		const disposable_1 = requireDisposable();
		Object.defineProperty(exports, "Disposable", { enumerable: true, get: function () { return disposable_1.Disposable; } });
		const events_1 = requireEvents$1();
		Object.defineProperty(exports, "Event", { enumerable: true, get: function () { return events_1.Event; } });
		Object.defineProperty(exports, "Emitter", { enumerable: true, get: function () { return events_1.Emitter; } });
		const cancellation_1 = requireCancellation$1();
		Object.defineProperty(exports, "CancellationTokenSource", { enumerable: true, get: function () { return cancellation_1.CancellationTokenSource; } });
		Object.defineProperty(exports, "CancellationToken", { enumerable: true, get: function () { return cancellation_1.CancellationToken; } });
		const sharedArrayCancellation_1 = requireSharedArrayCancellation();
		Object.defineProperty(exports, "SharedArraySenderStrategy", { enumerable: true, get: function () { return sharedArrayCancellation_1.SharedArraySenderStrategy; } });
		Object.defineProperty(exports, "SharedArrayReceiverStrategy", { enumerable: true, get: function () { return sharedArrayCancellation_1.SharedArrayReceiverStrategy; } });
		const messageReader_1 = requireMessageReader$1();
		Object.defineProperty(exports, "MessageReader", { enumerable: true, get: function () { return messageReader_1.MessageReader; } });
		Object.defineProperty(exports, "AbstractMessageReader", { enumerable: true, get: function () { return messageReader_1.AbstractMessageReader; } });
		Object.defineProperty(exports, "ReadableStreamMessageReader", { enumerable: true, get: function () { return messageReader_1.ReadableStreamMessageReader; } });
		const messageWriter_1 = requireMessageWriter$1();
		Object.defineProperty(exports, "MessageWriter", { enumerable: true, get: function () { return messageWriter_1.MessageWriter; } });
		Object.defineProperty(exports, "AbstractMessageWriter", { enumerable: true, get: function () { return messageWriter_1.AbstractMessageWriter; } });
		Object.defineProperty(exports, "WriteableStreamMessageWriter", { enumerable: true, get: function () { return messageWriter_1.WriteableStreamMessageWriter; } });
		const messageBuffer_1 = requireMessageBuffer();
		Object.defineProperty(exports, "AbstractMessageBuffer", { enumerable: true, get: function () { return messageBuffer_1.AbstractMessageBuffer; } });
		const connection_1 = requireConnection$1();
		Object.defineProperty(exports, "ConnectionStrategy", { enumerable: true, get: function () { return connection_1.ConnectionStrategy; } });
		Object.defineProperty(exports, "ConnectionOptions", { enumerable: true, get: function () { return connection_1.ConnectionOptions; } });
		Object.defineProperty(exports, "NullLogger", { enumerable: true, get: function () { return connection_1.NullLogger; } });
		Object.defineProperty(exports, "createMessageConnection", { enumerable: true, get: function () { return connection_1.createMessageConnection; } });
		Object.defineProperty(exports, "ProgressToken", { enumerable: true, get: function () { return connection_1.ProgressToken; } });
		Object.defineProperty(exports, "ProgressType", { enumerable: true, get: function () { return connection_1.ProgressType; } });
		Object.defineProperty(exports, "Trace", { enumerable: true, get: function () { return connection_1.Trace; } });
		Object.defineProperty(exports, "TraceValues", { enumerable: true, get: function () { return connection_1.TraceValues; } });
		Object.defineProperty(exports, "TraceFormat", { enumerable: true, get: function () { return connection_1.TraceFormat; } });
		Object.defineProperty(exports, "SetTraceNotification", { enumerable: true, get: function () { return connection_1.SetTraceNotification; } });
		Object.defineProperty(exports, "LogTraceNotification", { enumerable: true, get: function () { return connection_1.LogTraceNotification; } });
		Object.defineProperty(exports, "ConnectionErrors", { enumerable: true, get: function () { return connection_1.ConnectionErrors; } });
		Object.defineProperty(exports, "ConnectionError", { enumerable: true, get: function () { return connection_1.ConnectionError; } });
		Object.defineProperty(exports, "CancellationReceiverStrategy", { enumerable: true, get: function () { return connection_1.CancellationReceiverStrategy; } });
		Object.defineProperty(exports, "CancellationSenderStrategy", { enumerable: true, get: function () { return connection_1.CancellationSenderStrategy; } });
		Object.defineProperty(exports, "CancellationStrategy", { enumerable: true, get: function () { return connection_1.CancellationStrategy; } });
		Object.defineProperty(exports, "MessageStrategy", { enumerable: true, get: function () { return connection_1.MessageStrategy; } });
		const ral_1 = requireRal();
		exports.RAL = ral_1.default;
	} (api$4));
	return api$4;
}

Object.defineProperty(ril$1, "__esModule", { value: true });
const util_1$2 = require$$1$2;
const api_1 = requireApi$1();
let MessageBuffer$1 = class MessageBuffer extends api_1.AbstractMessageBuffer {
    constructor(encoding = 'utf-8') {
        super(encoding);
    }
    emptyBuffer() {
        return MessageBuffer$1.emptyBuffer;
    }
    fromString(value, encoding) {
        return Buffer.from(value, encoding);
    }
    toString(value, encoding) {
        if (value instanceof Buffer) {
            return value.toString(encoding);
        }
        else {
            return new util_1$2.TextDecoder(encoding).decode(value);
        }
    }
    asNative(buffer, length) {
        if (length === undefined) {
            return buffer instanceof Buffer ? buffer : Buffer.from(buffer);
        }
        else {
            return buffer instanceof Buffer ? buffer.slice(0, length) : Buffer.from(buffer, 0, length);
        }
    }
    allocNative(length) {
        return Buffer.allocUnsafe(length);
    }
};
MessageBuffer$1.emptyBuffer = Buffer.allocUnsafe(0);
let ReadableStreamWrapper$1 = class ReadableStreamWrapper {
    constructor(stream) {
        this.stream = stream;
    }
    onClose(listener) {
        this.stream.on('close', listener);
        return api_1.Disposable.create(() => this.stream.off('close', listener));
    }
    onError(listener) {
        this.stream.on('error', listener);
        return api_1.Disposable.create(() => this.stream.off('error', listener));
    }
    onEnd(listener) {
        this.stream.on('end', listener);
        return api_1.Disposable.create(() => this.stream.off('end', listener));
    }
    onData(listener) {
        this.stream.on('data', listener);
        return api_1.Disposable.create(() => this.stream.off('data', listener));
    }
};
let WritableStreamWrapper$1 = class WritableStreamWrapper {
    constructor(stream) {
        this.stream = stream;
    }
    onClose(listener) {
        this.stream.on('close', listener);
        return api_1.Disposable.create(() => this.stream.off('close', listener));
    }
    onError(listener) {
        this.stream.on('error', listener);
        return api_1.Disposable.create(() => this.stream.off('error', listener));
    }
    onEnd(listener) {
        this.stream.on('end', listener);
        return api_1.Disposable.create(() => this.stream.off('end', listener));
    }
    write(data, encoding) {
        return new Promise((resolve, reject) => {
            const callback = (error) => {
                if (error === undefined || error === null) {
                    resolve();
                }
                else {
                    reject(error);
                }
            };
            if (typeof data === 'string') {
                this.stream.write(data, encoding, callback);
            }
            else {
                this.stream.write(data, callback);
            }
        });
    }
    end() {
        this.stream.end();
    }
};
const _ril$1 = Object.freeze({
    messageBuffer: Object.freeze({
        create: (encoding) => new MessageBuffer$1(encoding)
    }),
    applicationJson: Object.freeze({
        encoder: Object.freeze({
            name: 'application/json',
            encode: (msg, options) => {
                try {
                    return Promise.resolve(Buffer.from(JSON.stringify(msg, undefined, 0), options.charset));
                }
                catch (err) {
                    return Promise.reject(err);
                }
            }
        }),
        decoder: Object.freeze({
            name: 'application/json',
            decode: (buffer, options) => {
                try {
                    if (buffer instanceof Buffer) {
                        return Promise.resolve(JSON.parse(buffer.toString(options.charset)));
                    }
                    else {
                        return Promise.resolve(JSON.parse(new util_1$2.TextDecoder(options.charset).decode(buffer)));
                    }
                }
                catch (err) {
                    return Promise.reject(err);
                }
            }
        })
    }),
    stream: Object.freeze({
        asReadableStream: (stream) => new ReadableStreamWrapper$1(stream),
        asWritableStream: (stream) => new WritableStreamWrapper$1(stream)
    }),
    console: console,
    timer: Object.freeze({
        setTimeout(callback, ms, ...args) {
            const handle = setTimeout(callback, ms, ...args);
            return { dispose: () => clearTimeout(handle) };
        },
        setImmediate(callback, ...args) {
            const handle = setImmediate(callback, ...args);
            return { dispose: () => clearImmediate(handle) };
        },
        setInterval(callback, ms, ...args) {
            const handle = setInterval(callback, ms, ...args);
            return { dispose: () => clearInterval(handle) };
        }
    })
});
function RIL$1() {
    return _ril$1;
}
(function (RIL) {
    function install() {
        api_1.RAL.install(_ril$1);
    }
    RIL.install = install;
})(RIL$1 || (RIL$1 = {}));
ril$1.default = RIL$1;

(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    var desc = Object.getOwnPropertyDescriptor(m, k);
	    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	      desc = { enumerable: true, get: function() { return m[k]; } };
	    }
	    Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createMessageConnection = exports.createServerSocketTransport = exports.createClientSocketTransport = exports.createServerPipeTransport = exports.createClientPipeTransport = exports.generateRandomPipeName = exports.StreamMessageWriter = exports.StreamMessageReader = exports.SocketMessageWriter = exports.SocketMessageReader = exports.PortMessageWriter = exports.PortMessageReader = exports.IPCMessageWriter = exports.IPCMessageReader = void 0;
	const ril_1 = ril$1;
	ril_1.default.install();
	const path = path$1;
	const os = require$$2$1;
	const crypto_1 = require$$3;
	const net_1 = require$$4;
	const api_1 = requireApi$1();
	__exportStar(requireApi$1(), exports);
	class IPCMessageReader extends api_1.AbstractMessageReader {
	    constructor(process) {
	        super();
	        this.process = process;
	        let eventEmitter = this.process;
	        eventEmitter.on('error', (error) => this.fireError(error));
	        eventEmitter.on('close', () => this.fireClose());
	    }
	    listen(callback) {
	        this.process.on('message', callback);
	        return api_1.Disposable.create(() => this.process.off('message', callback));
	    }
	}
	exports.IPCMessageReader = IPCMessageReader;
	class IPCMessageWriter extends api_1.AbstractMessageWriter {
	    constructor(process) {
	        super();
	        this.process = process;
	        this.errorCount = 0;
	        const eventEmitter = this.process;
	        eventEmitter.on('error', (error) => this.fireError(error));
	        eventEmitter.on('close', () => this.fireClose);
	    }
	    write(msg) {
	        try {
	            if (typeof this.process.send === 'function') {
	                this.process.send(msg, undefined, undefined, (error) => {
	                    if (error) {
	                        this.errorCount++;
	                        this.handleError(error, msg);
	                    }
	                    else {
	                        this.errorCount = 0;
	                    }
	                });
	            }
	            return Promise.resolve();
	        }
	        catch (error) {
	            this.handleError(error, msg);
	            return Promise.reject(error);
	        }
	    }
	    handleError(error, msg) {
	        this.errorCount++;
	        this.fireError(error, msg, this.errorCount);
	    }
	    end() {
	    }
	}
	exports.IPCMessageWriter = IPCMessageWriter;
	class PortMessageReader extends api_1.AbstractMessageReader {
	    constructor(port) {
	        super();
	        this.onData = new api_1.Emitter;
	        port.on('close', () => this.fireClose);
	        port.on('error', (error) => this.fireError(error));
	        port.on('message', (message) => {
	            this.onData.fire(message);
	        });
	    }
	    listen(callback) {
	        return this.onData.event(callback);
	    }
	}
	exports.PortMessageReader = PortMessageReader;
	class PortMessageWriter extends api_1.AbstractMessageWriter {
	    constructor(port) {
	        super();
	        this.port = port;
	        this.errorCount = 0;
	        port.on('close', () => this.fireClose());
	        port.on('error', (error) => this.fireError(error));
	    }
	    write(msg) {
	        try {
	            this.port.postMessage(msg);
	            return Promise.resolve();
	        }
	        catch (error) {
	            this.handleError(error, msg);
	            return Promise.reject(error);
	        }
	    }
	    handleError(error, msg) {
	        this.errorCount++;
	        this.fireError(error, msg, this.errorCount);
	    }
	    end() {
	    }
	}
	exports.PortMessageWriter = PortMessageWriter;
	class SocketMessageReader extends api_1.ReadableStreamMessageReader {
	    constructor(socket, encoding = 'utf-8') {
	        super((0, ril_1.default)().stream.asReadableStream(socket), encoding);
	    }
	}
	exports.SocketMessageReader = SocketMessageReader;
	class SocketMessageWriter extends api_1.WriteableStreamMessageWriter {
	    constructor(socket, options) {
	        super((0, ril_1.default)().stream.asWritableStream(socket), options);
	        this.socket = socket;
	    }
	    dispose() {
	        super.dispose();
	        this.socket.destroy();
	    }
	}
	exports.SocketMessageWriter = SocketMessageWriter;
	class StreamMessageReader extends api_1.ReadableStreamMessageReader {
	    constructor(readable, encoding) {
	        super((0, ril_1.default)().stream.asReadableStream(readable), encoding);
	    }
	}
	exports.StreamMessageReader = StreamMessageReader;
	class StreamMessageWriter extends api_1.WriteableStreamMessageWriter {
	    constructor(writable, options) {
	        super((0, ril_1.default)().stream.asWritableStream(writable), options);
	    }
	}
	exports.StreamMessageWriter = StreamMessageWriter;
	const XDG_RUNTIME_DIR = process.env['XDG_RUNTIME_DIR'];
	const safeIpcPathLengths = new Map([
	    ['linux', 107],
	    ['darwin', 103]
	]);
	function generateRandomPipeName() {
	    const randomSuffix = (0, crypto_1.randomBytes)(21).toString('hex');
	    if (process.platform === 'win32') {
	        return `\\\\.\\pipe\\vscode-jsonrpc-${randomSuffix}-sock`;
	    }
	    let result;
	    if (XDG_RUNTIME_DIR) {
	        result = path.join(XDG_RUNTIME_DIR, `vscode-ipc-${randomSuffix}.sock`);
	    }
	    else {
	        result = path.join(os.tmpdir(), `vscode-${randomSuffix}.sock`);
	    }
	    const limit = safeIpcPathLengths.get(process.platform);
	    if (limit !== undefined && result.length > limit) {
	        (0, ril_1.default)().console.warn(`WARNING: IPC handle "${result}" is longer than ${limit} characters.`);
	    }
	    return result;
	}
	exports.generateRandomPipeName = generateRandomPipeName;
	function createClientPipeTransport(pipeName, encoding = 'utf-8') {
	    let connectResolve;
	    const connected = new Promise((resolve, _reject) => {
	        connectResolve = resolve;
	    });
	    return new Promise((resolve, reject) => {
	        let server = (0, net_1.createServer)((socket) => {
	            server.close();
	            connectResolve([
	                new SocketMessageReader(socket, encoding),
	                new SocketMessageWriter(socket, encoding)
	            ]);
	        });
	        server.on('error', reject);
	        server.listen(pipeName, () => {
	            server.removeListener('error', reject);
	            resolve({
	                onConnected: () => { return connected; }
	            });
	        });
	    });
	}
	exports.createClientPipeTransport = createClientPipeTransport;
	function createServerPipeTransport(pipeName, encoding = 'utf-8') {
	    const socket = (0, net_1.createConnection)(pipeName);
	    return [
	        new SocketMessageReader(socket, encoding),
	        new SocketMessageWriter(socket, encoding)
	    ];
	}
	exports.createServerPipeTransport = createServerPipeTransport;
	function createClientSocketTransport(port, encoding = 'utf-8') {
	    let connectResolve;
	    const connected = new Promise((resolve, _reject) => {
	        connectResolve = resolve;
	    });
	    return new Promise((resolve, reject) => {
	        const server = (0, net_1.createServer)((socket) => {
	            server.close();
	            connectResolve([
	                new SocketMessageReader(socket, encoding),
	                new SocketMessageWriter(socket, encoding)
	            ]);
	        });
	        server.on('error', reject);
	        server.listen(port, '127.0.0.1', () => {
	            server.removeListener('error', reject);
	            resolve({
	                onConnected: () => { return connected; }
	            });
	        });
	    });
	}
	exports.createClientSocketTransport = createClientSocketTransport;
	function createServerSocketTransport(port, encoding = 'utf-8') {
	    const socket = (0, net_1.createConnection)(port, '127.0.0.1');
	    return [
	        new SocketMessageReader(socket, encoding),
	        new SocketMessageWriter(socket, encoding)
	    ];
	}
	exports.createServerSocketTransport = createServerSocketTransport;
	function isReadableStream(value) {
	    const candidate = value;
	    return candidate.read !== undefined && candidate.addListener !== undefined;
	}
	function isWritableStream(value) {
	    const candidate = value;
	    return candidate.write !== undefined && candidate.addListener !== undefined;
	}
	function createMessageConnection(input, output, logger, options) {
	    if (!logger) {
	        logger = api_1.NullLogger;
	    }
	    const reader = isReadableStream(input) ? new StreamMessageReader(input) : input;
	    const writer = isWritableStream(output) ? new StreamMessageWriter(output) : output;
	    if (api_1.ConnectionStrategy.is(options)) {
	        options = { connectionStrategy: options };
	    }
	    return (0, api_1.createMessageConnection)(reader, writer, logger, options);
	}
	exports.createMessageConnection = createMessageConnection;
} (main$6));
getDefaultExportFromCjs(main$6);

var node$3 = main$6;
getDefaultExportFromCjs(node$3);

var api$3 = {};

function commonjsRequire(path) {
	throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}

var main$5 = {exports: {}};

main$5.exports;
(function (module, exports) {
	(function (factory) {
	    {
	        var v = factory(commonjsRequire, exports);
	        if (v !== undefined) module.exports = v;
	    }
	})(function (require, exports) {
	    Object.defineProperty(exports, "__esModule", { value: true });
	    exports.TextDocument = exports.EOL = exports.WorkspaceFolder = exports.InlineCompletionContext = exports.SelectedCompletionInfo = exports.InlineCompletionTriggerKind = exports.InlineCompletionList = exports.InlineCompletionItem = exports.StringValue = exports.InlayHint = exports.InlayHintLabelPart = exports.InlayHintKind = exports.InlineValueContext = exports.InlineValueEvaluatableExpression = exports.InlineValueVariableLookup = exports.InlineValueText = exports.SemanticTokens = exports.SemanticTokenModifiers = exports.SemanticTokenTypes = exports.SelectionRange = exports.DocumentLink = exports.FormattingOptions = exports.CodeLens = exports.CodeAction = exports.CodeActionContext = exports.CodeActionTriggerKind = exports.CodeActionKind = exports.DocumentSymbol = exports.WorkspaceSymbol = exports.SymbolInformation = exports.SymbolTag = exports.SymbolKind = exports.DocumentHighlight = exports.DocumentHighlightKind = exports.SignatureInformation = exports.ParameterInformation = exports.Hover = exports.MarkedString = exports.CompletionList = exports.CompletionItem = exports.CompletionItemLabelDetails = exports.InsertTextMode = exports.InsertReplaceEdit = exports.CompletionItemTag = exports.InsertTextFormat = exports.CompletionItemKind = exports.MarkupContent = exports.MarkupKind = exports.TextDocumentItem = exports.OptionalVersionedTextDocumentIdentifier = exports.VersionedTextDocumentIdentifier = exports.TextDocumentIdentifier = exports.WorkspaceChange = exports.WorkspaceEdit = exports.DeleteFile = exports.RenameFile = exports.CreateFile = exports.TextDocumentEdit = exports.AnnotatedTextEdit = exports.ChangeAnnotationIdentifier = exports.ChangeAnnotation = exports.TextEdit = exports.Command = exports.Diagnostic = exports.CodeDescription = exports.DiagnosticTag = exports.DiagnosticSeverity = exports.DiagnosticRelatedInformation = exports.FoldingRange = exports.FoldingRangeKind = exports.ColorPresentation = exports.ColorInformation = exports.Color = exports.LocationLink = exports.Location = exports.Range = exports.Position = exports.uinteger = exports.integer = exports.URI = exports.DocumentUri = void 0;
	    var DocumentUri;
	    (function (DocumentUri) {
	        function is(value) {
	            return typeof value === 'string';
	        }
	        DocumentUri.is = is;
	    })(DocumentUri || (exports.DocumentUri = DocumentUri = {}));
	    var URI;
	    (function (URI) {
	        function is(value) {
	            return typeof value === 'string';
	        }
	        URI.is = is;
	    })(URI || (exports.URI = URI = {}));
	    var integer;
	    (function (integer) {
	        integer.MIN_VALUE = -2147483648;
	        integer.MAX_VALUE = 2147483647;
	        function is(value) {
	            return typeof value === 'number' && integer.MIN_VALUE <= value && value <= integer.MAX_VALUE;
	        }
	        integer.is = is;
	    })(integer || (exports.integer = integer = {}));
	    var uinteger;
	    (function (uinteger) {
	        uinteger.MIN_VALUE = 0;
	        uinteger.MAX_VALUE = 2147483647;
	        function is(value) {
	            return typeof value === 'number' && uinteger.MIN_VALUE <= value && value <= uinteger.MAX_VALUE;
	        }
	        uinteger.is = is;
	    })(uinteger || (exports.uinteger = uinteger = {}));
	    var Position;
	    (function (Position) {
	        function create(line, character) {
	            if (line === Number.MAX_VALUE) {
	                line = uinteger.MAX_VALUE;
	            }
	            if (character === Number.MAX_VALUE) {
	                character = uinteger.MAX_VALUE;
	            }
	            return { line: line, character: character };
	        }
	        Position.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Is.uinteger(candidate.line) && Is.uinteger(candidate.character);
	        }
	        Position.is = is;
	    })(Position || (exports.Position = Position = {}));
	    var Range;
	    (function (Range) {
	        function create(one, two, three, four) {
	            if (Is.uinteger(one) && Is.uinteger(two) && Is.uinteger(three) && Is.uinteger(four)) {
	                return { start: Position.create(one, two), end: Position.create(three, four) };
	            }
	            else if (Position.is(one) && Position.is(two)) {
	                return { start: one, end: two };
	            }
	            else {
	                throw new Error("Range#create called with invalid arguments[".concat(one, ", ").concat(two, ", ").concat(three, ", ").concat(four, "]"));
	            }
	        }
	        Range.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
	        }
	        Range.is = is;
	    })(Range || (exports.Range = Range = {}));
	    var Location;
	    (function (Location) {
	        function create(uri, range) {
	            return { uri: uri, range: range };
	        }
	        Location.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
	        }
	        Location.is = is;
	    })(Location || (exports.Location = Location = {}));
	    var LocationLink;
	    (function (LocationLink) {
	        function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
	            return { targetUri: targetUri, targetRange: targetRange, targetSelectionRange: targetSelectionRange, originSelectionRange: originSelectionRange };
	        }
	        LocationLink.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri)
	                && Range.is(candidate.targetSelectionRange)
	                && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
	        }
	        LocationLink.is = is;
	    })(LocationLink || (exports.LocationLink = LocationLink = {}));
	    var Color;
	    (function (Color) {
	        function create(red, green, blue, alpha) {
	            return {
	                red: red,
	                green: green,
	                blue: blue,
	                alpha: alpha,
	            };
	        }
	        Color.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Is.numberRange(candidate.red, 0, 1)
	                && Is.numberRange(candidate.green, 0, 1)
	                && Is.numberRange(candidate.blue, 0, 1)
	                && Is.numberRange(candidate.alpha, 0, 1);
	        }
	        Color.is = is;
	    })(Color || (exports.Color = Color = {}));
	    var ColorInformation;
	    (function (ColorInformation) {
	        function create(range, color) {
	            return {
	                range: range,
	                color: color,
	            };
	        }
	        ColorInformation.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Range.is(candidate.range) && Color.is(candidate.color);
	        }
	        ColorInformation.is = is;
	    })(ColorInformation || (exports.ColorInformation = ColorInformation = {}));
	    var ColorPresentation;
	    (function (ColorPresentation) {
	        function create(label, textEdit, additionalTextEdits) {
	            return {
	                label: label,
	                textEdit: textEdit,
	                additionalTextEdits: additionalTextEdits,
	            };
	        }
	        ColorPresentation.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Is.string(candidate.label)
	                && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate))
	                && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
	        }
	        ColorPresentation.is = is;
	    })(ColorPresentation || (exports.ColorPresentation = ColorPresentation = {}));
	    var FoldingRangeKind;
	    (function (FoldingRangeKind) {
	        FoldingRangeKind.Comment = 'comment';
	        FoldingRangeKind.Imports = 'imports';
	        FoldingRangeKind.Region = 'region';
	    })(FoldingRangeKind || (exports.FoldingRangeKind = FoldingRangeKind = {}));
	    var FoldingRange;
	    (function (FoldingRange) {
	        function create(startLine, endLine, startCharacter, endCharacter, kind, collapsedText) {
	            var result = {
	                startLine: startLine,
	                endLine: endLine
	            };
	            if (Is.defined(startCharacter)) {
	                result.startCharacter = startCharacter;
	            }
	            if (Is.defined(endCharacter)) {
	                result.endCharacter = endCharacter;
	            }
	            if (Is.defined(kind)) {
	                result.kind = kind;
	            }
	            if (Is.defined(collapsedText)) {
	                result.collapsedText = collapsedText;
	            }
	            return result;
	        }
	        FoldingRange.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Is.uinteger(candidate.startLine) && Is.uinteger(candidate.startLine)
	                && (Is.undefined(candidate.startCharacter) || Is.uinteger(candidate.startCharacter))
	                && (Is.undefined(candidate.endCharacter) || Is.uinteger(candidate.endCharacter))
	                && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
	        }
	        FoldingRange.is = is;
	    })(FoldingRange || (exports.FoldingRange = FoldingRange = {}));
	    var DiagnosticRelatedInformation;
	    (function (DiagnosticRelatedInformation) {
	        function create(location, message) {
	            return {
	                location: location,
	                message: message
	            };
	        }
	        DiagnosticRelatedInformation.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
	        }
	        DiagnosticRelatedInformation.is = is;
	    })(DiagnosticRelatedInformation || (exports.DiagnosticRelatedInformation = DiagnosticRelatedInformation = {}));
	    var DiagnosticSeverity;
	    (function (DiagnosticSeverity) {
	        DiagnosticSeverity.Error = 1;
	        DiagnosticSeverity.Warning = 2;
	        DiagnosticSeverity.Information = 3;
	        DiagnosticSeverity.Hint = 4;
	    })(DiagnosticSeverity || (exports.DiagnosticSeverity = DiagnosticSeverity = {}));
	    var DiagnosticTag;
	    (function (DiagnosticTag) {
	        DiagnosticTag.Unnecessary = 1;
	        DiagnosticTag.Deprecated = 2;
	    })(DiagnosticTag || (exports.DiagnosticTag = DiagnosticTag = {}));
	    var CodeDescription;
	    (function (CodeDescription) {
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Is.string(candidate.href);
	        }
	        CodeDescription.is = is;
	    })(CodeDescription || (exports.CodeDescription = CodeDescription = {}));
	    var Diagnostic;
	    (function (Diagnostic) {
	        function create(range, message, severity, code, source, relatedInformation) {
	            var result = { range: range, message: message };
	            if (Is.defined(severity)) {
	                result.severity = severity;
	            }
	            if (Is.defined(code)) {
	                result.code = code;
	            }
	            if (Is.defined(source)) {
	                result.source = source;
	            }
	            if (Is.defined(relatedInformation)) {
	                result.relatedInformation = relatedInformation;
	            }
	            return result;
	        }
	        Diagnostic.create = create;
	        function is(value) {
	            var _a;
	            var candidate = value;
	            return Is.defined(candidate)
	                && Range.is(candidate.range)
	                && Is.string(candidate.message)
	                && (Is.number(candidate.severity) || Is.undefined(candidate.severity))
	                && (Is.integer(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code))
	                && (Is.undefined(candidate.codeDescription) || (Is.string((_a = candidate.codeDescription) === null || _a === void 0 ? void 0 : _a.href)))
	                && (Is.string(candidate.source) || Is.undefined(candidate.source))
	                && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
	        }
	        Diagnostic.is = is;
	    })(Diagnostic || (exports.Diagnostic = Diagnostic = {}));
	    var Command;
	    (function (Command) {
	        function create(title, command) {
	            var args = [];
	            for (var _i = 2; _i < arguments.length; _i++) {
	                args[_i - 2] = arguments[_i];
	            }
	            var result = { title: title, command: command };
	            if (Is.defined(args) && args.length > 0) {
	                result.arguments = args;
	            }
	            return result;
	        }
	        Command.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
	        }
	        Command.is = is;
	    })(Command || (exports.Command = Command = {}));
	    var TextEdit;
	    (function (TextEdit) {
	        function replace(range, newText) {
	            return { range: range, newText: newText };
	        }
	        TextEdit.replace = replace;
	        function insert(position, newText) {
	            return { range: { start: position, end: position }, newText: newText };
	        }
	        TextEdit.insert = insert;
	        function del(range) {
	            return { range: range, newText: '' };
	        }
	        TextEdit.del = del;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate)
	                && Is.string(candidate.newText)
	                && Range.is(candidate.range);
	        }
	        TextEdit.is = is;
	    })(TextEdit || (exports.TextEdit = TextEdit = {}));
	    var ChangeAnnotation;
	    (function (ChangeAnnotation) {
	        function create(label, needsConfirmation, description) {
	            var result = { label: label };
	            if (needsConfirmation !== undefined) {
	                result.needsConfirmation = needsConfirmation;
	            }
	            if (description !== undefined) {
	                result.description = description;
	            }
	            return result;
	        }
	        ChangeAnnotation.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Is.string(candidate.label) &&
	                (Is.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === undefined) &&
	                (Is.string(candidate.description) || candidate.description === undefined);
	        }
	        ChangeAnnotation.is = is;
	    })(ChangeAnnotation || (exports.ChangeAnnotation = ChangeAnnotation = {}));
	    var ChangeAnnotationIdentifier;
	    (function (ChangeAnnotationIdentifier) {
	        function is(value) {
	            var candidate = value;
	            return Is.string(candidate);
	        }
	        ChangeAnnotationIdentifier.is = is;
	    })(ChangeAnnotationIdentifier || (exports.ChangeAnnotationIdentifier = ChangeAnnotationIdentifier = {}));
	    var AnnotatedTextEdit;
	    (function (AnnotatedTextEdit) {
	        function replace(range, newText, annotation) {
	            return { range: range, newText: newText, annotationId: annotation };
	        }
	        AnnotatedTextEdit.replace = replace;
	        function insert(position, newText, annotation) {
	            return { range: { start: position, end: position }, newText: newText, annotationId: annotation };
	        }
	        AnnotatedTextEdit.insert = insert;
	        function del(range, annotation) {
	            return { range: range, newText: '', annotationId: annotation };
	        }
	        AnnotatedTextEdit.del = del;
	        function is(value) {
	            var candidate = value;
	            return TextEdit.is(candidate) && (ChangeAnnotation.is(candidate.annotationId) || ChangeAnnotationIdentifier.is(candidate.annotationId));
	        }
	        AnnotatedTextEdit.is = is;
	    })(AnnotatedTextEdit || (exports.AnnotatedTextEdit = AnnotatedTextEdit = {}));
	    var TextDocumentEdit;
	    (function (TextDocumentEdit) {
	        function create(textDocument, edits) {
	            return { textDocument: textDocument, edits: edits };
	        }
	        TextDocumentEdit.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate)
	                && OptionalVersionedTextDocumentIdentifier.is(candidate.textDocument)
	                && Array.isArray(candidate.edits);
	        }
	        TextDocumentEdit.is = is;
	    })(TextDocumentEdit || (exports.TextDocumentEdit = TextDocumentEdit = {}));
	    var CreateFile;
	    (function (CreateFile) {
	        function create(uri, options, annotation) {
	            var result = {
	                kind: 'create',
	                uri: uri
	            };
	            if (options !== undefined && (options.overwrite !== undefined || options.ignoreIfExists !== undefined)) {
	                result.options = options;
	            }
	            if (annotation !== undefined) {
	                result.annotationId = annotation;
	            }
	            return result;
	        }
	        CreateFile.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate && candidate.kind === 'create' && Is.string(candidate.uri) && (candidate.options === undefined ||
	                ((candidate.options.overwrite === undefined || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === undefined || Is.boolean(candidate.options.ignoreIfExists)))) && (candidate.annotationId === undefined || ChangeAnnotationIdentifier.is(candidate.annotationId));
	        }
	        CreateFile.is = is;
	    })(CreateFile || (exports.CreateFile = CreateFile = {}));
	    var RenameFile;
	    (function (RenameFile) {
	        function create(oldUri, newUri, options, annotation) {
	            var result = {
	                kind: 'rename',
	                oldUri: oldUri,
	                newUri: newUri
	            };
	            if (options !== undefined && (options.overwrite !== undefined || options.ignoreIfExists !== undefined)) {
	                result.options = options;
	            }
	            if (annotation !== undefined) {
	                result.annotationId = annotation;
	            }
	            return result;
	        }
	        RenameFile.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate && candidate.kind === 'rename' && Is.string(candidate.oldUri) && Is.string(candidate.newUri) && (candidate.options === undefined ||
	                ((candidate.options.overwrite === undefined || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === undefined || Is.boolean(candidate.options.ignoreIfExists)))) && (candidate.annotationId === undefined || ChangeAnnotationIdentifier.is(candidate.annotationId));
	        }
	        RenameFile.is = is;
	    })(RenameFile || (exports.RenameFile = RenameFile = {}));
	    var DeleteFile;
	    (function (DeleteFile) {
	        function create(uri, options, annotation) {
	            var result = {
	                kind: 'delete',
	                uri: uri
	            };
	            if (options !== undefined && (options.recursive !== undefined || options.ignoreIfNotExists !== undefined)) {
	                result.options = options;
	            }
	            if (annotation !== undefined) {
	                result.annotationId = annotation;
	            }
	            return result;
	        }
	        DeleteFile.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate && candidate.kind === 'delete' && Is.string(candidate.uri) && (candidate.options === undefined ||
	                ((candidate.options.recursive === undefined || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === undefined || Is.boolean(candidate.options.ignoreIfNotExists)))) && (candidate.annotationId === undefined || ChangeAnnotationIdentifier.is(candidate.annotationId));
	        }
	        DeleteFile.is = is;
	    })(DeleteFile || (exports.DeleteFile = DeleteFile = {}));
	    var WorkspaceEdit;
	    (function (WorkspaceEdit) {
	        function is(value) {
	            var candidate = value;
	            return candidate &&
	                (candidate.changes !== undefined || candidate.documentChanges !== undefined) &&
	                (candidate.documentChanges === undefined || candidate.documentChanges.every(function (change) {
	                    if (Is.string(change.kind)) {
	                        return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
	                    }
	                    else {
	                        return TextDocumentEdit.is(change);
	                    }
	                }));
	        }
	        WorkspaceEdit.is = is;
	    })(WorkspaceEdit || (exports.WorkspaceEdit = WorkspaceEdit = {}));
	    var TextEditChangeImpl =  (function () {
	        function TextEditChangeImpl(edits, changeAnnotations) {
	            this.edits = edits;
	            this.changeAnnotations = changeAnnotations;
	        }
	        TextEditChangeImpl.prototype.insert = function (position, newText, annotation) {
	            var edit;
	            var id;
	            if (annotation === undefined) {
	                edit = TextEdit.insert(position, newText);
	            }
	            else if (ChangeAnnotationIdentifier.is(annotation)) {
	                id = annotation;
	                edit = AnnotatedTextEdit.insert(position, newText, annotation);
	            }
	            else {
	                this.assertChangeAnnotations(this.changeAnnotations);
	                id = this.changeAnnotations.manage(annotation);
	                edit = AnnotatedTextEdit.insert(position, newText, id);
	            }
	            this.edits.push(edit);
	            if (id !== undefined) {
	                return id;
	            }
	        };
	        TextEditChangeImpl.prototype.replace = function (range, newText, annotation) {
	            var edit;
	            var id;
	            if (annotation === undefined) {
	                edit = TextEdit.replace(range, newText);
	            }
	            else if (ChangeAnnotationIdentifier.is(annotation)) {
	                id = annotation;
	                edit = AnnotatedTextEdit.replace(range, newText, annotation);
	            }
	            else {
	                this.assertChangeAnnotations(this.changeAnnotations);
	                id = this.changeAnnotations.manage(annotation);
	                edit = AnnotatedTextEdit.replace(range, newText, id);
	            }
	            this.edits.push(edit);
	            if (id !== undefined) {
	                return id;
	            }
	        };
	        TextEditChangeImpl.prototype.delete = function (range, annotation) {
	            var edit;
	            var id;
	            if (annotation === undefined) {
	                edit = TextEdit.del(range);
	            }
	            else if (ChangeAnnotationIdentifier.is(annotation)) {
	                id = annotation;
	                edit = AnnotatedTextEdit.del(range, annotation);
	            }
	            else {
	                this.assertChangeAnnotations(this.changeAnnotations);
	                id = this.changeAnnotations.manage(annotation);
	                edit = AnnotatedTextEdit.del(range, id);
	            }
	            this.edits.push(edit);
	            if (id !== undefined) {
	                return id;
	            }
	        };
	        TextEditChangeImpl.prototype.add = function (edit) {
	            this.edits.push(edit);
	        };
	        TextEditChangeImpl.prototype.all = function () {
	            return this.edits;
	        };
	        TextEditChangeImpl.prototype.clear = function () {
	            this.edits.splice(0, this.edits.length);
	        };
	        TextEditChangeImpl.prototype.assertChangeAnnotations = function (value) {
	            if (value === undefined) {
	                throw new Error("Text edit change is not configured to manage change annotations.");
	            }
	        };
	        return TextEditChangeImpl;
	    }());
	    var ChangeAnnotations =  (function () {
	        function ChangeAnnotations(annotations) {
	            this._annotations = annotations === undefined ? Object.create(null) : annotations;
	            this._counter = 0;
	            this._size = 0;
	        }
	        ChangeAnnotations.prototype.all = function () {
	            return this._annotations;
	        };
	        Object.defineProperty(ChangeAnnotations.prototype, "size", {
	            get: function () {
	                return this._size;
	            },
	            enumerable: false,
	            configurable: true
	        });
	        ChangeAnnotations.prototype.manage = function (idOrAnnotation, annotation) {
	            var id;
	            if (ChangeAnnotationIdentifier.is(idOrAnnotation)) {
	                id = idOrAnnotation;
	            }
	            else {
	                id = this.nextId();
	                annotation = idOrAnnotation;
	            }
	            if (this._annotations[id] !== undefined) {
	                throw new Error("Id ".concat(id, " is already in use."));
	            }
	            if (annotation === undefined) {
	                throw new Error("No annotation provided for id ".concat(id));
	            }
	            this._annotations[id] = annotation;
	            this._size++;
	            return id;
	        };
	        ChangeAnnotations.prototype.nextId = function () {
	            this._counter++;
	            return this._counter.toString();
	        };
	        return ChangeAnnotations;
	    }());
	    var WorkspaceChange =  (function () {
	        function WorkspaceChange(workspaceEdit) {
	            var _this = this;
	            this._textEditChanges = Object.create(null);
	            if (workspaceEdit !== undefined) {
	                this._workspaceEdit = workspaceEdit;
	                if (workspaceEdit.documentChanges) {
	                    this._changeAnnotations = new ChangeAnnotations(workspaceEdit.changeAnnotations);
	                    workspaceEdit.changeAnnotations = this._changeAnnotations.all();
	                    workspaceEdit.documentChanges.forEach(function (change) {
	                        if (TextDocumentEdit.is(change)) {
	                            var textEditChange = new TextEditChangeImpl(change.edits, _this._changeAnnotations);
	                            _this._textEditChanges[change.textDocument.uri] = textEditChange;
	                        }
	                    });
	                }
	                else if (workspaceEdit.changes) {
	                    Object.keys(workspaceEdit.changes).forEach(function (key) {
	                        var textEditChange = new TextEditChangeImpl(workspaceEdit.changes[key]);
	                        _this._textEditChanges[key] = textEditChange;
	                    });
	                }
	            }
	            else {
	                this._workspaceEdit = {};
	            }
	        }
	        Object.defineProperty(WorkspaceChange.prototype, "edit", {
	            get: function () {
	                this.initDocumentChanges();
	                if (this._changeAnnotations !== undefined) {
	                    if (this._changeAnnotations.size === 0) {
	                        this._workspaceEdit.changeAnnotations = undefined;
	                    }
	                    else {
	                        this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
	                    }
	                }
	                return this._workspaceEdit;
	            },
	            enumerable: false,
	            configurable: true
	        });
	        WorkspaceChange.prototype.getTextEditChange = function (key) {
	            if (OptionalVersionedTextDocumentIdentifier.is(key)) {
	                this.initDocumentChanges();
	                if (this._workspaceEdit.documentChanges === undefined) {
	                    throw new Error('Workspace edit is not configured for document changes.');
	                }
	                var textDocument = { uri: key.uri, version: key.version };
	                var result = this._textEditChanges[textDocument.uri];
	                if (!result) {
	                    var edits = [];
	                    var textDocumentEdit = {
	                        textDocument: textDocument,
	                        edits: edits
	                    };
	                    this._workspaceEdit.documentChanges.push(textDocumentEdit);
	                    result = new TextEditChangeImpl(edits, this._changeAnnotations);
	                    this._textEditChanges[textDocument.uri] = result;
	                }
	                return result;
	            }
	            else {
	                this.initChanges();
	                if (this._workspaceEdit.changes === undefined) {
	                    throw new Error('Workspace edit is not configured for normal text edit changes.');
	                }
	                var result = this._textEditChanges[key];
	                if (!result) {
	                    var edits = [];
	                    this._workspaceEdit.changes[key] = edits;
	                    result = new TextEditChangeImpl(edits);
	                    this._textEditChanges[key] = result;
	                }
	                return result;
	            }
	        };
	        WorkspaceChange.prototype.initDocumentChanges = function () {
	            if (this._workspaceEdit.documentChanges === undefined && this._workspaceEdit.changes === undefined) {
	                this._changeAnnotations = new ChangeAnnotations();
	                this._workspaceEdit.documentChanges = [];
	                this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
	            }
	        };
	        WorkspaceChange.prototype.initChanges = function () {
	            if (this._workspaceEdit.documentChanges === undefined && this._workspaceEdit.changes === undefined) {
	                this._workspaceEdit.changes = Object.create(null);
	            }
	        };
	        WorkspaceChange.prototype.createFile = function (uri, optionsOrAnnotation, options) {
	            this.initDocumentChanges();
	            if (this._workspaceEdit.documentChanges === undefined) {
	                throw new Error('Workspace edit is not configured for document changes.');
	            }
	            var annotation;
	            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
	                annotation = optionsOrAnnotation;
	            }
	            else {
	                options = optionsOrAnnotation;
	            }
	            var operation;
	            var id;
	            if (annotation === undefined) {
	                operation = CreateFile.create(uri, options);
	            }
	            else {
	                id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
	                operation = CreateFile.create(uri, options, id);
	            }
	            this._workspaceEdit.documentChanges.push(operation);
	            if (id !== undefined) {
	                return id;
	            }
	        };
	        WorkspaceChange.prototype.renameFile = function (oldUri, newUri, optionsOrAnnotation, options) {
	            this.initDocumentChanges();
	            if (this._workspaceEdit.documentChanges === undefined) {
	                throw new Error('Workspace edit is not configured for document changes.');
	            }
	            var annotation;
	            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
	                annotation = optionsOrAnnotation;
	            }
	            else {
	                options = optionsOrAnnotation;
	            }
	            var operation;
	            var id;
	            if (annotation === undefined) {
	                operation = RenameFile.create(oldUri, newUri, options);
	            }
	            else {
	                id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
	                operation = RenameFile.create(oldUri, newUri, options, id);
	            }
	            this._workspaceEdit.documentChanges.push(operation);
	            if (id !== undefined) {
	                return id;
	            }
	        };
	        WorkspaceChange.prototype.deleteFile = function (uri, optionsOrAnnotation, options) {
	            this.initDocumentChanges();
	            if (this._workspaceEdit.documentChanges === undefined) {
	                throw new Error('Workspace edit is not configured for document changes.');
	            }
	            var annotation;
	            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
	                annotation = optionsOrAnnotation;
	            }
	            else {
	                options = optionsOrAnnotation;
	            }
	            var operation;
	            var id;
	            if (annotation === undefined) {
	                operation = DeleteFile.create(uri, options);
	            }
	            else {
	                id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
	                operation = DeleteFile.create(uri, options, id);
	            }
	            this._workspaceEdit.documentChanges.push(operation);
	            if (id !== undefined) {
	                return id;
	            }
	        };
	        return WorkspaceChange;
	    }());
	    exports.WorkspaceChange = WorkspaceChange;
	    var TextDocumentIdentifier;
	    (function (TextDocumentIdentifier) {
	        function create(uri) {
	            return { uri: uri };
	        }
	        TextDocumentIdentifier.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.string(candidate.uri);
	        }
	        TextDocumentIdentifier.is = is;
	    })(TextDocumentIdentifier || (exports.TextDocumentIdentifier = TextDocumentIdentifier = {}));
	    var VersionedTextDocumentIdentifier;
	    (function (VersionedTextDocumentIdentifier) {
	        function create(uri, version) {
	            return { uri: uri, version: version };
	        }
	        VersionedTextDocumentIdentifier.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.string(candidate.uri) && Is.integer(candidate.version);
	        }
	        VersionedTextDocumentIdentifier.is = is;
	    })(VersionedTextDocumentIdentifier || (exports.VersionedTextDocumentIdentifier = VersionedTextDocumentIdentifier = {}));
	    var OptionalVersionedTextDocumentIdentifier;
	    (function (OptionalVersionedTextDocumentIdentifier) {
	        function create(uri, version) {
	            return { uri: uri, version: version };
	        }
	        OptionalVersionedTextDocumentIdentifier.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.integer(candidate.version));
	        }
	        OptionalVersionedTextDocumentIdentifier.is = is;
	    })(OptionalVersionedTextDocumentIdentifier || (exports.OptionalVersionedTextDocumentIdentifier = OptionalVersionedTextDocumentIdentifier = {}));
	    var TextDocumentItem;
	    (function (TextDocumentItem) {
	        function create(uri, languageId, version, text) {
	            return { uri: uri, languageId: languageId, version: version, text: text };
	        }
	        TextDocumentItem.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.integer(candidate.version) && Is.string(candidate.text);
	        }
	        TextDocumentItem.is = is;
	    })(TextDocumentItem || (exports.TextDocumentItem = TextDocumentItem = {}));
	    var MarkupKind;
	    (function (MarkupKind) {
	        MarkupKind.PlainText = 'plaintext';
	        MarkupKind.Markdown = 'markdown';
	        function is(value) {
	            var candidate = value;
	            return candidate === MarkupKind.PlainText || candidate === MarkupKind.Markdown;
	        }
	        MarkupKind.is = is;
	    })(MarkupKind || (exports.MarkupKind = MarkupKind = {}));
	    var MarkupContent;
	    (function (MarkupContent) {
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
	        }
	        MarkupContent.is = is;
	    })(MarkupContent || (exports.MarkupContent = MarkupContent = {}));
	    var CompletionItemKind;
	    (function (CompletionItemKind) {
	        CompletionItemKind.Text = 1;
	        CompletionItemKind.Method = 2;
	        CompletionItemKind.Function = 3;
	        CompletionItemKind.Constructor = 4;
	        CompletionItemKind.Field = 5;
	        CompletionItemKind.Variable = 6;
	        CompletionItemKind.Class = 7;
	        CompletionItemKind.Interface = 8;
	        CompletionItemKind.Module = 9;
	        CompletionItemKind.Property = 10;
	        CompletionItemKind.Unit = 11;
	        CompletionItemKind.Value = 12;
	        CompletionItemKind.Enum = 13;
	        CompletionItemKind.Keyword = 14;
	        CompletionItemKind.Snippet = 15;
	        CompletionItemKind.Color = 16;
	        CompletionItemKind.File = 17;
	        CompletionItemKind.Reference = 18;
	        CompletionItemKind.Folder = 19;
	        CompletionItemKind.EnumMember = 20;
	        CompletionItemKind.Constant = 21;
	        CompletionItemKind.Struct = 22;
	        CompletionItemKind.Event = 23;
	        CompletionItemKind.Operator = 24;
	        CompletionItemKind.TypeParameter = 25;
	    })(CompletionItemKind || (exports.CompletionItemKind = CompletionItemKind = {}));
	    var InsertTextFormat;
	    (function (InsertTextFormat) {
	        InsertTextFormat.PlainText = 1;
	        InsertTextFormat.Snippet = 2;
	    })(InsertTextFormat || (exports.InsertTextFormat = InsertTextFormat = {}));
	    var CompletionItemTag;
	    (function (CompletionItemTag) {
	        CompletionItemTag.Deprecated = 1;
	    })(CompletionItemTag || (exports.CompletionItemTag = CompletionItemTag = {}));
	    var InsertReplaceEdit;
	    (function (InsertReplaceEdit) {
	        function create(newText, insert, replace) {
	            return { newText: newText, insert: insert, replace: replace };
	        }
	        InsertReplaceEdit.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate && Is.string(candidate.newText) && Range.is(candidate.insert) && Range.is(candidate.replace);
	        }
	        InsertReplaceEdit.is = is;
	    })(InsertReplaceEdit || (exports.InsertReplaceEdit = InsertReplaceEdit = {}));
	    var InsertTextMode;
	    (function (InsertTextMode) {
	        InsertTextMode.asIs = 1;
	        InsertTextMode.adjustIndentation = 2;
	    })(InsertTextMode || (exports.InsertTextMode = InsertTextMode = {}));
	    var CompletionItemLabelDetails;
	    (function (CompletionItemLabelDetails) {
	        function is(value) {
	            var candidate = value;
	            return candidate && (Is.string(candidate.detail) || candidate.detail === undefined) &&
	                (Is.string(candidate.description) || candidate.description === undefined);
	        }
	        CompletionItemLabelDetails.is = is;
	    })(CompletionItemLabelDetails || (exports.CompletionItemLabelDetails = CompletionItemLabelDetails = {}));
	    var CompletionItem;
	    (function (CompletionItem) {
	        function create(label) {
	            return { label: label };
	        }
	        CompletionItem.create = create;
	    })(CompletionItem || (exports.CompletionItem = CompletionItem = {}));
	    var CompletionList;
	    (function (CompletionList) {
	        function create(items, isIncomplete) {
	            return { items: items ? items : [], isIncomplete: !!isIncomplete };
	        }
	        CompletionList.create = create;
	    })(CompletionList || (exports.CompletionList = CompletionList = {}));
	    var MarkedString;
	    (function (MarkedString) {
	        function fromPlainText(plainText) {
	            return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, '\\$&');
	        }
	        MarkedString.fromPlainText = fromPlainText;
	        function is(value) {
	            var candidate = value;
	            return Is.string(candidate) || (Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value));
	        }
	        MarkedString.is = is;
	    })(MarkedString || (exports.MarkedString = MarkedString = {}));
	    var Hover;
	    (function (Hover) {
	        function is(value) {
	            var candidate = value;
	            return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) ||
	                MarkedString.is(candidate.contents) ||
	                Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === undefined || Range.is(value.range));
	        }
	        Hover.is = is;
	    })(Hover || (exports.Hover = Hover = {}));
	    var ParameterInformation;
	    (function (ParameterInformation) {
	        function create(label, documentation) {
	            return documentation ? { label: label, documentation: documentation } : { label: label };
	        }
	        ParameterInformation.create = create;
	    })(ParameterInformation || (exports.ParameterInformation = ParameterInformation = {}));
	    var SignatureInformation;
	    (function (SignatureInformation) {
	        function create(label, documentation) {
	            var parameters = [];
	            for (var _i = 2; _i < arguments.length; _i++) {
	                parameters[_i - 2] = arguments[_i];
	            }
	            var result = { label: label };
	            if (Is.defined(documentation)) {
	                result.documentation = documentation;
	            }
	            if (Is.defined(parameters)) {
	                result.parameters = parameters;
	            }
	            else {
	                result.parameters = [];
	            }
	            return result;
	        }
	        SignatureInformation.create = create;
	    })(SignatureInformation || (exports.SignatureInformation = SignatureInformation = {}));
	    var DocumentHighlightKind;
	    (function (DocumentHighlightKind) {
	        DocumentHighlightKind.Text = 1;
	        DocumentHighlightKind.Read = 2;
	        DocumentHighlightKind.Write = 3;
	    })(DocumentHighlightKind || (exports.DocumentHighlightKind = DocumentHighlightKind = {}));
	    var DocumentHighlight;
	    (function (DocumentHighlight) {
	        function create(range, kind) {
	            var result = { range: range };
	            if (Is.number(kind)) {
	                result.kind = kind;
	            }
	            return result;
	        }
	        DocumentHighlight.create = create;
	    })(DocumentHighlight || (exports.DocumentHighlight = DocumentHighlight = {}));
	    var SymbolKind;
	    (function (SymbolKind) {
	        SymbolKind.File = 1;
	        SymbolKind.Module = 2;
	        SymbolKind.Namespace = 3;
	        SymbolKind.Package = 4;
	        SymbolKind.Class = 5;
	        SymbolKind.Method = 6;
	        SymbolKind.Property = 7;
	        SymbolKind.Field = 8;
	        SymbolKind.Constructor = 9;
	        SymbolKind.Enum = 10;
	        SymbolKind.Interface = 11;
	        SymbolKind.Function = 12;
	        SymbolKind.Variable = 13;
	        SymbolKind.Constant = 14;
	        SymbolKind.String = 15;
	        SymbolKind.Number = 16;
	        SymbolKind.Boolean = 17;
	        SymbolKind.Array = 18;
	        SymbolKind.Object = 19;
	        SymbolKind.Key = 20;
	        SymbolKind.Null = 21;
	        SymbolKind.EnumMember = 22;
	        SymbolKind.Struct = 23;
	        SymbolKind.Event = 24;
	        SymbolKind.Operator = 25;
	        SymbolKind.TypeParameter = 26;
	    })(SymbolKind || (exports.SymbolKind = SymbolKind = {}));
	    var SymbolTag;
	    (function (SymbolTag) {
	        SymbolTag.Deprecated = 1;
	    })(SymbolTag || (exports.SymbolTag = SymbolTag = {}));
	    var SymbolInformation;
	    (function (SymbolInformation) {
	        function create(name, kind, range, uri, containerName) {
	            var result = {
	                name: name,
	                kind: kind,
	                location: { uri: uri, range: range }
	            };
	            if (containerName) {
	                result.containerName = containerName;
	            }
	            return result;
	        }
	        SymbolInformation.create = create;
	    })(SymbolInformation || (exports.SymbolInformation = SymbolInformation = {}));
	    var WorkspaceSymbol;
	    (function (WorkspaceSymbol) {
	        function create(name, kind, uri, range) {
	            return range !== undefined
	                ? { name: name, kind: kind, location: { uri: uri, range: range } }
	                : { name: name, kind: kind, location: { uri: uri } };
	        }
	        WorkspaceSymbol.create = create;
	    })(WorkspaceSymbol || (exports.WorkspaceSymbol = WorkspaceSymbol = {}));
	    var DocumentSymbol;
	    (function (DocumentSymbol) {
	        function create(name, detail, kind, range, selectionRange, children) {
	            var result = {
	                name: name,
	                detail: detail,
	                kind: kind,
	                range: range,
	                selectionRange: selectionRange
	            };
	            if (children !== undefined) {
	                result.children = children;
	            }
	            return result;
	        }
	        DocumentSymbol.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate &&
	                Is.string(candidate.name) && Is.number(candidate.kind) &&
	                Range.is(candidate.range) && Range.is(candidate.selectionRange) &&
	                (candidate.detail === undefined || Is.string(candidate.detail)) &&
	                (candidate.deprecated === undefined || Is.boolean(candidate.deprecated)) &&
	                (candidate.children === undefined || Array.isArray(candidate.children)) &&
	                (candidate.tags === undefined || Array.isArray(candidate.tags));
	        }
	        DocumentSymbol.is = is;
	    })(DocumentSymbol || (exports.DocumentSymbol = DocumentSymbol = {}));
	    var CodeActionKind;
	    (function (CodeActionKind) {
	        CodeActionKind.Empty = '';
	        CodeActionKind.QuickFix = 'quickfix';
	        CodeActionKind.Refactor = 'refactor';
	        CodeActionKind.RefactorExtract = 'refactor.extract';
	        CodeActionKind.RefactorInline = 'refactor.inline';
	        CodeActionKind.RefactorRewrite = 'refactor.rewrite';
	        CodeActionKind.Source = 'source';
	        CodeActionKind.SourceOrganizeImports = 'source.organizeImports';
	        CodeActionKind.SourceFixAll = 'source.fixAll';
	    })(CodeActionKind || (exports.CodeActionKind = CodeActionKind = {}));
	    var CodeActionTriggerKind;
	    (function (CodeActionTriggerKind) {
	        CodeActionTriggerKind.Invoked = 1;
	        CodeActionTriggerKind.Automatic = 2;
	    })(CodeActionTriggerKind || (exports.CodeActionTriggerKind = CodeActionTriggerKind = {}));
	    var CodeActionContext;
	    (function (CodeActionContext) {
	        function create(diagnostics, only, triggerKind) {
	            var result = { diagnostics: diagnostics };
	            if (only !== undefined && only !== null) {
	                result.only = only;
	            }
	            if (triggerKind !== undefined && triggerKind !== null) {
	                result.triggerKind = triggerKind;
	            }
	            return result;
	        }
	        CodeActionContext.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is)
	                && (candidate.only === undefined || Is.typedArray(candidate.only, Is.string))
	                && (candidate.triggerKind === undefined || candidate.triggerKind === CodeActionTriggerKind.Invoked || candidate.triggerKind === CodeActionTriggerKind.Automatic);
	        }
	        CodeActionContext.is = is;
	    })(CodeActionContext || (exports.CodeActionContext = CodeActionContext = {}));
	    var CodeAction;
	    (function (CodeAction) {
	        function create(title, kindOrCommandOrEdit, kind) {
	            var result = { title: title };
	            var checkKind = true;
	            if (typeof kindOrCommandOrEdit === 'string') {
	                checkKind = false;
	                result.kind = kindOrCommandOrEdit;
	            }
	            else if (Command.is(kindOrCommandOrEdit)) {
	                result.command = kindOrCommandOrEdit;
	            }
	            else {
	                result.edit = kindOrCommandOrEdit;
	            }
	            if (checkKind && kind !== undefined) {
	                result.kind = kind;
	            }
	            return result;
	        }
	        CodeAction.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate && Is.string(candidate.title) &&
	                (candidate.diagnostics === undefined || Is.typedArray(candidate.diagnostics, Diagnostic.is)) &&
	                (candidate.kind === undefined || Is.string(candidate.kind)) &&
	                (candidate.edit !== undefined || candidate.command !== undefined) &&
	                (candidate.command === undefined || Command.is(candidate.command)) &&
	                (candidate.isPreferred === undefined || Is.boolean(candidate.isPreferred)) &&
	                (candidate.edit === undefined || WorkspaceEdit.is(candidate.edit));
	        }
	        CodeAction.is = is;
	    })(CodeAction || (exports.CodeAction = CodeAction = {}));
	    var CodeLens;
	    (function (CodeLens) {
	        function create(range, data) {
	            var result = { range: range };
	            if (Is.defined(data)) {
	                result.data = data;
	            }
	            return result;
	        }
	        CodeLens.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command.is(candidate.command));
	        }
	        CodeLens.is = is;
	    })(CodeLens || (exports.CodeLens = CodeLens = {}));
	    var FormattingOptions;
	    (function (FormattingOptions) {
	        function create(tabSize, insertSpaces) {
	            return { tabSize: tabSize, insertSpaces: insertSpaces };
	        }
	        FormattingOptions.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.uinteger(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
	        }
	        FormattingOptions.is = is;
	    })(FormattingOptions || (exports.FormattingOptions = FormattingOptions = {}));
	    var DocumentLink;
	    (function (DocumentLink) {
	        function create(range, target, data) {
	            return { range: range, target: target, data: data };
	        }
	        DocumentLink.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
	        }
	        DocumentLink.is = is;
	    })(DocumentLink || (exports.DocumentLink = DocumentLink = {}));
	    var SelectionRange;
	    (function (SelectionRange) {
	        function create(range, parent) {
	            return { range: range, parent: parent };
	        }
	        SelectionRange.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Range.is(candidate.range) && (candidate.parent === undefined || SelectionRange.is(candidate.parent));
	        }
	        SelectionRange.is = is;
	    })(SelectionRange || (exports.SelectionRange = SelectionRange = {}));
	    var SemanticTokenTypes;
	    (function (SemanticTokenTypes) {
	        SemanticTokenTypes["namespace"] = "namespace";
	        SemanticTokenTypes["type"] = "type";
	        SemanticTokenTypes["class"] = "class";
	        SemanticTokenTypes["enum"] = "enum";
	        SemanticTokenTypes["interface"] = "interface";
	        SemanticTokenTypes["struct"] = "struct";
	        SemanticTokenTypes["typeParameter"] = "typeParameter";
	        SemanticTokenTypes["parameter"] = "parameter";
	        SemanticTokenTypes["variable"] = "variable";
	        SemanticTokenTypes["property"] = "property";
	        SemanticTokenTypes["enumMember"] = "enumMember";
	        SemanticTokenTypes["event"] = "event";
	        SemanticTokenTypes["function"] = "function";
	        SemanticTokenTypes["method"] = "method";
	        SemanticTokenTypes["macro"] = "macro";
	        SemanticTokenTypes["keyword"] = "keyword";
	        SemanticTokenTypes["modifier"] = "modifier";
	        SemanticTokenTypes["comment"] = "comment";
	        SemanticTokenTypes["string"] = "string";
	        SemanticTokenTypes["number"] = "number";
	        SemanticTokenTypes["regexp"] = "regexp";
	        SemanticTokenTypes["operator"] = "operator";
	        SemanticTokenTypes["decorator"] = "decorator";
	    })(SemanticTokenTypes || (exports.SemanticTokenTypes = SemanticTokenTypes = {}));
	    var SemanticTokenModifiers;
	    (function (SemanticTokenModifiers) {
	        SemanticTokenModifiers["declaration"] = "declaration";
	        SemanticTokenModifiers["definition"] = "definition";
	        SemanticTokenModifiers["readonly"] = "readonly";
	        SemanticTokenModifiers["static"] = "static";
	        SemanticTokenModifiers["deprecated"] = "deprecated";
	        SemanticTokenModifiers["abstract"] = "abstract";
	        SemanticTokenModifiers["async"] = "async";
	        SemanticTokenModifiers["modification"] = "modification";
	        SemanticTokenModifiers["documentation"] = "documentation";
	        SemanticTokenModifiers["defaultLibrary"] = "defaultLibrary";
	    })(SemanticTokenModifiers || (exports.SemanticTokenModifiers = SemanticTokenModifiers = {}));
	    var SemanticTokens;
	    (function (SemanticTokens) {
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && (candidate.resultId === undefined || typeof candidate.resultId === 'string') &&
	                Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === 'number');
	        }
	        SemanticTokens.is = is;
	    })(SemanticTokens || (exports.SemanticTokens = SemanticTokens = {}));
	    var InlineValueText;
	    (function (InlineValueText) {
	        function create(range, text) {
	            return { range: range, text: text };
	        }
	        InlineValueText.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate !== undefined && candidate !== null && Range.is(candidate.range) && Is.string(candidate.text);
	        }
	        InlineValueText.is = is;
	    })(InlineValueText || (exports.InlineValueText = InlineValueText = {}));
	    var InlineValueVariableLookup;
	    (function (InlineValueVariableLookup) {
	        function create(range, variableName, caseSensitiveLookup) {
	            return { range: range, variableName: variableName, caseSensitiveLookup: caseSensitiveLookup };
	        }
	        InlineValueVariableLookup.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate !== undefined && candidate !== null && Range.is(candidate.range) && Is.boolean(candidate.caseSensitiveLookup)
	                && (Is.string(candidate.variableName) || candidate.variableName === undefined);
	        }
	        InlineValueVariableLookup.is = is;
	    })(InlineValueVariableLookup || (exports.InlineValueVariableLookup = InlineValueVariableLookup = {}));
	    var InlineValueEvaluatableExpression;
	    (function (InlineValueEvaluatableExpression) {
	        function create(range, expression) {
	            return { range: range, expression: expression };
	        }
	        InlineValueEvaluatableExpression.create = create;
	        function is(value) {
	            var candidate = value;
	            return candidate !== undefined && candidate !== null && Range.is(candidate.range)
	                && (Is.string(candidate.expression) || candidate.expression === undefined);
	        }
	        InlineValueEvaluatableExpression.is = is;
	    })(InlineValueEvaluatableExpression || (exports.InlineValueEvaluatableExpression = InlineValueEvaluatableExpression = {}));
	    var InlineValueContext;
	    (function (InlineValueContext) {
	        function create(frameId, stoppedLocation) {
	            return { frameId: frameId, stoppedLocation: stoppedLocation };
	        }
	        InlineValueContext.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Range.is(value.stoppedLocation);
	        }
	        InlineValueContext.is = is;
	    })(InlineValueContext || (exports.InlineValueContext = InlineValueContext = {}));
	    var InlayHintKind;
	    (function (InlayHintKind) {
	        InlayHintKind.Type = 1;
	        InlayHintKind.Parameter = 2;
	        function is(value) {
	            return value === 1 || value === 2;
	        }
	        InlayHintKind.is = is;
	    })(InlayHintKind || (exports.InlayHintKind = InlayHintKind = {}));
	    var InlayHintLabelPart;
	    (function (InlayHintLabelPart) {
	        function create(value) {
	            return { value: value };
	        }
	        InlayHintLabelPart.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate)
	                && (candidate.tooltip === undefined || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip))
	                && (candidate.location === undefined || Location.is(candidate.location))
	                && (candidate.command === undefined || Command.is(candidate.command));
	        }
	        InlayHintLabelPart.is = is;
	    })(InlayHintLabelPart || (exports.InlayHintLabelPart = InlayHintLabelPart = {}));
	    var InlayHint;
	    (function (InlayHint) {
	        function create(position, label, kind) {
	            var result = { position: position, label: label };
	            if (kind !== undefined) {
	                result.kind = kind;
	            }
	            return result;
	        }
	        InlayHint.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && Position.is(candidate.position)
	                && (Is.string(candidate.label) || Is.typedArray(candidate.label, InlayHintLabelPart.is))
	                && (candidate.kind === undefined || InlayHintKind.is(candidate.kind))
	                && (candidate.textEdits === undefined) || Is.typedArray(candidate.textEdits, TextEdit.is)
	                && (candidate.tooltip === undefined || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip))
	                && (candidate.paddingLeft === undefined || Is.boolean(candidate.paddingLeft))
	                && (candidate.paddingRight === undefined || Is.boolean(candidate.paddingRight));
	        }
	        InlayHint.is = is;
	    })(InlayHint || (exports.InlayHint = InlayHint = {}));
	    var StringValue;
	    (function (StringValue) {
	        function createSnippet(value) {
	            return { kind: 'snippet', value: value };
	        }
	        StringValue.createSnippet = createSnippet;
	    })(StringValue || (exports.StringValue = StringValue = {}));
	    var InlineCompletionItem;
	    (function (InlineCompletionItem) {
	        function create(insertText, filterText, range, command) {
	            return { insertText: insertText, filterText: filterText, range: range, command: command };
	        }
	        InlineCompletionItem.create = create;
	    })(InlineCompletionItem || (exports.InlineCompletionItem = InlineCompletionItem = {}));
	    var InlineCompletionList;
	    (function (InlineCompletionList) {
	        function create(items) {
	            return { items: items };
	        }
	        InlineCompletionList.create = create;
	    })(InlineCompletionList || (exports.InlineCompletionList = InlineCompletionList = {}));
	    var InlineCompletionTriggerKind;
	    (function (InlineCompletionTriggerKind) {
	        InlineCompletionTriggerKind.Invoked = 0;
	        InlineCompletionTriggerKind.Automatic = 1;
	    })(InlineCompletionTriggerKind || (exports.InlineCompletionTriggerKind = InlineCompletionTriggerKind = {}));
	    var SelectedCompletionInfo;
	    (function (SelectedCompletionInfo) {
	        function create(range, text) {
	            return { range: range, text: text };
	        }
	        SelectedCompletionInfo.create = create;
	    })(SelectedCompletionInfo || (exports.SelectedCompletionInfo = SelectedCompletionInfo = {}));
	    var InlineCompletionContext;
	    (function (InlineCompletionContext) {
	        function create(triggerKind, selectedCompletionInfo) {
	            return { triggerKind: triggerKind, selectedCompletionInfo: selectedCompletionInfo };
	        }
	        InlineCompletionContext.create = create;
	    })(InlineCompletionContext || (exports.InlineCompletionContext = InlineCompletionContext = {}));
	    var WorkspaceFolder;
	    (function (WorkspaceFolder) {
	        function is(value) {
	            var candidate = value;
	            return Is.objectLiteral(candidate) && URI.is(candidate.uri) && Is.string(candidate.name);
	        }
	        WorkspaceFolder.is = is;
	    })(WorkspaceFolder || (exports.WorkspaceFolder = WorkspaceFolder = {}));
	    exports.EOL = ['\n', '\r\n', '\r'];
	    var TextDocument;
	    (function (TextDocument) {
	        function create(uri, languageId, version, content) {
	            return new FullTextDocument(uri, languageId, version, content);
	        }
	        TextDocument.create = create;
	        function is(value) {
	            var candidate = value;
	            return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.uinteger(candidate.lineCount)
	                && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
	        }
	        TextDocument.is = is;
	        function applyEdits(document, edits) {
	            var text = document.getText();
	            var sortedEdits = mergeSort(edits, function (a, b) {
	                var diff = a.range.start.line - b.range.start.line;
	                if (diff === 0) {
	                    return a.range.start.character - b.range.start.character;
	                }
	                return diff;
	            });
	            var lastModifiedOffset = text.length;
	            for (var i = sortedEdits.length - 1; i >= 0; i--) {
	                var e = sortedEdits[i];
	                var startOffset = document.offsetAt(e.range.start);
	                var endOffset = document.offsetAt(e.range.end);
	                if (endOffset <= lastModifiedOffset) {
	                    text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
	                }
	                else {
	                    throw new Error('Overlapping edit');
	                }
	                lastModifiedOffset = startOffset;
	            }
	            return text;
	        }
	        TextDocument.applyEdits = applyEdits;
	        function mergeSort(data, compare) {
	            if (data.length <= 1) {
	                return data;
	            }
	            var p = (data.length / 2) | 0;
	            var left = data.slice(0, p);
	            var right = data.slice(p);
	            mergeSort(left, compare);
	            mergeSort(right, compare);
	            var leftIdx = 0;
	            var rightIdx = 0;
	            var i = 0;
	            while (leftIdx < left.length && rightIdx < right.length) {
	                var ret = compare(left[leftIdx], right[rightIdx]);
	                if (ret <= 0) {
	                    data[i++] = left[leftIdx++];
	                }
	                else {
	                    data[i++] = right[rightIdx++];
	                }
	            }
	            while (leftIdx < left.length) {
	                data[i++] = left[leftIdx++];
	            }
	            while (rightIdx < right.length) {
	                data[i++] = right[rightIdx++];
	            }
	            return data;
	        }
	    })(TextDocument || (exports.TextDocument = TextDocument = {}));
	    var FullTextDocument =  (function () {
	        function FullTextDocument(uri, languageId, version, content) {
	            this._uri = uri;
	            this._languageId = languageId;
	            this._version = version;
	            this._content = content;
	            this._lineOffsets = undefined;
	        }
	        Object.defineProperty(FullTextDocument.prototype, "uri", {
	            get: function () {
	                return this._uri;
	            },
	            enumerable: false,
	            configurable: true
	        });
	        Object.defineProperty(FullTextDocument.prototype, "languageId", {
	            get: function () {
	                return this._languageId;
	            },
	            enumerable: false,
	            configurable: true
	        });
	        Object.defineProperty(FullTextDocument.prototype, "version", {
	            get: function () {
	                return this._version;
	            },
	            enumerable: false,
	            configurable: true
	        });
	        FullTextDocument.prototype.getText = function (range) {
	            if (range) {
	                var start = this.offsetAt(range.start);
	                var end = this.offsetAt(range.end);
	                return this._content.substring(start, end);
	            }
	            return this._content;
	        };
	        FullTextDocument.prototype.update = function (event, version) {
	            this._content = event.text;
	            this._version = version;
	            this._lineOffsets = undefined;
	        };
	        FullTextDocument.prototype.getLineOffsets = function () {
	            if (this._lineOffsets === undefined) {
	                var lineOffsets = [];
	                var text = this._content;
	                var isLineStart = true;
	                for (var i = 0; i < text.length; i++) {
	                    if (isLineStart) {
	                        lineOffsets.push(i);
	                        isLineStart = false;
	                    }
	                    var ch = text.charAt(i);
	                    isLineStart = (ch === '\r' || ch === '\n');
	                    if (ch === '\r' && i + 1 < text.length && text.charAt(i + 1) === '\n') {
	                        i++;
	                    }
	                }
	                if (isLineStart && text.length > 0) {
	                    lineOffsets.push(text.length);
	                }
	                this._lineOffsets = lineOffsets;
	            }
	            return this._lineOffsets;
	        };
	        FullTextDocument.prototype.positionAt = function (offset) {
	            offset = Math.max(Math.min(offset, this._content.length), 0);
	            var lineOffsets = this.getLineOffsets();
	            var low = 0, high = lineOffsets.length;
	            if (high === 0) {
	                return Position.create(0, offset);
	            }
	            while (low < high) {
	                var mid = Math.floor((low + high) / 2);
	                if (lineOffsets[mid] > offset) {
	                    high = mid;
	                }
	                else {
	                    low = mid + 1;
	                }
	            }
	            var line = low - 1;
	            return Position.create(line, offset - lineOffsets[line]);
	        };
	        FullTextDocument.prototype.offsetAt = function (position) {
	            var lineOffsets = this.getLineOffsets();
	            if (position.line >= lineOffsets.length) {
	                return this._content.length;
	            }
	            else if (position.line < 0) {
	                return 0;
	            }
	            var lineOffset = lineOffsets[position.line];
	            var nextLineOffset = (position.line + 1 < lineOffsets.length) ? lineOffsets[position.line + 1] : this._content.length;
	            return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
	        };
	        Object.defineProperty(FullTextDocument.prototype, "lineCount", {
	            get: function () {
	                return this.getLineOffsets().length;
	            },
	            enumerable: false,
	            configurable: true
	        });
	        return FullTextDocument;
	    }());
	    var Is;
	    (function (Is) {
	        var toString = Object.prototype.toString;
	        function defined(value) {
	            return typeof value !== 'undefined';
	        }
	        Is.defined = defined;
	        function undefined$1(value) {
	            return typeof value === 'undefined';
	        }
	        Is.undefined = undefined$1;
	        function boolean(value) {
	            return value === true || value === false;
	        }
	        Is.boolean = boolean;
	        function string(value) {
	            return toString.call(value) === '[object String]';
	        }
	        Is.string = string;
	        function number(value) {
	            return toString.call(value) === '[object Number]';
	        }
	        Is.number = number;
	        function numberRange(value, min, max) {
	            return toString.call(value) === '[object Number]' && min <= value && value <= max;
	        }
	        Is.numberRange = numberRange;
	        function integer(value) {
	            return toString.call(value) === '[object Number]' && -2147483648 <= value && value <= 2147483647;
	        }
	        Is.integer = integer;
	        function uinteger(value) {
	            return toString.call(value) === '[object Number]' && 0 <= value && value <= 2147483647;
	        }
	        Is.uinteger = uinteger;
	        function func(value) {
	            return toString.call(value) === '[object Function]';
	        }
	        Is.func = func;
	        function objectLiteral(value) {
	            return value !== null && typeof value === 'object';
	        }
	        Is.objectLiteral = objectLiteral;
	        function typedArray(value, check) {
	            return Array.isArray(value) && value.every(check);
	        }
	        Is.typedArray = typedArray;
	    })(Is || (Is = {}));
	});
} (main$5, main$5.exports));
var mainExports = main$5.exports;
getDefaultExportFromCjs(mainExports);

var messages$2 = {};

Object.defineProperty(messages$2, "__esModule", { value: true });
messages$2.ProtocolNotificationType = messages$2.ProtocolNotificationType0 = messages$2.ProtocolRequestType = messages$2.ProtocolRequestType0 = messages$2.RegistrationType = messages$2.MessageDirection = void 0;
const vscode_jsonrpc_1$4 = main$6;
var MessageDirection;
(function (MessageDirection) {
    MessageDirection["clientToServer"] = "clientToServer";
    MessageDirection["serverToClient"] = "serverToClient";
    MessageDirection["both"] = "both";
})(MessageDirection || (messages$2.MessageDirection = MessageDirection = {}));
class RegistrationType {
    constructor(method) {
        this.method = method;
    }
}
messages$2.RegistrationType = RegistrationType;
class ProtocolRequestType0 extends vscode_jsonrpc_1$4.RequestType0 {
    constructor(method) {
        super(method);
    }
}
messages$2.ProtocolRequestType0 = ProtocolRequestType0;
class ProtocolRequestType extends vscode_jsonrpc_1$4.RequestType {
    constructor(method) {
        super(method, vscode_jsonrpc_1$4.ParameterStructures.byName);
    }
}
messages$2.ProtocolRequestType = ProtocolRequestType;
class ProtocolNotificationType0 extends vscode_jsonrpc_1$4.NotificationType0 {
    constructor(method) {
        super(method);
    }
}
messages$2.ProtocolNotificationType0 = ProtocolNotificationType0;
class ProtocolNotificationType extends vscode_jsonrpc_1$4.NotificationType {
    constructor(method) {
        super(method, vscode_jsonrpc_1$4.ParameterStructures.byName);
    }
}
messages$2.ProtocolNotificationType = ProtocolNotificationType;

var protocol$1 = {};

var is$2 = {};

Object.defineProperty(is$2, "__esModule", { value: true });
is$2.objectLiteral = is$2.typedArray = is$2.stringArray = is$2.array = is$2.func = is$2.error = is$2.number = is$2.string = is$2.boolean = void 0;
function boolean$1(value) {
    return value === true || value === false;
}
is$2.boolean = boolean$1;
function string$1(value) {
    return typeof value === 'string' || value instanceof String;
}
is$2.string = string$1;
function number$1(value) {
    return typeof value === 'number' || value instanceof Number;
}
is$2.number = number$1;
function error$3(value) {
    return value instanceof Error;
}
is$2.error = error$3;
function func$1(value) {
    return typeof value === 'function';
}
is$2.func = func$1;
function array$1(value) {
    return Array.isArray(value);
}
is$2.array = array$1;
function stringArray$1(value) {
    return array$1(value) && value.every(elem => string$1(elem));
}
is$2.stringArray = stringArray$1;
function typedArray$1(value, check) {
    return Array.isArray(value) && value.every(check);
}
is$2.typedArray = typedArray$1;
function objectLiteral$1(value) {
    return value !== null && typeof value === 'object';
}
is$2.objectLiteral = objectLiteral$1;

var protocol_implementation$1 = {};

Object.defineProperty(protocol_implementation$1, "__esModule", { value: true });
protocol_implementation$1.ImplementationRequest = void 0;
const messages_1$k = messages$2;
var ImplementationRequest;
(function (ImplementationRequest) {
    ImplementationRequest.method = 'textDocument/implementation';
    ImplementationRequest.messageDirection = messages_1$k.MessageDirection.clientToServer;
    ImplementationRequest.type = new messages_1$k.ProtocolRequestType(ImplementationRequest.method);
})(ImplementationRequest || (protocol_implementation$1.ImplementationRequest = ImplementationRequest = {}));

var protocol_typeDefinition$1 = {};

Object.defineProperty(protocol_typeDefinition$1, "__esModule", { value: true });
protocol_typeDefinition$1.TypeDefinitionRequest = void 0;
const messages_1$j = messages$2;
var TypeDefinitionRequest;
(function (TypeDefinitionRequest) {
    TypeDefinitionRequest.method = 'textDocument/typeDefinition';
    TypeDefinitionRequest.messageDirection = messages_1$j.MessageDirection.clientToServer;
    TypeDefinitionRequest.type = new messages_1$j.ProtocolRequestType(TypeDefinitionRequest.method);
})(TypeDefinitionRequest || (protocol_typeDefinition$1.TypeDefinitionRequest = TypeDefinitionRequest = {}));

var protocol_workspaceFolder$1 = {};

Object.defineProperty(protocol_workspaceFolder$1, "__esModule", { value: true });
protocol_workspaceFolder$1.DidChangeWorkspaceFoldersNotification = protocol_workspaceFolder$1.WorkspaceFoldersRequest = void 0;
const messages_1$i = messages$2;
var WorkspaceFoldersRequest;
(function (WorkspaceFoldersRequest) {
    WorkspaceFoldersRequest.method = 'workspace/workspaceFolders';
    WorkspaceFoldersRequest.messageDirection = messages_1$i.MessageDirection.serverToClient;
    WorkspaceFoldersRequest.type = new messages_1$i.ProtocolRequestType0(WorkspaceFoldersRequest.method);
})(WorkspaceFoldersRequest || (protocol_workspaceFolder$1.WorkspaceFoldersRequest = WorkspaceFoldersRequest = {}));
var DidChangeWorkspaceFoldersNotification;
(function (DidChangeWorkspaceFoldersNotification) {
    DidChangeWorkspaceFoldersNotification.method = 'workspace/didChangeWorkspaceFolders';
    DidChangeWorkspaceFoldersNotification.messageDirection = messages_1$i.MessageDirection.clientToServer;
    DidChangeWorkspaceFoldersNotification.type = new messages_1$i.ProtocolNotificationType(DidChangeWorkspaceFoldersNotification.method);
})(DidChangeWorkspaceFoldersNotification || (protocol_workspaceFolder$1.DidChangeWorkspaceFoldersNotification = DidChangeWorkspaceFoldersNotification = {}));

var protocol_configuration$1 = {};

Object.defineProperty(protocol_configuration$1, "__esModule", { value: true });
protocol_configuration$1.ConfigurationRequest = void 0;
const messages_1$h = messages$2;
var ConfigurationRequest;
(function (ConfigurationRequest) {
    ConfigurationRequest.method = 'workspace/configuration';
    ConfigurationRequest.messageDirection = messages_1$h.MessageDirection.serverToClient;
    ConfigurationRequest.type = new messages_1$h.ProtocolRequestType(ConfigurationRequest.method);
})(ConfigurationRequest || (protocol_configuration$1.ConfigurationRequest = ConfigurationRequest = {}));

var protocol_colorProvider$1 = {};

Object.defineProperty(protocol_colorProvider$1, "__esModule", { value: true });
protocol_colorProvider$1.ColorPresentationRequest = protocol_colorProvider$1.DocumentColorRequest = void 0;
const messages_1$g = messages$2;
var DocumentColorRequest;
(function (DocumentColorRequest) {
    DocumentColorRequest.method = 'textDocument/documentColor';
    DocumentColorRequest.messageDirection = messages_1$g.MessageDirection.clientToServer;
    DocumentColorRequest.type = new messages_1$g.ProtocolRequestType(DocumentColorRequest.method);
})(DocumentColorRequest || (protocol_colorProvider$1.DocumentColorRequest = DocumentColorRequest = {}));
var ColorPresentationRequest;
(function (ColorPresentationRequest) {
    ColorPresentationRequest.method = 'textDocument/colorPresentation';
    ColorPresentationRequest.messageDirection = messages_1$g.MessageDirection.clientToServer;
    ColorPresentationRequest.type = new messages_1$g.ProtocolRequestType(ColorPresentationRequest.method);
})(ColorPresentationRequest || (protocol_colorProvider$1.ColorPresentationRequest = ColorPresentationRequest = {}));

var protocol_foldingRange$1 = {};

Object.defineProperty(protocol_foldingRange$1, "__esModule", { value: true });
protocol_foldingRange$1.FoldingRangeRefreshRequest = protocol_foldingRange$1.FoldingRangeRequest = void 0;
const messages_1$f = messages$2;
var FoldingRangeRequest;
(function (FoldingRangeRequest) {
    FoldingRangeRequest.method = 'textDocument/foldingRange';
    FoldingRangeRequest.messageDirection = messages_1$f.MessageDirection.clientToServer;
    FoldingRangeRequest.type = new messages_1$f.ProtocolRequestType(FoldingRangeRequest.method);
})(FoldingRangeRequest || (protocol_foldingRange$1.FoldingRangeRequest = FoldingRangeRequest = {}));
var FoldingRangeRefreshRequest;
(function (FoldingRangeRefreshRequest) {
    FoldingRangeRefreshRequest.method = `workspace/foldingRange/refresh`;
    FoldingRangeRefreshRequest.messageDirection = messages_1$f.MessageDirection.serverToClient;
    FoldingRangeRefreshRequest.type = new messages_1$f.ProtocolRequestType0(FoldingRangeRefreshRequest.method);
})(FoldingRangeRefreshRequest || (protocol_foldingRange$1.FoldingRangeRefreshRequest = FoldingRangeRefreshRequest = {}));

var protocol_declaration$1 = {};

Object.defineProperty(protocol_declaration$1, "__esModule", { value: true });
protocol_declaration$1.DeclarationRequest = void 0;
const messages_1$e = messages$2;
var DeclarationRequest;
(function (DeclarationRequest) {
    DeclarationRequest.method = 'textDocument/declaration';
    DeclarationRequest.messageDirection = messages_1$e.MessageDirection.clientToServer;
    DeclarationRequest.type = new messages_1$e.ProtocolRequestType(DeclarationRequest.method);
})(DeclarationRequest || (protocol_declaration$1.DeclarationRequest = DeclarationRequest = {}));

var protocol_selectionRange$1 = {};

Object.defineProperty(protocol_selectionRange$1, "__esModule", { value: true });
protocol_selectionRange$1.SelectionRangeRequest = void 0;
const messages_1$d = messages$2;
var SelectionRangeRequest;
(function (SelectionRangeRequest) {
    SelectionRangeRequest.method = 'textDocument/selectionRange';
    SelectionRangeRequest.messageDirection = messages_1$d.MessageDirection.clientToServer;
    SelectionRangeRequest.type = new messages_1$d.ProtocolRequestType(SelectionRangeRequest.method);
})(SelectionRangeRequest || (protocol_selectionRange$1.SelectionRangeRequest = SelectionRangeRequest = {}));

var protocol_progress$1 = {};

Object.defineProperty(protocol_progress$1, "__esModule", { value: true });
protocol_progress$1.WorkDoneProgressCancelNotification = protocol_progress$1.WorkDoneProgressCreateRequest = protocol_progress$1.WorkDoneProgress = void 0;
const vscode_jsonrpc_1$3 = main$6;
const messages_1$c = messages$2;
var WorkDoneProgress;
(function (WorkDoneProgress) {
    WorkDoneProgress.type = new vscode_jsonrpc_1$3.ProgressType();
    function is(value) {
        return value === WorkDoneProgress.type;
    }
    WorkDoneProgress.is = is;
})(WorkDoneProgress || (protocol_progress$1.WorkDoneProgress = WorkDoneProgress = {}));
var WorkDoneProgressCreateRequest;
(function (WorkDoneProgressCreateRequest) {
    WorkDoneProgressCreateRequest.method = 'window/workDoneProgress/create';
    WorkDoneProgressCreateRequest.messageDirection = messages_1$c.MessageDirection.serverToClient;
    WorkDoneProgressCreateRequest.type = new messages_1$c.ProtocolRequestType(WorkDoneProgressCreateRequest.method);
})(WorkDoneProgressCreateRequest || (protocol_progress$1.WorkDoneProgressCreateRequest = WorkDoneProgressCreateRequest = {}));
var WorkDoneProgressCancelNotification;
(function (WorkDoneProgressCancelNotification) {
    WorkDoneProgressCancelNotification.method = 'window/workDoneProgress/cancel';
    WorkDoneProgressCancelNotification.messageDirection = messages_1$c.MessageDirection.clientToServer;
    WorkDoneProgressCancelNotification.type = new messages_1$c.ProtocolNotificationType(WorkDoneProgressCancelNotification.method);
})(WorkDoneProgressCancelNotification || (protocol_progress$1.WorkDoneProgressCancelNotification = WorkDoneProgressCancelNotification = {}));

var protocol_callHierarchy$1 = {};

Object.defineProperty(protocol_callHierarchy$1, "__esModule", { value: true });
protocol_callHierarchy$1.CallHierarchyOutgoingCallsRequest = protocol_callHierarchy$1.CallHierarchyIncomingCallsRequest = protocol_callHierarchy$1.CallHierarchyPrepareRequest = void 0;
const messages_1$b = messages$2;
var CallHierarchyPrepareRequest;
(function (CallHierarchyPrepareRequest) {
    CallHierarchyPrepareRequest.method = 'textDocument/prepareCallHierarchy';
    CallHierarchyPrepareRequest.messageDirection = messages_1$b.MessageDirection.clientToServer;
    CallHierarchyPrepareRequest.type = new messages_1$b.ProtocolRequestType(CallHierarchyPrepareRequest.method);
})(CallHierarchyPrepareRequest || (protocol_callHierarchy$1.CallHierarchyPrepareRequest = CallHierarchyPrepareRequest = {}));
var CallHierarchyIncomingCallsRequest;
(function (CallHierarchyIncomingCallsRequest) {
    CallHierarchyIncomingCallsRequest.method = 'callHierarchy/incomingCalls';
    CallHierarchyIncomingCallsRequest.messageDirection = messages_1$b.MessageDirection.clientToServer;
    CallHierarchyIncomingCallsRequest.type = new messages_1$b.ProtocolRequestType(CallHierarchyIncomingCallsRequest.method);
})(CallHierarchyIncomingCallsRequest || (protocol_callHierarchy$1.CallHierarchyIncomingCallsRequest = CallHierarchyIncomingCallsRequest = {}));
var CallHierarchyOutgoingCallsRequest;
(function (CallHierarchyOutgoingCallsRequest) {
    CallHierarchyOutgoingCallsRequest.method = 'callHierarchy/outgoingCalls';
    CallHierarchyOutgoingCallsRequest.messageDirection = messages_1$b.MessageDirection.clientToServer;
    CallHierarchyOutgoingCallsRequest.type = new messages_1$b.ProtocolRequestType(CallHierarchyOutgoingCallsRequest.method);
})(CallHierarchyOutgoingCallsRequest || (protocol_callHierarchy$1.CallHierarchyOutgoingCallsRequest = CallHierarchyOutgoingCallsRequest = {}));

var protocol_semanticTokens$1 = {};

Object.defineProperty(protocol_semanticTokens$1, "__esModule", { value: true });
protocol_semanticTokens$1.SemanticTokensRefreshRequest = protocol_semanticTokens$1.SemanticTokensRangeRequest = protocol_semanticTokens$1.SemanticTokensDeltaRequest = protocol_semanticTokens$1.SemanticTokensRequest = protocol_semanticTokens$1.SemanticTokensRegistrationType = protocol_semanticTokens$1.TokenFormat = void 0;
const messages_1$a = messages$2;
var TokenFormat;
(function (TokenFormat) {
    TokenFormat.Relative = 'relative';
})(TokenFormat || (protocol_semanticTokens$1.TokenFormat = TokenFormat = {}));
var SemanticTokensRegistrationType;
(function (SemanticTokensRegistrationType) {
    SemanticTokensRegistrationType.method = 'textDocument/semanticTokens';
    SemanticTokensRegistrationType.type = new messages_1$a.RegistrationType(SemanticTokensRegistrationType.method);
})(SemanticTokensRegistrationType || (protocol_semanticTokens$1.SemanticTokensRegistrationType = SemanticTokensRegistrationType = {}));
var SemanticTokensRequest;
(function (SemanticTokensRequest) {
    SemanticTokensRequest.method = 'textDocument/semanticTokens/full';
    SemanticTokensRequest.messageDirection = messages_1$a.MessageDirection.clientToServer;
    SemanticTokensRequest.type = new messages_1$a.ProtocolRequestType(SemanticTokensRequest.method);
    SemanticTokensRequest.registrationMethod = SemanticTokensRegistrationType.method;
})(SemanticTokensRequest || (protocol_semanticTokens$1.SemanticTokensRequest = SemanticTokensRequest = {}));
var SemanticTokensDeltaRequest;
(function (SemanticTokensDeltaRequest) {
    SemanticTokensDeltaRequest.method = 'textDocument/semanticTokens/full/delta';
    SemanticTokensDeltaRequest.messageDirection = messages_1$a.MessageDirection.clientToServer;
    SemanticTokensDeltaRequest.type = new messages_1$a.ProtocolRequestType(SemanticTokensDeltaRequest.method);
    SemanticTokensDeltaRequest.registrationMethod = SemanticTokensRegistrationType.method;
})(SemanticTokensDeltaRequest || (protocol_semanticTokens$1.SemanticTokensDeltaRequest = SemanticTokensDeltaRequest = {}));
var SemanticTokensRangeRequest;
(function (SemanticTokensRangeRequest) {
    SemanticTokensRangeRequest.method = 'textDocument/semanticTokens/range';
    SemanticTokensRangeRequest.messageDirection = messages_1$a.MessageDirection.clientToServer;
    SemanticTokensRangeRequest.type = new messages_1$a.ProtocolRequestType(SemanticTokensRangeRequest.method);
    SemanticTokensRangeRequest.registrationMethod = SemanticTokensRegistrationType.method;
})(SemanticTokensRangeRequest || (protocol_semanticTokens$1.SemanticTokensRangeRequest = SemanticTokensRangeRequest = {}));
var SemanticTokensRefreshRequest;
(function (SemanticTokensRefreshRequest) {
    SemanticTokensRefreshRequest.method = `workspace/semanticTokens/refresh`;
    SemanticTokensRefreshRequest.messageDirection = messages_1$a.MessageDirection.serverToClient;
    SemanticTokensRefreshRequest.type = new messages_1$a.ProtocolRequestType0(SemanticTokensRefreshRequest.method);
})(SemanticTokensRefreshRequest || (protocol_semanticTokens$1.SemanticTokensRefreshRequest = SemanticTokensRefreshRequest = {}));

var protocol_showDocument$1 = {};

Object.defineProperty(protocol_showDocument$1, "__esModule", { value: true });
protocol_showDocument$1.ShowDocumentRequest = void 0;
const messages_1$9 = messages$2;
var ShowDocumentRequest;
(function (ShowDocumentRequest) {
    ShowDocumentRequest.method = 'window/showDocument';
    ShowDocumentRequest.messageDirection = messages_1$9.MessageDirection.serverToClient;
    ShowDocumentRequest.type = new messages_1$9.ProtocolRequestType(ShowDocumentRequest.method);
})(ShowDocumentRequest || (protocol_showDocument$1.ShowDocumentRequest = ShowDocumentRequest = {}));

var protocol_linkedEditingRange$1 = {};

Object.defineProperty(protocol_linkedEditingRange$1, "__esModule", { value: true });
protocol_linkedEditingRange$1.LinkedEditingRangeRequest = void 0;
const messages_1$8 = messages$2;
var LinkedEditingRangeRequest;
(function (LinkedEditingRangeRequest) {
    LinkedEditingRangeRequest.method = 'textDocument/linkedEditingRange';
    LinkedEditingRangeRequest.messageDirection = messages_1$8.MessageDirection.clientToServer;
    LinkedEditingRangeRequest.type = new messages_1$8.ProtocolRequestType(LinkedEditingRangeRequest.method);
})(LinkedEditingRangeRequest || (protocol_linkedEditingRange$1.LinkedEditingRangeRequest = LinkedEditingRangeRequest = {}));

var protocol_fileOperations$1 = {};

Object.defineProperty(protocol_fileOperations$1, "__esModule", { value: true });
protocol_fileOperations$1.WillDeleteFilesRequest = protocol_fileOperations$1.DidDeleteFilesNotification = protocol_fileOperations$1.DidRenameFilesNotification = protocol_fileOperations$1.WillRenameFilesRequest = protocol_fileOperations$1.DidCreateFilesNotification = protocol_fileOperations$1.WillCreateFilesRequest = protocol_fileOperations$1.FileOperationPatternKind = void 0;
const messages_1$7 = messages$2;
var FileOperationPatternKind;
(function (FileOperationPatternKind) {
    FileOperationPatternKind.file = 'file';
    FileOperationPatternKind.folder = 'folder';
})(FileOperationPatternKind || (protocol_fileOperations$1.FileOperationPatternKind = FileOperationPatternKind = {}));
var WillCreateFilesRequest;
(function (WillCreateFilesRequest) {
    WillCreateFilesRequest.method = 'workspace/willCreateFiles';
    WillCreateFilesRequest.messageDirection = messages_1$7.MessageDirection.clientToServer;
    WillCreateFilesRequest.type = new messages_1$7.ProtocolRequestType(WillCreateFilesRequest.method);
})(WillCreateFilesRequest || (protocol_fileOperations$1.WillCreateFilesRequest = WillCreateFilesRequest = {}));
var DidCreateFilesNotification;
(function (DidCreateFilesNotification) {
    DidCreateFilesNotification.method = 'workspace/didCreateFiles';
    DidCreateFilesNotification.messageDirection = messages_1$7.MessageDirection.clientToServer;
    DidCreateFilesNotification.type = new messages_1$7.ProtocolNotificationType(DidCreateFilesNotification.method);
})(DidCreateFilesNotification || (protocol_fileOperations$1.DidCreateFilesNotification = DidCreateFilesNotification = {}));
var WillRenameFilesRequest;
(function (WillRenameFilesRequest) {
    WillRenameFilesRequest.method = 'workspace/willRenameFiles';
    WillRenameFilesRequest.messageDirection = messages_1$7.MessageDirection.clientToServer;
    WillRenameFilesRequest.type = new messages_1$7.ProtocolRequestType(WillRenameFilesRequest.method);
})(WillRenameFilesRequest || (protocol_fileOperations$1.WillRenameFilesRequest = WillRenameFilesRequest = {}));
var DidRenameFilesNotification;
(function (DidRenameFilesNotification) {
    DidRenameFilesNotification.method = 'workspace/didRenameFiles';
    DidRenameFilesNotification.messageDirection = messages_1$7.MessageDirection.clientToServer;
    DidRenameFilesNotification.type = new messages_1$7.ProtocolNotificationType(DidRenameFilesNotification.method);
})(DidRenameFilesNotification || (protocol_fileOperations$1.DidRenameFilesNotification = DidRenameFilesNotification = {}));
var DidDeleteFilesNotification;
(function (DidDeleteFilesNotification) {
    DidDeleteFilesNotification.method = 'workspace/didDeleteFiles';
    DidDeleteFilesNotification.messageDirection = messages_1$7.MessageDirection.clientToServer;
    DidDeleteFilesNotification.type = new messages_1$7.ProtocolNotificationType(DidDeleteFilesNotification.method);
})(DidDeleteFilesNotification || (protocol_fileOperations$1.DidDeleteFilesNotification = DidDeleteFilesNotification = {}));
var WillDeleteFilesRequest;
(function (WillDeleteFilesRequest) {
    WillDeleteFilesRequest.method = 'workspace/willDeleteFiles';
    WillDeleteFilesRequest.messageDirection = messages_1$7.MessageDirection.clientToServer;
    WillDeleteFilesRequest.type = new messages_1$7.ProtocolRequestType(WillDeleteFilesRequest.method);
})(WillDeleteFilesRequest || (protocol_fileOperations$1.WillDeleteFilesRequest = WillDeleteFilesRequest = {}));

var protocol_moniker$1 = {};

Object.defineProperty(protocol_moniker$1, "__esModule", { value: true });
protocol_moniker$1.MonikerRequest = protocol_moniker$1.MonikerKind = protocol_moniker$1.UniquenessLevel = void 0;
const messages_1$6 = messages$2;
var UniquenessLevel;
(function (UniquenessLevel) {
    UniquenessLevel.document = 'document';
    UniquenessLevel.project = 'project';
    UniquenessLevel.group = 'group';
    UniquenessLevel.scheme = 'scheme';
    UniquenessLevel.global = 'global';
})(UniquenessLevel || (protocol_moniker$1.UniquenessLevel = UniquenessLevel = {}));
var MonikerKind;
(function (MonikerKind) {
    MonikerKind.$import = 'import';
    MonikerKind.$export = 'export';
    MonikerKind.local = 'local';
})(MonikerKind || (protocol_moniker$1.MonikerKind = MonikerKind = {}));
var MonikerRequest;
(function (MonikerRequest) {
    MonikerRequest.method = 'textDocument/moniker';
    MonikerRequest.messageDirection = messages_1$6.MessageDirection.clientToServer;
    MonikerRequest.type = new messages_1$6.ProtocolRequestType(MonikerRequest.method);
})(MonikerRequest || (protocol_moniker$1.MonikerRequest = MonikerRequest = {}));

var protocol_typeHierarchy$1 = {};

Object.defineProperty(protocol_typeHierarchy$1, "__esModule", { value: true });
protocol_typeHierarchy$1.TypeHierarchySubtypesRequest = protocol_typeHierarchy$1.TypeHierarchySupertypesRequest = protocol_typeHierarchy$1.TypeHierarchyPrepareRequest = void 0;
const messages_1$5 = messages$2;
var TypeHierarchyPrepareRequest;
(function (TypeHierarchyPrepareRequest) {
    TypeHierarchyPrepareRequest.method = 'textDocument/prepareTypeHierarchy';
    TypeHierarchyPrepareRequest.messageDirection = messages_1$5.MessageDirection.clientToServer;
    TypeHierarchyPrepareRequest.type = new messages_1$5.ProtocolRequestType(TypeHierarchyPrepareRequest.method);
})(TypeHierarchyPrepareRequest || (protocol_typeHierarchy$1.TypeHierarchyPrepareRequest = TypeHierarchyPrepareRequest = {}));
var TypeHierarchySupertypesRequest;
(function (TypeHierarchySupertypesRequest) {
    TypeHierarchySupertypesRequest.method = 'typeHierarchy/supertypes';
    TypeHierarchySupertypesRequest.messageDirection = messages_1$5.MessageDirection.clientToServer;
    TypeHierarchySupertypesRequest.type = new messages_1$5.ProtocolRequestType(TypeHierarchySupertypesRequest.method);
})(TypeHierarchySupertypesRequest || (protocol_typeHierarchy$1.TypeHierarchySupertypesRequest = TypeHierarchySupertypesRequest = {}));
var TypeHierarchySubtypesRequest;
(function (TypeHierarchySubtypesRequest) {
    TypeHierarchySubtypesRequest.method = 'typeHierarchy/subtypes';
    TypeHierarchySubtypesRequest.messageDirection = messages_1$5.MessageDirection.clientToServer;
    TypeHierarchySubtypesRequest.type = new messages_1$5.ProtocolRequestType(TypeHierarchySubtypesRequest.method);
})(TypeHierarchySubtypesRequest || (protocol_typeHierarchy$1.TypeHierarchySubtypesRequest = TypeHierarchySubtypesRequest = {}));

var protocol_inlineValue$1 = {};

Object.defineProperty(protocol_inlineValue$1, "__esModule", { value: true });
protocol_inlineValue$1.InlineValueRefreshRequest = protocol_inlineValue$1.InlineValueRequest = void 0;
const messages_1$4 = messages$2;
var InlineValueRequest;
(function (InlineValueRequest) {
    InlineValueRequest.method = 'textDocument/inlineValue';
    InlineValueRequest.messageDirection = messages_1$4.MessageDirection.clientToServer;
    InlineValueRequest.type = new messages_1$4.ProtocolRequestType(InlineValueRequest.method);
})(InlineValueRequest || (protocol_inlineValue$1.InlineValueRequest = InlineValueRequest = {}));
var InlineValueRefreshRequest;
(function (InlineValueRefreshRequest) {
    InlineValueRefreshRequest.method = `workspace/inlineValue/refresh`;
    InlineValueRefreshRequest.messageDirection = messages_1$4.MessageDirection.serverToClient;
    InlineValueRefreshRequest.type = new messages_1$4.ProtocolRequestType0(InlineValueRefreshRequest.method);
})(InlineValueRefreshRequest || (protocol_inlineValue$1.InlineValueRefreshRequest = InlineValueRefreshRequest = {}));

var protocol_inlayHint$1 = {};

Object.defineProperty(protocol_inlayHint$1, "__esModule", { value: true });
protocol_inlayHint$1.InlayHintRefreshRequest = protocol_inlayHint$1.InlayHintResolveRequest = protocol_inlayHint$1.InlayHintRequest = void 0;
const messages_1$3 = messages$2;
var InlayHintRequest;
(function (InlayHintRequest) {
    InlayHintRequest.method = 'textDocument/inlayHint';
    InlayHintRequest.messageDirection = messages_1$3.MessageDirection.clientToServer;
    InlayHintRequest.type = new messages_1$3.ProtocolRequestType(InlayHintRequest.method);
})(InlayHintRequest || (protocol_inlayHint$1.InlayHintRequest = InlayHintRequest = {}));
var InlayHintResolveRequest;
(function (InlayHintResolveRequest) {
    InlayHintResolveRequest.method = 'inlayHint/resolve';
    InlayHintResolveRequest.messageDirection = messages_1$3.MessageDirection.clientToServer;
    InlayHintResolveRequest.type = new messages_1$3.ProtocolRequestType(InlayHintResolveRequest.method);
})(InlayHintResolveRequest || (protocol_inlayHint$1.InlayHintResolveRequest = InlayHintResolveRequest = {}));
var InlayHintRefreshRequest;
(function (InlayHintRefreshRequest) {
    InlayHintRefreshRequest.method = `workspace/inlayHint/refresh`;
    InlayHintRefreshRequest.messageDirection = messages_1$3.MessageDirection.serverToClient;
    InlayHintRefreshRequest.type = new messages_1$3.ProtocolRequestType0(InlayHintRefreshRequest.method);
})(InlayHintRefreshRequest || (protocol_inlayHint$1.InlayHintRefreshRequest = InlayHintRefreshRequest = {}));

var protocol_diagnostic$1 = {};

Object.defineProperty(protocol_diagnostic$1, "__esModule", { value: true });
protocol_diagnostic$1.DiagnosticRefreshRequest = protocol_diagnostic$1.WorkspaceDiagnosticRequest = protocol_diagnostic$1.DocumentDiagnosticRequest = protocol_diagnostic$1.DocumentDiagnosticReportKind = protocol_diagnostic$1.DiagnosticServerCancellationData = void 0;
const vscode_jsonrpc_1$2 = main$6;
const Is$5 = is$2;
const messages_1$2 = messages$2;
var DiagnosticServerCancellationData;
(function (DiagnosticServerCancellationData) {
    function is(value) {
        const candidate = value;
        return candidate && Is$5.boolean(candidate.retriggerRequest);
    }
    DiagnosticServerCancellationData.is = is;
})(DiagnosticServerCancellationData || (protocol_diagnostic$1.DiagnosticServerCancellationData = DiagnosticServerCancellationData = {}));
var DocumentDiagnosticReportKind;
(function (DocumentDiagnosticReportKind) {
    DocumentDiagnosticReportKind.Full = 'full';
    DocumentDiagnosticReportKind.Unchanged = 'unchanged';
})(DocumentDiagnosticReportKind || (protocol_diagnostic$1.DocumentDiagnosticReportKind = DocumentDiagnosticReportKind = {}));
var DocumentDiagnosticRequest;
(function (DocumentDiagnosticRequest) {
    DocumentDiagnosticRequest.method = 'textDocument/diagnostic';
    DocumentDiagnosticRequest.messageDirection = messages_1$2.MessageDirection.clientToServer;
    DocumentDiagnosticRequest.type = new messages_1$2.ProtocolRequestType(DocumentDiagnosticRequest.method);
    DocumentDiagnosticRequest.partialResult = new vscode_jsonrpc_1$2.ProgressType();
})(DocumentDiagnosticRequest || (protocol_diagnostic$1.DocumentDiagnosticRequest = DocumentDiagnosticRequest = {}));
var WorkspaceDiagnosticRequest;
(function (WorkspaceDiagnosticRequest) {
    WorkspaceDiagnosticRequest.method = 'workspace/diagnostic';
    WorkspaceDiagnosticRequest.messageDirection = messages_1$2.MessageDirection.clientToServer;
    WorkspaceDiagnosticRequest.type = new messages_1$2.ProtocolRequestType(WorkspaceDiagnosticRequest.method);
    WorkspaceDiagnosticRequest.partialResult = new vscode_jsonrpc_1$2.ProgressType();
})(WorkspaceDiagnosticRequest || (protocol_diagnostic$1.WorkspaceDiagnosticRequest = WorkspaceDiagnosticRequest = {}));
var DiagnosticRefreshRequest;
(function (DiagnosticRefreshRequest) {
    DiagnosticRefreshRequest.method = `workspace/diagnostic/refresh`;
    DiagnosticRefreshRequest.messageDirection = messages_1$2.MessageDirection.serverToClient;
    DiagnosticRefreshRequest.type = new messages_1$2.ProtocolRequestType0(DiagnosticRefreshRequest.method);
})(DiagnosticRefreshRequest || (protocol_diagnostic$1.DiagnosticRefreshRequest = DiagnosticRefreshRequest = {}));

var protocol_notebook$1 = {};

Object.defineProperty(protocol_notebook$1, "__esModule", { value: true });
protocol_notebook$1.DidCloseNotebookDocumentNotification = protocol_notebook$1.DidSaveNotebookDocumentNotification = protocol_notebook$1.DidChangeNotebookDocumentNotification = protocol_notebook$1.NotebookCellArrayChange = protocol_notebook$1.DidOpenNotebookDocumentNotification = protocol_notebook$1.NotebookDocumentSyncRegistrationType = protocol_notebook$1.NotebookDocument = protocol_notebook$1.NotebookCell = protocol_notebook$1.ExecutionSummary = protocol_notebook$1.NotebookCellKind = void 0;
const vscode_languageserver_types_1$5 = mainExports;
const Is$4 = is$2;
const messages_1$1 = messages$2;
var NotebookCellKind;
(function (NotebookCellKind) {
    NotebookCellKind.Markup = 1;
    NotebookCellKind.Code = 2;
    function is(value) {
        return value === 1 || value === 2;
    }
    NotebookCellKind.is = is;
})(NotebookCellKind || (protocol_notebook$1.NotebookCellKind = NotebookCellKind = {}));
var ExecutionSummary;
(function (ExecutionSummary) {
    function create(executionOrder, success) {
        const result = { executionOrder };
        if (success === true || success === false) {
            result.success = success;
        }
        return result;
    }
    ExecutionSummary.create = create;
    function is(value) {
        const candidate = value;
        return Is$4.objectLiteral(candidate) && vscode_languageserver_types_1$5.uinteger.is(candidate.executionOrder) && (candidate.success === undefined || Is$4.boolean(candidate.success));
    }
    ExecutionSummary.is = is;
    function equals(one, other) {
        if (one === other) {
            return true;
        }
        if (one === null || one === undefined || other === null || other === undefined) {
            return false;
        }
        return one.executionOrder === other.executionOrder && one.success === other.success;
    }
    ExecutionSummary.equals = equals;
})(ExecutionSummary || (protocol_notebook$1.ExecutionSummary = ExecutionSummary = {}));
var NotebookCell;
(function (NotebookCell) {
    function create(kind, document) {
        return { kind, document };
    }
    NotebookCell.create = create;
    function is(value) {
        const candidate = value;
        return Is$4.objectLiteral(candidate) && NotebookCellKind.is(candidate.kind) && vscode_languageserver_types_1$5.DocumentUri.is(candidate.document) &&
            (candidate.metadata === undefined || Is$4.objectLiteral(candidate.metadata));
    }
    NotebookCell.is = is;
    function diff(one, two) {
        const result = new Set();
        if (one.document !== two.document) {
            result.add('document');
        }
        if (one.kind !== two.kind) {
            result.add('kind');
        }
        if (one.executionSummary !== two.executionSummary) {
            result.add('executionSummary');
        }
        if ((one.metadata !== undefined || two.metadata !== undefined) && !equalsMetadata(one.metadata, two.metadata)) {
            result.add('metadata');
        }
        if ((one.executionSummary !== undefined || two.executionSummary !== undefined) && !ExecutionSummary.equals(one.executionSummary, two.executionSummary)) {
            result.add('executionSummary');
        }
        return result;
    }
    NotebookCell.diff = diff;
    function equalsMetadata(one, other) {
        if (one === other) {
            return true;
        }
        if (one === null || one === undefined || other === null || other === undefined) {
            return false;
        }
        if (typeof one !== typeof other) {
            return false;
        }
        if (typeof one !== 'object') {
            return false;
        }
        const oneArray = Array.isArray(one);
        const otherArray = Array.isArray(other);
        if (oneArray !== otherArray) {
            return false;
        }
        if (oneArray && otherArray) {
            if (one.length !== other.length) {
                return false;
            }
            for (let i = 0; i < one.length; i++) {
                if (!equalsMetadata(one[i], other[i])) {
                    return false;
                }
            }
        }
        if (Is$4.objectLiteral(one) && Is$4.objectLiteral(other)) {
            const oneKeys = Object.keys(one);
            const otherKeys = Object.keys(other);
            if (oneKeys.length !== otherKeys.length) {
                return false;
            }
            oneKeys.sort();
            otherKeys.sort();
            if (!equalsMetadata(oneKeys, otherKeys)) {
                return false;
            }
            for (let i = 0; i < oneKeys.length; i++) {
                const prop = oneKeys[i];
                if (!equalsMetadata(one[prop], other[prop])) {
                    return false;
                }
            }
        }
        return true;
    }
})(NotebookCell || (protocol_notebook$1.NotebookCell = NotebookCell = {}));
var NotebookDocument;
(function (NotebookDocument) {
    function create(uri, notebookType, version, cells) {
        return { uri, notebookType, version, cells };
    }
    NotebookDocument.create = create;
    function is(value) {
        const candidate = value;
        return Is$4.objectLiteral(candidate) && Is$4.string(candidate.uri) && vscode_languageserver_types_1$5.integer.is(candidate.version) && Is$4.typedArray(candidate.cells, NotebookCell.is);
    }
    NotebookDocument.is = is;
})(NotebookDocument || (protocol_notebook$1.NotebookDocument = NotebookDocument = {}));
var NotebookDocumentSyncRegistrationType;
(function (NotebookDocumentSyncRegistrationType) {
    NotebookDocumentSyncRegistrationType.method = 'notebookDocument/sync';
    NotebookDocumentSyncRegistrationType.messageDirection = messages_1$1.MessageDirection.clientToServer;
    NotebookDocumentSyncRegistrationType.type = new messages_1$1.RegistrationType(NotebookDocumentSyncRegistrationType.method);
})(NotebookDocumentSyncRegistrationType || (protocol_notebook$1.NotebookDocumentSyncRegistrationType = NotebookDocumentSyncRegistrationType = {}));
var DidOpenNotebookDocumentNotification;
(function (DidOpenNotebookDocumentNotification) {
    DidOpenNotebookDocumentNotification.method = 'notebookDocument/didOpen';
    DidOpenNotebookDocumentNotification.messageDirection = messages_1$1.MessageDirection.clientToServer;
    DidOpenNotebookDocumentNotification.type = new messages_1$1.ProtocolNotificationType(DidOpenNotebookDocumentNotification.method);
    DidOpenNotebookDocumentNotification.registrationMethod = NotebookDocumentSyncRegistrationType.method;
})(DidOpenNotebookDocumentNotification || (protocol_notebook$1.DidOpenNotebookDocumentNotification = DidOpenNotebookDocumentNotification = {}));
var NotebookCellArrayChange;
(function (NotebookCellArrayChange) {
    function is(value) {
        const candidate = value;
        return Is$4.objectLiteral(candidate) && vscode_languageserver_types_1$5.uinteger.is(candidate.start) && vscode_languageserver_types_1$5.uinteger.is(candidate.deleteCount) && (candidate.cells === undefined || Is$4.typedArray(candidate.cells, NotebookCell.is));
    }
    NotebookCellArrayChange.is = is;
    function create(start, deleteCount, cells) {
        const result = { start, deleteCount };
        if (cells !== undefined) {
            result.cells = cells;
        }
        return result;
    }
    NotebookCellArrayChange.create = create;
})(NotebookCellArrayChange || (protocol_notebook$1.NotebookCellArrayChange = NotebookCellArrayChange = {}));
var DidChangeNotebookDocumentNotification;
(function (DidChangeNotebookDocumentNotification) {
    DidChangeNotebookDocumentNotification.method = 'notebookDocument/didChange';
    DidChangeNotebookDocumentNotification.messageDirection = messages_1$1.MessageDirection.clientToServer;
    DidChangeNotebookDocumentNotification.type = new messages_1$1.ProtocolNotificationType(DidChangeNotebookDocumentNotification.method);
    DidChangeNotebookDocumentNotification.registrationMethod = NotebookDocumentSyncRegistrationType.method;
})(DidChangeNotebookDocumentNotification || (protocol_notebook$1.DidChangeNotebookDocumentNotification = DidChangeNotebookDocumentNotification = {}));
var DidSaveNotebookDocumentNotification;
(function (DidSaveNotebookDocumentNotification) {
    DidSaveNotebookDocumentNotification.method = 'notebookDocument/didSave';
    DidSaveNotebookDocumentNotification.messageDirection = messages_1$1.MessageDirection.clientToServer;
    DidSaveNotebookDocumentNotification.type = new messages_1$1.ProtocolNotificationType(DidSaveNotebookDocumentNotification.method);
    DidSaveNotebookDocumentNotification.registrationMethod = NotebookDocumentSyncRegistrationType.method;
})(DidSaveNotebookDocumentNotification || (protocol_notebook$1.DidSaveNotebookDocumentNotification = DidSaveNotebookDocumentNotification = {}));
var DidCloseNotebookDocumentNotification;
(function (DidCloseNotebookDocumentNotification) {
    DidCloseNotebookDocumentNotification.method = 'notebookDocument/didClose';
    DidCloseNotebookDocumentNotification.messageDirection = messages_1$1.MessageDirection.clientToServer;
    DidCloseNotebookDocumentNotification.type = new messages_1$1.ProtocolNotificationType(DidCloseNotebookDocumentNotification.method);
    DidCloseNotebookDocumentNotification.registrationMethod = NotebookDocumentSyncRegistrationType.method;
})(DidCloseNotebookDocumentNotification || (protocol_notebook$1.DidCloseNotebookDocumentNotification = DidCloseNotebookDocumentNotification = {}));

var protocol_inlineCompletion = {};

Object.defineProperty(protocol_inlineCompletion, "__esModule", { value: true });
protocol_inlineCompletion.InlineCompletionRequest = void 0;
const messages_1 = messages$2;
var InlineCompletionRequest;
(function (InlineCompletionRequest) {
    InlineCompletionRequest.method = 'textDocument/inlineCompletion';
    InlineCompletionRequest.messageDirection = messages_1.MessageDirection.clientToServer;
    InlineCompletionRequest.type = new messages_1.ProtocolRequestType(InlineCompletionRequest.method);
})(InlineCompletionRequest || (protocol_inlineCompletion.InlineCompletionRequest = InlineCompletionRequest = {}));

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.WorkspaceSymbolRequest = exports.CodeActionResolveRequest = exports.CodeActionRequest = exports.DocumentSymbolRequest = exports.DocumentHighlightRequest = exports.ReferencesRequest = exports.DefinitionRequest = exports.SignatureHelpRequest = exports.SignatureHelpTriggerKind = exports.HoverRequest = exports.CompletionResolveRequest = exports.CompletionRequest = exports.CompletionTriggerKind = exports.PublishDiagnosticsNotification = exports.WatchKind = exports.RelativePattern = exports.FileChangeType = exports.DidChangeWatchedFilesNotification = exports.WillSaveTextDocumentWaitUntilRequest = exports.WillSaveTextDocumentNotification = exports.TextDocumentSaveReason = exports.DidSaveTextDocumentNotification = exports.DidCloseTextDocumentNotification = exports.DidChangeTextDocumentNotification = exports.TextDocumentContentChangeEvent = exports.DidOpenTextDocumentNotification = exports.TextDocumentSyncKind = exports.TelemetryEventNotification = exports.LogMessageNotification = exports.ShowMessageRequest = exports.ShowMessageNotification = exports.MessageType = exports.DidChangeConfigurationNotification = exports.ExitNotification = exports.ShutdownRequest = exports.InitializedNotification = exports.InitializeErrorCodes = exports.InitializeRequest = exports.WorkDoneProgressOptions = exports.TextDocumentRegistrationOptions = exports.StaticRegistrationOptions = exports.PositionEncodingKind = exports.FailureHandlingKind = exports.ResourceOperationKind = exports.UnregistrationRequest = exports.RegistrationRequest = exports.DocumentSelector = exports.NotebookCellTextDocumentFilter = exports.NotebookDocumentFilter = exports.TextDocumentFilter = void 0;
	exports.MonikerRequest = exports.MonikerKind = exports.UniquenessLevel = exports.WillDeleteFilesRequest = exports.DidDeleteFilesNotification = exports.WillRenameFilesRequest = exports.DidRenameFilesNotification = exports.WillCreateFilesRequest = exports.DidCreateFilesNotification = exports.FileOperationPatternKind = exports.LinkedEditingRangeRequest = exports.ShowDocumentRequest = exports.SemanticTokensRegistrationType = exports.SemanticTokensRefreshRequest = exports.SemanticTokensRangeRequest = exports.SemanticTokensDeltaRequest = exports.SemanticTokensRequest = exports.TokenFormat = exports.CallHierarchyPrepareRequest = exports.CallHierarchyOutgoingCallsRequest = exports.CallHierarchyIncomingCallsRequest = exports.WorkDoneProgressCancelNotification = exports.WorkDoneProgressCreateRequest = exports.WorkDoneProgress = exports.SelectionRangeRequest = exports.DeclarationRequest = exports.FoldingRangeRefreshRequest = exports.FoldingRangeRequest = exports.ColorPresentationRequest = exports.DocumentColorRequest = exports.ConfigurationRequest = exports.DidChangeWorkspaceFoldersNotification = exports.WorkspaceFoldersRequest = exports.TypeDefinitionRequest = exports.ImplementationRequest = exports.ApplyWorkspaceEditRequest = exports.ExecuteCommandRequest = exports.PrepareRenameRequest = exports.RenameRequest = exports.PrepareSupportDefaultBehavior = exports.DocumentOnTypeFormattingRequest = exports.DocumentRangesFormattingRequest = exports.DocumentRangeFormattingRequest = exports.DocumentFormattingRequest = exports.DocumentLinkResolveRequest = exports.DocumentLinkRequest = exports.CodeLensRefreshRequest = exports.CodeLensResolveRequest = exports.CodeLensRequest = exports.WorkspaceSymbolResolveRequest = void 0;
	exports.InlineCompletionRequest = exports.DidCloseNotebookDocumentNotification = exports.DidSaveNotebookDocumentNotification = exports.DidChangeNotebookDocumentNotification = exports.NotebookCellArrayChange = exports.DidOpenNotebookDocumentNotification = exports.NotebookDocumentSyncRegistrationType = exports.NotebookDocument = exports.NotebookCell = exports.ExecutionSummary = exports.NotebookCellKind = exports.DiagnosticRefreshRequest = exports.WorkspaceDiagnosticRequest = exports.DocumentDiagnosticRequest = exports.DocumentDiagnosticReportKind = exports.DiagnosticServerCancellationData = exports.InlayHintRefreshRequest = exports.InlayHintResolveRequest = exports.InlayHintRequest = exports.InlineValueRefreshRequest = exports.InlineValueRequest = exports.TypeHierarchySupertypesRequest = exports.TypeHierarchySubtypesRequest = exports.TypeHierarchyPrepareRequest = void 0;
	const messages_1 = messages$2;
	const vscode_languageserver_types_1 = mainExports;
	const Is = is$2;
	const protocol_implementation_1 = protocol_implementation$1;
	Object.defineProperty(exports, "ImplementationRequest", { enumerable: true, get: function () { return protocol_implementation_1.ImplementationRequest; } });
	const protocol_typeDefinition_1 = protocol_typeDefinition$1;
	Object.defineProperty(exports, "TypeDefinitionRequest", { enumerable: true, get: function () { return protocol_typeDefinition_1.TypeDefinitionRequest; } });
	const protocol_workspaceFolder_1 = protocol_workspaceFolder$1;
	Object.defineProperty(exports, "WorkspaceFoldersRequest", { enumerable: true, get: function () { return protocol_workspaceFolder_1.WorkspaceFoldersRequest; } });
	Object.defineProperty(exports, "DidChangeWorkspaceFoldersNotification", { enumerable: true, get: function () { return protocol_workspaceFolder_1.DidChangeWorkspaceFoldersNotification; } });
	const protocol_configuration_1 = protocol_configuration$1;
	Object.defineProperty(exports, "ConfigurationRequest", { enumerable: true, get: function () { return protocol_configuration_1.ConfigurationRequest; } });
	const protocol_colorProvider_1 = protocol_colorProvider$1;
	Object.defineProperty(exports, "DocumentColorRequest", { enumerable: true, get: function () { return protocol_colorProvider_1.DocumentColorRequest; } });
	Object.defineProperty(exports, "ColorPresentationRequest", { enumerable: true, get: function () { return protocol_colorProvider_1.ColorPresentationRequest; } });
	const protocol_foldingRange_1 = protocol_foldingRange$1;
	Object.defineProperty(exports, "FoldingRangeRequest", { enumerable: true, get: function () { return protocol_foldingRange_1.FoldingRangeRequest; } });
	Object.defineProperty(exports, "FoldingRangeRefreshRequest", { enumerable: true, get: function () { return protocol_foldingRange_1.FoldingRangeRefreshRequest; } });
	const protocol_declaration_1 = protocol_declaration$1;
	Object.defineProperty(exports, "DeclarationRequest", { enumerable: true, get: function () { return protocol_declaration_1.DeclarationRequest; } });
	const protocol_selectionRange_1 = protocol_selectionRange$1;
	Object.defineProperty(exports, "SelectionRangeRequest", { enumerable: true, get: function () { return protocol_selectionRange_1.SelectionRangeRequest; } });
	const protocol_progress_1 = protocol_progress$1;
	Object.defineProperty(exports, "WorkDoneProgress", { enumerable: true, get: function () { return protocol_progress_1.WorkDoneProgress; } });
	Object.defineProperty(exports, "WorkDoneProgressCreateRequest", { enumerable: true, get: function () { return protocol_progress_1.WorkDoneProgressCreateRequest; } });
	Object.defineProperty(exports, "WorkDoneProgressCancelNotification", { enumerable: true, get: function () { return protocol_progress_1.WorkDoneProgressCancelNotification; } });
	const protocol_callHierarchy_1 = protocol_callHierarchy$1;
	Object.defineProperty(exports, "CallHierarchyIncomingCallsRequest", { enumerable: true, get: function () { return protocol_callHierarchy_1.CallHierarchyIncomingCallsRequest; } });
	Object.defineProperty(exports, "CallHierarchyOutgoingCallsRequest", { enumerable: true, get: function () { return protocol_callHierarchy_1.CallHierarchyOutgoingCallsRequest; } });
	Object.defineProperty(exports, "CallHierarchyPrepareRequest", { enumerable: true, get: function () { return protocol_callHierarchy_1.CallHierarchyPrepareRequest; } });
	const protocol_semanticTokens_1 = protocol_semanticTokens$1;
	Object.defineProperty(exports, "TokenFormat", { enumerable: true, get: function () { return protocol_semanticTokens_1.TokenFormat; } });
	Object.defineProperty(exports, "SemanticTokensRequest", { enumerable: true, get: function () { return protocol_semanticTokens_1.SemanticTokensRequest; } });
	Object.defineProperty(exports, "SemanticTokensDeltaRequest", { enumerable: true, get: function () { return protocol_semanticTokens_1.SemanticTokensDeltaRequest; } });
	Object.defineProperty(exports, "SemanticTokensRangeRequest", { enumerable: true, get: function () { return protocol_semanticTokens_1.SemanticTokensRangeRequest; } });
	Object.defineProperty(exports, "SemanticTokensRefreshRequest", { enumerable: true, get: function () { return protocol_semanticTokens_1.SemanticTokensRefreshRequest; } });
	Object.defineProperty(exports, "SemanticTokensRegistrationType", { enumerable: true, get: function () { return protocol_semanticTokens_1.SemanticTokensRegistrationType; } });
	const protocol_showDocument_1 = protocol_showDocument$1;
	Object.defineProperty(exports, "ShowDocumentRequest", { enumerable: true, get: function () { return protocol_showDocument_1.ShowDocumentRequest; } });
	const protocol_linkedEditingRange_1 = protocol_linkedEditingRange$1;
	Object.defineProperty(exports, "LinkedEditingRangeRequest", { enumerable: true, get: function () { return protocol_linkedEditingRange_1.LinkedEditingRangeRequest; } });
	const protocol_fileOperations_1 = protocol_fileOperations$1;
	Object.defineProperty(exports, "FileOperationPatternKind", { enumerable: true, get: function () { return protocol_fileOperations_1.FileOperationPatternKind; } });
	Object.defineProperty(exports, "DidCreateFilesNotification", { enumerable: true, get: function () { return protocol_fileOperations_1.DidCreateFilesNotification; } });
	Object.defineProperty(exports, "WillCreateFilesRequest", { enumerable: true, get: function () { return protocol_fileOperations_1.WillCreateFilesRequest; } });
	Object.defineProperty(exports, "DidRenameFilesNotification", { enumerable: true, get: function () { return protocol_fileOperations_1.DidRenameFilesNotification; } });
	Object.defineProperty(exports, "WillRenameFilesRequest", { enumerable: true, get: function () { return protocol_fileOperations_1.WillRenameFilesRequest; } });
	Object.defineProperty(exports, "DidDeleteFilesNotification", { enumerable: true, get: function () { return protocol_fileOperations_1.DidDeleteFilesNotification; } });
	Object.defineProperty(exports, "WillDeleteFilesRequest", { enumerable: true, get: function () { return protocol_fileOperations_1.WillDeleteFilesRequest; } });
	const protocol_moniker_1 = protocol_moniker$1;
	Object.defineProperty(exports, "UniquenessLevel", { enumerable: true, get: function () { return protocol_moniker_1.UniquenessLevel; } });
	Object.defineProperty(exports, "MonikerKind", { enumerable: true, get: function () { return protocol_moniker_1.MonikerKind; } });
	Object.defineProperty(exports, "MonikerRequest", { enumerable: true, get: function () { return protocol_moniker_1.MonikerRequest; } });
	const protocol_typeHierarchy_1 = protocol_typeHierarchy$1;
	Object.defineProperty(exports, "TypeHierarchyPrepareRequest", { enumerable: true, get: function () { return protocol_typeHierarchy_1.TypeHierarchyPrepareRequest; } });
	Object.defineProperty(exports, "TypeHierarchySubtypesRequest", { enumerable: true, get: function () { return protocol_typeHierarchy_1.TypeHierarchySubtypesRequest; } });
	Object.defineProperty(exports, "TypeHierarchySupertypesRequest", { enumerable: true, get: function () { return protocol_typeHierarchy_1.TypeHierarchySupertypesRequest; } });
	const protocol_inlineValue_1 = protocol_inlineValue$1;
	Object.defineProperty(exports, "InlineValueRequest", { enumerable: true, get: function () { return protocol_inlineValue_1.InlineValueRequest; } });
	Object.defineProperty(exports, "InlineValueRefreshRequest", { enumerable: true, get: function () { return protocol_inlineValue_1.InlineValueRefreshRequest; } });
	const protocol_inlayHint_1 = protocol_inlayHint$1;
	Object.defineProperty(exports, "InlayHintRequest", { enumerable: true, get: function () { return protocol_inlayHint_1.InlayHintRequest; } });
	Object.defineProperty(exports, "InlayHintResolveRequest", { enumerable: true, get: function () { return protocol_inlayHint_1.InlayHintResolveRequest; } });
	Object.defineProperty(exports, "InlayHintRefreshRequest", { enumerable: true, get: function () { return protocol_inlayHint_1.InlayHintRefreshRequest; } });
	const protocol_diagnostic_1 = protocol_diagnostic$1;
	Object.defineProperty(exports, "DiagnosticServerCancellationData", { enumerable: true, get: function () { return protocol_diagnostic_1.DiagnosticServerCancellationData; } });
	Object.defineProperty(exports, "DocumentDiagnosticReportKind", { enumerable: true, get: function () { return protocol_diagnostic_1.DocumentDiagnosticReportKind; } });
	Object.defineProperty(exports, "DocumentDiagnosticRequest", { enumerable: true, get: function () { return protocol_diagnostic_1.DocumentDiagnosticRequest; } });
	Object.defineProperty(exports, "WorkspaceDiagnosticRequest", { enumerable: true, get: function () { return protocol_diagnostic_1.WorkspaceDiagnosticRequest; } });
	Object.defineProperty(exports, "DiagnosticRefreshRequest", { enumerable: true, get: function () { return protocol_diagnostic_1.DiagnosticRefreshRequest; } });
	const protocol_notebook_1 = protocol_notebook$1;
	Object.defineProperty(exports, "NotebookCellKind", { enumerable: true, get: function () { return protocol_notebook_1.NotebookCellKind; } });
	Object.defineProperty(exports, "ExecutionSummary", { enumerable: true, get: function () { return protocol_notebook_1.ExecutionSummary; } });
	Object.defineProperty(exports, "NotebookCell", { enumerable: true, get: function () { return protocol_notebook_1.NotebookCell; } });
	Object.defineProperty(exports, "NotebookDocument", { enumerable: true, get: function () { return protocol_notebook_1.NotebookDocument; } });
	Object.defineProperty(exports, "NotebookDocumentSyncRegistrationType", { enumerable: true, get: function () { return protocol_notebook_1.NotebookDocumentSyncRegistrationType; } });
	Object.defineProperty(exports, "DidOpenNotebookDocumentNotification", { enumerable: true, get: function () { return protocol_notebook_1.DidOpenNotebookDocumentNotification; } });
	Object.defineProperty(exports, "NotebookCellArrayChange", { enumerable: true, get: function () { return protocol_notebook_1.NotebookCellArrayChange; } });
	Object.defineProperty(exports, "DidChangeNotebookDocumentNotification", { enumerable: true, get: function () { return protocol_notebook_1.DidChangeNotebookDocumentNotification; } });
	Object.defineProperty(exports, "DidSaveNotebookDocumentNotification", { enumerable: true, get: function () { return protocol_notebook_1.DidSaveNotebookDocumentNotification; } });
	Object.defineProperty(exports, "DidCloseNotebookDocumentNotification", { enumerable: true, get: function () { return protocol_notebook_1.DidCloseNotebookDocumentNotification; } });
	const protocol_inlineCompletion_1 = protocol_inlineCompletion;
	Object.defineProperty(exports, "InlineCompletionRequest", { enumerable: true, get: function () { return protocol_inlineCompletion_1.InlineCompletionRequest; } });
	var TextDocumentFilter;
	(function (TextDocumentFilter) {
	    function is(value) {
	        const candidate = value;
	        return Is.string(candidate) || (Is.string(candidate.language) || Is.string(candidate.scheme) || Is.string(candidate.pattern));
	    }
	    TextDocumentFilter.is = is;
	})(TextDocumentFilter || (exports.TextDocumentFilter = TextDocumentFilter = {}));
	var NotebookDocumentFilter;
	(function (NotebookDocumentFilter) {
	    function is(value) {
	        const candidate = value;
	        return Is.objectLiteral(candidate) && (Is.string(candidate.notebookType) || Is.string(candidate.scheme) || Is.string(candidate.pattern));
	    }
	    NotebookDocumentFilter.is = is;
	})(NotebookDocumentFilter || (exports.NotebookDocumentFilter = NotebookDocumentFilter = {}));
	var NotebookCellTextDocumentFilter;
	(function (NotebookCellTextDocumentFilter) {
	    function is(value) {
	        const candidate = value;
	        return Is.objectLiteral(candidate)
	            && (Is.string(candidate.notebook) || NotebookDocumentFilter.is(candidate.notebook))
	            && (candidate.language === undefined || Is.string(candidate.language));
	    }
	    NotebookCellTextDocumentFilter.is = is;
	})(NotebookCellTextDocumentFilter || (exports.NotebookCellTextDocumentFilter = NotebookCellTextDocumentFilter = {}));
	var DocumentSelector;
	(function (DocumentSelector) {
	    function is(value) {
	        if (!Array.isArray(value)) {
	            return false;
	        }
	        for (let elem of value) {
	            if (!Is.string(elem) && !TextDocumentFilter.is(elem) && !NotebookCellTextDocumentFilter.is(elem)) {
	                return false;
	            }
	        }
	        return true;
	    }
	    DocumentSelector.is = is;
	})(DocumentSelector || (exports.DocumentSelector = DocumentSelector = {}));
	var RegistrationRequest;
	(function (RegistrationRequest) {
	    RegistrationRequest.method = 'client/registerCapability';
	    RegistrationRequest.messageDirection = messages_1.MessageDirection.serverToClient;
	    RegistrationRequest.type = new messages_1.ProtocolRequestType(RegistrationRequest.method);
	})(RegistrationRequest || (exports.RegistrationRequest = RegistrationRequest = {}));
	var UnregistrationRequest;
	(function (UnregistrationRequest) {
	    UnregistrationRequest.method = 'client/unregisterCapability';
	    UnregistrationRequest.messageDirection = messages_1.MessageDirection.serverToClient;
	    UnregistrationRequest.type = new messages_1.ProtocolRequestType(UnregistrationRequest.method);
	})(UnregistrationRequest || (exports.UnregistrationRequest = UnregistrationRequest = {}));
	var ResourceOperationKind;
	(function (ResourceOperationKind) {
	    ResourceOperationKind.Create = 'create';
	    ResourceOperationKind.Rename = 'rename';
	    ResourceOperationKind.Delete = 'delete';
	})(ResourceOperationKind || (exports.ResourceOperationKind = ResourceOperationKind = {}));
	var FailureHandlingKind;
	(function (FailureHandlingKind) {
	    FailureHandlingKind.Abort = 'abort';
	    FailureHandlingKind.Transactional = 'transactional';
	    FailureHandlingKind.TextOnlyTransactional = 'textOnlyTransactional';
	    FailureHandlingKind.Undo = 'undo';
	})(FailureHandlingKind || (exports.FailureHandlingKind = FailureHandlingKind = {}));
	var PositionEncodingKind;
	(function (PositionEncodingKind) {
	    PositionEncodingKind.UTF8 = 'utf-8';
	    PositionEncodingKind.UTF16 = 'utf-16';
	    PositionEncodingKind.UTF32 = 'utf-32';
	})(PositionEncodingKind || (exports.PositionEncodingKind = PositionEncodingKind = {}));
	var StaticRegistrationOptions;
	(function (StaticRegistrationOptions) {
	    function hasId(value) {
	        const candidate = value;
	        return candidate && Is.string(candidate.id) && candidate.id.length > 0;
	    }
	    StaticRegistrationOptions.hasId = hasId;
	})(StaticRegistrationOptions || (exports.StaticRegistrationOptions = StaticRegistrationOptions = {}));
	var TextDocumentRegistrationOptions;
	(function (TextDocumentRegistrationOptions) {
	    function is(value) {
	        const candidate = value;
	        return candidate && (candidate.documentSelector === null || DocumentSelector.is(candidate.documentSelector));
	    }
	    TextDocumentRegistrationOptions.is = is;
	})(TextDocumentRegistrationOptions || (exports.TextDocumentRegistrationOptions = TextDocumentRegistrationOptions = {}));
	var WorkDoneProgressOptions;
	(function (WorkDoneProgressOptions) {
	    function is(value) {
	        const candidate = value;
	        return Is.objectLiteral(candidate) && (candidate.workDoneProgress === undefined || Is.boolean(candidate.workDoneProgress));
	    }
	    WorkDoneProgressOptions.is = is;
	    function hasWorkDoneProgress(value) {
	        const candidate = value;
	        return candidate && Is.boolean(candidate.workDoneProgress);
	    }
	    WorkDoneProgressOptions.hasWorkDoneProgress = hasWorkDoneProgress;
	})(WorkDoneProgressOptions || (exports.WorkDoneProgressOptions = WorkDoneProgressOptions = {}));
	var InitializeRequest;
	(function (InitializeRequest) {
	    InitializeRequest.method = 'initialize';
	    InitializeRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    InitializeRequest.type = new messages_1.ProtocolRequestType(InitializeRequest.method);
	})(InitializeRequest || (exports.InitializeRequest = InitializeRequest = {}));
	var InitializeErrorCodes;
	(function (InitializeErrorCodes) {
	    InitializeErrorCodes.unknownProtocolVersion = 1;
	})(InitializeErrorCodes || (exports.InitializeErrorCodes = InitializeErrorCodes = {}));
	var InitializedNotification;
	(function (InitializedNotification) {
	    InitializedNotification.method = 'initialized';
	    InitializedNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    InitializedNotification.type = new messages_1.ProtocolNotificationType(InitializedNotification.method);
	})(InitializedNotification || (exports.InitializedNotification = InitializedNotification = {}));
	var ShutdownRequest;
	(function (ShutdownRequest) {
	    ShutdownRequest.method = 'shutdown';
	    ShutdownRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    ShutdownRequest.type = new messages_1.ProtocolRequestType0(ShutdownRequest.method);
	})(ShutdownRequest || (exports.ShutdownRequest = ShutdownRequest = {}));
	var ExitNotification;
	(function (ExitNotification) {
	    ExitNotification.method = 'exit';
	    ExitNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    ExitNotification.type = new messages_1.ProtocolNotificationType0(ExitNotification.method);
	})(ExitNotification || (exports.ExitNotification = ExitNotification = {}));
	var DidChangeConfigurationNotification;
	(function (DidChangeConfigurationNotification) {
	    DidChangeConfigurationNotification.method = 'workspace/didChangeConfiguration';
	    DidChangeConfigurationNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    DidChangeConfigurationNotification.type = new messages_1.ProtocolNotificationType(DidChangeConfigurationNotification.method);
	})(DidChangeConfigurationNotification || (exports.DidChangeConfigurationNotification = DidChangeConfigurationNotification = {}));
	var MessageType;
	(function (MessageType) {
	    MessageType.Error = 1;
	    MessageType.Warning = 2;
	    MessageType.Info = 3;
	    MessageType.Log = 4;
	    MessageType.Debug = 5;
	})(MessageType || (exports.MessageType = MessageType = {}));
	var ShowMessageNotification;
	(function (ShowMessageNotification) {
	    ShowMessageNotification.method = 'window/showMessage';
	    ShowMessageNotification.messageDirection = messages_1.MessageDirection.serverToClient;
	    ShowMessageNotification.type = new messages_1.ProtocolNotificationType(ShowMessageNotification.method);
	})(ShowMessageNotification || (exports.ShowMessageNotification = ShowMessageNotification = {}));
	var ShowMessageRequest;
	(function (ShowMessageRequest) {
	    ShowMessageRequest.method = 'window/showMessageRequest';
	    ShowMessageRequest.messageDirection = messages_1.MessageDirection.serverToClient;
	    ShowMessageRequest.type = new messages_1.ProtocolRequestType(ShowMessageRequest.method);
	})(ShowMessageRequest || (exports.ShowMessageRequest = ShowMessageRequest = {}));
	var LogMessageNotification;
	(function (LogMessageNotification) {
	    LogMessageNotification.method = 'window/logMessage';
	    LogMessageNotification.messageDirection = messages_1.MessageDirection.serverToClient;
	    LogMessageNotification.type = new messages_1.ProtocolNotificationType(LogMessageNotification.method);
	})(LogMessageNotification || (exports.LogMessageNotification = LogMessageNotification = {}));
	var TelemetryEventNotification;
	(function (TelemetryEventNotification) {
	    TelemetryEventNotification.method = 'telemetry/event';
	    TelemetryEventNotification.messageDirection = messages_1.MessageDirection.serverToClient;
	    TelemetryEventNotification.type = new messages_1.ProtocolNotificationType(TelemetryEventNotification.method);
	})(TelemetryEventNotification || (exports.TelemetryEventNotification = TelemetryEventNotification = {}));
	var TextDocumentSyncKind;
	(function (TextDocumentSyncKind) {
	    TextDocumentSyncKind.None = 0;
	    TextDocumentSyncKind.Full = 1;
	    TextDocumentSyncKind.Incremental = 2;
	})(TextDocumentSyncKind || (exports.TextDocumentSyncKind = TextDocumentSyncKind = {}));
	var DidOpenTextDocumentNotification;
	(function (DidOpenTextDocumentNotification) {
	    DidOpenTextDocumentNotification.method = 'textDocument/didOpen';
	    DidOpenTextDocumentNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    DidOpenTextDocumentNotification.type = new messages_1.ProtocolNotificationType(DidOpenTextDocumentNotification.method);
	})(DidOpenTextDocumentNotification || (exports.DidOpenTextDocumentNotification = DidOpenTextDocumentNotification = {}));
	var TextDocumentContentChangeEvent;
	(function (TextDocumentContentChangeEvent) {
	    function isIncremental(event) {
	        let candidate = event;
	        return candidate !== undefined && candidate !== null &&
	            typeof candidate.text === 'string' && candidate.range !== undefined &&
	            (candidate.rangeLength === undefined || typeof candidate.rangeLength === 'number');
	    }
	    TextDocumentContentChangeEvent.isIncremental = isIncremental;
	    function isFull(event) {
	        let candidate = event;
	        return candidate !== undefined && candidate !== null &&
	            typeof candidate.text === 'string' && candidate.range === undefined && candidate.rangeLength === undefined;
	    }
	    TextDocumentContentChangeEvent.isFull = isFull;
	})(TextDocumentContentChangeEvent || (exports.TextDocumentContentChangeEvent = TextDocumentContentChangeEvent = {}));
	var DidChangeTextDocumentNotification;
	(function (DidChangeTextDocumentNotification) {
	    DidChangeTextDocumentNotification.method = 'textDocument/didChange';
	    DidChangeTextDocumentNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    DidChangeTextDocumentNotification.type = new messages_1.ProtocolNotificationType(DidChangeTextDocumentNotification.method);
	})(DidChangeTextDocumentNotification || (exports.DidChangeTextDocumentNotification = DidChangeTextDocumentNotification = {}));
	var DidCloseTextDocumentNotification;
	(function (DidCloseTextDocumentNotification) {
	    DidCloseTextDocumentNotification.method = 'textDocument/didClose';
	    DidCloseTextDocumentNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    DidCloseTextDocumentNotification.type = new messages_1.ProtocolNotificationType(DidCloseTextDocumentNotification.method);
	})(DidCloseTextDocumentNotification || (exports.DidCloseTextDocumentNotification = DidCloseTextDocumentNotification = {}));
	var DidSaveTextDocumentNotification;
	(function (DidSaveTextDocumentNotification) {
	    DidSaveTextDocumentNotification.method = 'textDocument/didSave';
	    DidSaveTextDocumentNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    DidSaveTextDocumentNotification.type = new messages_1.ProtocolNotificationType(DidSaveTextDocumentNotification.method);
	})(DidSaveTextDocumentNotification || (exports.DidSaveTextDocumentNotification = DidSaveTextDocumentNotification = {}));
	var TextDocumentSaveReason;
	(function (TextDocumentSaveReason) {
	    TextDocumentSaveReason.Manual = 1;
	    TextDocumentSaveReason.AfterDelay = 2;
	    TextDocumentSaveReason.FocusOut = 3;
	})(TextDocumentSaveReason || (exports.TextDocumentSaveReason = TextDocumentSaveReason = {}));
	var WillSaveTextDocumentNotification;
	(function (WillSaveTextDocumentNotification) {
	    WillSaveTextDocumentNotification.method = 'textDocument/willSave';
	    WillSaveTextDocumentNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    WillSaveTextDocumentNotification.type = new messages_1.ProtocolNotificationType(WillSaveTextDocumentNotification.method);
	})(WillSaveTextDocumentNotification || (exports.WillSaveTextDocumentNotification = WillSaveTextDocumentNotification = {}));
	var WillSaveTextDocumentWaitUntilRequest;
	(function (WillSaveTextDocumentWaitUntilRequest) {
	    WillSaveTextDocumentWaitUntilRequest.method = 'textDocument/willSaveWaitUntil';
	    WillSaveTextDocumentWaitUntilRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    WillSaveTextDocumentWaitUntilRequest.type = new messages_1.ProtocolRequestType(WillSaveTextDocumentWaitUntilRequest.method);
	})(WillSaveTextDocumentWaitUntilRequest || (exports.WillSaveTextDocumentWaitUntilRequest = WillSaveTextDocumentWaitUntilRequest = {}));
	var DidChangeWatchedFilesNotification;
	(function (DidChangeWatchedFilesNotification) {
	    DidChangeWatchedFilesNotification.method = 'workspace/didChangeWatchedFiles';
	    DidChangeWatchedFilesNotification.messageDirection = messages_1.MessageDirection.clientToServer;
	    DidChangeWatchedFilesNotification.type = new messages_1.ProtocolNotificationType(DidChangeWatchedFilesNotification.method);
	})(DidChangeWatchedFilesNotification || (exports.DidChangeWatchedFilesNotification = DidChangeWatchedFilesNotification = {}));
	var FileChangeType;
	(function (FileChangeType) {
	    FileChangeType.Created = 1;
	    FileChangeType.Changed = 2;
	    FileChangeType.Deleted = 3;
	})(FileChangeType || (exports.FileChangeType = FileChangeType = {}));
	var RelativePattern;
	(function (RelativePattern) {
	    function is(value) {
	        const candidate = value;
	        return Is.objectLiteral(candidate) && (vscode_languageserver_types_1.URI.is(candidate.baseUri) || vscode_languageserver_types_1.WorkspaceFolder.is(candidate.baseUri)) && Is.string(candidate.pattern);
	    }
	    RelativePattern.is = is;
	})(RelativePattern || (exports.RelativePattern = RelativePattern = {}));
	var WatchKind;
	(function (WatchKind) {
	    WatchKind.Create = 1;
	    WatchKind.Change = 2;
	    WatchKind.Delete = 4;
	})(WatchKind || (exports.WatchKind = WatchKind = {}));
	var PublishDiagnosticsNotification;
	(function (PublishDiagnosticsNotification) {
	    PublishDiagnosticsNotification.method = 'textDocument/publishDiagnostics';
	    PublishDiagnosticsNotification.messageDirection = messages_1.MessageDirection.serverToClient;
	    PublishDiagnosticsNotification.type = new messages_1.ProtocolNotificationType(PublishDiagnosticsNotification.method);
	})(PublishDiagnosticsNotification || (exports.PublishDiagnosticsNotification = PublishDiagnosticsNotification = {}));
	var CompletionTriggerKind;
	(function (CompletionTriggerKind) {
	    CompletionTriggerKind.Invoked = 1;
	    CompletionTriggerKind.TriggerCharacter = 2;
	    CompletionTriggerKind.TriggerForIncompleteCompletions = 3;
	})(CompletionTriggerKind || (exports.CompletionTriggerKind = CompletionTriggerKind = {}));
	var CompletionRequest;
	(function (CompletionRequest) {
	    CompletionRequest.method = 'textDocument/completion';
	    CompletionRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    CompletionRequest.type = new messages_1.ProtocolRequestType(CompletionRequest.method);
	})(CompletionRequest || (exports.CompletionRequest = CompletionRequest = {}));
	var CompletionResolveRequest;
	(function (CompletionResolveRequest) {
	    CompletionResolveRequest.method = 'completionItem/resolve';
	    CompletionResolveRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    CompletionResolveRequest.type = new messages_1.ProtocolRequestType(CompletionResolveRequest.method);
	})(CompletionResolveRequest || (exports.CompletionResolveRequest = CompletionResolveRequest = {}));
	var HoverRequest;
	(function (HoverRequest) {
	    HoverRequest.method = 'textDocument/hover';
	    HoverRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    HoverRequest.type = new messages_1.ProtocolRequestType(HoverRequest.method);
	})(HoverRequest || (exports.HoverRequest = HoverRequest = {}));
	var SignatureHelpTriggerKind;
	(function (SignatureHelpTriggerKind) {
	    SignatureHelpTriggerKind.Invoked = 1;
	    SignatureHelpTriggerKind.TriggerCharacter = 2;
	    SignatureHelpTriggerKind.ContentChange = 3;
	})(SignatureHelpTriggerKind || (exports.SignatureHelpTriggerKind = SignatureHelpTriggerKind = {}));
	var SignatureHelpRequest;
	(function (SignatureHelpRequest) {
	    SignatureHelpRequest.method = 'textDocument/signatureHelp';
	    SignatureHelpRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    SignatureHelpRequest.type = new messages_1.ProtocolRequestType(SignatureHelpRequest.method);
	})(SignatureHelpRequest || (exports.SignatureHelpRequest = SignatureHelpRequest = {}));
	var DefinitionRequest;
	(function (DefinitionRequest) {
	    DefinitionRequest.method = 'textDocument/definition';
	    DefinitionRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DefinitionRequest.type = new messages_1.ProtocolRequestType(DefinitionRequest.method);
	})(DefinitionRequest || (exports.DefinitionRequest = DefinitionRequest = {}));
	var ReferencesRequest;
	(function (ReferencesRequest) {
	    ReferencesRequest.method = 'textDocument/references';
	    ReferencesRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    ReferencesRequest.type = new messages_1.ProtocolRequestType(ReferencesRequest.method);
	})(ReferencesRequest || (exports.ReferencesRequest = ReferencesRequest = {}));
	var DocumentHighlightRequest;
	(function (DocumentHighlightRequest) {
	    DocumentHighlightRequest.method = 'textDocument/documentHighlight';
	    DocumentHighlightRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentHighlightRequest.type = new messages_1.ProtocolRequestType(DocumentHighlightRequest.method);
	})(DocumentHighlightRequest || (exports.DocumentHighlightRequest = DocumentHighlightRequest = {}));
	var DocumentSymbolRequest;
	(function (DocumentSymbolRequest) {
	    DocumentSymbolRequest.method = 'textDocument/documentSymbol';
	    DocumentSymbolRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentSymbolRequest.type = new messages_1.ProtocolRequestType(DocumentSymbolRequest.method);
	})(DocumentSymbolRequest || (exports.DocumentSymbolRequest = DocumentSymbolRequest = {}));
	var CodeActionRequest;
	(function (CodeActionRequest) {
	    CodeActionRequest.method = 'textDocument/codeAction';
	    CodeActionRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    CodeActionRequest.type = new messages_1.ProtocolRequestType(CodeActionRequest.method);
	})(CodeActionRequest || (exports.CodeActionRequest = CodeActionRequest = {}));
	var CodeActionResolveRequest;
	(function (CodeActionResolveRequest) {
	    CodeActionResolveRequest.method = 'codeAction/resolve';
	    CodeActionResolveRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    CodeActionResolveRequest.type = new messages_1.ProtocolRequestType(CodeActionResolveRequest.method);
	})(CodeActionResolveRequest || (exports.CodeActionResolveRequest = CodeActionResolveRequest = {}));
	var WorkspaceSymbolRequest;
	(function (WorkspaceSymbolRequest) {
	    WorkspaceSymbolRequest.method = 'workspace/symbol';
	    WorkspaceSymbolRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    WorkspaceSymbolRequest.type = new messages_1.ProtocolRequestType(WorkspaceSymbolRequest.method);
	})(WorkspaceSymbolRequest || (exports.WorkspaceSymbolRequest = WorkspaceSymbolRequest = {}));
	var WorkspaceSymbolResolveRequest;
	(function (WorkspaceSymbolResolveRequest) {
	    WorkspaceSymbolResolveRequest.method = 'workspaceSymbol/resolve';
	    WorkspaceSymbolResolveRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    WorkspaceSymbolResolveRequest.type = new messages_1.ProtocolRequestType(WorkspaceSymbolResolveRequest.method);
	})(WorkspaceSymbolResolveRequest || (exports.WorkspaceSymbolResolveRequest = WorkspaceSymbolResolveRequest = {}));
	var CodeLensRequest;
	(function (CodeLensRequest) {
	    CodeLensRequest.method = 'textDocument/codeLens';
	    CodeLensRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    CodeLensRequest.type = new messages_1.ProtocolRequestType(CodeLensRequest.method);
	})(CodeLensRequest || (exports.CodeLensRequest = CodeLensRequest = {}));
	var CodeLensResolveRequest;
	(function (CodeLensResolveRequest) {
	    CodeLensResolveRequest.method = 'codeLens/resolve';
	    CodeLensResolveRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    CodeLensResolveRequest.type = new messages_1.ProtocolRequestType(CodeLensResolveRequest.method);
	})(CodeLensResolveRequest || (exports.CodeLensResolveRequest = CodeLensResolveRequest = {}));
	var CodeLensRefreshRequest;
	(function (CodeLensRefreshRequest) {
	    CodeLensRefreshRequest.method = `workspace/codeLens/refresh`;
	    CodeLensRefreshRequest.messageDirection = messages_1.MessageDirection.serverToClient;
	    CodeLensRefreshRequest.type = new messages_1.ProtocolRequestType0(CodeLensRefreshRequest.method);
	})(CodeLensRefreshRequest || (exports.CodeLensRefreshRequest = CodeLensRefreshRequest = {}));
	var DocumentLinkRequest;
	(function (DocumentLinkRequest) {
	    DocumentLinkRequest.method = 'textDocument/documentLink';
	    DocumentLinkRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentLinkRequest.type = new messages_1.ProtocolRequestType(DocumentLinkRequest.method);
	})(DocumentLinkRequest || (exports.DocumentLinkRequest = DocumentLinkRequest = {}));
	var DocumentLinkResolveRequest;
	(function (DocumentLinkResolveRequest) {
	    DocumentLinkResolveRequest.method = 'documentLink/resolve';
	    DocumentLinkResolveRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentLinkResolveRequest.type = new messages_1.ProtocolRequestType(DocumentLinkResolveRequest.method);
	})(DocumentLinkResolveRequest || (exports.DocumentLinkResolveRequest = DocumentLinkResolveRequest = {}));
	var DocumentFormattingRequest;
	(function (DocumentFormattingRequest) {
	    DocumentFormattingRequest.method = 'textDocument/formatting';
	    DocumentFormattingRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentFormattingRequest.type = new messages_1.ProtocolRequestType(DocumentFormattingRequest.method);
	})(DocumentFormattingRequest || (exports.DocumentFormattingRequest = DocumentFormattingRequest = {}));
	var DocumentRangeFormattingRequest;
	(function (DocumentRangeFormattingRequest) {
	    DocumentRangeFormattingRequest.method = 'textDocument/rangeFormatting';
	    DocumentRangeFormattingRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentRangeFormattingRequest.type = new messages_1.ProtocolRequestType(DocumentRangeFormattingRequest.method);
	})(DocumentRangeFormattingRequest || (exports.DocumentRangeFormattingRequest = DocumentRangeFormattingRequest = {}));
	var DocumentRangesFormattingRequest;
	(function (DocumentRangesFormattingRequest) {
	    DocumentRangesFormattingRequest.method = 'textDocument/rangesFormatting';
	    DocumentRangesFormattingRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentRangesFormattingRequest.type = new messages_1.ProtocolRequestType(DocumentRangesFormattingRequest.method);
	})(DocumentRangesFormattingRequest || (exports.DocumentRangesFormattingRequest = DocumentRangesFormattingRequest = {}));
	var DocumentOnTypeFormattingRequest;
	(function (DocumentOnTypeFormattingRequest) {
	    DocumentOnTypeFormattingRequest.method = 'textDocument/onTypeFormatting';
	    DocumentOnTypeFormattingRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    DocumentOnTypeFormattingRequest.type = new messages_1.ProtocolRequestType(DocumentOnTypeFormattingRequest.method);
	})(DocumentOnTypeFormattingRequest || (exports.DocumentOnTypeFormattingRequest = DocumentOnTypeFormattingRequest = {}));
	var PrepareSupportDefaultBehavior;
	(function (PrepareSupportDefaultBehavior) {
	    PrepareSupportDefaultBehavior.Identifier = 1;
	})(PrepareSupportDefaultBehavior || (exports.PrepareSupportDefaultBehavior = PrepareSupportDefaultBehavior = {}));
	var RenameRequest;
	(function (RenameRequest) {
	    RenameRequest.method = 'textDocument/rename';
	    RenameRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    RenameRequest.type = new messages_1.ProtocolRequestType(RenameRequest.method);
	})(RenameRequest || (exports.RenameRequest = RenameRequest = {}));
	var PrepareRenameRequest;
	(function (PrepareRenameRequest) {
	    PrepareRenameRequest.method = 'textDocument/prepareRename';
	    PrepareRenameRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    PrepareRenameRequest.type = new messages_1.ProtocolRequestType(PrepareRenameRequest.method);
	})(PrepareRenameRequest || (exports.PrepareRenameRequest = PrepareRenameRequest = {}));
	var ExecuteCommandRequest;
	(function (ExecuteCommandRequest) {
	    ExecuteCommandRequest.method = 'workspace/executeCommand';
	    ExecuteCommandRequest.messageDirection = messages_1.MessageDirection.clientToServer;
	    ExecuteCommandRequest.type = new messages_1.ProtocolRequestType(ExecuteCommandRequest.method);
	})(ExecuteCommandRequest || (exports.ExecuteCommandRequest = ExecuteCommandRequest = {}));
	var ApplyWorkspaceEditRequest;
	(function (ApplyWorkspaceEditRequest) {
	    ApplyWorkspaceEditRequest.method = 'workspace/applyEdit';
	    ApplyWorkspaceEditRequest.messageDirection = messages_1.MessageDirection.serverToClient;
	    ApplyWorkspaceEditRequest.type = new messages_1.ProtocolRequestType('workspace/applyEdit');
	})(ApplyWorkspaceEditRequest || (exports.ApplyWorkspaceEditRequest = ApplyWorkspaceEditRequest = {}));
} (protocol$1));
getDefaultExportFromCjs(protocol$1);

var connection$2 = {};

Object.defineProperty(connection$2, "__esModule", { value: true });
connection$2.createProtocolConnection = void 0;
const vscode_jsonrpc_1$1 = main$6;
function createProtocolConnection$1(input, output, logger, options) {
    if (vscode_jsonrpc_1$1.ConnectionStrategy.is(options)) {
        options = { connectionStrategy: options };
    }
    return (0, vscode_jsonrpc_1$1.createMessageConnection)(input, output, logger, options);
}
connection$2.createProtocolConnection = createProtocolConnection$1;

(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    var desc = Object.getOwnPropertyDescriptor(m, k);
	    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	      desc = { enumerable: true, get: function() { return m[k]; } };
	    }
	    Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.LSPErrorCodes = exports.createProtocolConnection = void 0;
	__exportStar(main$6, exports);
	__exportStar(mainExports, exports);
	__exportStar(messages$2, exports);
	__exportStar(protocol$1, exports);
	var connection_1 = connection$2;
	Object.defineProperty(exports, "createProtocolConnection", { enumerable: true, get: function () { return connection_1.createProtocolConnection; } });
	var LSPErrorCodes;
	(function (LSPErrorCodes) {
	    LSPErrorCodes.lspReservedErrorRangeStart = -32899;
	    LSPErrorCodes.RequestFailed = -32803;
	    LSPErrorCodes.ServerCancelled = -32802;
	    LSPErrorCodes.ContentModified = -32801;
	    LSPErrorCodes.RequestCancelled = -32800;
	    LSPErrorCodes.lspReservedErrorRangeEnd = -32800;
	})(LSPErrorCodes || (exports.LSPErrorCodes = LSPErrorCodes = {}));
} (api$3));
getDefaultExportFromCjs(api$3);

(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    var desc = Object.getOwnPropertyDescriptor(m, k);
	    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	      desc = { enumerable: true, get: function() { return m[k]; } };
	    }
	    Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createProtocolConnection = void 0;
	const node_1 = node$3;
	__exportStar(node$3, exports);
	__exportStar(api$3, exports);
	function createProtocolConnection(input, output, logger, options) {
	    return (0, node_1.createMessageConnection)(input, output, logger, options);
	}
	exports.createProtocolConnection = createProtocolConnection;
} (main$7));
getDefaultExportFromCjs(main$7);

var uuid = {};

Object.defineProperty(uuid, "__esModule", { value: true });
uuid.generateUuid = uuid.parse = uuid.isUUID = uuid.v4 = uuid.empty = void 0;
class ValueUUID {
    constructor(_value) {
        this._value = _value;
    }
    asHex() {
        return this._value;
    }
    equals(other) {
        return this.asHex() === other.asHex();
    }
}
class V4UUID extends ValueUUID {
    static _oneOf(array) {
        return array[Math.floor(array.length * Math.random())];
    }
    static _randomHex() {
        return V4UUID._oneOf(V4UUID._chars);
    }
    constructor() {
        super([
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            '-',
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            '-',
            '4',
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            '-',
            V4UUID._oneOf(V4UUID._timeHighBits),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            '-',
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
            V4UUID._randomHex(),
        ].join(''));
    }
}
V4UUID._chars = ['0', '1', '2', '3', '4', '5', '6', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'];
V4UUID._timeHighBits = ['8', '9', 'a', 'b'];
uuid.empty = new ValueUUID('00000000-0000-0000-0000-000000000000');
function v4() {
    return new V4UUID();
}
uuid.v4 = v4;
const _UUIDPattern = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
function isUUID(value) {
    return _UUIDPattern.test(value);
}
uuid.isUUID = isUUID;
function parse$5(value) {
    if (!isUUID(value)) {
        throw new Error('invalid uuid');
    }
    return new ValueUUID(value);
}
uuid.parse = parse$5;
function generateUuid() {
    return v4().asHex();
}
uuid.generateUuid = generateUuid;

var progress = {};

Object.defineProperty(progress, "__esModule", { value: true });
progress.attachPartialResult = progress.ProgressFeature = progress.attachWorkDone = void 0;
const vscode_languageserver_protocol_1$j = main$7;
const uuid_1 = uuid;
class WorkDoneProgressReporterImpl {
    constructor(_connection, _token) {
        this._connection = _connection;
        this._token = _token;
        WorkDoneProgressReporterImpl.Instances.set(this._token, this);
    }
    begin(title, percentage, message, cancellable) {
        let param = {
            kind: 'begin',
            title,
            percentage,
            message,
            cancellable
        };
        this._connection.sendProgress(vscode_languageserver_protocol_1$j.WorkDoneProgress.type, this._token, param);
    }
    report(arg0, arg1) {
        let param = {
            kind: 'report'
        };
        if (typeof arg0 === 'number') {
            param.percentage = arg0;
            if (arg1 !== undefined) {
                param.message = arg1;
            }
        }
        else {
            param.message = arg0;
        }
        this._connection.sendProgress(vscode_languageserver_protocol_1$j.WorkDoneProgress.type, this._token, param);
    }
    done() {
        WorkDoneProgressReporterImpl.Instances.delete(this._token);
        this._connection.sendProgress(vscode_languageserver_protocol_1$j.WorkDoneProgress.type, this._token, { kind: 'end' });
    }
}
WorkDoneProgressReporterImpl.Instances = new Map();
class WorkDoneProgressServerReporterImpl extends WorkDoneProgressReporterImpl {
    constructor(connection, token) {
        super(connection, token);
        this._source = new vscode_languageserver_protocol_1$j.CancellationTokenSource();
    }
    get token() {
        return this._source.token;
    }
    done() {
        this._source.dispose();
        super.done();
    }
    cancel() {
        this._source.cancel();
    }
}
class NullProgressReporter {
    constructor() {
    }
    begin() {
    }
    report() {
    }
    done() {
    }
}
class NullProgressServerReporter extends NullProgressReporter {
    constructor() {
        super();
        this._source = new vscode_languageserver_protocol_1$j.CancellationTokenSource();
    }
    get token() {
        return this._source.token;
    }
    done() {
        this._source.dispose();
    }
    cancel() {
        this._source.cancel();
    }
}
function attachWorkDone(connection, params) {
    if (params === undefined || params.workDoneToken === undefined) {
        return new NullProgressReporter();
    }
    const token = params.workDoneToken;
    delete params.workDoneToken;
    return new WorkDoneProgressReporterImpl(connection, token);
}
progress.attachWorkDone = attachWorkDone;
const ProgressFeature = (Base) => {
    return class extends Base {
        constructor() {
            super();
            this._progressSupported = false;
        }
        initialize(capabilities) {
            super.initialize(capabilities);
            if (capabilities?.window?.workDoneProgress === true) {
                this._progressSupported = true;
                this.connection.onNotification(vscode_languageserver_protocol_1$j.WorkDoneProgressCancelNotification.type, (params) => {
                    let progress = WorkDoneProgressReporterImpl.Instances.get(params.token);
                    if (progress instanceof WorkDoneProgressServerReporterImpl || progress instanceof NullProgressServerReporter) {
                        progress.cancel();
                    }
                });
            }
        }
        attachWorkDoneProgress(token) {
            if (token === undefined) {
                return new NullProgressReporter();
            }
            else {
                return new WorkDoneProgressReporterImpl(this.connection, token);
            }
        }
        createWorkDoneProgress() {
            if (this._progressSupported) {
                const token = (0, uuid_1.generateUuid)();
                return this.connection.sendRequest(vscode_languageserver_protocol_1$j.WorkDoneProgressCreateRequest.type, { token }).then(() => {
                    const result = new WorkDoneProgressServerReporterImpl(this.connection, token);
                    return result;
                });
            }
            else {
                return Promise.resolve(new NullProgressServerReporter());
            }
        }
    };
};
progress.ProgressFeature = ProgressFeature;
var ResultProgress;
(function (ResultProgress) {
    ResultProgress.type = new vscode_languageserver_protocol_1$j.ProgressType();
})(ResultProgress || (ResultProgress = {}));
class ResultProgressReporterImpl {
    constructor(_connection, _token) {
        this._connection = _connection;
        this._token = _token;
    }
    report(data) {
        this._connection.sendProgress(ResultProgress.type, this._token, data);
    }
}
function attachPartialResult(connection, params) {
    if (params === undefined || params.partialResultToken === undefined) {
        return undefined;
    }
    const token = params.partialResultToken;
    delete params.partialResultToken;
    return new ResultProgressReporterImpl(connection, token);
}
progress.attachPartialResult = attachPartialResult;

var configuration = {};

Object.defineProperty(configuration, "__esModule", { value: true });
configuration.ConfigurationFeature = void 0;
const vscode_languageserver_protocol_1$i = main$7;
const Is$3 = is$4;
const ConfigurationFeature = (Base) => {
    return class extends Base {
        getConfiguration(arg) {
            if (!arg) {
                return this._getConfiguration({});
            }
            else if (Is$3.string(arg)) {
                return this._getConfiguration({ section: arg });
            }
            else {
                return this._getConfiguration(arg);
            }
        }
        _getConfiguration(arg) {
            let params = {
                items: Array.isArray(arg) ? arg : [arg]
            };
            return this.connection.sendRequest(vscode_languageserver_protocol_1$i.ConfigurationRequest.type, params).then((result) => {
                if (Array.isArray(result)) {
                    return Array.isArray(arg) ? result : result[0];
                }
                else {
                    return Array.isArray(arg) ? [] : null;
                }
            });
        }
    };
};
configuration.ConfigurationFeature = ConfigurationFeature;

var workspaceFolder = {};

Object.defineProperty(workspaceFolder, "__esModule", { value: true });
workspaceFolder.WorkspaceFoldersFeature = void 0;
const vscode_languageserver_protocol_1$h = main$7;
const WorkspaceFoldersFeature = (Base) => {
    return class extends Base {
        constructor() {
            super();
            this._notificationIsAutoRegistered = false;
        }
        initialize(capabilities) {
            super.initialize(capabilities);
            let workspaceCapabilities = capabilities.workspace;
            if (workspaceCapabilities && workspaceCapabilities.workspaceFolders) {
                this._onDidChangeWorkspaceFolders = new vscode_languageserver_protocol_1$h.Emitter();
                this.connection.onNotification(vscode_languageserver_protocol_1$h.DidChangeWorkspaceFoldersNotification.type, (params) => {
                    this._onDidChangeWorkspaceFolders.fire(params.event);
                });
            }
        }
        fillServerCapabilities(capabilities) {
            super.fillServerCapabilities(capabilities);
            const changeNotifications = capabilities.workspace?.workspaceFolders?.changeNotifications;
            this._notificationIsAutoRegistered = changeNotifications === true || typeof changeNotifications === 'string';
        }
        getWorkspaceFolders() {
            return this.connection.sendRequest(vscode_languageserver_protocol_1$h.WorkspaceFoldersRequest.type);
        }
        get onDidChangeWorkspaceFolders() {
            if (!this._onDidChangeWorkspaceFolders) {
                throw new Error('Client doesn\'t support sending workspace folder change events.');
            }
            if (!this._notificationIsAutoRegistered && !this._unregistration) {
                this._unregistration = this.connection.client.register(vscode_languageserver_protocol_1$h.DidChangeWorkspaceFoldersNotification.type);
            }
            return this._onDidChangeWorkspaceFolders.event;
        }
    };
};
workspaceFolder.WorkspaceFoldersFeature = WorkspaceFoldersFeature;

var callHierarchy = {};

Object.defineProperty(callHierarchy, "__esModule", { value: true });
callHierarchy.CallHierarchyFeature = void 0;
const vscode_languageserver_protocol_1$g = main$7;
const CallHierarchyFeature = (Base) => {
    return class extends Base {
        get callHierarchy() {
            return {
                onPrepare: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$g.CallHierarchyPrepareRequest.type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), undefined);
                    });
                },
                onIncomingCalls: (handler) => {
                    const type = vscode_languageserver_protocol_1$g.CallHierarchyIncomingCallsRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                },
                onOutgoingCalls: (handler) => {
                    const type = vscode_languageserver_protocol_1$g.CallHierarchyOutgoingCallsRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                }
            };
        }
    };
};
callHierarchy.CallHierarchyFeature = CallHierarchyFeature;

var semanticTokens = {};

Object.defineProperty(semanticTokens, "__esModule", { value: true });
semanticTokens.SemanticTokensBuilder = semanticTokens.SemanticTokensDiff = semanticTokens.SemanticTokensFeature = void 0;
const vscode_languageserver_protocol_1$f = main$7;
const SemanticTokensFeature = (Base) => {
    return class extends Base {
        get semanticTokens() {
            return {
                refresh: () => {
                    return this.connection.sendRequest(vscode_languageserver_protocol_1$f.SemanticTokensRefreshRequest.type);
                },
                on: (handler) => {
                    const type = vscode_languageserver_protocol_1$f.SemanticTokensRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                },
                onDelta: (handler) => {
                    const type = vscode_languageserver_protocol_1$f.SemanticTokensDeltaRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                },
                onRange: (handler) => {
                    const type = vscode_languageserver_protocol_1$f.SemanticTokensRangeRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                }
            };
        }
    };
};
semanticTokens.SemanticTokensFeature = SemanticTokensFeature;
class SemanticTokensDiff {
    constructor(originalSequence, modifiedSequence) {
        this.originalSequence = originalSequence;
        this.modifiedSequence = modifiedSequence;
    }
    computeDiff() {
        const originalLength = this.originalSequence.length;
        const modifiedLength = this.modifiedSequence.length;
        let startIndex = 0;
        while (startIndex < modifiedLength && startIndex < originalLength && this.originalSequence[startIndex] === this.modifiedSequence[startIndex]) {
            startIndex++;
        }
        if (startIndex < modifiedLength && startIndex < originalLength) {
            let originalEndIndex = originalLength - 1;
            let modifiedEndIndex = modifiedLength - 1;
            while (originalEndIndex >= startIndex && modifiedEndIndex >= startIndex && this.originalSequence[originalEndIndex] === this.modifiedSequence[modifiedEndIndex]) {
                originalEndIndex--;
                modifiedEndIndex--;
            }
            if (originalEndIndex < startIndex || modifiedEndIndex < startIndex) {
                originalEndIndex++;
                modifiedEndIndex++;
            }
            const deleteCount = originalEndIndex - startIndex + 1;
            const newData = this.modifiedSequence.slice(startIndex, modifiedEndIndex + 1);
            if (newData.length === 1 && newData[0] === this.originalSequence[originalEndIndex]) {
                return [
                    { start: startIndex, deleteCount: deleteCount - 1 }
                ];
            }
            else {
                return [
                    { start: startIndex, deleteCount, data: newData }
                ];
            }
        }
        else if (startIndex < modifiedLength) {
            return [
                { start: startIndex, deleteCount: 0, data: this.modifiedSequence.slice(startIndex) }
            ];
        }
        else if (startIndex < originalLength) {
            return [
                { start: startIndex, deleteCount: originalLength - startIndex }
            ];
        }
        else {
            return [];
        }
    }
}
semanticTokens.SemanticTokensDiff = SemanticTokensDiff;
class SemanticTokensBuilder {
    constructor() {
        this._prevData = undefined;
        this.initialize();
    }
    initialize() {
        this._id = Date.now();
        this._prevLine = 0;
        this._prevChar = 0;
        this._data = [];
        this._dataLen = 0;
    }
    push(line, char, length, tokenType, tokenModifiers) {
        let pushLine = line;
        let pushChar = char;
        if (this._dataLen > 0) {
            pushLine -= this._prevLine;
            if (pushLine === 0) {
                pushChar -= this._prevChar;
            }
        }
        this._data[this._dataLen++] = pushLine;
        this._data[this._dataLen++] = pushChar;
        this._data[this._dataLen++] = length;
        this._data[this._dataLen++] = tokenType;
        this._data[this._dataLen++] = tokenModifiers;
        this._prevLine = line;
        this._prevChar = char;
    }
    get id() {
        return this._id.toString();
    }
    previousResult(id) {
        if (this.id === id) {
            this._prevData = this._data;
        }
        this.initialize();
    }
    build() {
        this._prevData = undefined;
        return {
            resultId: this.id,
            data: this._data
        };
    }
    canBuildEdits() {
        return this._prevData !== undefined;
    }
    buildEdits() {
        if (this._prevData !== undefined) {
            return {
                resultId: this.id,
                edits: (new SemanticTokensDiff(this._prevData, this._data)).computeDiff()
            };
        }
        else {
            return this.build();
        }
    }
}
semanticTokens.SemanticTokensBuilder = SemanticTokensBuilder;

var showDocument = {};

Object.defineProperty(showDocument, "__esModule", { value: true });
showDocument.ShowDocumentFeature = void 0;
const vscode_languageserver_protocol_1$e = main$7;
const ShowDocumentFeature = (Base) => {
    return class extends Base {
        showDocument(params) {
            return this.connection.sendRequest(vscode_languageserver_protocol_1$e.ShowDocumentRequest.type, params);
        }
    };
};
showDocument.ShowDocumentFeature = ShowDocumentFeature;

var fileOperations = {};

Object.defineProperty(fileOperations, "__esModule", { value: true });
fileOperations.FileOperationsFeature = void 0;
const vscode_languageserver_protocol_1$d = main$7;
const FileOperationsFeature = (Base) => {
    return class extends Base {
        onDidCreateFiles(handler) {
            return this.connection.onNotification(vscode_languageserver_protocol_1$d.DidCreateFilesNotification.type, (params) => {
                handler(params);
            });
        }
        onDidRenameFiles(handler) {
            return this.connection.onNotification(vscode_languageserver_protocol_1$d.DidRenameFilesNotification.type, (params) => {
                handler(params);
            });
        }
        onDidDeleteFiles(handler) {
            return this.connection.onNotification(vscode_languageserver_protocol_1$d.DidDeleteFilesNotification.type, (params) => {
                handler(params);
            });
        }
        onWillCreateFiles(handler) {
            return this.connection.onRequest(vscode_languageserver_protocol_1$d.WillCreateFilesRequest.type, (params, cancel) => {
                return handler(params, cancel);
            });
        }
        onWillRenameFiles(handler) {
            return this.connection.onRequest(vscode_languageserver_protocol_1$d.WillRenameFilesRequest.type, (params, cancel) => {
                return handler(params, cancel);
            });
        }
        onWillDeleteFiles(handler) {
            return this.connection.onRequest(vscode_languageserver_protocol_1$d.WillDeleteFilesRequest.type, (params, cancel) => {
                return handler(params, cancel);
            });
        }
    };
};
fileOperations.FileOperationsFeature = FileOperationsFeature;

var linkedEditingRange = {};

Object.defineProperty(linkedEditingRange, "__esModule", { value: true });
linkedEditingRange.LinkedEditingRangeFeature = void 0;
const vscode_languageserver_protocol_1$c = main$7;
const LinkedEditingRangeFeature = (Base) => {
    return class extends Base {
        onLinkedEditingRange(handler) {
            return this.connection.onRequest(vscode_languageserver_protocol_1$c.LinkedEditingRangeRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), undefined);
            });
        }
    };
};
linkedEditingRange.LinkedEditingRangeFeature = LinkedEditingRangeFeature;

var typeHierarchy = {};

Object.defineProperty(typeHierarchy, "__esModule", { value: true });
typeHierarchy.TypeHierarchyFeature = void 0;
const vscode_languageserver_protocol_1$b = main$7;
const TypeHierarchyFeature = (Base) => {
    return class extends Base {
        get typeHierarchy() {
            return {
                onPrepare: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$b.TypeHierarchyPrepareRequest.type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), undefined);
                    });
                },
                onSupertypes: (handler) => {
                    const type = vscode_languageserver_protocol_1$b.TypeHierarchySupertypesRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                },
                onSubtypes: (handler) => {
                    const type = vscode_languageserver_protocol_1$b.TypeHierarchySubtypesRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                }
            };
        }
    };
};
typeHierarchy.TypeHierarchyFeature = TypeHierarchyFeature;

var inlineValue = {};

Object.defineProperty(inlineValue, "__esModule", { value: true });
inlineValue.InlineValueFeature = void 0;
const vscode_languageserver_protocol_1$a = main$7;
const InlineValueFeature = (Base) => {
    return class extends Base {
        get inlineValue() {
            return {
                refresh: () => {
                    return this.connection.sendRequest(vscode_languageserver_protocol_1$a.InlineValueRefreshRequest.type);
                },
                on: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$a.InlineValueRequest.type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params));
                    });
                }
            };
        }
    };
};
inlineValue.InlineValueFeature = InlineValueFeature;

var foldingRange = {};

Object.defineProperty(foldingRange, "__esModule", { value: true });
foldingRange.FoldingRangeFeature = void 0;
const vscode_languageserver_protocol_1$9 = main$7;
const FoldingRangeFeature = (Base) => {
    return class extends Base {
        get foldingRange() {
            return {
                refresh: () => {
                    return this.connection.sendRequest(vscode_languageserver_protocol_1$9.FoldingRangeRefreshRequest.type);
                },
                on: (handler) => {
                    const type = vscode_languageserver_protocol_1$9.FoldingRangeRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                }
            };
        }
    };
};
foldingRange.FoldingRangeFeature = FoldingRangeFeature;

var inlayHint = {};

Object.defineProperty(inlayHint, "__esModule", { value: true });
inlayHint.InlayHintFeature = void 0;
const vscode_languageserver_protocol_1$8 = main$7;
const InlayHintFeature = (Base) => {
    return class extends Base {
        get inlayHint() {
            return {
                refresh: () => {
                    return this.connection.sendRequest(vscode_languageserver_protocol_1$8.InlayHintRefreshRequest.type);
                },
                on: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$8.InlayHintRequest.type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params));
                    });
                },
                resolve: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$8.InlayHintResolveRequest.type, (params, cancel) => {
                        return handler(params, cancel);
                    });
                }
            };
        }
    };
};
inlayHint.InlayHintFeature = InlayHintFeature;

var diagnostic = {};

Object.defineProperty(diagnostic, "__esModule", { value: true });
diagnostic.DiagnosticFeature = void 0;
const vscode_languageserver_protocol_1$7 = main$7;
const DiagnosticFeature = (Base) => {
    return class extends Base {
        get diagnostics() {
            return {
                refresh: () => {
                    return this.connection.sendRequest(vscode_languageserver_protocol_1$7.DiagnosticRefreshRequest.type);
                },
                on: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$7.DocumentDiagnosticRequest.type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(vscode_languageserver_protocol_1$7.DocumentDiagnosticRequest.partialResult, params));
                    });
                },
                onWorkspace: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$7.WorkspaceDiagnosticRequest.type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(vscode_languageserver_protocol_1$7.WorkspaceDiagnosticRequest.partialResult, params));
                    });
                }
            };
        }
    };
};
diagnostic.DiagnosticFeature = DiagnosticFeature;

var notebook = {};

var textDocuments = {};

Object.defineProperty(textDocuments, "__esModule", { value: true });
textDocuments.TextDocuments = void 0;
const vscode_languageserver_protocol_1$6 = main$7;
class TextDocuments {
    constructor(configuration) {
        this._configuration = configuration;
        this._syncedDocuments = new Map();
        this._onDidChangeContent = new vscode_languageserver_protocol_1$6.Emitter();
        this._onDidOpen = new vscode_languageserver_protocol_1$6.Emitter();
        this._onDidClose = new vscode_languageserver_protocol_1$6.Emitter();
        this._onDidSave = new vscode_languageserver_protocol_1$6.Emitter();
        this._onWillSave = new vscode_languageserver_protocol_1$6.Emitter();
    }
    get onDidOpen() {
        return this._onDidOpen.event;
    }
    get onDidChangeContent() {
        return this._onDidChangeContent.event;
    }
    get onWillSave() {
        return this._onWillSave.event;
    }
    onWillSaveWaitUntil(handler) {
        this._willSaveWaitUntil = handler;
    }
    get onDidSave() {
        return this._onDidSave.event;
    }
    get onDidClose() {
        return this._onDidClose.event;
    }
    get(uri) {
        return this._syncedDocuments.get(uri);
    }
    all() {
        return Array.from(this._syncedDocuments.values());
    }
    keys() {
        return Array.from(this._syncedDocuments.keys());
    }
    listen(connection) {
        connection.__textDocumentSync = vscode_languageserver_protocol_1$6.TextDocumentSyncKind.Incremental;
        const disposables = [];
        disposables.push(connection.onDidOpenTextDocument((event) => {
            const td = event.textDocument;
            const document = this._configuration.create(td.uri, td.languageId, td.version, td.text);
            this._syncedDocuments.set(td.uri, document);
            const toFire = Object.freeze({ document });
            this._onDidOpen.fire(toFire);
            this._onDidChangeContent.fire(toFire);
        }));
        disposables.push(connection.onDidChangeTextDocument((event) => {
            const td = event.textDocument;
            const changes = event.contentChanges;
            if (changes.length === 0) {
                return;
            }
            const { version } = td;
            if (version === null || version === undefined) {
                throw new Error(`Received document change event for ${td.uri} without valid version identifier`);
            }
            let syncedDocument = this._syncedDocuments.get(td.uri);
            if (syncedDocument !== undefined) {
                syncedDocument = this._configuration.update(syncedDocument, changes, version);
                this._syncedDocuments.set(td.uri, syncedDocument);
                this._onDidChangeContent.fire(Object.freeze({ document: syncedDocument }));
            }
        }));
        disposables.push(connection.onDidCloseTextDocument((event) => {
            let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
            if (syncedDocument !== undefined) {
                this._syncedDocuments.delete(event.textDocument.uri);
                this._onDidClose.fire(Object.freeze({ document: syncedDocument }));
            }
        }));
        disposables.push(connection.onWillSaveTextDocument((event) => {
            let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
            if (syncedDocument !== undefined) {
                this._onWillSave.fire(Object.freeze({ document: syncedDocument, reason: event.reason }));
            }
        }));
        disposables.push(connection.onWillSaveTextDocumentWaitUntil((event, token) => {
            let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
            if (syncedDocument !== undefined && this._willSaveWaitUntil) {
                return this._willSaveWaitUntil(Object.freeze({ document: syncedDocument, reason: event.reason }), token);
            }
            else {
                return [];
            }
        }));
        disposables.push(connection.onDidSaveTextDocument((event) => {
            let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
            if (syncedDocument !== undefined) {
                this._onDidSave.fire(Object.freeze({ document: syncedDocument }));
            }
        }));
        return vscode_languageserver_protocol_1$6.Disposable.create(() => { disposables.forEach(disposable => disposable.dispose()); });
    }
}
textDocuments.TextDocuments = TextDocuments;

Object.defineProperty(notebook, "__esModule", { value: true });
notebook.NotebookDocuments = notebook.NotebookSyncFeature = void 0;
const vscode_languageserver_protocol_1$5 = main$7;
const textDocuments_1 = textDocuments;
const NotebookSyncFeature = (Base) => {
    return class extends Base {
        get synchronization() {
            return {
                onDidOpenNotebookDocument: (handler) => {
                    return this.connection.onNotification(vscode_languageserver_protocol_1$5.DidOpenNotebookDocumentNotification.type, (params) => {
                        handler(params);
                    });
                },
                onDidChangeNotebookDocument: (handler) => {
                    return this.connection.onNotification(vscode_languageserver_protocol_1$5.DidChangeNotebookDocumentNotification.type, (params) => {
                        handler(params);
                    });
                },
                onDidSaveNotebookDocument: (handler) => {
                    return this.connection.onNotification(vscode_languageserver_protocol_1$5.DidSaveNotebookDocumentNotification.type, (params) => {
                        handler(params);
                    });
                },
                onDidCloseNotebookDocument: (handler) => {
                    return this.connection.onNotification(vscode_languageserver_protocol_1$5.DidCloseNotebookDocumentNotification.type, (params) => {
                        handler(params);
                    });
                }
            };
        }
    };
};
notebook.NotebookSyncFeature = NotebookSyncFeature;
class CellTextDocumentConnection {
    onDidOpenTextDocument(handler) {
        this.openHandler = handler;
        return vscode_languageserver_protocol_1$5.Disposable.create(() => { this.openHandler = undefined; });
    }
    openTextDocument(params) {
        this.openHandler && this.openHandler(params);
    }
    onDidChangeTextDocument(handler) {
        this.changeHandler = handler;
        return vscode_languageserver_protocol_1$5.Disposable.create(() => { this.changeHandler = handler; });
    }
    changeTextDocument(params) {
        this.changeHandler && this.changeHandler(params);
    }
    onDidCloseTextDocument(handler) {
        this.closeHandler = handler;
        return vscode_languageserver_protocol_1$5.Disposable.create(() => { this.closeHandler = undefined; });
    }
    closeTextDocument(params) {
        this.closeHandler && this.closeHandler(params);
    }
    onWillSaveTextDocument() {
        return CellTextDocumentConnection.NULL_DISPOSE;
    }
    onWillSaveTextDocumentWaitUntil() {
        return CellTextDocumentConnection.NULL_DISPOSE;
    }
    onDidSaveTextDocument() {
        return CellTextDocumentConnection.NULL_DISPOSE;
    }
}
CellTextDocumentConnection.NULL_DISPOSE = Object.freeze({ dispose: () => { } });
class NotebookDocuments {
    constructor(configurationOrTextDocuments) {
        if (configurationOrTextDocuments instanceof textDocuments_1.TextDocuments) {
            this._cellTextDocuments = configurationOrTextDocuments;
        }
        else {
            this._cellTextDocuments = new textDocuments_1.TextDocuments(configurationOrTextDocuments);
        }
        this.notebookDocuments = new Map();
        this.notebookCellMap = new Map();
        this._onDidOpen = new vscode_languageserver_protocol_1$5.Emitter();
        this._onDidChange = new vscode_languageserver_protocol_1$5.Emitter();
        this._onDidSave = new vscode_languageserver_protocol_1$5.Emitter();
        this._onDidClose = new vscode_languageserver_protocol_1$5.Emitter();
    }
    get cellTextDocuments() {
        return this._cellTextDocuments;
    }
    getCellTextDocument(cell) {
        return this._cellTextDocuments.get(cell.document);
    }
    getNotebookDocument(uri) {
        return this.notebookDocuments.get(uri);
    }
    getNotebookCell(uri) {
        const value = this.notebookCellMap.get(uri);
        return value && value[0];
    }
    findNotebookDocumentForCell(cell) {
        const key = typeof cell === 'string' ? cell : cell.document;
        const value = this.notebookCellMap.get(key);
        return value && value[1];
    }
    get onDidOpen() {
        return this._onDidOpen.event;
    }
    get onDidSave() {
        return this._onDidSave.event;
    }
    get onDidChange() {
        return this._onDidChange.event;
    }
    get onDidClose() {
        return this._onDidClose.event;
    }
    listen(connection) {
        const cellTextDocumentConnection = new CellTextDocumentConnection();
        const disposables = [];
        disposables.push(this.cellTextDocuments.listen(cellTextDocumentConnection));
        disposables.push(connection.notebooks.synchronization.onDidOpenNotebookDocument((params) => {
            this.notebookDocuments.set(params.notebookDocument.uri, params.notebookDocument);
            for (const cellTextDocument of params.cellTextDocuments) {
                cellTextDocumentConnection.openTextDocument({ textDocument: cellTextDocument });
            }
            this.updateCellMap(params.notebookDocument);
            this._onDidOpen.fire(params.notebookDocument);
        }));
        disposables.push(connection.notebooks.synchronization.onDidChangeNotebookDocument((params) => {
            const notebookDocument = this.notebookDocuments.get(params.notebookDocument.uri);
            if (notebookDocument === undefined) {
                return;
            }
            notebookDocument.version = params.notebookDocument.version;
            const oldMetadata = notebookDocument.metadata;
            let metadataChanged = false;
            const change = params.change;
            if (change.metadata !== undefined) {
                metadataChanged = true;
                notebookDocument.metadata = change.metadata;
            }
            const opened = [];
            const closed = [];
            const data = [];
            const text = [];
            if (change.cells !== undefined) {
                const changedCells = change.cells;
                if (changedCells.structure !== undefined) {
                    const array = changedCells.structure.array;
                    notebookDocument.cells.splice(array.start, array.deleteCount, ...(array.cells !== undefined ? array.cells : []));
                    if (changedCells.structure.didOpen !== undefined) {
                        for (const open of changedCells.structure.didOpen) {
                            cellTextDocumentConnection.openTextDocument({ textDocument: open });
                            opened.push(open.uri);
                        }
                    }
                    if (changedCells.structure.didClose) {
                        for (const close of changedCells.structure.didClose) {
                            cellTextDocumentConnection.closeTextDocument({ textDocument: close });
                            closed.push(close.uri);
                        }
                    }
                }
                if (changedCells.data !== undefined) {
                    const cellUpdates = new Map(changedCells.data.map(cell => [cell.document, cell]));
                    for (let i = 0; i <= notebookDocument.cells.length; i++) {
                        const change = cellUpdates.get(notebookDocument.cells[i].document);
                        if (change !== undefined) {
                            const old = notebookDocument.cells.splice(i, 1, change);
                            data.push({ old: old[0], new: change });
                            cellUpdates.delete(change.document);
                            if (cellUpdates.size === 0) {
                                break;
                            }
                        }
                    }
                }
                if (changedCells.textContent !== undefined) {
                    for (const cellTextDocument of changedCells.textContent) {
                        cellTextDocumentConnection.changeTextDocument({ textDocument: cellTextDocument.document, contentChanges: cellTextDocument.changes });
                        text.push(cellTextDocument.document.uri);
                    }
                }
            }
            this.updateCellMap(notebookDocument);
            const changeEvent = { notebookDocument };
            if (metadataChanged) {
                changeEvent.metadata = { old: oldMetadata, new: notebookDocument.metadata };
            }
            const added = [];
            for (const open of opened) {
                added.push(this.getNotebookCell(open));
            }
            const removed = [];
            for (const close of closed) {
                removed.push(this.getNotebookCell(close));
            }
            const textContent = [];
            for (const change of text) {
                textContent.push(this.getNotebookCell(change));
            }
            if (added.length > 0 || removed.length > 0 || data.length > 0 || textContent.length > 0) {
                changeEvent.cells = { added, removed, changed: { data, textContent } };
            }
            if (changeEvent.metadata !== undefined || changeEvent.cells !== undefined) {
                this._onDidChange.fire(changeEvent);
            }
        }));
        disposables.push(connection.notebooks.synchronization.onDidSaveNotebookDocument((params) => {
            const notebookDocument = this.notebookDocuments.get(params.notebookDocument.uri);
            if (notebookDocument === undefined) {
                return;
            }
            this._onDidSave.fire(notebookDocument);
        }));
        disposables.push(connection.notebooks.synchronization.onDidCloseNotebookDocument((params) => {
            const notebookDocument = this.notebookDocuments.get(params.notebookDocument.uri);
            if (notebookDocument === undefined) {
                return;
            }
            this._onDidClose.fire(notebookDocument);
            for (const cellTextDocument of params.cellTextDocuments) {
                cellTextDocumentConnection.closeTextDocument({ textDocument: cellTextDocument });
            }
            this.notebookDocuments.delete(params.notebookDocument.uri);
            for (const cell of notebookDocument.cells) {
                this.notebookCellMap.delete(cell.document);
            }
        }));
        return vscode_languageserver_protocol_1$5.Disposable.create(() => { disposables.forEach(disposable => disposable.dispose()); });
    }
    updateCellMap(notebookDocument) {
        for (const cell of notebookDocument.cells) {
            this.notebookCellMap.set(cell.document, [cell, notebookDocument]);
        }
    }
}
notebook.NotebookDocuments = NotebookDocuments;

var moniker = {};

Object.defineProperty(moniker, "__esModule", { value: true });
moniker.MonikerFeature = void 0;
const vscode_languageserver_protocol_1$4 = main$7;
const MonikerFeature = (Base) => {
    return class extends Base {
        get moniker() {
            return {
                on: (handler) => {
                    const type = vscode_languageserver_protocol_1$4.MonikerRequest.type;
                    return this.connection.onRequest(type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
                    });
                },
            };
        }
    };
};
moniker.MonikerFeature = MonikerFeature;

Object.defineProperty(server, "__esModule", { value: true });
server.createConnection = server.combineFeatures = server.combineNotebooksFeatures = server.combineLanguagesFeatures = server.combineWorkspaceFeatures = server.combineWindowFeatures = server.combineClientFeatures = server.combineTracerFeatures = server.combineTelemetryFeatures = server.combineConsoleFeatures = server._NotebooksImpl = server._LanguagesImpl = server.BulkUnregistration = server.BulkRegistration = server.ErrorMessageTracker = void 0;
const vscode_languageserver_protocol_1$3 = main$7;
const Is$2 = is$4;
const UUID = uuid;
const progress_1 = progress;
const configuration_1 = configuration;
const workspaceFolder_1 = workspaceFolder;
const callHierarchy_1 = callHierarchy;
const semanticTokens_1 = semanticTokens;
const showDocument_1 = showDocument;
const fileOperations_1 = fileOperations;
const linkedEditingRange_1 = linkedEditingRange;
const typeHierarchy_1 = typeHierarchy;
const inlineValue_1 = inlineValue;
const foldingRange_1 = foldingRange;
const inlayHint_1 = inlayHint;
const diagnostic_1 = diagnostic;
const notebook_1 = notebook;
const moniker_1 = moniker;
function null2Undefined(value) {
    if (value === null) {
        return undefined;
    }
    return value;
}
class ErrorMessageTracker {
    constructor() {
        this._messages = Object.create(null);
    }
    add(message) {
        let count = this._messages[message];
        if (!count) {
            count = 0;
        }
        count++;
        this._messages[message] = count;
    }
    sendErrors(connection) {
        Object.keys(this._messages).forEach(message => {
            connection.window.showErrorMessage(message);
        });
    }
}
server.ErrorMessageTracker = ErrorMessageTracker;
class RemoteConsoleImpl {
    constructor() {
    }
    rawAttach(connection) {
        this._rawConnection = connection;
    }
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    fillServerCapabilities(_capabilities) {
    }
    initialize(_capabilities) {
    }
    error(message) {
        this.send(vscode_languageserver_protocol_1$3.MessageType.Error, message);
    }
    warn(message) {
        this.send(vscode_languageserver_protocol_1$3.MessageType.Warning, message);
    }
    info(message) {
        this.send(vscode_languageserver_protocol_1$3.MessageType.Info, message);
    }
    log(message) {
        this.send(vscode_languageserver_protocol_1$3.MessageType.Log, message);
    }
    debug(message) {
        this.send(vscode_languageserver_protocol_1$3.MessageType.Debug, message);
    }
    send(type, message) {
        if (this._rawConnection) {
            this._rawConnection.sendNotification(vscode_languageserver_protocol_1$3.LogMessageNotification.type, { type, message }).catch(() => {
                (0, vscode_languageserver_protocol_1$3.RAL)().console.error(`Sending log message failed`);
            });
        }
    }
}
class _RemoteWindowImpl {
    constructor() {
    }
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    initialize(_capabilities) {
    }
    fillServerCapabilities(_capabilities) {
    }
    showErrorMessage(message, ...actions) {
        let params = { type: vscode_languageserver_protocol_1$3.MessageType.Error, message, actions };
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.ShowMessageRequest.type, params).then(null2Undefined);
    }
    showWarningMessage(message, ...actions) {
        let params = { type: vscode_languageserver_protocol_1$3.MessageType.Warning, message, actions };
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.ShowMessageRequest.type, params).then(null2Undefined);
    }
    showInformationMessage(message, ...actions) {
        let params = { type: vscode_languageserver_protocol_1$3.MessageType.Info, message, actions };
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.ShowMessageRequest.type, params).then(null2Undefined);
    }
}
const RemoteWindowImpl = (0, showDocument_1.ShowDocumentFeature)((0, progress_1.ProgressFeature)(_RemoteWindowImpl));
var BulkRegistration;
(function (BulkRegistration) {
    function create() {
        return new BulkRegistrationImpl();
    }
    BulkRegistration.create = create;
})(BulkRegistration || (server.BulkRegistration = BulkRegistration = {}));
class BulkRegistrationImpl {
    constructor() {
        this._registrations = [];
        this._registered = new Set();
    }
    add(type, registerOptions) {
        const method = Is$2.string(type) ? type : type.method;
        if (this._registered.has(method)) {
            throw new Error(`${method} is already added to this registration`);
        }
        const id = UUID.generateUuid();
        this._registrations.push({
            id: id,
            method: method,
            registerOptions: registerOptions || {}
        });
        this._registered.add(method);
    }
    asRegistrationParams() {
        return {
            registrations: this._registrations
        };
    }
}
var BulkUnregistration;
(function (BulkUnregistration) {
    function create() {
        return new BulkUnregistrationImpl(undefined, []);
    }
    BulkUnregistration.create = create;
})(BulkUnregistration || (server.BulkUnregistration = BulkUnregistration = {}));
class BulkUnregistrationImpl {
    constructor(_connection, unregistrations) {
        this._connection = _connection;
        this._unregistrations = new Map();
        unregistrations.forEach(unregistration => {
            this._unregistrations.set(unregistration.method, unregistration);
        });
    }
    get isAttached() {
        return !!this._connection;
    }
    attach(connection) {
        this._connection = connection;
    }
    add(unregistration) {
        this._unregistrations.set(unregistration.method, unregistration);
    }
    dispose() {
        let unregistrations = [];
        for (let unregistration of this._unregistrations.values()) {
            unregistrations.push(unregistration);
        }
        let params = {
            unregisterations: unregistrations
        };
        this._connection.sendRequest(vscode_languageserver_protocol_1$3.UnregistrationRequest.type, params).catch(() => {
            this._connection.console.info(`Bulk unregistration failed.`);
        });
    }
    disposeSingle(arg) {
        const method = Is$2.string(arg) ? arg : arg.method;
        const unregistration = this._unregistrations.get(method);
        if (!unregistration) {
            return false;
        }
        let params = {
            unregisterations: [unregistration]
        };
        this._connection.sendRequest(vscode_languageserver_protocol_1$3.UnregistrationRequest.type, params).then(() => {
            this._unregistrations.delete(method);
        }, (_error) => {
            this._connection.console.info(`Un-registering request handler for ${unregistration.id} failed.`);
        });
        return true;
    }
}
class RemoteClientImpl {
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    initialize(_capabilities) {
    }
    fillServerCapabilities(_capabilities) {
    }
    register(typeOrRegistrations, registerOptionsOrType, registerOptions) {
        if (typeOrRegistrations instanceof BulkRegistrationImpl) {
            return this.registerMany(typeOrRegistrations);
        }
        else if (typeOrRegistrations instanceof BulkUnregistrationImpl) {
            return this.registerSingle1(typeOrRegistrations, registerOptionsOrType, registerOptions);
        }
        else {
            return this.registerSingle2(typeOrRegistrations, registerOptionsOrType);
        }
    }
    registerSingle1(unregistration, type, registerOptions) {
        const method = Is$2.string(type) ? type : type.method;
        const id = UUID.generateUuid();
        let params = {
            registrations: [{ id, method, registerOptions: registerOptions || {} }]
        };
        if (!unregistration.isAttached) {
            unregistration.attach(this.connection);
        }
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.RegistrationRequest.type, params).then((_result) => {
            unregistration.add({ id: id, method: method });
            return unregistration;
        }, (_error) => {
            this.connection.console.info(`Registering request handler for ${method} failed.`);
            return Promise.reject(_error);
        });
    }
    registerSingle2(type, registerOptions) {
        const method = Is$2.string(type) ? type : type.method;
        const id = UUID.generateUuid();
        let params = {
            registrations: [{ id, method, registerOptions: registerOptions || {} }]
        };
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.RegistrationRequest.type, params).then((_result) => {
            return vscode_languageserver_protocol_1$3.Disposable.create(() => {
                this.unregisterSingle(id, method).catch(() => { this.connection.console.info(`Un-registering capability with id ${id} failed.`); });
            });
        }, (_error) => {
            this.connection.console.info(`Registering request handler for ${method} failed.`);
            return Promise.reject(_error);
        });
    }
    unregisterSingle(id, method) {
        let params = {
            unregisterations: [{ id, method }]
        };
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.UnregistrationRequest.type, params).catch(() => {
            this.connection.console.info(`Un-registering request handler for ${id} failed.`);
        });
    }
    registerMany(registrations) {
        let params = registrations.asRegistrationParams();
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.RegistrationRequest.type, params).then(() => {
            return new BulkUnregistrationImpl(this._connection, params.registrations.map(registration => { return { id: registration.id, method: registration.method }; }));
        }, (_error) => {
            this.connection.console.info(`Bulk registration failed.`);
            return Promise.reject(_error);
        });
    }
}
class _RemoteWorkspaceImpl {
    constructor() {
    }
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    initialize(_capabilities) {
    }
    fillServerCapabilities(_capabilities) {
    }
    applyEdit(paramOrEdit) {
        function isApplyWorkspaceEditParams(value) {
            return value && !!value.edit;
        }
        let params = isApplyWorkspaceEditParams(paramOrEdit) ? paramOrEdit : { edit: paramOrEdit };
        return this.connection.sendRequest(vscode_languageserver_protocol_1$3.ApplyWorkspaceEditRequest.type, params);
    }
}
const RemoteWorkspaceImpl = (0, fileOperations_1.FileOperationsFeature)((0, workspaceFolder_1.WorkspaceFoldersFeature)((0, configuration_1.ConfigurationFeature)(_RemoteWorkspaceImpl)));
class TracerImpl {
    constructor() {
        this._trace = vscode_languageserver_protocol_1$3.Trace.Off;
    }
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    initialize(_capabilities) {
    }
    fillServerCapabilities(_capabilities) {
    }
    set trace(value) {
        this._trace = value;
    }
    log(message, verbose) {
        if (this._trace === vscode_languageserver_protocol_1$3.Trace.Off) {
            return;
        }
        this.connection.sendNotification(vscode_languageserver_protocol_1$3.LogTraceNotification.type, {
            message: message,
            verbose: this._trace === vscode_languageserver_protocol_1$3.Trace.Verbose ? verbose : undefined
        }).catch(() => {
        });
    }
}
class TelemetryImpl {
    constructor() {
    }
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    initialize(_capabilities) {
    }
    fillServerCapabilities(_capabilities) {
    }
    logEvent(data) {
        this.connection.sendNotification(vscode_languageserver_protocol_1$3.TelemetryEventNotification.type, data).catch(() => {
            this.connection.console.log(`Sending TelemetryEventNotification failed`);
        });
    }
}
class _LanguagesImpl {
    constructor() {
    }
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    initialize(_capabilities) {
    }
    fillServerCapabilities(_capabilities) {
    }
    attachWorkDoneProgress(params) {
        return (0, progress_1.attachWorkDone)(this.connection, params);
    }
    attachPartialResultProgress(_type, params) {
        return (0, progress_1.attachPartialResult)(this.connection, params);
    }
}
server._LanguagesImpl = _LanguagesImpl;
const LanguagesImpl = (0, foldingRange_1.FoldingRangeFeature)((0, moniker_1.MonikerFeature)((0, diagnostic_1.DiagnosticFeature)((0, inlayHint_1.InlayHintFeature)((0, inlineValue_1.InlineValueFeature)((0, typeHierarchy_1.TypeHierarchyFeature)((0, linkedEditingRange_1.LinkedEditingRangeFeature)((0, semanticTokens_1.SemanticTokensFeature)((0, callHierarchy_1.CallHierarchyFeature)(_LanguagesImpl)))))))));
class _NotebooksImpl {
    constructor() {
    }
    attach(connection) {
        this._connection = connection;
    }
    get connection() {
        if (!this._connection) {
            throw new Error('Remote is not attached to a connection yet.');
        }
        return this._connection;
    }
    initialize(_capabilities) {
    }
    fillServerCapabilities(_capabilities) {
    }
    attachWorkDoneProgress(params) {
        return (0, progress_1.attachWorkDone)(this.connection, params);
    }
    attachPartialResultProgress(_type, params) {
        return (0, progress_1.attachPartialResult)(this.connection, params);
    }
}
server._NotebooksImpl = _NotebooksImpl;
const NotebooksImpl = (0, notebook_1.NotebookSyncFeature)(_NotebooksImpl);
function combineConsoleFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineConsoleFeatures = combineConsoleFeatures;
function combineTelemetryFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineTelemetryFeatures = combineTelemetryFeatures;
function combineTracerFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineTracerFeatures = combineTracerFeatures;
function combineClientFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineClientFeatures = combineClientFeatures;
function combineWindowFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineWindowFeatures = combineWindowFeatures;
function combineWorkspaceFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineWorkspaceFeatures = combineWorkspaceFeatures;
function combineLanguagesFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineLanguagesFeatures = combineLanguagesFeatures;
function combineNotebooksFeatures(one, two) {
    return function (Base) {
        return two(one(Base));
    };
}
server.combineNotebooksFeatures = combineNotebooksFeatures;
function combineFeatures(one, two) {
    function combine(one, two, func) {
        if (one && two) {
            return func(one, two);
        }
        else if (one) {
            return one;
        }
        else {
            return two;
        }
    }
    let result = {
        __brand: 'features',
        console: combine(one.console, two.console, combineConsoleFeatures),
        tracer: combine(one.tracer, two.tracer, combineTracerFeatures),
        telemetry: combine(one.telemetry, two.telemetry, combineTelemetryFeatures),
        client: combine(one.client, two.client, combineClientFeatures),
        window: combine(one.window, two.window, combineWindowFeatures),
        workspace: combine(one.workspace, two.workspace, combineWorkspaceFeatures),
        languages: combine(one.languages, two.languages, combineLanguagesFeatures),
        notebooks: combine(one.notebooks, two.notebooks, combineNotebooksFeatures)
    };
    return result;
}
server.combineFeatures = combineFeatures;
function createConnection(connectionFactory, watchDog, factories) {
    const logger = (factories && factories.console ? new (factories.console(RemoteConsoleImpl))() : new RemoteConsoleImpl());
    const connection = connectionFactory(logger);
    logger.rawAttach(connection);
    const tracer = (factories && factories.tracer ? new (factories.tracer(TracerImpl))() : new TracerImpl());
    const telemetry = (factories && factories.telemetry ? new (factories.telemetry(TelemetryImpl))() : new TelemetryImpl());
    const client = (factories && factories.client ? new (factories.client(RemoteClientImpl))() : new RemoteClientImpl());
    const remoteWindow = (factories && factories.window ? new (factories.window(RemoteWindowImpl))() : new RemoteWindowImpl());
    const workspace = (factories && factories.workspace ? new (factories.workspace(RemoteWorkspaceImpl))() : new RemoteWorkspaceImpl());
    const languages = (factories && factories.languages ? new (factories.languages(LanguagesImpl))() : new LanguagesImpl());
    const notebooks = (factories && factories.notebooks ? new (factories.notebooks(NotebooksImpl))() : new NotebooksImpl());
    const allRemotes = [logger, tracer, telemetry, client, remoteWindow, workspace, languages, notebooks];
    function asPromise(value) {
        if (value instanceof Promise) {
            return value;
        }
        else if (Is$2.thenable(value)) {
            return new Promise((resolve, reject) => {
                value.then((resolved) => resolve(resolved), (error) => reject(error));
            });
        }
        else {
            return Promise.resolve(value);
        }
    }
    let shutdownHandler = undefined;
    let initializeHandler = undefined;
    let exitHandler = undefined;
    let protocolConnection = {
        listen: () => connection.listen(),
        sendRequest: (type, ...params) => connection.sendRequest(Is$2.string(type) ? type : type.method, ...params),
        onRequest: (type, handler) => connection.onRequest(type, handler),
        sendNotification: (type, param) => {
            const method = Is$2.string(type) ? type : type.method;
            return connection.sendNotification(method, param);
        },
        onNotification: (type, handler) => connection.onNotification(type, handler),
        onProgress: connection.onProgress,
        sendProgress: connection.sendProgress,
        onInitialize: (handler) => {
            initializeHandler = handler;
            return {
                dispose: () => {
                    initializeHandler = undefined;
                }
            };
        },
        onInitialized: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.InitializedNotification.type, handler),
        onShutdown: (handler) => {
            shutdownHandler = handler;
            return {
                dispose: () => {
                    shutdownHandler = undefined;
                }
            };
        },
        onExit: (handler) => {
            exitHandler = handler;
            return {
                dispose: () => {
                    exitHandler = undefined;
                }
            };
        },
        get console() { return logger; },
        get telemetry() { return telemetry; },
        get tracer() { return tracer; },
        get client() { return client; },
        get window() { return remoteWindow; },
        get workspace() { return workspace; },
        get languages() { return languages; },
        get notebooks() { return notebooks; },
        onDidChangeConfiguration: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.DidChangeConfigurationNotification.type, handler),
        onDidChangeWatchedFiles: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.DidChangeWatchedFilesNotification.type, handler),
        __textDocumentSync: undefined,
        onDidOpenTextDocument: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.DidOpenTextDocumentNotification.type, handler),
        onDidChangeTextDocument: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.DidChangeTextDocumentNotification.type, handler),
        onDidCloseTextDocument: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.DidCloseTextDocumentNotification.type, handler),
        onWillSaveTextDocument: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.WillSaveTextDocumentNotification.type, handler),
        onWillSaveTextDocumentWaitUntil: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.WillSaveTextDocumentWaitUntilRequest.type, handler),
        onDidSaveTextDocument: (handler) => connection.onNotification(vscode_languageserver_protocol_1$3.DidSaveTextDocumentNotification.type, handler),
        sendDiagnostics: (params) => connection.sendNotification(vscode_languageserver_protocol_1$3.PublishDiagnosticsNotification.type, params),
        onHover: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.HoverRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), undefined);
        }),
        onCompletion: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.CompletionRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onCompletionResolve: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.CompletionResolveRequest.type, handler),
        onSignatureHelp: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.SignatureHelpRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), undefined);
        }),
        onDeclaration: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DeclarationRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onDefinition: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DefinitionRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onTypeDefinition: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.TypeDefinitionRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onImplementation: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.ImplementationRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onReferences: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.ReferencesRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onDocumentHighlight: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentHighlightRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onDocumentSymbol: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentSymbolRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onWorkspaceSymbol: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.WorkspaceSymbolRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onWorkspaceSymbolResolve: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.WorkspaceSymbolResolveRequest.type, handler),
        onCodeAction: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.CodeActionRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onCodeActionResolve: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.CodeActionResolveRequest.type, (params, cancel) => {
            return handler(params, cancel);
        }),
        onCodeLens: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.CodeLensRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onCodeLensResolve: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.CodeLensResolveRequest.type, (params, cancel) => {
            return handler(params, cancel);
        }),
        onDocumentFormatting: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentFormattingRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), undefined);
        }),
        onDocumentRangeFormatting: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentRangeFormattingRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), undefined);
        }),
        onDocumentOnTypeFormatting: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentOnTypeFormattingRequest.type, (params, cancel) => {
            return handler(params, cancel);
        }),
        onRenameRequest: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.RenameRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), undefined);
        }),
        onPrepareRename: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.PrepareRenameRequest.type, (params, cancel) => {
            return handler(params, cancel);
        }),
        onDocumentLinks: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentLinkRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onDocumentLinkResolve: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentLinkResolveRequest.type, (params, cancel) => {
            return handler(params, cancel);
        }),
        onDocumentColor: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.DocumentColorRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onColorPresentation: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.ColorPresentationRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onFoldingRanges: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.FoldingRangeRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onSelectionRanges: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.SelectionRangeRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), (0, progress_1.attachPartialResult)(connection, params));
        }),
        onExecuteCommand: (handler) => connection.onRequest(vscode_languageserver_protocol_1$3.ExecuteCommandRequest.type, (params, cancel) => {
            return handler(params, cancel, (0, progress_1.attachWorkDone)(connection, params), undefined);
        }),
        dispose: () => connection.dispose()
    };
    for (let remote of allRemotes) {
        remote.attach(protocolConnection);
    }
    connection.onRequest(vscode_languageserver_protocol_1$3.InitializeRequest.type, (params) => {
        watchDog.initialize(params);
        if (Is$2.string(params.trace)) {
            tracer.trace = vscode_languageserver_protocol_1$3.Trace.fromString(params.trace);
        }
        for (let remote of allRemotes) {
            remote.initialize(params.capabilities);
        }
        if (initializeHandler) {
            let result = initializeHandler(params, new vscode_languageserver_protocol_1$3.CancellationTokenSource().token, (0, progress_1.attachWorkDone)(connection, params), undefined);
            return asPromise(result).then((value) => {
                if (value instanceof vscode_languageserver_protocol_1$3.ResponseError) {
                    return value;
                }
                let result = value;
                if (!result) {
                    result = { capabilities: {} };
                }
                let capabilities = result.capabilities;
                if (!capabilities) {
                    capabilities = {};
                    result.capabilities = capabilities;
                }
                if (capabilities.textDocumentSync === undefined || capabilities.textDocumentSync === null) {
                    capabilities.textDocumentSync = Is$2.number(protocolConnection.__textDocumentSync) ? protocolConnection.__textDocumentSync : vscode_languageserver_protocol_1$3.TextDocumentSyncKind.None;
                }
                else if (!Is$2.number(capabilities.textDocumentSync) && !Is$2.number(capabilities.textDocumentSync.change)) {
                    capabilities.textDocumentSync.change = Is$2.number(protocolConnection.__textDocumentSync) ? protocolConnection.__textDocumentSync : vscode_languageserver_protocol_1$3.TextDocumentSyncKind.None;
                }
                for (let remote of allRemotes) {
                    remote.fillServerCapabilities(capabilities);
                }
                return result;
            });
        }
        else {
            let result = { capabilities: { textDocumentSync: vscode_languageserver_protocol_1$3.TextDocumentSyncKind.None } };
            for (let remote of allRemotes) {
                remote.fillServerCapabilities(result.capabilities);
            }
            return result;
        }
    });
    connection.onRequest(vscode_languageserver_protocol_1$3.ShutdownRequest.type, () => {
        watchDog.shutdownReceived = true;
        if (shutdownHandler) {
            return shutdownHandler(new vscode_languageserver_protocol_1$3.CancellationTokenSource().token);
        }
        else {
            return undefined;
        }
    });
    connection.onNotification(vscode_languageserver_protocol_1$3.ExitNotification.type, () => {
        try {
            if (exitHandler) {
                exitHandler();
            }
        }
        finally {
            if (watchDog.shutdownReceived) {
                watchDog.exit(0);
            }
            else {
                watchDog.exit(1);
            }
        }
    });
    connection.onNotification(vscode_languageserver_protocol_1$3.SetTraceNotification.type, (params) => {
        tracer.trace = vscode_languageserver_protocol_1$3.Trace.fromString(params.value);
    });
    return protocolConnection;
}
server.createConnection = createConnection;

var files = {};

Object.defineProperty(files, "__esModule", { value: true });
files.resolveModulePath = files.FileSystem = files.resolveGlobalYarnPath = files.resolveGlobalNodePath = files.resolve = files.uriToFilePath = void 0;
const url = require$$5;
const path = path$1;
const fs = require$$0$1;
const child_process_1 = require$$3$1;
function uriToFilePath(uri) {
    let parsed = url.parse(uri);
    if (parsed.protocol !== 'file:' || !parsed.path) {
        return undefined;
    }
    let segments = parsed.path.split('/');
    for (var i = 0, len = segments.length; i < len; i++) {
        segments[i] = decodeURIComponent(segments[i]);
    }
    if (process.platform === 'win32' && segments.length > 1) {
        let first = segments[0];
        let second = segments[1];
        if (first.length === 0 && second.length > 1 && second[1] === ':') {
            segments.shift();
        }
    }
    return path.normalize(segments.join('/'));
}
files.uriToFilePath = uriToFilePath;
function isWindows$1() {
    return process.platform === 'win32';
}
function resolve(moduleName, nodePath, cwd, tracer) {
    const nodePathKey = 'NODE_PATH';
    const app = [
        'var p = process;',
        'p.on(\'message\',function(m){',
        'if(m.c===\'e\'){',
        'p.exit(0);',
        '}',
        'else if(m.c===\'rs\'){',
        'try{',
        'var r=require.resolve(m.a);',
        'p.send({c:\'r\',s:true,r:r});',
        '}',
        'catch(err){',
        'p.send({c:\'r\',s:false});',
        '}',
        '}',
        '});'
    ].join('');
    return new Promise((resolve, reject) => {
        let env = process.env;
        let newEnv = Object.create(null);
        Object.keys(env).forEach(key => newEnv[key] = env[key]);
        if (nodePath && fs.existsSync(nodePath) ) {
            if (newEnv[nodePathKey]) {
                newEnv[nodePathKey] = nodePath + path.delimiter + newEnv[nodePathKey];
            }
            else {
                newEnv[nodePathKey] = nodePath;
            }
            if (tracer) {
                tracer(`NODE_PATH value is: ${newEnv[nodePathKey]}`);
            }
        }
        newEnv['ELECTRON_RUN_AS_NODE'] = '1';
        try {
            let cp = (0, child_process_1.fork)('', [], {
                cwd: cwd,
                env: newEnv,
                execArgv: ['-e', app]
            });
            if (cp.pid === void 0) {
                reject(new Error(`Starting process to resolve node module  ${moduleName} failed`));
                return;
            }
            cp.on('error', (error) => {
                reject(error);
            });
            cp.on('message', (message) => {
                if (message.c === 'r') {
                    cp.send({ c: 'e' });
                    if (message.s) {
                        resolve(message.r);
                    }
                    else {
                        reject(new Error(`Failed to resolve module: ${moduleName}`));
                    }
                }
            });
            let message = {
                c: 'rs',
                a: moduleName
            };
            cp.send(message);
        }
        catch (error) {
            reject(error);
        }
    });
}
files.resolve = resolve;
function resolveGlobalNodePath(tracer) {
    let npmCommand = 'npm';
    const env = Object.create(null);
    Object.keys(process.env).forEach(key => env[key] = process.env[key]);
    env['NO_UPDATE_NOTIFIER'] = 'true';
    const options = {
        encoding: 'utf8',
        env
    };
    if (isWindows$1()) {
        npmCommand = 'npm.cmd';
        options.shell = true;
    }
    let handler = () => { };
    try {
        process.on('SIGPIPE', handler);
        let stdout = (0, child_process_1.spawnSync)(npmCommand, ['config', 'get', 'prefix'], options).stdout;
        if (!stdout) {
            if (tracer) {
                tracer(`'npm config get prefix' didn't return a value.`);
            }
            return undefined;
        }
        let prefix = stdout.trim();
        if (tracer) {
            tracer(`'npm config get prefix' value is: ${prefix}`);
        }
        if (prefix.length > 0) {
            if (isWindows$1()) {
                return path.join(prefix, 'node_modules');
            }
            else {
                return path.join(prefix, 'lib', 'node_modules');
            }
        }
        return undefined;
    }
    catch (err) {
        return undefined;
    }
    finally {
        process.removeListener('SIGPIPE', handler);
    }
}
files.resolveGlobalNodePath = resolveGlobalNodePath;
function resolveGlobalYarnPath(tracer) {
    let yarnCommand = 'yarn';
    let options = {
        encoding: 'utf8'
    };
    if (isWindows$1()) {
        yarnCommand = 'yarn.cmd';
        options.shell = true;
    }
    let handler = () => { };
    try {
        process.on('SIGPIPE', handler);
        let results = (0, child_process_1.spawnSync)(yarnCommand, ['global', 'dir', '--json'], options);
        let stdout = results.stdout;
        if (!stdout) {
            if (tracer) {
                tracer(`'yarn global dir' didn't return a value.`);
                if (results.stderr) {
                    tracer(results.stderr);
                }
            }
            return undefined;
        }
        let lines = stdout.trim().split(/\r?\n/);
        for (let line of lines) {
            try {
                let yarn = JSON.parse(line);
                if (yarn.type === 'log') {
                    return path.join(yarn.data, 'node_modules');
                }
            }
            catch (e) {
            }
        }
        return undefined;
    }
    catch (err) {
        return undefined;
    }
    finally {
        process.removeListener('SIGPIPE', handler);
    }
}
files.resolveGlobalYarnPath = resolveGlobalYarnPath;
var FileSystem;
(function (FileSystem) {
    let _isCaseSensitive = undefined;
    function isCaseSensitive() {
        if (_isCaseSensitive !== void 0) {
            return _isCaseSensitive;
        }
        if (process.platform === 'win32') {
            _isCaseSensitive = false;
        }
        else {
            _isCaseSensitive = !fs.existsSync(__filename.toUpperCase()) || !fs.existsSync(__filename.toLowerCase());
        }
        return _isCaseSensitive;
    }
    FileSystem.isCaseSensitive = isCaseSensitive;
    function isParent(parent, child) {
        if (isCaseSensitive()) {
            return path.normalize(child).indexOf(path.normalize(parent)) === 0;
        }
        else {
            return path.normalize(child).toLowerCase().indexOf(path.normalize(parent).toLowerCase()) === 0;
        }
    }
    FileSystem.isParent = isParent;
})(FileSystem || (files.FileSystem = FileSystem = {}));
function resolveModulePath(workspaceRoot, moduleName, nodePath, tracer) {
    if (nodePath) {
        if (!path.isAbsolute(nodePath)) {
            nodePath = path.join(workspaceRoot, nodePath);
        }
        return resolve(moduleName, nodePath, nodePath, tracer).then((value) => {
            if (FileSystem.isParent(nodePath, value)) {
                return value;
            }
            else {
                return Promise.reject(new Error(`Failed to load ${moduleName} from node path location.`));
            }
        }).then(undefined, (_error) => {
            return resolve(moduleName, resolveGlobalNodePath(tracer), workspaceRoot, tracer);
        });
    }
    else {
        return resolve(moduleName, resolveGlobalNodePath(tracer), workspaceRoot, tracer);
    }
}
files.resolveModulePath = resolveModulePath;

var node$2 = main$7;
getDefaultExportFromCjs(node$2);

var api$2 = {};

var inlineCompletion_proposed = {};

Object.defineProperty(inlineCompletion_proposed, "__esModule", { value: true });
inlineCompletion_proposed.InlineCompletionFeature = void 0;
const vscode_languageserver_protocol_1$2 = main$7;
const InlineCompletionFeature = (Base) => {
    return class extends Base {
        get inlineCompletion() {
            return {
                on: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1$2.InlineCompletionRequest.type, (params, cancel) => {
                        return handler(params, cancel, this.attachWorkDoneProgress(params));
                    });
                }
            };
        }
    };
};
inlineCompletion_proposed.InlineCompletionFeature = InlineCompletionFeature;

(function (exports) {
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    var desc = Object.getOwnPropertyDescriptor(m, k);
	    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	      desc = { enumerable: true, get: function() { return m[k]; } };
	    }
	    Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.ProposedFeatures = exports.NotebookDocuments = exports.TextDocuments = exports.SemanticTokensBuilder = void 0;
	const semanticTokens_1 = semanticTokens;
	Object.defineProperty(exports, "SemanticTokensBuilder", { enumerable: true, get: function () { return semanticTokens_1.SemanticTokensBuilder; } });
	const ic = inlineCompletion_proposed;
	__exportStar(main$7, exports);
	const textDocuments_1 = textDocuments;
	Object.defineProperty(exports, "TextDocuments", { enumerable: true, get: function () { return textDocuments_1.TextDocuments; } });
	const notebook_1 = notebook;
	Object.defineProperty(exports, "NotebookDocuments", { enumerable: true, get: function () { return notebook_1.NotebookDocuments; } });
	__exportStar(server, exports);
	var ProposedFeatures;
	(function (ProposedFeatures) {
	    ProposedFeatures.all = {
	        __brand: 'features',
	        languages: ic.InlineCompletionFeature
	    };
	})(ProposedFeatures || (exports.ProposedFeatures = ProposedFeatures = {}));
} (api$2));
getDefaultExportFromCjs(api$2);

(function (exports) {
	/// <reference path="../../typings/thenable.d.ts" />
	var __createBinding = (commonjsGlobal && commonjsGlobal.__createBinding) || (Object.create ? (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    var desc = Object.getOwnPropertyDescriptor(m, k);
	    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	      desc = { enumerable: true, get: function() { return m[k]; } };
	    }
	    Object.defineProperty(o, k2, desc);
	}) : (function(o, m, k, k2) {
	    if (k2 === undefined) k2 = k;
	    o[k2] = m[k];
	}));
	var __exportStar = (commonjsGlobal && commonjsGlobal.__exportStar) || function(m, exports) {
	    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
	};
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.createConnection = exports.Files = void 0;
	const node_util_1 = require$$0$2;
	const Is = is$4;
	const server_1 = server;
	const fm = files;
	const node_1 = node$2;
	__exportStar(node$2, exports);
	__exportStar(api$2, exports);
	var Files;
	(function (Files) {
	    Files.uriToFilePath = fm.uriToFilePath;
	    Files.resolveGlobalNodePath = fm.resolveGlobalNodePath;
	    Files.resolveGlobalYarnPath = fm.resolveGlobalYarnPath;
	    Files.resolve = fm.resolve;
	    Files.resolveModulePath = fm.resolveModulePath;
	})(Files || (exports.Files = Files = {}));
	function endProtocolConnection() {
	    {
	        return;
	    }
	}
	let _shutdownReceived = false;
	let exitTimer = undefined;
	function setupExitTimer() {
	    const argName = '--clientProcessId';
	    function runTimer(value) {
	        try {
	            let processId = parseInt(value);
	            if (!isNaN(processId)) {
	                exitTimer = setInterval(() => {
	                    try {
	                        process.kill(processId, 0);
	                    }
	                    catch (ex) {
	                        endProtocolConnection();
	                        process.exit(_shutdownReceived ? 0 : 1);
	                    }
	                }, 3000);
	            }
	        }
	        catch (e) {
	        }
	    }
	    for (let i = 2; i < process.argv.length; i++) {
	        let arg = process.argv[i];
	        if (arg === argName && i + 1 < process.argv.length) {
	            runTimer(process.argv[i + 1]);
	            return;
	        }
	        else {
	            let args = arg.split('=');
	            if (args[0] === argName) {
	                runTimer(args[1]);
	            }
	        }
	    }
	}
	setupExitTimer();
	const watchDog = {
	    initialize: (params) => {
	        const processId = params.processId;
	        if (Is.number(processId) && exitTimer === undefined) {
	            setInterval(() => {
	                try {
	                    process.kill(processId, 0);
	                }
	                catch (ex) {
	                    process.exit(_shutdownReceived ? 0 : 1);
	                }
	            }, 3000);
	        }
	    },
	    get shutdownReceived() {
	        return _shutdownReceived;
	    },
	    set shutdownReceived(value) {
	        _shutdownReceived = value;
	    },
	    exit: (code) => {
	        process.exit(code);
	    }
	};
	function createConnection(arg1, arg2, arg3, arg4) {
	    let factories;
	    let input;
	    let output;
	    let options;
	    if (arg1 !== void 0 && arg1.__brand === 'features') {
	        factories = arg1;
	        arg1 = arg2;
	        arg2 = arg3;
	        arg3 = arg4;
	    }
	    if (node_1.ConnectionStrategy.is(arg1) || node_1.ConnectionOptions.is(arg1)) {
	        options = arg1;
	    }
	    else {
	        input = arg1;
	        output = arg2;
	        options = arg3;
	    }
	    return _createConnection(input, output, options, factories);
	}
	exports.createConnection = createConnection;
	function _createConnection(input, output, options, factories) {
	    let stdio = false;
	    if (!input && !output && process.argv.length > 2) {
	        let port = void 0;
	        let pipeName = void 0;
	        let argv = process.argv.slice(2);
	        for (let i = 0; i < argv.length; i++) {
	            let arg = argv[i];
	            if (arg === '--node-ipc') {
	                input = new node_1.IPCMessageReader(process);
	                output = new node_1.IPCMessageWriter(process);
	                break;
	            }
	            else if (arg === '--stdio') {
	                stdio = true;
	                input = process.stdin;
	                output = process.stdout;
	                break;
	            }
	            else if (arg === '--socket') {
	                port = parseInt(argv[i + 1]);
	                break;
	            }
	            else if (arg === '--pipe') {
	                pipeName = argv[i + 1];
	                break;
	            }
	            else {
	                var args = arg.split('=');
	                if (args[0] === '--socket') {
	                    port = parseInt(args[1]);
	                    break;
	                }
	                else if (args[0] === '--pipe') {
	                    pipeName = args[1];
	                    break;
	                }
	            }
	        }
	        if (port) {
	            let transport = (0, node_1.createServerSocketTransport)(port);
	            input = transport[0];
	            output = transport[1];
	        }
	        else if (pipeName) {
	            let transport = (0, node_1.createServerPipeTransport)(pipeName);
	            input = transport[0];
	            output = transport[1];
	        }
	    }
	    var commandLineMessage = 'Use arguments of createConnection or set command line parameters: \'--node-ipc\', \'--stdio\' or \'--socket={number}\'';
	    if (!input) {
	        throw new Error('Connection input stream is not set. ' + commandLineMessage);
	    }
	    if (!output) {
	        throw new Error('Connection output stream is not set. ' + commandLineMessage);
	    }
	    if (Is.func(input.read) && Is.func(input.on)) {
	        let inputStream = input;
	        inputStream.on('end', () => {
	            process.exit(_shutdownReceived ? 0 : 1);
	        });
	        inputStream.on('close', () => {
	            process.exit(_shutdownReceived ? 0 : 1);
	        });
	    }
	    const connectionFactory = (logger) => {
	        const result = (0, node_1.createProtocolConnection)(input, output, logger, options);
	        if (stdio) {
	            patchConsole(logger);
	        }
	        return result;
	    };
	    return (0, server_1.createConnection)(connectionFactory, watchDog, factories);
	}
	function patchConsole(logger) {
	    function serialize(args) {
	        return args.map(arg => typeof arg === 'string' ? arg : (0, node_util_1.inspect)(arg)).join(' ');
	    }
	    const counters = new Map();
	    console.assert = function assert(assertion, ...args) {
	        if (assertion) {
	            return;
	        }
	        if (args.length === 0) {
	            logger.error('Assertion failed');
	        }
	        else {
	            const [message, ...rest] = args;
	            logger.error(`Assertion failed: ${message} ${serialize(rest)}`);
	        }
	    };
	    console.count = function count(label = 'default') {
	        const message = String(label);
	        let counter = counters.get(message) ?? 0;
	        counter += 1;
	        counters.set(message, counter);
	        logger.log(`${message}: ${message}`);
	    };
	    console.countReset = function countReset(label) {
	        if (label === undefined) {
	            counters.clear();
	        }
	        else {
	            counters.delete(String(label));
	        }
	    };
	    console.debug = function debug(...args) {
	        logger.log(serialize(args));
	    };
	    console.dir = function dir(arg, options) {
	        logger.log((0, node_util_1.inspect)(arg, options));
	    };
	    console.log = function log(...args) {
	        logger.log(serialize(args));
	    };
	    console.error = function error(...args) {
	        logger.error(serialize(args));
	    };
	    console.trace = function trace(...args) {
	        const stack = new Error().stack.replace(/(.+\n){2}/, '');
	        let message = 'Trace';
	        if (args.length !== 0) {
	            message += `: ${serialize(args)}`;
	        }
	        logger.log(`${message}\n${stack}`);
	    };
	    console.warn = function warn(...args) {
	        logger.warn(serialize(args));
	    };
	}
} (main$8));
getDefaultExportFromCjs(main$8);

var node$1 = main$8;
getDefaultExportFromCjs(node$1);

var DiagnosticsManager$1 = {};

var utils$4 = {};

var lodash = {exports: {}};

/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
lodash.exports;
(function (module, exports) {
(function() {
	  var undefined$1;
	  var VERSION = '4.17.21';
	  var LARGE_ARRAY_SIZE = 200;
	  var CORE_ERROR_TEXT = 'Unsupported core-js use. Try https://npms.io/search?q=ponyfill.',
	      FUNC_ERROR_TEXT = 'Expected a function',
	      INVALID_TEMPL_VAR_ERROR_TEXT = 'Invalid `variable` option passed into `_.template`';
	  var HASH_UNDEFINED = '__lodash_hash_undefined__';
	  var MAX_MEMOIZE_SIZE = 500;
	  var PLACEHOLDER = '__lodash_placeholder__';
	  var CLONE_DEEP_FLAG = 1,
	      CLONE_FLAT_FLAG = 2,
	      CLONE_SYMBOLS_FLAG = 4;
	  var COMPARE_PARTIAL_FLAG = 1,
	      COMPARE_UNORDERED_FLAG = 2;
	  var WRAP_BIND_FLAG = 1,
	      WRAP_BIND_KEY_FLAG = 2,
	      WRAP_CURRY_BOUND_FLAG = 4,
	      WRAP_CURRY_FLAG = 8,
	      WRAP_CURRY_RIGHT_FLAG = 16,
	      WRAP_PARTIAL_FLAG = 32,
	      WRAP_PARTIAL_RIGHT_FLAG = 64,
	      WRAP_ARY_FLAG = 128,
	      WRAP_REARG_FLAG = 256,
	      WRAP_FLIP_FLAG = 512;
	  var DEFAULT_TRUNC_LENGTH = 30,
	      DEFAULT_TRUNC_OMISSION = '...';
	  var HOT_COUNT = 800,
	      HOT_SPAN = 16;
	  var LAZY_FILTER_FLAG = 1,
	      LAZY_MAP_FLAG = 2,
	      LAZY_WHILE_FLAG = 3;
	  var INFINITY = 1 / 0,
	      MAX_SAFE_INTEGER = 9007199254740991,
	      MAX_INTEGER = 1.7976931348623157e+308,
	      NAN = 0 / 0;
	  var MAX_ARRAY_LENGTH = 4294967295,
	      MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1,
	      HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;
	  var wrapFlags = [
	    ['ary', WRAP_ARY_FLAG],
	    ['bind', WRAP_BIND_FLAG],
	    ['bindKey', WRAP_BIND_KEY_FLAG],
	    ['curry', WRAP_CURRY_FLAG],
	    ['curryRight', WRAP_CURRY_RIGHT_FLAG],
	    ['flip', WRAP_FLIP_FLAG],
	    ['partial', WRAP_PARTIAL_FLAG],
	    ['partialRight', WRAP_PARTIAL_RIGHT_FLAG],
	    ['rearg', WRAP_REARG_FLAG]
	  ];
	  var argsTag = '[object Arguments]',
	      arrayTag = '[object Array]',
	      asyncTag = '[object AsyncFunction]',
	      boolTag = '[object Boolean]',
	      dateTag = '[object Date]',
	      domExcTag = '[object DOMException]',
	      errorTag = '[object Error]',
	      funcTag = '[object Function]',
	      genTag = '[object GeneratorFunction]',
	      mapTag = '[object Map]',
	      numberTag = '[object Number]',
	      nullTag = '[object Null]',
	      objectTag = '[object Object]',
	      promiseTag = '[object Promise]',
	      proxyTag = '[object Proxy]',
	      regexpTag = '[object RegExp]',
	      setTag = '[object Set]',
	      stringTag = '[object String]',
	      symbolTag = '[object Symbol]',
	      undefinedTag = '[object Undefined]',
	      weakMapTag = '[object WeakMap]',
	      weakSetTag = '[object WeakSet]';
	  var arrayBufferTag = '[object ArrayBuffer]',
	      dataViewTag = '[object DataView]',
	      float32Tag = '[object Float32Array]',
	      float64Tag = '[object Float64Array]',
	      int8Tag = '[object Int8Array]',
	      int16Tag = '[object Int16Array]',
	      int32Tag = '[object Int32Array]',
	      uint8Tag = '[object Uint8Array]',
	      uint8ClampedTag = '[object Uint8ClampedArray]',
	      uint16Tag = '[object Uint16Array]',
	      uint32Tag = '[object Uint32Array]';
	  var reEmptyStringLeading = /\b__p \+= '';/g,
	      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
	      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
	  var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g,
	      reUnescapedHtml = /[&<>"']/g,
	      reHasEscapedHtml = RegExp(reEscapedHtml.source),
	      reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
	  var reEscape = /<%-([\s\S]+?)%>/g,
	      reEvaluate = /<%([\s\S]+?)%>/g,
	      reInterpolate = /<%=([\s\S]+?)%>/g;
	  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
	      reIsPlainProp = /^\w*$/,
	      rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
	  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g,
	      reHasRegExpChar = RegExp(reRegExpChar.source);
	  var reTrimStart = /^\s+/;
	  var reWhitespace = /\s/;
	  var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
	      reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/,
	      reSplitDetails = /,? & /;
	  var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
	  var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
	  var reEscapeChar = /\\(\\)?/g;
	  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
	  var reFlags = /\w*$/;
	  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
	  var reIsBinary = /^0b[01]+$/i;
	  var reIsHostCtor = /^\[object .+?Constructor\]$/;
	  var reIsOctal = /^0o[0-7]+$/i;
	  var reIsUint = /^(?:0|[1-9]\d*)$/;
	  var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
	  var reNoMatch = /($^)/;
	  var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
	  var rsAstralRange = '\\ud800-\\udfff',
	      rsComboMarksRange = '\\u0300-\\u036f',
	      reComboHalfMarksRange = '\\ufe20-\\ufe2f',
	      rsComboSymbolsRange = '\\u20d0-\\u20ff',
	      rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
	      rsDingbatRange = '\\u2700-\\u27bf',
	      rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
	      rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
	      rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
	      rsPunctuationRange = '\\u2000-\\u206f',
	      rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
	      rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
	      rsVarRange = '\\ufe0e\\ufe0f',
	      rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
	  var rsApos = "['\u2019]",
	      rsAstral = '[' + rsAstralRange + ']',
	      rsBreak = '[' + rsBreakRange + ']',
	      rsCombo = '[' + rsComboRange + ']',
	      rsDigits = '\\d+',
	      rsDingbat = '[' + rsDingbatRange + ']',
	      rsLower = '[' + rsLowerRange + ']',
	      rsMisc = '[^' + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
	      rsFitz = '\\ud83c[\\udffb-\\udfff]',
	      rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
	      rsNonAstral = '[^' + rsAstralRange + ']',
	      rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
	      rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
	      rsUpper = '[' + rsUpperRange + ']',
	      rsZWJ = '\\u200d';
	  var rsMiscLower = '(?:' + rsLower + '|' + rsMisc + ')',
	      rsMiscUpper = '(?:' + rsUpper + '|' + rsMisc + ')',
	      rsOptContrLower = '(?:' + rsApos + '(?:d|ll|m|re|s|t|ve))?',
	      rsOptContrUpper = '(?:' + rsApos + '(?:D|LL|M|RE|S|T|VE))?',
	      reOptMod = rsModifier + '?',
	      rsOptVar = '[' + rsVarRange + ']?',
	      rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
	      rsOrdLower = '\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])',
	      rsOrdUpper = '\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])',
	      rsSeq = rsOptVar + reOptMod + rsOptJoin,
	      rsEmoji = '(?:' + [rsDingbat, rsRegional, rsSurrPair].join('|') + ')' + rsSeq,
	      rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';
	  var reApos = RegExp(rsApos, 'g');
	  var reComboMark = RegExp(rsCombo, 'g');
	  var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');
	  var reUnicodeWord = RegExp([
	    rsUpper + '?' + rsLower + '+' + rsOptContrLower + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
	    rsMiscUpper + '+' + rsOptContrUpper + '(?=' + [rsBreak, rsUpper + rsMiscLower, '$'].join('|') + ')',
	    rsUpper + '?' + rsMiscLower + '+' + rsOptContrLower,
	    rsUpper + '+' + rsOptContrUpper,
	    rsOrdUpper,
	    rsOrdLower,
	    rsDigits,
	    rsEmoji
	  ].join('|'), 'g');
	  var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');
	  var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
	  var contextProps = [
	    'Array', 'Buffer', 'DataView', 'Date', 'Error', 'Float32Array', 'Float64Array',
	    'Function', 'Int8Array', 'Int16Array', 'Int32Array', 'Map', 'Math', 'Object',
	    'Promise', 'RegExp', 'Set', 'String', 'Symbol', 'TypeError', 'Uint8Array',
	    'Uint8ClampedArray', 'Uint16Array', 'Uint32Array', 'WeakMap',
	    '_', 'clearTimeout', 'isFinite', 'parseInt', 'setTimeout'
	  ];
	  var templateCounter = -1;
	  var typedArrayTags = {};
	  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
	  typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
	  typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
	  typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
	  typedArrayTags[uint32Tag] = true;
	  typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
	  typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
	  typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
	  typedArrayTags[errorTag] = typedArrayTags[funcTag] =
	  typedArrayTags[mapTag] = typedArrayTags[numberTag] =
	  typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
	  typedArrayTags[setTag] = typedArrayTags[stringTag] =
	  typedArrayTags[weakMapTag] = false;
	  var cloneableTags = {};
	  cloneableTags[argsTag] = cloneableTags[arrayTag] =
	  cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
	  cloneableTags[boolTag] = cloneableTags[dateTag] =
	  cloneableTags[float32Tag] = cloneableTags[float64Tag] =
	  cloneableTags[int8Tag] = cloneableTags[int16Tag] =
	  cloneableTags[int32Tag] = cloneableTags[mapTag] =
	  cloneableTags[numberTag] = cloneableTags[objectTag] =
	  cloneableTags[regexpTag] = cloneableTags[setTag] =
	  cloneableTags[stringTag] = cloneableTags[symbolTag] =
	  cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
	  cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
	  cloneableTags[errorTag] = cloneableTags[funcTag] =
	  cloneableTags[weakMapTag] = false;
	  var deburredLetters = {
	    '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
	    '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
	    '\xc7': 'C',  '\xe7': 'c',
	    '\xd0': 'D',  '\xf0': 'd',
	    '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
	    '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
	    '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
	    '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
	    '\xd1': 'N',  '\xf1': 'n',
	    '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
	    '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
	    '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
	    '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
	    '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
	    '\xc6': 'Ae', '\xe6': 'ae',
	    '\xde': 'Th', '\xfe': 'th',
	    '\xdf': 'ss',
	    '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
	    '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
	    '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
	    '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
	    '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
	    '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
	    '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
	    '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
	    '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
	    '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
	    '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
	    '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
	    '\u0134': 'J',  '\u0135': 'j',
	    '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
	    '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
	    '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
	    '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
	    '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
	    '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
	    '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
	    '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
	    '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
	    '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
	    '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
	    '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
	    '\u0163': 't',  '\u0165': 't', '\u0167': 't',
	    '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
	    '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
	    '\u0174': 'W',  '\u0175': 'w',
	    '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
	    '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
	    '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
	    '\u0132': 'IJ', '\u0133': 'ij',
	    '\u0152': 'Oe', '\u0153': 'oe',
	    '\u0149': "'n", '\u017f': 's'
	  };
	  var htmlEscapes = {
	    '&': '&amp;',
	    '<': '&lt;',
	    '>': '&gt;',
	    '"': '&quot;',
	    "'": '&#39;'
	  };
	  var htmlUnescapes = {
	    '&amp;': '&',
	    '&lt;': '<',
	    '&gt;': '>',
	    '&quot;': '"',
	    '&#39;': "'"
	  };
	  var stringEscapes = {
	    '\\': '\\',
	    "'": "'",
	    '\n': 'n',
	    '\r': 'r',
	    '\u2028': 'u2028',
	    '\u2029': 'u2029'
	  };
	  var freeParseFloat = parseFloat,
	      freeParseInt = parseInt;
	  var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
	  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;
	  var root = freeGlobal || freeSelf || Function('return this')();
	  var freeExports = exports && !exports.nodeType && exports;
	  var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;
	  var moduleExports = freeModule && freeModule.exports === freeExports;
	  var freeProcess = moduleExports && freeGlobal.process;
	  var nodeUtil = (function() {
	    try {
	      var types = freeModule && freeModule.require && freeModule.require('util').types;
	      if (types) {
	        return types;
	      }
	      return freeProcess && freeProcess.binding && freeProcess.binding('util');
	    } catch (e) {}
	  }());
	  var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer,
	      nodeIsDate = nodeUtil && nodeUtil.isDate,
	      nodeIsMap = nodeUtil && nodeUtil.isMap,
	      nodeIsRegExp = nodeUtil && nodeUtil.isRegExp,
	      nodeIsSet = nodeUtil && nodeUtil.isSet,
	      nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
	  function apply(func, thisArg, args) {
	    switch (args.length) {
	      case 0: return func.call(thisArg);
	      case 1: return func.call(thisArg, args[0]);
	      case 2: return func.call(thisArg, args[0], args[1]);
	      case 3: return func.call(thisArg, args[0], args[1], args[2]);
	    }
	    return func.apply(thisArg, args);
	  }
	  function arrayAggregator(array, setter, iteratee, accumulator) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	    while (++index < length) {
	      var value = array[index];
	      setter(accumulator, value, iteratee(value), array);
	    }
	    return accumulator;
	  }
	  function arrayEach(array, iteratee) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	    while (++index < length) {
	      if (iteratee(array[index], index, array) === false) {
	        break;
	      }
	    }
	    return array;
	  }
	  function arrayEachRight(array, iteratee) {
	    var length = array == null ? 0 : array.length;
	    while (length--) {
	      if (iteratee(array[length], length, array) === false) {
	        break;
	      }
	    }
	    return array;
	  }
	  function arrayEvery(array, predicate) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	    while (++index < length) {
	      if (!predicate(array[index], index, array)) {
	        return false;
	      }
	    }
	    return true;
	  }
	  function arrayFilter(array, predicate) {
	    var index = -1,
	        length = array == null ? 0 : array.length,
	        resIndex = 0,
	        result = [];
	    while (++index < length) {
	      var value = array[index];
	      if (predicate(value, index, array)) {
	        result[resIndex++] = value;
	      }
	    }
	    return result;
	  }
	  function arrayIncludes(array, value) {
	    var length = array == null ? 0 : array.length;
	    return !!length && baseIndexOf(array, value, 0) > -1;
	  }
	  function arrayIncludesWith(array, value, comparator) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	    while (++index < length) {
	      if (comparator(value, array[index])) {
	        return true;
	      }
	    }
	    return false;
	  }
	  function arrayMap(array, iteratee) {
	    var index = -1,
	        length = array == null ? 0 : array.length,
	        result = Array(length);
	    while (++index < length) {
	      result[index] = iteratee(array[index], index, array);
	    }
	    return result;
	  }
	  function arrayPush(array, values) {
	    var index = -1,
	        length = values.length,
	        offset = array.length;
	    while (++index < length) {
	      array[offset + index] = values[index];
	    }
	    return array;
	  }
	  function arrayReduce(array, iteratee, accumulator, initAccum) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	    if (initAccum && length) {
	      accumulator = array[++index];
	    }
	    while (++index < length) {
	      accumulator = iteratee(accumulator, array[index], index, array);
	    }
	    return accumulator;
	  }
	  function arrayReduceRight(array, iteratee, accumulator, initAccum) {
	    var length = array == null ? 0 : array.length;
	    if (initAccum && length) {
	      accumulator = array[--length];
	    }
	    while (length--) {
	      accumulator = iteratee(accumulator, array[length], length, array);
	    }
	    return accumulator;
	  }
	  function arraySome(array, predicate) {
	    var index = -1,
	        length = array == null ? 0 : array.length;
	    while (++index < length) {
	      if (predicate(array[index], index, array)) {
	        return true;
	      }
	    }
	    return false;
	  }
	  var asciiSize = baseProperty('length');
	  function asciiToArray(string) {
	    return string.split('');
	  }
	  function asciiWords(string) {
	    return string.match(reAsciiWord) || [];
	  }
	  function baseFindKey(collection, predicate, eachFunc) {
	    var result;
	    eachFunc(collection, function(value, key, collection) {
	      if (predicate(value, key, collection)) {
	        result = key;
	        return false;
	      }
	    });
	    return result;
	  }
	  function baseFindIndex(array, predicate, fromIndex, fromRight) {
	    var length = array.length,
	        index = fromIndex + (fromRight ? 1 : -1);
	    while ((fromRight ? index-- : ++index < length)) {
	      if (predicate(array[index], index, array)) {
	        return index;
	      }
	    }
	    return -1;
	  }
	  function baseIndexOf(array, value, fromIndex) {
	    return value === value
	      ? strictIndexOf(array, value, fromIndex)
	      : baseFindIndex(array, baseIsNaN, fromIndex);
	  }
	  function baseIndexOfWith(array, value, fromIndex, comparator) {
	    var index = fromIndex - 1,
	        length = array.length;
	    while (++index < length) {
	      if (comparator(array[index], value)) {
	        return index;
	      }
	    }
	    return -1;
	  }
	  function baseIsNaN(value) {
	    return value !== value;
	  }
	  function baseMean(array, iteratee) {
	    var length = array == null ? 0 : array.length;
	    return length ? (baseSum(array, iteratee) / length) : NAN;
	  }
	  function baseProperty(key) {
	    return function(object) {
	      return object == null ? undefined$1 : object[key];
	    };
	  }
	  function basePropertyOf(object) {
	    return function(key) {
	      return object == null ? undefined$1 : object[key];
	    };
	  }
	  function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
	    eachFunc(collection, function(value, index, collection) {
	      accumulator = initAccum
	        ? (initAccum = false, value)
	        : iteratee(accumulator, value, index, collection);
	    });
	    return accumulator;
	  }
	  function baseSortBy(array, comparer) {
	    var length = array.length;
	    array.sort(comparer);
	    while (length--) {
	      array[length] = array[length].value;
	    }
	    return array;
	  }
	  function baseSum(array, iteratee) {
	    var result,
	        index = -1,
	        length = array.length;
	    while (++index < length) {
	      var current = iteratee(array[index]);
	      if (current !== undefined$1) {
	        result = result === undefined$1 ? current : (result + current);
	      }
	    }
	    return result;
	  }
	  function baseTimes(n, iteratee) {
	    var index = -1,
	        result = Array(n);
	    while (++index < n) {
	      result[index] = iteratee(index);
	    }
	    return result;
	  }
	  function baseToPairs(object, props) {
	    return arrayMap(props, function(key) {
	      return [key, object[key]];
	    });
	  }
	  function baseTrim(string) {
	    return string
	      ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '')
	      : string;
	  }
	  function baseUnary(func) {
	    return function(value) {
	      return func(value);
	    };
	  }
	  function baseValues(object, props) {
	    return arrayMap(props, function(key) {
	      return object[key];
	    });
	  }
	  function cacheHas(cache, key) {
	    return cache.has(key);
	  }
	  function charsStartIndex(strSymbols, chrSymbols) {
	    var index = -1,
	        length = strSymbols.length;
	    while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
	    return index;
	  }
	  function charsEndIndex(strSymbols, chrSymbols) {
	    var index = strSymbols.length;
	    while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
	    return index;
	  }
	  function countHolders(array, placeholder) {
	    var length = array.length,
	        result = 0;
	    while (length--) {
	      if (array[length] === placeholder) {
	        ++result;
	      }
	    }
	    return result;
	  }
	  var deburrLetter = basePropertyOf(deburredLetters);
	  var escapeHtmlChar = basePropertyOf(htmlEscapes);
	  function escapeStringChar(chr) {
	    return '\\' + stringEscapes[chr];
	  }
	  function getValue(object, key) {
	    return object == null ? undefined$1 : object[key];
	  }
	  function hasUnicode(string) {
	    return reHasUnicode.test(string);
	  }
	  function hasUnicodeWord(string) {
	    return reHasUnicodeWord.test(string);
	  }
	  function iteratorToArray(iterator) {
	    var data,
	        result = [];
	    while (!(data = iterator.next()).done) {
	      result.push(data.value);
	    }
	    return result;
	  }
	  function mapToArray(map) {
	    var index = -1,
	        result = Array(map.size);
	    map.forEach(function(value, key) {
	      result[++index] = [key, value];
	    });
	    return result;
	  }
	  function overArg(func, transform) {
	    return function(arg) {
	      return func(transform(arg));
	    };
	  }
	  function replaceHolders(array, placeholder) {
	    var index = -1,
	        length = array.length,
	        resIndex = 0,
	        result = [];
	    while (++index < length) {
	      var value = array[index];
	      if (value === placeholder || value === PLACEHOLDER) {
	        array[index] = PLACEHOLDER;
	        result[resIndex++] = index;
	      }
	    }
	    return result;
	  }
	  function setToArray(set) {
	    var index = -1,
	        result = Array(set.size);
	    set.forEach(function(value) {
	      result[++index] = value;
	    });
	    return result;
	  }
	  function setToPairs(set) {
	    var index = -1,
	        result = Array(set.size);
	    set.forEach(function(value) {
	      result[++index] = [value, value];
	    });
	    return result;
	  }
	  function strictIndexOf(array, value, fromIndex) {
	    var index = fromIndex - 1,
	        length = array.length;
	    while (++index < length) {
	      if (array[index] === value) {
	        return index;
	      }
	    }
	    return -1;
	  }
	  function strictLastIndexOf(array, value, fromIndex) {
	    var index = fromIndex + 1;
	    while (index--) {
	      if (array[index] === value) {
	        return index;
	      }
	    }
	    return index;
	  }
	  function stringSize(string) {
	    return hasUnicode(string)
	      ? unicodeSize(string)
	      : asciiSize(string);
	  }
	  function stringToArray(string) {
	    return hasUnicode(string)
	      ? unicodeToArray(string)
	      : asciiToArray(string);
	  }
	  function trimmedEndIndex(string) {
	    var index = string.length;
	    while (index-- && reWhitespace.test(string.charAt(index))) {}
	    return index;
	  }
	  var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
	  function unicodeSize(string) {
	    var result = reUnicode.lastIndex = 0;
	    while (reUnicode.test(string)) {
	      ++result;
	    }
	    return result;
	  }
	  function unicodeToArray(string) {
	    return string.match(reUnicode) || [];
	  }
	  function unicodeWords(string) {
	    return string.match(reUnicodeWord) || [];
	  }
	  var runInContext = (function runInContext(context) {
	    context = context == null ? root : _.defaults(root.Object(), context, _.pick(root, contextProps));
	    var Array = context.Array,
	        Date = context.Date,
	        Error = context.Error,
	        Function = context.Function,
	        Math = context.Math,
	        Object = context.Object,
	        RegExp = context.RegExp,
	        String = context.String,
	        TypeError = context.TypeError;
	    var arrayProto = Array.prototype,
	        funcProto = Function.prototype,
	        objectProto = Object.prototype;
	    var coreJsData = context['__core-js_shared__'];
	    var funcToString = funcProto.toString;
	    var hasOwnProperty = objectProto.hasOwnProperty;
	    var idCounter = 0;
	    var maskSrcKey = (function() {
	      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
	      return uid ? ('Symbol(src)_1.' + uid) : '';
	    }());
	    var nativeObjectToString = objectProto.toString;
	    var objectCtorString = funcToString.call(Object);
	    var oldDash = root._;
	    var reIsNative = RegExp('^' +
	      funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	      .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	    );
	    var Buffer = moduleExports ? context.Buffer : undefined$1,
	        Symbol = context.Symbol,
	        Uint8Array = context.Uint8Array,
	        allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined$1,
	        getPrototype = overArg(Object.getPrototypeOf, Object),
	        objectCreate = Object.create,
	        propertyIsEnumerable = objectProto.propertyIsEnumerable,
	        splice = arrayProto.splice,
	        spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined$1,
	        symIterator = Symbol ? Symbol.iterator : undefined$1,
	        symToStringTag = Symbol ? Symbol.toStringTag : undefined$1;
	    var defineProperty = (function() {
	      try {
	        var func = getNative(Object, 'defineProperty');
	        func({}, '', {});
	        return func;
	      } catch (e) {}
	    }());
	    var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout,
	        ctxNow = Date && Date.now !== root.Date.now && Date.now,
	        ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;
	    var nativeCeil = Math.ceil,
	        nativeFloor = Math.floor,
	        nativeGetSymbols = Object.getOwnPropertySymbols,
	        nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined$1,
	        nativeIsFinite = context.isFinite,
	        nativeJoin = arrayProto.join,
	        nativeKeys = overArg(Object.keys, Object),
	        nativeMax = Math.max,
	        nativeMin = Math.min,
	        nativeNow = Date.now,
	        nativeParseInt = context.parseInt,
	        nativeRandom = Math.random,
	        nativeReverse = arrayProto.reverse;
	    var DataView = getNative(context, 'DataView'),
	        Map = getNative(context, 'Map'),
	        Promise = getNative(context, 'Promise'),
	        Set = getNative(context, 'Set'),
	        WeakMap = getNative(context, 'WeakMap'),
	        nativeCreate = getNative(Object, 'create');
	    var metaMap = WeakMap && new WeakMap;
	    var realNames = {};
	    var dataViewCtorString = toSource(DataView),
	        mapCtorString = toSource(Map),
	        promiseCtorString = toSource(Promise),
	        setCtorString = toSource(Set),
	        weakMapCtorString = toSource(WeakMap);
	    var symbolProto = Symbol ? Symbol.prototype : undefined$1,
	        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined$1,
	        symbolToString = symbolProto ? symbolProto.toString : undefined$1;
	    function lodash(value) {
	      if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
	        if (value instanceof LodashWrapper) {
	          return value;
	        }
	        if (hasOwnProperty.call(value, '__wrapped__')) {
	          return wrapperClone(value);
	        }
	      }
	      return new LodashWrapper(value);
	    }
	    var baseCreate = (function() {
	      function object() {}
	      return function(proto) {
	        if (!isObject(proto)) {
	          return {};
	        }
	        if (objectCreate) {
	          return objectCreate(proto);
	        }
	        object.prototype = proto;
	        var result = new object;
	        object.prototype = undefined$1;
	        return result;
	      };
	    }());
	    function baseLodash() {
	    }
	    function LodashWrapper(value, chainAll) {
	      this.__wrapped__ = value;
	      this.__actions__ = [];
	      this.__chain__ = !!chainAll;
	      this.__index__ = 0;
	      this.__values__ = undefined$1;
	    }
	    lodash.templateSettings = {
	      'escape': reEscape,
	      'evaluate': reEvaluate,
	      'interpolate': reInterpolate,
	      'variable': '',
	      'imports': {
	        '_': lodash
	      }
	    };
	    lodash.prototype = baseLodash.prototype;
	    lodash.prototype.constructor = lodash;
	    LodashWrapper.prototype = baseCreate(baseLodash.prototype);
	    LodashWrapper.prototype.constructor = LodashWrapper;
	    function LazyWrapper(value) {
	      this.__wrapped__ = value;
	      this.__actions__ = [];
	      this.__dir__ = 1;
	      this.__filtered__ = false;
	      this.__iteratees__ = [];
	      this.__takeCount__ = MAX_ARRAY_LENGTH;
	      this.__views__ = [];
	    }
	    function lazyClone() {
	      var result = new LazyWrapper(this.__wrapped__);
	      result.__actions__ = copyArray(this.__actions__);
	      result.__dir__ = this.__dir__;
	      result.__filtered__ = this.__filtered__;
	      result.__iteratees__ = copyArray(this.__iteratees__);
	      result.__takeCount__ = this.__takeCount__;
	      result.__views__ = copyArray(this.__views__);
	      return result;
	    }
	    function lazyReverse() {
	      if (this.__filtered__) {
	        var result = new LazyWrapper(this);
	        result.__dir__ = -1;
	        result.__filtered__ = true;
	      } else {
	        result = this.clone();
	        result.__dir__ *= -1;
	      }
	      return result;
	    }
	    function lazyValue() {
	      var array = this.__wrapped__.value(),
	          dir = this.__dir__,
	          isArr = isArray(array),
	          isRight = dir < 0,
	          arrLength = isArr ? array.length : 0,
	          view = getView(0, arrLength, this.__views__),
	          start = view.start,
	          end = view.end,
	          length = end - start,
	          index = isRight ? end : (start - 1),
	          iteratees = this.__iteratees__,
	          iterLength = iteratees.length,
	          resIndex = 0,
	          takeCount = nativeMin(length, this.__takeCount__);
	      if (!isArr || (!isRight && arrLength == length && takeCount == length)) {
	        return baseWrapperValue(array, this.__actions__);
	      }
	      var result = [];
	      outer:
	      while (length-- && resIndex < takeCount) {
	        index += dir;
	        var iterIndex = -1,
	            value = array[index];
	        while (++iterIndex < iterLength) {
	          var data = iteratees[iterIndex],
	              iteratee = data.iteratee,
	              type = data.type,
	              computed = iteratee(value);
	          if (type == LAZY_MAP_FLAG) {
	            value = computed;
	          } else if (!computed) {
	            if (type == LAZY_FILTER_FLAG) {
	              continue outer;
	            } else {
	              break outer;
	            }
	          }
	        }
	        result[resIndex++] = value;
	      }
	      return result;
	    }
	    LazyWrapper.prototype = baseCreate(baseLodash.prototype);
	    LazyWrapper.prototype.constructor = LazyWrapper;
	    function Hash(entries) {
	      var index = -1,
	          length = entries == null ? 0 : entries.length;
	      this.clear();
	      while (++index < length) {
	        var entry = entries[index];
	        this.set(entry[0], entry[1]);
	      }
	    }
	    function hashClear() {
	      this.__data__ = nativeCreate ? nativeCreate(null) : {};
	      this.size = 0;
	    }
	    function hashDelete(key) {
	      var result = this.has(key) && delete this.__data__[key];
	      this.size -= result ? 1 : 0;
	      return result;
	    }
	    function hashGet(key) {
	      var data = this.__data__;
	      if (nativeCreate) {
	        var result = data[key];
	        return result === HASH_UNDEFINED ? undefined$1 : result;
	      }
	      return hasOwnProperty.call(data, key) ? data[key] : undefined$1;
	    }
	    function hashHas(key) {
	      var data = this.__data__;
	      return nativeCreate ? (data[key] !== undefined$1) : hasOwnProperty.call(data, key);
	    }
	    function hashSet(key, value) {
	      var data = this.__data__;
	      this.size += this.has(key) ? 0 : 1;
	      data[key] = (nativeCreate && value === undefined$1) ? HASH_UNDEFINED : value;
	      return this;
	    }
	    Hash.prototype.clear = hashClear;
	    Hash.prototype['delete'] = hashDelete;
	    Hash.prototype.get = hashGet;
	    Hash.prototype.has = hashHas;
	    Hash.prototype.set = hashSet;
	    function ListCache(entries) {
	      var index = -1,
	          length = entries == null ? 0 : entries.length;
	      this.clear();
	      while (++index < length) {
	        var entry = entries[index];
	        this.set(entry[0], entry[1]);
	      }
	    }
	    function listCacheClear() {
	      this.__data__ = [];
	      this.size = 0;
	    }
	    function listCacheDelete(key) {
	      var data = this.__data__,
	          index = assocIndexOf(data, key);
	      if (index < 0) {
	        return false;
	      }
	      var lastIndex = data.length - 1;
	      if (index == lastIndex) {
	        data.pop();
	      } else {
	        splice.call(data, index, 1);
	      }
	      --this.size;
	      return true;
	    }
	    function listCacheGet(key) {
	      var data = this.__data__,
	          index = assocIndexOf(data, key);
	      return index < 0 ? undefined$1 : data[index][1];
	    }
	    function listCacheHas(key) {
	      return assocIndexOf(this.__data__, key) > -1;
	    }
	    function listCacheSet(key, value) {
	      var data = this.__data__,
	          index = assocIndexOf(data, key);
	      if (index < 0) {
	        ++this.size;
	        data.push([key, value]);
	      } else {
	        data[index][1] = value;
	      }
	      return this;
	    }
	    ListCache.prototype.clear = listCacheClear;
	    ListCache.prototype['delete'] = listCacheDelete;
	    ListCache.prototype.get = listCacheGet;
	    ListCache.prototype.has = listCacheHas;
	    ListCache.prototype.set = listCacheSet;
	    function MapCache(entries) {
	      var index = -1,
	          length = entries == null ? 0 : entries.length;
	      this.clear();
	      while (++index < length) {
	        var entry = entries[index];
	        this.set(entry[0], entry[1]);
	      }
	    }
	    function mapCacheClear() {
	      this.size = 0;
	      this.__data__ = {
	        'hash': new Hash,
	        'map': new (Map || ListCache),
	        'string': new Hash
	      };
	    }
	    function mapCacheDelete(key) {
	      var result = getMapData(this, key)['delete'](key);
	      this.size -= result ? 1 : 0;
	      return result;
	    }
	    function mapCacheGet(key) {
	      return getMapData(this, key).get(key);
	    }
	    function mapCacheHas(key) {
	      return getMapData(this, key).has(key);
	    }
	    function mapCacheSet(key, value) {
	      var data = getMapData(this, key),
	          size = data.size;
	      data.set(key, value);
	      this.size += data.size == size ? 0 : 1;
	      return this;
	    }
	    MapCache.prototype.clear = mapCacheClear;
	    MapCache.prototype['delete'] = mapCacheDelete;
	    MapCache.prototype.get = mapCacheGet;
	    MapCache.prototype.has = mapCacheHas;
	    MapCache.prototype.set = mapCacheSet;
	    function SetCache(values) {
	      var index = -1,
	          length = values == null ? 0 : values.length;
	      this.__data__ = new MapCache;
	      while (++index < length) {
	        this.add(values[index]);
	      }
	    }
	    function setCacheAdd(value) {
	      this.__data__.set(value, HASH_UNDEFINED);
	      return this;
	    }
	    function setCacheHas(value) {
	      return this.__data__.has(value);
	    }
	    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
	    SetCache.prototype.has = setCacheHas;
	    function Stack(entries) {
	      var data = this.__data__ = new ListCache(entries);
	      this.size = data.size;
	    }
	    function stackClear() {
	      this.__data__ = new ListCache;
	      this.size = 0;
	    }
	    function stackDelete(key) {
	      var data = this.__data__,
	          result = data['delete'](key);
	      this.size = data.size;
	      return result;
	    }
	    function stackGet(key) {
	      return this.__data__.get(key);
	    }
	    function stackHas(key) {
	      return this.__data__.has(key);
	    }
	    function stackSet(key, value) {
	      var data = this.__data__;
	      if (data instanceof ListCache) {
	        var pairs = data.__data__;
	        if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
	          pairs.push([key, value]);
	          this.size = ++data.size;
	          return this;
	        }
	        data = this.__data__ = new MapCache(pairs);
	      }
	      data.set(key, value);
	      this.size = data.size;
	      return this;
	    }
	    Stack.prototype.clear = stackClear;
	    Stack.prototype['delete'] = stackDelete;
	    Stack.prototype.get = stackGet;
	    Stack.prototype.has = stackHas;
	    Stack.prototype.set = stackSet;
	    function arrayLikeKeys(value, inherited) {
	      var isArr = isArray(value),
	          isArg = !isArr && isArguments(value),
	          isBuff = !isArr && !isArg && isBuffer(value),
	          isType = !isArr && !isArg && !isBuff && isTypedArray(value),
	          skipIndexes = isArr || isArg || isBuff || isType,
	          result = skipIndexes ? baseTimes(value.length, String) : [],
	          length = result.length;
	      for (var key in value) {
	        if ((inherited || hasOwnProperty.call(value, key)) &&
	            !(skipIndexes && (
	               key == 'length' ||
	               (isBuff && (key == 'offset' || key == 'parent')) ||
	               (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
	               isIndex(key, length)
	            ))) {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	    function arraySample(array) {
	      var length = array.length;
	      return length ? array[baseRandom(0, length - 1)] : undefined$1;
	    }
	    function arraySampleSize(array, n) {
	      return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
	    }
	    function arrayShuffle(array) {
	      return shuffleSelf(copyArray(array));
	    }
	    function assignMergeValue(object, key, value) {
	      if ((value !== undefined$1 && !eq(object[key], value)) ||
	          (value === undefined$1 && !(key in object))) {
	        baseAssignValue(object, key, value);
	      }
	    }
	    function assignValue(object, key, value) {
	      var objValue = object[key];
	      if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
	          (value === undefined$1 && !(key in object))) {
	        baseAssignValue(object, key, value);
	      }
	    }
	    function assocIndexOf(array, key) {
	      var length = array.length;
	      while (length--) {
	        if (eq(array[length][0], key)) {
	          return length;
	        }
	      }
	      return -1;
	    }
	    function baseAggregator(collection, setter, iteratee, accumulator) {
	      baseEach(collection, function(value, key, collection) {
	        setter(accumulator, value, iteratee(value), collection);
	      });
	      return accumulator;
	    }
	    function baseAssign(object, source) {
	      return object && copyObject(source, keys(source), object);
	    }
	    function baseAssignIn(object, source) {
	      return object && copyObject(source, keysIn(source), object);
	    }
	    function baseAssignValue(object, key, value) {
	      if (key == '__proto__' && defineProperty) {
	        defineProperty(object, key, {
	          'configurable': true,
	          'enumerable': true,
	          'value': value,
	          'writable': true
	        });
	      } else {
	        object[key] = value;
	      }
	    }
	    function baseAt(object, paths) {
	      var index = -1,
	          length = paths.length,
	          result = Array(length),
	          skip = object == null;
	      while (++index < length) {
	        result[index] = skip ? undefined$1 : get(object, paths[index]);
	      }
	      return result;
	    }
	    function baseClamp(number, lower, upper) {
	      if (number === number) {
	        if (upper !== undefined$1) {
	          number = number <= upper ? number : upper;
	        }
	        if (lower !== undefined$1) {
	          number = number >= lower ? number : lower;
	        }
	      }
	      return number;
	    }
	    function baseClone(value, bitmask, customizer, key, object, stack) {
	      var result,
	          isDeep = bitmask & CLONE_DEEP_FLAG,
	          isFlat = bitmask & CLONE_FLAT_FLAG,
	          isFull = bitmask & CLONE_SYMBOLS_FLAG;
	      if (customizer) {
	        result = object ? customizer(value, key, object, stack) : customizer(value);
	      }
	      if (result !== undefined$1) {
	        return result;
	      }
	      if (!isObject(value)) {
	        return value;
	      }
	      var isArr = isArray(value);
	      if (isArr) {
	        result = initCloneArray(value);
	        if (!isDeep) {
	          return copyArray(value, result);
	        }
	      } else {
	        var tag = getTag(value),
	            isFunc = tag == funcTag || tag == genTag;
	        if (isBuffer(value)) {
	          return cloneBuffer(value, isDeep);
	        }
	        if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
	          result = (isFlat || isFunc) ? {} : initCloneObject(value);
	          if (!isDeep) {
	            return isFlat
	              ? copySymbolsIn(value, baseAssignIn(result, value))
	              : copySymbols(value, baseAssign(result, value));
	          }
	        } else {
	          if (!cloneableTags[tag]) {
	            return object ? value : {};
	          }
	          result = initCloneByTag(value, tag, isDeep);
	        }
	      }
	      stack || (stack = new Stack);
	      var stacked = stack.get(value);
	      if (stacked) {
	        return stacked;
	      }
	      stack.set(value, result);
	      if (isSet(value)) {
	        value.forEach(function(subValue) {
	          result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
	        });
	      } else if (isMap(value)) {
	        value.forEach(function(subValue, key) {
	          result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));
	        });
	      }
	      var keysFunc = isFull
	        ? (isFlat ? getAllKeysIn : getAllKeys)
	        : (isFlat ? keysIn : keys);
	      var props = isArr ? undefined$1 : keysFunc(value);
	      arrayEach(props || value, function(subValue, key) {
	        if (props) {
	          key = subValue;
	          subValue = value[key];
	        }
	        assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
	      });
	      return result;
	    }
	    function baseConforms(source) {
	      var props = keys(source);
	      return function(object) {
	        return baseConformsTo(object, source, props);
	      };
	    }
	    function baseConformsTo(object, source, props) {
	      var length = props.length;
	      if (object == null) {
	        return !length;
	      }
	      object = Object(object);
	      while (length--) {
	        var key = props[length],
	            predicate = source[key],
	            value = object[key];
	        if ((value === undefined$1 && !(key in object)) || !predicate(value)) {
	          return false;
	        }
	      }
	      return true;
	    }
	    function baseDelay(func, wait, args) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      return setTimeout(function() { func.apply(undefined$1, args); }, wait);
	    }
	    function baseDifference(array, values, iteratee, comparator) {
	      var index = -1,
	          includes = arrayIncludes,
	          isCommon = true,
	          length = array.length,
	          result = [],
	          valuesLength = values.length;
	      if (!length) {
	        return result;
	      }
	      if (iteratee) {
	        values = arrayMap(values, baseUnary(iteratee));
	      }
	      if (comparator) {
	        includes = arrayIncludesWith;
	        isCommon = false;
	      }
	      else if (values.length >= LARGE_ARRAY_SIZE) {
	        includes = cacheHas;
	        isCommon = false;
	        values = new SetCache(values);
	      }
	      outer:
	      while (++index < length) {
	        var value = array[index],
	            computed = iteratee == null ? value : iteratee(value);
	        value = (comparator || value !== 0) ? value : 0;
	        if (isCommon && computed === computed) {
	          var valuesIndex = valuesLength;
	          while (valuesIndex--) {
	            if (values[valuesIndex] === computed) {
	              continue outer;
	            }
	          }
	          result.push(value);
	        }
	        else if (!includes(values, computed, comparator)) {
	          result.push(value);
	        }
	      }
	      return result;
	    }
	    var baseEach = createBaseEach(baseForOwn);
	    var baseEachRight = createBaseEach(baseForOwnRight, true);
	    function baseEvery(collection, predicate) {
	      var result = true;
	      baseEach(collection, function(value, index, collection) {
	        result = !!predicate(value, index, collection);
	        return result;
	      });
	      return result;
	    }
	    function baseExtremum(array, iteratee, comparator) {
	      var index = -1,
	          length = array.length;
	      while (++index < length) {
	        var value = array[index],
	            current = iteratee(value);
	        if (current != null && (computed === undefined$1
	              ? (current === current && !isSymbol(current))
	              : comparator(current, computed)
	            )) {
	          var computed = current,
	              result = value;
	        }
	      }
	      return result;
	    }
	    function baseFill(array, value, start, end) {
	      var length = array.length;
	      start = toInteger(start);
	      if (start < 0) {
	        start = -start > length ? 0 : (length + start);
	      }
	      end = (end === undefined$1 || end > length) ? length : toInteger(end);
	      if (end < 0) {
	        end += length;
	      }
	      end = start > end ? 0 : toLength(end);
	      while (start < end) {
	        array[start++] = value;
	      }
	      return array;
	    }
	    function baseFilter(collection, predicate) {
	      var result = [];
	      baseEach(collection, function(value, index, collection) {
	        if (predicate(value, index, collection)) {
	          result.push(value);
	        }
	      });
	      return result;
	    }
	    function baseFlatten(array, depth, predicate, isStrict, result) {
	      var index = -1,
	          length = array.length;
	      predicate || (predicate = isFlattenable);
	      result || (result = []);
	      while (++index < length) {
	        var value = array[index];
	        if (depth > 0 && predicate(value)) {
	          if (depth > 1) {
	            baseFlatten(value, depth - 1, predicate, isStrict, result);
	          } else {
	            arrayPush(result, value);
	          }
	        } else if (!isStrict) {
	          result[result.length] = value;
	        }
	      }
	      return result;
	    }
	    var baseFor = createBaseFor();
	    var baseForRight = createBaseFor(true);
	    function baseForOwn(object, iteratee) {
	      return object && baseFor(object, iteratee, keys);
	    }
	    function baseForOwnRight(object, iteratee) {
	      return object && baseForRight(object, iteratee, keys);
	    }
	    function baseFunctions(object, props) {
	      return arrayFilter(props, function(key) {
	        return isFunction(object[key]);
	      });
	    }
	    function baseGet(object, path) {
	      path = castPath(path, object);
	      var index = 0,
	          length = path.length;
	      while (object != null && index < length) {
	        object = object[toKey(path[index++])];
	      }
	      return (index && index == length) ? object : undefined$1;
	    }
	    function baseGetAllKeys(object, keysFunc, symbolsFunc) {
	      var result = keysFunc(object);
	      return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
	    }
	    function baseGetTag(value) {
	      if (value == null) {
	        return value === undefined$1 ? undefinedTag : nullTag;
	      }
	      return (symToStringTag && symToStringTag in Object(value))
	        ? getRawTag(value)
	        : objectToString(value);
	    }
	    function baseGt(value, other) {
	      return value > other;
	    }
	    function baseHas(object, key) {
	      return object != null && hasOwnProperty.call(object, key);
	    }
	    function baseHasIn(object, key) {
	      return object != null && key in Object(object);
	    }
	    function baseInRange(number, start, end) {
	      return number >= nativeMin(start, end) && number < nativeMax(start, end);
	    }
	    function baseIntersection(arrays, iteratee, comparator) {
	      var includes = comparator ? arrayIncludesWith : arrayIncludes,
	          length = arrays[0].length,
	          othLength = arrays.length,
	          othIndex = othLength,
	          caches = Array(othLength),
	          maxLength = Infinity,
	          result = [];
	      while (othIndex--) {
	        var array = arrays[othIndex];
	        if (othIndex && iteratee) {
	          array = arrayMap(array, baseUnary(iteratee));
	        }
	        maxLength = nativeMin(array.length, maxLength);
	        caches[othIndex] = !comparator && (iteratee || (length >= 120 && array.length >= 120))
	          ? new SetCache(othIndex && array)
	          : undefined$1;
	      }
	      array = arrays[0];
	      var index = -1,
	          seen = caches[0];
	      outer:
	      while (++index < length && result.length < maxLength) {
	        var value = array[index],
	            computed = iteratee ? iteratee(value) : value;
	        value = (comparator || value !== 0) ? value : 0;
	        if (!(seen
	              ? cacheHas(seen, computed)
	              : includes(result, computed, comparator)
	            )) {
	          othIndex = othLength;
	          while (--othIndex) {
	            var cache = caches[othIndex];
	            if (!(cache
	                  ? cacheHas(cache, computed)
	                  : includes(arrays[othIndex], computed, comparator))
	                ) {
	              continue outer;
	            }
	          }
	          if (seen) {
	            seen.push(computed);
	          }
	          result.push(value);
	        }
	      }
	      return result;
	    }
	    function baseInverter(object, setter, iteratee, accumulator) {
	      baseForOwn(object, function(value, key, object) {
	        setter(accumulator, iteratee(value), key, object);
	      });
	      return accumulator;
	    }
	    function baseInvoke(object, path, args) {
	      path = castPath(path, object);
	      object = parent(object, path);
	      var func = object == null ? object : object[toKey(last(path))];
	      return func == null ? undefined$1 : apply(func, object, args);
	    }
	    function baseIsArguments(value) {
	      return isObjectLike(value) && baseGetTag(value) == argsTag;
	    }
	    function baseIsArrayBuffer(value) {
	      return isObjectLike(value) && baseGetTag(value) == arrayBufferTag;
	    }
	    function baseIsDate(value) {
	      return isObjectLike(value) && baseGetTag(value) == dateTag;
	    }
	    function baseIsEqual(value, other, bitmask, customizer, stack) {
	      if (value === other) {
	        return true;
	      }
	      if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
	        return value !== value && other !== other;
	      }
	      return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
	    }
	    function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
	      var objIsArr = isArray(object),
	          othIsArr = isArray(other),
	          objTag = objIsArr ? arrayTag : getTag(object),
	          othTag = othIsArr ? arrayTag : getTag(other);
	      objTag = objTag == argsTag ? objectTag : objTag;
	      othTag = othTag == argsTag ? objectTag : othTag;
	      var objIsObj = objTag == objectTag,
	          othIsObj = othTag == objectTag,
	          isSameTag = objTag == othTag;
	      if (isSameTag && isBuffer(object)) {
	        if (!isBuffer(other)) {
	          return false;
	        }
	        objIsArr = true;
	        objIsObj = false;
	      }
	      if (isSameTag && !objIsObj) {
	        stack || (stack = new Stack);
	        return (objIsArr || isTypedArray(object))
	          ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
	          : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
	      }
	      if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
	        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
	            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');
	        if (objIsWrapped || othIsWrapped) {
	          var objUnwrapped = objIsWrapped ? object.value() : object,
	              othUnwrapped = othIsWrapped ? other.value() : other;
	          stack || (stack = new Stack);
	          return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
	        }
	      }
	      if (!isSameTag) {
	        return false;
	      }
	      stack || (stack = new Stack);
	      return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
	    }
	    function baseIsMap(value) {
	      return isObjectLike(value) && getTag(value) == mapTag;
	    }
	    function baseIsMatch(object, source, matchData, customizer) {
	      var index = matchData.length,
	          length = index,
	          noCustomizer = !customizer;
	      if (object == null) {
	        return !length;
	      }
	      object = Object(object);
	      while (index--) {
	        var data = matchData[index];
	        if ((noCustomizer && data[2])
	              ? data[1] !== object[data[0]]
	              : !(data[0] in object)
	            ) {
	          return false;
	        }
	      }
	      while (++index < length) {
	        data = matchData[index];
	        var key = data[0],
	            objValue = object[key],
	            srcValue = data[1];
	        if (noCustomizer && data[2]) {
	          if (objValue === undefined$1 && !(key in object)) {
	            return false;
	          }
	        } else {
	          var stack = new Stack;
	          if (customizer) {
	            var result = customizer(objValue, srcValue, key, object, source, stack);
	          }
	          if (!(result === undefined$1
	                ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
	                : result
	              )) {
	            return false;
	          }
	        }
	      }
	      return true;
	    }
	    function baseIsNative(value) {
	      if (!isObject(value) || isMasked(value)) {
	        return false;
	      }
	      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
	      return pattern.test(toSource(value));
	    }
	    function baseIsRegExp(value) {
	      return isObjectLike(value) && baseGetTag(value) == regexpTag;
	    }
	    function baseIsSet(value) {
	      return isObjectLike(value) && getTag(value) == setTag;
	    }
	    function baseIsTypedArray(value) {
	      return isObjectLike(value) &&
	        isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
	    }
	    function baseIteratee(value) {
	      if (typeof value == 'function') {
	        return value;
	      }
	      if (value == null) {
	        return identity;
	      }
	      if (typeof value == 'object') {
	        return isArray(value)
	          ? baseMatchesProperty(value[0], value[1])
	          : baseMatches(value);
	      }
	      return property(value);
	    }
	    function baseKeys(object) {
	      if (!isPrototype(object)) {
	        return nativeKeys(object);
	      }
	      var result = [];
	      for (var key in Object(object)) {
	        if (hasOwnProperty.call(object, key) && key != 'constructor') {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	    function baseKeysIn(object) {
	      if (!isObject(object)) {
	        return nativeKeysIn(object);
	      }
	      var isProto = isPrototype(object),
	          result = [];
	      for (var key in object) {
	        if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	    function baseLt(value, other) {
	      return value < other;
	    }
	    function baseMap(collection, iteratee) {
	      var index = -1,
	          result = isArrayLike(collection) ? Array(collection.length) : [];
	      baseEach(collection, function(value, key, collection) {
	        result[++index] = iteratee(value, key, collection);
	      });
	      return result;
	    }
	    function baseMatches(source) {
	      var matchData = getMatchData(source);
	      if (matchData.length == 1 && matchData[0][2]) {
	        return matchesStrictComparable(matchData[0][0], matchData[0][1]);
	      }
	      return function(object) {
	        return object === source || baseIsMatch(object, source, matchData);
	      };
	    }
	    function baseMatchesProperty(path, srcValue) {
	      if (isKey(path) && isStrictComparable(srcValue)) {
	        return matchesStrictComparable(toKey(path), srcValue);
	      }
	      return function(object) {
	        var objValue = get(object, path);
	        return (objValue === undefined$1 && objValue === srcValue)
	          ? hasIn(object, path)
	          : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
	      };
	    }
	    function baseMerge(object, source, srcIndex, customizer, stack) {
	      if (object === source) {
	        return;
	      }
	      baseFor(source, function(srcValue, key) {
	        stack || (stack = new Stack);
	        if (isObject(srcValue)) {
	          baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
	        }
	        else {
	          var newValue = customizer
	            ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
	            : undefined$1;
	          if (newValue === undefined$1) {
	            newValue = srcValue;
	          }
	          assignMergeValue(object, key, newValue);
	        }
	      }, keysIn);
	    }
	    function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
	      var objValue = safeGet(object, key),
	          srcValue = safeGet(source, key),
	          stacked = stack.get(srcValue);
	      if (stacked) {
	        assignMergeValue(object, key, stacked);
	        return;
	      }
	      var newValue = customizer
	        ? customizer(objValue, srcValue, (key + ''), object, source, stack)
	        : undefined$1;
	      var isCommon = newValue === undefined$1;
	      if (isCommon) {
	        var isArr = isArray(srcValue),
	            isBuff = !isArr && isBuffer(srcValue),
	            isTyped = !isArr && !isBuff && isTypedArray(srcValue);
	        newValue = srcValue;
	        if (isArr || isBuff || isTyped) {
	          if (isArray(objValue)) {
	            newValue = objValue;
	          }
	          else if (isArrayLikeObject(objValue)) {
	            newValue = copyArray(objValue);
	          }
	          else if (isBuff) {
	            isCommon = false;
	            newValue = cloneBuffer(srcValue, true);
	          }
	          else if (isTyped) {
	            isCommon = false;
	            newValue = cloneTypedArray(srcValue, true);
	          }
	          else {
	            newValue = [];
	          }
	        }
	        else if (isPlainObject(srcValue) || isArguments(srcValue)) {
	          newValue = objValue;
	          if (isArguments(objValue)) {
	            newValue = toPlainObject(objValue);
	          }
	          else if (!isObject(objValue) || isFunction(objValue)) {
	            newValue = initCloneObject(srcValue);
	          }
	        }
	        else {
	          isCommon = false;
	        }
	      }
	      if (isCommon) {
	        stack.set(srcValue, newValue);
	        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
	        stack['delete'](srcValue);
	      }
	      assignMergeValue(object, key, newValue);
	    }
	    function baseNth(array, n) {
	      var length = array.length;
	      if (!length) {
	        return;
	      }
	      n += n < 0 ? length : 0;
	      return isIndex(n, length) ? array[n] : undefined$1;
	    }
	    function baseOrderBy(collection, iteratees, orders) {
	      if (iteratees.length) {
	        iteratees = arrayMap(iteratees, function(iteratee) {
	          if (isArray(iteratee)) {
	            return function(value) {
	              return baseGet(value, iteratee.length === 1 ? iteratee[0] : iteratee);
	            }
	          }
	          return iteratee;
	        });
	      } else {
	        iteratees = [identity];
	      }
	      var index = -1;
	      iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
	      var result = baseMap(collection, function(value, key, collection) {
	        var criteria = arrayMap(iteratees, function(iteratee) {
	          return iteratee(value);
	        });
	        return { 'criteria': criteria, 'index': ++index, 'value': value };
	      });
	      return baseSortBy(result, function(object, other) {
	        return compareMultiple(object, other, orders);
	      });
	    }
	    function basePick(object, paths) {
	      return basePickBy(object, paths, function(value, path) {
	        return hasIn(object, path);
	      });
	    }
	    function basePickBy(object, paths, predicate) {
	      var index = -1,
	          length = paths.length,
	          result = {};
	      while (++index < length) {
	        var path = paths[index],
	            value = baseGet(object, path);
	        if (predicate(value, path)) {
	          baseSet(result, castPath(path, object), value);
	        }
	      }
	      return result;
	    }
	    function basePropertyDeep(path) {
	      return function(object) {
	        return baseGet(object, path);
	      };
	    }
	    function basePullAll(array, values, iteratee, comparator) {
	      var indexOf = comparator ? baseIndexOfWith : baseIndexOf,
	          index = -1,
	          length = values.length,
	          seen = array;
	      if (array === values) {
	        values = copyArray(values);
	      }
	      if (iteratee) {
	        seen = arrayMap(array, baseUnary(iteratee));
	      }
	      while (++index < length) {
	        var fromIndex = 0,
	            value = values[index],
	            computed = iteratee ? iteratee(value) : value;
	        while ((fromIndex = indexOf(seen, computed, fromIndex, comparator)) > -1) {
	          if (seen !== array) {
	            splice.call(seen, fromIndex, 1);
	          }
	          splice.call(array, fromIndex, 1);
	        }
	      }
	      return array;
	    }
	    function basePullAt(array, indexes) {
	      var length = array ? indexes.length : 0,
	          lastIndex = length - 1;
	      while (length--) {
	        var index = indexes[length];
	        if (length == lastIndex || index !== previous) {
	          var previous = index;
	          if (isIndex(index)) {
	            splice.call(array, index, 1);
	          } else {
	            baseUnset(array, index);
	          }
	        }
	      }
	      return array;
	    }
	    function baseRandom(lower, upper) {
	      return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
	    }
	    function baseRange(start, end, step, fromRight) {
	      var index = -1,
	          length = nativeMax(nativeCeil((end - start) / (step || 1)), 0),
	          result = Array(length);
	      while (length--) {
	        result[fromRight ? length : ++index] = start;
	        start += step;
	      }
	      return result;
	    }
	    function baseRepeat(string, n) {
	      var result = '';
	      if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
	        return result;
	      }
	      do {
	        if (n % 2) {
	          result += string;
	        }
	        n = nativeFloor(n / 2);
	        if (n) {
	          string += string;
	        }
	      } while (n);
	      return result;
	    }
	    function baseRest(func, start) {
	      return setToString(overRest(func, start, identity), func + '');
	    }
	    function baseSample(collection) {
	      return arraySample(values(collection));
	    }
	    function baseSampleSize(collection, n) {
	      var array = values(collection);
	      return shuffleSelf(array, baseClamp(n, 0, array.length));
	    }
	    function baseSet(object, path, value, customizer) {
	      if (!isObject(object)) {
	        return object;
	      }
	      path = castPath(path, object);
	      var index = -1,
	          length = path.length,
	          lastIndex = length - 1,
	          nested = object;
	      while (nested != null && ++index < length) {
	        var key = toKey(path[index]),
	            newValue = value;
	        if (key === '__proto__' || key === 'constructor' || key === 'prototype') {
	          return object;
	        }
	        if (index != lastIndex) {
	          var objValue = nested[key];
	          newValue = customizer ? customizer(objValue, key, nested) : undefined$1;
	          if (newValue === undefined$1) {
	            newValue = isObject(objValue)
	              ? objValue
	              : (isIndex(path[index + 1]) ? [] : {});
	          }
	        }
	        assignValue(nested, key, newValue);
	        nested = nested[key];
	      }
	      return object;
	    }
	    var baseSetData = !metaMap ? identity : function(func, data) {
	      metaMap.set(func, data);
	      return func;
	    };
	    var baseSetToString = !defineProperty ? identity : function(func, string) {
	      return defineProperty(func, 'toString', {
	        'configurable': true,
	        'enumerable': false,
	        'value': constant(string),
	        'writable': true
	      });
	    };
	    function baseShuffle(collection) {
	      return shuffleSelf(values(collection));
	    }
	    function baseSlice(array, start, end) {
	      var index = -1,
	          length = array.length;
	      if (start < 0) {
	        start = -start > length ? 0 : (length + start);
	      }
	      end = end > length ? length : end;
	      if (end < 0) {
	        end += length;
	      }
	      length = start > end ? 0 : ((end - start) >>> 0);
	      start >>>= 0;
	      var result = Array(length);
	      while (++index < length) {
	        result[index] = array[index + start];
	      }
	      return result;
	    }
	    function baseSome(collection, predicate) {
	      var result;
	      baseEach(collection, function(value, index, collection) {
	        result = predicate(value, index, collection);
	        return !result;
	      });
	      return !!result;
	    }
	    function baseSortedIndex(array, value, retHighest) {
	      var low = 0,
	          high = array == null ? low : array.length;
	      if (typeof value == 'number' && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
	        while (low < high) {
	          var mid = (low + high) >>> 1,
	              computed = array[mid];
	          if (computed !== null && !isSymbol(computed) &&
	              (retHighest ? (computed <= value) : (computed < value))) {
	            low = mid + 1;
	          } else {
	            high = mid;
	          }
	        }
	        return high;
	      }
	      return baseSortedIndexBy(array, value, identity, retHighest);
	    }
	    function baseSortedIndexBy(array, value, iteratee, retHighest) {
	      var low = 0,
	          high = array == null ? 0 : array.length;
	      if (high === 0) {
	        return 0;
	      }
	      value = iteratee(value);
	      var valIsNaN = value !== value,
	          valIsNull = value === null,
	          valIsSymbol = isSymbol(value),
	          valIsUndefined = value === undefined$1;
	      while (low < high) {
	        var mid = nativeFloor((low + high) / 2),
	            computed = iteratee(array[mid]),
	            othIsDefined = computed !== undefined$1,
	            othIsNull = computed === null,
	            othIsReflexive = computed === computed,
	            othIsSymbol = isSymbol(computed);
	        if (valIsNaN) {
	          var setLow = retHighest || othIsReflexive;
	        } else if (valIsUndefined) {
	          setLow = othIsReflexive && (retHighest || othIsDefined);
	        } else if (valIsNull) {
	          setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
	        } else if (valIsSymbol) {
	          setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
	        } else if (othIsNull || othIsSymbol) {
	          setLow = false;
	        } else {
	          setLow = retHighest ? (computed <= value) : (computed < value);
	        }
	        if (setLow) {
	          low = mid + 1;
	        } else {
	          high = mid;
	        }
	      }
	      return nativeMin(high, MAX_ARRAY_INDEX);
	    }
	    function baseSortedUniq(array, iteratee) {
	      var index = -1,
	          length = array.length,
	          resIndex = 0,
	          result = [];
	      while (++index < length) {
	        var value = array[index],
	            computed = iteratee ? iteratee(value) : value;
	        if (!index || !eq(computed, seen)) {
	          var seen = computed;
	          result[resIndex++] = value === 0 ? 0 : value;
	        }
	      }
	      return result;
	    }
	    function baseToNumber(value) {
	      if (typeof value == 'number') {
	        return value;
	      }
	      if (isSymbol(value)) {
	        return NAN;
	      }
	      return +value;
	    }
	    function baseToString(value) {
	      if (typeof value == 'string') {
	        return value;
	      }
	      if (isArray(value)) {
	        return arrayMap(value, baseToString) + '';
	      }
	      if (isSymbol(value)) {
	        return symbolToString ? symbolToString.call(value) : '';
	      }
	      var result = (value + '');
	      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	    }
	    function baseUniq(array, iteratee, comparator) {
	      var index = -1,
	          includes = arrayIncludes,
	          length = array.length,
	          isCommon = true,
	          result = [],
	          seen = result;
	      if (comparator) {
	        isCommon = false;
	        includes = arrayIncludesWith;
	      }
	      else if (length >= LARGE_ARRAY_SIZE) {
	        var set = iteratee ? null : createSet(array);
	        if (set) {
	          return setToArray(set);
	        }
	        isCommon = false;
	        includes = cacheHas;
	        seen = new SetCache;
	      }
	      else {
	        seen = iteratee ? [] : result;
	      }
	      outer:
	      while (++index < length) {
	        var value = array[index],
	            computed = iteratee ? iteratee(value) : value;
	        value = (comparator || value !== 0) ? value : 0;
	        if (isCommon && computed === computed) {
	          var seenIndex = seen.length;
	          while (seenIndex--) {
	            if (seen[seenIndex] === computed) {
	              continue outer;
	            }
	          }
	          if (iteratee) {
	            seen.push(computed);
	          }
	          result.push(value);
	        }
	        else if (!includes(seen, computed, comparator)) {
	          if (seen !== result) {
	            seen.push(computed);
	          }
	          result.push(value);
	        }
	      }
	      return result;
	    }
	    function baseUnset(object, path) {
	      path = castPath(path, object);
	      object = parent(object, path);
	      return object == null || delete object[toKey(last(path))];
	    }
	    function baseUpdate(object, path, updater, customizer) {
	      return baseSet(object, path, updater(baseGet(object, path)), customizer);
	    }
	    function baseWhile(array, predicate, isDrop, fromRight) {
	      var length = array.length,
	          index = fromRight ? length : -1;
	      while ((fromRight ? index-- : ++index < length) &&
	        predicate(array[index], index, array)) {}
	      return isDrop
	        ? baseSlice(array, (fromRight ? 0 : index), (fromRight ? index + 1 : length))
	        : baseSlice(array, (fromRight ? index + 1 : 0), (fromRight ? length : index));
	    }
	    function baseWrapperValue(value, actions) {
	      var result = value;
	      if (result instanceof LazyWrapper) {
	        result = result.value();
	      }
	      return arrayReduce(actions, function(result, action) {
	        return action.func.apply(action.thisArg, arrayPush([result], action.args));
	      }, result);
	    }
	    function baseXor(arrays, iteratee, comparator) {
	      var length = arrays.length;
	      if (length < 2) {
	        return length ? baseUniq(arrays[0]) : [];
	      }
	      var index = -1,
	          result = Array(length);
	      while (++index < length) {
	        var array = arrays[index],
	            othIndex = -1;
	        while (++othIndex < length) {
	          if (othIndex != index) {
	            result[index] = baseDifference(result[index] || array, arrays[othIndex], iteratee, comparator);
	          }
	        }
	      }
	      return baseUniq(baseFlatten(result, 1), iteratee, comparator);
	    }
	    function baseZipObject(props, values, assignFunc) {
	      var index = -1,
	          length = props.length,
	          valsLength = values.length,
	          result = {};
	      while (++index < length) {
	        var value = index < valsLength ? values[index] : undefined$1;
	        assignFunc(result, props[index], value);
	      }
	      return result;
	    }
	    function castArrayLikeObject(value) {
	      return isArrayLikeObject(value) ? value : [];
	    }
	    function castFunction(value) {
	      return typeof value == 'function' ? value : identity;
	    }
	    function castPath(value, object) {
	      if (isArray(value)) {
	        return value;
	      }
	      return isKey(value, object) ? [value] : stringToPath(toString(value));
	    }
	    var castRest = baseRest;
	    function castSlice(array, start, end) {
	      var length = array.length;
	      end = end === undefined$1 ? length : end;
	      return (!start && end >= length) ? array : baseSlice(array, start, end);
	    }
	    var clearTimeout = ctxClearTimeout || function(id) {
	      return root.clearTimeout(id);
	    };
	    function cloneBuffer(buffer, isDeep) {
	      if (isDeep) {
	        return buffer.slice();
	      }
	      var length = buffer.length,
	          result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
	      buffer.copy(result);
	      return result;
	    }
	    function cloneArrayBuffer(arrayBuffer) {
	      var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
	      new Uint8Array(result).set(new Uint8Array(arrayBuffer));
	      return result;
	    }
	    function cloneDataView(dataView, isDeep) {
	      var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
	      return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
	    }
	    function cloneRegExp(regexp) {
	      var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
	      result.lastIndex = regexp.lastIndex;
	      return result;
	    }
	    function cloneSymbol(symbol) {
	      return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
	    }
	    function cloneTypedArray(typedArray, isDeep) {
	      var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
	      return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
	    }
	    function compareAscending(value, other) {
	      if (value !== other) {
	        var valIsDefined = value !== undefined$1,
	            valIsNull = value === null,
	            valIsReflexive = value === value,
	            valIsSymbol = isSymbol(value);
	        var othIsDefined = other !== undefined$1,
	            othIsNull = other === null,
	            othIsReflexive = other === other,
	            othIsSymbol = isSymbol(other);
	        if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
	            (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
	            (valIsNull && othIsDefined && othIsReflexive) ||
	            (!valIsDefined && othIsReflexive) ||
	            !valIsReflexive) {
	          return 1;
	        }
	        if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
	            (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
	            (othIsNull && valIsDefined && valIsReflexive) ||
	            (!othIsDefined && valIsReflexive) ||
	            !othIsReflexive) {
	          return -1;
	        }
	      }
	      return 0;
	    }
	    function compareMultiple(object, other, orders) {
	      var index = -1,
	          objCriteria = object.criteria,
	          othCriteria = other.criteria,
	          length = objCriteria.length,
	          ordersLength = orders.length;
	      while (++index < length) {
	        var result = compareAscending(objCriteria[index], othCriteria[index]);
	        if (result) {
	          if (index >= ordersLength) {
	            return result;
	          }
	          var order = orders[index];
	          return result * (order == 'desc' ? -1 : 1);
	        }
	      }
	      return object.index - other.index;
	    }
	    function composeArgs(args, partials, holders, isCurried) {
	      var argsIndex = -1,
	          argsLength = args.length,
	          holdersLength = holders.length,
	          leftIndex = -1,
	          leftLength = partials.length,
	          rangeLength = nativeMax(argsLength - holdersLength, 0),
	          result = Array(leftLength + rangeLength),
	          isUncurried = !isCurried;
	      while (++leftIndex < leftLength) {
	        result[leftIndex] = partials[leftIndex];
	      }
	      while (++argsIndex < holdersLength) {
	        if (isUncurried || argsIndex < argsLength) {
	          result[holders[argsIndex]] = args[argsIndex];
	        }
	      }
	      while (rangeLength--) {
	        result[leftIndex++] = args[argsIndex++];
	      }
	      return result;
	    }
	    function composeArgsRight(args, partials, holders, isCurried) {
	      var argsIndex = -1,
	          argsLength = args.length,
	          holdersIndex = -1,
	          holdersLength = holders.length,
	          rightIndex = -1,
	          rightLength = partials.length,
	          rangeLength = nativeMax(argsLength - holdersLength, 0),
	          result = Array(rangeLength + rightLength),
	          isUncurried = !isCurried;
	      while (++argsIndex < rangeLength) {
	        result[argsIndex] = args[argsIndex];
	      }
	      var offset = argsIndex;
	      while (++rightIndex < rightLength) {
	        result[offset + rightIndex] = partials[rightIndex];
	      }
	      while (++holdersIndex < holdersLength) {
	        if (isUncurried || argsIndex < argsLength) {
	          result[offset + holders[holdersIndex]] = args[argsIndex++];
	        }
	      }
	      return result;
	    }
	    function copyArray(source, array) {
	      var index = -1,
	          length = source.length;
	      array || (array = Array(length));
	      while (++index < length) {
	        array[index] = source[index];
	      }
	      return array;
	    }
	    function copyObject(source, props, object, customizer) {
	      var isNew = !object;
	      object || (object = {});
	      var index = -1,
	          length = props.length;
	      while (++index < length) {
	        var key = props[index];
	        var newValue = customizer
	          ? customizer(object[key], source[key], key, object, source)
	          : undefined$1;
	        if (newValue === undefined$1) {
	          newValue = source[key];
	        }
	        if (isNew) {
	          baseAssignValue(object, key, newValue);
	        } else {
	          assignValue(object, key, newValue);
	        }
	      }
	      return object;
	    }
	    function copySymbols(source, object) {
	      return copyObject(source, getSymbols(source), object);
	    }
	    function copySymbolsIn(source, object) {
	      return copyObject(source, getSymbolsIn(source), object);
	    }
	    function createAggregator(setter, initializer) {
	      return function(collection, iteratee) {
	        var func = isArray(collection) ? arrayAggregator : baseAggregator,
	            accumulator = initializer ? initializer() : {};
	        return func(collection, setter, getIteratee(iteratee, 2), accumulator);
	      };
	    }
	    function createAssigner(assigner) {
	      return baseRest(function(object, sources) {
	        var index = -1,
	            length = sources.length,
	            customizer = length > 1 ? sources[length - 1] : undefined$1,
	            guard = length > 2 ? sources[2] : undefined$1;
	        customizer = (assigner.length > 3 && typeof customizer == 'function')
	          ? (length--, customizer)
	          : undefined$1;
	        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
	          customizer = length < 3 ? undefined$1 : customizer;
	          length = 1;
	        }
	        object = Object(object);
	        while (++index < length) {
	          var source = sources[index];
	          if (source) {
	            assigner(object, source, index, customizer);
	          }
	        }
	        return object;
	      });
	    }
	    function createBaseEach(eachFunc, fromRight) {
	      return function(collection, iteratee) {
	        if (collection == null) {
	          return collection;
	        }
	        if (!isArrayLike(collection)) {
	          return eachFunc(collection, iteratee);
	        }
	        var length = collection.length,
	            index = fromRight ? length : -1,
	            iterable = Object(collection);
	        while ((fromRight ? index-- : ++index < length)) {
	          if (iteratee(iterable[index], index, iterable) === false) {
	            break;
	          }
	        }
	        return collection;
	      };
	    }
	    function createBaseFor(fromRight) {
	      return function(object, iteratee, keysFunc) {
	        var index = -1,
	            iterable = Object(object),
	            props = keysFunc(object),
	            length = props.length;
	        while (length--) {
	          var key = props[fromRight ? length : ++index];
	          if (iteratee(iterable[key], key, iterable) === false) {
	            break;
	          }
	        }
	        return object;
	      };
	    }
	    function createBind(func, bitmask, thisArg) {
	      var isBind = bitmask & WRAP_BIND_FLAG,
	          Ctor = createCtor(func);
	      function wrapper() {
	        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
	        return fn.apply(isBind ? thisArg : this, arguments);
	      }
	      return wrapper;
	    }
	    function createCaseFirst(methodName) {
	      return function(string) {
	        string = toString(string);
	        var strSymbols = hasUnicode(string)
	          ? stringToArray(string)
	          : undefined$1;
	        var chr = strSymbols
	          ? strSymbols[0]
	          : string.charAt(0);
	        var trailing = strSymbols
	          ? castSlice(strSymbols, 1).join('')
	          : string.slice(1);
	        return chr[methodName]() + trailing;
	      };
	    }
	    function createCompounder(callback) {
	      return function(string) {
	        return arrayReduce(words(deburr(string).replace(reApos, '')), callback, '');
	      };
	    }
	    function createCtor(Ctor) {
	      return function() {
	        var args = arguments;
	        switch (args.length) {
	          case 0: return new Ctor;
	          case 1: return new Ctor(args[0]);
	          case 2: return new Ctor(args[0], args[1]);
	          case 3: return new Ctor(args[0], args[1], args[2]);
	          case 4: return new Ctor(args[0], args[1], args[2], args[3]);
	          case 5: return new Ctor(args[0], args[1], args[2], args[3], args[4]);
	          case 6: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
	          case 7: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
	        }
	        var thisBinding = baseCreate(Ctor.prototype),
	            result = Ctor.apply(thisBinding, args);
	        return isObject(result) ? result : thisBinding;
	      };
	    }
	    function createCurry(func, bitmask, arity) {
	      var Ctor = createCtor(func);
	      function wrapper() {
	        var length = arguments.length,
	            args = Array(length),
	            index = length,
	            placeholder = getHolder(wrapper);
	        while (index--) {
	          args[index] = arguments[index];
	        }
	        var holders = (length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder)
	          ? []
	          : replaceHolders(args, placeholder);
	        length -= holders.length;
	        if (length < arity) {
	          return createRecurry(
	            func, bitmask, createHybrid, wrapper.placeholder, undefined$1,
	            args, holders, undefined$1, undefined$1, arity - length);
	        }
	        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
	        return apply(fn, this, args);
	      }
	      return wrapper;
	    }
	    function createFind(findIndexFunc) {
	      return function(collection, predicate, fromIndex) {
	        var iterable = Object(collection);
	        if (!isArrayLike(collection)) {
	          var iteratee = getIteratee(predicate, 3);
	          collection = keys(collection);
	          predicate = function(key) { return iteratee(iterable[key], key, iterable); };
	        }
	        var index = findIndexFunc(collection, predicate, fromIndex);
	        return index > -1 ? iterable[iteratee ? collection[index] : index] : undefined$1;
	      };
	    }
	    function createFlow(fromRight) {
	      return flatRest(function(funcs) {
	        var length = funcs.length,
	            index = length,
	            prereq = LodashWrapper.prototype.thru;
	        if (fromRight) {
	          funcs.reverse();
	        }
	        while (index--) {
	          var func = funcs[index];
	          if (typeof func != 'function') {
	            throw new TypeError(FUNC_ERROR_TEXT);
	          }
	          if (prereq && !wrapper && getFuncName(func) == 'wrapper') {
	            var wrapper = new LodashWrapper([], true);
	          }
	        }
	        index = wrapper ? index : length;
	        while (++index < length) {
	          func = funcs[index];
	          var funcName = getFuncName(func),
	              data = funcName == 'wrapper' ? getData(func) : undefined$1;
	          if (data && isLaziable(data[0]) &&
	                data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) &&
	                !data[4].length && data[9] == 1
	              ) {
	            wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
	          } else {
	            wrapper = (func.length == 1 && isLaziable(func))
	              ? wrapper[funcName]()
	              : wrapper.thru(func);
	          }
	        }
	        return function() {
	          var args = arguments,
	              value = args[0];
	          if (wrapper && args.length == 1 && isArray(value)) {
	            return wrapper.plant(value).value();
	          }
	          var index = 0,
	              result = length ? funcs[index].apply(this, args) : value;
	          while (++index < length) {
	            result = funcs[index].call(this, result);
	          }
	          return result;
	        };
	      });
	    }
	    function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
	      var isAry = bitmask & WRAP_ARY_FLAG,
	          isBind = bitmask & WRAP_BIND_FLAG,
	          isBindKey = bitmask & WRAP_BIND_KEY_FLAG,
	          isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG),
	          isFlip = bitmask & WRAP_FLIP_FLAG,
	          Ctor = isBindKey ? undefined$1 : createCtor(func);
	      function wrapper() {
	        var length = arguments.length,
	            args = Array(length),
	            index = length;
	        while (index--) {
	          args[index] = arguments[index];
	        }
	        if (isCurried) {
	          var placeholder = getHolder(wrapper),
	              holdersCount = countHolders(args, placeholder);
	        }
	        if (partials) {
	          args = composeArgs(args, partials, holders, isCurried);
	        }
	        if (partialsRight) {
	          args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
	        }
	        length -= holdersCount;
	        if (isCurried && length < arity) {
	          var newHolders = replaceHolders(args, placeholder);
	          return createRecurry(
	            func, bitmask, createHybrid, wrapper.placeholder, thisArg,
	            args, newHolders, argPos, ary, arity - length
	          );
	        }
	        var thisBinding = isBind ? thisArg : this,
	            fn = isBindKey ? thisBinding[func] : func;
	        length = args.length;
	        if (argPos) {
	          args = reorder(args, argPos);
	        } else if (isFlip && length > 1) {
	          args.reverse();
	        }
	        if (isAry && ary < length) {
	          args.length = ary;
	        }
	        if (this && this !== root && this instanceof wrapper) {
	          fn = Ctor || createCtor(fn);
	        }
	        return fn.apply(thisBinding, args);
	      }
	      return wrapper;
	    }
	    function createInverter(setter, toIteratee) {
	      return function(object, iteratee) {
	        return baseInverter(object, setter, toIteratee(iteratee), {});
	      };
	    }
	    function createMathOperation(operator, defaultValue) {
	      return function(value, other) {
	        var result;
	        if (value === undefined$1 && other === undefined$1) {
	          return defaultValue;
	        }
	        if (value !== undefined$1) {
	          result = value;
	        }
	        if (other !== undefined$1) {
	          if (result === undefined$1) {
	            return other;
	          }
	          if (typeof value == 'string' || typeof other == 'string') {
	            value = baseToString(value);
	            other = baseToString(other);
	          } else {
	            value = baseToNumber(value);
	            other = baseToNumber(other);
	          }
	          result = operator(value, other);
	        }
	        return result;
	      };
	    }
	    function createOver(arrayFunc) {
	      return flatRest(function(iteratees) {
	        iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
	        return baseRest(function(args) {
	          var thisArg = this;
	          return arrayFunc(iteratees, function(iteratee) {
	            return apply(iteratee, thisArg, args);
	          });
	        });
	      });
	    }
	    function createPadding(length, chars) {
	      chars = chars === undefined$1 ? ' ' : baseToString(chars);
	      var charsLength = chars.length;
	      if (charsLength < 2) {
	        return charsLength ? baseRepeat(chars, length) : chars;
	      }
	      var result = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
	      return hasUnicode(chars)
	        ? castSlice(stringToArray(result), 0, length).join('')
	        : result.slice(0, length);
	    }
	    function createPartial(func, bitmask, thisArg, partials) {
	      var isBind = bitmask & WRAP_BIND_FLAG,
	          Ctor = createCtor(func);
	      function wrapper() {
	        var argsIndex = -1,
	            argsLength = arguments.length,
	            leftIndex = -1,
	            leftLength = partials.length,
	            args = Array(leftLength + argsLength),
	            fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
	        while (++leftIndex < leftLength) {
	          args[leftIndex] = partials[leftIndex];
	        }
	        while (argsLength--) {
	          args[leftIndex++] = arguments[++argsIndex];
	        }
	        return apply(fn, isBind ? thisArg : this, args);
	      }
	      return wrapper;
	    }
	    function createRange(fromRight) {
	      return function(start, end, step) {
	        if (step && typeof step != 'number' && isIterateeCall(start, end, step)) {
	          end = step = undefined$1;
	        }
	        start = toFinite(start);
	        if (end === undefined$1) {
	          end = start;
	          start = 0;
	        } else {
	          end = toFinite(end);
	        }
	        step = step === undefined$1 ? (start < end ? 1 : -1) : toFinite(step);
	        return baseRange(start, end, step, fromRight);
	      };
	    }
	    function createRelationalOperation(operator) {
	      return function(value, other) {
	        if (!(typeof value == 'string' && typeof other == 'string')) {
	          value = toNumber(value);
	          other = toNumber(other);
	        }
	        return operator(value, other);
	      };
	    }
	    function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary, arity) {
	      var isCurry = bitmask & WRAP_CURRY_FLAG,
	          newHolders = isCurry ? holders : undefined$1,
	          newHoldersRight = isCurry ? undefined$1 : holders,
	          newPartials = isCurry ? partials : undefined$1,
	          newPartialsRight = isCurry ? undefined$1 : partials;
	      bitmask |= (isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG);
	      bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
	      if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
	        bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
	      }
	      var newData = [
	        func, bitmask, thisArg, newPartials, newHolders, newPartialsRight,
	        newHoldersRight, argPos, ary, arity
	      ];
	      var result = wrapFunc.apply(undefined$1, newData);
	      if (isLaziable(func)) {
	        setData(result, newData);
	      }
	      result.placeholder = placeholder;
	      return setWrapToString(result, func, bitmask);
	    }
	    function createRound(methodName) {
	      var func = Math[methodName];
	      return function(number, precision) {
	        number = toNumber(number);
	        precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
	        if (precision && nativeIsFinite(number)) {
	          var pair = (toString(number) + 'e').split('e'),
	              value = func(pair[0] + 'e' + (+pair[1] + precision));
	          pair = (toString(value) + 'e').split('e');
	          return +(pair[0] + 'e' + (+pair[1] - precision));
	        }
	        return func(number);
	      };
	    }
	    var createSet = !(Set && (1 / setToArray(new Set([,-0]))[1]) == INFINITY) ? noop : function(values) {
	      return new Set(values);
	    };
	    function createToPairs(keysFunc) {
	      return function(object) {
	        var tag = getTag(object);
	        if (tag == mapTag) {
	          return mapToArray(object);
	        }
	        if (tag == setTag) {
	          return setToPairs(object);
	        }
	        return baseToPairs(object, keysFunc(object));
	      };
	    }
	    function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
	      var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
	      if (!isBindKey && typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      var length = partials ? partials.length : 0;
	      if (!length) {
	        bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
	        partials = holders = undefined$1;
	      }
	      ary = ary === undefined$1 ? ary : nativeMax(toInteger(ary), 0);
	      arity = arity === undefined$1 ? arity : toInteger(arity);
	      length -= holders ? holders.length : 0;
	      if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
	        var partialsRight = partials,
	            holdersRight = holders;
	        partials = holders = undefined$1;
	      }
	      var data = isBindKey ? undefined$1 : getData(func);
	      var newData = [
	        func, bitmask, thisArg, partials, holders, partialsRight, holdersRight,
	        argPos, ary, arity
	      ];
	      if (data) {
	        mergeData(newData, data);
	      }
	      func = newData[0];
	      bitmask = newData[1];
	      thisArg = newData[2];
	      partials = newData[3];
	      holders = newData[4];
	      arity = newData[9] = newData[9] === undefined$1
	        ? (isBindKey ? 0 : func.length)
	        : nativeMax(newData[9] - length, 0);
	      if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
	        bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
	      }
	      if (!bitmask || bitmask == WRAP_BIND_FLAG) {
	        var result = createBind(func, bitmask, thisArg);
	      } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
	        result = createCurry(func, bitmask, arity);
	      } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
	        result = createPartial(func, bitmask, thisArg, partials);
	      } else {
	        result = createHybrid.apply(undefined$1, newData);
	      }
	      var setter = data ? baseSetData : setData;
	      return setWrapToString(setter(result, newData), func, bitmask);
	    }
	    function customDefaultsAssignIn(objValue, srcValue, key, object) {
	      if (objValue === undefined$1 ||
	          (eq(objValue, objectProto[key]) && !hasOwnProperty.call(object, key))) {
	        return srcValue;
	      }
	      return objValue;
	    }
	    function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
	      if (isObject(objValue) && isObject(srcValue)) {
	        stack.set(srcValue, objValue);
	        baseMerge(objValue, srcValue, undefined$1, customDefaultsMerge, stack);
	        stack['delete'](srcValue);
	      }
	      return objValue;
	    }
	    function customOmitClone(value) {
	      return isPlainObject(value) ? undefined$1 : value;
	    }
	    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
	      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
	          arrLength = array.length,
	          othLength = other.length;
	      if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
	        return false;
	      }
	      var arrStacked = stack.get(array);
	      var othStacked = stack.get(other);
	      if (arrStacked && othStacked) {
	        return arrStacked == other && othStacked == array;
	      }
	      var index = -1,
	          result = true,
	          seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined$1;
	      stack.set(array, other);
	      stack.set(other, array);
	      while (++index < arrLength) {
	        var arrValue = array[index],
	            othValue = other[index];
	        if (customizer) {
	          var compared = isPartial
	            ? customizer(othValue, arrValue, index, other, array, stack)
	            : customizer(arrValue, othValue, index, array, other, stack);
	        }
	        if (compared !== undefined$1) {
	          if (compared) {
	            continue;
	          }
	          result = false;
	          break;
	        }
	        if (seen) {
	          if (!arraySome(other, function(othValue, othIndex) {
	                if (!cacheHas(seen, othIndex) &&
	                    (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
	                  return seen.push(othIndex);
	                }
	              })) {
	            result = false;
	            break;
	          }
	        } else if (!(
	              arrValue === othValue ||
	                equalFunc(arrValue, othValue, bitmask, customizer, stack)
	            )) {
	          result = false;
	          break;
	        }
	      }
	      stack['delete'](array);
	      stack['delete'](other);
	      return result;
	    }
	    function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
	      switch (tag) {
	        case dataViewTag:
	          if ((object.byteLength != other.byteLength) ||
	              (object.byteOffset != other.byteOffset)) {
	            return false;
	          }
	          object = object.buffer;
	          other = other.buffer;
	        case arrayBufferTag:
	          if ((object.byteLength != other.byteLength) ||
	              !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
	            return false;
	          }
	          return true;
	        case boolTag:
	        case dateTag:
	        case numberTag:
	          return eq(+object, +other);
	        case errorTag:
	          return object.name == other.name && object.message == other.message;
	        case regexpTag:
	        case stringTag:
	          return object == (other + '');
	        case mapTag:
	          var convert = mapToArray;
	        case setTag:
	          var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
	          convert || (convert = setToArray);
	          if (object.size != other.size && !isPartial) {
	            return false;
	          }
	          var stacked = stack.get(object);
	          if (stacked) {
	            return stacked == other;
	          }
	          bitmask |= COMPARE_UNORDERED_FLAG;
	          stack.set(object, other);
	          var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
	          stack['delete'](object);
	          return result;
	        case symbolTag:
	          if (symbolValueOf) {
	            return symbolValueOf.call(object) == symbolValueOf.call(other);
	          }
	      }
	      return false;
	    }
	    function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
	      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
	          objProps = getAllKeys(object),
	          objLength = objProps.length,
	          othProps = getAllKeys(other),
	          othLength = othProps.length;
	      if (objLength != othLength && !isPartial) {
	        return false;
	      }
	      var index = objLength;
	      while (index--) {
	        var key = objProps[index];
	        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
	          return false;
	        }
	      }
	      var objStacked = stack.get(object);
	      var othStacked = stack.get(other);
	      if (objStacked && othStacked) {
	        return objStacked == other && othStacked == object;
	      }
	      var result = true;
	      stack.set(object, other);
	      stack.set(other, object);
	      var skipCtor = isPartial;
	      while (++index < objLength) {
	        key = objProps[index];
	        var objValue = object[key],
	            othValue = other[key];
	        if (customizer) {
	          var compared = isPartial
	            ? customizer(othValue, objValue, key, other, object, stack)
	            : customizer(objValue, othValue, key, object, other, stack);
	        }
	        if (!(compared === undefined$1
	              ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
	              : compared
	            )) {
	          result = false;
	          break;
	        }
	        skipCtor || (skipCtor = key == 'constructor');
	      }
	      if (result && !skipCtor) {
	        var objCtor = object.constructor,
	            othCtor = other.constructor;
	        if (objCtor != othCtor &&
	            ('constructor' in object && 'constructor' in other) &&
	            !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
	              typeof othCtor == 'function' && othCtor instanceof othCtor)) {
	          result = false;
	        }
	      }
	      stack['delete'](object);
	      stack['delete'](other);
	      return result;
	    }
	    function flatRest(func) {
	      return setToString(overRest(func, undefined$1, flatten), func + '');
	    }
	    function getAllKeys(object) {
	      return baseGetAllKeys(object, keys, getSymbols);
	    }
	    function getAllKeysIn(object) {
	      return baseGetAllKeys(object, keysIn, getSymbolsIn);
	    }
	    var getData = !metaMap ? noop : function(func) {
	      return metaMap.get(func);
	    };
	    function getFuncName(func) {
	      var result = (func.name + ''),
	          array = realNames[result],
	          length = hasOwnProperty.call(realNames, result) ? array.length : 0;
	      while (length--) {
	        var data = array[length],
	            otherFunc = data.func;
	        if (otherFunc == null || otherFunc == func) {
	          return data.name;
	        }
	      }
	      return result;
	    }
	    function getHolder(func) {
	      var object = hasOwnProperty.call(lodash, 'placeholder') ? lodash : func;
	      return object.placeholder;
	    }
	    function getIteratee() {
	      var result = lodash.iteratee || iteratee;
	      result = result === iteratee ? baseIteratee : result;
	      return arguments.length ? result(arguments[0], arguments[1]) : result;
	    }
	    function getMapData(map, key) {
	      var data = map.__data__;
	      return isKeyable(key)
	        ? data[typeof key == 'string' ? 'string' : 'hash']
	        : data.map;
	    }
	    function getMatchData(object) {
	      var result = keys(object),
	          length = result.length;
	      while (length--) {
	        var key = result[length],
	            value = object[key];
	        result[length] = [key, value, isStrictComparable(value)];
	      }
	      return result;
	    }
	    function getNative(object, key) {
	      var value = getValue(object, key);
	      return baseIsNative(value) ? value : undefined$1;
	    }
	    function getRawTag(value) {
	      var isOwn = hasOwnProperty.call(value, symToStringTag),
	          tag = value[symToStringTag];
	      try {
	        value[symToStringTag] = undefined$1;
	        var unmasked = true;
	      } catch (e) {}
	      var result = nativeObjectToString.call(value);
	      if (unmasked) {
	        if (isOwn) {
	          value[symToStringTag] = tag;
	        } else {
	          delete value[symToStringTag];
	        }
	      }
	      return result;
	    }
	    var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
	      if (object == null) {
	        return [];
	      }
	      object = Object(object);
	      return arrayFilter(nativeGetSymbols(object), function(symbol) {
	        return propertyIsEnumerable.call(object, symbol);
	      });
	    };
	    var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
	      var result = [];
	      while (object) {
	        arrayPush(result, getSymbols(object));
	        object = getPrototype(object);
	      }
	      return result;
	    };
	    var getTag = baseGetTag;
	    if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
	        (Map && getTag(new Map) != mapTag) ||
	        (Promise && getTag(Promise.resolve()) != promiseTag) ||
	        (Set && getTag(new Set) != setTag) ||
	        (WeakMap && getTag(new WeakMap) != weakMapTag)) {
	      getTag = function(value) {
	        var result = baseGetTag(value),
	            Ctor = result == objectTag ? value.constructor : undefined$1,
	            ctorString = Ctor ? toSource(Ctor) : '';
	        if (ctorString) {
	          switch (ctorString) {
	            case dataViewCtorString: return dataViewTag;
	            case mapCtorString: return mapTag;
	            case promiseCtorString: return promiseTag;
	            case setCtorString: return setTag;
	            case weakMapCtorString: return weakMapTag;
	          }
	        }
	        return result;
	      };
	    }
	    function getView(start, end, transforms) {
	      var index = -1,
	          length = transforms.length;
	      while (++index < length) {
	        var data = transforms[index],
	            size = data.size;
	        switch (data.type) {
	          case 'drop':      start += size; break;
	          case 'dropRight': end -= size; break;
	          case 'take':      end = nativeMin(end, start + size); break;
	          case 'takeRight': start = nativeMax(start, end - size); break;
	        }
	      }
	      return { 'start': start, 'end': end };
	    }
	    function getWrapDetails(source) {
	      var match = source.match(reWrapDetails);
	      return match ? match[1].split(reSplitDetails) : [];
	    }
	    function hasPath(object, path, hasFunc) {
	      path = castPath(path, object);
	      var index = -1,
	          length = path.length,
	          result = false;
	      while (++index < length) {
	        var key = toKey(path[index]);
	        if (!(result = object != null && hasFunc(object, key))) {
	          break;
	        }
	        object = object[key];
	      }
	      if (result || ++index != length) {
	        return result;
	      }
	      length = object == null ? 0 : object.length;
	      return !!length && isLength(length) && isIndex(key, length) &&
	        (isArray(object) || isArguments(object));
	    }
	    function initCloneArray(array) {
	      var length = array.length,
	          result = new array.constructor(length);
	      if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
	        result.index = array.index;
	        result.input = array.input;
	      }
	      return result;
	    }
	    function initCloneObject(object) {
	      return (typeof object.constructor == 'function' && !isPrototype(object))
	        ? baseCreate(getPrototype(object))
	        : {};
	    }
	    function initCloneByTag(object, tag, isDeep) {
	      var Ctor = object.constructor;
	      switch (tag) {
	        case arrayBufferTag:
	          return cloneArrayBuffer(object);
	        case boolTag:
	        case dateTag:
	          return new Ctor(+object);
	        case dataViewTag:
	          return cloneDataView(object, isDeep);
	        case float32Tag: case float64Tag:
	        case int8Tag: case int16Tag: case int32Tag:
	        case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
	          return cloneTypedArray(object, isDeep);
	        case mapTag:
	          return new Ctor;
	        case numberTag:
	        case stringTag:
	          return new Ctor(object);
	        case regexpTag:
	          return cloneRegExp(object);
	        case setTag:
	          return new Ctor;
	        case symbolTag:
	          return cloneSymbol(object);
	      }
	    }
	    function insertWrapDetails(source, details) {
	      var length = details.length;
	      if (!length) {
	        return source;
	      }
	      var lastIndex = length - 1;
	      details[lastIndex] = (length > 1 ? '& ' : '') + details[lastIndex];
	      details = details.join(length > 2 ? ', ' : ' ');
	      return source.replace(reWrapComment, '{\n/* [wrapped with ' + details + '] */\n');
	    }
	    function isFlattenable(value) {
	      return isArray(value) || isArguments(value) ||
	        !!(spreadableSymbol && value && value[spreadableSymbol]);
	    }
	    function isIndex(value, length) {
	      var type = typeof value;
	      length = length == null ? MAX_SAFE_INTEGER : length;
	      return !!length &&
	        (type == 'number' ||
	          (type != 'symbol' && reIsUint.test(value))) &&
	            (value > -1 && value % 1 == 0 && value < length);
	    }
	    function isIterateeCall(value, index, object) {
	      if (!isObject(object)) {
	        return false;
	      }
	      var type = typeof index;
	      if (type == 'number'
	            ? (isArrayLike(object) && isIndex(index, object.length))
	            : (type == 'string' && index in object)
	          ) {
	        return eq(object[index], value);
	      }
	      return false;
	    }
	    function isKey(value, object) {
	      if (isArray(value)) {
	        return false;
	      }
	      var type = typeof value;
	      if (type == 'number' || type == 'symbol' || type == 'boolean' ||
	          value == null || isSymbol(value)) {
	        return true;
	      }
	      return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
	        (object != null && value in Object(object));
	    }
	    function isKeyable(value) {
	      var type = typeof value;
	      return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
	        ? (value !== '__proto__')
	        : (value === null);
	    }
	    function isLaziable(func) {
	      var funcName = getFuncName(func),
	          other = lodash[funcName];
	      if (typeof other != 'function' || !(funcName in LazyWrapper.prototype)) {
	        return false;
	      }
	      if (func === other) {
	        return true;
	      }
	      var data = getData(other);
	      return !!data && func === data[0];
	    }
	    function isMasked(func) {
	      return !!maskSrcKey && (maskSrcKey in func);
	    }
	    var isMaskable = coreJsData ? isFunction : stubFalse;
	    function isPrototype(value) {
	      var Ctor = value && value.constructor,
	          proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;
	      return value === proto;
	    }
	    function isStrictComparable(value) {
	      return value === value && !isObject(value);
	    }
	    function matchesStrictComparable(key, srcValue) {
	      return function(object) {
	        if (object == null) {
	          return false;
	        }
	        return object[key] === srcValue &&
	          (srcValue !== undefined$1 || (key in Object(object)));
	      };
	    }
	    function memoizeCapped(func) {
	      var result = memoize(func, function(key) {
	        if (cache.size === MAX_MEMOIZE_SIZE) {
	          cache.clear();
	        }
	        return key;
	      });
	      var cache = result.cache;
	      return result;
	    }
	    function mergeData(data, source) {
	      var bitmask = data[1],
	          srcBitmask = source[1],
	          newBitmask = bitmask | srcBitmask,
	          isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
	      var isCombo =
	        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_CURRY_FLAG)) ||
	        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_REARG_FLAG) && (data[7].length <= source[8])) ||
	        ((srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG)) && (source[7].length <= source[8]) && (bitmask == WRAP_CURRY_FLAG));
	      if (!(isCommon || isCombo)) {
	        return data;
	      }
	      if (srcBitmask & WRAP_BIND_FLAG) {
	        data[2] = source[2];
	        newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
	      }
	      var value = source[3];
	      if (value) {
	        var partials = data[3];
	        data[3] = partials ? composeArgs(partials, value, source[4]) : value;
	        data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
	      }
	      value = source[5];
	      if (value) {
	        partials = data[5];
	        data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
	        data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
	      }
	      value = source[7];
	      if (value) {
	        data[7] = value;
	      }
	      if (srcBitmask & WRAP_ARY_FLAG) {
	        data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
	      }
	      if (data[9] == null) {
	        data[9] = source[9];
	      }
	      data[0] = source[0];
	      data[1] = newBitmask;
	      return data;
	    }
	    function nativeKeysIn(object) {
	      var result = [];
	      if (object != null) {
	        for (var key in Object(object)) {
	          result.push(key);
	        }
	      }
	      return result;
	    }
	    function objectToString(value) {
	      return nativeObjectToString.call(value);
	    }
	    function overRest(func, start, transform) {
	      start = nativeMax(start === undefined$1 ? (func.length - 1) : start, 0);
	      return function() {
	        var args = arguments,
	            index = -1,
	            length = nativeMax(args.length - start, 0),
	            array = Array(length);
	        while (++index < length) {
	          array[index] = args[start + index];
	        }
	        index = -1;
	        var otherArgs = Array(start + 1);
	        while (++index < start) {
	          otherArgs[index] = args[index];
	        }
	        otherArgs[start] = transform(array);
	        return apply(func, this, otherArgs);
	      };
	    }
	    function parent(object, path) {
	      return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
	    }
	    function reorder(array, indexes) {
	      var arrLength = array.length,
	          length = nativeMin(indexes.length, arrLength),
	          oldArray = copyArray(array);
	      while (length--) {
	        var index = indexes[length];
	        array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined$1;
	      }
	      return array;
	    }
	    function safeGet(object, key) {
	      if (key === 'constructor' && typeof object[key] === 'function') {
	        return;
	      }
	      if (key == '__proto__') {
	        return;
	      }
	      return object[key];
	    }
	    var setData = shortOut(baseSetData);
	    var setTimeout = ctxSetTimeout || function(func, wait) {
	      return root.setTimeout(func, wait);
	    };
	    var setToString = shortOut(baseSetToString);
	    function setWrapToString(wrapper, reference, bitmask) {
	      var source = (reference + '');
	      return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
	    }
	    function shortOut(func) {
	      var count = 0,
	          lastCalled = 0;
	      return function() {
	        var stamp = nativeNow(),
	            remaining = HOT_SPAN - (stamp - lastCalled);
	        lastCalled = stamp;
	        if (remaining > 0) {
	          if (++count >= HOT_COUNT) {
	            return arguments[0];
	          }
	        } else {
	          count = 0;
	        }
	        return func.apply(undefined$1, arguments);
	      };
	    }
	    function shuffleSelf(array, size) {
	      var index = -1,
	          length = array.length,
	          lastIndex = length - 1;
	      size = size === undefined$1 ? length : size;
	      while (++index < size) {
	        var rand = baseRandom(index, lastIndex),
	            value = array[rand];
	        array[rand] = array[index];
	        array[index] = value;
	      }
	      array.length = size;
	      return array;
	    }
	    var stringToPath = memoizeCapped(function(string) {
	      var result = [];
	      if (string.charCodeAt(0) === 46 ) {
	        result.push('');
	      }
	      string.replace(rePropName, function(match, number, quote, subString) {
	        result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
	      });
	      return result;
	    });
	    function toKey(value) {
	      if (typeof value == 'string' || isSymbol(value)) {
	        return value;
	      }
	      var result = (value + '');
	      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	    }
	    function toSource(func) {
	      if (func != null) {
	        try {
	          return funcToString.call(func);
	        } catch (e) {}
	        try {
	          return (func + '');
	        } catch (e) {}
	      }
	      return '';
	    }
	    function updateWrapDetails(details, bitmask) {
	      arrayEach(wrapFlags, function(pair) {
	        var value = '_.' + pair[0];
	        if ((bitmask & pair[1]) && !arrayIncludes(details, value)) {
	          details.push(value);
	        }
	      });
	      return details.sort();
	    }
	    function wrapperClone(wrapper) {
	      if (wrapper instanceof LazyWrapper) {
	        return wrapper.clone();
	      }
	      var result = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
	      result.__actions__ = copyArray(wrapper.__actions__);
	      result.__index__  = wrapper.__index__;
	      result.__values__ = wrapper.__values__;
	      return result;
	    }
	    function chunk(array, size, guard) {
	      if ((guard ? isIterateeCall(array, size, guard) : size === undefined$1)) {
	        size = 1;
	      } else {
	        size = nativeMax(toInteger(size), 0);
	      }
	      var length = array == null ? 0 : array.length;
	      if (!length || size < 1) {
	        return [];
	      }
	      var index = 0,
	          resIndex = 0,
	          result = Array(nativeCeil(length / size));
	      while (index < length) {
	        result[resIndex++] = baseSlice(array, index, (index += size));
	      }
	      return result;
	    }
	    function compact(array) {
	      var index = -1,
	          length = array == null ? 0 : array.length,
	          resIndex = 0,
	          result = [];
	      while (++index < length) {
	        var value = array[index];
	        if (value) {
	          result[resIndex++] = value;
	        }
	      }
	      return result;
	    }
	    function concat() {
	      var length = arguments.length;
	      if (!length) {
	        return [];
	      }
	      var args = Array(length - 1),
	          array = arguments[0],
	          index = length;
	      while (index--) {
	        args[index - 1] = arguments[index];
	      }
	      return arrayPush(isArray(array) ? copyArray(array) : [array], baseFlatten(args, 1));
	    }
	    var difference = baseRest(function(array, values) {
	      return isArrayLikeObject(array)
	        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true))
	        : [];
	    });
	    var differenceBy = baseRest(function(array, values) {
	      var iteratee = last(values);
	      if (isArrayLikeObject(iteratee)) {
	        iteratee = undefined$1;
	      }
	      return isArrayLikeObject(array)
	        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), getIteratee(iteratee, 2))
	        : [];
	    });
	    var differenceWith = baseRest(function(array, values) {
	      var comparator = last(values);
	      if (isArrayLikeObject(comparator)) {
	        comparator = undefined$1;
	      }
	      return isArrayLikeObject(array)
	        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), undefined$1, comparator)
	        : [];
	    });
	    function drop(array, n, guard) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      n = (guard || n === undefined$1) ? 1 : toInteger(n);
	      return baseSlice(array, n < 0 ? 0 : n, length);
	    }
	    function dropRight(array, n, guard) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      n = (guard || n === undefined$1) ? 1 : toInteger(n);
	      n = length - n;
	      return baseSlice(array, 0, n < 0 ? 0 : n);
	    }
	    function dropRightWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3), true, true)
	        : [];
	    }
	    function dropWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3), true)
	        : [];
	    }
	    function fill(array, value, start, end) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      if (start && typeof start != 'number' && isIterateeCall(array, value, start)) {
	        start = 0;
	        end = length;
	      }
	      return baseFill(array, value, start, end);
	    }
	    function findIndex(array, predicate, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = fromIndex == null ? 0 : toInteger(fromIndex);
	      if (index < 0) {
	        index = nativeMax(length + index, 0);
	      }
	      return baseFindIndex(array, getIteratee(predicate, 3), index);
	    }
	    function findLastIndex(array, predicate, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = length - 1;
	      if (fromIndex !== undefined$1) {
	        index = toInteger(fromIndex);
	        index = fromIndex < 0
	          ? nativeMax(length + index, 0)
	          : nativeMin(index, length - 1);
	      }
	      return baseFindIndex(array, getIteratee(predicate, 3), index, true);
	    }
	    function flatten(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseFlatten(array, 1) : [];
	    }
	    function flattenDeep(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseFlatten(array, INFINITY) : [];
	    }
	    function flattenDepth(array, depth) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      depth = depth === undefined$1 ? 1 : toInteger(depth);
	      return baseFlatten(array, depth);
	    }
	    function fromPairs(pairs) {
	      var index = -1,
	          length = pairs == null ? 0 : pairs.length,
	          result = {};
	      while (++index < length) {
	        var pair = pairs[index];
	        result[pair[0]] = pair[1];
	      }
	      return result;
	    }
	    function head(array) {
	      return (array && array.length) ? array[0] : undefined$1;
	    }
	    function indexOf(array, value, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = fromIndex == null ? 0 : toInteger(fromIndex);
	      if (index < 0) {
	        index = nativeMax(length + index, 0);
	      }
	      return baseIndexOf(array, value, index);
	    }
	    function initial(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseSlice(array, 0, -1) : [];
	    }
	    var intersection = baseRest(function(arrays) {
	      var mapped = arrayMap(arrays, castArrayLikeObject);
	      return (mapped.length && mapped[0] === arrays[0])
	        ? baseIntersection(mapped)
	        : [];
	    });
	    var intersectionBy = baseRest(function(arrays) {
	      var iteratee = last(arrays),
	          mapped = arrayMap(arrays, castArrayLikeObject);
	      if (iteratee === last(mapped)) {
	        iteratee = undefined$1;
	      } else {
	        mapped.pop();
	      }
	      return (mapped.length && mapped[0] === arrays[0])
	        ? baseIntersection(mapped, getIteratee(iteratee, 2))
	        : [];
	    });
	    var intersectionWith = baseRest(function(arrays) {
	      var comparator = last(arrays),
	          mapped = arrayMap(arrays, castArrayLikeObject);
	      comparator = typeof comparator == 'function' ? comparator : undefined$1;
	      if (comparator) {
	        mapped.pop();
	      }
	      return (mapped.length && mapped[0] === arrays[0])
	        ? baseIntersection(mapped, undefined$1, comparator)
	        : [];
	    });
	    function join(array, separator) {
	      return array == null ? '' : nativeJoin.call(array, separator);
	    }
	    function last(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? array[length - 1] : undefined$1;
	    }
	    function lastIndexOf(array, value, fromIndex) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return -1;
	      }
	      var index = length;
	      if (fromIndex !== undefined$1) {
	        index = toInteger(fromIndex);
	        index = index < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
	      }
	      return value === value
	        ? strictLastIndexOf(array, value, index)
	        : baseFindIndex(array, baseIsNaN, index, true);
	    }
	    function nth(array, n) {
	      return (array && array.length) ? baseNth(array, toInteger(n)) : undefined$1;
	    }
	    var pull = baseRest(pullAll);
	    function pullAll(array, values) {
	      return (array && array.length && values && values.length)
	        ? basePullAll(array, values)
	        : array;
	    }
	    function pullAllBy(array, values, iteratee) {
	      return (array && array.length && values && values.length)
	        ? basePullAll(array, values, getIteratee(iteratee, 2))
	        : array;
	    }
	    function pullAllWith(array, values, comparator) {
	      return (array && array.length && values && values.length)
	        ? basePullAll(array, values, undefined$1, comparator)
	        : array;
	    }
	    var pullAt = flatRest(function(array, indexes) {
	      var length = array == null ? 0 : array.length,
	          result = baseAt(array, indexes);
	      basePullAt(array, arrayMap(indexes, function(index) {
	        return isIndex(index, length) ? +index : index;
	      }).sort(compareAscending));
	      return result;
	    });
	    function remove(array, predicate) {
	      var result = [];
	      if (!(array && array.length)) {
	        return result;
	      }
	      var index = -1,
	          indexes = [],
	          length = array.length;
	      predicate = getIteratee(predicate, 3);
	      while (++index < length) {
	        var value = array[index];
	        if (predicate(value, index, array)) {
	          result.push(value);
	          indexes.push(index);
	        }
	      }
	      basePullAt(array, indexes);
	      return result;
	    }
	    function reverse(array) {
	      return array == null ? array : nativeReverse.call(array);
	    }
	    function slice(array, start, end) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      if (end && typeof end != 'number' && isIterateeCall(array, start, end)) {
	        start = 0;
	        end = length;
	      }
	      else {
	        start = start == null ? 0 : toInteger(start);
	        end = end === undefined$1 ? length : toInteger(end);
	      }
	      return baseSlice(array, start, end);
	    }
	    function sortedIndex(array, value) {
	      return baseSortedIndex(array, value);
	    }
	    function sortedIndexBy(array, value, iteratee) {
	      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2));
	    }
	    function sortedIndexOf(array, value) {
	      var length = array == null ? 0 : array.length;
	      if (length) {
	        var index = baseSortedIndex(array, value);
	        if (index < length && eq(array[index], value)) {
	          return index;
	        }
	      }
	      return -1;
	    }
	    function sortedLastIndex(array, value) {
	      return baseSortedIndex(array, value, true);
	    }
	    function sortedLastIndexBy(array, value, iteratee) {
	      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2), true);
	    }
	    function sortedLastIndexOf(array, value) {
	      var length = array == null ? 0 : array.length;
	      if (length) {
	        var index = baseSortedIndex(array, value, true) - 1;
	        if (eq(array[index], value)) {
	          return index;
	        }
	      }
	      return -1;
	    }
	    function sortedUniq(array) {
	      return (array && array.length)
	        ? baseSortedUniq(array)
	        : [];
	    }
	    function sortedUniqBy(array, iteratee) {
	      return (array && array.length)
	        ? baseSortedUniq(array, getIteratee(iteratee, 2))
	        : [];
	    }
	    function tail(array) {
	      var length = array == null ? 0 : array.length;
	      return length ? baseSlice(array, 1, length) : [];
	    }
	    function take(array, n, guard) {
	      if (!(array && array.length)) {
	        return [];
	      }
	      n = (guard || n === undefined$1) ? 1 : toInteger(n);
	      return baseSlice(array, 0, n < 0 ? 0 : n);
	    }
	    function takeRight(array, n, guard) {
	      var length = array == null ? 0 : array.length;
	      if (!length) {
	        return [];
	      }
	      n = (guard || n === undefined$1) ? 1 : toInteger(n);
	      n = length - n;
	      return baseSlice(array, n < 0 ? 0 : n, length);
	    }
	    function takeRightWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3), false, true)
	        : [];
	    }
	    function takeWhile(array, predicate) {
	      return (array && array.length)
	        ? baseWhile(array, getIteratee(predicate, 3))
	        : [];
	    }
	    var union = baseRest(function(arrays) {
	      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
	    });
	    var unionBy = baseRest(function(arrays) {
	      var iteratee = last(arrays);
	      if (isArrayLikeObject(iteratee)) {
	        iteratee = undefined$1;
	      }
	      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee, 2));
	    });
	    var unionWith = baseRest(function(arrays) {
	      var comparator = last(arrays);
	      comparator = typeof comparator == 'function' ? comparator : undefined$1;
	      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined$1, comparator);
	    });
	    function uniq(array) {
	      return (array && array.length) ? baseUniq(array) : [];
	    }
	    function uniqBy(array, iteratee) {
	      return (array && array.length) ? baseUniq(array, getIteratee(iteratee, 2)) : [];
	    }
	    function uniqWith(array, comparator) {
	      comparator = typeof comparator == 'function' ? comparator : undefined$1;
	      return (array && array.length) ? baseUniq(array, undefined$1, comparator) : [];
	    }
	    function unzip(array) {
	      if (!(array && array.length)) {
	        return [];
	      }
	      var length = 0;
	      array = arrayFilter(array, function(group) {
	        if (isArrayLikeObject(group)) {
	          length = nativeMax(group.length, length);
	          return true;
	        }
	      });
	      return baseTimes(length, function(index) {
	        return arrayMap(array, baseProperty(index));
	      });
	    }
	    function unzipWith(array, iteratee) {
	      if (!(array && array.length)) {
	        return [];
	      }
	      var result = unzip(array);
	      if (iteratee == null) {
	        return result;
	      }
	      return arrayMap(result, function(group) {
	        return apply(iteratee, undefined$1, group);
	      });
	    }
	    var without = baseRest(function(array, values) {
	      return isArrayLikeObject(array)
	        ? baseDifference(array, values)
	        : [];
	    });
	    var xor = baseRest(function(arrays) {
	      return baseXor(arrayFilter(arrays, isArrayLikeObject));
	    });
	    var xorBy = baseRest(function(arrays) {
	      var iteratee = last(arrays);
	      if (isArrayLikeObject(iteratee)) {
	        iteratee = undefined$1;
	      }
	      return baseXor(arrayFilter(arrays, isArrayLikeObject), getIteratee(iteratee, 2));
	    });
	    var xorWith = baseRest(function(arrays) {
	      var comparator = last(arrays);
	      comparator = typeof comparator == 'function' ? comparator : undefined$1;
	      return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined$1, comparator);
	    });
	    var zip = baseRest(unzip);
	    function zipObject(props, values) {
	      return baseZipObject(props || [], values || [], assignValue);
	    }
	    function zipObjectDeep(props, values) {
	      return baseZipObject(props || [], values || [], baseSet);
	    }
	    var zipWith = baseRest(function(arrays) {
	      var length = arrays.length,
	          iteratee = length > 1 ? arrays[length - 1] : undefined$1;
	      iteratee = typeof iteratee == 'function' ? (arrays.pop(), iteratee) : undefined$1;
	      return unzipWith(arrays, iteratee);
	    });
	    function chain(value) {
	      var result = lodash(value);
	      result.__chain__ = true;
	      return result;
	    }
	    function tap(value, interceptor) {
	      interceptor(value);
	      return value;
	    }
	    function thru(value, interceptor) {
	      return interceptor(value);
	    }
	    var wrapperAt = flatRest(function(paths) {
	      var length = paths.length,
	          start = length ? paths[0] : 0,
	          value = this.__wrapped__,
	          interceptor = function(object) { return baseAt(object, paths); };
	      if (length > 1 || this.__actions__.length ||
	          !(value instanceof LazyWrapper) || !isIndex(start)) {
	        return this.thru(interceptor);
	      }
	      value = value.slice(start, +start + (length ? 1 : 0));
	      value.__actions__.push({
	        'func': thru,
	        'args': [interceptor],
	        'thisArg': undefined$1
	      });
	      return new LodashWrapper(value, this.__chain__).thru(function(array) {
	        if (length && !array.length) {
	          array.push(undefined$1);
	        }
	        return array;
	      });
	    });
	    function wrapperChain() {
	      return chain(this);
	    }
	    function wrapperCommit() {
	      return new LodashWrapper(this.value(), this.__chain__);
	    }
	    function wrapperNext() {
	      if (this.__values__ === undefined$1) {
	        this.__values__ = toArray(this.value());
	      }
	      var done = this.__index__ >= this.__values__.length,
	          value = done ? undefined$1 : this.__values__[this.__index__++];
	      return { 'done': done, 'value': value };
	    }
	    function wrapperToIterator() {
	      return this;
	    }
	    function wrapperPlant(value) {
	      var result,
	          parent = this;
	      while (parent instanceof baseLodash) {
	        var clone = wrapperClone(parent);
	        clone.__index__ = 0;
	        clone.__values__ = undefined$1;
	        if (result) {
	          previous.__wrapped__ = clone;
	        } else {
	          result = clone;
	        }
	        var previous = clone;
	        parent = parent.__wrapped__;
	      }
	      previous.__wrapped__ = value;
	      return result;
	    }
	    function wrapperReverse() {
	      var value = this.__wrapped__;
	      if (value instanceof LazyWrapper) {
	        var wrapped = value;
	        if (this.__actions__.length) {
	          wrapped = new LazyWrapper(this);
	        }
	        wrapped = wrapped.reverse();
	        wrapped.__actions__.push({
	          'func': thru,
	          'args': [reverse],
	          'thisArg': undefined$1
	        });
	        return new LodashWrapper(wrapped, this.__chain__);
	      }
	      return this.thru(reverse);
	    }
	    function wrapperValue() {
	      return baseWrapperValue(this.__wrapped__, this.__actions__);
	    }
	    var countBy = createAggregator(function(result, value, key) {
	      if (hasOwnProperty.call(result, key)) {
	        ++result[key];
	      } else {
	        baseAssignValue(result, key, 1);
	      }
	    });
	    function every(collection, predicate, guard) {
	      var func = isArray(collection) ? arrayEvery : baseEvery;
	      if (guard && isIterateeCall(collection, predicate, guard)) {
	        predicate = undefined$1;
	      }
	      return func(collection, getIteratee(predicate, 3));
	    }
	    function filter(collection, predicate) {
	      var func = isArray(collection) ? arrayFilter : baseFilter;
	      return func(collection, getIteratee(predicate, 3));
	    }
	    var find = createFind(findIndex);
	    var findLast = createFind(findLastIndex);
	    function flatMap(collection, iteratee) {
	      return baseFlatten(map(collection, iteratee), 1);
	    }
	    function flatMapDeep(collection, iteratee) {
	      return baseFlatten(map(collection, iteratee), INFINITY);
	    }
	    function flatMapDepth(collection, iteratee, depth) {
	      depth = depth === undefined$1 ? 1 : toInteger(depth);
	      return baseFlatten(map(collection, iteratee), depth);
	    }
	    function forEach(collection, iteratee) {
	      var func = isArray(collection) ? arrayEach : baseEach;
	      return func(collection, getIteratee(iteratee, 3));
	    }
	    function forEachRight(collection, iteratee) {
	      var func = isArray(collection) ? arrayEachRight : baseEachRight;
	      return func(collection, getIteratee(iteratee, 3));
	    }
	    var groupBy = createAggregator(function(result, value, key) {
	      if (hasOwnProperty.call(result, key)) {
	        result[key].push(value);
	      } else {
	        baseAssignValue(result, key, [value]);
	      }
	    });
	    function includes(collection, value, fromIndex, guard) {
	      collection = isArrayLike(collection) ? collection : values(collection);
	      fromIndex = (fromIndex && !guard) ? toInteger(fromIndex) : 0;
	      var length = collection.length;
	      if (fromIndex < 0) {
	        fromIndex = nativeMax(length + fromIndex, 0);
	      }
	      return isString(collection)
	        ? (fromIndex <= length && collection.indexOf(value, fromIndex) > -1)
	        : (!!length && baseIndexOf(collection, value, fromIndex) > -1);
	    }
	    var invokeMap = baseRest(function(collection, path, args) {
	      var index = -1,
	          isFunc = typeof path == 'function',
	          result = isArrayLike(collection) ? Array(collection.length) : [];
	      baseEach(collection, function(value) {
	        result[++index] = isFunc ? apply(path, value, args) : baseInvoke(value, path, args);
	      });
	      return result;
	    });
	    var keyBy = createAggregator(function(result, value, key) {
	      baseAssignValue(result, key, value);
	    });
	    function map(collection, iteratee) {
	      var func = isArray(collection) ? arrayMap : baseMap;
	      return func(collection, getIteratee(iteratee, 3));
	    }
	    function orderBy(collection, iteratees, orders, guard) {
	      if (collection == null) {
	        return [];
	      }
	      if (!isArray(iteratees)) {
	        iteratees = iteratees == null ? [] : [iteratees];
	      }
	      orders = guard ? undefined$1 : orders;
	      if (!isArray(orders)) {
	        orders = orders == null ? [] : [orders];
	      }
	      return baseOrderBy(collection, iteratees, orders);
	    }
	    var partition = createAggregator(function(result, value, key) {
	      result[key ? 0 : 1].push(value);
	    }, function() { return [[], []]; });
	    function reduce(collection, iteratee, accumulator) {
	      var func = isArray(collection) ? arrayReduce : baseReduce,
	          initAccum = arguments.length < 3;
	      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEach);
	    }
	    function reduceRight(collection, iteratee, accumulator) {
	      var func = isArray(collection) ? arrayReduceRight : baseReduce,
	          initAccum = arguments.length < 3;
	      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEachRight);
	    }
	    function reject(collection, predicate) {
	      var func = isArray(collection) ? arrayFilter : baseFilter;
	      return func(collection, negate(getIteratee(predicate, 3)));
	    }
	    function sample(collection) {
	      var func = isArray(collection) ? arraySample : baseSample;
	      return func(collection);
	    }
	    function sampleSize(collection, n, guard) {
	      if ((guard ? isIterateeCall(collection, n, guard) : n === undefined$1)) {
	        n = 1;
	      } else {
	        n = toInteger(n);
	      }
	      var func = isArray(collection) ? arraySampleSize : baseSampleSize;
	      return func(collection, n);
	    }
	    function shuffle(collection) {
	      var func = isArray(collection) ? arrayShuffle : baseShuffle;
	      return func(collection);
	    }
	    function size(collection) {
	      if (collection == null) {
	        return 0;
	      }
	      if (isArrayLike(collection)) {
	        return isString(collection) ? stringSize(collection) : collection.length;
	      }
	      var tag = getTag(collection);
	      if (tag == mapTag || tag == setTag) {
	        return collection.size;
	      }
	      return baseKeys(collection).length;
	    }
	    function some(collection, predicate, guard) {
	      var func = isArray(collection) ? arraySome : baseSome;
	      if (guard && isIterateeCall(collection, predicate, guard)) {
	        predicate = undefined$1;
	      }
	      return func(collection, getIteratee(predicate, 3));
	    }
	    var sortBy = baseRest(function(collection, iteratees) {
	      if (collection == null) {
	        return [];
	      }
	      var length = iteratees.length;
	      if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
	        iteratees = [];
	      } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
	        iteratees = [iteratees[0]];
	      }
	      return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
	    });
	    var now = ctxNow || function() {
	      return root.Date.now();
	    };
	    function after(n, func) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      n = toInteger(n);
	      return function() {
	        if (--n < 1) {
	          return func.apply(this, arguments);
	        }
	      };
	    }
	    function ary(func, n, guard) {
	      n = guard ? undefined$1 : n;
	      n = (func && n == null) ? func.length : n;
	      return createWrap(func, WRAP_ARY_FLAG, undefined$1, undefined$1, undefined$1, undefined$1, n);
	    }
	    function before(n, func) {
	      var result;
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      n = toInteger(n);
	      return function() {
	        if (--n > 0) {
	          result = func.apply(this, arguments);
	        }
	        if (n <= 1) {
	          func = undefined$1;
	        }
	        return result;
	      };
	    }
	    var bind = baseRest(function(func, thisArg, partials) {
	      var bitmask = WRAP_BIND_FLAG;
	      if (partials.length) {
	        var holders = replaceHolders(partials, getHolder(bind));
	        bitmask |= WRAP_PARTIAL_FLAG;
	      }
	      return createWrap(func, bitmask, thisArg, partials, holders);
	    });
	    var bindKey = baseRest(function(object, key, partials) {
	      var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
	      if (partials.length) {
	        var holders = replaceHolders(partials, getHolder(bindKey));
	        bitmask |= WRAP_PARTIAL_FLAG;
	      }
	      return createWrap(key, bitmask, object, partials, holders);
	    });
	    function curry(func, arity, guard) {
	      arity = guard ? undefined$1 : arity;
	      var result = createWrap(func, WRAP_CURRY_FLAG, undefined$1, undefined$1, undefined$1, undefined$1, undefined$1, arity);
	      result.placeholder = curry.placeholder;
	      return result;
	    }
	    function curryRight(func, arity, guard) {
	      arity = guard ? undefined$1 : arity;
	      var result = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined$1, undefined$1, undefined$1, undefined$1, undefined$1, arity);
	      result.placeholder = curryRight.placeholder;
	      return result;
	    }
	    function debounce(func, wait, options) {
	      var lastArgs,
	          lastThis,
	          maxWait,
	          result,
	          timerId,
	          lastCallTime,
	          lastInvokeTime = 0,
	          leading = false,
	          maxing = false,
	          trailing = true;
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      wait = toNumber(wait) || 0;
	      if (isObject(options)) {
	        leading = !!options.leading;
	        maxing = 'maxWait' in options;
	        maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
	        trailing = 'trailing' in options ? !!options.trailing : trailing;
	      }
	      function invokeFunc(time) {
	        var args = lastArgs,
	            thisArg = lastThis;
	        lastArgs = lastThis = undefined$1;
	        lastInvokeTime = time;
	        result = func.apply(thisArg, args);
	        return result;
	      }
	      function leadingEdge(time) {
	        lastInvokeTime = time;
	        timerId = setTimeout(timerExpired, wait);
	        return leading ? invokeFunc(time) : result;
	      }
	      function remainingWait(time) {
	        var timeSinceLastCall = time - lastCallTime,
	            timeSinceLastInvoke = time - lastInvokeTime,
	            timeWaiting = wait - timeSinceLastCall;
	        return maxing
	          ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke)
	          : timeWaiting;
	      }
	      function shouldInvoke(time) {
	        var timeSinceLastCall = time - lastCallTime,
	            timeSinceLastInvoke = time - lastInvokeTime;
	        return (lastCallTime === undefined$1 || (timeSinceLastCall >= wait) ||
	          (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
	      }
	      function timerExpired() {
	        var time = now();
	        if (shouldInvoke(time)) {
	          return trailingEdge(time);
	        }
	        timerId = setTimeout(timerExpired, remainingWait(time));
	      }
	      function trailingEdge(time) {
	        timerId = undefined$1;
	        if (trailing && lastArgs) {
	          return invokeFunc(time);
	        }
	        lastArgs = lastThis = undefined$1;
	        return result;
	      }
	      function cancel() {
	        if (timerId !== undefined$1) {
	          clearTimeout(timerId);
	        }
	        lastInvokeTime = 0;
	        lastArgs = lastCallTime = lastThis = timerId = undefined$1;
	      }
	      function flush() {
	        return timerId === undefined$1 ? result : trailingEdge(now());
	      }
	      function debounced() {
	        var time = now(),
	            isInvoking = shouldInvoke(time);
	        lastArgs = arguments;
	        lastThis = this;
	        lastCallTime = time;
	        if (isInvoking) {
	          if (timerId === undefined$1) {
	            return leadingEdge(lastCallTime);
	          }
	          if (maxing) {
	            clearTimeout(timerId);
	            timerId = setTimeout(timerExpired, wait);
	            return invokeFunc(lastCallTime);
	          }
	        }
	        if (timerId === undefined$1) {
	          timerId = setTimeout(timerExpired, wait);
	        }
	        return result;
	      }
	      debounced.cancel = cancel;
	      debounced.flush = flush;
	      return debounced;
	    }
	    var defer = baseRest(function(func, args) {
	      return baseDelay(func, 1, args);
	    });
	    var delay = baseRest(function(func, wait, args) {
	      return baseDelay(func, toNumber(wait) || 0, args);
	    });
	    function flip(func) {
	      return createWrap(func, WRAP_FLIP_FLAG);
	    }
	    function memoize(func, resolver) {
	      if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      var memoized = function() {
	        var args = arguments,
	            key = resolver ? resolver.apply(this, args) : args[0],
	            cache = memoized.cache;
	        if (cache.has(key)) {
	          return cache.get(key);
	        }
	        var result = func.apply(this, args);
	        memoized.cache = cache.set(key, result) || cache;
	        return result;
	      };
	      memoized.cache = new (memoize.Cache || MapCache);
	      return memoized;
	    }
	    memoize.Cache = MapCache;
	    function negate(predicate) {
	      if (typeof predicate != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      return function() {
	        var args = arguments;
	        switch (args.length) {
	          case 0: return !predicate.call(this);
	          case 1: return !predicate.call(this, args[0]);
	          case 2: return !predicate.call(this, args[0], args[1]);
	          case 3: return !predicate.call(this, args[0], args[1], args[2]);
	        }
	        return !predicate.apply(this, args);
	      };
	    }
	    function once(func) {
	      return before(2, func);
	    }
	    var overArgs = castRest(function(func, transforms) {
	      transforms = (transforms.length == 1 && isArray(transforms[0]))
	        ? arrayMap(transforms[0], baseUnary(getIteratee()))
	        : arrayMap(baseFlatten(transforms, 1), baseUnary(getIteratee()));
	      var funcsLength = transforms.length;
	      return baseRest(function(args) {
	        var index = -1,
	            length = nativeMin(args.length, funcsLength);
	        while (++index < length) {
	          args[index] = transforms[index].call(this, args[index]);
	        }
	        return apply(func, this, args);
	      });
	    });
	    var partial = baseRest(function(func, partials) {
	      var holders = replaceHolders(partials, getHolder(partial));
	      return createWrap(func, WRAP_PARTIAL_FLAG, undefined$1, partials, holders);
	    });
	    var partialRight = baseRest(function(func, partials) {
	      var holders = replaceHolders(partials, getHolder(partialRight));
	      return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined$1, partials, holders);
	    });
	    var rearg = flatRest(function(func, indexes) {
	      return createWrap(func, WRAP_REARG_FLAG, undefined$1, undefined$1, undefined$1, indexes);
	    });
	    function rest(func, start) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      start = start === undefined$1 ? start : toInteger(start);
	      return baseRest(func, start);
	    }
	    function spread(func, start) {
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      start = start == null ? 0 : nativeMax(toInteger(start), 0);
	      return baseRest(function(args) {
	        var array = args[start],
	            otherArgs = castSlice(args, 0, start);
	        if (array) {
	          arrayPush(otherArgs, array);
	        }
	        return apply(func, this, otherArgs);
	      });
	    }
	    function throttle(func, wait, options) {
	      var leading = true,
	          trailing = true;
	      if (typeof func != 'function') {
	        throw new TypeError(FUNC_ERROR_TEXT);
	      }
	      if (isObject(options)) {
	        leading = 'leading' in options ? !!options.leading : leading;
	        trailing = 'trailing' in options ? !!options.trailing : trailing;
	      }
	      return debounce(func, wait, {
	        'leading': leading,
	        'maxWait': wait,
	        'trailing': trailing
	      });
	    }
	    function unary(func) {
	      return ary(func, 1);
	    }
	    function wrap(value, wrapper) {
	      return partial(castFunction(wrapper), value);
	    }
	    function castArray() {
	      if (!arguments.length) {
	        return [];
	      }
	      var value = arguments[0];
	      return isArray(value) ? value : [value];
	    }
	    function clone(value) {
	      return baseClone(value, CLONE_SYMBOLS_FLAG);
	    }
	    function cloneWith(value, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined$1;
	      return baseClone(value, CLONE_SYMBOLS_FLAG, customizer);
	    }
	    function cloneDeep(value) {
	      return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
	    }
	    function cloneDeepWith(value, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined$1;
	      return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG, customizer);
	    }
	    function conformsTo(object, source) {
	      return source == null || baseConformsTo(object, source, keys(source));
	    }
	    function eq(value, other) {
	      return value === other || (value !== value && other !== other);
	    }
	    var gt = createRelationalOperation(baseGt);
	    var gte = createRelationalOperation(function(value, other) {
	      return value >= other;
	    });
	    var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
	      return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
	        !propertyIsEnumerable.call(value, 'callee');
	    };
	    var isArray = Array.isArray;
	    var isArrayBuffer = nodeIsArrayBuffer ? baseUnary(nodeIsArrayBuffer) : baseIsArrayBuffer;
	    function isArrayLike(value) {
	      return value != null && isLength(value.length) && !isFunction(value);
	    }
	    function isArrayLikeObject(value) {
	      return isObjectLike(value) && isArrayLike(value);
	    }
	    function isBoolean(value) {
	      return value === true || value === false ||
	        (isObjectLike(value) && baseGetTag(value) == boolTag);
	    }
	    var isBuffer = nativeIsBuffer || stubFalse;
	    var isDate = nodeIsDate ? baseUnary(nodeIsDate) : baseIsDate;
	    function isElement(value) {
	      return isObjectLike(value) && value.nodeType === 1 && !isPlainObject(value);
	    }
	    function isEmpty(value) {
	      if (value == null) {
	        return true;
	      }
	      if (isArrayLike(value) &&
	          (isArray(value) || typeof value == 'string' || typeof value.splice == 'function' ||
	            isBuffer(value) || isTypedArray(value) || isArguments(value))) {
	        return !value.length;
	      }
	      var tag = getTag(value);
	      if (tag == mapTag || tag == setTag) {
	        return !value.size;
	      }
	      if (isPrototype(value)) {
	        return !baseKeys(value).length;
	      }
	      for (var key in value) {
	        if (hasOwnProperty.call(value, key)) {
	          return false;
	        }
	      }
	      return true;
	    }
	    function isEqual(value, other) {
	      return baseIsEqual(value, other);
	    }
	    function isEqualWith(value, other, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined$1;
	      var result = customizer ? customizer(value, other) : undefined$1;
	      return result === undefined$1 ? baseIsEqual(value, other, undefined$1, customizer) : !!result;
	    }
	    function isError(value) {
	      if (!isObjectLike(value)) {
	        return false;
	      }
	      var tag = baseGetTag(value);
	      return tag == errorTag || tag == domExcTag ||
	        (typeof value.message == 'string' && typeof value.name == 'string' && !isPlainObject(value));
	    }
	    function isFinite(value) {
	      return typeof value == 'number' && nativeIsFinite(value);
	    }
	    function isFunction(value) {
	      if (!isObject(value)) {
	        return false;
	      }
	      var tag = baseGetTag(value);
	      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
	    }
	    function isInteger(value) {
	      return typeof value == 'number' && value == toInteger(value);
	    }
	    function isLength(value) {
	      return typeof value == 'number' &&
	        value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
	    }
	    function isObject(value) {
	      var type = typeof value;
	      return value != null && (type == 'object' || type == 'function');
	    }
	    function isObjectLike(value) {
	      return value != null && typeof value == 'object';
	    }
	    var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
	    function isMatch(object, source) {
	      return object === source || baseIsMatch(object, source, getMatchData(source));
	    }
	    function isMatchWith(object, source, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined$1;
	      return baseIsMatch(object, source, getMatchData(source), customizer);
	    }
	    function isNaN(value) {
	      return isNumber(value) && value != +value;
	    }
	    function isNative(value) {
	      if (isMaskable(value)) {
	        throw new Error(CORE_ERROR_TEXT);
	      }
	      return baseIsNative(value);
	    }
	    function isNull(value) {
	      return value === null;
	    }
	    function isNil(value) {
	      return value == null;
	    }
	    function isNumber(value) {
	      return typeof value == 'number' ||
	        (isObjectLike(value) && baseGetTag(value) == numberTag);
	    }
	    function isPlainObject(value) {
	      if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
	        return false;
	      }
	      var proto = getPrototype(value);
	      if (proto === null) {
	        return true;
	      }
	      var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
	      return typeof Ctor == 'function' && Ctor instanceof Ctor &&
	        funcToString.call(Ctor) == objectCtorString;
	    }
	    var isRegExp = nodeIsRegExp ? baseUnary(nodeIsRegExp) : baseIsRegExp;
	    function isSafeInteger(value) {
	      return isInteger(value) && value >= -MAX_SAFE_INTEGER && value <= MAX_SAFE_INTEGER;
	    }
	    var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
	    function isString(value) {
	      return typeof value == 'string' ||
	        (!isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag);
	    }
	    function isSymbol(value) {
	      return typeof value == 'symbol' ||
	        (isObjectLike(value) && baseGetTag(value) == symbolTag);
	    }
	    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
	    function isUndefined(value) {
	      return value === undefined$1;
	    }
	    function isWeakMap(value) {
	      return isObjectLike(value) && getTag(value) == weakMapTag;
	    }
	    function isWeakSet(value) {
	      return isObjectLike(value) && baseGetTag(value) == weakSetTag;
	    }
	    var lt = createRelationalOperation(baseLt);
	    var lte = createRelationalOperation(function(value, other) {
	      return value <= other;
	    });
	    function toArray(value) {
	      if (!value) {
	        return [];
	      }
	      if (isArrayLike(value)) {
	        return isString(value) ? stringToArray(value) : copyArray(value);
	      }
	      if (symIterator && value[symIterator]) {
	        return iteratorToArray(value[symIterator]());
	      }
	      var tag = getTag(value),
	          func = tag == mapTag ? mapToArray : (tag == setTag ? setToArray : values);
	      return func(value);
	    }
	    function toFinite(value) {
	      if (!value) {
	        return value === 0 ? value : 0;
	      }
	      value = toNumber(value);
	      if (value === INFINITY || value === -INFINITY) {
	        var sign = (value < 0 ? -1 : 1);
	        return sign * MAX_INTEGER;
	      }
	      return value === value ? value : 0;
	    }
	    function toInteger(value) {
	      var result = toFinite(value),
	          remainder = result % 1;
	      return result === result ? (remainder ? result - remainder : result) : 0;
	    }
	    function toLength(value) {
	      return value ? baseClamp(toInteger(value), 0, MAX_ARRAY_LENGTH) : 0;
	    }
	    function toNumber(value) {
	      if (typeof value == 'number') {
	        return value;
	      }
	      if (isSymbol(value)) {
	        return NAN;
	      }
	      if (isObject(value)) {
	        var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
	        value = isObject(other) ? (other + '') : other;
	      }
	      if (typeof value != 'string') {
	        return value === 0 ? value : +value;
	      }
	      value = baseTrim(value);
	      var isBinary = reIsBinary.test(value);
	      return (isBinary || reIsOctal.test(value))
	        ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
	        : (reIsBadHex.test(value) ? NAN : +value);
	    }
	    function toPlainObject(value) {
	      return copyObject(value, keysIn(value));
	    }
	    function toSafeInteger(value) {
	      return value
	        ? baseClamp(toInteger(value), -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER)
	        : (value === 0 ? value : 0);
	    }
	    function toString(value) {
	      return value == null ? '' : baseToString(value);
	    }
	    var assign = createAssigner(function(object, source) {
	      if (isPrototype(source) || isArrayLike(source)) {
	        copyObject(source, keys(source), object);
	        return;
	      }
	      for (var key in source) {
	        if (hasOwnProperty.call(source, key)) {
	          assignValue(object, key, source[key]);
	        }
	      }
	    });
	    var assignIn = createAssigner(function(object, source) {
	      copyObject(source, keysIn(source), object);
	    });
	    var assignInWith = createAssigner(function(object, source, srcIndex, customizer) {
	      copyObject(source, keysIn(source), object, customizer);
	    });
	    var assignWith = createAssigner(function(object, source, srcIndex, customizer) {
	      copyObject(source, keys(source), object, customizer);
	    });
	    var at = flatRest(baseAt);
	    function create(prototype, properties) {
	      var result = baseCreate(prototype);
	      return properties == null ? result : baseAssign(result, properties);
	    }
	    var defaults = baseRest(function(object, sources) {
	      object = Object(object);
	      var index = -1;
	      var length = sources.length;
	      var guard = length > 2 ? sources[2] : undefined$1;
	      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
	        length = 1;
	      }
	      while (++index < length) {
	        var source = sources[index];
	        var props = keysIn(source);
	        var propsIndex = -1;
	        var propsLength = props.length;
	        while (++propsIndex < propsLength) {
	          var key = props[propsIndex];
	          var value = object[key];
	          if (value === undefined$1 ||
	              (eq(value, objectProto[key]) && !hasOwnProperty.call(object, key))) {
	            object[key] = source[key];
	          }
	        }
	      }
	      return object;
	    });
	    var defaultsDeep = baseRest(function(args) {
	      args.push(undefined$1, customDefaultsMerge);
	      return apply(mergeWith, undefined$1, args);
	    });
	    function findKey(object, predicate) {
	      return baseFindKey(object, getIteratee(predicate, 3), baseForOwn);
	    }
	    function findLastKey(object, predicate) {
	      return baseFindKey(object, getIteratee(predicate, 3), baseForOwnRight);
	    }
	    function forIn(object, iteratee) {
	      return object == null
	        ? object
	        : baseFor(object, getIteratee(iteratee, 3), keysIn);
	    }
	    function forInRight(object, iteratee) {
	      return object == null
	        ? object
	        : baseForRight(object, getIteratee(iteratee, 3), keysIn);
	    }
	    function forOwn(object, iteratee) {
	      return object && baseForOwn(object, getIteratee(iteratee, 3));
	    }
	    function forOwnRight(object, iteratee) {
	      return object && baseForOwnRight(object, getIteratee(iteratee, 3));
	    }
	    function functions(object) {
	      return object == null ? [] : baseFunctions(object, keys(object));
	    }
	    function functionsIn(object) {
	      return object == null ? [] : baseFunctions(object, keysIn(object));
	    }
	    function get(object, path, defaultValue) {
	      var result = object == null ? undefined$1 : baseGet(object, path);
	      return result === undefined$1 ? defaultValue : result;
	    }
	    function has(object, path) {
	      return object != null && hasPath(object, path, baseHas);
	    }
	    function hasIn(object, path) {
	      return object != null && hasPath(object, path, baseHasIn);
	    }
	    var invert = createInverter(function(result, value, key) {
	      if (value != null &&
	          typeof value.toString != 'function') {
	        value = nativeObjectToString.call(value);
	      }
	      result[value] = key;
	    }, constant(identity));
	    var invertBy = createInverter(function(result, value, key) {
	      if (value != null &&
	          typeof value.toString != 'function') {
	        value = nativeObjectToString.call(value);
	      }
	      if (hasOwnProperty.call(result, value)) {
	        result[value].push(key);
	      } else {
	        result[value] = [key];
	      }
	    }, getIteratee);
	    var invoke = baseRest(baseInvoke);
	    function keys(object) {
	      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
	    }
	    function keysIn(object) {
	      return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
	    }
	    function mapKeys(object, iteratee) {
	      var result = {};
	      iteratee = getIteratee(iteratee, 3);
	      baseForOwn(object, function(value, key, object) {
	        baseAssignValue(result, iteratee(value, key, object), value);
	      });
	      return result;
	    }
	    function mapValues(object, iteratee) {
	      var result = {};
	      iteratee = getIteratee(iteratee, 3);
	      baseForOwn(object, function(value, key, object) {
	        baseAssignValue(result, key, iteratee(value, key, object));
	      });
	      return result;
	    }
	    var merge = createAssigner(function(object, source, srcIndex) {
	      baseMerge(object, source, srcIndex);
	    });
	    var mergeWith = createAssigner(function(object, source, srcIndex, customizer) {
	      baseMerge(object, source, srcIndex, customizer);
	    });
	    var omit = flatRest(function(object, paths) {
	      var result = {};
	      if (object == null) {
	        return result;
	      }
	      var isDeep = false;
	      paths = arrayMap(paths, function(path) {
	        path = castPath(path, object);
	        isDeep || (isDeep = path.length > 1);
	        return path;
	      });
	      copyObject(object, getAllKeysIn(object), result);
	      if (isDeep) {
	        result = baseClone(result, CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG, customOmitClone);
	      }
	      var length = paths.length;
	      while (length--) {
	        baseUnset(result, paths[length]);
	      }
	      return result;
	    });
	    function omitBy(object, predicate) {
	      return pickBy(object, negate(getIteratee(predicate)));
	    }
	    var pick = flatRest(function(object, paths) {
	      return object == null ? {} : basePick(object, paths);
	    });
	    function pickBy(object, predicate) {
	      if (object == null) {
	        return {};
	      }
	      var props = arrayMap(getAllKeysIn(object), function(prop) {
	        return [prop];
	      });
	      predicate = getIteratee(predicate);
	      return basePickBy(object, props, function(value, path) {
	        return predicate(value, path[0]);
	      });
	    }
	    function result(object, path, defaultValue) {
	      path = castPath(path, object);
	      var index = -1,
	          length = path.length;
	      if (!length) {
	        length = 1;
	        object = undefined$1;
	      }
	      while (++index < length) {
	        var value = object == null ? undefined$1 : object[toKey(path[index])];
	        if (value === undefined$1) {
	          index = length;
	          value = defaultValue;
	        }
	        object = isFunction(value) ? value.call(object) : value;
	      }
	      return object;
	    }
	    function set(object, path, value) {
	      return object == null ? object : baseSet(object, path, value);
	    }
	    function setWith(object, path, value, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined$1;
	      return object == null ? object : baseSet(object, path, value, customizer);
	    }
	    var toPairs = createToPairs(keys);
	    var toPairsIn = createToPairs(keysIn);
	    function transform(object, iteratee, accumulator) {
	      var isArr = isArray(object),
	          isArrLike = isArr || isBuffer(object) || isTypedArray(object);
	      iteratee = getIteratee(iteratee, 4);
	      if (accumulator == null) {
	        var Ctor = object && object.constructor;
	        if (isArrLike) {
	          accumulator = isArr ? new Ctor : [];
	        }
	        else if (isObject(object)) {
	          accumulator = isFunction(Ctor) ? baseCreate(getPrototype(object)) : {};
	        }
	        else {
	          accumulator = {};
	        }
	      }
	      (isArrLike ? arrayEach : baseForOwn)(object, function(value, index, object) {
	        return iteratee(accumulator, value, index, object);
	      });
	      return accumulator;
	    }
	    function unset(object, path) {
	      return object == null ? true : baseUnset(object, path);
	    }
	    function update(object, path, updater) {
	      return object == null ? object : baseUpdate(object, path, castFunction(updater));
	    }
	    function updateWith(object, path, updater, customizer) {
	      customizer = typeof customizer == 'function' ? customizer : undefined$1;
	      return object == null ? object : baseUpdate(object, path, castFunction(updater), customizer);
	    }
	    function values(object) {
	      return object == null ? [] : baseValues(object, keys(object));
	    }
	    function valuesIn(object) {
	      return object == null ? [] : baseValues(object, keysIn(object));
	    }
	    function clamp(number, lower, upper) {
	      if (upper === undefined$1) {
	        upper = lower;
	        lower = undefined$1;
	      }
	      if (upper !== undefined$1) {
	        upper = toNumber(upper);
	        upper = upper === upper ? upper : 0;
	      }
	      if (lower !== undefined$1) {
	        lower = toNumber(lower);
	        lower = lower === lower ? lower : 0;
	      }
	      return baseClamp(toNumber(number), lower, upper);
	    }
	    function inRange(number, start, end) {
	      start = toFinite(start);
	      if (end === undefined$1) {
	        end = start;
	        start = 0;
	      } else {
	        end = toFinite(end);
	      }
	      number = toNumber(number);
	      return baseInRange(number, start, end);
	    }
	    function random(lower, upper, floating) {
	      if (floating && typeof floating != 'boolean' && isIterateeCall(lower, upper, floating)) {
	        upper = floating = undefined$1;
	      }
	      if (floating === undefined$1) {
	        if (typeof upper == 'boolean') {
	          floating = upper;
	          upper = undefined$1;
	        }
	        else if (typeof lower == 'boolean') {
	          floating = lower;
	          lower = undefined$1;
	        }
	      }
	      if (lower === undefined$1 && upper === undefined$1) {
	        lower = 0;
	        upper = 1;
	      }
	      else {
	        lower = toFinite(lower);
	        if (upper === undefined$1) {
	          upper = lower;
	          lower = 0;
	        } else {
	          upper = toFinite(upper);
	        }
	      }
	      if (lower > upper) {
	        var temp = lower;
	        lower = upper;
	        upper = temp;
	      }
	      if (floating || lower % 1 || upper % 1) {
	        var rand = nativeRandom();
	        return nativeMin(lower + (rand * (upper - lower + freeParseFloat('1e-' + ((rand + '').length - 1)))), upper);
	      }
	      return baseRandom(lower, upper);
	    }
	    var camelCase = createCompounder(function(result, word, index) {
	      word = word.toLowerCase();
	      return result + (index ? capitalize(word) : word);
	    });
	    function capitalize(string) {
	      return upperFirst(toString(string).toLowerCase());
	    }
	    function deburr(string) {
	      string = toString(string);
	      return string && string.replace(reLatin, deburrLetter).replace(reComboMark, '');
	    }
	    function endsWith(string, target, position) {
	      string = toString(string);
	      target = baseToString(target);
	      var length = string.length;
	      position = position === undefined$1
	        ? length
	        : baseClamp(toInteger(position), 0, length);
	      var end = position;
	      position -= target.length;
	      return position >= 0 && string.slice(position, end) == target;
	    }
	    function escape(string) {
	      string = toString(string);
	      return (string && reHasUnescapedHtml.test(string))
	        ? string.replace(reUnescapedHtml, escapeHtmlChar)
	        : string;
	    }
	    function escapeRegExp(string) {
	      string = toString(string);
	      return (string && reHasRegExpChar.test(string))
	        ? string.replace(reRegExpChar, '\\$&')
	        : string;
	    }
	    var kebabCase = createCompounder(function(result, word, index) {
	      return result + (index ? '-' : '') + word.toLowerCase();
	    });
	    var lowerCase = createCompounder(function(result, word, index) {
	      return result + (index ? ' ' : '') + word.toLowerCase();
	    });
	    var lowerFirst = createCaseFirst('toLowerCase');
	    function pad(string, length, chars) {
	      string = toString(string);
	      length = toInteger(length);
	      var strLength = length ? stringSize(string) : 0;
	      if (!length || strLength >= length) {
	        return string;
	      }
	      var mid = (length - strLength) / 2;
	      return (
	        createPadding(nativeFloor(mid), chars) +
	        string +
	        createPadding(nativeCeil(mid), chars)
	      );
	    }
	    function padEnd(string, length, chars) {
	      string = toString(string);
	      length = toInteger(length);
	      var strLength = length ? stringSize(string) : 0;
	      return (length && strLength < length)
	        ? (string + createPadding(length - strLength, chars))
	        : string;
	    }
	    function padStart(string, length, chars) {
	      string = toString(string);
	      length = toInteger(length);
	      var strLength = length ? stringSize(string) : 0;
	      return (length && strLength < length)
	        ? (createPadding(length - strLength, chars) + string)
	        : string;
	    }
	    function parseInt(string, radix, guard) {
	      if (guard || radix == null) {
	        radix = 0;
	      } else if (radix) {
	        radix = +radix;
	      }
	      return nativeParseInt(toString(string).replace(reTrimStart, ''), radix || 0);
	    }
	    function repeat(string, n, guard) {
	      if ((guard ? isIterateeCall(string, n, guard) : n === undefined$1)) {
	        n = 1;
	      } else {
	        n = toInteger(n);
	      }
	      return baseRepeat(toString(string), n);
	    }
	    function replace() {
	      var args = arguments,
	          string = toString(args[0]);
	      return args.length < 3 ? string : string.replace(args[1], args[2]);
	    }
	    var snakeCase = createCompounder(function(result, word, index) {
	      return result + (index ? '_' : '') + word.toLowerCase();
	    });
	    function split(string, separator, limit) {
	      if (limit && typeof limit != 'number' && isIterateeCall(string, separator, limit)) {
	        separator = limit = undefined$1;
	      }
	      limit = limit === undefined$1 ? MAX_ARRAY_LENGTH : limit >>> 0;
	      if (!limit) {
	        return [];
	      }
	      string = toString(string);
	      if (string && (
	            typeof separator == 'string' ||
	            (separator != null && !isRegExp(separator))
	          )) {
	        separator = baseToString(separator);
	        if (!separator && hasUnicode(string)) {
	          return castSlice(stringToArray(string), 0, limit);
	        }
	      }
	      return string.split(separator, limit);
	    }
	    var startCase = createCompounder(function(result, word, index) {
	      return result + (index ? ' ' : '') + upperFirst(word);
	    });
	    function startsWith(string, target, position) {
	      string = toString(string);
	      position = position == null
	        ? 0
	        : baseClamp(toInteger(position), 0, string.length);
	      target = baseToString(target);
	      return string.slice(position, position + target.length) == target;
	    }
	    function template(string, options, guard) {
	      var settings = lodash.templateSettings;
	      if (guard && isIterateeCall(string, options, guard)) {
	        options = undefined$1;
	      }
	      string = toString(string);
	      options = assignInWith({}, options, settings, customDefaultsAssignIn);
	      var imports = assignInWith({}, options.imports, settings.imports, customDefaultsAssignIn),
	          importsKeys = keys(imports),
	          importsValues = baseValues(imports, importsKeys);
	      var isEscaping,
	          isEvaluating,
	          index = 0,
	          interpolate = options.interpolate || reNoMatch,
	          source = "__p += '";
	      var reDelimiters = RegExp(
	        (options.escape || reNoMatch).source + '|' +
	        interpolate.source + '|' +
	        (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + '|' +
	        (options.evaluate || reNoMatch).source + '|$'
	      , 'g');
	      var sourceURL = '//# sourceURL=' +
	        (hasOwnProperty.call(options, 'sourceURL')
	          ? (options.sourceURL + '').replace(/\s/g, ' ')
	          : ('lodash.templateSources[' + (++templateCounter) + ']')
	        ) + '\n';
	      string.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
	        interpolateValue || (interpolateValue = esTemplateValue);
	        source += string.slice(index, offset).replace(reUnescapedString, escapeStringChar);
	        if (escapeValue) {
	          isEscaping = true;
	          source += "' +\n__e(" + escapeValue + ") +\n'";
	        }
	        if (evaluateValue) {
	          isEvaluating = true;
	          source += "';\n" + evaluateValue + ";\n__p += '";
	        }
	        if (interpolateValue) {
	          source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
	        }
	        index = offset + match.length;
	        return match;
	      });
	      source += "';\n";
	      var variable = hasOwnProperty.call(options, 'variable') && options.variable;
	      if (!variable) {
	        source = 'with (obj) {\n' + source + '\n}\n';
	      }
	      else if (reForbiddenIdentifierChars.test(variable)) {
	        throw new Error(INVALID_TEMPL_VAR_ERROR_TEXT);
	      }
	      source = (isEvaluating ? source.replace(reEmptyStringLeading, '') : source)
	        .replace(reEmptyStringMiddle, '$1')
	        .replace(reEmptyStringTrailing, '$1;');
	      source = 'function(' + (variable || 'obj') + ') {\n' +
	        (variable
	          ? ''
	          : 'obj || (obj = {});\n'
	        ) +
	        "var __t, __p = ''" +
	        (isEscaping
	           ? ', __e = _.escape'
	           : ''
	        ) +
	        (isEvaluating
	          ? ', __j = Array.prototype.join;\n' +
	            "function print() { __p += __j.call(arguments, '') }\n"
	          : ';\n'
	        ) +
	        source +
	        'return __p\n}';
	      var result = attempt(function() {
	        return Function(importsKeys, sourceURL + 'return ' + source)
	          .apply(undefined$1, importsValues);
	      });
	      result.source = source;
	      if (isError(result)) {
	        throw result;
	      }
	      return result;
	    }
	    function toLower(value) {
	      return toString(value).toLowerCase();
	    }
	    function toUpper(value) {
	      return toString(value).toUpperCase();
	    }
	    function trim(string, chars, guard) {
	      string = toString(string);
	      if (string && (guard || chars === undefined$1)) {
	        return baseTrim(string);
	      }
	      if (!string || !(chars = baseToString(chars))) {
	        return string;
	      }
	      var strSymbols = stringToArray(string),
	          chrSymbols = stringToArray(chars),
	          start = charsStartIndex(strSymbols, chrSymbols),
	          end = charsEndIndex(strSymbols, chrSymbols) + 1;
	      return castSlice(strSymbols, start, end).join('');
	    }
	    function trimEnd(string, chars, guard) {
	      string = toString(string);
	      if (string && (guard || chars === undefined$1)) {
	        return string.slice(0, trimmedEndIndex(string) + 1);
	      }
	      if (!string || !(chars = baseToString(chars))) {
	        return string;
	      }
	      var strSymbols = stringToArray(string),
	          end = charsEndIndex(strSymbols, stringToArray(chars)) + 1;
	      return castSlice(strSymbols, 0, end).join('');
	    }
	    function trimStart(string, chars, guard) {
	      string = toString(string);
	      if (string && (guard || chars === undefined$1)) {
	        return string.replace(reTrimStart, '');
	      }
	      if (!string || !(chars = baseToString(chars))) {
	        return string;
	      }
	      var strSymbols = stringToArray(string),
	          start = charsStartIndex(strSymbols, stringToArray(chars));
	      return castSlice(strSymbols, start).join('');
	    }
	    function truncate(string, options) {
	      var length = DEFAULT_TRUNC_LENGTH,
	          omission = DEFAULT_TRUNC_OMISSION;
	      if (isObject(options)) {
	        var separator = 'separator' in options ? options.separator : separator;
	        length = 'length' in options ? toInteger(options.length) : length;
	        omission = 'omission' in options ? baseToString(options.omission) : omission;
	      }
	      string = toString(string);
	      var strLength = string.length;
	      if (hasUnicode(string)) {
	        var strSymbols = stringToArray(string);
	        strLength = strSymbols.length;
	      }
	      if (length >= strLength) {
	        return string;
	      }
	      var end = length - stringSize(omission);
	      if (end < 1) {
	        return omission;
	      }
	      var result = strSymbols
	        ? castSlice(strSymbols, 0, end).join('')
	        : string.slice(0, end);
	      if (separator === undefined$1) {
	        return result + omission;
	      }
	      if (strSymbols) {
	        end += (result.length - end);
	      }
	      if (isRegExp(separator)) {
	        if (string.slice(end).search(separator)) {
	          var match,
	              substring = result;
	          if (!separator.global) {
	            separator = RegExp(separator.source, toString(reFlags.exec(separator)) + 'g');
	          }
	          separator.lastIndex = 0;
	          while ((match = separator.exec(substring))) {
	            var newEnd = match.index;
	          }
	          result = result.slice(0, newEnd === undefined$1 ? end : newEnd);
	        }
	      } else if (string.indexOf(baseToString(separator), end) != end) {
	        var index = result.lastIndexOf(separator);
	        if (index > -1) {
	          result = result.slice(0, index);
	        }
	      }
	      return result + omission;
	    }
	    function unescape(string) {
	      string = toString(string);
	      return (string && reHasEscapedHtml.test(string))
	        ? string.replace(reEscapedHtml, unescapeHtmlChar)
	        : string;
	    }
	    var upperCase = createCompounder(function(result, word, index) {
	      return result + (index ? ' ' : '') + word.toUpperCase();
	    });
	    var upperFirst = createCaseFirst('toUpperCase');
	    function words(string, pattern, guard) {
	      string = toString(string);
	      pattern = guard ? undefined$1 : pattern;
	      if (pattern === undefined$1) {
	        return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
	      }
	      return string.match(pattern) || [];
	    }
	    var attempt = baseRest(function(func, args) {
	      try {
	        return apply(func, undefined$1, args);
	      } catch (e) {
	        return isError(e) ? e : new Error(e);
	      }
	    });
	    var bindAll = flatRest(function(object, methodNames) {
	      arrayEach(methodNames, function(key) {
	        key = toKey(key);
	        baseAssignValue(object, key, bind(object[key], object));
	      });
	      return object;
	    });
	    function cond(pairs) {
	      var length = pairs == null ? 0 : pairs.length,
	          toIteratee = getIteratee();
	      pairs = !length ? [] : arrayMap(pairs, function(pair) {
	        if (typeof pair[1] != 'function') {
	          throw new TypeError(FUNC_ERROR_TEXT);
	        }
	        return [toIteratee(pair[0]), pair[1]];
	      });
	      return baseRest(function(args) {
	        var index = -1;
	        while (++index < length) {
	          var pair = pairs[index];
	          if (apply(pair[0], this, args)) {
	            return apply(pair[1], this, args);
	          }
	        }
	      });
	    }
	    function conforms(source) {
	      return baseConforms(baseClone(source, CLONE_DEEP_FLAG));
	    }
	    function constant(value) {
	      return function() {
	        return value;
	      };
	    }
	    function defaultTo(value, defaultValue) {
	      return (value == null || value !== value) ? defaultValue : value;
	    }
	    var flow = createFlow();
	    var flowRight = createFlow(true);
	    function identity(value) {
	      return value;
	    }
	    function iteratee(func) {
	      return baseIteratee(typeof func == 'function' ? func : baseClone(func, CLONE_DEEP_FLAG));
	    }
	    function matches(source) {
	      return baseMatches(baseClone(source, CLONE_DEEP_FLAG));
	    }
	    function matchesProperty(path, srcValue) {
	      return baseMatchesProperty(path, baseClone(srcValue, CLONE_DEEP_FLAG));
	    }
	    var method = baseRest(function(path, args) {
	      return function(object) {
	        return baseInvoke(object, path, args);
	      };
	    });
	    var methodOf = baseRest(function(object, args) {
	      return function(path) {
	        return baseInvoke(object, path, args);
	      };
	    });
	    function mixin(object, source, options) {
	      var props = keys(source),
	          methodNames = baseFunctions(source, props);
	      if (options == null &&
	          !(isObject(source) && (methodNames.length || !props.length))) {
	        options = source;
	        source = object;
	        object = this;
	        methodNames = baseFunctions(source, keys(source));
	      }
	      var chain = !(isObject(options) && 'chain' in options) || !!options.chain,
	          isFunc = isFunction(object);
	      arrayEach(methodNames, function(methodName) {
	        var func = source[methodName];
	        object[methodName] = func;
	        if (isFunc) {
	          object.prototype[methodName] = function() {
	            var chainAll = this.__chain__;
	            if (chain || chainAll) {
	              var result = object(this.__wrapped__),
	                  actions = result.__actions__ = copyArray(this.__actions__);
	              actions.push({ 'func': func, 'args': arguments, 'thisArg': object });
	              result.__chain__ = chainAll;
	              return result;
	            }
	            return func.apply(object, arrayPush([this.value()], arguments));
	          };
	        }
	      });
	      return object;
	    }
	    function noConflict() {
	      if (root._ === this) {
	        root._ = oldDash;
	      }
	      return this;
	    }
	    function noop() {
	    }
	    function nthArg(n) {
	      n = toInteger(n);
	      return baseRest(function(args) {
	        return baseNth(args, n);
	      });
	    }
	    var over = createOver(arrayMap);
	    var overEvery = createOver(arrayEvery);
	    var overSome = createOver(arraySome);
	    function property(path) {
	      return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
	    }
	    function propertyOf(object) {
	      return function(path) {
	        return object == null ? undefined$1 : baseGet(object, path);
	      };
	    }
	    var range = createRange();
	    var rangeRight = createRange(true);
	    function stubArray() {
	      return [];
	    }
	    function stubFalse() {
	      return false;
	    }
	    function stubObject() {
	      return {};
	    }
	    function stubString() {
	      return '';
	    }
	    function stubTrue() {
	      return true;
	    }
	    function times(n, iteratee) {
	      n = toInteger(n);
	      if (n < 1 || n > MAX_SAFE_INTEGER) {
	        return [];
	      }
	      var index = MAX_ARRAY_LENGTH,
	          length = nativeMin(n, MAX_ARRAY_LENGTH);
	      iteratee = getIteratee(iteratee);
	      n -= MAX_ARRAY_LENGTH;
	      var result = baseTimes(length, iteratee);
	      while (++index < n) {
	        iteratee(index);
	      }
	      return result;
	    }
	    function toPath(value) {
	      if (isArray(value)) {
	        return arrayMap(value, toKey);
	      }
	      return isSymbol(value) ? [value] : copyArray(stringToPath(toString(value)));
	    }
	    function uniqueId(prefix) {
	      var id = ++idCounter;
	      return toString(prefix) + id;
	    }
	    var add = createMathOperation(function(augend, addend) {
	      return augend + addend;
	    }, 0);
	    var ceil = createRound('ceil');
	    var divide = createMathOperation(function(dividend, divisor) {
	      return dividend / divisor;
	    }, 1);
	    var floor = createRound('floor');
	    function max(array) {
	      return (array && array.length)
	        ? baseExtremum(array, identity, baseGt)
	        : undefined$1;
	    }
	    function maxBy(array, iteratee) {
	      return (array && array.length)
	        ? baseExtremum(array, getIteratee(iteratee, 2), baseGt)
	        : undefined$1;
	    }
	    function mean(array) {
	      return baseMean(array, identity);
	    }
	    function meanBy(array, iteratee) {
	      return baseMean(array, getIteratee(iteratee, 2));
	    }
	    function min(array) {
	      return (array && array.length)
	        ? baseExtremum(array, identity, baseLt)
	        : undefined$1;
	    }
	    function minBy(array, iteratee) {
	      return (array && array.length)
	        ? baseExtremum(array, getIteratee(iteratee, 2), baseLt)
	        : undefined$1;
	    }
	    var multiply = createMathOperation(function(multiplier, multiplicand) {
	      return multiplier * multiplicand;
	    }, 1);
	    var round = createRound('round');
	    var subtract = createMathOperation(function(minuend, subtrahend) {
	      return minuend - subtrahend;
	    }, 0);
	    function sum(array) {
	      return (array && array.length)
	        ? baseSum(array, identity)
	        : 0;
	    }
	    function sumBy(array, iteratee) {
	      return (array && array.length)
	        ? baseSum(array, getIteratee(iteratee, 2))
	        : 0;
	    }
	    lodash.after = after;
	    lodash.ary = ary;
	    lodash.assign = assign;
	    lodash.assignIn = assignIn;
	    lodash.assignInWith = assignInWith;
	    lodash.assignWith = assignWith;
	    lodash.at = at;
	    lodash.before = before;
	    lodash.bind = bind;
	    lodash.bindAll = bindAll;
	    lodash.bindKey = bindKey;
	    lodash.castArray = castArray;
	    lodash.chain = chain;
	    lodash.chunk = chunk;
	    lodash.compact = compact;
	    lodash.concat = concat;
	    lodash.cond = cond;
	    lodash.conforms = conforms;
	    lodash.constant = constant;
	    lodash.countBy = countBy;
	    lodash.create = create;
	    lodash.curry = curry;
	    lodash.curryRight = curryRight;
	    lodash.debounce = debounce;
	    lodash.defaults = defaults;
	    lodash.defaultsDeep = defaultsDeep;
	    lodash.defer = defer;
	    lodash.delay = delay;
	    lodash.difference = difference;
	    lodash.differenceBy = differenceBy;
	    lodash.differenceWith = differenceWith;
	    lodash.drop = drop;
	    lodash.dropRight = dropRight;
	    lodash.dropRightWhile = dropRightWhile;
	    lodash.dropWhile = dropWhile;
	    lodash.fill = fill;
	    lodash.filter = filter;
	    lodash.flatMap = flatMap;
	    lodash.flatMapDeep = flatMapDeep;
	    lodash.flatMapDepth = flatMapDepth;
	    lodash.flatten = flatten;
	    lodash.flattenDeep = flattenDeep;
	    lodash.flattenDepth = flattenDepth;
	    lodash.flip = flip;
	    lodash.flow = flow;
	    lodash.flowRight = flowRight;
	    lodash.fromPairs = fromPairs;
	    lodash.functions = functions;
	    lodash.functionsIn = functionsIn;
	    lodash.groupBy = groupBy;
	    lodash.initial = initial;
	    lodash.intersection = intersection;
	    lodash.intersectionBy = intersectionBy;
	    lodash.intersectionWith = intersectionWith;
	    lodash.invert = invert;
	    lodash.invertBy = invertBy;
	    lodash.invokeMap = invokeMap;
	    lodash.iteratee = iteratee;
	    lodash.keyBy = keyBy;
	    lodash.keys = keys;
	    lodash.keysIn = keysIn;
	    lodash.map = map;
	    lodash.mapKeys = mapKeys;
	    lodash.mapValues = mapValues;
	    lodash.matches = matches;
	    lodash.matchesProperty = matchesProperty;
	    lodash.memoize = memoize;
	    lodash.merge = merge;
	    lodash.mergeWith = mergeWith;
	    lodash.method = method;
	    lodash.methodOf = methodOf;
	    lodash.mixin = mixin;
	    lodash.negate = negate;
	    lodash.nthArg = nthArg;
	    lodash.omit = omit;
	    lodash.omitBy = omitBy;
	    lodash.once = once;
	    lodash.orderBy = orderBy;
	    lodash.over = over;
	    lodash.overArgs = overArgs;
	    lodash.overEvery = overEvery;
	    lodash.overSome = overSome;
	    lodash.partial = partial;
	    lodash.partialRight = partialRight;
	    lodash.partition = partition;
	    lodash.pick = pick;
	    lodash.pickBy = pickBy;
	    lodash.property = property;
	    lodash.propertyOf = propertyOf;
	    lodash.pull = pull;
	    lodash.pullAll = pullAll;
	    lodash.pullAllBy = pullAllBy;
	    lodash.pullAllWith = pullAllWith;
	    lodash.pullAt = pullAt;
	    lodash.range = range;
	    lodash.rangeRight = rangeRight;
	    lodash.rearg = rearg;
	    lodash.reject = reject;
	    lodash.remove = remove;
	    lodash.rest = rest;
	    lodash.reverse = reverse;
	    lodash.sampleSize = sampleSize;
	    lodash.set = set;
	    lodash.setWith = setWith;
	    lodash.shuffle = shuffle;
	    lodash.slice = slice;
	    lodash.sortBy = sortBy;
	    lodash.sortedUniq = sortedUniq;
	    lodash.sortedUniqBy = sortedUniqBy;
	    lodash.split = split;
	    lodash.spread = spread;
	    lodash.tail = tail;
	    lodash.take = take;
	    lodash.takeRight = takeRight;
	    lodash.takeRightWhile = takeRightWhile;
	    lodash.takeWhile = takeWhile;
	    lodash.tap = tap;
	    lodash.throttle = throttle;
	    lodash.thru = thru;
	    lodash.toArray = toArray;
	    lodash.toPairs = toPairs;
	    lodash.toPairsIn = toPairsIn;
	    lodash.toPath = toPath;
	    lodash.toPlainObject = toPlainObject;
	    lodash.transform = transform;
	    lodash.unary = unary;
	    lodash.union = union;
	    lodash.unionBy = unionBy;
	    lodash.unionWith = unionWith;
	    lodash.uniq = uniq;
	    lodash.uniqBy = uniqBy;
	    lodash.uniqWith = uniqWith;
	    lodash.unset = unset;
	    lodash.unzip = unzip;
	    lodash.unzipWith = unzipWith;
	    lodash.update = update;
	    lodash.updateWith = updateWith;
	    lodash.values = values;
	    lodash.valuesIn = valuesIn;
	    lodash.without = without;
	    lodash.words = words;
	    lodash.wrap = wrap;
	    lodash.xor = xor;
	    lodash.xorBy = xorBy;
	    lodash.xorWith = xorWith;
	    lodash.zip = zip;
	    lodash.zipObject = zipObject;
	    lodash.zipObjectDeep = zipObjectDeep;
	    lodash.zipWith = zipWith;
	    lodash.entries = toPairs;
	    lodash.entriesIn = toPairsIn;
	    lodash.extend = assignIn;
	    lodash.extendWith = assignInWith;
	    mixin(lodash, lodash);
	    lodash.add = add;
	    lodash.attempt = attempt;
	    lodash.camelCase = camelCase;
	    lodash.capitalize = capitalize;
	    lodash.ceil = ceil;
	    lodash.clamp = clamp;
	    lodash.clone = clone;
	    lodash.cloneDeep = cloneDeep;
	    lodash.cloneDeepWith = cloneDeepWith;
	    lodash.cloneWith = cloneWith;
	    lodash.conformsTo = conformsTo;
	    lodash.deburr = deburr;
	    lodash.defaultTo = defaultTo;
	    lodash.divide = divide;
	    lodash.endsWith = endsWith;
	    lodash.eq = eq;
	    lodash.escape = escape;
	    lodash.escapeRegExp = escapeRegExp;
	    lodash.every = every;
	    lodash.find = find;
	    lodash.findIndex = findIndex;
	    lodash.findKey = findKey;
	    lodash.findLast = findLast;
	    lodash.findLastIndex = findLastIndex;
	    lodash.findLastKey = findLastKey;
	    lodash.floor = floor;
	    lodash.forEach = forEach;
	    lodash.forEachRight = forEachRight;
	    lodash.forIn = forIn;
	    lodash.forInRight = forInRight;
	    lodash.forOwn = forOwn;
	    lodash.forOwnRight = forOwnRight;
	    lodash.get = get;
	    lodash.gt = gt;
	    lodash.gte = gte;
	    lodash.has = has;
	    lodash.hasIn = hasIn;
	    lodash.head = head;
	    lodash.identity = identity;
	    lodash.includes = includes;
	    lodash.indexOf = indexOf;
	    lodash.inRange = inRange;
	    lodash.invoke = invoke;
	    lodash.isArguments = isArguments;
	    lodash.isArray = isArray;
	    lodash.isArrayBuffer = isArrayBuffer;
	    lodash.isArrayLike = isArrayLike;
	    lodash.isArrayLikeObject = isArrayLikeObject;
	    lodash.isBoolean = isBoolean;
	    lodash.isBuffer = isBuffer;
	    lodash.isDate = isDate;
	    lodash.isElement = isElement;
	    lodash.isEmpty = isEmpty;
	    lodash.isEqual = isEqual;
	    lodash.isEqualWith = isEqualWith;
	    lodash.isError = isError;
	    lodash.isFinite = isFinite;
	    lodash.isFunction = isFunction;
	    lodash.isInteger = isInteger;
	    lodash.isLength = isLength;
	    lodash.isMap = isMap;
	    lodash.isMatch = isMatch;
	    lodash.isMatchWith = isMatchWith;
	    lodash.isNaN = isNaN;
	    lodash.isNative = isNative;
	    lodash.isNil = isNil;
	    lodash.isNull = isNull;
	    lodash.isNumber = isNumber;
	    lodash.isObject = isObject;
	    lodash.isObjectLike = isObjectLike;
	    lodash.isPlainObject = isPlainObject;
	    lodash.isRegExp = isRegExp;
	    lodash.isSafeInteger = isSafeInteger;
	    lodash.isSet = isSet;
	    lodash.isString = isString;
	    lodash.isSymbol = isSymbol;
	    lodash.isTypedArray = isTypedArray;
	    lodash.isUndefined = isUndefined;
	    lodash.isWeakMap = isWeakMap;
	    lodash.isWeakSet = isWeakSet;
	    lodash.join = join;
	    lodash.kebabCase = kebabCase;
	    lodash.last = last;
	    lodash.lastIndexOf = lastIndexOf;
	    lodash.lowerCase = lowerCase;
	    lodash.lowerFirst = lowerFirst;
	    lodash.lt = lt;
	    lodash.lte = lte;
	    lodash.max = max;
	    lodash.maxBy = maxBy;
	    lodash.mean = mean;
	    lodash.meanBy = meanBy;
	    lodash.min = min;
	    lodash.minBy = minBy;
	    lodash.stubArray = stubArray;
	    lodash.stubFalse = stubFalse;
	    lodash.stubObject = stubObject;
	    lodash.stubString = stubString;
	    lodash.stubTrue = stubTrue;
	    lodash.multiply = multiply;
	    lodash.nth = nth;
	    lodash.noConflict = noConflict;
	    lodash.noop = noop;
	    lodash.now = now;
	    lodash.pad = pad;
	    lodash.padEnd = padEnd;
	    lodash.padStart = padStart;
	    lodash.parseInt = parseInt;
	    lodash.random = random;
	    lodash.reduce = reduce;
	    lodash.reduceRight = reduceRight;
	    lodash.repeat = repeat;
	    lodash.replace = replace;
	    lodash.result = result;
	    lodash.round = round;
	    lodash.runInContext = runInContext;
	    lodash.sample = sample;
	    lodash.size = size;
	    lodash.snakeCase = snakeCase;
	    lodash.some = some;
	    lodash.sortedIndex = sortedIndex;
	    lodash.sortedIndexBy = sortedIndexBy;
	    lodash.sortedIndexOf = sortedIndexOf;
	    lodash.sortedLastIndex = sortedLastIndex;
	    lodash.sortedLastIndexBy = sortedLastIndexBy;
	    lodash.sortedLastIndexOf = sortedLastIndexOf;
	    lodash.startCase = startCase;
	    lodash.startsWith = startsWith;
	    lodash.subtract = subtract;
	    lodash.sum = sum;
	    lodash.sumBy = sumBy;
	    lodash.template = template;
	    lodash.times = times;
	    lodash.toFinite = toFinite;
	    lodash.toInteger = toInteger;
	    lodash.toLength = toLength;
	    lodash.toLower = toLower;
	    lodash.toNumber = toNumber;
	    lodash.toSafeInteger = toSafeInteger;
	    lodash.toString = toString;
	    lodash.toUpper = toUpper;
	    lodash.trim = trim;
	    lodash.trimEnd = trimEnd;
	    lodash.trimStart = trimStart;
	    lodash.truncate = truncate;
	    lodash.unescape = unescape;
	    lodash.uniqueId = uniqueId;
	    lodash.upperCase = upperCase;
	    lodash.upperFirst = upperFirst;
	    lodash.each = forEach;
	    lodash.eachRight = forEachRight;
	    lodash.first = head;
	    mixin(lodash, (function() {
	      var source = {};
	      baseForOwn(lodash, function(func, methodName) {
	        if (!hasOwnProperty.call(lodash.prototype, methodName)) {
	          source[methodName] = func;
	        }
	      });
	      return source;
	    }()), { 'chain': false });
	    lodash.VERSION = VERSION;
	    arrayEach(['bind', 'bindKey', 'curry', 'curryRight', 'partial', 'partialRight'], function(methodName) {
	      lodash[methodName].placeholder = lodash;
	    });
	    arrayEach(['drop', 'take'], function(methodName, index) {
	      LazyWrapper.prototype[methodName] = function(n) {
	        n = n === undefined$1 ? 1 : nativeMax(toInteger(n), 0);
	        var result = (this.__filtered__ && !index)
	          ? new LazyWrapper(this)
	          : this.clone();
	        if (result.__filtered__) {
	          result.__takeCount__ = nativeMin(n, result.__takeCount__);
	        } else {
	          result.__views__.push({
	            'size': nativeMin(n, MAX_ARRAY_LENGTH),
	            'type': methodName + (result.__dir__ < 0 ? 'Right' : '')
	          });
	        }
	        return result;
	      };
	      LazyWrapper.prototype[methodName + 'Right'] = function(n) {
	        return this.reverse()[methodName](n).reverse();
	      };
	    });
	    arrayEach(['filter', 'map', 'takeWhile'], function(methodName, index) {
	      var type = index + 1,
	          isFilter = type == LAZY_FILTER_FLAG || type == LAZY_WHILE_FLAG;
	      LazyWrapper.prototype[methodName] = function(iteratee) {
	        var result = this.clone();
	        result.__iteratees__.push({
	          'iteratee': getIteratee(iteratee, 3),
	          'type': type
	        });
	        result.__filtered__ = result.__filtered__ || isFilter;
	        return result;
	      };
	    });
	    arrayEach(['head', 'last'], function(methodName, index) {
	      var takeName = 'take' + (index ? 'Right' : '');
	      LazyWrapper.prototype[methodName] = function() {
	        return this[takeName](1).value()[0];
	      };
	    });
	    arrayEach(['initial', 'tail'], function(methodName, index) {
	      var dropName = 'drop' + (index ? '' : 'Right');
	      LazyWrapper.prototype[methodName] = function() {
	        return this.__filtered__ ? new LazyWrapper(this) : this[dropName](1);
	      };
	    });
	    LazyWrapper.prototype.compact = function() {
	      return this.filter(identity);
	    };
	    LazyWrapper.prototype.find = function(predicate) {
	      return this.filter(predicate).head();
	    };
	    LazyWrapper.prototype.findLast = function(predicate) {
	      return this.reverse().find(predicate);
	    };
	    LazyWrapper.prototype.invokeMap = baseRest(function(path, args) {
	      if (typeof path == 'function') {
	        return new LazyWrapper(this);
	      }
	      return this.map(function(value) {
	        return baseInvoke(value, path, args);
	      });
	    });
	    LazyWrapper.prototype.reject = function(predicate) {
	      return this.filter(negate(getIteratee(predicate)));
	    };
	    LazyWrapper.prototype.slice = function(start, end) {
	      start = toInteger(start);
	      var result = this;
	      if (result.__filtered__ && (start > 0 || end < 0)) {
	        return new LazyWrapper(result);
	      }
	      if (start < 0) {
	        result = result.takeRight(-start);
	      } else if (start) {
	        result = result.drop(start);
	      }
	      if (end !== undefined$1) {
	        end = toInteger(end);
	        result = end < 0 ? result.dropRight(-end) : result.take(end - start);
	      }
	      return result;
	    };
	    LazyWrapper.prototype.takeRightWhile = function(predicate) {
	      return this.reverse().takeWhile(predicate).reverse();
	    };
	    LazyWrapper.prototype.toArray = function() {
	      return this.take(MAX_ARRAY_LENGTH);
	    };
	    baseForOwn(LazyWrapper.prototype, function(func, methodName) {
	      var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(methodName),
	          isTaker = /^(?:head|last)$/.test(methodName),
	          lodashFunc = lodash[isTaker ? ('take' + (methodName == 'last' ? 'Right' : '')) : methodName],
	          retUnwrapped = isTaker || /^find/.test(methodName);
	      if (!lodashFunc) {
	        return;
	      }
	      lodash.prototype[methodName] = function() {
	        var value = this.__wrapped__,
	            args = isTaker ? [1] : arguments,
	            isLazy = value instanceof LazyWrapper,
	            iteratee = args[0],
	            useLazy = isLazy || isArray(value);
	        var interceptor = function(value) {
	          var result = lodashFunc.apply(lodash, arrayPush([value], args));
	          return (isTaker && chainAll) ? result[0] : result;
	        };
	        if (useLazy && checkIteratee && typeof iteratee == 'function' && iteratee.length != 1) {
	          isLazy = useLazy = false;
	        }
	        var chainAll = this.__chain__,
	            isHybrid = !!this.__actions__.length,
	            isUnwrapped = retUnwrapped && !chainAll,
	            onlyLazy = isLazy && !isHybrid;
	        if (!retUnwrapped && useLazy) {
	          value = onlyLazy ? value : new LazyWrapper(this);
	          var result = func.apply(value, args);
	          result.__actions__.push({ 'func': thru, 'args': [interceptor], 'thisArg': undefined$1 });
	          return new LodashWrapper(result, chainAll);
	        }
	        if (isUnwrapped && onlyLazy) {
	          return func.apply(this, args);
	        }
	        result = this.thru(interceptor);
	        return isUnwrapped ? (isTaker ? result.value()[0] : result.value()) : result;
	      };
	    });
	    arrayEach(['pop', 'push', 'shift', 'sort', 'splice', 'unshift'], function(methodName) {
	      var func = arrayProto[methodName],
	          chainName = /^(?:push|sort|unshift)$/.test(methodName) ? 'tap' : 'thru',
	          retUnwrapped = /^(?:pop|shift)$/.test(methodName);
	      lodash.prototype[methodName] = function() {
	        var args = arguments;
	        if (retUnwrapped && !this.__chain__) {
	          var value = this.value();
	          return func.apply(isArray(value) ? value : [], args);
	        }
	        return this[chainName](function(value) {
	          return func.apply(isArray(value) ? value : [], args);
	        });
	      };
	    });
	    baseForOwn(LazyWrapper.prototype, function(func, methodName) {
	      var lodashFunc = lodash[methodName];
	      if (lodashFunc) {
	        var key = lodashFunc.name + '';
	        if (!hasOwnProperty.call(realNames, key)) {
	          realNames[key] = [];
	        }
	        realNames[key].push({ 'name': methodName, 'func': lodashFunc });
	      }
	    });
	    realNames[createHybrid(undefined$1, WRAP_BIND_KEY_FLAG).name] = [{
	      'name': 'wrapper',
	      'func': undefined$1
	    }];
	    LazyWrapper.prototype.clone = lazyClone;
	    LazyWrapper.prototype.reverse = lazyReverse;
	    LazyWrapper.prototype.value = lazyValue;
	    lodash.prototype.at = wrapperAt;
	    lodash.prototype.chain = wrapperChain;
	    lodash.prototype.commit = wrapperCommit;
	    lodash.prototype.next = wrapperNext;
	    lodash.prototype.plant = wrapperPlant;
	    lodash.prototype.reverse = wrapperReverse;
	    lodash.prototype.toJSON = lodash.prototype.valueOf = lodash.prototype.value = wrapperValue;
	    lodash.prototype.first = lodash.prototype.head;
	    if (symIterator) {
	      lodash.prototype[symIterator] = wrapperToIterator;
	    }
	    return lodash;
	  });
	  var _ = runInContext();
	  if (freeModule) {
	    (freeModule.exports = _)._ = _;
	    freeExports._ = _;
	  }
	  else {
	    root._ = _;
	  }
	}.call(commonjsGlobal));
} (lodash, lodash.exports));
var lodashExports = lodash.exports;
getDefaultExportFromCjs(lodashExports);

var umd = {exports: {}};

umd.exports;
(function (module, exports) {
	!function(t,e){module.exports=e();}(commonjsGlobal,(()=>(()=>{var t={975:t=>{function e(t){if("string"!=typeof t)throw new TypeError("Path must be a string. Received "+JSON.stringify(t))}function r(t,e){for(var r,n="",i=0,o=-1,s=0,a=0;a<=t.length;++a){if(a<t.length)r=t.charCodeAt(a);else {if(47===r)break;r=47;}if(47===r){if(o===a-1||1===s);else if(o!==a-1&&2===s){if(n.length<2||2!==i||46!==n.charCodeAt(n.length-1)||46!==n.charCodeAt(n.length-2))if(n.length>2){var h=n.lastIndexOf("/");if(h!==n.length-1){-1===h?(n="",i=0):i=(n=n.slice(0,h)).length-1-n.lastIndexOf("/"),o=a,s=0;continue}}else if(2===n.length||1===n.length){n="",i=0,o=a,s=0;continue}e&&(n.length>0?n+="/..":n="..",i=2);}else n.length>0?n+="/"+t.slice(o+1,a):n=t.slice(o+1,a),i=a-o-1;o=a,s=0;}else 46===r&&-1!==s?++s:s=-1;}return n}var n={resolve:function(){for(var t,n="",i=!1,o=arguments.length-1;o>=-1&&!i;o--){var s;o>=0?s=arguments[o]:(void 0===t&&(t=process.cwd()),s=t),e(s),0!==s.length&&(n=s+"/"+n,i=47===s.charCodeAt(0));}return n=r(n,!i),i?n.length>0?"/"+n:"/":n.length>0?n:"."},normalize:function(t){if(e(t),0===t.length)return ".";var n=47===t.charCodeAt(0),i=47===t.charCodeAt(t.length-1);return 0!==(t=r(t,!n)).length||n||(t="."),t.length>0&&i&&(t+="/"),n?"/"+t:t},isAbsolute:function(t){return e(t),t.length>0&&47===t.charCodeAt(0)},join:function(){if(0===arguments.length)return ".";for(var t,r=0;r<arguments.length;++r){var i=arguments[r];e(i),i.length>0&&(void 0===t?t=i:t+="/"+i);}return void 0===t?".":n.normalize(t)},relative:function(t,r){if(e(t),e(r),t===r)return "";if((t=n.resolve(t))===(r=n.resolve(r)))return "";for(var i=1;i<t.length&&47===t.charCodeAt(i);++i);for(var o=t.length,s=o-i,a=1;a<r.length&&47===r.charCodeAt(a);++a);for(var h=r.length-a,c=s<h?s:h,f=-1,u=0;u<=c;++u){if(u===c){if(h>c){if(47===r.charCodeAt(a+u))return r.slice(a+u+1);if(0===u)return r.slice(a+u)}else s>c&&(47===t.charCodeAt(i+u)?f=u:0===u&&(f=0));break}var l=t.charCodeAt(i+u);if(l!==r.charCodeAt(a+u))break;47===l&&(f=u);}var d="";for(u=i+f+1;u<=o;++u)u!==o&&47!==t.charCodeAt(u)||(0===d.length?d+="..":d+="/..");return d.length>0?d+r.slice(a+f):(a+=f,47===r.charCodeAt(a)&&++a,r.slice(a))},_makeLong:function(t){return t},dirname:function(t){if(e(t),0===t.length)return ".";for(var r=t.charCodeAt(0),n=47===r,i=-1,o=!0,s=t.length-1;s>=1;--s)if(47===(r=t.charCodeAt(s))){if(!o){i=s;break}}else o=!1;return -1===i?n?"/":".":n&&1===i?"//":t.slice(0,i)},basename:function(t,r){if(void 0!==r&&"string"!=typeof r)throw new TypeError('"ext" argument must be a string');e(t);var n,i=0,o=-1,s=!0;if(void 0!==r&&r.length>0&&r.length<=t.length){if(r.length===t.length&&r===t)return "";var a=r.length-1,h=-1;for(n=t.length-1;n>=0;--n){var c=t.charCodeAt(n);if(47===c){if(!s){i=n+1;break}}else -1===h&&(s=!1,h=n+1),a>=0&&(c===r.charCodeAt(a)?-1==--a&&(o=n):(a=-1,o=h));}return i===o?o=h:-1===o&&(o=t.length),t.slice(i,o)}for(n=t.length-1;n>=0;--n)if(47===t.charCodeAt(n)){if(!s){i=n+1;break}}else -1===o&&(s=!1,o=n+1);return -1===o?"":t.slice(i,o)},extname:function(t){e(t);for(var r=-1,n=0,i=-1,o=!0,s=0,a=t.length-1;a>=0;--a){var h=t.charCodeAt(a);if(47!==h)-1===i&&(o=!1,i=a+1),46===h?-1===r?r=a:1!==s&&(s=1):-1!==r&&(s=-1);else if(!o){n=a+1;break}}return -1===r||-1===i||0===s||1===s&&r===i-1&&r===n+1?"":t.slice(r,i)},format:function(t){if(null===t||"object"!=typeof t)throw new TypeError('The "pathObject" argument must be of type Object. Received type '+typeof t);return function(t,e){var r=e.dir||e.root,n=e.base||(e.name||"")+(e.ext||"");return r?r===e.root?r+n:r+"/"+n:n}(0,t)},parse:function(t){e(t);var r={root:"",dir:"",base:"",ext:"",name:""};if(0===t.length)return r;var n,i=t.charCodeAt(0),o=47===i;o?(r.root="/",n=1):n=0;for(var s=-1,a=0,h=-1,c=!0,f=t.length-1,u=0;f>=n;--f)if(47!==(i=t.charCodeAt(f)))-1===h&&(c=!1,h=f+1),46===i?-1===s?s=f:1!==u&&(u=1):-1!==s&&(u=-1);else if(!c){a=f+1;break}return -1===s||-1===h||0===u||1===u&&s===h-1&&s===a+1?-1!==h&&(r.base=r.name=0===a&&o?t.slice(1,h):t.slice(a,h)):(0===a&&o?(r.name=t.slice(1,s),r.base=t.slice(1,h)):(r.name=t.slice(a,s),r.base=t.slice(a,h)),r.ext=t.slice(s,h)),a>0?r.dir=t.slice(0,a-1):o&&(r.dir="/"),r},sep:"/",delimiter:":",win32:null,posix:null};n.posix=n,t.exports=n;},70:(t,e)=>{if(Object.defineProperty(e,"__esModule",{value:!0}),e.isWindows=void 0,"object"==typeof process)e.isWindows="win32"===process.platform;else if("object"==typeof navigator){let t=navigator.userAgent;e.isWindows=t.indexOf("Windows")>=0;}},231:(t,e,r)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.uriToFsPath=e.URI=void 0;const n=r(70),i=/^\w[\w\d+.-]*$/,o=/^\//,s=/^\/\//;function a(t,e){if(!t.scheme&&e)throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${t.authority}", path: "${t.path}", query: "${t.query}", fragment: "${t.fragment}"}`);if(t.scheme&&!i.test(t.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(t.path)if(t.authority){if(!o.test(t.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(s.test(t.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}const h="",c="/",f=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;class u{static isUri(t){return t instanceof u||!!t&&"string"==typeof t.authority&&"string"==typeof t.fragment&&"string"==typeof t.path&&"string"==typeof t.query&&"string"==typeof t.scheme&&"string"==typeof t.fsPath&&"function"==typeof t.with&&"function"==typeof t.toString}scheme;authority;path;query;fragment;constructor(t,e,r,n,i,o=!1){"object"==typeof t?(this.scheme=t.scheme||h,this.authority=t.authority||h,this.path=t.path||h,this.query=t.query||h,this.fragment=t.fragment||h):(this.scheme=function(t,e){return t||e?t:"file"}(t,o),this.authority=e||h,this.path=function(t,e){switch(t){case"https":case"http":case"file":e?e[0]!==c&&(e=c+e):e=c;}return e}(this.scheme,r||h),this.query=n||h,this.fragment=i||h,a(this,o));}get fsPath(){return v(this,!1)}with(t){if(!t)return this;let{scheme:e,authority:r,path:n,query:i,fragment:o}=t;return void 0===e?e=this.scheme:null===e&&(e=h),void 0===r?r=this.authority:null===r&&(r=h),void 0===n?n=this.path:null===n&&(n=h),void 0===i?i=this.query:null===i&&(i=h),void 0===o?o=this.fragment:null===o&&(o=h),e===this.scheme&&r===this.authority&&n===this.path&&i===this.query&&o===this.fragment?this:new d(e,r,n,i,o)}static parse(t,e=!1){const r=f.exec(t);return r?new d(r[2]||h,w(r[4]||h),w(r[5]||h),w(r[7]||h),w(r[9]||h),e):new d(h,h,h,h,h)}static file(t){let e=h;if(n.isWindows&&(t=t.replace(/\\/g,c)),t[0]===c&&t[1]===c){const r=t.indexOf(c,2);-1===r?(e=t.substring(2),t=c):(e=t.substring(2,r),t=t.substring(r)||c);}return new d("file",e,t,h,h)}static from(t){const e=new d(t.scheme,t.authority,t.path,t.query,t.fragment);return a(e,!0),e}toString(t=!1){return y(this,t)}toJSON(){return this}static revive(t){if(t){if(t instanceof u)return t;{const e=new d(t);return e._formatted=t.external,e._fsPath=t._sep===l?t.fsPath:null,e}}return t}}e.URI=u;const l=n.isWindows?1:void 0;class d extends u{_formatted=null;_fsPath=null;get fsPath(){return this._fsPath||(this._fsPath=v(this,!1)),this._fsPath}toString(t=!1){return t?y(this,!0):(this._formatted||(this._formatted=y(this,!1)),this._formatted)}toJSON(){const t={$mid:1};return this._fsPath&&(t.fsPath=this._fsPath,t._sep=l),this._formatted&&(t.external=this._formatted),this.path&&(t.path=this.path),this.scheme&&(t.scheme=this.scheme),this.authority&&(t.authority=this.authority),this.query&&(t.query=this.query),this.fragment&&(t.fragment=this.fragment),t}}const p={58:"%3A",47:"%2F",63:"%3F",35:"%23",91:"%5B",93:"%5D",64:"%40",33:"%21",36:"%24",38:"%26",39:"%27",40:"%28",41:"%29",42:"%2A",43:"%2B",44:"%2C",59:"%3B",61:"%3D",32:"%20"};function g(t,e,r){let n,i=-1;for(let o=0;o<t.length;o++){const s=t.charCodeAt(o);if(s>=97&&s<=122||s>=65&&s<=90||s>=48&&s<=57||45===s||46===s||95===s||126===s||e&&47===s||r&&91===s||r&&93===s||r&&58===s)-1!==i&&(n+=encodeURIComponent(t.substring(i,o)),i=-1),void 0!==n&&(n+=t.charAt(o));else {void 0===n&&(n=t.substr(0,o));const e=p[s];void 0!==e?(-1!==i&&(n+=encodeURIComponent(t.substring(i,o)),i=-1),n+=e):-1===i&&(i=o);}}return -1!==i&&(n+=encodeURIComponent(t.substring(i))),void 0!==n?n:t}function m(t){let e;for(let r=0;r<t.length;r++){const n=t.charCodeAt(r);35===n||63===n?(void 0===e&&(e=t.substr(0,r)),e+=p[n]):void 0!==e&&(e+=t[r]);}return void 0!==e?e:t}function v(t,e){let r;return r=t.authority&&t.path.length>1&&"file"===t.scheme?`//${t.authority}${t.path}`:47===t.path.charCodeAt(0)&&(t.path.charCodeAt(1)>=65&&t.path.charCodeAt(1)<=90||t.path.charCodeAt(1)>=97&&t.path.charCodeAt(1)<=122)&&58===t.path.charCodeAt(2)?e?t.path.substr(1):t.path[1].toLowerCase()+t.path.substr(2):t.path,n.isWindows&&(r=r.replace(/\//g,"\\")),r}function y(t,e){const r=e?m:g;let n="",{scheme:i,authority:o,path:s,query:a,fragment:h}=t;if(i&&(n+=i,n+=":"),(o||"file"===i)&&(n+=c,n+=c),o){let t=o.indexOf("@");if(-1!==t){const e=o.substr(0,t);o=o.substr(t+1),t=e.lastIndexOf(":"),-1===t?n+=r(e,!1,!1):(n+=r(e.substr(0,t),!1,!1),n+=":",n+=r(e.substr(t+1),!1,!0)),n+="@";}o=o.toLowerCase(),t=o.lastIndexOf(":"),-1===t?n+=r(o,!1,!0):(n+=r(o.substr(0,t),!1,!0),n+=o.substr(t));}if(s){if(s.length>=3&&47===s.charCodeAt(0)&&58===s.charCodeAt(2)){const t=s.charCodeAt(1);t>=65&&t<=90&&(s=`/${String.fromCharCode(t+32)}:${s.substr(3)}`);}else if(s.length>=2&&58===s.charCodeAt(1)){const t=s.charCodeAt(0);t>=65&&t<=90&&(s=`${String.fromCharCode(t+32)}:${s.substr(2)}`);}n+=r(s,!0,!1);}return a&&(n+="?",n+=r(a,!1,!1)),h&&(n+="#",n+=e?h:g(h,!1,!1)),n}function b(t){try{return decodeURIComponent(t)}catch{return t.length>3?t.substr(0,3)+b(t.substr(3)):t}}e.uriToFsPath=v;const C=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function w(t){return t.match(C)?t.replace(C,(t=>b(t))):t}},552:function(t,e,r){var n=this&&this.__createBinding||(Object.create?function(t,e,r,n){void 0===n&&(n=r);var i=Object.getOwnPropertyDescriptor(e,r);i&&!("get"in i?!e.__esModule:i.writable||i.configurable)||(i={enumerable:!0,get:function(){return e[r]}}),Object.defineProperty(t,n,i);}:function(t,e,r,n){void 0===n&&(n=r),t[n]=e[r];}),i=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e});}:function(t,e){t.default=e;}),o=this&&this.__importStar||function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var r in t)"default"!==r&&Object.prototype.hasOwnProperty.call(t,r)&&n(e,t,r);return i(e,t),e};Object.defineProperty(e,"__esModule",{value:!0}),e.Utils=void 0;const s=o(r(975)),a=s.posix||s,h="/";var c;!function(t){t.joinPath=function(t,...e){return t.with({path:a.join(t.path,...e)})},t.resolvePath=function(t,...e){let r=t.path,n=!1;r[0]!==h&&(r=h+r,n=!0);let i=a.resolve(r,...e);return n&&i[0]===h&&!t.authority&&(i=i.substring(1)),t.with({path:i})},t.dirname=function(t){if(0===t.path.length||t.path===h)return t;let e=a.dirname(t.path);return 1===e.length&&46===e.charCodeAt(0)&&(e=""),t.with({path:e})},t.basename=function(t){return a.basename(t.path)},t.extname=function(t){return a.extname(t.path)};}(c||(e.Utils=c={}));}},e={};function r(n){var i=e[n];if(void 0!==i)return i.exports;var o=e[n]={exports:{}};return t[n].call(o.exports,o,o.exports,r),o.exports}var n={};return (()=>{var t=n;Object.defineProperty(t,"__esModule",{value:!0}),t.Utils=t.URI=void 0;const e=r(231);Object.defineProperty(t,"URI",{enumerable:!0,get:function(){return e.URI}});const i=r(552);Object.defineProperty(t,"Utils",{enumerable:!0,get:function(){return i.Utils}});})(),n})()));
} (umd, umd.exports));
var umdExports = umd.exports;
getDefaultExportFromCjs(umdExports);

Object.defineProperty(utils$4, "__esModule", { value: true });
utils$4.not = not;
utils$4.or = or;
utils$4.and = and;
utils$4.unique = unique;
utils$4.clamp = clamp$1;
utils$4.urlToPath = urlToPath;
utils$4.pathToUrl = pathToUrl;
utils$4.normalizePath = normalizePath$1;
utils$4.normalizeUri = normalizeUri;
utils$4.getLastPartOfPath = getLastPartOfPath;
utils$4.flatten = flatten$1;
utils$4.passMap = passMap;
utils$4.isInRange = isInRange;
utils$4.isZeroLengthRange = isZeroLengthRange;
utils$4.isRangeStartAfterEnd = isRangeStartAfterEnd;
utils$4.swapRangeStartEndIfNecessary = swapRangeStartEndIfNecessary;
utils$4.moveRangeStartToEndIfNecessary = moveRangeStartToEndIfNecessary;
utils$4.isBeforeOrEqualToPosition = isBeforeOrEqualToPosition;
utils$4.isPositionEqual = isPositionEqual;
utils$4.isNotNullOrUndefined = isNotNullOrUndefined;
utils$4.debounceSameArg = debounceSameArg;
utils$4.debounceThrottle = debounceThrottle;
utils$4.regexLastIndexOf = regexLastIndexOf;
utils$4.regexIndexOf = regexIndexOf;
utils$4.getRegExpMatches = getRegExpMatches;
utils$4.modifyLines = modifyLines;
utils$4.isSamePosition = isSamePosition;
utils$4.filterAsync = filterAsync;
utils$4.getIndent = getIndent$1;
utils$4.possiblyComponent = possiblyComponent;
utils$4.returnObjectIfHasKeys = returnObjectIfHasKeys;
utils$4.toFileNameLowerCase = toFileNameLowerCase;
utils$4.createGetCanonicalFileName = createGetCanonicalFileName;
utils$4.memoize = memoize;
utils$4.removeLineWithString = removeLineWithString;
utils$4.traverseTypeString = traverseTypeString;
const lodash_1$5 = lodashExports;
const vscode_uri_1$2 = umdExports;
function not(predicate) {
    return (x) => !predicate(x);
}
function or(...predicates) {
    return (x) => predicates.some((predicate) => predicate(x));
}
function and(...predicates) {
    return (x) => predicates.every((predicate) => predicate(x));
}
function unique(array) {
    return (0, lodash_1$5.uniqWith)(array, lodash_1$5.isEqual);
}
function clamp$1(num, min, max) {
    return Math.max(min, Math.min(max, num));
}
function urlToPath(stringUrl) {
    const url = vscode_uri_1$2.URI.parse(stringUrl);
    if (url.scheme !== 'file') {
        return null;
    }
    return url.fsPath.replace(/\\/g, '/');
}
function pathToUrl(path) {
    return vscode_uri_1$2.URI.file(path).toString();
}
function normalizePath$1(path) {
    return vscode_uri_1$2.URI.file(path).fsPath.replace(/\\/g, '/');
}
function normalizeUri(uri) {
    return vscode_uri_1$2.URI.parse(uri).toString();
}
function getLastPartOfPath(path) {
    return path.replace(/\\/g, '/').split('/').pop() || '';
}
function flatten$1(arr) {
    return arr.reduce((all, item) => (Array.isArray(item) ? [...all, ...item] : [...all, item]), []);
}
function passMap(array, mapper) {
    return array.map((x) => {
        const mapped = mapper(x);
        return mapped === undefined ? x : mapped;
    });
}
function isInRange(range, positionToTest) {
    return (isBeforeOrEqualToPosition(range.end, positionToTest) &&
        isBeforeOrEqualToPosition(positionToTest, range.start));
}
function isZeroLengthRange(range) {
    return isPositionEqual(range.start, range.end);
}
function isRangeStartAfterEnd(range) {
    return (range.end.line < range.start.line ||
        (range.end.line === range.start.line && range.end.character < range.start.character));
}
function swapRangeStartEndIfNecessary(range) {
    if (isRangeStartAfterEnd(range)) {
        const start = range.start;
        range.start = range.end;
        range.end = start;
    }
    return range;
}
function moveRangeStartToEndIfNecessary(range) {
    if (isRangeStartAfterEnd(range)) {
        range.start = range.end;
    }
    return range;
}
function isBeforeOrEqualToPosition(position, positionToTest) {
    return (positionToTest.line < position.line ||
        (positionToTest.line === position.line && positionToTest.character <= position.character));
}
function isPositionEqual(position1, position2) {
    return position1.line === position2.line && position1.character === position2.character;
}
function isNotNullOrUndefined(val) {
    return val !== undefined && val !== null;
}
function debounceSameArg(fn, shouldCancelPrevious, miliseconds) {
    let timeout;
    let prevArg;
    return (arg) => {
        if (shouldCancelPrevious(arg, prevArg)) {
            clearTimeout(timeout);
        }
        prevArg = arg;
        timeout = setTimeout(() => {
            fn(arg);
            prevArg = undefined;
        }, miliseconds);
    };
}
function debounceThrottle(fn, miliseconds) {
    let timeout;
    let lastInvocation = Date.now() - miliseconds;
    function maybeCall() {
        clearTimeout(timeout);
        timeout = setTimeout(() => {
            if (Date.now() - lastInvocation < miliseconds) {
                maybeCall();
                return;
            }
            fn();
            lastInvocation = Date.now();
        }, miliseconds);
    }
    return maybeCall;
}
function regexLastIndexOf(text, regex, endPos) {
    if (endPos === undefined) {
        endPos = text.length;
    }
    else if (endPos < 0) {
        endPos = 0;
    }
    const stringToWorkWith = text.substring(0, endPos + 1);
    let lastIndexOf = -1;
    let result = null;
    while ((result = regex.exec(stringToWorkWith)) !== null) {
        lastIndexOf = result.index;
    }
    return lastIndexOf;
}
function regexIndexOf(text, regex, startPos) {
    if (startPos === undefined || startPos < 0) {
        startPos = 0;
    }
    const stringToWorkWith = text.substring(startPos);
    const result = regex.exec(stringToWorkWith);
    return result?.index ?? -1;
}
function getRegExpMatches(regex, str) {
    const matches = [];
    let match;
    while ((match = regex.exec(str))) {
        matches.push(match);
    }
    return matches;
}
function modifyLines(text, replacementFn) {
    let idx = 0;
    return text
        .split('\r\n')
        .map((l1) => l1
        .split('\n')
        .map((line) => replacementFn(line, idx++))
        .join('\n'))
        .join('\r\n');
}
function isSamePosition(position, another) {
    return position.line === another.line && position.character === another.character;
}
async function filterAsync(array, predicate) {
    const fail = Symbol();
    return (await Promise.all(array.map(async (item, idx) => ((await predicate(item, idx)) ? item : fail)))).filter((i) => i !== fail);
}
function getIndent$1(text) {
    return /^[ |\t]+/.exec(text)?.[0] ?? '';
}
function possiblyComponent(nodeOrTagName) {
    return !!(typeof nodeOrTagName === 'object' ? nodeOrTagName.tag : nodeOrTagName)?.[0].match(/[A-Z]/);
}
function returnObjectIfHasKeys(obj) {
    if (Object.keys(obj || {}).length > 0) {
        return obj;
    }
}
const fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;
function toFileNameLowerCase(x) {
    return fileNameLowerCaseRegExp.test(x) ? x.replace(fileNameLowerCaseRegExp, toLowerCase) : x;
}
function toLowerCase(x) {
    return x.toLowerCase();
}
function createGetCanonicalFileName(useCaseSensitiveFileNames) {
    return useCaseSensitiveFileNames ? identity : toFileNameLowerCase;
}
function identity(x) {
    return x;
}
function memoize(callback) {
    let value;
    let callbackInner = callback;
    return () => {
        if (callbackInner) {
            value = callback();
            callbackInner = undefined;
        }
        return value;
    };
}
function removeLineWithString(str, keyword) {
    const lines = str.split('\n');
    const filteredLines = lines.filter((line) => !line.includes(keyword));
    return filteredLines.join('\n');
}
function traverseTypeString(str, start, endChar) {
    let singleQuoteOpen = false;
    let doubleQuoteOpen = false;
    let countCurlyBrace = 0;
    let countAngleBracket = 0;
    for (let i = start; i < str.length; i++) {
        const char = str[i];
        if (!doubleQuoteOpen && char === "'") {
            singleQuoteOpen = !singleQuoteOpen;
        }
        else if (!singleQuoteOpen && char === '"') {
            doubleQuoteOpen = !doubleQuoteOpen;
        }
        else if (!doubleQuoteOpen && !singleQuoteOpen) {
            if (char === '{') {
                countCurlyBrace++;
            }
            else if (char === '}') {
                countCurlyBrace--;
            }
            else if (char === '<') {
                countAngleBracket++;
            }
            else if (char === '>') {
                countAngleBracket--;
            }
        }
        if (!singleQuoteOpen &&
            !doubleQuoteOpen &&
            countCurlyBrace === 0 &&
            countAngleBracket === 0 &&
            char === endChar) {
            return i;
        }
    }
    return -1;
}

Object.defineProperty(DiagnosticsManager$1, "__esModule", { value: true });
DiagnosticsManager$1.DiagnosticsManager = void 0;
const vscode_languageserver_1$w = main$8;
const utils_1$L = utils$4;
class DiagnosticsManager {
    constructor(sendDiagnostics, docManager, getDiagnostics) {
        this.sendDiagnostics = sendDiagnostics;
        this.docManager = docManager;
        this.getDiagnostics = getDiagnostics;
        this.pendingUpdates = new Set();
        this.cancellationTokens = new Map();
        this.debouncedUpdateAll = (0, utils_1$L.debounceThrottle)(() => this.updateAll(), 1000);
        this.scheduleBatchUpdate = (0, utils_1$L.debounceThrottle)(() => {
            this.pendingUpdates.forEach((doc) => {
                this.update(doc);
            });
            this.pendingUpdates.clear();
        }, 700);
    }
    updateAll() {
        this.docManager.getAllOpenedByClient().forEach((doc) => {
            this.update(doc[1]);
        });
        this.pendingUpdates.clear();
    }
    scheduleUpdateAll() {
        this.cancellationTokens.forEach((token) => token.cancel());
        this.cancellationTokens.clear();
        this.pendingUpdates.clear();
        this.debouncedUpdateAll();
    }
    async update(document) {
        const uri = document.getURL();
        this.cancelStarted(uri);
        const tokenSource = new vscode_languageserver_1$w.CancellationTokenSource();
        this.cancellationTokens.set(uri, tokenSource);
        const diagnostics = await this.getDiagnostics({ uri: document.getURL() }, tokenSource.token);
        this.sendDiagnostics({
            uri: document.getURL(),
            diagnostics
        });
        tokenSource.dispose();
        if (this.cancellationTokens.get(uri) === tokenSource) {
            this.cancellationTokens.delete(uri);
        }
    }
    cancelStarted(uri) {
        const started = this.cancellationTokens.get(uri);
        if (started) {
            started.cancel();
        }
    }
    removeDiagnostics(document) {
        this.pendingUpdates.delete(document);
        this.sendDiagnostics({
            uri: document.getURL(),
            diagnostics: []
        });
    }
    scheduleUpdate(document) {
        if (!this.docManager.isOpenedInClient(document.getURL())) {
            return;
        }
        this.cancelStarted(document.getURL());
        this.pendingUpdates.add(document);
        this.scheduleBatchUpdate();
    }
}
DiagnosticsManager$1.DiagnosticsManager = DiagnosticsManager;

var documents = {};

var DocumentManager$1 = {};

var fileCollection = {};

var __importDefault$s = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(fileCollection, "__esModule", { value: true });
fileCollection.FileSet = fileCollection.FileMap = void 0;
const typescript_1$p = __importDefault$s(ts);
const utils_1$K = utils$4;
class FileMap {
    constructor(useCaseSensitiveFileNames = typescript_1$p.default.sys.useCaseSensitiveFileNames) {
        this.map = new Map();
        this.getCanonicalFileName = (0, utils_1$K.createGetCanonicalFileName)(useCaseSensitiveFileNames);
    }
    get(filePath) {
        return this.map.get(this.getCanonicalFileName(filePath));
    }
    set(filePath, value) {
        const canonicalFileName = this.getCanonicalFileName(filePath);
        return this.map.set(canonicalFileName, value);
    }
    has(filePath) {
        return this.map.has(this.getCanonicalFileName(filePath));
    }
    delete(filePath) {
        return this.map.delete(this.getCanonicalFileName(filePath));
    }
    entries() {
        return this.map.entries();
    }
    forEach(callbackfn) {
        return this.map.forEach(callbackfn);
    }
    values() {
        return this.map.values();
    }
    clear() {
        this.map.clear();
    }
    keys() {
        return this.map.keys();
    }
    get size() {
        return this.map.size;
    }
    [Symbol.iterator]() {
        return this.map[Symbol.iterator]();
    }
}
fileCollection.FileMap = FileMap;
class FileSet {
    constructor(useCaseSensitiveFileNames = typescript_1$p.default.sys.useCaseSensitiveFileNames) {
        this.set = new Set();
        this.getCanonicalFileName = (0, utils_1$K.createGetCanonicalFileName)(useCaseSensitiveFileNames);
    }
    add(filePath) {
        this.set.add(this.getCanonicalFileName(filePath));
    }
    has(filePath) {
        return this.set.has(this.getCanonicalFileName(filePath));
    }
    delete(filePath) {
        return this.set.delete(this.getCanonicalFileName(filePath));
    }
    clear() {
        this.set.clear();
    }
    [Symbol.iterator]() {
        return this.set[Symbol.iterator]();
    }
}
fileCollection.FileSet = FileSet;

var __importDefault$r = (commonjsGlobal && commonjsGlobal.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(DocumentManager$1, "__esModule", { value: true });
DocumentManager$1.DocumentManager = void 0;
const events_1$1 = require$$0$3;
const utils_1$J = utils$4;
const typescript_1$o = __importDefault$r(ts);
const fileCollection_1$7 = fileCollection;
class DocumentManager {
    constructor(createDocument, options = {
        useCaseSensitiveFileNames: typescript_1$o.default.sys.useCaseSensitiveFileNames
    }) {
        this.createDocument = createDocument;
        this.emitter = new events_1$1.EventEmitter();
        this.documents = new fileCollection_1$7.FileMap(options.useCaseSensitiveFileNames);
        this.locked = new fileCollection_1$7.FileSet(options.useCaseSensitiveFileNames);
        this.deleteCandidates = new fileCollection_1$7.FileSet(options.useCaseSensitiveFileNames);
    }
    openClientDocument(textDocument) {
        return this.openDocument(textDocument,  true);
    }
    openDocument(textDocument, openedByClient) {
        textDocument = {
            ...textDocument,
            uri: (0, utils_1$J.normalizeUri)(textDocument.uri)
        };
        let document;
        if (this.documents.has(textDocument.uri)) {
            document = this.documents.get(textDocument.uri);
            document.openedByClient ||= openedByClient;
            document.setText(textDocument.text);
        }
        else {
            document = this.createDocument(textDocument);
            document.openedByClient = openedByClient;
            this.documents.set(textDocument.uri, document);
            this.notify('documentOpen', document);
        }
        this.notify('documentChange', document);
        return document;
    }
    lockDocument(uri) {
        this.locked.add((0, utils_1$J.normalizeUri)(uri));
    }
    markAsOpenedInClient(uri) {
        const document = this.documents.get((0, utils_1$J.normalizeUri)(uri));
        if (document) {
            document.openedByClient = true;
        }
    }
    getAllOpenedByClient() {
        return Array.from(this.documents.entries()).filter((doc) => doc[1].openedByClient);
    }
    isOpenedInClient(uri) {
        const document = this.documents.get((0, utils_1$J.normalizeUri)(uri));
        return !!document?.openedByClient;
    }
    releaseDocument(uri) {
        uri = (0, utils_1$J.normalizeUri)(uri);
        this.locked.delete(uri);
        const document = this.documents.get(uri);
        if (document) {
            document.openedByClient = false;
        }
        if (this.deleteCandidates.has(uri)) {
            this.deleteCandidates.delete(uri);
            this.closeDocument(uri);
        }
    }
    closeDocument(uri) {
        uri = (0, utils_1$J.normalizeUri)(uri);
        const document = this.documents.get(uri);
        if (!document) {
            throw new Error('Cannot call methods on an unopened document');
        }
        this.notify('documentClose', document);
        if (!this.locked.has(uri)) {
            this.documents.delete(uri);
        }
        else {
            this.deleteCandidates.add(uri);
        }
        document.openedByClient = false;
    }
    updateDocument(textDocument, changes) {
        const document = this.documents.get((0, utils_1$J.normalizeUri)(textDocument.uri));
        if (!document) {
            throw new Error('Cannot call methods on an unopened document');
        }
        for (const change of changes) {
            let start = 0;
            let end = 0;
            if ('range' in change) {
                start = document.offsetAt(change.range.start);
                end = document.offsetAt(change.range.end);
            }
            else {
                end = document.getTextLength();
            }
            document.update(change.text, start, end);
        }
        this.notify('documentChange', document);
    }
    on(name, listener) {
        this.emitter.on(name, listener);
    }
    get(uri) {
        return this.documents.get((0, utils_1$J.normalizeUri)(uri));
    }
    notify(name, document) {
        this.emitter.emit(name, document);
    }
}
DocumentManager$1.DocumentManager = DocumentManager;

var Document$2 = {};

var DocumentBase = {};

var utils$3 = {};

var parseHtml = {};

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var main_exports = {};
__export(main_exports, {
  config: () => config,
  t: () => t
});
var main$4 = __toCommonJS(main_exports);
var import_fs = require$$0$1;
var import_promises = require$$1$3;
async function readFileFromUri(uri) {
  if (uri.protocol === "file:") {
    return await (0, import_promises.readFile)(uri, "utf8");
  }
  if (uri.protocol === "http:" || uri.protocol === "https:") {
    const res = await fetch(uri.toString(), {
      headers: {
        "Accept-Encoding": "gzip, deflate",
        "Accept": "application/json"
      },
      redirect: "follow"
    });
    if (!res.ok) {
      let error = `Unexpected ${res.status} response while trying to read ${uri}`;
      try {
        error += `: ${await res.text()}`;
      } catch {
      }
      throw new Error(error);
    }
    const decoded = await res.text();
    return decoded;
  }
  throw new Error("Unsupported protocol");
}
function readFileFromFsPath(fsPath) {
  return (0, import_fs.readFileSync)(fsPath, "utf8");
}
var bundle;
function config(config2) {
  if ("contents" in config2) {
    if (typeof config2.contents === "string") {
      bundle = JSON.parse(config2.contents);
    } else {
      bundle = config2.contents;
    }
    return;
  }
  if ("fsPath" in config2) {
    const fileContent = readFileFromFsPath(config2.fsPath);
    const content = JSON.parse(fileContent);
    bundle = isBuiltinExtension(content) ? content.contents.bundle : content;
    return;
  }
  if (config2.uri) {
    let uri = config2.uri;
    if (typeof config2.uri === "string") {
      uri = new URL(config2.uri);
    }
    return new Promise((resolve, reject) => {
      readFileFromUri(uri).then((uriContent) => {
        try {
          const content = JSON.parse(uriContent);
          bundle = isBuiltinExtension(content) ? content.contents.bundle : content;
          resolve();
        } catch (err) {
          reject(err);
        }
      }).catch((err) => {
        reject(err);
      });
    });
  }
}
function t(...args) {
  const firstArg = args[0];
  let key;
  let message;
  let formatArgs;
  if (typeof firstArg === "string") {
    key = firstArg;
    message = firstArg;
    args.splice(0, 1);
    formatArgs = !args || typeof args[0] !== "object" ? args : args[0];
  } else if (firstArg instanceof Array) {
    const replacements = args.slice(1);
    if (firstArg.length !== replacements.length + 1) {
      throw new Error("expected a string as the first argument to l10n.t");
    }
    let str = firstArg[0];
    for (let i = 1; i < firstArg.length; i++) {
      str += `{${i - 1}}` + firstArg[i];
    }
    return t(str, ...replacements);
  } else {
    message = firstArg.message;
    key = message;
    if (firstArg.comment && firstArg.comment.length > 0) {
      key += `/${Array.isArray(firstArg.comment) ? firstArg.comment.join("") : firstArg.comment}`;
    }
    formatArgs = firstArg.args ?? {};
  }
  const messageFromBundle = bundle?.[key];
  if (!messageFromBundle) {
    return format$2(message, formatArgs);
  }
  if (typeof messageFromBundle === "string") {
    return format$2(messageFromBundle, formatArgs);
  }
  if (messageFromBundle.comment) {
    return format$2(messageFromBundle.message, formatArgs);
  }
  return format$2(message, formatArgs);
}
var _format2Regexp = /{([^}]+)}/g;
function format$2(template, values) {
  if (Object.keys(values).length === 0) {
    return template;
  }
  return template.replace(_format2Regexp, (match, group) => values[group] ?? match);
}
function isBuiltinExtension(json) {
  return !!(typeof json?.contents?.bundle === "object" && typeof json?.version === "string");
}
getDefaultExportFromCjs(main$4);

var DocumentUri$1;
(function (DocumentUri) {
    function is(value) {
        return typeof value === 'string';
    }
    DocumentUri.is = is;
})(DocumentUri$1 || (DocumentUri$1 = {}));
var URI$3;
(function (URI) {
    function is(value) {
        return typeof value === 'string';
    }
    URI.is = is;
})(URI$3 || (URI$3 = {}));
var integer$1;
(function (integer) {
    integer.MIN_VALUE = -2147483648;
    integer.MAX_VALUE = 2147483647;
    function is(value) {
        return typeof value === 'number' && integer.MIN_VALUE <= value && value <= integer.MAX_VALUE;
    }
    integer.is = is;
})(integer$1 || (integer$1 = {}));
var uinteger$1;
(function (uinteger) {
    uinteger.MIN_VALUE = 0;
    uinteger.MAX_VALUE = 2147483647;
    function is(value) {
        return typeof value === 'number' && uinteger.MIN_VALUE <= value && value <= uinteger.MAX_VALUE;
    }
    uinteger.is = is;
})(uinteger$1 || (uinteger$1 = {}));
var Position$1;
(function (Position) {
    function create(line, character) {
        if (line === Number.MAX_VALUE) {
            line = uinteger$1.MAX_VALUE;
        }
        if (character === Number.MAX_VALUE) {
            character = uinteger$1.MAX_VALUE;
        }
        return { line, character };
    }
    Position.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.objectLiteral(candidate) && Is$1.uinteger(candidate.line) && Is$1.uinteger(candidate.character);
    }
    Position.is = is;
})(Position$1 || (Position$1 = {}));
var Range$1;
(function (Range) {
    function create(one, two, three, four) {
        if (Is$1.uinteger(one) && Is$1.uinteger(two) && Is$1.uinteger(three) && Is$1.uinteger(four)) {
            return { start: Position$1.create(one, two), end: Position$1.create(three, four) };
        }
        else if (Position$1.is(one) && Position$1.is(two)) {
            return { start: one, end: two };
        }
        else {
            throw new Error(`Range#create called with invalid arguments[${one}, ${two}, ${three}, ${four}]`);
        }
    }
    Range.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.objectLiteral(candidate) && Position$1.is(candidate.start) && Position$1.is(candidate.end);
    }
    Range.is = is;
})(Range$1 || (Range$1 = {}));
var Location$1;
(function (Location) {
    function create(uri, range) {
        return { uri, range };
    }
    Location.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.objectLiteral(candidate) && Range$1.is(candidate.range) && (Is$1.string(candidate.uri) || Is$1.undefined(candidate.uri));
    }
    Location.is = is;
})(Location$1 || (Location$1 = {}));
var LocationLink$1;
(function (LocationLink) {
    function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
        return { targetUri, targetRange, targetSelectionRange, originSelectionRange };
    }
    LocationLink.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.objectLiteral(candidate) && Range$1.is(candidate.targetRange) && Is$1.string(candidate.targetUri)
            && Range$1.is(candidate.targetSelectionRange)
            && (Range$1.is(candidate.originSelectionRange) || Is$1.undefined(candidate.originSelectionRange));
    }
    LocationLink.is = is;
})(LocationLink$1 || (LocationLink$1 = {}));
var Color$1;
(function (Color) {
    function create(red, green, blue, alpha) {
        return {
            red,
            green,
            blue,
            alpha,
        };
    }
    Color.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && Is$1.numberRange(candidate.red, 0, 1)
            && Is$1.numberRange(candidate.green, 0, 1)
            && Is$1.numberRange(candidate.blue, 0, 1)
            && Is$1.numberRange(candidate.alpha, 0, 1);
    }
    Color.is = is;
})(Color$1 || (Color$1 = {}));
var ColorInformation$1;
(function (ColorInformation) {
    function create(range, color) {
        return {
            range,
            color,
        };
    }
    ColorInformation.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && Range$1.is(candidate.range) && Color$1.is(candidate.color);
    }
    ColorInformation.is = is;
})(ColorInformation$1 || (ColorInformation$1 = {}));
var ColorPresentation$1;
(function (ColorPresentation) {
    function create(label, textEdit, additionalTextEdits) {
        return {
            label,
            textEdit,
            additionalTextEdits,
        };
    }
    ColorPresentation.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && Is$1.string(candidate.label)
            && (Is$1.undefined(candidate.textEdit) || TextEdit$1.is(candidate))
            && (Is$1.undefined(candidate.additionalTextEdits) || Is$1.typedArray(candidate.additionalTextEdits, TextEdit$1.is));
    }
    ColorPresentation.is = is;
})(ColorPresentation$1 || (ColorPresentation$1 = {}));
var FoldingRangeKind$1;
(function (FoldingRangeKind) {
    FoldingRangeKind.Comment = 'comment';
    FoldingRangeKind.Imports = 'imports';
    FoldingRangeKind.Region = 'region';
})(FoldingRangeKind$1 || (FoldingRangeKind$1 = {}));
var FoldingRange$1;
(function (FoldingRange) {
    function create(startLine, endLine, startCharacter, endCharacter, kind, collapsedText) {
        const result = {
            startLine,
            endLine
        };
        if (Is$1.defined(startCharacter)) {
            result.startCharacter = startCharacter;
        }
        if (Is$1.defined(endCharacter)) {
            result.endCharacter = endCharacter;
        }
        if (Is$1.defined(kind)) {
            result.kind = kind;
        }
        if (Is$1.defined(collapsedText)) {
            result.collapsedText = collapsedText;
        }
        return result;
    }
    FoldingRange.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && Is$1.uinteger(candidate.startLine) && Is$1.uinteger(candidate.startLine)
            && (Is$1.undefined(candidate.startCharacter) || Is$1.uinteger(candidate.startCharacter))
            && (Is$1.undefined(candidate.endCharacter) || Is$1.uinteger(candidate.endCharacter))
            && (Is$1.undefined(candidate.kind) || Is$1.string(candidate.kind));
    }
    FoldingRange.is = is;
})(FoldingRange$1 || (FoldingRange$1 = {}));
var DiagnosticRelatedInformation$1;
(function (DiagnosticRelatedInformation) {
    function create(location, message) {
        return {
            location,
            message
        };
    }
    DiagnosticRelatedInformation.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Location$1.is(candidate.location) && Is$1.string(candidate.message);
    }
    DiagnosticRelatedInformation.is = is;
})(DiagnosticRelatedInformation$1 || (DiagnosticRelatedInformation$1 = {}));
var DiagnosticSeverity$1;
(function (DiagnosticSeverity) {
    DiagnosticSeverity.Error = 1;
    DiagnosticSeverity.Warning = 2;
    DiagnosticSeverity.Information = 3;
    DiagnosticSeverity.Hint = 4;
})(DiagnosticSeverity$1 || (DiagnosticSeverity$1 = {}));
var DiagnosticTag$1;
(function (DiagnosticTag) {
    DiagnosticTag.Unnecessary = 1;
    DiagnosticTag.Deprecated = 2;
})(DiagnosticTag$1 || (DiagnosticTag$1 = {}));
var CodeDescription$1;
(function (CodeDescription) {
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && Is$1.string(candidate.href);
    }
    CodeDescription.is = is;
})(CodeDescription$1 || (CodeDescription$1 = {}));
var Diagnostic$1;
(function (Diagnostic) {
    function create(range, message, severity, code, source, relatedInformation) {
        let result = { range, message };
        if (Is$1.defined(severity)) {
            result.severity = severity;
        }
        if (Is$1.defined(code)) {
            result.code = code;
        }
        if (Is$1.defined(source)) {
            result.source = source;
        }
        if (Is$1.defined(relatedInformation)) {
            result.relatedInformation = relatedInformation;
        }
        return result;
    }
    Diagnostic.create = create;
    function is(value) {
        var _a;
        let candidate = value;
        return Is$1.defined(candidate)
            && Range$1.is(candidate.range)
            && Is$1.string(candidate.message)
            && (Is$1.number(candidate.severity) || Is$1.undefined(candidate.severity))
            && (Is$1.integer(candidate.code) || Is$1.string(candidate.code) || Is$1.undefined(candidate.code))
            && (Is$1.undefined(candidate.codeDescription) || (Is$1.string((_a = candidate.codeDescription) === null || _a === void 0 ? void 0 : _a.href)))
            && (Is$1.string(candidate.source) || Is$1.undefined(candidate.source))
            && (Is$1.undefined(candidate.relatedInformation) || Is$1.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation$1.is));
    }
    Diagnostic.is = is;
})(Diagnostic$1 || (Diagnostic$1 = {}));
var Command$1;
(function (Command) {
    function create(title, command, ...args) {
        let result = { title, command };
        if (Is$1.defined(args) && args.length > 0) {
            result.arguments = args;
        }
        return result;
    }
    Command.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.string(candidate.title) && Is$1.string(candidate.command);
    }
    Command.is = is;
})(Command$1 || (Command$1 = {}));
var TextEdit$1;
(function (TextEdit) {
    function replace(range, newText) {
        return { range, newText };
    }
    TextEdit.replace = replace;
    function insert(position, newText) {
        return { range: { start: position, end: position }, newText };
    }
    TextEdit.insert = insert;
    function del(range) {
        return { range, newText: '' };
    }
    TextEdit.del = del;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate)
            && Is$1.string(candidate.newText)
            && Range$1.is(candidate.range);
    }
    TextEdit.is = is;
})(TextEdit$1 || (TextEdit$1 = {}));
var ChangeAnnotation$1;
(function (ChangeAnnotation) {
    function create(label, needsConfirmation, description) {
        const result = { label };
        if (needsConfirmation !== undefined) {
            result.needsConfirmation = needsConfirmation;
        }
        if (description !== undefined) {
            result.description = description;
        }
        return result;
    }
    ChangeAnnotation.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && Is$1.string(candidate.label) &&
            (Is$1.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === undefined) &&
            (Is$1.string(candidate.description) || candidate.description === undefined);
    }
    ChangeAnnotation.is = is;
})(ChangeAnnotation$1 || (ChangeAnnotation$1 = {}));
var ChangeAnnotationIdentifier$1;
(function (ChangeAnnotationIdentifier) {
    function is(value) {
        const candidate = value;
        return Is$1.string(candidate);
    }
    ChangeAnnotationIdentifier.is = is;
})(ChangeAnnotationIdentifier$1 || (ChangeAnnotationIdentifier$1 = {}));
var AnnotatedTextEdit$1;
(function (AnnotatedTextEdit) {
    function replace(range, newText, annotation) {
        return { range, newText, annotationId: annotation };
    }
    AnnotatedTextEdit.replace = replace;
    function insert(position, newText, annotation) {
        return { range: { start: position, end: position }, newText, annotationId: annotation };
    }
    AnnotatedTextEdit.insert = insert;
    function del(range, annotation) {
        return { range, newText: '', annotationId: annotation };
    }
    AnnotatedTextEdit.del = del;
    function is(value) {
        const candidate = value;
        return TextEdit$1.is(candidate) && (ChangeAnnotation$1.is(candidate.annotationId) || ChangeAnnotationIdentifier$1.is(candidate.annotationId));
    }
    AnnotatedTextEdit.is = is;
})(AnnotatedTextEdit$1 || (AnnotatedTextEdit$1 = {}));
var TextDocumentEdit$1;
(function (TextDocumentEdit) {
    function create(textDocument, edits) {
        return { textDocument, edits };
    }
    TextDocumentEdit.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate)
            && OptionalVersionedTextDocumentIdentifier$1.is(candidate.textDocument)
            && Array.isArray(candidate.edits);
    }
    TextDocumentEdit.is = is;
})(TextDocumentEdit$1 || (TextDocumentEdit$1 = {}));
var CreateFile$1;
(function (CreateFile) {
    function create(uri, options, annotation) {
        let result = {
            kind: 'create',
            uri
        };
        if (options !== undefined && (options.overwrite !== undefined || options.ignoreIfExists !== undefined)) {
            result.options = options;
        }
        if (annotation !== undefined) {
            result.annotationId = annotation;
        }
        return result;
    }
    CreateFile.create = create;
    function is(value) {
        let candidate = value;
        return candidate && candidate.kind === 'create' && Is$1.string(candidate.uri) && (candidate.options === undefined ||
            ((candidate.options.overwrite === undefined || Is$1.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === undefined || Is$1.boolean(candidate.options.ignoreIfExists)))) && (candidate.annotationId === undefined || ChangeAnnotationIdentifier$1.is(candidate.annotationId));
    }
    CreateFile.is = is;
})(CreateFile$1 || (CreateFile$1 = {}));
var RenameFile$1;
(function (RenameFile) {
    function create(oldUri, newUri, options, annotation) {
        let result = {
            kind: 'rename',
            oldUri,
            newUri
        };
        if (options !== undefined && (options.overwrite !== undefined || options.ignoreIfExists !== undefined)) {
            result.options = options;
        }
        if (annotation !== undefined) {
            result.annotationId = annotation;
        }
        return result;
    }
    RenameFile.create = create;
    function is(value) {
        let candidate = value;
        return candidate && candidate.kind === 'rename' && Is$1.string(candidate.oldUri) && Is$1.string(candidate.newUri) && (candidate.options === undefined ||
            ((candidate.options.overwrite === undefined || Is$1.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === undefined || Is$1.boolean(candidate.options.ignoreIfExists)))) && (candidate.annotationId === undefined || ChangeAnnotationIdentifier$1.is(candidate.annotationId));
    }
    RenameFile.is = is;
})(RenameFile$1 || (RenameFile$1 = {}));
var DeleteFile$1;
(function (DeleteFile) {
    function create(uri, options, annotation) {
        let result = {
            kind: 'delete',
            uri
        };
        if (options !== undefined && (options.recursive !== undefined || options.ignoreIfNotExists !== undefined)) {
            result.options = options;
        }
        if (annotation !== undefined) {
            result.annotationId = annotation;
        }
        return result;
    }
    DeleteFile.create = create;
    function is(value) {
        let candidate = value;
        return candidate && candidate.kind === 'delete' && Is$1.string(candidate.uri) && (candidate.options === undefined ||
            ((candidate.options.recursive === undefined || Is$1.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === undefined || Is$1.boolean(candidate.options.ignoreIfNotExists)))) && (candidate.annotationId === undefined || ChangeAnnotationIdentifier$1.is(candidate.annotationId));
    }
    DeleteFile.is = is;
})(DeleteFile$1 || (DeleteFile$1 = {}));
var WorkspaceEdit$1;
(function (WorkspaceEdit) {
    function is(value) {
        let candidate = value;
        return candidate &&
            (candidate.changes !== undefined || candidate.documentChanges !== undefined) &&
            (candidate.documentChanges === undefined || candidate.documentChanges.every((change) => {
                if (Is$1.string(change.kind)) {
                    return CreateFile$1.is(change) || RenameFile$1.is(change) || DeleteFile$1.is(change);
                }
                else {
                    return TextDocumentEdit$1.is(change);
                }
            }));
    }
    WorkspaceEdit.is = is;
})(WorkspaceEdit$1 || (WorkspaceEdit$1 = {}));
var TextDocumentIdentifier$1;
(function (TextDocumentIdentifier) {
    function create(uri) {
        return { uri };
    }
    TextDocumentIdentifier.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.string(candidate.uri);
    }
    TextDocumentIdentifier.is = is;
})(TextDocumentIdentifier$1 || (TextDocumentIdentifier$1 = {}));
var VersionedTextDocumentIdentifier$1;
(function (VersionedTextDocumentIdentifier) {
    function create(uri, version) {
        return { uri, version };
    }
    VersionedTextDocumentIdentifier.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.string(candidate.uri) && Is$1.integer(candidate.version);
    }
    VersionedTextDocumentIdentifier.is = is;
})(VersionedTextDocumentIdentifier$1 || (VersionedTextDocumentIdentifier$1 = {}));
var OptionalVersionedTextDocumentIdentifier$1;
(function (OptionalVersionedTextDocumentIdentifier) {
    function create(uri, version) {
        return { uri, version };
    }
    OptionalVersionedTextDocumentIdentifier.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.string(candidate.uri) && (candidate.version === null || Is$1.integer(candidate.version));
    }
    OptionalVersionedTextDocumentIdentifier.is = is;
})(OptionalVersionedTextDocumentIdentifier$1 || (OptionalVersionedTextDocumentIdentifier$1 = {}));
var TextDocumentItem$1;
(function (TextDocumentItem) {
    function create(uri, languageId, version, text) {
        return { uri, languageId, version, text };
    }
    TextDocumentItem.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.string(candidate.uri) && Is$1.string(candidate.languageId) && Is$1.integer(candidate.version) && Is$1.string(candidate.text);
    }
    TextDocumentItem.is = is;
})(TextDocumentItem$1 || (TextDocumentItem$1 = {}));
var MarkupKind$1;
(function (MarkupKind) {
    MarkupKind.PlainText = 'plaintext';
    MarkupKind.Markdown = 'markdown';
    function is(value) {
        const candidate = value;
        return candidate === MarkupKind.PlainText || candidate === MarkupKind.Markdown;
    }
    MarkupKind.is = is;
})(MarkupKind$1 || (MarkupKind$1 = {}));
var MarkupContent$1;
(function (MarkupContent) {
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(value) && MarkupKind$1.is(candidate.kind) && Is$1.string(candidate.value);
    }
    MarkupContent.is = is;
})(MarkupContent$1 || (MarkupContent$1 = {}));
var CompletionItemKind$1;
(function (CompletionItemKind) {
    CompletionItemKind.Text = 1;
    CompletionItemKind.Method = 2;
    CompletionItemKind.Function = 3;
    CompletionItemKind.Constructor = 4;
    CompletionItemKind.Field = 5;
    CompletionItemKind.Variable = 6;
    CompletionItemKind.Class = 7;
    CompletionItemKind.Interface = 8;
    CompletionItemKind.Module = 9;
    CompletionItemKind.Property = 10;
    CompletionItemKind.Unit = 11;
    CompletionItemKind.Value = 12;
    CompletionItemKind.Enum = 13;
    CompletionItemKind.Keyword = 14;
    CompletionItemKind.Snippet = 15;
    CompletionItemKind.Color = 16;
    CompletionItemKind.File = 17;
    CompletionItemKind.Reference = 18;
    CompletionItemKind.Folder = 19;
    CompletionItemKind.EnumMember = 20;
    CompletionItemKind.Constant = 21;
    CompletionItemKind.Struct = 22;
    CompletionItemKind.Event = 23;
    CompletionItemKind.Operator = 24;
    CompletionItemKind.TypeParameter = 25;
})(CompletionItemKind$1 || (CompletionItemKind$1 = {}));
var InsertTextFormat$1;
(function (InsertTextFormat) {
    InsertTextFormat.PlainText = 1;
    InsertTextFormat.Snippet = 2;
})(InsertTextFormat$1 || (InsertTextFormat$1 = {}));
var CompletionItemTag$1;
(function (CompletionItemTag) {
    CompletionItemTag.Deprecated = 1;
})(CompletionItemTag$1 || (CompletionItemTag$1 = {}));
var InsertReplaceEdit$1;
(function (InsertReplaceEdit) {
    function create(newText, insert, replace) {
        return { newText, insert, replace };
    }
    InsertReplaceEdit.create = create;
    function is(value) {
        const candidate = value;
        return candidate && Is$1.string(candidate.newText) && Range$1.is(candidate.insert) && Range$1.is(candidate.replace);
    }
    InsertReplaceEdit.is = is;
})(InsertReplaceEdit$1 || (InsertReplaceEdit$1 = {}));
var InsertTextMode$1;
(function (InsertTextMode) {
    InsertTextMode.asIs = 1;
    InsertTextMode.adjustIndentation = 2;
})(InsertTextMode$1 || (InsertTextMode$1 = {}));
var CompletionItemLabelDetails$1;
(function (CompletionItemLabelDetails) {
    function is(value) {
        const candidate = value;
        return candidate && (Is$1.string(candidate.detail) || candidate.detail === undefined) &&
            (Is$1.string(candidate.description) || candidate.description === undefined);
    }
    CompletionItemLabelDetails.is = is;
})(CompletionItemLabelDetails$1 || (CompletionItemLabelDetails$1 = {}));
var CompletionItem$1;
(function (CompletionItem) {
    function create(label) {
        return { label };
    }
    CompletionItem.create = create;
})(CompletionItem$1 || (CompletionItem$1 = {}));
var CompletionList$1;
(function (CompletionList) {
    function create(items, isIncomplete) {
        return { items: items ? items : [], isIncomplete: !!isIncomplete };
    }
    CompletionList.create = create;
})(CompletionList$1 || (CompletionList$1 = {}));
var MarkedString$1;
(function (MarkedString) {
    function fromPlainText(plainText) {
        return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, '\\$&');
    }
    MarkedString.fromPlainText = fromPlainText;
    function is(value) {
        const candidate = value;
        return Is$1.string(candidate) || (Is$1.objectLiteral(candidate) && Is$1.string(candidate.language) && Is$1.string(candidate.value));
    }
    MarkedString.is = is;
})(MarkedString$1 || (MarkedString$1 = {}));
var Hover$1;
(function (Hover) {
    function is(value) {
        let candidate = value;
        return !!candidate && Is$1.objectLiteral(candidate) && (MarkupContent$1.is(candidate.contents) ||
            MarkedString$1.is(candidate.contents) ||
            Is$1.typedArray(candidate.contents, MarkedString$1.is)) && (value.range === undefined || Range$1.is(value.range));
    }
    Hover.is = is;
})(Hover$1 || (Hover$1 = {}));
var ParameterInformation$1;
(function (ParameterInformation) {
    function create(label, documentation) {
        return documentation ? { label, documentation } : { label };
    }
    ParameterInformation.create = create;
})(ParameterInformation$1 || (ParameterInformation$1 = {}));
var SignatureInformation$1;
(function (SignatureInformation) {
    function create(label, documentation, ...parameters) {
        let result = { label };
        if (Is$1.defined(documentation)) {
            result.documentation = documentation;
        }
        if (Is$1.defined(parameters)) {
            result.parameters = parameters;
        }
        else {
            result.parameters = [];
        }
        return result;
    }
    SignatureInformation.create = create;
})(SignatureInformation$1 || (SignatureInformation$1 = {}));
var DocumentHighlightKind$1;
(function (DocumentHighlightKind) {
    DocumentHighlightKind.Text = 1;
    DocumentHighlightKind.Read = 2;
    DocumentHighlightKind.Write = 3;
})(DocumentHighlightKind$1 || (DocumentHighlightKind$1 = {}));
var DocumentHighlight$1;
(function (DocumentHighlight) {
    function create(range, kind) {
        let result = { range };
        if (Is$1.number(kind)) {
            result.kind = kind;
        }
        return result;
    }
    DocumentHighlight.create = create;
})(DocumentHighlight$1 || (DocumentHighlight$1 = {}));
var SymbolKind$1;
(function (SymbolKind) {
    SymbolKind.File = 1;
    SymbolKind.Module = 2;
    SymbolKind.Namespace = 3;
    SymbolKind.Package = 4;
    SymbolKind.Class = 5;
    SymbolKind.Method = 6;
    SymbolKind.Property = 7;
    SymbolKind.Field = 8;
    SymbolKind.Constructor = 9;
    SymbolKind.Enum = 10;
    SymbolKind.Interface = 11;
    SymbolKind.Function = 12;
    SymbolKind.Variable = 13;
    SymbolKind.Constant = 14;
    SymbolKind.String = 15;
    SymbolKind.Number = 16;
    SymbolKind.Boolean = 17;
    SymbolKind.Array = 18;
    SymbolKind.Object = 19;
    SymbolKind.Key = 20;
    SymbolKind.Null = 21;
    SymbolKind.EnumMember = 22;
    SymbolKind.Struct = 23;
    SymbolKind.Event = 24;
    SymbolKind.Operator = 25;
    SymbolKind.TypeParameter = 26;
})(SymbolKind$1 || (SymbolKind$1 = {}));
var SymbolTag$1;
(function (SymbolTag) {
    SymbolTag.Deprecated = 1;
})(SymbolTag$1 || (SymbolTag$1 = {}));
var SymbolInformation$1;
(function (SymbolInformation) {
    function create(name, kind, range, uri, containerName) {
        let result = {
            name,
            kind,
            location: { uri, range }
        };
        if (containerName) {
            result.containerName = containerName;
        }
        return result;
    }
    SymbolInformation.create = create;
})(SymbolInformation$1 || (SymbolInformation$1 = {}));
var WorkspaceSymbol$1;
(function (WorkspaceSymbol) {
    function create(name, kind, uri, range) {
        return range !== undefined
            ? { name, kind, location: { uri, range } }
            : { name, kind, location: { uri } };
    }
    WorkspaceSymbol.create = create;
})(WorkspaceSymbol$1 || (WorkspaceSymbol$1 = {}));
var DocumentSymbol$1;
(function (DocumentSymbol) {
    function create(name, detail, kind, range, selectionRange, children) {
        let result = {
            name,
            detail,
            kind,
            range,
            selectionRange
        };
        if (children !== undefined) {
            result.children = children;
        }
        return result;
    }
    DocumentSymbol.create = create;
    function is(value) {
        let candidate = value;
        return candidate &&
            Is$1.string(candidate.name) && Is$1.number(candidate.kind) &&
            Range$1.is(candidate.range) && Range$1.is(candidate.selectionRange) &&
            (candidate.detail === undefined || Is$1.string(candidate.detail)) &&
            (candidate.deprecated === undefined || Is$1.boolean(candidate.deprecated)) &&
            (candidate.children === undefined || Array.isArray(candidate.children)) &&
            (candidate.tags === undefined || Array.isArray(candidate.tags));
    }
    DocumentSymbol.is = is;
})(DocumentSymbol$1 || (DocumentSymbol$1 = {}));
var CodeActionKind$1;
(function (CodeActionKind) {
    CodeActionKind.Empty = '';
    CodeActionKind.QuickFix = 'quickfix';
    CodeActionKind.Refactor = 'refactor';
    CodeActionKind.RefactorExtract = 'refactor.extract';
    CodeActionKind.RefactorInline = 'refactor.inline';
    CodeActionKind.RefactorRewrite = 'refactor.rewrite';
    CodeActionKind.Source = 'source';
    CodeActionKind.SourceOrganizeImports = 'source.organizeImports';
    CodeActionKind.SourceFixAll = 'source.fixAll';
})(CodeActionKind$1 || (CodeActionKind$1 = {}));
var CodeActionTriggerKind$1;
(function (CodeActionTriggerKind) {
    CodeActionTriggerKind.Invoked = 1;
    CodeActionTriggerKind.Automatic = 2;
})(CodeActionTriggerKind$1 || (CodeActionTriggerKind$1 = {}));
var CodeActionContext$1;
(function (CodeActionContext) {
    function create(diagnostics, only, triggerKind) {
        let result = { diagnostics };
        if (only !== undefined && only !== null) {
            result.only = only;
        }
        if (triggerKind !== undefined && triggerKind !== null) {
            result.triggerKind = triggerKind;
        }
        return result;
    }
    CodeActionContext.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.typedArray(candidate.diagnostics, Diagnostic$1.is)
            && (candidate.only === undefined || Is$1.typedArray(candidate.only, Is$1.string))
            && (candidate.triggerKind === undefined || candidate.triggerKind === CodeActionTriggerKind$1.Invoked || candidate.triggerKind === CodeActionTriggerKind$1.Automatic);
    }
    CodeActionContext.is = is;
})(CodeActionContext$1 || (CodeActionContext$1 = {}));
var CodeAction$1;
(function (CodeAction) {
    function create(title, kindOrCommandOrEdit, kind) {
        let result = { title };
        let checkKind = true;
        if (typeof kindOrCommandOrEdit === 'string') {
            checkKind = false;
            result.kind = kindOrCommandOrEdit;
        }
        else if (Command$1.is(kindOrCommandOrEdit)) {
            result.command = kindOrCommandOrEdit;
        }
        else {
            result.edit = kindOrCommandOrEdit;
        }
        if (checkKind && kind !== undefined) {
            result.kind = kind;
        }
        return result;
    }
    CodeAction.create = create;
    function is(value) {
        let candidate = value;
        return candidate && Is$1.string(candidate.title) &&
            (candidate.diagnostics === undefined || Is$1.typedArray(candidate.diagnostics, Diagnostic$1.is)) &&
            (candidate.kind === undefined || Is$1.string(candidate.kind)) &&
            (candidate.edit !== undefined || candidate.command !== undefined) &&
            (candidate.command === undefined || Command$1.is(candidate.command)) &&
            (candidate.isPreferred === undefined || Is$1.boolean(candidate.isPreferred)) &&
            (candidate.edit === undefined || WorkspaceEdit$1.is(candidate.edit));
    }
    CodeAction.is = is;
})(CodeAction$1 || (CodeAction$1 = {}));
var CodeLens$1;
(function (CodeLens) {
    function create(range, data) {
        let result = { range };
        if (Is$1.defined(data)) {
            result.data = data;
        }
        return result;
    }
    CodeLens.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Range$1.is(candidate.range) && (Is$1.undefined(candidate.command) || Command$1.is(candidate.command));
    }
    CodeLens.is = is;
})(CodeLens$1 || (CodeLens$1 = {}));
var FormattingOptions$1;
(function (FormattingOptions) {
    function create(tabSize, insertSpaces) {
        return { tabSize, insertSpaces };
    }
    FormattingOptions.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.uinteger(candidate.tabSize) && Is$1.boolean(candidate.insertSpaces);
    }
    FormattingOptions.is = is;
})(FormattingOptions$1 || (FormattingOptions$1 = {}));
var DocumentLink$1;
(function (DocumentLink) {
    function create(range, target, data) {
        return { range, target, data };
    }
    DocumentLink.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Range$1.is(candidate.range) && (Is$1.undefined(candidate.target) || Is$1.string(candidate.target));
    }
    DocumentLink.is = is;
})(DocumentLink$1 || (DocumentLink$1 = {}));
var SelectionRange$1;
(function (SelectionRange) {
    function create(range, parent) {
        return { range, parent };
    }
    SelectionRange.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.objectLiteral(candidate) && Range$1.is(candidate.range) && (candidate.parent === undefined || SelectionRange.is(candidate.parent));
    }
    SelectionRange.is = is;
})(SelectionRange$1 || (SelectionRange$1 = {}));
var SemanticTokenTypes$1;
(function (SemanticTokenTypes) {
    SemanticTokenTypes["namespace"] = "namespace";
    SemanticTokenTypes["type"] = "type";
    SemanticTokenTypes["class"] = "class";
    SemanticTokenTypes["enum"] = "enum";
    SemanticTokenTypes["interface"] = "interface";
    SemanticTokenTypes["struct"] = "struct";
    SemanticTokenTypes["typeParameter"] = "typeParameter";
    SemanticTokenTypes["parameter"] = "parameter";
    SemanticTokenTypes["variable"] = "variable";
    SemanticTokenTypes["property"] = "property";
    SemanticTokenTypes["enumMember"] = "enumMember";
    SemanticTokenTypes["event"] = "event";
    SemanticTokenTypes["function"] = "function";
    SemanticTokenTypes["method"] = "method";
    SemanticTokenTypes["macro"] = "macro";
    SemanticTokenTypes["keyword"] = "keyword";
    SemanticTokenTypes["modifier"] = "modifier";
    SemanticTokenTypes["comment"] = "comment";
    SemanticTokenTypes["string"] = "string";
    SemanticTokenTypes["number"] = "number";
    SemanticTokenTypes["regexp"] = "regexp";
    SemanticTokenTypes["operator"] = "operator";
    SemanticTokenTypes["decorator"] = "decorator";
})(SemanticTokenTypes$1 || (SemanticTokenTypes$1 = {}));
var SemanticTokenModifiers$1;
(function (SemanticTokenModifiers) {
    SemanticTokenModifiers["declaration"] = "declaration";
    SemanticTokenModifiers["definition"] = "definition";
    SemanticTokenModifiers["readonly"] = "readonly";
    SemanticTokenModifiers["static"] = "static";
    SemanticTokenModifiers["deprecated"] = "deprecated";
    SemanticTokenModifiers["abstract"] = "abstract";
    SemanticTokenModifiers["async"] = "async";
    SemanticTokenModifiers["modification"] = "modification";
    SemanticTokenModifiers["documentation"] = "documentation";
    SemanticTokenModifiers["defaultLibrary"] = "defaultLibrary";
})(SemanticTokenModifiers$1 || (SemanticTokenModifiers$1 = {}));
var SemanticTokens$1;
(function (SemanticTokens) {
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && (candidate.resultId === undefined || typeof candidate.resultId === 'string') &&
            Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === 'number');
    }
    SemanticTokens.is = is;
})(SemanticTokens$1 || (SemanticTokens$1 = {}));
var InlineValueText$1;
(function (InlineValueText) {
    function create(range, text) {
        return { range, text };
    }
    InlineValueText.create = create;
    function is(value) {
        const candidate = value;
        return candidate !== undefined && candidate !== null && Range$1.is(candidate.range) && Is$1.string(candidate.text);
    }
    InlineValueText.is = is;
})(InlineValueText$1 || (InlineValueText$1 = {}));
var InlineValueVariableLookup$1;
(function (InlineValueVariableLookup) {
    function create(range, variableName, caseSensitiveLookup) {
        return { range, variableName, caseSensitiveLookup };
    }
    InlineValueVariableLookup.create = create;
    function is(value) {
        const candidate = value;
        return candidate !== undefined && candidate !== null && Range$1.is(candidate.range) && Is$1.boolean(candidate.caseSensitiveLookup)
            && (Is$1.string(candidate.variableName) || candidate.variableName === undefined);
    }
    InlineValueVariableLookup.is = is;
})(InlineValueVariableLookup$1 || (InlineValueVariableLookup$1 = {}));
var InlineValueEvaluatableExpression$1;
(function (InlineValueEvaluatableExpression) {
    function create(range, expression) {
        return { range, expression };
    }
    InlineValueEvaluatableExpression.create = create;
    function is(value) {
        const candidate = value;
        return candidate !== undefined && candidate !== null && Range$1.is(candidate.range)
            && (Is$1.string(candidate.expression) || candidate.expression === undefined);
    }
    InlineValueEvaluatableExpression.is = is;
})(InlineValueEvaluatableExpression$1 || (InlineValueEvaluatableExpression$1 = {}));
var InlineValueContext$1;
(function (InlineValueContext) {
    function create(frameId, stoppedLocation) {
        return { frameId, stoppedLocation };
    }
    InlineValueContext.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.defined(candidate) && Range$1.is(value.stoppedLocation);
    }
    InlineValueContext.is = is;
})(InlineValueContext$1 || (InlineValueContext$1 = {}));
var InlayHintKind$1;
(function (InlayHintKind) {
    InlayHintKind.Type = 1;
    InlayHintKind.Parameter = 2;
    function is(value) {
        return value === 1 || value === 2;
    }
    InlayHintKind.is = is;
})(InlayHintKind$1 || (InlayHintKind$1 = {}));
var InlayHintLabelPart$1;
(function (InlayHintLabelPart) {
    function create(value) {
        return { value };
    }
    InlayHintLabelPart.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate)
            && (candidate.tooltip === undefined || Is$1.string(candidate.tooltip) || MarkupContent$1.is(candidate.tooltip))
            && (candidate.location === undefined || Location$1.is(candidate.location))
            && (candidate.command === undefined || Command$1.is(candidate.command));
    }
    InlayHintLabelPart.is = is;
})(InlayHintLabelPart$1 || (InlayHintLabelPart$1 = {}));
var InlayHint$1;
(function (InlayHint) {
    function create(position, label, kind) {
        const result = { position, label };
        if (kind !== undefined) {
            result.kind = kind;
        }
        return result;
    }
    InlayHint.create = create;
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && Position$1.is(candidate.position)
            && (Is$1.string(candidate.label) || Is$1.typedArray(candidate.label, InlayHintLabelPart$1.is))
            && (candidate.kind === undefined || InlayHintKind$1.is(candidate.kind))
            && (candidate.textEdits === undefined) || Is$1.typedArray(candidate.textEdits, TextEdit$1.is)
            && (candidate.tooltip === undefined || Is$1.string(candidate.tooltip) || MarkupContent$1.is(candidate.tooltip))
            && (candidate.paddingLeft === undefined || Is$1.boolean(candidate.paddingLeft))
            && (candidate.paddingRight === undefined || Is$1.boolean(candidate.paddingRight));
    }
    InlayHint.is = is;
})(InlayHint$1 || (InlayHint$1 = {}));
var StringValue;
(function (StringValue) {
    function createSnippet(value) {
        return { kind: 'snippet', value };
    }
    StringValue.createSnippet = createSnippet;
})(StringValue || (StringValue = {}));
var InlineCompletionItem;
(function (InlineCompletionItem) {
    function create(insertText, filterText, range, command) {
        return { insertText, filterText, range, command };
    }
    InlineCompletionItem.create = create;
})(InlineCompletionItem || (InlineCompletionItem = {}));
var InlineCompletionList;
(function (InlineCompletionList) {
    function create(items) {
        return { items };
    }
    InlineCompletionList.create = create;
})(InlineCompletionList || (InlineCompletionList = {}));
var InlineCompletionTriggerKind;
(function (InlineCompletionTriggerKind) {
    InlineCompletionTriggerKind.Invoked = 0;
    InlineCompletionTriggerKind.Automatic = 1;
})(InlineCompletionTriggerKind || (InlineCompletionTriggerKind = {}));
var SelectedCompletionInfo;
(function (SelectedCompletionInfo) {
    function create(range, text) {
        return { range, text };
    }
    SelectedCompletionInfo.create = create;
})(SelectedCompletionInfo || (SelectedCompletionInfo = {}));
var InlineCompletionContext;
(function (InlineCompletionContext) {
    function create(triggerKind, selectedCompletionInfo) {
        return { triggerKind, selectedCompletionInfo };
    }
    InlineCompletionContext.create = create;
})(InlineCompletionContext || (InlineCompletionContext = {}));
var WorkspaceFolder$1;
(function (WorkspaceFolder) {
    function is(value) {
        const candidate = value;
        return Is$1.objectLiteral(candidate) && URI$3.is(candidate.uri) && Is$1.string(candidate.name);
    }
    WorkspaceFolder.is = is;
})(WorkspaceFolder$1 || (WorkspaceFolder$1 = {}));
var TextDocument$2;
(function (TextDocument) {
    function create(uri, languageId, version, content) {
        return new FullTextDocument$2(uri, languageId, version, content);
    }
    TextDocument.create = create;
    function is(value) {
        let candidate = value;
        return Is$1.defined(candidate) && Is$1.string(candidate.uri) && (Is$1.undefined(candidate.languageId) || Is$1.string(candidate.languageId)) && Is$1.uinteger(candidate.lineCount)
            && Is$1.func(candidate.getText) && Is$1.func(candidate.positionAt) && Is$1.func(candidate.offsetAt) ? true : false;
    }
    TextDocument.is = is;
    function applyEdits(document, edits) {
        let text = document.getText();
        let sortedEdits = mergeSort(edits, (a, b) => {
            let diff = a.range.start.line - b.range.start.line;
            if (diff === 0) {
                return a.range.start.character - b.range.start.character;
            }
            return diff;
        });
        let lastModifiedOffset = text.length;
        for (let i = sortedEdits.length - 1; i >= 0; i--) {
            let e = sortedEdits[i];
            let startOffset = document.offsetAt(e.range.start);
            let endOffset = document.offsetAt(e.range.end);
            if (endOffset <= lastModifiedOffset) {
                text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
            }
            else {
                throw new Error('Overlapping edit');
            }
            lastModifiedOffset = startOffset;
        }
        return text;
    }
    TextDocument.applyEdits = applyEdits;
    function mergeSort(data, compare) {
        if (data.length <= 1) {
            return data;
        }
        const p = (data.length / 2) | 0;
        const left = data.slice(0, p);
        const right = data.slice(p);
        mergeSort(left, compare);
        mergeSort(right, compare);
        let leftIdx = 0;
        let rightIdx = 0;
        let i = 0;
        while (leftIdx < left.length && rightIdx < right.length) {
            let ret = compare(left[leftIdx], right[rightIdx]);
            if (ret <= 0) {
                data[i++] = left[leftIdx++];
            }
            else {
                data[i++] = right[rightIdx++];
            }
        }
        while (leftIdx < left.length) {
            data[i++] = left[leftIdx++];
        }
        while (rightIdx < right.length) {
            data[i++] = right[rightIdx++];
        }
        return data;
    }
})(TextDocument$2 || (TextDocument$2 = {}));
let FullTextDocument$2 = class FullTextDocument {
    constructor(uri, languageId, version, content) {
        this._uri = uri;
        this._languageId = languageId;
        this._version = version;
        this._content = content;
        this._lineOffsets = undefined;
    }
    get uri() {
        return this._uri;
    }
    get languageId() {
        return this._languageId;
    }
    get version() {
        return this._version;
    }
    getText(range) {
        if (range) {
            let start = this.offsetAt(range.start);
            let end = this.offsetAt(range.end);
            return this._content.substring(start, end);
        }
        return this._content;
    }
    update(event, version) {
        this._content = event.text;
        this._version = version;
        this._lineOffsets = undefined;
    }
    getLineOffsets() {
        if (this._lineOffsets === undefined) {
            let lineOffsets = [];
            let text = this._content;
            let isLineStart = true;
            for (let i = 0; i < text.length; i++) {
                if (isLineStart) {
                    lineOffsets.push(i);
                    isLineStart = false;
                }
                let ch = text.charAt(i);
                isLineStart = (ch === '\r' || ch === '\n');
                if (ch === '\r' && i + 1 < text.length && text.charAt(i + 1) === '\n') {
                    i++;
                }
            }
            if (isLineStart && text.length > 0) {
                lineOffsets.push(text.length);
            }
            this._lineOffsets = lineOffsets;
        }
        return this._lineOffsets;
    }
    positionAt(offset) {
        offset = Math.max(Math.min(offset, this._content.length), 0);
        let lineOffsets = this.getLineOffsets();
        let low = 0, high = lineOffsets.length;
        if (high === 0) {
            return Position$1.create(0, offset);
        }
        while (low < high) {
            let mid = Math.floor((low + high) / 2);
            if (lineOffsets[mid] > offset) {
                high = mid;
            }
            else {
                low = mid + 1;
            }
        }
        let line = low - 1;
        return Position$1.create(line, offset - lineOffsets[line]);
    }
    offsetAt(position) {
        let lineOffsets = this.getLineOffsets();
        if (position.line >= lineOffsets.length) {
            return this._content.length;
        }
        else if (position.line < 0) {
            return 0;
        }
        let lineOffset = lineOffsets[position.line];
        let nextLineOffset = (position.line + 1 < lineOffsets.length) ? lineOffsets[position.line + 1] : this._content.length;
        return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
    }
    get lineCount() {
        return this.getLineOffsets().length;
    }
};
var Is$1;
(function (Is) {
    const toString = Object.prototype.toString;
    function defined(value) {
        return typeof value !== 'undefined';
    }
    Is.defined = defined;
    function undefined$1(value) {
        return typeof value === 'undefined';
    }
    Is.undefined = undefined$1;
    function boolean(value) {
        return value === true || value === false;
    }
    Is.boolean = boolean;
    function string(value) {
        return toString.call(value) === '[object String]';
    }
    Is.string = string;
    function number(value) {
        return toString.call(value) === '[object Number]';
    }
    Is.number = number;
    function numberRange(value, min, max) {
        return toString.call(value) === '[object Number]' && min <= value && value <= max;
    }
    Is.numberRange = numberRange;
    function integer(value) {
        return toString.call(value) === '[object Number]' && -2147483648 <= value && value <= 2147483647;
    }
    Is.integer = integer;
    function uinteger(value) {
        return toString.call(value) === '[object Number]' && 0 <= value && value <= 2147483647;
    }
    Is.uinteger = uinteger;
    function func(value) {
        return toString.call(value) === '[object Function]';
    }
    Is.func = func;
    function objectLiteral(value) {
        return value !== null && typeof value === 'object';
    }
    Is.objectLiteral = objectLiteral;
    function typedArray(value, check) {
        return Array.isArray(value) && value.every(check);
    }
    Is.typedArray = typedArray;
})(Is$1 || (Is$1 = {}));

let FullTextDocument$1 = class FullTextDocument {
    constructor(uri, languageId, version, content) {
        this._uri = uri;
        this._languageId = languageId;
        this._version = version;
        this._content = content;
        this._lineOffsets = undefined;
    }
    get uri() {
        return this._uri;
    }
    get languageId() {
        return this._languageId;
    }
    get version() {
        return this._version;
    }
    getText(range) {
        if (range) {
            const start = this.offsetAt(range.start);
            const end = this.offsetAt(range.end);
            return this._content.substring(start, end);
        }
        return this._content;
    }
    update(changes, version) {
        for (const change of changes) {
            if (FullTextDocument$1.isIncremental(change)) {
                const range = getWellformedRange(change.range);
                const startOffset = this.offsetAt(range.start);
                const endOffset = this.offsetAt(range.end);
                this._content = this._content.substring(0, startOffset) + change.text + this._content.substring(endOffset, this._content.length);
                const startLine = Math.max(range.start.line, 0);
                const endLine = Math.max(range.end.line, 0);
                let lineOffsets = this._lineOffsets;
                const addedLineOffsets = computeLineOffsets(change.text, false, startOffset);
                if (endLine - startLine === addedLineOffsets.length) {
                    for (let i = 0, len = addedLineOffsets.length; i < len; i++) {
                        lineOffsets[i + startLine + 1] = addedLineOffsets[i];
                    }
                }
                else {
                    if (addedLineOffsets.length < 10000) {
                        lineOffsets.splice(startLine + 1, endLine - startLine, ...addedLineOffsets);
                    }
                    else {
                        this._lineOffsets = lineOffsets = lineOffsets.slice(0, startLine + 1).concat(addedLineOffsets, lineOffsets.slice(endLine + 1));
                    }
                }
                const diff = change.text.length - (endOffset - startOffset);
                if (diff !== 0) {
                    for (let i = startLine + 1 + addedLineOffsets.length, len = lineOffsets.length; i < len; i++) {
                        lineOffsets[i] = lineOffsets[i] + diff;
                    }
                }
            }
            else if (FullTextDocument$1.isFull(change)) {
                this._content = change.text;
                this._lineOffsets = undefined;
            }
            else {
                throw new Error('Unknown change event received');
            }
        }
        this._version = version;
    }
    getLineOffsets() {
        if (this._lineOffsets === undefined) {
            this._lineOffsets = computeLineOffsets(this._content, true);
        }
        return this._lineOffsets;
    }
    positionAt(offset) {
        offset = Math.max(Math.min(offset, this._content.length), 0);
        const lineOffsets = this.getLineOffsets();
        let low = 0, high = lineOffsets.length;
        if (high === 0) {
            return { line: 0, character: offset };
        }
        while (low < high) {
            const mid = Math.floor((low + high) / 2);
            if (lineOffsets[mid] > offset) {
                high = mid;
            }
            else {
                low = mid + 1;
            }
        }
        const line = low - 1;
        offset = this.ensureBeforeEOL(offset, lineOffsets[line]);
        return { line, character: offset - lineOffsets[line] };
    }
    offsetAt(position) {
        const lineOffsets = this.getLineOffsets();
        if (position.line >= lineOffsets.length) {
            return this._content.length;
        }
        else if (position.line < 0) {
            return 0;
        }
        const lineOffset = lineOffsets[position.line];
        if (position.character <= 0) {
            return lineOffset;
        }
        const nextLineOffset = (position.line + 1 < lineOffsets.length) ? lineOffsets[position.line + 1] : this._content.length;
        const offset = Math.min(lineOffset + position.character, nextLineOffset);
        return this.ensureBeforeEOL(offset, lineOffset);
    }
    ensureBeforeEOL(offset, lineOffset) {
        while (offset > lineOffset && isEOL$2(this._content.charCodeAt(offset - 1))) {
            offset--;
        }
        return offset;
    }
    get lineCount() {
        return this.getLineOffsets().length;
    }
    static isIncremental(event) {
        const candidate = event;
        return candidate !== undefined && candidate !== null &&
            typeof candidate.text === 'string' && candidate.range !== undefined &&
            (candidate.rangeLength === undefined || typeof candidate.rangeLength === 'number');
    }
    static isFull(event) {
        const candidate = event;
        return candidate !== undefined && candidate !== null &&
            typeof candidate.text === 'string' && candidate.range === undefined && candidate.rangeLength === undefined;
    }
};
var TextDocument$1;
(function (TextDocument) {
    function create(uri, languageId, version, content) {
        return new FullTextDocument$1(uri, languageId, version, content);
    }
    TextDocument.create = create;
    function update(document, changes, version) {
        if (document instanceof FullTextDocument$1) {
            document.update(changes, version);
            return document;
        }
        else {
            throw new Error('TextDocument.update: document must be created by TextDocument.create');
        }
    }
    TextDocument.update = update;
    function applyEdits(document, edits) {
        const text = document.getText();
        const sortedEdits = mergeSort(edits.map(getWellformedEdit), (a, b) => {
            const diff = a.range.start.line - b.range.start.line;
            if (diff === 0) {
                return a.range.start.character - b.range.start.character;
            }
            return diff;
        });
        let lastModifiedOffset = 0;
        const spans = [];
        for (const e of sortedEdits) {
            const startOffset = document.offsetAt(e.range.start);
            if (startOffset < lastModifiedOffset) {
                throw new Error('Overlapping edit');
            }
            else if (startOffset > lastModifiedOffset) {
                spans.push(text.substring(lastModifiedOffset, startOffset));
            }
            if (e.newText.length) {
                spans.push(e.newText);
            }
            lastModifiedOffset = document.offsetAt(e.range.end);
        }
        spans.push(text.substr(lastModifiedOffset));
        return spans.join('');
    }
    TextDocument.applyEdits = applyEdits;
})(TextDocument$1 || (TextDocument$1 = {}));
function mergeSort(data, compare) {
    if (data.length <= 1) {
        return data;
    }
    const p = (data.length / 2) | 0;
    const left = data.slice(0, p);
    const right = data.slice(p);
    mergeSort(left, compare);
    mergeSort(right, compare);
    let leftIdx = 0;
    let rightIdx = 0;
    let i = 0;
    while (leftIdx < left.length && rightIdx < right.length) {
        const ret = compare(left[leftIdx], right[rightIdx]);
        if (ret <= 0) {
            data[i++] = left[leftIdx++];
        }
        else {
            data[i++] = right[rightIdx++];
        }
    }
    while (leftIdx < left.length) {
        data[i++] = left[leftIdx++];
    }
    while (rightIdx < right.length) {
        data[i++] = right[rightIdx++];
    }
    return data;
}
function computeLineOffsets(text, isAtLineStart, textOffset = 0) {
    const result = isAtLineStart ? [textOffset] : [];
    for (let i = 0; i < text.length; i++) {
        const ch = text.charCodeAt(i);
        if (isEOL$2(ch)) {
            if (ch === 13  && i + 1 < text.length && text.charCodeAt(i + 1) === 10 ) {
                i++;
            }
            result.push(textOffset + i + 1);
        }
    }
    return result;
}
function isEOL$2(char) {
    return char === 13  || char === 10 ;
}
function getWellformedRange(range) {
    const start = range.start;
    const end = range.end;
    if (start.line > end.line || (start.line === end.line && start.character > end.character)) {
        return { start: end, end: start };
    }
    return range;
}
function getWellformedEdit(textEdit) {
    const range = getWellformedRange(textEdit.range);
    if (range !== textEdit.range) {
        return { newText: textEdit.newText, range };
    }
    return textEdit;
}

var TokenType$1;
(function (TokenType) {
    TokenType[TokenType["StartCommentTag"] = 0] = "StartCommentTag";
    TokenType[TokenType["Comment"] = 1] = "Comment";
    TokenType[TokenType["EndCommentTag"] = 2] = "EndCommentTag";
    TokenType[TokenType["StartTagOpen"] = 3] = "StartTagOpen";
    TokenType[TokenType["StartTagClose"] = 4] = "StartTagClose";
    TokenType[TokenType["StartTagSelfClose"] = 5] = "StartTagSelfClose";
    TokenType[TokenType["StartTag"] = 6] = "StartTag";
    TokenType[TokenType["EndTagOpen"] = 7] = "EndTagOpen";
    TokenType[TokenType["EndTagClose"] = 8] = "EndTagClose";
    TokenType[TokenType["EndTag"] = 9] = "EndTag";
    TokenType[TokenType["DelimiterAssign"] = 10] = "DelimiterAssign";
    TokenType[TokenType["AttributeName"] = 11] = "AttributeName";
    TokenType[TokenType["AttributeValue"] = 12] = "AttributeValue";
    TokenType[TokenType["StartDoctypeTag"] = 13] = "StartDoctypeTag";
    TokenType[TokenType["Doctype"] = 14] = "Doctype";
    TokenType[TokenType["EndDoctypeTag"] = 15] = "EndDoctypeTag";
    TokenType[TokenType["Content"] = 16] = "Content";
    TokenType[TokenType["Whitespace"] = 17] = "Whitespace";
    TokenType[TokenType["Unknown"] = 18] = "Unknown";
    TokenType[TokenType["Script"] = 19] = "Script";
    TokenType[TokenType["Styles"] = 20] = "Styles";
    TokenType[TokenType["EOS"] = 21] = "EOS";
})(TokenType$1 || (TokenType$1 = {}));
var ScannerState;
(function (ScannerState) {
    ScannerState[ScannerState["WithinContent"] = 0] = "WithinContent";
    ScannerState[ScannerState["AfterOpeningStartTag"] = 1] = "AfterOpeningStartTag";
    ScannerState[ScannerState["AfterOpeningEndTag"] = 2] = "AfterOpeningEndTag";
    ScannerState[ScannerState["WithinDoctype"] = 3] = "WithinDoctype";
    ScannerState[ScannerState["WithinTag"] = 4] = "WithinTag";
    ScannerState[ScannerState["WithinEndTag"] = 5] = "WithinEndTag";
    ScannerState[ScannerState["WithinComment"] = 6] = "WithinComment";
    ScannerState[ScannerState["WithinScriptContent"] = 7] = "WithinScriptContent";
    ScannerState[ScannerState["WithinStyleContent"] = 8] = "WithinStyleContent";
    ScannerState[ScannerState["AfterAttributeName"] = 9] = "AfterAttributeName";
    ScannerState[ScannerState["BeforeAttributeValue"] = 10] = "BeforeAttributeValue";
})(ScannerState || (ScannerState = {}));
var ClientCapabilities$1;
(function (ClientCapabilities) {
    ClientCapabilities.LATEST = {
        textDocument: {
            completion: {
                completionItem: {
                    documentationFormat: [MarkupKind$1.Markdown, MarkupKind$1.PlainText]
                }
            },
            hover: {
                contentFormat: [MarkupKind$1.Markdown, MarkupKind$1.PlainText]
            }
        }
    };
})(ClientCapabilities$1 || (ClientCapabilities$1 = {}));
var FileType$2;
(function (FileType) {
    FileType[FileType["Unknown"] = 0] = "Unknown";
    FileType[FileType["File"] = 1] = "File";
    FileType[FileType["Directory"] = 2] = "Directory";
    FileType[FileType["SymbolicLink"] = 64] = "SymbolicLink";
})(FileType$2 || (FileType$2 = {}));

let MultiLineStream$1 = class MultiLineStream {
    constructor(source, position) {
        this.source = source;
        this.len = source.length;
        this.position = position;
    }
    eos() {
        return this.len <= this.position;
    }
    getSource() {
        return this.source;
    }
    pos() {
        return this.position;
    }
    goBackTo(pos) {
        this.position = pos;
    }
    goBack(n) {
        this.position -= n;
    }
    advance(n) {
        this.position += n;
    }
    goToEnd() {
        this.position = this.source.length;
    }
    nextChar() {
        return this.source.charCodeAt(this.position++) || 0;
    }
    peekChar(n = 0) {
        return this.source.charCodeAt(this.position + n) || 0;
    }
    advanceIfChar(ch) {
        if (ch === this.source.charCodeAt(this.position)) {
            this.position++;
            return true;
        }
        return false;
    }
    advanceIfChars(ch) {
        let i;
        if (this.position + ch.length > this.source.length) {
            return false;
        }
        for (i = 0; i < ch.length; i++) {
            if (this.source.charCodeAt(this.position + i) !== ch[i]) {
                return false;
            }
        }
        this.advance(i);
        return true;
    }
    advanceIfRegExp(regex) {
        const str = this.source.substr(this.position);
        const match = str.match(regex);
        if (match) {
            this.position = this.position + match.index + match[0].length;
            return match[0];
        }
        return '';
    }
    advanceUntilRegExp(regex) {
        const str = this.source.substr(this.position);
        const match = str.match(regex);
        if (match) {
            this.position = this.position + match.index;
            return match[0];
        }
        else {
            this.goToEnd();
        }
        return '';
    }
    advanceUntilChar(ch) {
        while (this.position < this.source.length) {
            if (this.source.charCodeAt(this.position) === ch) {
                return true;
            }
            this.advance(1);
        }
        return false;
    }
    advanceUntilChars(ch) {
        while (this.position + ch.length <= this.source.length) {
            let i = 0;
            for (; i < ch.length && this.source.charCodeAt(this.position + i) === ch[i]; i++) {
            }
            if (i === ch.length) {
                return true;
            }
            this.advance(1);
        }
        this.goToEnd();
        return false;
    }
    skipWhitespace() {
        const n = this.advanceWhileChar(ch => {
            return ch === _WSP$1 || ch === _TAB$1 || ch === _NWL$3 || ch === _LFD$3 || ch === _CAR$3;
        });
        return n > 0;
    }
    advanceWhileChar(condition) {
        const posNow = this.position;
        while (this.position < this.len && condition(this.source.charCodeAt(this.position))) {
            this.position++;
        }
        return this.position - posNow;
    }
};
const _BNG$2 = '!'.charCodeAt(0);
const _MIN$1 = '-'.charCodeAt(0);
const _LAN$2 = '<'.charCodeAt(0);
const _RAN$2 = '>'.charCodeAt(0);
const _FSL$3 = '/'.charCodeAt(0);
const _EQS$2 = '='.charCodeAt(0);
const _DQO$1 = '"'.charCodeAt(0);
const _SQO$1 = '\''.charCodeAt(0);
const _NWL$3 = '\n'.charCodeAt(0);
const _CAR$3 = '\r'.charCodeAt(0);
const _LFD$3 = '\f'.charCodeAt(0);
const _WSP$1 = ' '.charCodeAt(0);
const _TAB$1 = '\t'.charCodeAt(0);
const htmlScriptContents = {
    'text/x-handlebars-template': true,
    'text/html': true,
};
function createScanner$1(input, initialOffset = 0, initialState = ScannerState.WithinContent, emitPseudoCloseTags = false) {
    const stream = new MultiLineStream$1(input, initialOffset);
    let state = initialState;
    let tokenOffset = 0;
    let tokenType = TokenType$1.Unknown;
    let tokenError;
    let hasSpaceAfterTag;
    let lastTag;
    let lastAttributeName;
    let lastTypeValue;
    function nextElementName() {
        return stream.advanceIfRegExp(/^[_:\w][_:\w-.\d]*/).toLowerCase();
    }
    function nextAttributeName() {
        return stream.advanceIfRegExp(/^[^\s"'></=\x00-\x0F\x7F\x80-\x9F]*/).toLowerCase();
    }
    function finishToken(offset, type, errorMessage) {
        tokenType = type;
        tokenOffset = offset;
        tokenError = errorMessage;
        return type;
    }
    function scan() {
        const offset = stream.pos();
        const oldState = state;
        const token = internalScan();
        if (token !== TokenType$1.EOS && offset === stream.pos() && !(emitPseudoCloseTags && (token === TokenType$1.StartTagClose || token === TokenType$1.EndTagClose))) {
            console.warn('Scanner.scan has not advanced at offset ' + offset + ', state before: ' + oldState + ' after: ' + state);
            stream.advance(1);
            return finishToken(offset, TokenType$1.Unknown);
        }
        return token;
    }
    function internalScan() {
        const offset = stream.pos();
        if (stream.eos()) {
            return finishToken(offset, TokenType$1.EOS);
        }
        let errorMessage;
        switch (state) {
            case ScannerState.WithinComment:
                if (stream.advanceIfChars([_MIN$1, _MIN$1, _RAN$2])) {
                    state = ScannerState.WithinContent;
                    return finishToken(offset, TokenType$1.EndCommentTag);
                }
                stream.advanceUntilChars([_MIN$1, _MIN$1, _RAN$2]);
                return finishToken(offset, TokenType$1.Comment);
            case ScannerState.WithinDoctype:
                if (stream.advanceIfChar(_RAN$2)) {
                    state = ScannerState.WithinContent;
                    return finishToken(offset, TokenType$1.EndDoctypeTag);
                }
                stream.advanceUntilChar(_RAN$2);
                return finishToken(offset, TokenType$1.Doctype);
            case ScannerState.WithinContent:
                if (stream.advanceIfChar(_LAN$2)) {
                    if (!stream.eos() && stream.peekChar() === _BNG$2) {
                        if (stream.advanceIfChars([_BNG$2, _MIN$1, _MIN$1])) {
                            state = ScannerState.WithinComment;
                            return finishToken(offset, TokenType$1.StartCommentTag);
                        }
                        if (stream.advanceIfRegExp(/^!doctype/i)) {
                            state = ScannerState.WithinDoctype;
                            return finishToken(offset, TokenType$1.StartDoctypeTag);
                        }
                    }
                    if (stream.advanceIfChar(_FSL$3)) {
                        state = ScannerState.AfterOpeningEndTag;
                        return finishToken(offset, TokenType$1.EndTagOpen);
                    }
                    state = ScannerState.AfterOpeningStartTag;
                    return finishToken(offset, TokenType$1.StartTagOpen);
                }
                stream.advanceUntilChar(_LAN$2);
                return finishToken(offset, TokenType$1.Content);
            case ScannerState.AfterOpeningEndTag:
                const tagName = nextElementName();
                if (tagName.length > 0) {
                    state = ScannerState.WithinEndTag;
                    return finishToken(offset, TokenType$1.EndTag);
                }
                if (stream.skipWhitespace()) {
                    return finishToken(offset, TokenType$1.Whitespace, main$4.t('Tag name must directly follow the open bracket.'));
                }
                state = ScannerState.WithinEndTag;
                stream.advanceUntilChar(_RAN$2);
                if (offset < stream.pos()) {
                    return finishToken(offset, TokenType$1.Unknown, main$4.t('End tag name expected.'));
                }
                return internalScan();
            case ScannerState.WithinEndTag:
                if (stream.skipWhitespace()) {
                    return finishToken(offset, TokenType$1.Whitespace);
                }
                if (stream.advanceIfChar(_RAN$2)) {
                    state = ScannerState.WithinContent;
                    return finishToken(offset, TokenType$1.EndTagClose);
                }
                if (emitPseudoCloseTags && stream.peekChar() === _LAN$2) {
                    state = ScannerState.WithinContent;
                    return finishToken(offset, TokenType$1.EndTagClose, main$4.t('Closing bracket missing.'));
                }
                errorMessage = main$4.t('Closing bracket expected.');
                break;
            case ScannerState.AfterOpeningStartTag:
                lastTag = nextElementName();
                lastTypeValue = void 0;
                lastAttributeName = void 0;
                if (lastTag.length > 0) {
                    hasSpaceAfterTag = false;
                    state = ScannerState.WithinTag;
                    return finishToken(offset, TokenType$1.StartTag);
                }
                if (stream.skipWhitespace()) {
                    return finishToken(offset, TokenType$1.Whitespace, main$4.t('Tag name must directly follow the open bracket.'));
                }
                state = ScannerState.WithinTag;
                stream.advanceUntilChar(_RAN$2);
                if (offset < stream.pos()) {
                    return finishToken(offset, TokenType$1.Unknown, main$4.t('Start tag name expected.'));
                }
                return internalScan();
            case ScannerState.WithinTag:
                if (stream.skipWhitespace()) {
                    hasSpaceAfterTag = true;
                    return finishToken(offset, TokenType$1.Whitespace);
                }
                if (hasSpaceAfterTag) {
                    lastAttributeName = nextAttributeName();
                    if (lastAttributeName.length > 0) {
                        state = ScannerState.AfterAttributeName;
                        hasSpaceAfterTag = false;
                        return finishToken(offset, TokenType$1.AttributeName);
                    }
                }
                if (stream.advanceIfChars([_FSL$3, _RAN$2])) {
                    state = ScannerState.WithinContent;
                    return finishToken(offset, TokenType$1.StartTagSelfClose);
                }
                if (stream.advanceIfChar(_RAN$2)) {
                    if (lastTag === 'script') {
                        if (lastTypeValue && htmlScriptContents[lastTypeValue]) {
                            state = ScannerState.WithinContent;
                        }
                        else {
                            state = ScannerState.WithinScriptContent;
                        }
                    }
                    else if (lastTag === 'style') {
                        state = ScannerState.WithinStyleContent;
                    }
                    else {
                        state = ScannerState.WithinContent;
                    }
                    return finishToken(offset, TokenType$1.StartTagClose);
                }
                if (emitPseudoCloseTags && stream.peekChar() === _LAN$2) {
                    state = ScannerState.WithinContent;
                    return finishToken(offset, TokenType$1.StartTagClose, main$4.t('Closing bracket missing.'));
                }
                stream.advance(1);
                return finishToken(offset, TokenType$1.Unknown, main$4.t('Unexpected character in tag.'));
            case ScannerState.AfterAttributeName:
                if (stream.skipWhitespace()) {
                    hasSpaceAfterTag = true;
                    return finishToken(offset, TokenType$1.Whitespace);
                }
                if (stream.advanceIfChar(_EQS$2)) {
                    state = ScannerState.BeforeAttributeValue;
                    return finishToken(offset, TokenType$1.DelimiterAssign);
                }
                state = ScannerState.WithinTag;
                return internalScan();
            case ScannerState.BeforeAttributeValue:
                if (stream.skipWhitespace()) {
                    return finishToken(offset, TokenType$1.Whitespace);
                }
                let attributeValue = stream.advanceIfRegExp(/^[^\s"'`=<>]+/);
                if (attributeValue.length > 0) {
                    if (stream.peekChar() === _RAN$2 && stream.peekChar(-1) === _FSL$3) {
                        stream.goBack(1);
                        attributeValue = attributeValue.substring(0, attributeValue.length - 1);
                    }
                    if (lastAttributeName === 'type') {
                        lastTypeValue = attributeValue;
                    }
                    if (attributeValue.length > 0) {
                        state = ScannerState.WithinTag;
                        hasSpaceAfterTag = false;
                        return finishToken(offset, TokenType$1.AttributeValue);
                    }
                }
                const ch = stream.peekChar();
                if (ch === _SQO$1 || ch === _DQO$1) {
                    stream.advance(1);
                    if (stream.advanceUntilChar(ch)) {
                        stream.advance(1);
                    }
                    if (lastAttributeName === 'type') {
                        lastTypeValue = stream.getSource().substring(offset + 1, stream.pos() - 1);
                    }
                    state = ScannerState.WithinTag;
                    hasSpaceAfterTag = false;
                    return finishToken(offset, TokenType$1.AttributeValue);
                }
                state = ScannerState.WithinTag;
                hasSpaceAfterTag = false;
                return internalScan();
            case ScannerState.WithinScriptContent:
                let sciptState = 1;
                while (!stream.eos()) {
                    const match = stream.advanceIfRegExp(/<!--|-->|<\/?script\s*\/?>?/i);
                    if (match.length === 0) {
                        stream.goToEnd();
                        return finishToken(offset, TokenType$1.Script);
                    }
                    else if (match === '<!--') {
                        if (sciptState === 1) {
                            sciptState = 2;
                        }
                    }
                    else if (match === '-->') {
                        sciptState = 1;
                    }
                    else if (match[1] !== '/') {
                        if (sciptState === 2) {
                            sciptState = 3;
                        }
                    }
                    else {
                        if (sciptState === 3) {
                            sciptState = 2;
                        }
                        else {
                            stream.goBack(match.length);
                            break;
                        }
                    }
                }
                state = ScannerState.WithinContent;
                if (offset < stream.pos()) {
                    return finishToken(offset, TokenType$1.Script);
                }
                return internalScan();
            case ScannerState.WithinStyleContent:
                stream.advanceUntilRegExp(/<\/style/i);
                state = ScannerState.WithinContent;
                if (offset < stream.pos()) {
                    return finishToken(offset, TokenType$1.Styles);
                }
                return internalScan();
        }
        stream.advance(1);
        state = ScannerState.WithinContent;
        return finishToken(offset, TokenType$1.Unknown, errorMessage);
    }
    return {
        scan,
        getTokenType: () => tokenType,
        getTokenOffset: () => tokenOffset,
        getTokenLength: () => stream.pos() - tokenOffset,
        getTokenEnd: () => stream.pos(),
        getTokenText: () => stream.getSource().substring(tokenOffset, stream.pos()),
        getScannerState: () => state,
        getTokenError: () => tokenError
    };
}

function findFirst$1(array, p) {
    let low = 0, high = array.length;
    if (high === 0) {
        return 0;
    }
    while (low < high) {
        let mid = Math.floor((low + high) / 2);
        if (p(array[mid])) {
            high = mid;
        }
        else {
            low = mid + 1;
        }
    }
    return low;
}
function binarySearch(array, key, comparator) {
    let low = 0, high = array.length - 1;
    while (low <= high) {
        const mid = ((low + high) / 2) | 0;
        const comp = comparator(array[mid], key);
        if (comp < 0) {
            low = mid + 1;
        }
        else if (comp > 0) {
            high = mid - 1;
        }
        else {
            return mid;
        }
    }
    return -(low + 1);
}

let Node$1 = class Node {
    get attributeNames() { return this.attributes ? Object.keys(this.attributes) : []; }
    constructor(start, end, children, parent) {
        this.start = start;
        this.end = end;
        this.children = children;
        this.parent = parent;
        this.closed = false;
    }
    isSameTag(tagInLowerCase) {
        if (this.tag === undefined) {
            return tagInLowerCase === undefined;
        }
        else {
            return tagInLowerCase !== undefined && this.tag.length === tagInLowerCase.length && this.tag.toLowerCase() === tagInLowerCase;
        }
    }
    get firstChild() { return this.children[0]; }
    get lastChild() { return this.children.length ? this.children[this.children.length - 1] : void 0; }
    findNodeBefore(offset) {
        const idx = findFirst$1(this.children, c => offset <= c.start) - 1;
        if (idx >= 0) {
            const child = this.children[idx];
            if (offset > child.start) {
                if (offset < child.end) {
                    return child.findNodeBefore(offset);
                }
                const lastChild = child.lastChild;
                if (lastChild && lastChild.end === child.end) {
                    return child.findNodeBefore(offset);
                }
                return child;
            }
        }
        return this;
    }
    findNodeAt(offset) {
        const idx = findFirst$1(this.children, c => offset <= c.start) - 1;
        if (idx >= 0) {
            const child = this.children[idx];
            if (offset > child.start && offset <= child.end) {
                return child.findNodeAt(offset);
            }
        }
        return this;
    }
};
class HTMLParser {
    constructor(dataManager) {
        this.dataManager = dataManager;
    }
    parseDocument(document) {
        return this.parse(document.getText(), this.dataManager.getVoidElements(document.languageId));
    }
    parse(text, voidElements) {
        const scanner = createScanner$1(text, undefined, undefined, true);
        const htmlDocument = new Node$1(0, text.length, [], void 0);
        let curr = htmlDocument;
        let endTagStart = -1;
        let endTagName = undefined;
        let pendingAttribute = null;
        let token = scanner.scan();
        while (token !== TokenType$1.EOS) {
            switch (token) {
                case TokenType$1.StartTagOpen:
                    const child = new Node$1(scanner.getTokenOffset(), text.length, [], curr);
                    curr.children.push(child);
                    curr = child;
                    break;
                case TokenType$1.StartTag:
                    curr.tag = scanner.getTokenText();
                    break;
                case TokenType$1.StartTagClose:
                    if (curr.parent) {
                        curr.end = scanner.getTokenEnd();
                        if (scanner.getTokenLength()) {
                            curr.startTagEnd = scanner.getTokenEnd();
                            if (curr.tag && this.dataManager.isVoidElement(curr.tag, voidElements)) {
                                curr.closed = true;
                                curr = curr.parent;
                            }
                        }
                        else {
                            curr = curr.parent;
                        }
                    }
                    break;
                case TokenType$1.StartTagSelfClose:
                    if (curr.parent) {
                        curr.closed = true;
                        curr.end = scanner.getTokenEnd();
                        curr.startTagEnd = scanner.getTokenEnd();
                        curr = curr.parent;
                    }
                    break;
                case TokenType$1.EndTagOpen:
                    endTagStart = scanner.getTokenOffset();
                    endTagName = undefined;
                    break;
                case TokenType$1.EndTag:
                    endTagName = scanner.getTokenText().toLowerCase();
                    break;
                case TokenType$1.EndTagClose:
                    let node = curr;
                    while (!node.isSameTag(endTagName) && node.parent) {
                        node = node.parent;
                    }
                    if (node.parent) {
                        while (curr !== node) {
                            curr.end = endTagStart;
                            curr.closed = false;
                            curr = curr.parent;
                        }
                        curr.closed = true;
                        curr.endTagStart = endTagStart;
                        curr.end = scanner.getTokenEnd();
                        curr = curr.parent;
                    }
                    break;
                case TokenType$1.AttributeName: {
                    pendingAttribute = scanner.getTokenText();
                    let attributes = curr.attributes;
                    if (!attributes) {
                        curr.attributes = attributes = {};
                    }
                    attributes[pendingAttribute] = null;
                    break;
                }
                case TokenType$1.AttributeValue: {
                    const value = scanner.getTokenText();
                    const attributes = curr.attributes;
                    if (attributes && pendingAttribute) {
                        attributes[pendingAttribute] = value;
                        pendingAttribute = null;
                    }
                    break;
                }
            }
            token = scanner.scan();
        }
        while (curr.parent) {
            curr.end = text.length;
            curr.closed = false;
            curr = curr.parent;
        }
        return {
            roots: htmlDocument.children,
            findNodeBefore: htmlDocument.findNodeBefore.bind(htmlDocument),
            findNodeAt: htmlDocument.findNodeAt.bind(htmlDocument)
        };
    }
}

const entities = {
    "Aacute;": "\u00C1",
    "Aacute": "\u00C1",
    "aacute;": "\u00E1",
    "aacute": "\u00E1",
    "Abreve;": "\u0102",
    "abreve;": "\u0103",
    "ac;": "\u223E",
    "acd;": "\u223F",
    "acE;": "\u223E\u0333",
    "Acirc;": "\u00C2",
    "Acirc": "\u00C2",
    "acirc;": "\u00E2",
    "acirc": "\u00E2",
    "acute;": "\u00B4",
    "acute": "\u00B4",
    "Acy;": "\u0410",
    "acy;": "\u0430",
    "AElig;": "\u00C6",
    "AElig": "\u00C6",
    "aelig;": "\u00E6",
    "aelig": "\u00E6",
    "af;": "\u2061",
    "Afr;": "\uD835\uDD04",
    "afr;": "\uD835\uDD1E",
    "Agrave;": "\u00C0",
    "Agrave": "\u00C0",
    "agrave;": "\u00E0",
    "agrave": "\u00E0",
    "alefsym;": "\u2135",
    "aleph;": "\u2135",
    "Alpha;": "\u0391",
    "alpha;": "\u03B1",
    "Amacr;": "\u0100",
    "amacr;": "\u0101",
    "amalg;": "\u2A3F",
    "AMP;": "\u0026",
    "AMP": "\u0026",
    "amp;": "\u0026",
    "amp": "\u0026",
    "And;": "\u2A53",
    "and;": "\u2227",
    "andand;": "\u2A55",
    "andd;": "\u2A5C",
    "andslope;": "\u2A58",
    "andv;": "\u2A5A",
    "ang;": "\u2220",
    "ange;": "\u29A4",
    "angle;": "\u2220",
    "angmsd;": "\u2221",
    "angmsdaa;": "\u29A8",
    "angmsdab;": "\u29A9",
    "angmsdac;": "\u29AA",
    "angmsdad;": "\u29AB",
    "angmsdae;": "\u29AC",
    "angmsdaf;": "\u29AD",
    "angmsdag;": "\u29AE",
    "angmsdah;": "\u29AF",
    "angrt;": "\u221F",
    "angrtvb;": "\u22BE",
    "angrtvbd;": "\u299D",
    "angsph;": "\u2222",
    "angst;": "\u00C5",
    "angzarr;": "\u237C",
    "Aogon;": "\u0104",
    "aogon;": "\u0105",
    "Aopf;": "\uD835\uDD38",
    "aopf;": "\uD835\uDD52",
    "ap;": "\u2248",
    "apacir;": "\u2A6F",
    "apE;": "\u2A70",
    "ape;": "\u224A",
    "apid;": "\u224B",
    "apos;": "\u0027",
    "ApplyFunction;": "\u2061",
    "approx;": "\u2248",
    "approxeq;": "\u224A",
    "Aring;": "\u00C5",
    "Aring": "\u00C5",
    "aring;": "\u00E5",
    "aring": "\u00E5",
    "Ascr;": "\uD835\uDC9C",
    "ascr;": "\uD835\uDCB6",
    "Assign;": "\u2254",
    "ast;": "\u002A",
    "asymp;": "\u2248",
    "asympeq;": "\u224D",
    "Atilde;": "\u00C3",
    "Atilde": "\u00C3",
    "atilde;": "\u00E3",
    "atilde": "\u00E3",
    "Auml;": "\u00C4",
    "Auml": "\u00C4",
    "auml;": "\u00E4",
    "auml": "\u00E4",
    "awconint;": "\u2233",
    "awint;": "\u2A11",
    "backcong;": "\u224C",
    "backepsilon;": "\u03F6",
    "backprime;": "\u2035",
    "backsim;": "\u223D",
    "backsimeq;": "\u22CD",
    "Backslash;": "\u2216",
    "Barv;": "\u2AE7",
    "barvee;": "\u22BD",
    "Barwed;": "\u2306",
    "barwed;": "\u2305",
    "barwedge;": "\u2305",
    "bbrk;": "\u23B5",
    "bbrktbrk;": "\u23B6",
    "bcong;": "\u224C",
    "Bcy;": "\u0411",
    "bcy;": "\u0431",
    "bdquo;": "\u201E",
    "becaus;": "\u2235",
    "Because;": "\u2235",
    "because;": "\u2235",
    "bemptyv;": "\u29B0",
    "bepsi;": "\u03F6",
    "bernou;": "\u212C",
    "Bernoullis;": "\u212C",
    "Beta;": "\u0392",
    "beta;": "\u03B2",
    "beth;": "\u2136",
    "between;": "\u226C",
    "Bfr;": "\uD835\uDD05",
    "bfr;": "\uD835\uDD1F",
    "bigcap;": "\u22C2",
    "bigcirc;": "\u25EF",
    "bigcup;": "\u22C3",
    "bigodot;": "\u2A00",
    "bigoplus;": "\u2A01",
    "bigotimes;": "\u2A02",
    "bigsqcup;": "\u2A06",
    "bigstar;": "\u2605",
    "bigtriangledown;": "\u25BD",
    "bigtriangleup;": "\u25B3",
    "biguplus;": "\u2A04",
    "bigvee;": "\u22C1",
    "bigwedge;": "\u22C0",
    "bkarow;": "\u290D",
    "blacklozenge;": "\u29EB",
    "blacksquare;": "\u25AA",
    "blacktriangle;": "\u25B4",
    "blacktriangledown;": "\u25BE",
    "blacktriangleleft;": "\u25C2",
    "blacktriangleright;": "\u25B8",
    "blank;": "\u2423",
    "blk12;": "\u2592",
    "blk14;": "\u2591",
    "blk34;": "\u2593",
    "block;": "\u2588",
    "bne;": "\u003D\u20E5",
    "bnequiv;": "\u2261\u20E5",
    "bNot;": "\u2AED",
    "bnot;": "\u2310",
    "Bopf;": "\uD835\uDD39",
    "bopf;": "\uD835\uDD53",
    "bot;": "\u22A5",
    "bottom;": "\u22A5",
    "bowtie;": "\u22C8",
    "boxbox;": "\u29C9",
    "boxDL;": "\u2557",
    "boxDl;": "\u2556",
    "boxdL;": "\u2555",
    "boxdl;": "\u2510",
    "boxDR;": "\u2554",
    "boxDr;": "\u2553",
    "boxdR;": "\u2552",
    "boxdr;": "\u250C",
    "boxH;": "\u2550",
    "boxh;": "\u2500",
    "boxHD;": "\u2566",
    "boxHd;": "\u2564",
    "boxhD;": "\u2565",
    "boxhd;": "\u252C",
    "boxHU;": "\u2569",
    "boxHu;": "\u2567",
    "boxhU;": "\u2568",
    "boxhu;": "\u2534",
    "boxminus;": "\u229F",
    "boxplus;": "\u229E",
    "boxtimes;": "\u22A0",
    "boxUL;": "\u255D",
    "boxUl;": "\u255C",
    "boxuL;": "\u255B",
    "boxul;": "\u2518",
    "boxUR;": "\u255A",
    "boxUr;": "\u2559",
    "boxuR;": "\u2558",
    "boxur;": "\u2514",
    "boxV;": "\u2551",
    "boxv;": "\u2502",
    "boxVH;": "\u256C",
    "boxVh;": "\u256B",
    "boxvH;": "\u256A",
    "boxvh;": "\u253C",
    "boxVL;": "\u2563",
    "boxVl;": "\u2562",
    "boxvL;": "\u2561",
    "boxvl;": "\u2524",
    "boxVR;": "\u2560",
    "boxVr;": "\u255F",
    "boxvR;": "\u255E",
    "boxvr;": "\u251C",
    "bprime;": "\u2035",
    "Breve;": "\u02D8",
    "breve;": "\u02D8",
    "brvbar;": "\u00A6",
    "brvbar": "\u00A6",
    "Bscr;": "\u212C",
    "bscr;": "\uD835\uDCB7",
    "bsemi;": "\u204F",
    "bsim;": "\u223D",
    "bsime;": "\u22CD",
    "bsol;": "\u005C",
    "bsolb;": "\u29C5",
    "bsolhsub;": "\u27C8",
    "bull;": "\u2022",
    "bullet;": "\u2022",
    "bump;": "\u224E",
    "bumpE;": "\u2AAE",
    "bumpe;": "\u224F",
    "Bumpeq;": "\u224E",
    "bumpeq;": "\u224F",
    "Cacute;": "\u0106",
    "cacute;": "\u0107",
    "Cap;": "\u22D2",
    "cap;": "\u2229",
    "capand;": "\u2A44",
    "capbrcup;": "\u2A49",
    "capcap;": "\u2A4B",
    "capcup;": "\u2A47",
    "capdot;": "\u2A40",
    "CapitalDifferentialD;": "\u2145",
    "caps;": "\u2229\uFE00",
    "caret;": "\u2041",
    "caron;": "\u02C7",
    "Cayleys;": "\u212D",
    "ccaps;": "\u2A4D",
    "Ccaron;": "\u010C",
    "ccaron;": "\u010D",
    "Ccedil;": "\u00C7",
    "Ccedil": "\u00C7",
    "ccedil;": "\u00E7",
    "ccedil": "\u00E7",
    "Ccirc;": "\u0108",
    "ccirc;": "\u0109",
    "Cconint;": "\u2230",
    "ccups;": "\u2A4C",
    "ccupssm;": "\u2A50",
    "Cdot;": "\u010A",
    "cdot;": "\u010B",
    "cedil;": "\u00B8",
    "cedil": "\u00B8",
    "Cedilla;": "\u00B8",
    "cemptyv;": "\u29B2",
    "cent;": "\u00A2",
    "cent": "\u00A2",
    "CenterDot;": "\u00B7",
    "centerdot;": "\u00B7",
    "Cfr;": "\u212D",
    "cfr;": "\uD835\uDD20",
    "CHcy;": "\u0427",
    "chcy;": "\u0447",
    "check;": "\u2713",
    "checkmark;": "\u2713",
    "Chi;": "\u03A7",
    "chi;": "\u03C7",
    "cir;": "\u25CB",
    "circ;": "\u02C6",
    "circeq;": "\u2257",
    "circlearrowleft;": "\u21BA",
    "circlearrowright;": "\u21BB",
    "circledast;": "\u229B",
    "circledcirc;": "\u229A",
    "circleddash;": "\u229D",
    "CircleDot;": "\u2299",
    "circledR;": "\u00AE",
    "circledS;": "\u24C8",
    "CircleMinus;": "\u2296",
    "CirclePlus;": "\u2295",
    "CircleTimes;": "\u2297",
    "cirE;": "\u29C3",
    "cire;": "\u2257",
    "cirfnint;": "\u2A10",
    "cirmid;": "\u2AEF",
    "cirscir;": "\u29C2",
    "ClockwiseContourIntegral;": "\u2232",
    "CloseCurlyDoubleQuote;": "\u201D",
    "CloseCurlyQuote;": "\u2019",
    "clubs;": "\u2663",
    "clubsuit;": "\u2663",
    "Colon;": "\u2237",
    "colon;": "\u003A",
    "Colone;": "\u2A74",
    "colone;": "\u2254",
    "coloneq;": "\u2254",
    "comma;": "\u002C",
    "commat;": "\u0040",
    "comp;": "\u2201",
    "compfn;": "\u2218",
    "complement;": "\u2201",
    "complexes;": "\u2102",
    "cong;": "\u2245",
    "congdot;": "\u2A6D",
    "Congruent;": "\u2261",
    "Conint;": "\u222F",
    "conint;": "\u222E",
    "ContourIntegral;": "\u222E",
    "Copf;": "\u2102",
    "copf;": "\uD835\uDD54",
    "coprod;": "\u2210",
    "Coproduct;": "\u2210",
    "COPY;": "\u00A9",
    "COPY": "\u00A9",
    "copy;": "\u00A9",
    "copy": "\u00A9",
    "copysr;": "\u2117",
    "CounterClockwiseContourIntegral;": "\u2233",
    "crarr;": "\u21B5",
    "Cross;": "\u2A2F",
    "cross;": "\u2717",
    "Cscr;": "\uD835\uDC9E",
    "cscr;": "\uD835\uDCB8",
    "csub;": "\u2ACF",
    "csube;": "\u2AD1",
    "csup;": "\u2AD0",
    "csupe;": "\u2AD2",
    "ctdot;": "\u22EF",
    "cudarrl;": "\u2938",
    "cudarrr;": "\u2935",
    "cuepr;": "\u22DE",
    "cuesc;": "\u22DF",
    "cularr;": "\u21B6",
    "cularrp;": "\u293D",
    "Cup;": "\u22D3",
    "cup;": "\u222A",
    "cupbrcap;": "\u2A48",
    "CupCap;": "\u224D",
    "cupcap;": "\u2A46",
    "cupcup;": "\u2A4A",
    "cupdot;": "\u228D",
    "cupor;": "\u2A45",
    "cups;": "\u222A\uFE00",
    "curarr;": "\u21B7",
    "curarrm;": "\u293C",
    "curlyeqprec;": "\u22DE",
    "curlyeqsucc;": "\u22DF",
    "curlyvee;": "\u22CE",
    "curlywedge;": "\u22CF",
    "curren;": "\u00A4",
    "curren": "\u00A4",
    "curvearrowleft;": "\u21B6",
    "curvearrowright;": "\u21B7",
    "cuvee;": "\u22CE",
    "cuwed;": "\u22CF",
    "cwconint;": "\u2232",
    "cwint;": "\u2231",
    "cylcty;": "\u232D",
    "Dagger;": "\u2021",
    "dagger;": "\u2020",
    "daleth;": "\u2138",
    "Darr;": "\u21A1",
    "dArr;": "\u21D3",
    "darr;": "\u2193",
    "dash;": "\u2010",
    "Dashv;": "\u2AE4",
    "dashv;": "\u22A3",
    "dbkarow;": "\u290F",
    "dblac;": "\u02DD",
    "Dcaron;": "\u010E",
    "dcaron;": "\u010F",
    "Dcy;": "\u0414",
    "dcy;": "\u0434",
    "DD;": "\u2145",
    "dd;": "\u2146",
    "ddagger;": "\u2021",
    "ddarr;": "\u21CA",
    "DDotrahd;": "\u2911",
    "ddotseq;": "\u2A77",
    "deg;": "\u00B0",
    "deg": "\u00B0",
    "Del;": "\u2207",
    "Delta;": "\u0394",
    "delta;": "\u03B4",
    "demptyv;": "\u29B1",
    "dfisht;": "\u297F",
    "Dfr;": "\uD835\uDD07",
    "dfr;": "\uD835\uDD21",
    "dHar;": "\u2965",
    "dharl;": "\u21C3",
    "dharr;": "\u21C2",
    "DiacriticalAcute;": "\u00B4",
    "DiacriticalDot;": "\u02D9",
    "DiacriticalDoubleAcute;": "\u02DD",
    "DiacriticalGrave;": "\u0060",
    "DiacriticalTilde;": "\u02DC",
    "diam;": "\u22C4",
    "Diamond;": "\u22C4",
    "diamond;": "\u22C4",
    "diamondsuit;": "\u2666",
    "diams;": "\u2666",
    "die;": "\u00A8",
    "DifferentialD;": "\u2146",
    "digamma;": "\u03DD",
    "disin;": "\u22F2",
    "div;": "\u00F7",
    "divide;": "\u00F7",
    "divide": "\u00F7",
    "divideontimes;": "\u22C7",
    "divonx;": "\u22C7",
    "DJcy;": "\u0402",
    "djcy;": "\u0452",
    "dlcorn;": "\u231E",
    "dlcrop;": "\u230D",
    "dollar;": "\u0024",
    "Dopf;": "\uD835\uDD3B",
    "dopf;": "\uD835\uDD55",
    "Dot;": "\u00A8",
    "dot;": "\u02D9",
    "DotDot;": "\u20DC",
    "doteq;": "\u2250",
    "doteqdot;": "\u2251",
    "DotEqual;": "\u2250",
    "dotminus;": "\u2238",
    "dotplus;": "\u2214",
    "dotsquare;": "\u22A1",
    "doublebarwedge;": "\u2306",
    "DoubleContourIntegral;": "\u222F",
    "DoubleDot;": "\u00A8",
    "DoubleDownArrow;": "\u21D3",
    "DoubleLeftArrow;": "\u21D0",
    "DoubleLeftRightArrow;": "\u21D4",
    "DoubleLeftTee;": "\u2AE4",
    "DoubleLongLeftArrow;": "\u27F8",
    "DoubleLongLeftRightArrow;": "\u27FA",
    "DoubleLongRightArrow;": "\u27F9",
    "DoubleRightArrow;": "\u21D2",
    "DoubleRightTee;": "\u22A8",
    "DoubleUpArrow;": "\u21D1",
    "DoubleUpDownArrow;": "\u21D5",
    "DoubleVerticalBar;": "\u2225",
    "DownArrow;": "\u2193",
    "Downarrow;": "\u21D3",
    "downarrow;": "\u2193",
    "DownArrowBar;": "\u2913",
    "DownArrowUpArrow;": "\u21F5",
    "DownBreve;": "\u0311",
    "downdownarrows;": "\u21CA",
    "downharpoonleft;": "\u21C3",
    "downharpoonright;": "\u21C2",
    "DownLeftRightVector;": "\u2950",
    "DownLeftTeeVector;": "\u295E",
    "DownLeftVector;": "\u21BD",
    "DownLeftVectorBar;": "\u2956",
    "DownRightTeeVector;": "\u295F",
    "DownRightVector;": "\u21C1",
    "DownRightVectorBar;": "\u2957",
    "DownTee;": "\u22A4",
    "DownTeeArrow;": "\u21A7",
    "drbkarow;": "\u2910",
    "drcorn;": "\u231F",
    "drcrop;": "\u230C",
    "Dscr;": "\uD835\uDC9F",
    "dscr;": "\uD835\uDCB9",
    "DScy;": "\u0405",
    "dscy;": "\u0455",
    "dsol;": "\u29F6",
    "Dstrok;": "\u0110",
    "dstrok;": "\u0111",
    "dtdot;": "\u22F1",
    "dtri;": "\u25BF",
    "dtrif;": "\u25BE",
    "duarr;": "\u21F5",
    "duhar;": "\u296F",
    "dwangle;": "\u29A6",
    "DZcy;": "\u040F",
    "dzcy;": "\u045F",
    "dzigrarr;": "\u27FF",
    "Eacute;": "\u00C9",
    "Eacute": "\u00C9",
    "eacute;": "\u00E9",
    "eacute": "\u00E9",
    "easter;": "\u2A6E",
    "Ecaron;": "\u011A",
    "ecaron;": "\u011B",
    "ecir;": "\u2256",
    "Ecirc;": "\u00CA",
    "Ecirc": "\u00CA",
    "ecirc;": "\u00EA",
    "ecirc": "\u00EA",
    "ecolon;": "\u2255",
    "Ecy;": "\u042D",
    "ecy;": "\u044D",
    "eDDot;": "\u2A77",
    "Edot;": "\u0116",
    "eDot;": "\u2251",
    "edot;": "\u0117",
    "ee;": "\u2147",
    "efDot;": "\u2252",
    "Efr;": "\uD835\uDD08",
    "efr;": "\uD835\uDD22",
    "eg;": "\u2A9A",
    "Egrave;": "\u00C8",
    "Egrave": "\u00C8",
    "egrave;": "\u00E8",
    "egrave": "\u00E8",
    "egs;": "\u2A96",
    "egsdot;": "\u2A98",
    "el;": "\u2A99",
    "Element;": "\u2208",
    "elinters;": "\u23E7",
    "ell;": "\u2113",
    "els;": "\u2A95",
    "elsdot;": "\u2A97",
    "Emacr;": "\u0112",
    "emacr;": "\u0113",
    "empty;": "\u2205",
    "emptyset;": "\u2205",
    "EmptySmallSquare;": "\u25FB",
    "emptyv;": "\u2205",
    "EmptyVerySmallSquare;": "\u25AB",
    "emsp;": "\u2003",
    "emsp13;": "\u2004",
    "emsp14;": "\u2005",
    "ENG;": "\u014A",
    "eng;": "\u014B",
    "ensp;": "\u2002",
    "Eogon;": "\u0118",
    "eogon;": "\u0119",
    "Eopf;": "\uD835\uDD3C",
    "eopf;": "\uD835\uDD56",
    "epar;": "\u22D5",
    "eparsl;": "\u29E3",
    "eplus;": "\u2A71",
    "epsi;": "\u03B5",
    "Epsilon;": "\u0395",
    "epsilon;": "\u03B5",
    "epsiv;": "\u03F5",
    "eqcirc;": "\u2256",
    "eqcolon;": "\u2255",
    "eqsim;": "\u2242",
    "eqslantgtr;": "\u2A96",
    "eqslantless;": "\u2A95",
    "Equal;": "\u2A75",
    "equals;": "\u003D",
    "EqualTilde;": "\u2242",
    "equest;": "\u225F",
    "Equilibrium;": "\u21CC",
    "equiv;": "\u2261",
    "equivDD;": "\u2A78",
    "eqvparsl;": "\u29E5",
    "erarr;": "\u2971",
    "erDot;": "\u2253",
    "Escr;": "\u2130",
    "escr;": "\u212F",
    "esdot;": "\u2250",
    "Esim;": "\u2A73",
    "esim;": "\u2242",
    "Eta;": "\u0397",
    "eta;": "\u03B7",
    "ETH;": "\u00D0",
    "ETH": "\u00D0",
    "eth;": "\u00F0",
    "eth": "\u00F0",
    "Euml;": "\u00CB",
    "Euml": "\u00CB",
    "euml;": "\u00EB",
    "euml": "\u00EB",
    "euro;": "\u20AC",
    "excl;": "\u0021",
    "exist;": "\u2203",
    "Exists;": "\u2203",
    "expectation;": "\u2130",
    "ExponentialE;": "\u2147",
    "exponentiale;": "\u2147",
    "fallingdotseq;": "\u2252",
    "Fcy;": "\u0424",
    "fcy;": "\u0444",
    "female;": "\u2640",
    "ffilig;": "\uFB03",
    "fflig;": "\uFB00",
    "ffllig;": "\uFB04",
    "Ffr;": "\uD835\uDD09",
    "ffr;": "\uD835\uDD23",
    "filig;": "\uFB01",
    "FilledSmallSquare;": "\u25FC",
    "FilledVerySmallSquare;": "\u25AA",
    "fjlig;": "\u0066\u006A",
    "flat;": "\u266D",
    "fllig;": "\uFB02",
    "fltns;": "\u25B1",
    "fnof;": "\u0192",
    "Fopf;": "\uD835\uDD3D",
    "fopf;": "\uD835\uDD57",
    "ForAll;": "\u2200",
    "forall;": "\u2200",
    "fork;": "\u22D4",
    "forkv;": "\u2AD9",
    "Fouriertrf;": "\u2131",
    "fpartint;": "\u2A0D",
    "frac12;": "\u00BD",
    "frac12": "\u00BD",
    "frac13;": "\u2153",
    "frac14;": "\u00BC",
    "frac14": "\u00BC",
    "frac15;": "\u2155",
    "frac16;": "\u2159",
    "frac18;": "\u215B",
    "frac23;": "\u2154",
    "frac25;": "\u2156",
    "frac34;": "\u00BE",
    "frac34": "\u00BE",
    "frac35;": "\u2157",
    "frac38;": "\u215C",
    "frac45;": "\u2158",
    "frac56;": "\u215A",
    "frac58;": "\u215D",
    "frac78;": "\u215E",
    "frasl;": "\u2044",
    "frown;": "\u2322",
    "Fscr;": "\u2131",
    "fscr;": "\uD835\uDCBB",
    "gacute;": "\u01F5",
    "Gamma;": "\u0393",
    "gamma;": "\u03B3",
    "Gammad;": "\u03DC",
    "gammad;": "\u03DD",
    "gap;": "\u2A86",
    "Gbreve;": "\u011E",
    "gbreve;": "\u011F",
    "Gcedil;": "\u0122",
    "Gcirc;": "\u011C",
    "gcirc;": "\u011D",
    "Gcy;": "\u0413",
    "gcy;": "\u0433",
    "Gdot;": "\u0120",
    "gdot;": "\u0121",
    "gE;": "\u2267",
    "ge;": "\u2265",
    "gEl;": "\u2A8C",
    "gel;": "\u22DB",
    "geq;": "\u2265",
    "geqq;": "\u2267",
    "geqslant;": "\u2A7E",
    "ges;": "\u2A7E",
    "gescc;": "\u2AA9",
    "gesdot;": "\u2A80",
    "gesdoto;": "\u2A82",
    "gesdotol;": "\u2A84",
    "gesl;": "\u22DB\uFE00",
    "gesles;": "\u2A94",
    "Gfr;": "\uD835\uDD0A",
    "gfr;": "\uD835\uDD24",
    "Gg;": "\u22D9",
    "gg;": "\u226B",
    "ggg;": "\u22D9",
    "gimel;": "\u2137",
    "GJcy;": "\u0403",
    "gjcy;": "\u0453",
    "gl;": "\u2277",
    "gla;": "\u2AA5",
    "glE;": "\u2A92",
    "glj;": "\u2AA4",
    "gnap;": "\u2A8A",
    "gnapprox;": "\u2A8A",
    "gnE;": "\u2269",
    "gne;": "\u2A88",
    "gneq;": "\u2A88",
    "gneqq;": "\u2269",
    "gnsim;": "\u22E7",
    "Gopf;": "\uD835\uDD3E",
    "gopf;": "\uD835\uDD58",
    "grave;": "\u0060",
    "GreaterEqual;": "\u2265",
    "GreaterEqualLess;": "\u22DB",
    "GreaterFullEqual;": "\u2267",
    "GreaterGreater;": "\u2AA2",
    "GreaterLess;": "\u2277",
    "GreaterSlantEqual;": "\u2A7E",
    "GreaterTilde;": "\u2273",
    "Gscr;": "\uD835\uDCA2",
    "gscr;": "\u210A",
    "gsim;": "\u2273",
    "gsime;": "\u2A8E",
    "gsiml;": "\u2A90",
    "GT;": "\u003E",
    "GT": "\u003E",
    "Gt;": "\u226B",
    "gt;": "\u003E",
    "gt": "\u003E",
    "gtcc;": "\u2AA7",
    "gtcir;": "\u2A7A",
    "gtdot;": "\u22D7",
    "gtlPar;": "\u2995",
    "gtquest;": "\u2A7C",
    "gtrapprox;": "\u2A86",
    "gtrarr;": "\u2978",
    "gtrdot;": "\u22D7",
    "gtreqless;": "\u22DB",
    "gtreqqless;": "\u2A8C",
    "gtrless;": "\u2277",
    "gtrsim;": "\u2273",
    "gvertneqq;": "\u2269\uFE00",
    "gvnE;": "\u2269\uFE00",
    "Hacek;": "\u02C7",
    "hairsp;": "\u200A",
    "half;": "\u00BD",
    "hamilt;": "\u210B",
    "HARDcy;": "\u042A",
    "hardcy;": "\u044A",
    "hArr;": "\u21D4",
    "harr;": "\u2194",
    "harrcir;": "\u2948",
    "harrw;": "\u21AD",
    "Hat;": "\u005E",
    "hbar;": "\u210F",
    "Hcirc;": "\u0124",
    "hcirc;": "\u0125",
    "hearts;": "\u2665",
    "heartsuit;": "\u2665",
    "hellip;": "\u2026",
    "hercon;": "\u22B9",
    "Hfr;": "\u210C",
    "hfr;": "\uD835\uDD25",
    "HilbertSpace;": "\u210B",
    "hksearow;": "\u2925",
    "hkswarow;": "\u2926",
    "hoarr;": "\u21FF",
    "homtht;": "\u223B",
    "hookleftarrow;": "\u21A9",
    "hookrightarrow;": "\u21AA",
    "Hopf;": "\u210D",
    "hopf;": "\uD835\uDD59",
    "horbar;": "\u2015",
    "HorizontalLine;": "\u2500",
    "Hscr;": "\u210B",
    "hscr;": "\uD835\uDCBD",
    "hslash;": "\u210F",
    "Hstrok;": "\u0126",
    "hstrok;": "\u0127",
    "HumpDownHump;": "\u224E",
    "HumpEqual;": "\u224F",
    "hybull;": "\u2043",
    "hyphen;": "\u2010",
    "Iacute;": "\u00CD",
    "Iacute": "\u00CD",
    "iacute;": "\u00ED",
    "iacute": "\u00ED",
    "ic;": "\u2063",
    "Icirc;": "\u00CE",
    "Icirc": "\u00CE",
    "icirc;": "\u00EE",
    "icirc": "\u00EE",
    "Icy;": "\u0418",
    "icy;": "\u0438",
    "Idot;": "\u0130",
    "IEcy;": "\u0415",
    "iecy;": "\u0435",
    "iexcl;": "\u00A1",
    "iexcl": "\u00A1",
    "iff;": "\u21D4",
    "Ifr;": "\u2111",
    "ifr;": "\uD835\uDD26",
    "Igrave;": "\u00CC",
    "Igrave": "\u00CC",
    "igrave;": "\u00EC",
    "igrave": "\u00EC",
    "ii;": "\u2148",
    "iiiint;": "\u2A0C",
    "iiint;": "\u222D",
    "iinfin;": "\u29DC",
    "iiota;": "\u2129",
    "IJlig;": "\u0132",
    "ijlig;": "\u0133",
    "Im;": "\u2111",
    "Imacr;": "\u012A",
    "imacr;": "\u012B",
    "image;": "\u2111",
    "ImaginaryI;": "\u2148",
    "imagline;": "\u2110",
    "imagpart;": "\u2111",
    "imath;": "\u0131",
    "imof;": "\u22B7",
    "imped;": "\u01B5",
    "Implies;": "\u21D2",
    "in;": "\u2208",
    "incare;": "\u2105",
    "infin;": "\u221E",
    "infintie;": "\u29DD",
    "inodot;": "\u0131",
    "Int;": "\u222C",
    "int;": "\u222B",
    "intcal;": "\u22BA",
    "integers;": "\u2124",
    "Integral;": "\u222B",
    "intercal;": "\u22BA",
    "Intersection;": "\u22C2",
    "intlarhk;": "\u2A17",
    "intprod;": "\u2A3C",
    "InvisibleComma;": "\u2063",
    "InvisibleTimes;": "\u2062",
    "IOcy;": "\u0401",
    "iocy;": "\u0451",
    "Iogon;": "\u012E",
    "iogon;": "\u012F",
    "Iopf;": "\uD835\uDD40",
    "iopf;": "\uD835\uDD5A",
    "Iota;": "\u0399",
    "iota;": "\u03B9",
    "iprod;": "\u2A3C",
    "iquest;": "\u00BF",
    "iquest": "\u00BF",
    "Iscr;": "\u2110",
    "iscr;": "\uD835\uDCBE",
    "isin;": "\u2208",
    "isindot;": "\u22F5",
    "isinE;": "\u22F9",
    "isins;": "\u22F4",
    "isinsv;": "\u22F3",
    "isinv;": "\u2208",
    "it;": "\u2062",
    "Itilde;": "\u0128",
    "itilde;": "\u0129",
    "Iukcy;": "\u0406",
    "iukcy;": "\u0456",
    "Iuml;": "\u00CF",
    "Iuml": "\u00CF",
    "iuml;": "\u00EF",
    "iuml": "\u00EF",
    "Jcirc;": "\u0134",
    "jcirc;": "\u0135",
    "Jcy;": "\u0419",
    "jcy;": "\u0439",
    "Jfr;": "\uD835\uDD0D",
    "jfr;": "\uD835\uDD27",
    "jmath;": "\u0237",
    "Jopf;": "\uD835\uDD41",
    "jopf;": "\uD835\uDD5B",
    "Jscr;": "\uD835\uDCA5",
    "jscr;": "\uD835\uDCBF",
    "Jsercy;": "\u0408",
    "jsercy;": "\u0458",
    "Jukcy;": "\u0404",
    "jukcy;": "\u0454",
    "Kappa;": "\u039A",
    "kappa;": "\u03BA",
    "kappav;": "\u03F0",
    "Kcedil;": "\u0136",
    "kcedil;": "\u0137",
    "Kcy;": "\u041A",
    "kcy;": "\u043A",
    "Kfr;": "\uD835\uDD0E",
    "kfr;": "\uD835\uDD28",
    "kgreen;": "\u0138",
    "KHcy;": "\u0425",
    "khcy;": "\u0445",
    "KJcy;": "\u040C",
    "kjcy;": "\u045C",
    "Kopf;": "\uD835\uDD42",
    "kopf;": "\uD835\uDD5C",
    "Kscr;": "\uD835\uDCA6",
    "kscr;": "\uD835\uDCC0",
    "lAarr;": "\u21DA",
    "Lacute;": "\u0139",
    "lacute;": "\u013A",
    "laemptyv;": "\u29B4",
    "lagran;": "\u2112",
    "Lambda;": "\u039B",
    "lambda;": "\u03BB",
    "Lang;": "\u27EA",
    "lang;": "\u27E8",
    "langd;": "\u2991",
    "langle;": "\u27E8",
    "lap;": "\u2A85",
    "Laplacetrf;": "\u2112",
    "laquo;": "\u00AB",
    "laquo": "\u00AB",
    "Larr;": "\u219E",
    "lArr;": "\u21D0",
    "larr;": "\u2190",
    "larrb;": "\u21E4",
    "larrbfs;": "\u291F",
    "larrfs;": "\u291D",
    "larrhk;": "\u21A9",
    "larrlp;": "\u21AB",
    "larrpl;": "\u2939",
    "larrsim;": "\u2973",
    "larrtl;": "\u21A2",
    "lat;": "\u2AAB",
    "lAtail;": "\u291B",
    "latail;": "\u2919",
    "late;": "\u2AAD",
    "lates;": "\u2AAD\uFE00",
    "lBarr;": "\u290E",
    "lbarr;": "\u290C",
    "lbbrk;": "\u2772",
    "lbrace;": "\u007B",
    "lbrack;": "\u005B",
    "lbrke;": "\u298B",
    "lbrksld;": "\u298F",
    "lbrkslu;": "\u298D",
    "Lcaron;": "\u013D",
    "lcaron;": "\u013E",
    "Lcedil;": "\u013B",
    "lcedil;": "\u013C",
    "lceil;": "\u2308",
    "lcub;": "\u007B",
    "Lcy;": "\u041B",
    "lcy;": "\u043B",
    "ldca;": "\u2936",
    "ldquo;": "\u201C",
    "ldquor;": "\u201E",
    "ldrdhar;": "\u2967",
    "ldrushar;": "\u294B",
    "ldsh;": "\u21B2",
    "lE;": "\u2266",
    "le;": "\u2264",
    "LeftAngleBracket;": "\u27E8",
    "LeftArrow;": "\u2190",
    "Leftarrow;": "\u21D0",
    "leftarrow;": "\u2190",
    "LeftArrowBar;": "\u21E4",
    "LeftArrowRightArrow;": "\u21C6",
    "leftarrowtail;": "\u21A2",
    "LeftCeiling;": "\u2308",
    "LeftDoubleBracket;": "\u27E6",
    "LeftDownTeeVector;": "\u2961",
    "LeftDownVector;": "\u21C3",
    "LeftDownVectorBar;": "\u2959",
    "LeftFloor;": "\u230A",
    "leftharpoondown;": "\u21BD",
    "leftharpoonup;": "\u21BC",
    "leftleftarrows;": "\u21C7",
    "LeftRightArrow;": "\u2194",
    "Leftrightarrow;": "\u21D4",
    "leftrightarrow;": "\u2194",
    "leftrightarrows;": "\u21C6",
    "leftrightharpoons;": "\u21CB",
    "leftrightsquigarrow;": "\u21AD",
    "LeftRightVector;": "\u294E",
    "LeftTee;": "\u22A3",
    "LeftTeeArrow;": "\u21A4",
    "LeftTeeVector;": "\u295A",
    "leftthreetimes;": "\u22CB",
    "LeftTriangle;": "\u22B2",
    "LeftTriangleBar;": "\u29CF",
    "LeftTriangleEqual;": "\u22B4",
    "LeftUpDownVector;": "\u2951",
    "LeftUpTeeVector;": "\u2960",
    "LeftUpVector;": "\u21BF",
    "LeftUpVectorBar;": "\u2958",
    "LeftVector;": "\u21BC",
    "LeftVectorBar;": "\u2952",
    "lEg;": "\u2A8B",
    "leg;": "\u22DA",
    "leq;": "\u2264",
    "leqq;": "\u2266",
    "leqslant;": "\u2A7D",
    "les;": "\u2A7D",
    "lescc;": "\u2AA8",
    "lesdot;": "\u2A7F",
    "lesdoto;": "\u2A81",
    "lesdotor;": "\u2A83",
    "lesg;": "\u22DA\uFE00",
    "lesges;": "\u2A93",
    "lessapprox;": "\u2A85",
    "lessdot;": "\u22D6",
    "lesseqgtr;": "\u22DA",
    "lesseqqgtr;": "\u2A8B",
    "LessEqualGreater;": "\u22DA",
    "LessFullEqual;": "\u2266",
    "LessGreater;": "\u2276",
    "lessgtr;": "\u2276",
    "LessLess;": "\u2AA1",
    "lesssim;": "\u2272",
    "LessSlantEqual;": "\u2A7D",
    "LessTilde;": "\u2272",
    "lfisht;": "\u297C",
    "lfloor;": "\u230A",
    "Lfr;": "\uD835\uDD0F",
    "lfr;": "\uD835\uDD29",
    "lg;": "\u2276",
    "lgE;": "\u2A91",
    "lHar;": "\u2962",
    "lhard;": "\u21BD",
    "lharu;": "\u21BC",
    "lharul;": "\u296A",
    "lhblk;": "\u2584",
    "LJcy;": "\u0409",
    "ljcy;": "\u0459",
    "Ll;": "\u22D8",
    "ll;": "\u226A",
    "llarr;": "\u21C7",
    "llcorner;": "\u231E",
    "Lleftarrow;": "\u21DA",
    "llhard;": "\u296B",
    "lltri;": "\u25FA",
    "Lmidot;": "\u013F",
    "lmidot;": "\u0140",
    "lmoust;": "\u23B0",
    "lmoustache;": "\u23B0",
    "lnap;": "\u2A89",
    "lnapprox;": "\u2A89",
    "lnE;": "\u2268",
    "lne;": "\u2A87",
    "lneq;": "\u2A87",
    "lneqq;": "\u2268",
    "lnsim;": "\u22E6",
    "loang;": "\u27EC",
    "loarr;": "\u21FD",
    "lobrk;": "\u27E6",
    "LongLeftArrow;": "\u27F5",
    "Longleftarrow;": "\u27F8",
    "longleftarrow;": "\u27F5",
    "LongLeftRightArrow;": "\u27F7",
    "Longleftrightarrow;": "\u27FA",
    "longleftrightarrow;": "\u27F7",
    "longmapsto;": "\u27FC",
    "LongRightArrow;": "\u27F6",
    "Longrightarrow;": "\u27F9",
    "longrightarrow;": "\u27F6",
    "looparrowleft;": "\u21AB",
    "looparrowright;": "\u21AC",
    "lopar;": "\u2985",
    "Lopf;": "\uD835\uDD43",
    "lopf;": "\uD835\uDD5D",
    "loplus;": "\u2A2D",
    "lotimes;": "\u2A34",
    "lowast;": "\u2217",
    "lowbar;": "\u005F",
    "LowerLeftArrow;": "\u2199",
    "LowerRightArrow;": "\u2198",
    "loz;": "\u25CA",
    "lozenge;": "\u25CA",
    "lozf;": "\u29EB",
    "lpar;": "\u0028",
    "lparlt;": "\u2993",
    "lrarr;": "\u21C6",
    "lrcorner;": "\u231F",
    "lrhar;": "\u21CB",
    "lrhard;": "\u296D",
    "lrm;": "\u200E",
    "lrtri;": "\u22BF",
    "lsaquo;": "\u2039",
    "Lscr;": "\u2112",
    "lscr;": "\uD835\uDCC1",
    "Lsh;": "\u21B0",
    "lsh;": "\u21B0",
    "lsim;": "\u2272",
    "lsime;": "\u2A8D",
    "lsimg;": "\u2A8F",
    "lsqb;": "\u005B",
    "lsquo;": "\u2018",
    "lsquor;": "\u201A",
    "Lstrok;": "\u0141",
    "lstrok;": "\u0142",
    "LT;": "\u003C",
    "LT": "\u003C",
    "Lt;": "\u226A",
    "lt;": "\u003C",
    "lt": "\u003C",
    "ltcc;": "\u2AA6",
    "ltcir;": "\u2A79",
    "ltdot;": "\u22D6",
    "lthree;": "\u22CB",
    "ltimes;": "\u22C9",
    "ltlarr;": "\u2976",
    "ltquest;": "\u2A7B",
    "ltri;": "\u25C3",
    "ltrie;": "\u22B4",
    "ltrif;": "\u25C2",
    "ltrPar;": "\u2996",
    "lurdshar;": "\u294A",
    "luruhar;": "\u2966",
    "lvertneqq;": "\u2268\uFE00",
    "lvnE;": "\u2268\uFE00",
    "macr;": "\u00AF",
    "macr": "\u00AF",
    "male;": "\u2642",
    "malt;": "\u2720",
    "maltese;": "\u2720",
    "Map;": "\u2905",
    "map;": "\u21A6",
    "mapsto;": "\u21A6",
    "mapstodown;": "\u21A7",
    "mapstoleft;": "\u21A4",
    "mapstoup;": "\u21A5",
    "marker;": "\u25AE",
    "mcomma;": "\u2A29",
    "Mcy;": "\u041C",
    "mcy;": "\u043C",
    "mdash;": "\u2014",
    "mDDot;": "\u223A",
    "measuredangle;": "\u2221",
    "MediumSpace;": "\u205F",
    "Mellintrf;": "\u2133",
    "Mfr;": "\uD835\uDD10",
    "mfr;": "\uD835\uDD2A",
    "mho;": "\u2127",
    "micro;": "\u00B5",
    "micro": "\u00B5",
    "mid;": "\u2223",
    "midast;": "\u002A",
    "midcir;": "\u2AF0",
    "middot;": "\u00B7",
    "middot": "\u00B7",
    "minus;": "\u2212",
    "minusb;": "\u229F",
    "minusd;": "\u2238",
    "minusdu;": "\u2A2A",
    "MinusPlus;": "\u2213",
    "mlcp;": "\u2ADB",
    "mldr;": "\u2026",
    "mnplus;": "\u2213",
    "models;": "\u22A7",
    "Mopf;": "\uD835\uDD44",
    "mopf;": "\uD835\uDD5E",
    "mp;": "\u2213",
    "Mscr;": "\u2133",
    "mscr;": "\uD835\uDCC2",
    "mstpos;": "\u223E",
    "Mu;": "\u039C",
    "mu;": "\u03BC",
    "multimap;": "\u22B8",
    "mumap;": "\u22B8",
    "nabla;": "\u2207",
    "Nacute;": "\u0143",
    "nacute;": "\u0144",
    "nang;": "\u2220\u20D2",
    "nap;": "\u2249",
    "napE;": "\u2A70\u0338",
    "napid;": "\u224B\u0338",
    "napos;": "\u0149",
    "napprox;": "\u2249",
    "natur;": "\u266E",
    "natural;": "\u266E",
    "naturals;": "\u2115",
    "nbsp;": "\u00A0",
    "nbsp": "\u00A0",
    "nbump;": "\u224E\u0338",
    "nbumpe;": "\u224F\u0338",
    "ncap;": "\u2A43",
    "Ncaron;": "\u0147",
    "ncaron;": "\u0148",
    "Ncedil;": "\u0145",
    "ncedil;": "\u0146",
    "ncong;": "\u2247",
    "ncongdot;": "\u2A6D\u0338",
    "ncup;": "\u2A42",
    "Ncy;": "\u041D",
    "ncy;": "\u043D",
    "ndash;": "\u2013",
    "ne;": "\u2260",
    "nearhk;": "\u2924",
    "neArr;": "\u21D7",
    "nearr;": "\u2197",
    "nearrow;": "\u2197",
    "nedot;": "\u2250\u0338",
    "NegativeMediumSpace;": "\u200B",
    "NegativeThickSpace;": "\u200B",
    "NegativeThinSpace;": "\u200B",
    "NegativeVeryThinSpace;": "\u200B",
    "nequiv;": "\u2262",
    "nesear;": "\u2928",
    "nesim;": "\u2242\u0338",
    "NestedGreaterGreater;": "\u226B",
    "NestedLessLess;": "\u226A",
    "NewLine;": "\u000A",
    "nexist;": "\u2204",
    "nexists;": "\u2204",
    "Nfr;": "\uD835\uDD11",
    "nfr;": "\uD835\uDD2B",
    "ngE;": "\u2267\u0338",
    "nge;": "\u2271",
    "ngeq;": "\u2271",
    "ngeqq;": "\u2267\u0338",
    "ngeqslant;": "\u2A7E\u0338",
    "nges;": "\u2A7E\u0338",
    "nGg;": "\u22D9\u0338",
    "ngsim;": "\u2275",
    "nGt;": "\u226B\u20D2",
    "ngt;": "\u226F",
    "ngtr;": "\u226F",
    "nGtv;": "\u226B\u0338",
    "nhArr;": "\u21CE",
    "nharr;": "\u21AE",
    "nhpar;": "\u2AF2",
    "ni;": "\u220B",
    "nis;": "\u22FC",
    "nisd;": "\u22FA",
    "niv;": "\u220B",
    "NJcy;": "\u040A",
    "njcy;": "\u045A",
    "nlArr;": "\u21CD",
    "nlarr;": "\u219A",
    "nldr;": "\u2025",
    "nlE;": "\u2266\u0338",
    "nle;": "\u2270",
    "nLeftarrow;": "\u21CD",
    "nleftarrow;": "\u219A",
    "nLeftrightarrow;": "\u21CE",
    "nleftrightarrow;": "\u21AE",
    "nleq;": "\u2270",
    "nleqq;": "\u2266\u0338",
    "nleqslant;": "\u2A7D\u0338",
    "nles;": "\u2A7D\u0338",
    "nless;": "\u226E",
    "nLl;": "\u22D8\u0338",
    "nlsim;": "\u2274",
    "nLt;": "\u226A\u20D2",
    "nlt;": "\u226E",
    "nltri;": "\u22EA",
    "nltrie;": "\u22EC",
    "nLtv;": "\u226A\u0338",
    "nmid;": "\u2224",
    "NoBreak;": "\u2060",
    "NonBreakingSpace;": "\u00A0",
    "Nopf;": "\u2115",
    "nopf;": "\uD835\uDD5F",
    "Not;": "\u2AEC",
    "not;": "\u00AC",
    "not": "\u00AC",
    "NotCongruent;": "\u2262",
    "NotCupCap;": "\u226D",
    "NotDoubleVerticalBar;": "\u2226",
    "NotElement;": "\u2209",
    "NotEqual;": "\u2260",
    "NotEqualTilde;": "\u2242\u0338",
    "NotExists;": "\u2204",
    "NotGreater;": "\u226F",
    "NotGreaterEqual;": "\u2271",
    "NotGreaterFullEqual;": "\u2267\u0338",
    "NotGreaterGreater;": "\u226B\u0338",
    "NotGreaterLess;": "\u2279",
    "NotGreaterSlantEqual;": "\u2A7E\u0338",
    "NotGreaterTilde;": "\u2275",
    "NotHumpDownHump;": "\u224E\u0338",
    "NotHumpEqual;": "\u224F\u0338",
    "notin;": "\u2209",
    "notindot;": "\u22F5\u0338",
    "notinE;": "\u22F9\u0338",
    "notinva;": "\u2209",
    "notinvb;": "\u22F7",
    "notinvc;": "\u22F6",
    "NotLeftTriangle;": "\u22EA",
    "NotLeftTriangleBar;": "\u29CF\u0338",
    "NotLeftTriangleEqual;": "\u22EC",
    "NotLess;": "\u226E",
    "NotLessEqual;": "\u2270",
    "NotLessGreater;": "\u2278",
    "NotLessLess;": "\u226A\u0338",
    "NotLessSlantEqual;": "\u2A7D\u0338",
    "NotLessTilde;": "\u2274",
    "NotNestedGreaterGreater;": "\u2AA2\u0338",
    "NotNestedLessLess;": "\u2AA1\u0338",
    "notni;": "\u220C",
    "notniva;": "\u220C",
    "notnivb;": "\u22FE",
    "notnivc;": "\u22FD",
    "NotPrecedes;": "\u2280",
    "NotPrecedesEqual;": "\u2AAF\u0338",
    "NotPrecedesSlantEqual;": "\u22E0",
    "NotReverseElement;": "\u220C",
    "NotRightTriangle;": "\u22EB",
    "NotRightTriangleBar;": "\u29D0\u0338",
    "NotRightTriangleEqual;": "\u22ED",
    "NotSquareSubset;": "\u228F\u0338",
    "NotSquareSubsetEqual;": "\u22E2",
    "NotSquareSuperset;": "\u2290\u0338",
    "NotSquareSupersetEqual;": "\u22E3",
    "NotSubset;": "\u2282\u20D2",
    "NotSubsetEqual;": "\u2288",
    "NotSucceeds;": "\u2281",
    "NotSucceedsEqual;": "\u2AB0\u0338",
    "NotSucceedsSlantEqual;": "\u22E1",
    "NotSucceedsTilde;": "\u227F\u0338",
    "NotSuperset;": "\u2283\u20D2",
    "NotSupersetEqual;": "\u2289",
    "NotTilde;": "\u2241",
    "NotTildeEqual;": "\u2244",
    "NotTildeFullEqual;": "\u2247",
    "NotTildeTilde;": "\u2249",
    "NotVerticalBar;": "\u2224",
    "npar;": "\u2226",
    "nparallel;": "\u2226",
    "nparsl;": "\u2AFD\u20E5",
    "npart;": "\u2202\u0338",
    "npolint;": "\u2A14",
    "npr;": "\u2280",
    "nprcue;": "\u22E0",
    "npre;": "\u2AAF\u0338",
    "nprec;": "\u2280",
    "npreceq;": "\u2AAF\u0338",
    "nrArr;": "\u21CF",
    "nrarr;": "\u219B",
    "nrarrc;": "\u2933\u0338",
    "nrarrw;": "\u219D\u0338",
    "nRightarrow;": "\u21CF",
    "nrightarrow;": "\u219B",
    "nrtri;": "\u22EB",
    "nrtrie;": "\u22ED",
    "nsc;": "\u2281",
    "nsccue;": "\u22E1",
    "nsce;": "\u2AB0\u0338",
    "Nscr;": "\uD835\uDCA9",
    "nscr;": "\uD835\uDCC3",
    "nshortmid;": "\u2224",
    "nshortparallel;": "\u2226",
    "nsim;": "\u2241",
    "nsime;": "\u2244",
    "nsimeq;": "\u2244",
    "nsmid;": "\u2224",
    "nspar;": "\u2226",
    "nsqsube;": "\u22E2",
    "nsqsupe;": "\u22E3",
    "nsub;": "\u2284",
    "nsubE;": "\u2AC5\u0338",
    "nsube;": "\u2288",
    "nsubset;": "\u2282\u20D2",
    "nsubseteq;": "\u2288",
    "nsubseteqq;": "\u2AC5\u0338",
    "nsucc;": "\u2281",
    "nsucceq;": "\u2AB0\u0338",
    "nsup;": "\u2285",
    "nsupE;": "\u2AC6\u0338",
    "nsupe;": "\u2289",
    "nsupset;": "\u2283\u20D2",
    "nsupseteq;": "\u2289",
    "nsupseteqq;": "\u2AC6\u0338",
    "ntgl;": "\u2279",
    "Ntilde;": "\u00D1",
    "Ntilde": "\u00D1",
    "ntilde;": "\u00F1",
    "ntilde": "\u00F1",
    "ntlg;": "\u2278",
    "ntriangleleft;": "\u22EA",
    "ntrianglelefteq;": "\u22EC",
    "ntriangleright;": "\u22EB",
    "ntrianglerighteq;": "\u22ED",
    "Nu;": "\u039D",
    "nu;": "\u03BD",
    "num;": "\u0023",
    "numero;": "\u2116",
    "numsp;": "\u2007",
    "nvap;": "\u224D\u20D2",
    "nVDash;": "\u22AF",
    "nVdash;": "\u22AE",
    "nvDash;": "\u22AD",
    "nvdash;": "\u22AC",
    "nvge;": "\u2265\u20D2",
    "nvgt;": "\u003E\u20D2",
    "nvHarr;": "\u2904",
    "nvinfin;": "\u29DE",
    "nvlArr;": "\u2902",
    "nvle;": "\u2264\u20D2",
    "nvlt;": "\u003C\u20D2",
    "nvltrie;": "\u22B4\u20D2",
    "nvrArr;": "\u2903",
    "nvrtrie;": "\u22B5\u20D2",
    "nvsim;": "\u223C\u20D2",
    "nwarhk;": "\u2923",
    "nwArr;": "\u21D6",
    "nwarr;": "\u2196",
    "nwarrow;": "\u2196",
    "nwnear;": "\u2927",
    "Oacute;": "\u00D3",
    "Oacute": "\u00D3",
    "oacute;": "\u00F3",
    "oacute": "\u00F3",
    "oast;": "\u229B",
    "ocir;": "\u229A",
    "Ocirc;": "\u00D4",
    "Ocirc": "\u00D4",
    "ocirc;": "\u00F4",
    "ocirc": "\u00F4",
    "Ocy;": "\u041E",
    "ocy;": "\u043E",
    "odash;": "\u229D",
    "Odblac;": "\u0150",
    "odblac;": "\u0151",
    "odiv;": "\u2A38",
    "odot;": "\u2299",
    "odsold;": "\u29BC",
    "OElig;": "\u0152",
    "oelig;": "\u0153",
    "ofcir;": "\u29BF",
    "Ofr;": "\uD835\uDD12",
    "ofr;": "\uD835\uDD2C",
    "ogon;": "\u02DB",
    "Ograve;": "\u00D2",
    "Ograve": "\u00D2",
    "ograve;": "\u00F2",
    "ograve": "\u00F2",
    "ogt;": "\u29C1",
    "ohbar;": "\u29B5",
    "ohm;": "\u03A9",
    "oint;": "\u222E",
    "olarr;": "\u21BA",
    "olcir;": "\u29BE",
    "olcross;": "\u29BB",
    "oline;": "\u203E",
    "olt;": "\u29C0",
    "Omacr;": "\u014C",
    "omacr;": "\u014D",
    "Omega;": "\u03A9",
    "omega;": "\u03C9",
    "Omicron;": "\u039F",
    "omicron;": "\u03BF",
    "omid;": "\u29B6",
    "ominus;": "\u2296",
    "Oopf;": "\uD835\uDD46",
    "oopf;": "\uD835\uDD60",
    "opar;": "\u29B7",
    "OpenCurlyDoubleQuote;": "\u201C",
    "OpenCurlyQuote;": "\u2018",
    "operp;": "\u29B9",
    "oplus;": "\u2295",
    "Or;": "\u2A54",
    "or;": "\u2228",
    "orarr;": "\u21BB",
    "ord;": "\u2A5D",
    "order;": "\u2134",
    "orderof;": "\u2134",
    "ordf;": "\u00AA",
    "ordf": "\u00AA",
    "ordm;": "\u00BA",
    "ordm": "\u00BA",
    "origof;": "\u22B6",
    "oror;": "\u2A56",
    "orslope;": "\u2A57",
    "orv;": "\u2A5B",
    "oS;": "\u24C8",
    "Oscr;": "\uD835\uDCAA",
    "oscr;": "\u2134",
    "Oslash;": "\u00D8",
    "Oslash": "\u00D8",
    "oslash;": "\u00F8",
    "oslash": "\u00F8",
    "osol;": "\u2298",
    "Otilde;": "\u00D5",
    "Otilde": "\u00D5",
    "otilde;": "\u00F5",
    "otilde": "\u00F5",
    "Otimes;": "\u2A37",
    "otimes;": "\u2297",
    "otimesas;": "\u2A36",
    "Ouml;": "\u00D6",
    "Ouml": "\u00D6",
    "ouml;": "\u00F6",
    "ouml": "\u00F6",
    "ovbar;": "\u233D",
    "OverBar;": "\u203E",
    "OverBrace;": "\u23DE",
    "OverBracket;": "\u23B4",
    "OverParenthesis;": "\u23DC",
    "par;": "\u2225",
    "para;": "\u00B6",
    "para": "\u00B6",
    "parallel;": "\u2225",
    "parsim;": "\u2AF3",
    "parsl;": "\u2AFD",
    "part;": "\u2202",
    "PartialD;": "\u2202",
    "Pcy;": "\u041F",
    "pcy;": "\u043F",
    "percnt;": "\u0025",
    "period;": "\u002E",
    "permil;": "\u2030",
    "perp;": "\u22A5",
    "pertenk;": "\u2031",
    "Pfr;": "\uD835\uDD13",
    "pfr;": "\uD835\uDD2D",
    "Phi;": "\u03A6",
    "phi;": "\u03C6",
    "phiv;": "\u03D5",
    "phmmat;": "\u2133",
    "phone;": "\u260E",
    "Pi;": "\u03A0",
    "pi;": "\u03C0",
    "pitchfork;": "\u22D4",
    "piv;": "\u03D6",
    "planck;": "\u210F",
    "planckh;": "\u210E",
    "plankv;": "\u210F",
    "plus;": "\u002B",
    "plusacir;": "\u2A23",
    "plusb;": "\u229E",
    "pluscir;": "\u2A22",
    "plusdo;": "\u2214",
    "plusdu;": "\u2A25",
    "pluse;": "\u2A72",
    "PlusMinus;": "\u00B1",
    "plusmn;": "\u00B1",
    "plusmn": "\u00B1",
    "plussim;": "\u2A26",
    "plustwo;": "\u2A27",
    "pm;": "\u00B1",
    "Poincareplane;": "\u210C",
    "pointint;": "\u2A15",
    "Popf;": "\u2119",
    "popf;": "\uD835\uDD61",
    "pound;": "\u00A3",
    "pound": "\u00A3",
    "Pr;": "\u2ABB",
    "pr;": "\u227A",
    "prap;": "\u2AB7",
    "prcue;": "\u227C",
    "prE;": "\u2AB3",
    "pre;": "\u2AAF",
    "prec;": "\u227A",
    "precapprox;": "\u2AB7",
    "preccurlyeq;": "\u227C",
    "Precedes;": "\u227A",
    "PrecedesEqual;": "\u2AAF",
    "PrecedesSlantEqual;": "\u227C",
    "PrecedesTilde;": "\u227E",
    "preceq;": "\u2AAF",
    "precnapprox;": "\u2AB9",
    "precneqq;": "\u2AB5",
    "precnsim;": "\u22E8",
    "precsim;": "\u227E",
    "Prime;": "\u2033",
    "prime;": "\u2032",
    "primes;": "\u2119",
    "prnap;": "\u2AB9",
    "prnE;": "\u2AB5",
    "prnsim;": "\u22E8",
    "prod;": "\u220F",
    "Product;": "\u220F",
    "profalar;": "\u232E",
    "profline;": "\u2312",
    "profsurf;": "\u2313",
    "prop;": "\u221D",
    "Proportion;": "\u2237",
    "Proportional;": "\u221D",
    "propto;": "\u221D",
    "prsim;": "\u227E",
    "prurel;": "\u22B0",
    "Pscr;": "\uD835\uDCAB",
    "pscr;": "\uD835\uDCC5",
    "Psi;": "\u03A8",
    "psi;": "\u03C8",
    "puncsp;": "\u2008",
    "Qfr;": "\uD835\uDD14",
    "qfr;": "\uD835\uDD2E",
    "qint;": "\u2A0C",
    "Qopf;": "\u211A",
    "qopf;": "\uD835\uDD62",
    "qprime;": "\u2057",
    "Qscr;": "\uD835\uDCAC",
    "qscr;": "\uD835\uDCC6",
    "quaternions;": "\u210D",
    "quatint;": "\u2A16",
    "quest;": "\u003F",
    "questeq;": "\u225F",
    "QUOT;": "\u0022",
    "QUOT": "\u0022",
    "quot;": "\u0022",
    "quot": "\u0022",
    "rAarr;": "\u21DB",
    "race;": "\u223D\u0331",
    "Racute;": "\u0154",
    "racute;": "\u0155",
    "radic;": "\u221A",
    "raemptyv;": "\u29B3",
    "Rang;": "\u27EB",
    "rang;": "\u27E9",
    "rangd;": "\u2992",
    "range;": "\u29A5",
    "rangle;": "\u27E9",
    "raquo;": "\u00BB",
    "raquo": "\u00BB",
    "Rarr;": "\u21A0",
    "rArr;": "\u21D2",
    "rarr;": "\u2192",
    "rarrap;": "\u2975",
    "rarrb;": "\u21E5",
    "rarrbfs;": "\u2920",
    "rarrc;": "\u2933",
    "rarrfs;": "\u291E",
    "rarrhk;": "\u21AA",
    "rarrlp;": "\u21AC",
    "rarrpl;": "\u2945",
    "rarrsim;": "\u2974",
    "Rarrtl;": "\u2916",
    "rarrtl;": "\u21A3",
    "rarrw;": "\u219D",
    "rAtail;": "\u291C",
    "ratail;": "\u291A",
    "ratio;": "\u2236",
    "rationals;": "\u211A",
    "RBarr;": "\u2910",
    "rBarr;": "\u290F",
    "rbarr;": "\u290D",
    "rbbrk;": "\u2773",
    "rbrace;": "\u007D",
    "rbrack;": "\u005D",
    "rbrke;": "\u298C",
    "rbrksld;": "\u298E",
    "rbrkslu;": "\u2990",
    "Rcaron;": "\u0158",
    "rcaron;": "\u0159",
    "Rcedil;": "\u0156",
    "rcedil;": "\u0157",
    "rceil;": "\u2309",
    "rcub;": "\u007D",
    "Rcy;": "\u0420",
    "rcy;": "\u0440",
    "rdca;": "\u2937",
    "rdldhar;": "\u2969",
    "rdquo;": "\u201D",
    "rdquor;": "\u201D",
    "rdsh;": "\u21B3",
    "Re;": "\u211C",
    "real;": "\u211C",
    "realine;": "\u211B",
    "realpart;": "\u211C",
    "reals;": "\u211D",
    "rect;": "\u25AD",
    "REG;": "\u00AE",
    "REG": "\u00AE",
    "reg;": "\u00AE",
    "reg": "\u00AE",
    "ReverseElement;": "\u220B",
    "ReverseEquilibrium;": "\u21CB",
    "ReverseUpEquilibrium;": "\u296F",
    "rfisht;": "\u297D",
    "rfloor;": "\u230B",
    "Rfr;": "\u211C",
    "rfr;": "\uD835\uDD2F",
    "rHar;": "\u2964",
    "rhard;": "\u21C1",
    "rharu;": "\u21C0",
    "rharul;": "\u296C",
    "Rho;": "\u03A1",
    "rho;": "\u03C1",
    "rhov;": "\u03F1",
    "RightAngleBracket;": "\u27E9",
    "RightArrow;": "\u2192",
    "Rightarrow;": "\u21D2",
    "rightarrow;": "\u2192",
    "RightArrowBar;": "\u21E5",
    "RightArrowLeftArrow;": "\u21C4",
    "rightarrowtail;": "\u21A3",
    "RightCeiling;": "\u2309",
    "RightDoubleBracket;": "\u27E7",
    "RightDownTeeVector;": "\u295D",
    "RightDownVector;": "\u21C2",
    "RightDownVectorBar;": "\u2955",
    "RightFloor;": "\u230B",
    "rightharpoondown;": "\u21C1",
    "rightharpoonup;": "\u21C0",
    "rightleftarrows;": "\u21C4",
    "rightleftharpoons;": "\u21CC",
    "rightrightarrows;": "\u21C9",
    "rightsquigarrow;": "\u219D",
    "RightTee;": "\u22A2",
    "RightTeeArrow;": "\u21A6",
    "RightTeeVector;": "\u295B",
    "rightthreetimes;": "\u22CC",
    "RightTriangle;": "\u22B3",
    "RightTriangleBar;": "\u29D0",
    "RightTriangleEqual;": "\u22B5",
    "RightUpDownVector;": "\u294F",
    "RightUpTeeVector;": "\u295C",
    "RightUpVector;": "\u21BE",
    "RightUpVectorBar;": "\u2954",
    "RightVector;": "\u21C0",
    "RightVectorBar;": "\u2953",
    "ring;": "\u02DA",
    "risingdotseq;": "\u2253",
    "rlarr;": "\u21C4",
    "rlhar;": "\u21CC",
    "rlm;": "\u200F",
    "rmoust;": "\u23B1",
    "rmoustache;": "\u23B1",
    "rnmid;": "\u2AEE",
    "roang;": "\u27ED",
    "roarr;": "\u21FE",
    "robrk;": "\u27E7",
    "ropar;": "\u2986",
    "Ropf;": "\u211D",
    "ropf;": "\uD835\uDD63",
    "roplus;": "\u2A2E",
    "rotimes;": "\u2A35",
    "RoundImplies;": "\u2970",
    "rpar;": "\u0029",
    "rpargt;": "\u2994",
    "rppolint;": "\u2A12",
    "rrarr;": "\u21C9",
    "Rrightarrow;": "\u21DB",
    "rsaquo;": "\u203A",
    "Rscr;": "\u211B",
    "rscr;": "\uD835\uDCC7",
    "Rsh;": "\u21B1",
    "rsh;": "\u21B1",
    "rsqb;": "\u005D",
    "rsquo;": "\u2019",
    "rsquor;": "\u2019",
    "rthree;": "\u22CC",
    "rtimes;": "\u22CA",
    "rtri;": "\u25B9",
    "rtrie;": "\u22B5",
    "rtrif;": "\u25B8",
    "rtriltri;": "\u29CE",
    "RuleDelayed;": "\u29F4",
    "ruluhar;": "\u2968",
    "rx;": "\u211E",
    "Sacute;": "\u015A",
    "sacute;": "\u015B",
    "sbquo;": "\u201A",
    "Sc;": "\u2ABC",
    "sc;": "\u227B",
    "scap;": "\u2AB8",
    "Scaron;": "\u0160",
    "scaron;": "\u0161",
    "sccue;": "\u227D",
    "scE;": "\u2AB4",
    "sce;": "\u2AB0",
    "Scedil;": "\u015E",
    "scedil;": "\u015F",
    "Scirc;": "\u015C",
    "scirc;": "\u015D",
    "scnap;": "\u2ABA",
    "scnE;": "\u2AB6",
    "scnsim;": "\u22E9",
    "scpolint;": "\u2A13",
    "scsim;": "\u227F",
    "Scy;": "\u0421",
    "scy;": "\u0441",
    "sdot;": "\u22C5",
    "sdotb;": "\u22A1",
    "sdote;": "\u2A66",
    "searhk;": "\u2925",
    "seArr;": "\u21D8",
    "searr;": "\u2198",
    "searrow;": "\u2198",
    "sect;": "\u00A7",
    "sect": "\u00A7",
    "semi;": "\u003B",
    "seswar;": "\u2929",
    "setminus;": "\u2216",
    "setmn;": "\u2216",
    "sext;": "\u2736",
    "Sfr;": "\uD835\uDD16",
    "sfr;": "\uD835\uDD30",
    "sfrown;": "\u2322",
    "sharp;": "\u266F",
    "SHCHcy;": "\u0429",
    "shchcy;": "\u0449",
    "SHcy;": "\u0428",
    "shcy;": "\u0448",
    "ShortDownArrow;": "\u2193",
    "ShortLeftArrow;": "\u2190",
    "shortmid;": "\u2223",
    "shortparallel;": "\u2225",
    "ShortRightArrow;": "\u2192",
    "ShortUpArrow;": "\u2191",
    "shy;": "\u00AD",
    "shy": "\u00AD",
    "Sigma;": "\u03A3",
    "sigma;": "\u03C3",
    "sigmaf;": "\u03C2",
    "sigmav;": "\u03C2",
    "sim;": "\u223C",
    "simdot;": "\u2A6A",
    "sime;": "\u2243",
    "simeq;": "\u2243",
    "simg;": "\u2A9E",
    "simgE;": "\u2AA0",
    "siml;": "\u2A9D",
    "simlE;": "\u2A9F",
    "simne;": "\u2246",
    "simplus;": "\u2A24",
    "simrarr;": "\u2972",
    "slarr;": "\u2190",
    "SmallCircle;": "\u2218",
    "smallsetminus;": "\u2216",
    "smashp;": "\u2A33",
    "smeparsl;": "\u29E4",
    "smid;": "\u2223",
    "smile;": "\u2323",
    "smt;": "\u2AAA",
    "smte;": "\u2AAC",
    "smtes;": "\u2AAC\uFE00",
    "SOFTcy;": "\u042C",
    "softcy;": "\u044C",
    "sol;": "\u002F",
    "solb;": "\u29C4",
    "solbar;": "\u233F",
    "Sopf;": "\uD835\uDD4A",
    "sopf;": "\uD835\uDD64",
    "spades;": "\u2660",
    "spadesuit;": "\u2660",
    "spar;": "\u2225",
    "sqcap;": "\u2293",
    "sqcaps;": "\u2293\uFE00",
    "sqcup;": "\u2294",
    "sqcups;": "\u2294\uFE00",
    "Sqrt;": "\u221A",
    "sqsub;": "\u228F",
    "sqsube;": "\u2291",
    "sqsubset;": "\u228F",
    "sqsubseteq;": "\u2291",
    "sqsup;": "\u2290",
    "sqsupe;": "\u2292",
    "sqsupset;": "\u2290",
    "sqsupseteq;": "\u2292",
    "squ;": "\u25A1",
    "Square;": "\u25A1",
    "square;": "\u25A1",
    "SquareIntersection;": "\u2293",
    "SquareSubset;": "\u228F",
    "SquareSubsetEqual;": "\u2291",
    "SquareSuperset;": "\u2290",
    "SquareSupersetEqual;": "\u2292",
    "SquareUnion;": "\u2294",
    "squarf;": "\u25AA",
    "squf;": "\u25AA",
    "srarr;": "\u2192",
    "Sscr;": "\uD835\uDCAE",
    "sscr;": "\uD835\uDCC8",
    "ssetmn;": "\u2216",
    "ssmile;": "\u2323",
    "sstarf;": "\u22C6",
    "Star;": "\u22C6",
    "star;": "\u2606",
    "starf;": "\u2605",
    "straightepsilon;": "\u03F5",
    "straightphi;": "\u03D5",
    "strns;": "\u00AF",
    "Sub;": "\u22D0",
    "sub;": "\u2282",
    "subdot;": "\u2ABD",
    "subE;": "\u2AC5",
    "sube;": "\u2286",
    "subedot;": "\u2AC3",
    "submult;": "\u2AC1",
    "subnE;": "\u2ACB",
    "subne;": "\u228A",
    "subplus;": "\u2ABF",
    "subrarr;": "\u2979",
    "Subset;": "\u22D0",
    "subset;": "\u2282",
    "subseteq;": "\u2286",
    "subseteqq;": "\u2AC5",
    "SubsetEqual;": "\u2286",
    "subsetneq;": "\u228A",
    "subsetneqq;": "\u2ACB",
    "subsim;": "\u2AC7",
    "subsub;": "\u2AD5",
    "subsup;": "\u2AD3",
    "succ;": "\u227B",
    "succapprox;": "\u2AB8",
    "succcurlyeq;": "\u227D",
    "Succeeds;": "\u227B",
    "SucceedsEqual;": "\u2AB0",
    "SucceedsSlantEqual;": "\u227D",
    "SucceedsTilde;": "\u227F",
    "succeq;": "\u2AB0",
    "succnapprox;": "\u2ABA",
    "succneqq;": "\u2AB6",
    "succnsim;": "\u22E9",
    "succsim;": "\u227F",
    "SuchThat;": "\u220B",
    "Sum;": "\u2211",
    "sum;": "\u2211",
    "sung;": "\u266A",
    "Sup;": "\u22D1",
    "sup;": "\u2283",
    "sup1;": "\u00B9",
    "sup1": "\u00B9",
    "sup2;": "\u00B2",
    "sup2": "\u00B2",
    "sup3;": "\u00B3",
    "sup3": "\u00B3",
    "supdot;": "\u2ABE",
    "supdsub;": "\u2AD8",
    "supE;": "\u2AC6",
    "supe;": "\u2287",
    "supedot;": "\u2AC4",
    "Superset;": "\u2283",
    "SupersetEqual;": "\u2287",
    "suphsol;": "\u27C9",
    "suphsub;": "\u2AD7",
    "suplarr;": "\u297B",
    "supmult;": "\u2AC2",
    "supnE;": "\u2ACC",
    "supne;": "\u228B",
    "supplus;": "\u2AC0",
    "Supset;": "\u22D1",
    "supset;": "\u2283",
    "supseteq;": "\u2287",
    "supseteqq;": "\u2AC6",
    "supsetneq;": "\u228B",
    "supsetneqq;": "\u2ACC",
    "supsim;": "\u2AC8",
    "supsub;": "\u2AD4",
    "supsup;": "\u2AD6",
    "swarhk;": "\u2926",
    "swArr;": "\u21D9",
    "swarr;": "\u2199",
    "swarrow;": "\u2199",
    "swnwar;": "\u292A",
    "szlig;": "\u00DF",
    "szlig": "\u00DF",
    "Tab;": "\u0009",
    "target;": "\u2316",
    "Tau;": "\u03A4",
    "tau;": "\u03C4",
    "tbrk;": "\u23B4",
    "Tcaron;": "\u0164",
    "tcaron;": "\u0165",
    "Tcedil;": "\u0162",
    "tcedil;": "\u0163",
    "Tcy;": "\u0422",
    "tcy;": "\u0442",
    "tdot;": "\u20DB",
    "telrec;": "\u2315",
    "Tfr;": "\uD835\uDD17",
    "tfr;": "\uD835\uDD31",
    "there4;": "\u2234",
    "Therefore;": "\u2234",
    "therefore;": "\u2234",
    "Theta;": "\u0398",
    "theta;": "\u03B8",
    "thetasym;": "\u03D1",
    "thetav;": "\u03D1",
    "thickapprox;": "\u2248",
    "thicksim;": "\u223C",
    "ThickSpace;": "\u205F\u200A",
    "thinsp;": "\u2009",
    "ThinSpace;": "\u2009",
    "thkap;": "\u2248",
    "thksim;": "\u223C",
    "THORN;": "\u00DE",
    "THORN": "\u00DE",
    "thorn;": "\u00FE",
    "thorn": "\u00FE",
    "Tilde;": "\u223C",
    "tilde;": "\u02DC",
    "TildeEqual;": "\u2243",
    "TildeFullEqual;": "\u2245",
    "TildeTilde;": "\u2248",
    "times;": "\u00D7",
    "times": "\u00D7",
    "timesb;": "\u22A0",
    "timesbar;": "\u2A31",
    "timesd;": "\u2A30",
    "tint;": "\u222D",
    "toea;": "\u2928",
    "top;": "\u22A4",
    "topbot;": "\u2336",
    "topcir;": "\u2AF1",
    "Topf;": "\uD835\uDD4B",
    "topf;": "\uD835\uDD65",
    "topfork;": "\u2ADA",
    "tosa;": "\u2929",
    "tprime;": "\u2034",
    "TRADE;": "\u2122",
    "trade;": "\u2122",
    "triangle;": "\u25B5",
    "triangledown;": "\u25BF",
    "triangleleft;": "\u25C3",
    "trianglelefteq;": "\u22B4",
    "triangleq;": "\u225C",
    "triangleright;": "\u25B9",
    "trianglerighteq;": "\u22B5",
    "tridot;": "\u25EC",
    "trie;": "\u225C",
    "triminus;": "\u2A3A",
    "TripleDot;": "\u20DB",
    "triplus;": "\u2A39",
    "trisb;": "\u29CD",
    "tritime;": "\u2A3B",
    "trpezium;": "\u23E2",
    "Tscr;": "\uD835\uDCAF",
    "tscr;": "\uD835\uDCC9",
    "TScy;": "\u0426",
    "tscy;": "\u0446",
    "TSHcy;": "\u040B",
    "tshcy;": "\u045B",
    "Tstrok;": "\u0166",
    "tstrok;": "\u0167",
    "twixt;": "\u226C",
    "twoheadleftarrow;": "\u219E",
    "twoheadrightarrow;": "\u21A0",
    "Uacute;": "\u00DA",
    "Uacute": "\u00DA",
    "uacute;": "\u00FA",
    "uacute": "\u00FA",
    "Uarr;": "\u219F",
    "uArr;": "\u21D1",
    "uarr;": "\u2191",
    "Uarrocir;": "\u2949",
    "Ubrcy;": "\u040E",
    "ubrcy;": "\u045E",
    "Ubreve;": "\u016C",
    "ubreve;": "\u016D",
    "Ucirc;": "\u00DB",
    "Ucirc": "\u00DB",
    "ucirc;": "\u00FB",
    "ucirc": "\u00FB",
    "Ucy;": "\u0423",
    "ucy;": "\u0443",
    "udarr;": "\u21C5",
    "Udblac;": "\u0170",
    "udblac;": "\u0171",
    "udhar;": "\u296E",
    "ufisht;": "\u297E",
    "Ufr;": "\uD835\uDD18",
    "ufr;": "\uD835\uDD32",
    "Ugrave;": "\u00D9",
    "Ugrave": "\u00D9",
    "ugrave;": "\u00F9",
    "ugrave": "\u00F9",
    "uHar;": "\u2963",
    "uharl;": "\u21BF",
    "uharr;": "\u21BE",
    "uhblk;": "\u2580",
    "ulcorn;": "\u231C",
    "ulcorner;": "\u231C",
    "ulcrop;": "\u230F",
    "ultri;": "\u25F8",
    "Umacr;": "\u016A",
    "umacr;": "\u016B",
    "uml;": "\u00A8",
    "uml": "\u00A8",
    "UnderBar;": "\u005F",
    "UnderBrace;": "\u23DF",
    "UnderBracket;": "\u23B5",
    "UnderParenthesis;": "\u23DD",
    "Union;": "\u22C3",
    "UnionPlus;": "\u228E",
    "Uogon;": "\u0172",
    "uogon;": "\u0173",
    "Uopf;": "\uD835\uDD4C",
    "uopf;": "\uD835\uDD66",
    "UpArrow;": "\u2191",
    "Uparrow;": "\u21D1",
    "uparrow;": "\u2191",
    "UpArrowBar;": "\u2912",
    "UpArrowDownArrow;": "\u21C5",
    "UpDownArrow;": "\u2195",
    "Updownarrow;": "\u21D5",
    "updownarrow;": "\u2195",
    "UpEquilibrium;": "\u296E",
    "upharpoonleft;": "\u21BF",
    "upharpoonright;": "\u21BE",
    "uplus;": "\u228E",
    "UpperLeftArrow;": "\u2196",
    "UpperRightArrow;": "\u2197",
    "Upsi;": "\u03D2",
    "upsi;": "\u03C5",
    "upsih;": "\u03D2",
    "Upsilon;": "\u03A5",
    "upsilon;": "\u03C5",
    "UpTee;": "\u22A5",
    "UpTeeArrow;": "\u21A5",
    "upuparrows;": "\u21C8",
    "urcorn;": "\u231D",
    "urcorner;": "\u231D",
    "urcrop;": "\u230E",
    "Uring;": "\u016E",
    "uring;": "\u016F",
    "urtri;": "\u25F9",
    "Uscr;": "\uD835\uDCB0",
    "uscr;": "\uD835\uDCCA",
    "utdot;": "\u22F0",
    "Utilde;": "\u0168",
    "utilde;": "\u0169",
    "utri;": "\u25B5",
    "utrif;": "\u25B4",
    "uuarr;": "\u21C8",
    "Uuml;": "\u00DC",
    "Uuml": "\u00DC",
    "uuml;": "\u00FC",
    "uuml": "\u00FC",
    "uwangle;": "\u29A7",
    "vangrt;": "\u299C",
    "varepsilon;": "\u03F5",
    "varkappa;": "\u03F0",
    "varnothing;": "\u2205",
    "varphi;": "\u03D5",
    "varpi;": "\u03D6",
    "varpropto;": "\u221D",
    "vArr;": "\u21D5",
    "varr;": "\u2195",
    "varrho;": "\u03F1",
    "varsigma;": "\u03C2",
    "varsubsetneq;": "\u228A\uFE00",
    "varsubsetneqq;": "\u2ACB\uFE00",
    "varsupsetneq;": "\u228B\uFE00",
    "varsupsetneqq;": "\u2ACC\uFE00",
    "vartheta;": "\u03D1",
    "vartriangleleft;": "\u22B2",
    "vartriangleright;": "\u22B3",
    "Vbar;": "\u2AEB",
    "vBar;": "\u2AE8",
    "vBarv;": "\u2AE9",
    "Vcy;": "\u0412",
    "vcy;": "\u0432",
    "VDash;": "\u22AB",
    "Vdash;": "\u22A9",
    "vDash;": "\u22A8",
    "vdash;": "\u22A2",
    "Vdashl;": "\u2AE6",
    "Vee;": "\u22C1",
    "vee;": "\u2228",
    "veebar;": "\u22BB",
    "veeeq;": "\u225A",
    "vellip;": "\u22EE",
    "Verbar;": "\u2016",
    "verbar;": "\u007C",
    "Vert;": "\u2016",
    "vert;": "\u007C",
    "VerticalBar;": "\u2223",
    "VerticalLine;": "\u007C",
    "VerticalSeparator;": "\u2758",
    "VerticalTilde;": "\u2240",
    "VeryThinSpace;": "\u200A",
    "Vfr;": "\uD835\uDD19",
    "vfr;": "\uD835\uDD33",
    "vltri;": "\u22B2",
    "vnsub;": "\u2282\u20D2",
    "vnsup;": "\u2283\u20D2",
    "Vopf;": "\uD835\uDD4D",
    "vopf;": "\uD835\uDD67",
    "vprop;": "\u221D",
    "vrtri;": "\u22B3",
    "Vscr;": "\uD835\uDCB1",
    "vscr;": "\uD835\uDCCB",
    "vsubnE;": "\u2ACB\uFE00",
    "vsubne;": "\u228A\uFE00",
    "vsupnE;": "\u2ACC\uFE00",
    "vsupne;": "\u228B\uFE00",
    "Vvdash;": "\u22AA",
    "vzigzag;": "\u299A",
    "Wcirc;": "\u0174",
    "wcirc;": "\u0175",
    "wedbar;": "\u2A5F",
    "Wedge;": "\u22C0",
    "wedge;": "\u2227",
    "wedgeq;": "\u2259",
    "weierp;": "\u2118",
    "Wfr;": "\uD835\uDD1A",
    "wfr;": "\uD835\uDD34",
    "Wopf;": "\uD835\uDD4E",
    "wopf;": "\uD835\uDD68",
    "wp;": "\u2118",
    "wr;": "\u2240",
    "wreath;": "\u2240",
    "Wscr;": "\uD835\uDCB2",
    "wscr;": "\uD835\uDCCC",
    "xcap;": "\u22C2",
    "xcirc;": "\u25EF",
    "xcup;": "\u22C3",
    "xdtri;": "\u25BD",
    "Xfr;": "\uD835\uDD1B",
    "xfr;": "\uD835\uDD35",
    "xhArr;": "\u27FA",
    "xharr;": "\u27F7",
    "Xi;": "\u039E",
    "xi;": "\u03BE",
    "xlArr;": "\u27F8",
    "xlarr;": "\u27F5",
    "xmap;": "\u27FC",
    "xnis;": "\u22FB",
    "xodot;": "\u2A00",
    "Xopf;": "\uD835\uDD4F",
    "xopf;": "\uD835\uDD69",
    "xoplus;": "\u2A01",
    "xotime;": "\u2A02",
    "xrArr;": "\u27F9",
    "xrarr;": "\u27F6",
    "Xscr;": "\uD835\uDCB3",
    "xscr;": "\uD835\uDCCD",
    "xsqcup;": "\u2A06",
    "xuplus;": "\u2A04",
    "xutri;": "\u25B3",
    "xvee;": "\u22C1",
    "xwedge;": "\u22C0",
    "Yacute;": "\u00DD",
    "Yacute": "\u00DD",
    "yacute;": "\u00FD",
    "yacute": "\u00FD",
    "YAcy;": "\u042F",
    "yacy;": "\u044F",
    "Ycirc;": "\u0176",
    "ycirc;": "\u0177",
    "Ycy;": "\u042B",
    "ycy;": "\u044B",
    "yen;": "\u00A5",
    "yen": "\u00A5",
    "Yfr;": "\uD835\uDD1C",
    "yfr;": "\uD835\uDD36",
    "YIcy;": "\u0407",
    "yicy;": "\u0457",
    "Yopf;": "\uD835\uDD50",
    "yopf;": "\uD835\uDD6A",
    "Yscr;": "\uD835\uDCB4",
    "yscr;": "\uD835\uDCCE",
    "YUcy;": "\u042E",
    "yucy;": "\u044E",
    "Yuml;": "\u0178",
    "yuml;": "\u00FF",
    "yuml": "\u00FF",
    "Zacute;": "\u0179",
    "zacute;": "\u017A",
    "Zcaron;": "\u017D",
    "zcaron;": "\u017E",
    "Zcy;": "\u0417",
    "zcy;": "\u0437",
    "Zdot;": "\u017B",
    "zdot;": "\u017C",
    "zeetrf;": "\u2128",
    "ZeroWidthSpace;": "\u200B",
    "Zeta;": "\u0396",
    "zeta;": "\u03B6",
    "Zfr;": "\u2128",
    "zfr;": "\uD835\uDD37",
    "ZHcy;": "\u0416",
    "zhcy;": "\u0436",
    "zigrarr;": "\u21DD",
    "Zopf;": "\u2124",
    "zopf;": "\uD835\uDD6B",
    "Zscr;": "\uD835\uDCB5",
    "zscr;": "\uD835\uDCCF",
    "zwj;": "\u200D",
    "zwnj;": "\u200C"
};

function startsWith$1(haystack, needle) {
    if (haystack.length < needle.length) {
        return false;
    }
    for (let i = 0; i < needle.length; i++) {
        if (haystack[i] !== needle[i]) {
            return false;
        }
    }
    return true;
}
function endsWith$1(haystack, needle) {
    const diff = haystack.length - needle.length;
    if (diff > 0) {
        return haystack.lastIndexOf(needle) === diff;
    }
    else if (diff === 0) {
        return haystack === needle;
    }
    else {
        return false;
    }
}
function repeat$1(value, count) {
    let s = '';
    while (count > 0) {
        if ((count & 1) === 1) {
            s += value;
        }
        value += value;
        count = count >>> 1;
    }
    return s;
}
const _a$2 = 'a'.charCodeAt(0);
const _z$1 = 'z'.charCodeAt(0);
const _A$1 = 'A'.charCodeAt(0);
const _Z$1 = 'Z'.charCodeAt(0);
const _0$2 = '0'.charCodeAt(0);
const _9$2 = '9'.charCodeAt(0);
function isLetterOrDigit(text, index) {
    const c = text.charCodeAt(index);
    return (_a$2 <= c && c <= _z$1) || (_A$1 <= c && c <= _Z$1) || (_0$2 <= c && c <= _9$2);
}

function isDefined$1(obj) {
    return typeof obj !== 'undefined';
}

function normalizeMarkupContent(input) {
    if (!input) {
        return undefined;
    }
    if (typeof input === 'string') {
        return {
            kind: 'markdown',
            value: input
        };
    }
    return {
        kind: 'markdown',
        value: input.value
    };
}

const BaselineImages$1 = {
    BASELINE_LIMITED: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTgiIGhlaWdodD0iMTAiIHZpZXdCb3g9IjAgMCA1NDAgMzAwIiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgogIDxzdHlsZT4KICAgIC5ncmF5LXNoYXBlIHsKICAgICAgZmlsbDogI0M2QzZDNjsgLyogTGlnaHQgbW9kZSAqLwogICAgfQoKICAgIEBtZWRpYSAocHJlZmVycy1jb2xvci1zY2hlbWU6IGRhcmspIHsKICAgICAgLmdyYXktc2hhcGUgewogICAgICAgIGZpbGw6ICM1NjU2NTY7IC8qIERhcmsgbW9kZSAqLwogICAgICB9CiAgICB9CiAgPC9zdHlsZT4KICA8cGF0aCBkPSJNMTUwIDBMMjQwIDkwTDIxMCAxMjBMMTIwIDMwTDE1MCAwWiIgZmlsbD0iI0YwOTQwOSIvPgogIDxwYXRoIGQ9Ik00MjAgMzBMNTQwIDE1MEw0MjAgMjcwTDM5MCAyNDBMNDgwIDE1MEwzOTAgNjBMNDIwIDMwWiIgY2xhc3M9ImdyYXktc2hhcGUiLz4KICA8cGF0aCBkPSJNMzMwIDE4MEwzMDAgMjEwTDM5MCAzMDBMNDIwIDI3MEwzMzAgMTgwWiIgZmlsbD0iI0YwOTQwOSIvPgogIDxwYXRoIGQ9Ik0xMjAgMzBMMTUwIDYwTDYwIDE1MEwxNTAgMjQwTDEyMCAyNzBMMCAxNTBMMTIwIDMwWiIgY2xhc3M9ImdyYXktc2hhcGUiLz4KICA8cGF0aCBkPSJNMzkwIDBMNDIwIDMwTDE1MCAzMDBMMTIwIDI3MEwzOTAgMFoiIGZpbGw9IiNGMDk0MDkiLz4KPC9zdmc+',
    BASELINE_LOW: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTgiIGhlaWdodD0iMTAiIHZpZXdCb3g9IjAgMCA1NDAgMzAwIiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgogIDxzdHlsZT4KICAgIC5ibHVlLXNoYXBlIHsKICAgICAgZmlsbDogI0E4QzdGQTsgLyogTGlnaHQgbW9kZSAqLwogICAgfQoKICAgIEBtZWRpYSAocHJlZmVycy1jb2xvci1zY2hlbWU6IGRhcmspIHsKICAgICAgLmJsdWUtc2hhcGUgewogICAgICAgIGZpbGw6ICMyRDUwOUU7IC8qIERhcmsgbW9kZSAqLwogICAgICB9CiAgICB9CgogICAgLmRhcmtlci1ibHVlLXNoYXBlIHsKICAgICAgICBmaWxsOiAjMUI2RUYzOwogICAgfQoKICAgIEBtZWRpYSAocHJlZmVycy1jb2xvci1zY2hlbWU6IGRhcmspIHsKICAgICAgICAuZGFya2VyLWJsdWUtc2hhcGUgewogICAgICAgICAgICBmaWxsOiAjNDE4NUZGOwogICAgICAgIH0KICAgIH0KCiAgPC9zdHlsZT4KICA8cGF0aCBkPSJNMTUwIDBMMTgwIDMwTDE1MCA2MEwxMjAgMzBMMTUwIDBaIiBjbGFzcz0iYmx1ZS1zaGFwZSIvPgogIDxwYXRoIGQ9Ik0yMTAgNjBMMjQwIDkwTDIxMCAxMjBMMTgwIDkwTDIxMCA2MFoiIGNsYXNzPSJibHVlLXNoYXBlIi8+CiAgPHBhdGggZD0iTTQ1MCA2MEw0ODAgOTBMNDUwIDEyMEw0MjAgOTBMNDUwIDYwWiIgY2xhc3M9ImJsdWUtc2hhcGUiLz4KICA8cGF0aCBkPSJNNTEwIDEyMEw1NDAgMTUwTDUxMCAxODBMNDgwIDE1MEw1MTAgMTIwWiIgY2xhc3M9ImJsdWUtc2hhcGUiLz4KICA8cGF0aCBkPSJNNDUwIDE4MEw0ODAgMjEwTDQ1MCAyNDBMNDIwIDIxMEw0NTAgMTgwWiIgY2xhc3M9ImJsdWUtc2hhcGUiLz4KICA8cGF0aCBkPSJNMzkwIDI0MEw0MjAgMjcwTDM5MCAzMDBMMzYwIDI3MEwzOTAgMjQwWiIgY2xhc3M9ImJsdWUtc2hhcGUiLz4KICA8cGF0aCBkPSJNMzMwIDE4MEwzNjAgMjEwTDMzMCAyNDBMMzAwIDIxMEwzMzAgMTgwWiIgY2xhc3M9ImJsdWUtc2hhcGUiLz4KICA8cGF0aCBkPSJNOTAgNjBMMTIwIDkwTDkwIDEyMEw2MCA5MEw5MCA2MFoiIGNsYXNzPSJibHVlLXNoYXBlIi8+CiAgPHBhdGggZD0iTTM5MCAwTDQyMCAzMEwxNTAgMzAwTDAgMTUwTDMwIDEyMEwxNTAgMjQwTDM5MCAwWiIgY2xhc3M9ImRhcmtlci1ibHVlLXNoYXBlIi8+Cjwvc3ZnPg==',
    BASELINE_HIGH: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTgiIGhlaWdodD0iMTAiIHZpZXdCb3g9IjAgMCA1NDAgMzAwIiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgogIDxzdHlsZT4KICAgIC5ncmVlbi1zaGFwZSB7CiAgICAgIGZpbGw6ICNDNEVFRDA7IC8qIExpZ2h0IG1vZGUgKi8KICAgIH0KCiAgICBAbWVkaWEgKHByZWZlcnMtY29sb3Itc2NoZW1lOiBkYXJrKSB7CiAgICAgIC5ncmVlbi1zaGFwZSB7CiAgICAgICAgZmlsbDogIzEyNTIyNTsgLyogRGFyayBtb2RlICovCiAgICAgIH0KICAgIH0KICA8L3N0eWxlPgogIDxwYXRoIGQ9Ik00MjAgMzBMMzkwIDYwTDQ4MCAxNTBMMzkwIDI0MEwzMzAgMTgwTDMwMCAyMTBMMzkwIDMwMEw1NDAgMTUwTDQyMCAzMFoiIGNsYXNzPSJncmVlbi1zaGFwZSIvPgogIDxwYXRoIGQ9Ik0xNTAgMEwzMCAxMjBMNjAgMTUwTDE1MCA2MEwyMTAgMTIwTDI0MCA5MEwxNTAgMFoiIGNsYXNzPSJncmVlbi1zaGFwZSIvPgogIDxwYXRoIGQ9Ik0zOTAgMEw0MjAgMzBMMTUwIDMwMEwwIDE1MEwzMCAxMjBMMTUwIDI0MEwzOTAgMFoiIGZpbGw9IiMxRUE0NDYiLz4KPC9zdmc+'
};
function getEntryBaselineImage$1(status) {
    if (!status) {
        return '';
    }
    let baselineImg;
    switch (status?.baseline) {
        case 'low':
            baselineImg = BaselineImages$1.BASELINE_LOW;
            break;
        case 'high':
            baselineImg = BaselineImages$1.BASELINE_HIGH;
            break;
        default:
            baselineImg = BaselineImages$1.BASELINE_LIMITED;
    }
    return `![Baseline icon](${baselineImg})`;
}
function getEntryBaselineStatus$1(status, browsers) {
    if (!status) {
        return '';
    }
    if (status.baseline === false) {
        const missingBrowsers = getMissingBaselineBrowsers$1(browsers);
        let status = `Limited availability across major browsers`;
        if (missingBrowsers) {
            status += ` (Not fully implemented in ${missingBrowsers})`;
        }
        return status;
    }
    const baselineYear = status.baseline_low_date?.split('-')[0];
    return `${status.baseline === 'low' ? 'Newly' : 'Widely'} available across major browsers (Baseline since ${baselineYear})`;
}
const browserNames$1 = {
    'C': {
        name: 'Chrome',
        platform: 'desktop'
    },
    'CA': {
        name: 'Chrome',
        platform: 'Android'
    },
    'E': {
        name: 'Edge',
        platform: 'desktop'
    },
    'FF': {
        name: 'Firefox',
        platform: 'desktop'
    },
    'FFA': {
        name: 'Firefox',
        platform: 'Android'
    },
    'S': {
        name: 'Safari',
        platform: 'macOS'
    },
    'SM': {
        name: 'Safari',
        platform: 'iOS'
    }
};
const shortCompatPattern$1 = /(E|FFA|FF|SM|S|CA|C|IE|O)([\d|\.]+)?/;
const missingBaselineBrowserFormatter$1 = new Intl.ListFormat("en", {
    style: "long",
    type: "disjunction",
});
function getMissingBaselineBrowsers$1(browsers) {
    if (!browsers) {
        return '';
    }
    const missingBrowsers = new Map(Object.entries(browserNames$1));
    for (const shortCompatString of browsers) {
        const match = shortCompatPattern$1.exec(shortCompatString);
        if (!match) {
            continue;
        }
        const browser = match[1];
        missingBrowsers.delete(browser);
    }
    return missingBaselineBrowserFormatter$1.format(Object.values(Array.from(missingBrowsers.entries()).reduce((browsers, [browserId, browser]) => {
        if (browser.name in browsers || browserId === 'E') {
            browsers[browser.name] = browser.name;
            return browsers;
        }
        browsers[browser.name] = `${browser.name} on ${browser.platform}`;
        return browsers;
    }, {})));
}
class HTMLDataProvider {
    isApplicable() {
        return true;
    }
    constructor(id, customData) {
        this.id = id;
        this._tags = [];
        this._tagMap = {};
        this._valueSetMap = {};
        this._tags = customData.tags || [];
        this._globalAttributes = customData.globalAttributes || [];
        this._tags.forEach(t => {
            this._tagMap[t.name.toLowerCase()] = t;
        });
        if (customData.valueSets) {
            customData.valueSets.forEach(vs => {
                this._valueSetMap[vs.name] = vs.values;
            });
        }
    }
    getId() {
        return this.id;
    }
    provideTags() {
        return this._tags;
    }
    provideAttributes(tag) {
        const attributes = [];
        const processAttribute = (a) => {
            attributes.push(a);
        };
        const tagEntry = this._tagMap[tag.toLowerCase()];
        if (tagEntry) {
            tagEntry.attributes.forEach(processAttribute);
        }
        this._globalAttributes.forEach(processAttribute);
        return attributes;
    }
    provideValues(tag, attribute) {
        const values = [];
        attribute = attribute.toLowerCase();
        const processAttributes = (attributes) => {
            attributes.forEach(a => {
                if (a.name.toLowerCase() === attribute) {
                    if (a.values) {
                        a.values.forEach(v => {
                            values.push(v);
                        });
                    }
                    if (a.valueSet) {
                        if (this._valueSetMap[a.valueSet]) {
                            this._valueSetMap[a.valueSet].forEach(v => {
                                values.push(v);
                            });
                        }
                    }
                }
            });
        };
        const tagEntry = this._tagMap[tag.toLowerCase()];
        if (tagEntry) {
            processAttributes(tagEntry.attributes);
        }
        processAttributes(this._globalAttributes);
        return values;
    }
}
function generateDocumentation(item, settings = {}, doesSupportMarkdown) {
    const result = {
        kind: doesSupportMarkdown ? 'markdown' : 'plaintext',
        value: ''
    };
    if (item.description && settings.documentation !== false) {
        const normalizedDescription = normalizeMarkupContent(item.description);
        if (normalizedDescription) {
            result.value += normalizedDescription.value;
        }
    }
    if (item.status && settings.documentation !== false) {
        if (result.value.length) {
            result.value += `\n\n`;
        }
        const baselineStatus = getEntryBaselineStatus$1(item.status, item.browsers);
        if (doesSupportMarkdown) {
            result.value += `${getEntryBaselineImage$1(item.status)} _${baselineStatus}_`;
        }
        else {
            result.value += baselineStatus;
        }
    }
    if (item.references && item.references.length > 0 && settings.references !== false) {
        if (result.value.length) {
            result.value += `\n\n`;
        }
        if (doesSupportMarkdown) {
            result.value += item.references.map(r => {
                return `[${r.name}](${r.url})`;
            }).join(' | ');
        }
        else {
            result.value += item.references.map(r => {
                return `${r.name}: ${r.url}`;
            }).join('\n');
        }
    }
    if (result.value === '') {
        return undefined;
    }
    return result;
}

let PathCompletionParticipant$1 = class PathCompletionParticipant {
    constructor(dataManager, readDirectory) {
        this.dataManager = dataManager;
        this.readDirectory = readDirectory;
        this.atributeCompletions = [];
    }
    onHtmlAttributeValue(context) {
        if (this.dataManager.isPathAttribute(context.tag, context.attribute)) {
            this.atributeCompletions.push(context);
        }
    }
    async computeCompletions(document, documentContext) {
        const result = { items: [], isIncomplete: false };
        for (const attributeCompletion of this.atributeCompletions) {
            const fullValue = stripQuotes$1(document.getText(attributeCompletion.range));
            if (isCompletablePath(fullValue)) {
                if (fullValue === '.' || fullValue === '..') {
                    result.isIncomplete = true;
                }
                else {
                    const replaceRange = pathToReplaceRange$1(attributeCompletion.value, fullValue, attributeCompletion.range);
                    const suggestions = await this.providePathSuggestions(attributeCompletion.value, replaceRange, document, documentContext);
                    for (const item of suggestions) {
                        result.items.push(item);
                    }
                }
            }
        }
        return result;
    }
    async providePathSuggestions(valueBeforeCursor, replaceRange, document, documentContext) {
        const valueBeforeLastSlash = valueBeforeCursor.substring(0, valueBeforeCursor.lastIndexOf('/') + 1);
        let parentDir = documentContext.resolveReference(valueBeforeLastSlash || '.', document.uri);
        if (parentDir) {
            try {
                const result = [];
                const infos = await this.readDirectory(parentDir);
                for (const [name, type] of infos) {
                    if (name.charCodeAt(0) !== CharCode_dot$1) {
                        result.push(createCompletionItem$1(name, type === FileType$2.Directory, replaceRange));
                    }
                }
                return result;
            }
            catch (e) {
            }
        }
        return [];
    }
};
const CharCode_dot$1 = '.'.charCodeAt(0);
function stripQuotes$1(fullValue) {
    if (startsWith$1(fullValue, `'`) || startsWith$1(fullValue, `"`)) {
        return fullValue.slice(1, -1);
    }
    else {
        return fullValue;
    }
}
function isCompletablePath(value) {
    if (startsWith$1(value, 'http') || startsWith$1(value, 'https') || startsWith$1(value, '//')) {
        return false;
    }
    return true;
}
function pathToReplaceRange$1(valueBeforeCursor, fullValue, range) {
    let replaceRange;
    const lastIndexOfSlash = valueBeforeCursor.lastIndexOf('/');
    if (lastIndexOfSlash === -1) {
        replaceRange = shiftRange$1(range, 1, -1);
    }
    else {
        const valueAfterLastSlash = fullValue.slice(lastIndexOfSlash + 1);
        const startPos = shiftPosition$1(range.end, -1 - valueAfterLastSlash.length);
        const whitespaceIndex = valueAfterLastSlash.indexOf(' ');
        let endPos;
        if (whitespaceIndex !== -1) {
            endPos = shiftPosition$1(startPos, whitespaceIndex);
        }
        else {
            endPos = shiftPosition$1(range.end, -1);
        }
        replaceRange = Range$1.create(startPos, endPos);
    }
    return replaceRange;
}
function createCompletionItem$1(p, isDir, replaceRange) {
    if (isDir) {
        p = p + '/';
        return {
            label: p,
            kind: CompletionItemKind$1.Folder,
            textEdit: TextEdit$1.replace(replaceRange, p),
            command: {
                title: 'Suggest',
                command: 'editor.action.triggerSuggest'
            }
        };
    }
    else {
        return {
            label: p,
            kind: CompletionItemKind$1.File,
            textEdit: TextEdit$1.replace(replaceRange, p)
        };
    }
}
function shiftPosition$1(pos, offset) {
    return Position$1.create(pos.line, pos.character + offset);
}
function shiftRange$1(range, startOffset, endOffset) {
    const start = shiftPosition$1(range.start, startOffset);
    const end = shiftPosition$1(range.end, endOffset);
    return Range$1.create(start, end);
}

class HTMLCompletion {
    constructor(lsOptions, dataManager) {
        this.lsOptions = lsOptions;
        this.dataManager = dataManager;
        this.completionParticipants = [];
    }
    setCompletionParticipants(registeredCompletionParticipants) {
        this.completionParticipants = registeredCompletionParticipants || [];
    }
    async doComplete2(document, position, htmlDocument, documentContext, settings) {
        if (!this.lsOptions.fileSystemProvider || !this.lsOptions.fileSystemProvider.readDirectory) {
            return this.doComplete(document, position, htmlDocument, settings);
        }
        const participant = new PathCompletionParticipant$1(this.dataManager, this.lsOptions.fileSystemProvider.readDirectory);
        const contributedParticipants = this.completionParticipants;
        this.completionParticipants = [participant].concat(contributedParticipants);
        const result = this.doComplete(document, position, htmlDocument, settings);
        try {
            const pathCompletionResult = await participant.computeCompletions(document, documentContext);
            return {
                isIncomplete: result.isIncomplete || pathCompletionResult.isIncomplete,
                items: pathCompletionResult.items.concat(result.items)
            };
        }
        finally {
            this.completionParticipants = contributedParticipants;
        }
    }
    doComplete(document, position, htmlDocument, settings) {
        const result = this._doComplete(document, position, htmlDocument, settings);
        return this.convertCompletionList(result);
    }
    _doComplete(document, position, htmlDocument, settings) {
        const result = {
            isIncomplete: false,
            items: []
        };
        const completionParticipants = this.completionParticipants;
        const dataProviders = this.dataManager.getDataProviders().filter(p => p.isApplicable(document.languageId) && (!settings || settings[p.getId()] !== false));
        const doesSupportMarkdown = this.doesSupportMarkdown();
        const text = document.getText();
        const offset = document.offsetAt(position);
        const node = htmlDocument.findNodeBefore(offset);
        if (!node) {
            return result;
        }
        const scanner = createScanner$1(text, node.start);
        let currentTag = '';
        let currentAttributeName;
        let voidElements;
        function getReplaceRange(replaceStart, replaceEnd = offset) {
            if (replaceStart > offset) {
                replaceStart = offset;
            }
            return { start: document.positionAt(replaceStart), end: document.positionAt(replaceEnd) };
        }
        function collectOpenTagSuggestions(afterOpenBracket, tagNameEnd) {
            const range = getReplaceRange(afterOpenBracket, tagNameEnd);
            dataProviders.forEach((provider) => {
                provider.provideTags().forEach(tag => {
                    result.items.push({
                        label: tag.name,
                        kind: CompletionItemKind$1.Property,
                        documentation: generateDocumentation(tag, undefined, doesSupportMarkdown),
                        textEdit: TextEdit$1.replace(range, tag.name),
                        insertTextFormat: InsertTextFormat$1.PlainText
                    });
                });
            });
            return result;
        }
        function getLineIndent(offset) {
            let start = offset;
            while (start > 0) {
                const ch = text.charAt(start - 1);
                if ("\n\r".indexOf(ch) >= 0) {
                    return text.substring(start, offset);
                }
                if (!isWhiteSpace$5(ch)) {
                    return null;
                }
                start--;
            }
            return text.substring(0, offset);
        }
        function collectCloseTagSuggestions(afterOpenBracket, inOpenTag, tagNameEnd = offset) {
            const range = getReplaceRange(afterOpenBracket, tagNameEnd);
            const closeTag = isFollowedBy(text, tagNameEnd, ScannerState.WithinEndTag, TokenType$1.EndTagClose) ? '' : '>';
            let curr = node;
            if (inOpenTag) {
                curr = curr.parent;
            }
            while (curr) {
                const tag = curr.tag;
                if (tag && (!curr.closed || curr.endTagStart && (curr.endTagStart > offset))) {
                    const item = {
                        label: '/' + tag,
                        kind: CompletionItemKind$1.Property,
                        filterText: '/' + tag,
                        textEdit: TextEdit$1.replace(range, '/' + tag + closeTag),
                        insertTextFormat: InsertTextFormat$1.PlainText
                    };
                    const startIndent = getLineIndent(curr.start);
                    const endIndent = getLineIndent(afterOpenBracket - 1);
                    if (startIndent !== null && endIndent !== null && startIndent !== endIndent) {
                        const insertText = startIndent + '</' + tag + closeTag;
                        item.textEdit = TextEdit$1.replace(getReplaceRange(afterOpenBracket - 1 - endIndent.length), insertText);
                        item.filterText = endIndent + '</' + tag;
                    }
                    result.items.push(item);
                    return result;
                }
                curr = curr.parent;
            }
            if (inOpenTag) {
                return result;
            }
            dataProviders.forEach(provider => {
                provider.provideTags().forEach(tag => {
                    result.items.push({
                        label: '/' + tag.name,
                        kind: CompletionItemKind$1.Property,
                        documentation: generateDocumentation(tag, undefined, doesSupportMarkdown),
                        filterText: '/' + tag.name + closeTag,
                        textEdit: TextEdit$1.replace(range, '/' + tag.name + closeTag),
                        insertTextFormat: InsertTextFormat$1.PlainText
                    });
                });
            });
            return result;
        }
        const collectAutoCloseTagSuggestion = (tagCloseEnd, tag) => {
            if (settings && settings.hideAutoCompleteProposals) {
                return result;
            }
            voidElements ?? (voidElements = this.dataManager.getVoidElements(dataProviders));
            if (!this.dataManager.isVoidElement(tag, voidElements)) {
                const pos = document.positionAt(tagCloseEnd);
                result.items.push({
                    label: '</' + tag + '>',
                    kind: CompletionItemKind$1.Property,
                    filterText: '</' + tag + '>',
                    textEdit: TextEdit$1.insert(pos, '$0</' + tag + '>'),
                    insertTextFormat: InsertTextFormat$1.Snippet
                });
            }
            return result;
        };
        function collectTagSuggestions(tagStart, tagEnd) {
            collectOpenTagSuggestions(tagStart, tagEnd);
            collectCloseTagSuggestions(tagStart, true, tagEnd);
            return result;
        }
        function getExistingAttributes() {
            const existingAttributes = Object.create(null);
            node.attributeNames.forEach(attribute => {
                existingAttributes[attribute] = true;
            });
            return existingAttributes;
        }
        function collectAttributeNameSuggestions(nameStart, nameEnd = offset) {
            let replaceEnd = offset;
            while (replaceEnd < nameEnd && text[replaceEnd] !== '<') {
                replaceEnd++;
            }
            const currentAttribute = text.substring(nameStart, nameEnd);
            const range = getReplaceRange(nameStart, replaceEnd);
            let value = '';
            if (!isFollowedBy(text, nameEnd, ScannerState.AfterAttributeName, TokenType$1.DelimiterAssign)) {
                const defaultValue = settings?.attributeDefaultValue ?? 'doublequotes';
                if (defaultValue === 'empty') {
                    value = '=$1';
                }
                else if (defaultValue === 'singlequotes') {
                    value = '=\'$1\'';
                }
                else {
                    value = '="$1"';
                }
            }
            const seenAttributes = getExistingAttributes();
            seenAttributes[currentAttribute] = false;
            dataProviders.forEach(provider => {
                provider.provideAttributes(currentTag).forEach(attr => {
                    if (seenAttributes[attr.name]) {
                        return;
                    }
                    seenAttributes[attr.name] = true;
                    let codeSnippet = attr.name;
                    let command;
                    if (attr.valueSet !== 'v' && value.length) {
                        codeSnippet = codeSnippet + value;
                        if (attr.valueSet || attr.name === 'style') {
                            command = {
                                title: 'Suggest',
                                command: 'editor.action.triggerSuggest'
                            };
                        }
                    }
                    result.items.push({
                        label: attr.name,
                        kind: attr.valueSet === 'handler' ? CompletionItemKind$1.Function : CompletionItemKind$1.Value,
                        documentation: generateDocumentation(attr, undefined, doesSupportMarkdown),
                        textEdit: TextEdit$1.replace(range, codeSnippet),
                        insertTextFormat: InsertTextFormat$1.Snippet,
                        command
                    });
                });
            });
            collectDataAttributesSuggestions(range, seenAttributes);
            return result;
        }
        function collectDataAttributesSuggestions(range, seenAttributes) {
            const dataAttr = 'data-';
            const dataAttributes = {};
            dataAttributes[dataAttr] = `${dataAttr}$1="$2"`;
            function addNodeDataAttributes(node) {
                node.attributeNames.forEach(attr => {
                    if (startsWith$1(attr, dataAttr) && !dataAttributes[attr] && !seenAttributes[attr]) {
                        dataAttributes[attr] = attr + '="$1"';
                    }
                });
                node.children.forEach(child => addNodeDataAttributes(child));
            }
            if (htmlDocument) {
                htmlDocument.roots.forEach(root => addNodeDataAttributes(root));
            }
            Object.keys(dataAttributes).forEach(attr => result.items.push({
                label: attr,
                kind: CompletionItemKind$1.Value,
                textEdit: TextEdit$1.replace(range, dataAttributes[attr]),
                insertTextFormat: InsertTextFormat$1.Snippet
            }));
        }
        function collectAttributeValueSuggestions(valueStart, valueEnd = offset) {
            let range;
            let addQuotes;
            let valuePrefix;
            if (offset > valueStart && offset <= valueEnd && isQuote$3(text[valueStart])) {
                const valueContentStart = valueStart + 1;
                let valueContentEnd = valueEnd;
                if (valueEnd > valueStart && text[valueEnd - 1] === text[valueStart]) {
                    valueContentEnd--;
                }
                const wsBefore = getWordStart(text, offset, valueContentStart);
                const wsAfter = getWordEnd(text, offset, valueContentEnd);
                range = getReplaceRange(wsBefore, wsAfter);
                valuePrefix = offset >= valueContentStart && offset <= valueContentEnd ? text.substring(valueContentStart, offset) : '';
                addQuotes = false;
            }
            else {
                range = getReplaceRange(valueStart, valueEnd);
                valuePrefix = text.substring(valueStart, offset);
                addQuotes = true;
            }
            if (completionParticipants.length > 0) {
                const tag = currentTag.toLowerCase();
                const attribute = currentAttributeName.toLowerCase();
                const fullRange = getReplaceRange(valueStart, valueEnd);
                for (const participant of completionParticipants) {
                    if (participant.onHtmlAttributeValue) {
                        participant.onHtmlAttributeValue({ document, position, tag, attribute, value: valuePrefix, range: fullRange });
                    }
                }
            }
            dataProviders.forEach(provider => {
                provider.provideValues(currentTag, currentAttributeName).forEach(value => {
                    const insertText = addQuotes ? '"' + value.name + '"' : value.name;
                    result.items.push({
                        label: value.name,
                        filterText: insertText,
                        kind: CompletionItemKind$1.Unit,
                        documentation: generateDocumentation(value, undefined, doesSupportMarkdown),
                        textEdit: TextEdit$1.replace(range, insertText),
                        insertTextFormat: InsertTextFormat$1.PlainText
                    });
                });
            });
            collectCharacterEntityProposals();
            return result;
        }
        function scanNextForEndPos(nextToken) {
            if (offset === scanner.getTokenEnd()) {
                token = scanner.scan();
                if (token === nextToken && scanner.getTokenOffset() === offset) {
                    return scanner.getTokenEnd();
                }
            }
            return offset;
        }
        function collectInsideContent() {
            for (const participant of completionParticipants) {
                if (participant.onHtmlContent) {
                    participant.onHtmlContent({ document, position });
                }
            }
            return collectCharacterEntityProposals();
        }
        function collectCharacterEntityProposals() {
            let k = offset - 1;
            let characterStart = position.character;
            while (k >= 0 && isLetterOrDigit(text, k)) {
                k--;
                characterStart--;
            }
            if (k >= 0 && text[k] === '&') {
                const range = Range$1.create(Position$1.create(position.line, characterStart - 1), position);
                for (const entity in entities) {
                    if (endsWith$1(entity, ';')) {
                        const label = '&' + entity;
                        result.items.push({
                            label,
                            kind: CompletionItemKind$1.Keyword,
                            documentation: main$4.t('Character entity representing \'{0}\'', entities[entity]),
                            textEdit: TextEdit$1.replace(range, label),
                            insertTextFormat: InsertTextFormat$1.PlainText
                        });
                    }
                }
            }
            return result;
        }
        function suggestDoctype(replaceStart, replaceEnd) {
            const range = getReplaceRange(replaceStart, replaceEnd);
            result.items.push({
                label: '!DOCTYPE',
                kind: CompletionItemKind$1.Property,
                documentation: 'A preamble for an HTML document.',
                textEdit: TextEdit$1.replace(range, '!DOCTYPE html>'),
                insertTextFormat: InsertTextFormat$1.PlainText
            });
        }
        let token = scanner.scan();
        while (token !== TokenType$1.EOS && scanner.getTokenOffset() <= offset) {
            switch (token) {
                case TokenType$1.StartTagOpen:
                    if (scanner.getTokenEnd() === offset) {
                        const endPos = scanNextForEndPos(TokenType$1.StartTag);
                        if (position.line === 0) {
                            suggestDoctype(offset, endPos);
                        }
                        return collectTagSuggestions(offset, endPos);
                    }
                    break;
                case TokenType$1.StartTag:
                    if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
                        return collectOpenTagSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd());
                    }
                    currentTag = scanner.getTokenText();
                    break;
                case TokenType$1.AttributeName:
                    if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
                        return collectAttributeNameSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd());
                    }
                    currentAttributeName = scanner.getTokenText();
                    break;
                case TokenType$1.DelimiterAssign:
                    if (scanner.getTokenEnd() === offset) {
                        const endPos = scanNextForEndPos(TokenType$1.AttributeValue);
                        return collectAttributeValueSuggestions(offset, endPos);
                    }
                    break;
                case TokenType$1.AttributeValue:
                    if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
                        return collectAttributeValueSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd());
                    }
                    break;
                case TokenType$1.Whitespace:
                    if (offset <= scanner.getTokenEnd()) {
                        switch (scanner.getScannerState()) {
                            case ScannerState.AfterOpeningStartTag:
                                const startPos = scanner.getTokenOffset();
                                const endTagPos = scanNextForEndPos(TokenType$1.StartTag);
                                return collectTagSuggestions(startPos, endTagPos);
                            case ScannerState.WithinTag:
                            case ScannerState.AfterAttributeName:
                                return collectAttributeNameSuggestions(scanner.getTokenEnd());
                            case ScannerState.BeforeAttributeValue:
                                return collectAttributeValueSuggestions(scanner.getTokenEnd());
                            case ScannerState.AfterOpeningEndTag:
                                return collectCloseTagSuggestions(scanner.getTokenOffset() - 1, false);
                            case ScannerState.WithinContent:
                                return collectInsideContent();
                        }
                    }
                    break;
                case TokenType$1.EndTagOpen:
                    if (offset <= scanner.getTokenEnd()) {
                        const afterOpenBracket = scanner.getTokenOffset() + 1;
                        const endOffset = scanNextForEndPos(TokenType$1.EndTag);
                        return collectCloseTagSuggestions(afterOpenBracket, false, endOffset);
                    }
                    break;
                case TokenType$1.EndTag:
                    if (offset <= scanner.getTokenEnd()) {
                        let start = scanner.getTokenOffset() - 1;
                        while (start >= 0) {
                            const ch = text.charAt(start);
                            if (ch === '/') {
                                return collectCloseTagSuggestions(start, false, scanner.getTokenEnd());
                            }
                            else if (!isWhiteSpace$5(ch)) {
                                break;
                            }
                            start--;
                        }
                    }
                    break;
                case TokenType$1.StartTagClose:
                    if (offset <= scanner.getTokenEnd()) {
                        if (currentTag) {
                            return collectAutoCloseTagSuggestion(scanner.getTokenEnd(), currentTag);
                        }
                    }
                    break;
                case TokenType$1.Content:
                    if (offset <= scanner.getTokenEnd()) {
                        return collectInsideContent();
                    }
                    break;
                default:
                    if (offset <= scanner.getTokenEnd()) {
                        return result;
                    }
                    break;
            }
            token = scanner.scan();
        }
        return result;
    }
    doQuoteComplete(document, position, htmlDocument, settings) {
        const offset = document.offsetAt(position);
        if (offset <= 0) {
            return null;
        }
        const defaultValue = settings?.attributeDefaultValue ?? 'doublequotes';
        if (defaultValue === 'empty') {
            return null;
        }
        const char = document.getText().charAt(offset - 1);
        if (char !== '=') {
            return null;
        }
        const value = defaultValue === 'doublequotes' ? '"$1"' : '\'$1\'';
        const node = htmlDocument.findNodeBefore(offset);
        if (node && node.attributes && node.start < offset && (!node.endTagStart || node.endTagStart > offset)) {
            const scanner = createScanner$1(document.getText(), node.start);
            let token = scanner.scan();
            while (token !== TokenType$1.EOS && scanner.getTokenEnd() <= offset) {
                if (token === TokenType$1.AttributeName && scanner.getTokenEnd() === offset - 1) {
                    token = scanner.scan();
                    if (token !== TokenType$1.DelimiterAssign) {
                        return null;
                    }
                    token = scanner.scan();
                    if (token === TokenType$1.Unknown || token === TokenType$1.AttributeValue) {
                        return null;
                    }
                    return value;
                }
                token = scanner.scan();
            }
        }
        return null;
    }
    doTagComplete(document, position, htmlDocument) {
        const offset = document.offsetAt(position);
        if (offset <= 0) {
            return null;
        }
        const char = document.getText().charAt(offset - 1);
        if (char === '>') {
            const node = htmlDocument.findNodeBefore(offset);
            if (node && node.tag && node.start < offset && (!node.endTagStart || node.endTagStart > offset)) {
                const voidElements = this.dataManager.getVoidElements(document.languageId);
                if (!this.dataManager.isVoidElement(node.tag, voidElements)) {
                    const scanner = createScanner$1(document.getText(), node.start);
                    let token = scanner.scan();
                    while (token !== TokenType$1.EOS && scanner.getTokenEnd() <= offset) {
                        if (token === TokenType$1.StartTagClose && scanner.getTokenEnd() === offset) {
                            return `$0</${node.tag}>`;
                        }
                        token = scanner.scan();
                    }
                }
            }
        }
        else if (char === '/') {
            let node = htmlDocument.findNodeBefore(offset);
            while (node && node.closed && !(node.endTagStart && (node.endTagStart > offset))) {
                node = node.parent;
            }
            if (node && node.tag) {
                const scanner = createScanner$1(document.getText(), node.start);
                let token = scanner.scan();
                while (token !== TokenType$1.EOS && scanner.getTokenEnd() <= offset) {
                    if (token === TokenType$1.EndTagOpen && scanner.getTokenEnd() === offset) {
                        if (document.getText().charAt(offset) !== '>') {
                            return `${node.tag}>`;
                        }
                        else {
                            return node.tag;
                        }
                    }
                    token = scanner.scan();
                }
            }
        }
        return null;
    }
    convertCompletionList(list) {
        if (!this.doesSupportMarkdown()) {
            list.items.forEach(item => {
                if (item.documentation && typeof item.documentation !== 'string') {
                    item.documentation = {
                        kind: 'plaintext',
                        value: item.documentation.value
                    };
                }
            });
        }
        return list;
    }
    doesSupportMarkdown() {
        if (!isDefined$1(this.supportsMarkdown)) {
            if (!isDefined$1(this.lsOptions.clientCapabilities)) {
                this.supportsMarkdown = true;
                return this.supportsMarkdown;
            }
            const documentationFormat = this.lsOptions.clientCapabilities.textDocument?.completion?.completionItem?.documentationFormat;
            this.supportsMarkdown = Array.isArray(documentationFormat) && documentationFormat.indexOf(MarkupKind$1.Markdown) !== -1;
        }
        return this.supportsMarkdown;
    }
}
function isQuote$3(s) {
    return /^["']*$/.test(s);
}
function isWhiteSpace$5(s) {
    return /^\s*$/.test(s);
}
function isFollowedBy(s, offset, intialState, expectedToken) {
    const scanner = createScanner$1(s, offset, intialState);
    let token = scanner.scan();
    while (token === TokenType$1.Whitespace) {
        token = scanner.scan();
    }
    return token === expectedToken;
}
function getWordStart(s, offset, limit) {
    while (offset > limit && !isWhiteSpace$5(s[offset - 1])) {
        offset--;
    }
    return offset;
}
function getWordEnd(s, offset, limit) {
    while (offset < limit && !isWhiteSpace$5(s[offset])) {
        offset++;
    }
    return offset;
}

class HTMLHover {
    constructor(lsOptions, dataManager) {
        this.lsOptions = lsOptions;
        this.dataManager = dataManager;
    }
    doHover(document, position, htmlDocument, options) {
        const convertContents = this.convertContents.bind(this);
        const doesSupportMarkdown = this.doesSupportMarkdown();
        const offset = document.offsetAt(position);
        const node = htmlDocument.findNodeAt(offset);
        const text = document.getText();
        if (!node || !node.tag) {
            return null;
        }
        const dataProviders = this.dataManager.getDataProviders().filter(p => p.isApplicable(document.languageId));
        function getTagHover(currTag, range, open) {
            for (const provider of dataProviders) {
                let hover = null;
                provider.provideTags().forEach(tag => {
                    if (tag.name.toLowerCase() === currTag.toLowerCase()) {
                        let markupContent = generateDocumentation(tag, options, doesSupportMarkdown);
                        if (!markupContent) {
                            markupContent = {
                                kind: doesSupportMarkdown ? 'markdown' : 'plaintext',
                                value: ''
                            };
                        }
                        hover = { contents: markupContent, range };
                    }
                });
                if (hover) {
                    hover.contents = convertContents(hover.contents);
                    return hover;
                }
            }
            return null;
        }
        function getAttrHover(currTag, currAttr, range) {
            for (const provider of dataProviders) {
                let hover = null;
                provider.provideAttributes(currTag).forEach(attr => {
                    if (currAttr === attr.name && attr.description) {
                        const contentsDoc = generateDocumentation(attr, options, doesSupportMarkdown);
                        if (contentsDoc) {
                            hover = { contents: contentsDoc, range };
                        }
                        else {
                            hover = null;
                        }
                    }
                });
                if (hover) {
                    hover.contents = convertContents(hover.contents);
                    return hover;
                }
            }
            return null;
        }
        function getAttrValueHover(currTag, currAttr, currAttrValue, range) {
            for (const provider of dataProviders) {
                let hover = null;
                provider.provideValues(currTag, currAttr).forEach(attrValue => {
                    if (currAttrValue === attrValue.name && attrValue.description) {
                        const contentsDoc = generateDocumentation(attrValue, options, doesSupportMarkdown);
                        if (contentsDoc) {
                            hover = { contents: contentsDoc, range };
                        }
                        else {
                            hover = null;
                        }
                    }
                });
                if (hover) {
                    hover.contents = convertContents(hover.contents);
                    return hover;
                }
            }
            return null;
        }
        function getEntityHover(text, range) {
            let currEntity = filterEntity(text);
            for (const entity in entities) {
                let hover = null;
                const label = '&' + entity;
                if (currEntity === label) {
                    let code = entities[entity].charCodeAt(0).toString(16).toUpperCase();
                    let hex = 'U+';
                    if (code.length < 4) {
                        const zeroes = 4 - code.length;
                        let k = 0;
                        while (k < zeroes) {
                            hex += '0';
                            k += 1;
                        }
                    }
                    hex += code;
                    const contentsDoc = main$4.t('Character entity representing \'{0}\', unicode equivalent \'{1}\'', entities[entity], hex);
                    if (contentsDoc) {
                        hover = { contents: contentsDoc, range };
                    }
                    else {
                        hover = null;
                    }
                }
                if (hover) {
                    hover.contents = convertContents(hover.contents);
                    return hover;
                }
            }
            return null;
        }
        function getTagNameRange(tokenType, startOffset) {
            const scanner = createScanner$1(document.getText(), startOffset);
            let token = scanner.scan();
            while (token !== TokenType$1.EOS && (scanner.getTokenEnd() < offset || scanner.getTokenEnd() === offset && token !== tokenType)) {
                token = scanner.scan();
            }
            if (token === tokenType && offset <= scanner.getTokenEnd()) {
                return { start: document.positionAt(scanner.getTokenOffset()), end: document.positionAt(scanner.getTokenEnd()) };
            }
            return null;
        }
        function getEntityRange() {
            let k = offset - 1;
            let characterStart = position.character;
            while (k >= 0 && isLetterOrDigit(text, k)) {
                k--;
                characterStart--;
            }
            let n = k + 1;
            let characterEnd = characterStart;
            while (isLetterOrDigit(text, n)) {
                n++;
                characterEnd++;
            }
            if (k >= 0 && text[k] === '&') {
                let range = null;
                if (text[n] === ';') {
                    range = Range$1.create(Position$1.create(position.line, characterStart), Position$1.create(position.line, characterEnd + 1));
                }
                else {
                    range = Range$1.create(Position$1.create(position.line, characterStart), Position$1.create(position.line, characterEnd));
                }
                return range;
            }
            return null;
        }
        function filterEntity(text) {
            let k = offset - 1;
            let newText = '&';
            while (k >= 0 && isLetterOrDigit(text, k)) {
                k--;
            }
            k = k + 1;
            while (isLetterOrDigit(text, k)) {
                newText += text[k];
                k += 1;
            }
            newText += ';';
            return newText;
        }
        if (node.endTagStart && offset >= node.endTagStart) {
            const tagRange = getTagNameRange(TokenType$1.EndTag, node.endTagStart);
            if (tagRange) {
                return getTagHover(node.tag, tagRange);
            }
            return null;
        }
        const tagRange = getTagNameRange(TokenType$1.StartTag, node.start);
        if (tagRange) {
            return getTagHover(node.tag, tagRange);
        }
        const attrRange = getTagNameRange(TokenType$1.AttributeName, node.start);
        if (attrRange) {
            const tag = node.tag;
            const attr = document.getText(attrRange);
            return getAttrHover(tag, attr, attrRange);
        }
        const entityRange = getEntityRange();
        if (entityRange) {
            return getEntityHover(text, entityRange);
        }
        function scanAttrAndAttrValue(nodeStart, attrValueStart) {
            const scanner = createScanner$1(document.getText(), nodeStart);
            let token = scanner.scan();
            let prevAttr = undefined;
            while (token !== TokenType$1.EOS && (scanner.getTokenEnd() <= attrValueStart)) {
                token = scanner.scan();
                if (token === TokenType$1.AttributeName) {
                    prevAttr = scanner.getTokenText();
                }
            }
            return prevAttr;
        }
        const attrValueRange = getTagNameRange(TokenType$1.AttributeValue, node.start);
        if (attrValueRange) {
            const tag = node.tag;
            const attrValue = trimQuotes(document.getText(attrValueRange));
            const matchAttr = scanAttrAndAttrValue(node.start, document.offsetAt(attrValueRange.start));
            if (matchAttr) {
                return getAttrValueHover(tag, matchAttr, attrValue, attrValueRange);
            }
        }
        return null;
    }
    convertContents(contents) {
        if (!this.doesSupportMarkdown()) {
            if (typeof contents === 'string') {
                return contents;
            }
            else if ('kind' in contents) {
                return {
                    kind: 'plaintext',
                    value: contents.value
                };
            }
            else if (Array.isArray(contents)) {
                contents.map(c => {
                    return typeof c === 'string' ? c : c.value;
                });
            }
            else {
                return contents.value;
            }
        }
        return contents;
    }
    doesSupportMarkdown() {
        if (!isDefined$1(this.supportsMarkdown)) {
            if (!isDefined$1(this.lsOptions.clientCapabilities)) {
                this.supportsMarkdown = true;
                return this.supportsMarkdown;
            }
            const contentFormat = this.lsOptions.clientCapabilities?.textDocument?.hover?.contentFormat;
            this.supportsMarkdown = Array.isArray(contentFormat) && contentFormat.indexOf(MarkupKind$1.Markdown) !== -1;
        }
        return this.supportsMarkdown;
    }
}
function trimQuotes(s) {
    if (s.length <= 1) {
        return s.replace(/['"]/, '');
    }
    if (s[0] === `'` || s[0] === `"`) {
        s = s.slice(1);
    }
    if (s[s.length - 1] === `'` || s[s.length - 1] === `"`) {
        s = s.slice(0, -1);
    }
    return s;
}

function js_beautify(js_source_text, options) {
    return js_source_text;
}

var legacy_beautify_css$1;
 (function() {
 	var __webpack_modules__ = ([
,
,
 (function(module) {
function OutputLine(parent) {
  this.__parent = parent;
  this.__character_count = 0;
  this.__indent_count = -1;
  this.__alignment_count = 0;
  this.__wrap_point_index = 0;
  this.__wrap_point_character_count = 0;
  this.__wrap_point_indent_count = -1;
  this.__wrap_point_alignment_count = 0;
  this.__items = [];
}
OutputLine.prototype.clone_empty = function() {
  var line = new OutputLine(this.__parent);
  line.set_indent(this.__indent_count, this.__alignment_count);
  return line;
};
OutputLine.prototype.item = function(index) {
  if (index < 0) {
    return this.__items[this.__items.length + index];
  } else {
    return this.__items[index];
  }
};
OutputLine.prototype.has_match = function(pattern) {
  for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
    if (this.__items[lastCheckedOutput].match(pattern)) {
      return true;
    }
  }
  return false;
};
OutputLine.prototype.set_indent = function(indent, alignment) {
  if (this.is_empty()) {
    this.__indent_count = indent || 0;
    this.__alignment_count = alignment || 0;
    this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
  }
};
OutputLine.prototype._set_wrap_point = function() {
  if (this.__parent.wrap_line_length) {
    this.__wrap_point_index = this.__items.length;
    this.__wrap_point_character_count = this.__character_count;
    this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
    this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
  }
};
OutputLine.prototype._should_wrap = function() {
  return this.__wrap_point_index &&
    this.__character_count > this.__parent.wrap_line_length &&
    this.__wrap_point_character_count > this.__parent.next_line.__character_count;
};
OutputLine.prototype._allow_wrap = function() {
  if (this._should_wrap()) {
    this.__parent.add_new_line();
    var next = this.__parent.current_line;
    next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
    next.__items = this.__items.slice(this.__wrap_point_index);
    this.__items = this.__items.slice(0, this.__wrap_point_index);
    next.__character_count += this.__character_count - this.__wrap_point_character_count;
    this.__character_count = this.__wrap_point_character_count;
    if (next.__items[0] === " ") {
      next.__items.splice(0, 1);
      next.__character_count -= 1;
    }
    return true;
  }
  return false;
};
OutputLine.prototype.is_empty = function() {
  return this.__items.length === 0;
};
OutputLine.prototype.last = function() {
  if (!this.is_empty()) {
    return this.__items[this.__items.length - 1];
  } else {
    return null;
  }
};
OutputLine.prototype.push = function(item) {
  this.__items.push(item);
  var last_newline_index = item.lastIndexOf('\n');
  if (last_newline_index !== -1) {
    this.__character_count = item.length - last_newline_index;
  } else {
    this.__character_count += item.length;
  }
};
OutputLine.prototype.pop = function() {
  var item = null;
  if (!this.is_empty()) {
    item = this.__items.pop();
    this.__character_count -= item.length;
  }
  return item;
};
OutputLine.prototype._remove_indent = function() {
  if (this.__indent_count > 0) {
    this.__indent_count -= 1;
    this.__character_count -= this.__parent.indent_size;
  }
};
OutputLine.prototype._remove_wrap_indent = function() {
  if (this.__wrap_point_indent_count > 0) {
    this.__wrap_point_indent_count -= 1;
  }
};
OutputLine.prototype.trim = function() {
  while (this.last() === ' ') {
    this.__items.pop();
    this.__character_count -= 1;
  }
};
OutputLine.prototype.toString = function() {
  var result = '';
  if (this.is_empty()) {
    if (this.__parent.indent_empty_lines) {
      result = this.__parent.get_indent_string(this.__indent_count);
    }
  } else {
    result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
    result += this.__items.join('');
  }
  return result;
};
function IndentStringCache(options, baseIndentString) {
  this.__cache = [''];
  this.__indent_size = options.indent_size;
  this.__indent_string = options.indent_char;
  if (!options.indent_with_tabs) {
    this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
  }
  baseIndentString = baseIndentString || '';
  if (options.indent_level > 0) {
    baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
  }
  this.__base_string = baseIndentString;
  this.__base_string_length = baseIndentString.length;
}
IndentStringCache.prototype.get_indent_size = function(indent, column) {
  var result = this.__base_string_length;
  column = column || 0;
  if (indent < 0) {
    result = 0;
  }
  result += indent * this.__indent_size;
  result += column;
  return result;
};
IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
  var result = this.__base_string;
  column = column || 0;
  if (indent_level < 0) {
    indent_level = 0;
    result = '';
  }
  column += indent_level * this.__indent_size;
  this.__ensure_cache(column);
  result += this.__cache[column];
  return result;
};
IndentStringCache.prototype.__ensure_cache = function(column) {
  while (column >= this.__cache.length) {
    this.__add_column();
  }
};
IndentStringCache.prototype.__add_column = function() {
  var column = this.__cache.length;
  var indent = 0;
  var result = '';
  if (this.__indent_size && column >= this.__indent_size) {
    indent = Math.floor(column / this.__indent_size);
    column -= indent * this.__indent_size;
    result = new Array(indent + 1).join(this.__indent_string);
  }
  if (column) {
    result += new Array(column + 1).join(' ');
  }
  this.__cache.push(result);
};
function Output(options, baseIndentString) {
  this.__indent_cache = new IndentStringCache(options, baseIndentString);
  this.raw = false;
  this._end_with_newline = options.end_with_newline;
  this.indent_size = options.indent_size;
  this.wrap_line_length = options.wrap_line_length;
  this.indent_empty_lines = options.indent_empty_lines;
  this.__lines = [];
  this.previous_line = null;
  this.current_line = null;
  this.next_line = new OutputLine(this);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
  this.__add_outputline();
}
Output.prototype.__add_outputline = function() {
  this.previous_line = this.current_line;
  this.current_line = this.next_line.clone_empty();
  this.__lines.push(this.current_line);
};
Output.prototype.get_line_number = function() {
  return this.__lines.length;
};
Output.prototype.get_indent_string = function(indent, column) {
  return this.__indent_cache.get_indent_string(indent, column);
};
Output.prototype.get_indent_size = function(indent, column) {
  return this.__indent_cache.get_indent_size(indent, column);
};
Output.prototype.is_empty = function() {
  return !this.previous_line && this.current_line.is_empty();
};
Output.prototype.add_new_line = function(force_newline) {
  if (this.is_empty() ||
    (!force_newline && this.just_added_newline())) {
    return false;
  }
  if (!this.raw) {
    this.__add_outputline();
  }
  return true;
};
Output.prototype.get_code = function(eol) {
  this.trim(true);
  var last_item = this.current_line.pop();
  if (last_item) {
    if (last_item[last_item.length - 1] === '\n') {
      last_item = last_item.replace(/\n+$/g, '');
    }
    this.current_line.push(last_item);
  }
  if (this._end_with_newline) {
    this.__add_outputline();
  }
  var sweet_code = this.__lines.join('\n');
  if (eol !== '\n') {
    sweet_code = sweet_code.replace(/[\n]/g, eol);
  }
  return sweet_code;
};
Output.prototype.set_wrap_point = function() {
  this.current_line._set_wrap_point();
};
Output.prototype.set_indent = function(indent, alignment) {
  indent = indent || 0;
  alignment = alignment || 0;
  this.next_line.set_indent(indent, alignment);
  if (this.__lines.length > 1) {
    this.current_line.set_indent(indent, alignment);
    return true;
  }
  this.current_line.set_indent();
  return false;
};
Output.prototype.add_raw_token = function(token) {
  for (var x = 0; x < token.newlines; x++) {
    this.__add_outputline();
  }
  this.current_line.set_indent(-1);
  this.current_line.push(token.whitespace_before);
  this.current_line.push(token.text);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
};
Output.prototype.add_token = function(printable_token) {
  this.__add_space_before_token();
  this.current_line.push(printable_token);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = this.current_line._allow_wrap();
};
Output.prototype.__add_space_before_token = function() {
  if (this.space_before_token && !this.just_added_newline()) {
    if (!this.non_breaking_space) {
      this.set_wrap_point();
    }
    this.current_line.push(' ');
  }
};
Output.prototype.remove_indent = function(index) {
  var output_length = this.__lines.length;
  while (index < output_length) {
    this.__lines[index]._remove_indent();
    index++;
  }
  this.current_line._remove_wrap_indent();
};
Output.prototype.trim = function(eat_newlines) {
  eat_newlines = (eat_newlines === undefined) ? false : eat_newlines;
  this.current_line.trim();
  while (eat_newlines && this.__lines.length > 1 &&
    this.current_line.is_empty()) {
    this.__lines.pop();
    this.current_line = this.__lines[this.__lines.length - 1];
    this.current_line.trim();
  }
  this.previous_line = this.__lines.length > 1 ?
    this.__lines[this.__lines.length - 2] : null;
};
Output.prototype.just_added_newline = function() {
  return this.current_line.is_empty();
};
Output.prototype.just_added_blankline = function() {
  return this.is_empty() ||
    (this.current_line.is_empty() && this.previous_line.is_empty());
};
Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
  var index = this.__lines.length - 2;
  while (index >= 0) {
    var potentialEmptyLine = this.__lines[index];
    if (potentialEmptyLine.is_empty()) {
      break;
    } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 &&
      potentialEmptyLine.item(-1) !== ends_with) {
      this.__lines.splice(index + 1, 0, new OutputLine(this));
      this.previous_line = this.__lines[this.__lines.length - 2];
      break;
    }
    index--;
  }
};
module.exports.Output = Output;
 }),
,
,
,
 (function(module) {
function Options(options, merge_child_field) {
  this.raw_options = _mergeOpts(options, merge_child_field);
  this.disabled = this._get_boolean('disabled');
  this.eol = this._get_characters('eol', 'auto');
  this.end_with_newline = this._get_boolean('end_with_newline');
  this.indent_size = this._get_number('indent_size', 4);
  this.indent_char = this._get_characters('indent_char', ' ');
  this.indent_level = this._get_number('indent_level');
  this.preserve_newlines = this._get_boolean('preserve_newlines', true);
  this.max_preserve_newlines = this._get_number('max_preserve_newlines', 32786);
  if (!this.preserve_newlines) {
    this.max_preserve_newlines = 0;
  }
  this.indent_with_tabs = this._get_boolean('indent_with_tabs', this.indent_char === '\t');
  if (this.indent_with_tabs) {
    this.indent_char = '\t';
    if (this.indent_size === 1) {
      this.indent_size = 4;
    }
  }
  this.wrap_line_length = this._get_number('wrap_line_length', this._get_number('max_char'));
  this.indent_empty_lines = this._get_boolean('indent_empty_lines');
  this.templating = this._get_selection_list('templating', ['auto', 'none', 'angular', 'django', 'erb', 'handlebars', 'php', 'smarty'], ['auto']);
}
Options.prototype._get_array = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || [];
  if (typeof option_value === 'object') {
    if (option_value !== null && typeof option_value.concat === 'function') {
      result = option_value.concat();
    }
  } else if (typeof option_value === 'string') {
    result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
  }
  return result;
};
Options.prototype._get_boolean = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = option_value === undefined ? !!default_value : !!option_value;
  return result;
};
Options.prototype._get_characters = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || '';
  if (typeof option_value === 'string') {
    result = option_value.replace(/\\r/, '\r').replace(/\\n/, '\n').replace(/\\t/, '\t');
  }
  return result;
};
Options.prototype._get_number = function(name, default_value) {
  var option_value = this.raw_options[name];
  default_value = parseInt(default_value, 10);
  if (isNaN(default_value)) {
    default_value = 0;
  }
  var result = parseInt(option_value, 10);
  if (isNaN(result)) {
    result = default_value;
  }
  return result;
};
Options.prototype._get_selection = function(name, selection_list, default_value) {
  var result = this._get_selection_list(name, selection_list, default_value);
  if (result.length !== 1) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }
  return result[0];
};
Options.prototype._get_selection_list = function(name, selection_list, default_value) {
  if (!selection_list || selection_list.length === 0) {
    throw new Error("Selection list cannot be empty.");
  }
  default_value = default_value || [selection_list[0]];
  if (!this._is_valid_selection(default_value, selection_list)) {
    throw new Error("Invalid Default Value!");
  }
  var result = this._get_array(name, default_value);
  if (!this._is_valid_selection(result, selection_list)) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }
  return result;
};
Options.prototype._is_valid_selection = function(result, selection_list) {
  return result.length && selection_list.length &&
    !result.some(function(item) { return selection_list.indexOf(item) === -1; });
};
function _mergeOpts(allOptions, childFieldName) {
  var finalOpts = {};
  allOptions = _normalizeOpts(allOptions);
  var name;
  for (name in allOptions) {
    if (name !== childFieldName) {
      finalOpts[name] = allOptions[name];
    }
  }
  if (childFieldName && allOptions[childFieldName]) {
    for (name in allOptions[childFieldName]) {
      finalOpts[name] = allOptions[childFieldName][name];
    }
  }
  return finalOpts;
}
function _normalizeOpts(options) {
  var convertedOpts = {};
  var key;
  for (key in options) {
    var newKey = key.replace(/-/g, "_");
    convertedOpts[newKey] = options[key];
  }
  return convertedOpts;
}
module.exports.Options = Options;
module.exports.normalizeOpts = _normalizeOpts;
module.exports.mergeOpts = _mergeOpts;
 }),
,
 (function(module) {
var regexp_has_sticky = RegExp.prototype.hasOwnProperty('sticky');
function InputScanner(input_string) {
  this.__input = input_string || '';
  this.__input_length = this.__input.length;
  this.__position = 0;
}
InputScanner.prototype.restart = function() {
  this.__position = 0;
};
InputScanner.prototype.back = function() {
  if (this.__position > 0) {
    this.__position -= 1;
  }
};
InputScanner.prototype.hasNext = function() {
  return this.__position < this.__input_length;
};
InputScanner.prototype.next = function() {
  var val = null;
  if (this.hasNext()) {
    val = this.__input.charAt(this.__position);
    this.__position += 1;
  }
  return val;
};
InputScanner.prototype.peek = function(index) {
  var val = null;
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__input_length) {
    val = this.__input.charAt(index);
  }
  return val;
};
InputScanner.prototype.__match = function(pattern, index) {
  pattern.lastIndex = index;
  var pattern_match = pattern.exec(this.__input);
  if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
    if (pattern_match.index !== index) {
      pattern_match = null;
    }
  }
  return pattern_match;
};
InputScanner.prototype.test = function(pattern, index) {
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__input_length) {
    return !!this.__match(pattern, index);
  } else {
    return false;
  }
};
InputScanner.prototype.testChar = function(pattern, index) {
  var val = this.peek(index);
  pattern.lastIndex = 0;
  return val !== null && pattern.test(val);
};
InputScanner.prototype.match = function(pattern) {
  var pattern_match = this.__match(pattern, this.__position);
  if (pattern_match) {
    this.__position += pattern_match[0].length;
  } else {
    pattern_match = null;
  }
  return pattern_match;
};
InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
  var val = '';
  var match;
  if (starting_pattern) {
    match = this.match(starting_pattern);
    if (match) {
      val += match[0];
    }
  }
  if (until_pattern && (match || !starting_pattern)) {
    val += this.readUntil(until_pattern, until_after);
  }
  return val;
};
InputScanner.prototype.readUntil = function(pattern, until_after) {
  var val = '';
  var match_index = this.__position;
  pattern.lastIndex = this.__position;
  var pattern_match = pattern.exec(this.__input);
  if (pattern_match) {
    match_index = pattern_match.index;
    if (until_after) {
      match_index += pattern_match[0].length;
    }
  } else {
    match_index = this.__input_length;
  }
  val = this.__input.substring(this.__position, match_index);
  this.__position = match_index;
  return val;
};
InputScanner.prototype.readUntilAfter = function(pattern) {
  return this.readUntil(pattern, true);
};
InputScanner.prototype.get_regexp = function(pattern, match_from) {
  var result = null;
  var flags = 'g';
  if (match_from && regexp_has_sticky) {
    flags = 'y';
  }
  if (typeof pattern === "string" && pattern !== '') {
    result = new RegExp(pattern, flags);
  } else if (pattern) {
    result = new RegExp(pattern.source, flags);
  }
  return result;
};
InputScanner.prototype.get_literal_regexp = function(literal_string) {
  return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
};
InputScanner.prototype.peekUntilAfter = function(pattern) {
  var start = this.__position;
  var val = this.readUntilAfter(pattern);
  this.__position = start;
  return val;
};
InputScanner.prototype.lookBack = function(testVal) {
  var start = this.__position - 1;
  return start >= testVal.length && this.__input.substring(start - testVal.length, start)
    .toLowerCase() === testVal;
};
module.exports.InputScanner = InputScanner;
 }),
,
,
,
,
 (function(module) {
function Directives(start_block_pattern, end_block_pattern) {
  start_block_pattern = typeof start_block_pattern === 'string' ? start_block_pattern : start_block_pattern.source;
  end_block_pattern = typeof end_block_pattern === 'string' ? end_block_pattern : end_block_pattern.source;
  this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, 'g');
  this.__directive_pattern = / (\w+)[:](\w+)/g;
  this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, 'g');
}
Directives.prototype.get_directives = function(text) {
  if (!text.match(this.__directives_block_pattern)) {
    return null;
  }
  var directives = {};
  this.__directive_pattern.lastIndex = 0;
  var directive_match = this.__directive_pattern.exec(text);
  while (directive_match) {
    directives[directive_match[1]] = directive_match[2];
    directive_match = this.__directive_pattern.exec(text);
  }
  return directives;
};
Directives.prototype.readIgnored = function(input) {
  return input.readUntilAfter(this.__directives_end_ignore_pattern);
};
module.exports.Directives = Directives;
 }),
,
 (function(module, __unused_webpack_exports, __webpack_require__) {
var Beautifier = (__webpack_require__(16).Beautifier),
  Options = (__webpack_require__(17).Options);
function css_beautify(source_text, options) {
  var beautifier = new Beautifier(source_text, options);
  return beautifier.beautify();
}
module.exports = css_beautify;
module.exports.defaultOptions = function() {
  return new Options();
};
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var Options = (__webpack_require__(17).Options);
var Output = (__webpack_require__(2).Output);
var InputScanner = (__webpack_require__(8).InputScanner);
var Directives = (__webpack_require__(13).Directives);
var directives_core = new Directives(/\/\*/, /\*\//);
var lineBreak = /\r\n|[\r\n]/;
var allLineBreaks = /\r\n|[\r\n]/g;
var whitespaceChar = /\s/;
var whitespacePattern = /(?:\s|\n)+/g;
var block_comment_pattern = /\/\*(?:[\s\S]*?)((?:\*\/)|$)/g;
var comment_pattern = /\/\/(?:[^\n\r\u2028\u2029]*)/g;
function Beautifier(source_text, options) {
  this._source_text = source_text || '';
  this._options = new Options(options);
  this._ch = null;
  this._input = null;
  this.NESTED_AT_RULE = {
    "page": true,
    "font-face": true,
    "keyframes": true,
    "media": true,
    "supports": true,
    "document": true
  };
  this.CONDITIONAL_GROUP_RULE = {
    "media": true,
    "supports": true,
    "document": true
  };
  this.NON_SEMICOLON_NEWLINE_PROPERTY = [
    "grid-template-areas",
    "grid-template"
  ];
}
Beautifier.prototype.eatString = function(endChars) {
  var result = '';
  this._ch = this._input.next();
  while (this._ch) {
    result += this._ch;
    if (this._ch === "\\") {
      result += this._input.next();
    } else if (endChars.indexOf(this._ch) !== -1 || this._ch === "\n") {
      break;
    }
    this._ch = this._input.next();
  }
  return result;
};
Beautifier.prototype.eatWhitespace = function(allowAtLeastOneNewLine) {
  var result = whitespaceChar.test(this._input.peek());
  var newline_count = 0;
  while (whitespaceChar.test(this._input.peek())) {
    this._ch = this._input.next();
    if (allowAtLeastOneNewLine && this._ch === '\n') {
      if (newline_count === 0 || newline_count < this._options.max_preserve_newlines) {
        newline_count++;
        this._output.add_new_line(true);
      }
    }
  }
  return result;
};
Beautifier.prototype.foundNestedPseudoClass = function() {
  var openParen = 0;
  var i = 1;
  var ch = this._input.peek(i);
  while (ch) {
    if (ch === "{") {
      return true;
    } else if (ch === '(') {
      openParen += 1;
    } else if (ch === ')') {
      if (openParen === 0) {
        return false;
      }
      openParen -= 1;
    } else if (ch === ";" || ch === "}") {
      return false;
    }
    i++;
    ch = this._input.peek(i);
  }
  return false;
};
Beautifier.prototype.print_string = function(output_string) {
  this._output.set_indent(this._indentLevel);
  this._output.non_breaking_space = true;
  this._output.add_token(output_string);
};
Beautifier.prototype.preserveSingleSpace = function(isAfterSpace) {
  if (isAfterSpace) {
    this._output.space_before_token = true;
  }
};
Beautifier.prototype.indent = function() {
  this._indentLevel++;
};
Beautifier.prototype.outdent = function() {
  if (this._indentLevel > 0) {
    this._indentLevel--;
  }
};
Beautifier.prototype.beautify = function() {
  if (this._options.disabled) {
    return this._source_text;
  }
  var source_text = this._source_text;
  var eol = this._options.eol;
  if (eol === 'auto') {
    eol = '\n';
    if (source_text && lineBreak.test(source_text || '')) {
      eol = source_text.match(lineBreak)[0];
    }
  }
  source_text = source_text.replace(allLineBreaks, '\n');
  var baseIndentString = source_text.match(/^[\t ]*/)[0];
  this._output = new Output(this._options, baseIndentString);
  this._input = new InputScanner(source_text);
  this._indentLevel = 0;
  this._nestedLevel = 0;
  this._ch = null;
  var parenLevel = 0;
  var insideRule = false;
  var insidePropertyValue = false;
  var enteringConditionalGroup = false;
  var insideNonNestedAtRule = false;
  var insideScssMap = false;
  var topCharacter = this._ch;
  var insideNonSemiColonValues = false;
  var whitespace;
  var isAfterSpace;
  var previous_ch;
  while (true) {
    whitespace = this._input.read(whitespacePattern);
    isAfterSpace = whitespace !== '';
    previous_ch = topCharacter;
    this._ch = this._input.next();
    if (this._ch === '\\' && this._input.hasNext()) {
      this._ch += this._input.next();
    }
    topCharacter = this._ch;
    if (!this._ch) {
      break;
    } else if (this._ch === '/' && this._input.peek() === '*') {
      this._output.add_new_line();
      this._input.back();
      var comment = this._input.read(block_comment_pattern);
      var directives = directives_core.get_directives(comment);
      if (directives && directives.ignore === 'start') {
        comment += directives_core.readIgnored(this._input);
      }
      this.print_string(comment);
      this.eatWhitespace(true);
      this._output.add_new_line();
    } else if (this._ch === '/' && this._input.peek() === '/') {
      this._output.space_before_token = true;
      this._input.back();
      this.print_string(this._input.read(comment_pattern));
      this.eatWhitespace(true);
    } else if (this._ch === '$') {
      this.preserveSingleSpace(isAfterSpace);
      this.print_string(this._ch);
      var variable = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
      if (variable.match(/[ :]$/)) {
        variable = this.eatString(": ").replace(/\s+$/, '');
        this.print_string(variable);
        this._output.space_before_token = true;
      }
      if (parenLevel === 0 && variable.indexOf(':') !== -1) {
        insidePropertyValue = true;
        this.indent();
      }
    } else if (this._ch === '@') {
      this.preserveSingleSpace(isAfterSpace);
      if (this._input.peek() === '{') {
        this.print_string(this._ch + this.eatString('}'));
      } else {
        this.print_string(this._ch);
        var variableOrRule = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
        if (variableOrRule.match(/[ :]$/)) {
          variableOrRule = this.eatString(": ").replace(/\s+$/, '');
          this.print_string(variableOrRule);
          this._output.space_before_token = true;
        }
        if (parenLevel === 0 && variableOrRule.indexOf(':') !== -1) {
          insidePropertyValue = true;
          this.indent();
        } else if (variableOrRule in this.NESTED_AT_RULE) {
          this._nestedLevel += 1;
          if (variableOrRule in this.CONDITIONAL_GROUP_RULE) {
            enteringConditionalGroup = true;
          }
        } else if (parenLevel === 0 && !insidePropertyValue) {
          insideNonNestedAtRule = true;
        }
      }
    } else if (this._ch === '#' && this._input.peek() === '{') {
      this.preserveSingleSpace(isAfterSpace);
      this.print_string(this._ch + this.eatString('}'));
    } else if (this._ch === '{') {
      if (insidePropertyValue) {
        insidePropertyValue = false;
        this.outdent();
      }
      insideNonNestedAtRule = false;
      if (enteringConditionalGroup) {
        enteringConditionalGroup = false;
        insideRule = (this._indentLevel >= this._nestedLevel);
      } else {
        insideRule = (this._indentLevel >= this._nestedLevel - 1);
      }
      if (this._options.newline_between_rules && insideRule) {
        if (this._output.previous_line && this._output.previous_line.item(-1) !== '{') {
          this._output.ensure_empty_line_above('/', ',');
        }
      }
      this._output.space_before_token = true;
      if (this._options.brace_style === 'expand') {
        this._output.add_new_line();
        this.print_string(this._ch);
        this.indent();
        this._output.set_indent(this._indentLevel);
      } else {
        if (previous_ch === '(') {
          this._output.space_before_token = false;
        } else if (previous_ch !== ',') {
          this.indent();
        }
        this.print_string(this._ch);
      }
      this.eatWhitespace(true);
      this._output.add_new_line();
    } else if (this._ch === '}') {
      this.outdent();
      this._output.add_new_line();
      if (previous_ch === '{') {
        this._output.trim(true);
      }
      if (insidePropertyValue) {
        this.outdent();
        insidePropertyValue = false;
      }
      this.print_string(this._ch);
      insideRule = false;
      if (this._nestedLevel) {
        this._nestedLevel--;
      }
      this.eatWhitespace(true);
      this._output.add_new_line();
      if (this._options.newline_between_rules && !this._output.just_added_blankline()) {
        if (this._input.peek() !== '}') {
          this._output.add_new_line(true);
        }
      }
      if (this._input.peek() === ')') {
        this._output.trim(true);
        if (this._options.brace_style === "expand") {
          this._output.add_new_line(true);
        }
      }
    } else if (this._ch === ":") {
      for (var i = 0; i < this.NON_SEMICOLON_NEWLINE_PROPERTY.length; i++) {
        if (this._input.lookBack(this.NON_SEMICOLON_NEWLINE_PROPERTY[i])) {
          insideNonSemiColonValues = true;
          break;
        }
      }
      if ((insideRule || enteringConditionalGroup) && !(this._input.lookBack("&") || this.foundNestedPseudoClass()) && !this._input.lookBack("(") && !insideNonNestedAtRule && parenLevel === 0) {
        this.print_string(':');
        if (!insidePropertyValue) {
          insidePropertyValue = true;
          this._output.space_before_token = true;
          this.eatWhitespace(true);
          this.indent();
        }
      } else {
        if (this._input.lookBack(" ")) {
          this._output.space_before_token = true;
        }
        if (this._input.peek() === ":") {
          this._ch = this._input.next();
          this.print_string("::");
        } else {
          this.print_string(':');
        }
      }
    } else if (this._ch === '"' || this._ch === '\'') {
      var preserveQuoteSpace = previous_ch === '"' || previous_ch === '\'';
      this.preserveSingleSpace(preserveQuoteSpace || isAfterSpace);
      this.print_string(this._ch + this.eatString(this._ch));
      this.eatWhitespace(true);
    } else if (this._ch === ';') {
      insideNonSemiColonValues = false;
      if (parenLevel === 0) {
        if (insidePropertyValue) {
          this.outdent();
          insidePropertyValue = false;
        }
        insideNonNestedAtRule = false;
        this.print_string(this._ch);
        this.eatWhitespace(true);
        if (this._input.peek() !== '/') {
          this._output.add_new_line();
        }
      } else {
        this.print_string(this._ch);
        this.eatWhitespace(true);
        this._output.space_before_token = true;
      }
    } else if (this._ch === '(') {
      if (this._input.lookBack("url")) {
        this.print_string(this._ch);
        this.eatWhitespace();
        parenLevel++;
        this.indent();
        this._ch = this._input.next();
        if (this._ch === ')' || this._ch === '"' || this._ch === '\'') {
          this._input.back();
        } else if (this._ch) {
          this.print_string(this._ch + this.eatString(')'));
          if (parenLevel) {
            parenLevel--;
            this.outdent();
          }
        }
      } else {
        var space_needed = false;
        if (this._input.lookBack("with")) {
          space_needed = true;
        }
        this.preserveSingleSpace(isAfterSpace || space_needed);
        this.print_string(this._ch);
        if (insidePropertyValue && previous_ch === "$" && this._options.selector_separator_newline) {
          this._output.add_new_line();
          insideScssMap = true;
        } else {
          this.eatWhitespace();
          parenLevel++;
          this.indent();
        }
      }
    } else if (this._ch === ')') {
      if (parenLevel) {
        parenLevel--;
        this.outdent();
      }
      if (insideScssMap && this._input.peek() === ";" && this._options.selector_separator_newline) {
        insideScssMap = false;
        this.outdent();
        this._output.add_new_line();
      }
      this.print_string(this._ch);
    } else if (this._ch === ',') {
      this.print_string(this._ch);
      this.eatWhitespace(true);
      if (this._options.selector_separator_newline && (!insidePropertyValue || insideScssMap) && parenLevel === 0 && !insideNonNestedAtRule) {
        this._output.add_new_line();
      } else {
        this._output.space_before_token = true;
      }
    } else if ((this._ch === '>' || this._ch === '+' || this._ch === '~') && !insidePropertyValue && parenLevel === 0) {
      if (this._options.space_around_combinator) {
        this._output.space_before_token = true;
        this.print_string(this._ch);
        this._output.space_before_token = true;
      } else {
        this.print_string(this._ch);
        this.eatWhitespace();
        if (this._ch && whitespaceChar.test(this._ch)) {
          this._ch = '';
        }
      }
    } else if (this._ch === ']') {
      this.print_string(this._ch);
    } else if (this._ch === '[') {
      this.preserveSingleSpace(isAfterSpace);
      this.print_string(this._ch);
    } else if (this._ch === '=') {
      this.eatWhitespace();
      this.print_string('=');
      if (whitespaceChar.test(this._ch)) {
        this._ch = '';
      }
    } else if (this._ch === '!' && !this._input.lookBack("\\")) {
      this._output.space_before_token = true;
      this.print_string(this._ch);
    } else {
      var preserveAfterSpace = previous_ch === '"' || previous_ch === '\'';
      this.preserveSingleSpace(preserveAfterSpace || isAfterSpace);
      this.print_string(this._ch);
      if (!this._output.just_added_newline() && this._input.peek() === '\n' && insideNonSemiColonValues) {
        this._output.add_new_line();
      }
    }
  }
  var sweetCode = this._output.get_code(eol);
  return sweetCode;
};
module.exports.Beautifier = Beautifier;
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var BaseOptions = (__webpack_require__(6).Options);
function Options(options) {
  BaseOptions.call(this, options, 'css');
  this.selector_separator_newline = this._get_boolean('selector_separator_newline', true);
  this.newline_between_rules = this._get_boolean('newline_between_rules', true);
  var space_around_selector_separator = this._get_boolean('space_around_selector_separator');
  this.space_around_combinator = this._get_boolean('space_around_combinator') || space_around_selector_separator;
  var brace_style_split = this._get_selection_list('brace_style', ['collapse', 'expand', 'end-expand', 'none', 'preserve-inline']);
  this.brace_style = 'collapse';
  for (var bs = 0; bs < brace_style_split.length; bs++) {
    if (brace_style_split[bs] !== 'expand') {
      this.brace_style = 'collapse';
    } else {
      this.brace_style = brace_style_split[bs];
    }
  }
}
Options.prototype = new BaseOptions();
module.exports.Options = Options;
 })
 	]);
 	var __webpack_module_cache__ = {};
 	function __webpack_require__(moduleId) {
 		var cachedModule = __webpack_module_cache__[moduleId];
 		if (cachedModule !== undefined) {
 			return cachedModule.exports;
 		}
 		var module = __webpack_module_cache__[moduleId] = {
 			exports: {}
 		};
 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
 		return module.exports;
 	}
 	var __webpack_exports__ = __webpack_require__(15);
 	legacy_beautify_css$1 = __webpack_exports__;
 })()
;
var css_beautify$1 = legacy_beautify_css$1;

var legacy_beautify_html;
 (function() {
 	var __webpack_modules__ = ([
,
,
 (function(module) {
function OutputLine(parent) {
  this.__parent = parent;
  this.__character_count = 0;
  this.__indent_count = -1;
  this.__alignment_count = 0;
  this.__wrap_point_index = 0;
  this.__wrap_point_character_count = 0;
  this.__wrap_point_indent_count = -1;
  this.__wrap_point_alignment_count = 0;
  this.__items = [];
}
OutputLine.prototype.clone_empty = function() {
  var line = new OutputLine(this.__parent);
  line.set_indent(this.__indent_count, this.__alignment_count);
  return line;
};
OutputLine.prototype.item = function(index) {
  if (index < 0) {
    return this.__items[this.__items.length + index];
  } else {
    return this.__items[index];
  }
};
OutputLine.prototype.has_match = function(pattern) {
  for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
    if (this.__items[lastCheckedOutput].match(pattern)) {
      return true;
    }
  }
  return false;
};
OutputLine.prototype.set_indent = function(indent, alignment) {
  if (this.is_empty()) {
    this.__indent_count = indent || 0;
    this.__alignment_count = alignment || 0;
    this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
  }
};
OutputLine.prototype._set_wrap_point = function() {
  if (this.__parent.wrap_line_length) {
    this.__wrap_point_index = this.__items.length;
    this.__wrap_point_character_count = this.__character_count;
    this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
    this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
  }
};
OutputLine.prototype._should_wrap = function() {
  return this.__wrap_point_index &&
    this.__character_count > this.__parent.wrap_line_length &&
    this.__wrap_point_character_count > this.__parent.next_line.__character_count;
};
OutputLine.prototype._allow_wrap = function() {
  if (this._should_wrap()) {
    this.__parent.add_new_line();
    var next = this.__parent.current_line;
    next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
    next.__items = this.__items.slice(this.__wrap_point_index);
    this.__items = this.__items.slice(0, this.__wrap_point_index);
    next.__character_count += this.__character_count - this.__wrap_point_character_count;
    this.__character_count = this.__wrap_point_character_count;
    if (next.__items[0] === " ") {
      next.__items.splice(0, 1);
      next.__character_count -= 1;
    }
    return true;
  }
  return false;
};
OutputLine.prototype.is_empty = function() {
  return this.__items.length === 0;
};
OutputLine.prototype.last = function() {
  if (!this.is_empty()) {
    return this.__items[this.__items.length - 1];
  } else {
    return null;
  }
};
OutputLine.prototype.push = function(item) {
  this.__items.push(item);
  var last_newline_index = item.lastIndexOf('\n');
  if (last_newline_index !== -1) {
    this.__character_count = item.length - last_newline_index;
  } else {
    this.__character_count += item.length;
  }
};
OutputLine.prototype.pop = function() {
  var item = null;
  if (!this.is_empty()) {
    item = this.__items.pop();
    this.__character_count -= item.length;
  }
  return item;
};
OutputLine.prototype._remove_indent = function() {
  if (this.__indent_count > 0) {
    this.__indent_count -= 1;
    this.__character_count -= this.__parent.indent_size;
  }
};
OutputLine.prototype._remove_wrap_indent = function() {
  if (this.__wrap_point_indent_count > 0) {
    this.__wrap_point_indent_count -= 1;
  }
};
OutputLine.prototype.trim = function() {
  while (this.last() === ' ') {
    this.__items.pop();
    this.__character_count -= 1;
  }
};
OutputLine.prototype.toString = function() {
  var result = '';
  if (this.is_empty()) {
    if (this.__parent.indent_empty_lines) {
      result = this.__parent.get_indent_string(this.__indent_count);
    }
  } else {
    result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
    result += this.__items.join('');
  }
  return result;
};
function IndentStringCache(options, baseIndentString) {
  this.__cache = [''];
  this.__indent_size = options.indent_size;
  this.__indent_string = options.indent_char;
  if (!options.indent_with_tabs) {
    this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
  }
  baseIndentString = baseIndentString || '';
  if (options.indent_level > 0) {
    baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
  }
  this.__base_string = baseIndentString;
  this.__base_string_length = baseIndentString.length;
}
IndentStringCache.prototype.get_indent_size = function(indent, column) {
  var result = this.__base_string_length;
  column = column || 0;
  if (indent < 0) {
    result = 0;
  }
  result += indent * this.__indent_size;
  result += column;
  return result;
};
IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
  var result = this.__base_string;
  column = column || 0;
  if (indent_level < 0) {
    indent_level = 0;
    result = '';
  }
  column += indent_level * this.__indent_size;
  this.__ensure_cache(column);
  result += this.__cache[column];
  return result;
};
IndentStringCache.prototype.__ensure_cache = function(column) {
  while (column >= this.__cache.length) {
    this.__add_column();
  }
};
IndentStringCache.prototype.__add_column = function() {
  var column = this.__cache.length;
  var indent = 0;
  var result = '';
  if (this.__indent_size && column >= this.__indent_size) {
    indent = Math.floor(column / this.__indent_size);
    column -= indent * this.__indent_size;
    result = new Array(indent + 1).join(this.__indent_string);
  }
  if (column) {
    result += new Array(column + 1).join(' ');
  }
  this.__cache.push(result);
};
function Output(options, baseIndentString) {
  this.__indent_cache = new IndentStringCache(options, baseIndentString);
  this.raw = false;
  this._end_with_newline = options.end_with_newline;
  this.indent_size = options.indent_size;
  this.wrap_line_length = options.wrap_line_length;
  this.indent_empty_lines = options.indent_empty_lines;
  this.__lines = [];
  this.previous_line = null;
  this.current_line = null;
  this.next_line = new OutputLine(this);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
  this.__add_outputline();
}
Output.prototype.__add_outputline = function() {
  this.previous_line = this.current_line;
  this.current_line = this.next_line.clone_empty();
  this.__lines.push(this.current_line);
};
Output.prototype.get_line_number = function() {
  return this.__lines.length;
};
Output.prototype.get_indent_string = function(indent, column) {
  return this.__indent_cache.get_indent_string(indent, column);
};
Output.prototype.get_indent_size = function(indent, column) {
  return this.__indent_cache.get_indent_size(indent, column);
};
Output.prototype.is_empty = function() {
  return !this.previous_line && this.current_line.is_empty();
};
Output.prototype.add_new_line = function(force_newline) {
  if (this.is_empty() ||
    (!force_newline && this.just_added_newline())) {
    return false;
  }
  if (!this.raw) {
    this.__add_outputline();
  }
  return true;
};
Output.prototype.get_code = function(eol) {
  this.trim(true);
  var last_item = this.current_line.pop();
  if (last_item) {
    if (last_item[last_item.length - 1] === '\n') {
      last_item = last_item.replace(/\n+$/g, '');
    }
    this.current_line.push(last_item);
  }
  if (this._end_with_newline) {
    this.__add_outputline();
  }
  var sweet_code = this.__lines.join('\n');
  if (eol !== '\n') {
    sweet_code = sweet_code.replace(/[\n]/g, eol);
  }
  return sweet_code;
};
Output.prototype.set_wrap_point = function() {
  this.current_line._set_wrap_point();
};
Output.prototype.set_indent = function(indent, alignment) {
  indent = indent || 0;
  alignment = alignment || 0;
  this.next_line.set_indent(indent, alignment);
  if (this.__lines.length > 1) {
    this.current_line.set_indent(indent, alignment);
    return true;
  }
  this.current_line.set_indent();
  return false;
};
Output.prototype.add_raw_token = function(token) {
  for (var x = 0; x < token.newlines; x++) {
    this.__add_outputline();
  }
  this.current_line.set_indent(-1);
  this.current_line.push(token.whitespace_before);
  this.current_line.push(token.text);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
};
Output.prototype.add_token = function(printable_token) {
  this.__add_space_before_token();
  this.current_line.push(printable_token);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = this.current_line._allow_wrap();
};
Output.prototype.__add_space_before_token = function() {
  if (this.space_before_token && !this.just_added_newline()) {
    if (!this.non_breaking_space) {
      this.set_wrap_point();
    }
    this.current_line.push(' ');
  }
};
Output.prototype.remove_indent = function(index) {
  var output_length = this.__lines.length;
  while (index < output_length) {
    this.__lines[index]._remove_indent();
    index++;
  }
  this.current_line._remove_wrap_indent();
};
Output.prototype.trim = function(eat_newlines) {
  eat_newlines = (eat_newlines === undefined) ? false : eat_newlines;
  this.current_line.trim();
  while (eat_newlines && this.__lines.length > 1 &&
    this.current_line.is_empty()) {
    this.__lines.pop();
    this.current_line = this.__lines[this.__lines.length - 1];
    this.current_line.trim();
  }
  this.previous_line = this.__lines.length > 1 ?
    this.__lines[this.__lines.length - 2] : null;
};
Output.prototype.just_added_newline = function() {
  return this.current_line.is_empty();
};
Output.prototype.just_added_blankline = function() {
  return this.is_empty() ||
    (this.current_line.is_empty() && this.previous_line.is_empty());
};
Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
  var index = this.__lines.length - 2;
  while (index >= 0) {
    var potentialEmptyLine = this.__lines[index];
    if (potentialEmptyLine.is_empty()) {
      break;
    } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 &&
      potentialEmptyLine.item(-1) !== ends_with) {
      this.__lines.splice(index + 1, 0, new OutputLine(this));
      this.previous_line = this.__lines[this.__lines.length - 2];
      break;
    }
    index--;
  }
};
module.exports.Output = Output;
 }),
 (function(module) {
function Token(type, text, newlines, whitespace_before) {
  this.type = type;
  this.text = text;
  this.comments_before = null;
  this.newlines = newlines || 0;
  this.whitespace_before = whitespace_before || '';
  this.parent = null;
  this.next = null;
  this.previous = null;
  this.opened = null;
  this.closed = null;
  this.directives = null;
}
module.exports.Token = Token;
 }),
,
,
 (function(module) {
function Options(options, merge_child_field) {
  this.raw_options = _mergeOpts(options, merge_child_field);
  this.disabled = this._get_boolean('disabled');
  this.eol = this._get_characters('eol', 'auto');
  this.end_with_newline = this._get_boolean('end_with_newline');
  this.indent_size = this._get_number('indent_size', 4);
  this.indent_char = this._get_characters('indent_char', ' ');
  this.indent_level = this._get_number('indent_level');
  this.preserve_newlines = this._get_boolean('preserve_newlines', true);
  this.max_preserve_newlines = this._get_number('max_preserve_newlines', 32786);
  if (!this.preserve_newlines) {
    this.max_preserve_newlines = 0;
  }
  this.indent_with_tabs = this._get_boolean('indent_with_tabs', this.indent_char === '\t');
  if (this.indent_with_tabs) {
    this.indent_char = '\t';
    if (this.indent_size === 1) {
      this.indent_size = 4;
    }
  }
  this.wrap_line_length = this._get_number('wrap_line_length', this._get_number('max_char'));
  this.indent_empty_lines = this._get_boolean('indent_empty_lines');
  this.templating = this._get_selection_list('templating', ['auto', 'none', 'angular', 'django', 'erb', 'handlebars', 'php', 'smarty'], ['auto']);
}
Options.prototype._get_array = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || [];
  if (typeof option_value === 'object') {
    if (option_value !== null && typeof option_value.concat === 'function') {
      result = option_value.concat();
    }
  } else if (typeof option_value === 'string') {
    result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
  }
  return result;
};
Options.prototype._get_boolean = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = option_value === undefined ? !!default_value : !!option_value;
  return result;
};
Options.prototype._get_characters = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || '';
  if (typeof option_value === 'string') {
    result = option_value.replace(/\\r/, '\r').replace(/\\n/, '\n').replace(/\\t/, '\t');
  }
  return result;
};
Options.prototype._get_number = function(name, default_value) {
  var option_value = this.raw_options[name];
  default_value = parseInt(default_value, 10);
  if (isNaN(default_value)) {
    default_value = 0;
  }
  var result = parseInt(option_value, 10);
  if (isNaN(result)) {
    result = default_value;
  }
  return result;
};
Options.prototype._get_selection = function(name, selection_list, default_value) {
  var result = this._get_selection_list(name, selection_list, default_value);
  if (result.length !== 1) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }
  return result[0];
};
Options.prototype._get_selection_list = function(name, selection_list, default_value) {
  if (!selection_list || selection_list.length === 0) {
    throw new Error("Selection list cannot be empty.");
  }
  default_value = default_value || [selection_list[0]];
  if (!this._is_valid_selection(default_value, selection_list)) {
    throw new Error("Invalid Default Value!");
  }
  var result = this._get_array(name, default_value);
  if (!this._is_valid_selection(result, selection_list)) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }
  return result;
};
Options.prototype._is_valid_selection = function(result, selection_list) {
  return result.length && selection_list.length &&
    !result.some(function(item) { return selection_list.indexOf(item) === -1; });
};
function _mergeOpts(allOptions, childFieldName) {
  var finalOpts = {};
  allOptions = _normalizeOpts(allOptions);
  var name;
  for (name in allOptions) {
    if (name !== childFieldName) {
      finalOpts[name] = allOptions[name];
    }
  }
  if (childFieldName && allOptions[childFieldName]) {
    for (name in allOptions[childFieldName]) {
      finalOpts[name] = allOptions[childFieldName][name];
    }
  }
  return finalOpts;
}
function _normalizeOpts(options) {
  var convertedOpts = {};
  var key;
  for (key in options) {
    var newKey = key.replace(/-/g, "_");
    convertedOpts[newKey] = options[key];
  }
  return convertedOpts;
}
module.exports.Options = Options;
module.exports.normalizeOpts = _normalizeOpts;
module.exports.mergeOpts = _mergeOpts;
 }),
,
 (function(module) {
var regexp_has_sticky = RegExp.prototype.hasOwnProperty('sticky');
function InputScanner(input_string) {
  this.__input = input_string || '';
  this.__input_length = this.__input.length;
  this.__position = 0;
}
InputScanner.prototype.restart = function() {
  this.__position = 0;
};
InputScanner.prototype.back = function() {
  if (this.__position > 0) {
    this.__position -= 1;
  }
};
InputScanner.prototype.hasNext = function() {
  return this.__position < this.__input_length;
};
InputScanner.prototype.next = function() {
  var val = null;
  if (this.hasNext()) {
    val = this.__input.charAt(this.__position);
    this.__position += 1;
  }
  return val;
};
InputScanner.prototype.peek = function(index) {
  var val = null;
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__input_length) {
    val = this.__input.charAt(index);
  }
  return val;
};
InputScanner.prototype.__match = function(pattern, index) {
  pattern.lastIndex = index;
  var pattern_match = pattern.exec(this.__input);
  if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
    if (pattern_match.index !== index) {
      pattern_match = null;
    }
  }
  return pattern_match;
};
InputScanner.prototype.test = function(pattern, index) {
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__input_length) {
    return !!this.__match(pattern, index);
  } else {
    return false;
  }
};
InputScanner.prototype.testChar = function(pattern, index) {
  var val = this.peek(index);
  pattern.lastIndex = 0;
  return val !== null && pattern.test(val);
};
InputScanner.prototype.match = function(pattern) {
  var pattern_match = this.__match(pattern, this.__position);
  if (pattern_match) {
    this.__position += pattern_match[0].length;
  } else {
    pattern_match = null;
  }
  return pattern_match;
};
InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
  var val = '';
  var match;
  if (starting_pattern) {
    match = this.match(starting_pattern);
    if (match) {
      val += match[0];
    }
  }
  if (until_pattern && (match || !starting_pattern)) {
    val += this.readUntil(until_pattern, until_after);
  }
  return val;
};
InputScanner.prototype.readUntil = function(pattern, until_after) {
  var val = '';
  var match_index = this.__position;
  pattern.lastIndex = this.__position;
  var pattern_match = pattern.exec(this.__input);
  if (pattern_match) {
    match_index = pattern_match.index;
    if (until_after) {
      match_index += pattern_match[0].length;
    }
  } else {
    match_index = this.__input_length;
  }
  val = this.__input.substring(this.__position, match_index);
  this.__position = match_index;
  return val;
};
InputScanner.prototype.readUntilAfter = function(pattern) {
  return this.readUntil(pattern, true);
};
InputScanner.prototype.get_regexp = function(pattern, match_from) {
  var result = null;
  var flags = 'g';
  if (match_from && regexp_has_sticky) {
    flags = 'y';
  }
  if (typeof pattern === "string" && pattern !== '') {
    result = new RegExp(pattern, flags);
  } else if (pattern) {
    result = new RegExp(pattern.source, flags);
  }
  return result;
};
InputScanner.prototype.get_literal_regexp = function(literal_string) {
  return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
};
InputScanner.prototype.peekUntilAfter = function(pattern) {
  var start = this.__position;
  var val = this.readUntilAfter(pattern);
  this.__position = start;
  return val;
};
InputScanner.prototype.lookBack = function(testVal) {
  var start = this.__position - 1;
  return start >= testVal.length && this.__input.substring(start - testVal.length, start)
    .toLowerCase() === testVal;
};
module.exports.InputScanner = InputScanner;
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var InputScanner = (__webpack_require__(8).InputScanner);
var Token = (__webpack_require__(3).Token);
var TokenStream = (__webpack_require__(10).TokenStream);
var WhitespacePattern = (__webpack_require__(11).WhitespacePattern);
var TOKEN = {
  START: 'TK_START',
  RAW: 'TK_RAW',
  EOF: 'TK_EOF'
};
var Tokenizer = function(input_string, options) {
  this._input = new InputScanner(input_string);
  this._options = options || {};
  this.__tokens = null;
  this._patterns = {};
  this._patterns.whitespace = new WhitespacePattern(this._input);
};
Tokenizer.prototype.tokenize = function() {
  this._input.restart();
  this.__tokens = new TokenStream();
  this._reset();
  var current;
  var previous = new Token(TOKEN.START, '');
  var open_token = null;
  var open_stack = [];
  var comments = new TokenStream();
  while (previous.type !== TOKEN.EOF) {
    current = this._get_next_token(previous, open_token);
    while (this._is_comment(current)) {
      comments.add(current);
      current = this._get_next_token(previous, open_token);
    }
    if (!comments.isEmpty()) {
      current.comments_before = comments;
      comments = new TokenStream();
    }
    current.parent = open_token;
    if (this._is_opening(current)) {
      open_stack.push(open_token);
      open_token = current;
    } else if (open_token && this._is_closing(current, open_token)) {
      current.opened = open_token;
      open_token.closed = current;
      open_token = open_stack.pop();
      current.parent = open_token;
    }
    current.previous = previous;
    previous.next = current;
    this.__tokens.add(current);
    previous = current;
  }
  return this.__tokens;
};
Tokenizer.prototype._is_first_token = function() {
  return this.__tokens.isEmpty();
};
Tokenizer.prototype._reset = function() {};
Tokenizer.prototype._get_next_token = function(previous_token, open_token) {
  this._readWhitespace();
  var resulting_string = this._input.read(/.+/g);
  if (resulting_string) {
    return this._create_token(TOKEN.RAW, resulting_string);
  } else {
    return this._create_token(TOKEN.EOF, '');
  }
};
Tokenizer.prototype._is_comment = function(current_token) {
  return false;
};
Tokenizer.prototype._is_opening = function(current_token) {
  return false;
};
Tokenizer.prototype._is_closing = function(current_token, open_token) {
  return false;
};
Tokenizer.prototype._create_token = function(type, text) {
  var token = new Token(type, text,
    this._patterns.whitespace.newline_count,
    this._patterns.whitespace.whitespace_before_token);
  return token;
};
Tokenizer.prototype._readWhitespace = function() {
  return this._patterns.whitespace.read();
};
module.exports.Tokenizer = Tokenizer;
module.exports.TOKEN = TOKEN;
 }),
 (function(module) {
function TokenStream(parent_token) {
  this.__tokens = [];
  this.__tokens_length = this.__tokens.length;
  this.__position = 0;
  this.__parent_token = parent_token;
}
TokenStream.prototype.restart = function() {
  this.__position = 0;
};
TokenStream.prototype.isEmpty = function() {
  return this.__tokens_length === 0;
};
TokenStream.prototype.hasNext = function() {
  return this.__position < this.__tokens_length;
};
TokenStream.prototype.next = function() {
  var val = null;
  if (this.hasNext()) {
    val = this.__tokens[this.__position];
    this.__position += 1;
  }
  return val;
};
TokenStream.prototype.peek = function(index) {
  var val = null;
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__tokens_length) {
    val = this.__tokens[index];
  }
  return val;
};
TokenStream.prototype.add = function(token) {
  if (this.__parent_token) {
    token.parent = this.__parent_token;
  }
  this.__tokens.push(token);
  this.__tokens_length += 1;
};
module.exports.TokenStream = TokenStream;
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var Pattern = (__webpack_require__(12).Pattern);
function WhitespacePattern(input_scanner, parent) {
  Pattern.call(this, input_scanner, parent);
  if (parent) {
    this._line_regexp = this._input.get_regexp(parent._line_regexp);
  } else {
    this.__set_whitespace_patterns('', '');
  }
  this.newline_count = 0;
  this.whitespace_before_token = '';
}
WhitespacePattern.prototype = new Pattern();
WhitespacePattern.prototype.__set_whitespace_patterns = function(whitespace_chars, newline_chars) {
  whitespace_chars += '\\t ';
  newline_chars += '\\n\\r';
  this._match_pattern = this._input.get_regexp(
    '[' + whitespace_chars + newline_chars + ']+', true);
  this._newline_regexp = this._input.get_regexp(
    '\\r\\n|[' + newline_chars + ']');
};
WhitespacePattern.prototype.read = function() {
  this.newline_count = 0;
  this.whitespace_before_token = '';
  var resulting_string = this._input.read(this._match_pattern);
  if (resulting_string === ' ') {
    this.whitespace_before_token = ' ';
  } else if (resulting_string) {
    var matches = this.__split(this._newline_regexp, resulting_string);
    this.newline_count = matches.length - 1;
    this.whitespace_before_token = matches[this.newline_count];
  }
  return resulting_string;
};
WhitespacePattern.prototype.matching = function(whitespace_chars, newline_chars) {
  var result = this._create();
  result.__set_whitespace_patterns(whitespace_chars, newline_chars);
  result._update();
  return result;
};
WhitespacePattern.prototype._create = function() {
  return new WhitespacePattern(this._input, this);
};
WhitespacePattern.prototype.__split = function(regexp, input_string) {
  regexp.lastIndex = 0;
  var start_index = 0;
  var result = [];
  var next_match = regexp.exec(input_string);
  while (next_match) {
    result.push(input_string.substring(start_index, next_match.index));
    start_index = next_match.index + next_match[0].length;
    next_match = regexp.exec(input_string);
  }
  if (start_index < input_string.length) {
    result.push(input_string.substring(start_index, input_string.length));
  } else {
    result.push('');
  }
  return result;
};
module.exports.WhitespacePattern = WhitespacePattern;
 }),
 (function(module) {
function Pattern(input_scanner, parent) {
  this._input = input_scanner;
  this._starting_pattern = null;
  this._match_pattern = null;
  this._until_pattern = null;
  this._until_after = false;
  if (parent) {
    this._starting_pattern = this._input.get_regexp(parent._starting_pattern, true);
    this._match_pattern = this._input.get_regexp(parent._match_pattern, true);
    this._until_pattern = this._input.get_regexp(parent._until_pattern);
    this._until_after = parent._until_after;
  }
}
Pattern.prototype.read = function() {
  var result = this._input.read(this._starting_pattern);
  if (!this._starting_pattern || result) {
    result += this._input.read(this._match_pattern, this._until_pattern, this._until_after);
  }
  return result;
};
Pattern.prototype.read_match = function() {
  return this._input.match(this._match_pattern);
};
Pattern.prototype.until_after = function(pattern) {
  var result = this._create();
  result._until_after = true;
  result._until_pattern = this._input.get_regexp(pattern);
  result._update();
  return result;
};
Pattern.prototype.until = function(pattern) {
  var result = this._create();
  result._until_after = false;
  result._until_pattern = this._input.get_regexp(pattern);
  result._update();
  return result;
};
Pattern.prototype.starting_with = function(pattern) {
  var result = this._create();
  result._starting_pattern = this._input.get_regexp(pattern, true);
  result._update();
  return result;
};
Pattern.prototype.matching = function(pattern) {
  var result = this._create();
  result._match_pattern = this._input.get_regexp(pattern, true);
  result._update();
  return result;
};
Pattern.prototype._create = function() {
  return new Pattern(this._input, this);
};
Pattern.prototype._update = function() {};
module.exports.Pattern = Pattern;
 }),
 (function(module) {
function Directives(start_block_pattern, end_block_pattern) {
  start_block_pattern = typeof start_block_pattern === 'string' ? start_block_pattern : start_block_pattern.source;
  end_block_pattern = typeof end_block_pattern === 'string' ? end_block_pattern : end_block_pattern.source;
  this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, 'g');
  this.__directive_pattern = / (\w+)[:](\w+)/g;
  this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, 'g');
}
Directives.prototype.get_directives = function(text) {
  if (!text.match(this.__directives_block_pattern)) {
    return null;
  }
  var directives = {};
  this.__directive_pattern.lastIndex = 0;
  var directive_match = this.__directive_pattern.exec(text);
  while (directive_match) {
    directives[directive_match[1]] = directive_match[2];
    directive_match = this.__directive_pattern.exec(text);
  }
  return directives;
};
Directives.prototype.readIgnored = function(input) {
  return input.readUntilAfter(this.__directives_end_ignore_pattern);
};
module.exports.Directives = Directives;
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var Pattern = (__webpack_require__(12).Pattern);
var template_names = {
  django: false,
  erb: false,
  handlebars: false,
  php: false,
  smarty: false,
  angular: false
};
function TemplatablePattern(input_scanner, parent) {
  Pattern.call(this, input_scanner, parent);
  this.__template_pattern = null;
  this._disabled = Object.assign({}, template_names);
  this._excluded = Object.assign({}, template_names);
  if (parent) {
    this.__template_pattern = this._input.get_regexp(parent.__template_pattern);
    this._excluded = Object.assign(this._excluded, parent._excluded);
    this._disabled = Object.assign(this._disabled, parent._disabled);
  }
  var pattern = new Pattern(input_scanner);
  this.__patterns = {
    handlebars_comment: pattern.starting_with(/{{!--/).until_after(/--}}/),
    handlebars_unescaped: pattern.starting_with(/{{{/).until_after(/}}}/),
    handlebars: pattern.starting_with(/{{/).until_after(/}}/),
    php: pattern.starting_with(/<\?(?:[= ]|php)/).until_after(/\?>/),
    erb: pattern.starting_with(/<%[^%]/).until_after(/[^%]%>/),
    django: pattern.starting_with(/{%/).until_after(/%}/),
    django_value: pattern.starting_with(/{{/).until_after(/}}/),
    django_comment: pattern.starting_with(/{#/).until_after(/#}/),
    smarty: pattern.starting_with(/{(?=[^}{\s\n])/).until_after(/[^\s\n]}/),
    smarty_comment: pattern.starting_with(/{\*/).until_after(/\*}/),
    smarty_literal: pattern.starting_with(/{literal}/).until_after(/{\/literal}/)
  };
}
TemplatablePattern.prototype = new Pattern();
TemplatablePattern.prototype._create = function() {
  return new TemplatablePattern(this._input, this);
};
TemplatablePattern.prototype._update = function() {
  this.__set_templated_pattern();
};
TemplatablePattern.prototype.disable = function(language) {
  var result = this._create();
  result._disabled[language] = true;
  result._update();
  return result;
};
TemplatablePattern.prototype.read_options = function(options) {
  var result = this._create();
  for (var language in template_names) {
    result._disabled[language] = options.templating.indexOf(language) === -1;
  }
  result._update();
  return result;
};
TemplatablePattern.prototype.exclude = function(language) {
  var result = this._create();
  result._excluded[language] = true;
  result._update();
  return result;
};
TemplatablePattern.prototype.read = function() {
  var result = '';
  if (this._match_pattern) {
    result = this._input.read(this._starting_pattern);
  } else {
    result = this._input.read(this._starting_pattern, this.__template_pattern);
  }
  var next = this._read_template();
  while (next) {
    if (this._match_pattern) {
      next += this._input.read(this._match_pattern);
    } else {
      next += this._input.readUntil(this.__template_pattern);
    }
    result += next;
    next = this._read_template();
  }
  if (this._until_after) {
    result += this._input.readUntilAfter(this._until_pattern);
  }
  return result;
};
TemplatablePattern.prototype.__set_templated_pattern = function() {
  var items = [];
  if (!this._disabled.php) {
    items.push(this.__patterns.php._starting_pattern.source);
  }
  if (!this._disabled.handlebars) {
    items.push(this.__patterns.handlebars._starting_pattern.source);
  }
  if (!this._disabled.angular) {
    items.push(this.__patterns.handlebars._starting_pattern.source);
  }
  if (!this._disabled.erb) {
    items.push(this.__patterns.erb._starting_pattern.source);
  }
  if (!this._disabled.django) {
    items.push(this.__patterns.django._starting_pattern.source);
    items.push(this.__patterns.django_value._starting_pattern.source);
    items.push(this.__patterns.django_comment._starting_pattern.source);
  }
  if (!this._disabled.smarty) {
    items.push(this.__patterns.smarty._starting_pattern.source);
  }
  if (this._until_pattern) {
    items.push(this._until_pattern.source);
  }
  this.__template_pattern = this._input.get_regexp('(?:' + items.join('|') + ')');
};
TemplatablePattern.prototype._read_template = function() {
  var resulting_string = '';
  var c = this._input.peek();
  if (c === '<') {
    var peek1 = this._input.peek(1);
    if (!this._disabled.php && !this._excluded.php && peek1 === '?') {
      resulting_string = resulting_string ||
        this.__patterns.php.read();
    }
    if (!this._disabled.erb && !this._excluded.erb && peek1 === '%') {
      resulting_string = resulting_string ||
        this.__patterns.erb.read();
    }
  } else if (c === '{') {
    if (!this._disabled.handlebars && !this._excluded.handlebars) {
      resulting_string = resulting_string ||
        this.__patterns.handlebars_comment.read();
      resulting_string = resulting_string ||
        this.__patterns.handlebars_unescaped.read();
      resulting_string = resulting_string ||
        this.__patterns.handlebars.read();
    }
    if (!this._disabled.django) {
      if (!this._excluded.django && !this._excluded.handlebars) {
        resulting_string = resulting_string ||
          this.__patterns.django_value.read();
      }
      if (!this._excluded.django) {
        resulting_string = resulting_string ||
          this.__patterns.django_comment.read();
        resulting_string = resulting_string ||
          this.__patterns.django.read();
      }
    }
    if (!this._disabled.smarty) {
      if (this._disabled.django && this._disabled.handlebars) {
        resulting_string = resulting_string ||
          this.__patterns.smarty_comment.read();
        resulting_string = resulting_string ||
          this.__patterns.smarty_literal.read();
        resulting_string = resulting_string ||
          this.__patterns.smarty.read();
      }
    }
  }
  return resulting_string;
};
module.exports.TemplatablePattern = TemplatablePattern;
 }),
,
,
,
 (function(module, __unused_webpack_exports, __webpack_require__) {
var Beautifier = (__webpack_require__(19).Beautifier),
  Options = (__webpack_require__(20).Options);
function style_html(html_source, options, js_beautify, css_beautify) {
  var beautifier = new Beautifier(html_source, options, js_beautify, css_beautify);
  return beautifier.beautify();
}
module.exports = style_html;
module.exports.defaultOptions = function() {
  return new Options();
};
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var Options = (__webpack_require__(20).Options);
var Output = (__webpack_require__(2).Output);
var Tokenizer = (__webpack_require__(21).Tokenizer);
var TOKEN = (__webpack_require__(21).TOKEN);
var lineBreak = /\r\n|[\r\n]/;
var allLineBreaks = /\r\n|[\r\n]/g;
var Printer = function(options, base_indent_string) {
  this.indent_level = 0;
  this.alignment_size = 0;
  this.max_preserve_newlines = options.max_preserve_newlines;
  this.preserve_newlines = options.preserve_newlines;
  this._output = new Output(options, base_indent_string);
};
Printer.prototype.current_line_has_match = function(pattern) {
  return this._output.current_line.has_match(pattern);
};
Printer.prototype.set_space_before_token = function(value, non_breaking) {
  this._output.space_before_token = value;
  this._output.non_breaking_space = non_breaking;
};
Printer.prototype.set_wrap_point = function() {
  this._output.set_indent(this.indent_level, this.alignment_size);
  this._output.set_wrap_point();
};
Printer.prototype.add_raw_token = function(token) {
  this._output.add_raw_token(token);
};
Printer.prototype.print_preserved_newlines = function(raw_token) {
  var newlines = 0;
  if (raw_token.type !== TOKEN.TEXT && raw_token.previous.type !== TOKEN.TEXT) {
    newlines = raw_token.newlines ? 1 : 0;
  }
  if (this.preserve_newlines) {
    newlines = raw_token.newlines < this.max_preserve_newlines + 1 ? raw_token.newlines : this.max_preserve_newlines + 1;
  }
  for (var n = 0; n < newlines; n++) {
    this.print_newline(n > 0);
  }
  return newlines !== 0;
};
Printer.prototype.traverse_whitespace = function(raw_token) {
  if (raw_token.whitespace_before || raw_token.newlines) {
    if (!this.print_preserved_newlines(raw_token)) {
      this._output.space_before_token = true;
    }
    return true;
  }
  return false;
};
Printer.prototype.previous_token_wrapped = function() {
  return this._output.previous_token_wrapped;
};
Printer.prototype.print_newline = function(force) {
  this._output.add_new_line(force);
};
Printer.prototype.print_token = function(token) {
  if (token.text) {
    this._output.set_indent(this.indent_level, this.alignment_size);
    this._output.add_token(token.text);
  }
};
Printer.prototype.indent = function() {
  this.indent_level++;
};
Printer.prototype.deindent = function() {
  if (this.indent_level > 0) {
    this.indent_level--;
    this._output.set_indent(this.indent_level, this.alignment_size);
  }
};
Printer.prototype.get_full_indent = function(level) {
  level = this.indent_level + (level || 0);
  if (level < 1) {
    return '';
  }
  return this._output.get_indent_string(level);
};
var get_type_attribute = function(start_token) {
  var result = null;
  var raw_token = start_token.next;
  while (raw_token.type !== TOKEN.EOF && start_token.closed !== raw_token) {
    if (raw_token.type === TOKEN.ATTRIBUTE && raw_token.text === 'type') {
      if (raw_token.next && raw_token.next.type === TOKEN.EQUALS &&
        raw_token.next.next && raw_token.next.next.type === TOKEN.VALUE) {
        result = raw_token.next.next.text;
      }
      break;
    }
    raw_token = raw_token.next;
  }
  return result;
};
var get_custom_beautifier_name = function(tag_check, raw_token) {
  var typeAttribute = null;
  var result = null;
  if (!raw_token.closed) {
    return null;
  }
  if (tag_check === 'script') {
    typeAttribute = 'text/javascript';
  } else if (tag_check === 'style') {
    typeAttribute = 'text/css';
  }
  typeAttribute = get_type_attribute(raw_token) || typeAttribute;
  if (typeAttribute.search('text/css') > -1) {
    result = 'css';
  } else if (typeAttribute.search(/module|((text|application|dojo)\/(x-)?(javascript|ecmascript|jscript|livescript|(ld\+)?json|method|aspect))/) > -1) {
    result = 'javascript';
  } else if (typeAttribute.search(/(text|application|dojo)\/(x-)?(html)/) > -1) {
    result = 'html';
  } else if (typeAttribute.search(/test\/null/) > -1) {
    result = 'null';
  }
  return result;
};
function in_array(what, arr) {
  return arr.indexOf(what) !== -1;
}
function TagFrame(parent, parser_token, indent_level) {
  this.parent = parent || null;
  this.tag = parser_token ? parser_token.tag_name : '';
  this.indent_level = indent_level || 0;
  this.parser_token = parser_token || null;
}
function TagStack(printer) {
  this._printer = printer;
  this._current_frame = null;
}
TagStack.prototype.get_parser_token = function() {
  return this._current_frame ? this._current_frame.parser_token : null;
};
TagStack.prototype.record_tag = function(parser_token) {
  var new_frame = new TagFrame(this._current_frame, parser_token, this._printer.indent_level);
  this._current_frame = new_frame;
};
TagStack.prototype._try_pop_frame = function(frame) {
  var parser_token = null;
  if (frame) {
    parser_token = frame.parser_token;
    this._printer.indent_level = frame.indent_level;
    this._current_frame = frame.parent;
  }
  return parser_token;
};
TagStack.prototype._get_frame = function(tag_list, stop_list) {
  var frame = this._current_frame;
  while (frame) {
    if (tag_list.indexOf(frame.tag) !== -1) {
      break;
    } else if (stop_list && stop_list.indexOf(frame.tag) !== -1) {
      frame = null;
      break;
    }
    frame = frame.parent;
  }
  return frame;
};
TagStack.prototype.try_pop = function(tag, stop_list) {
  var frame = this._get_frame([tag], stop_list);
  return this._try_pop_frame(frame);
};
TagStack.prototype.indent_to_tag = function(tag_list) {
  var frame = this._get_frame(tag_list);
  if (frame) {
    this._printer.indent_level = frame.indent_level;
  }
};
function Beautifier(source_text, options, js_beautify, css_beautify) {
  this._source_text = source_text || '';
  options = options || {};
  this._js_beautify = js_beautify;
  this._css_beautify = css_beautify;
  this._tag_stack = null;
  var optionHtml = new Options(options, 'html');
  this._options = optionHtml;
  this._is_wrap_attributes_force = this._options.wrap_attributes.substr(0, 'force'.length) === 'force';
  this._is_wrap_attributes_force_expand_multiline = (this._options.wrap_attributes === 'force-expand-multiline');
  this._is_wrap_attributes_force_aligned = (this._options.wrap_attributes === 'force-aligned');
  this._is_wrap_attributes_aligned_multiple = (this._options.wrap_attributes === 'aligned-multiple');
  this._is_wrap_attributes_preserve = this._options.wrap_attributes.substr(0, 'preserve'.length) === 'preserve';
  this._is_wrap_attributes_preserve_aligned = (this._options.wrap_attributes === 'preserve-aligned');
}
Beautifier.prototype.beautify = function() {
  if (this._options.disabled) {
    return this._source_text;
  }
  var source_text = this._source_text;
  var eol = this._options.eol;
  if (this._options.eol === 'auto') {
    eol = '\n';
    if (source_text && lineBreak.test(source_text)) {
      eol = source_text.match(lineBreak)[0];
    }
  }
  source_text = source_text.replace(allLineBreaks, '\n');
  var baseIndentString = source_text.match(/^[\t ]*/)[0];
  var last_token = {
    text: '',
    type: ''
  };
  var last_tag_token = new TagOpenParserToken(this._options);
  var printer = new Printer(this._options, baseIndentString);
  var tokens = new Tokenizer(source_text, this._options).tokenize();
  this._tag_stack = new TagStack(printer);
  var parser_token = null;
  var raw_token = tokens.next();
  while (raw_token.type !== TOKEN.EOF) {
    if (raw_token.type === TOKEN.TAG_OPEN || raw_token.type === TOKEN.COMMENT) {
      parser_token = this._handle_tag_open(printer, raw_token, last_tag_token, last_token, tokens);
      last_tag_token = parser_token;
    } else if ((raw_token.type === TOKEN.ATTRIBUTE || raw_token.type === TOKEN.EQUALS || raw_token.type === TOKEN.VALUE) ||
      (raw_token.type === TOKEN.TEXT && !last_tag_token.tag_complete)) {
      parser_token = this._handle_inside_tag(printer, raw_token, last_tag_token, last_token);
    } else if (raw_token.type === TOKEN.TAG_CLOSE) {
      parser_token = this._handle_tag_close(printer, raw_token, last_tag_token);
    } else if (raw_token.type === TOKEN.TEXT) {
      parser_token = this._handle_text(printer, raw_token, last_tag_token);
    } else if (raw_token.type === TOKEN.CONTROL_FLOW_OPEN) {
      parser_token = this._handle_control_flow_open(printer, raw_token);
    } else if (raw_token.type === TOKEN.CONTROL_FLOW_CLOSE) {
      parser_token = this._handle_control_flow_close(printer, raw_token);
    } else {
      printer.add_raw_token(raw_token);
    }
    last_token = parser_token;
    raw_token = tokens.next();
  }
  var sweet_code = printer._output.get_code(eol);
  return sweet_code;
};
Beautifier.prototype._handle_control_flow_open = function(printer, raw_token) {
  var parser_token = {
    text: raw_token.text,
    type: raw_token.type
  };
  printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== '', true);
  if (raw_token.newlines) {
    printer.print_preserved_newlines(raw_token);
  } else {
    printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== '', true);
  }
  printer.print_token(raw_token);
  printer.indent();
  return parser_token;
};
Beautifier.prototype._handle_control_flow_close = function(printer, raw_token) {
  var parser_token = {
    text: raw_token.text,
    type: raw_token.type
  };
  printer.deindent();
  if (raw_token.newlines) {
    printer.print_preserved_newlines(raw_token);
  } else {
    printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== '', true);
  }
  printer.print_token(raw_token);
  return parser_token;
};
Beautifier.prototype._handle_tag_close = function(printer, raw_token, last_tag_token) {
  var parser_token = {
    text: raw_token.text,
    type: raw_token.type
  };
  printer.alignment_size = 0;
  last_tag_token.tag_complete = true;
  printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== '', true);
  if (last_tag_token.is_unformatted) {
    printer.add_raw_token(raw_token);
  } else {
    if (last_tag_token.tag_start_char === '<') {
      printer.set_space_before_token(raw_token.text[0] === '/', true);
      if (this._is_wrap_attributes_force_expand_multiline && last_tag_token.has_wrapped_attrs) {
        printer.print_newline(false);
      }
    }
    printer.print_token(raw_token);
  }
  if (last_tag_token.indent_content &&
    !(last_tag_token.is_unformatted || last_tag_token.is_content_unformatted)) {
    printer.indent();
    last_tag_token.indent_content = false;
  }
  if (!last_tag_token.is_inline_element &&
    !(last_tag_token.is_unformatted || last_tag_token.is_content_unformatted)) {
    printer.set_wrap_point();
  }
  return parser_token;
};
Beautifier.prototype._handle_inside_tag = function(printer, raw_token, last_tag_token, last_token) {
  var wrapped = last_tag_token.has_wrapped_attrs;
  var parser_token = {
    text: raw_token.text,
    type: raw_token.type
  };
  printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== '', true);
  if (last_tag_token.is_unformatted) {
    printer.add_raw_token(raw_token);
  } else if (last_tag_token.tag_start_char === '{' && raw_token.type === TOKEN.TEXT) {
    if (printer.print_preserved_newlines(raw_token)) {
      raw_token.newlines = 0;
      printer.add_raw_token(raw_token);
    } else {
      printer.print_token(raw_token);
    }
  } else {
    if (raw_token.type === TOKEN.ATTRIBUTE) {
      printer.set_space_before_token(true);
    } else if (raw_token.type === TOKEN.EQUALS) {
      printer.set_space_before_token(false);
    } else if (raw_token.type === TOKEN.VALUE && raw_token.previous.type === TOKEN.EQUALS) {
      printer.set_space_before_token(false);
    }
    if (raw_token.type === TOKEN.ATTRIBUTE && last_tag_token.tag_start_char === '<') {
      if (this._is_wrap_attributes_preserve || this._is_wrap_attributes_preserve_aligned) {
        printer.traverse_whitespace(raw_token);
        wrapped = wrapped || raw_token.newlines !== 0;
      }
      if (this._is_wrap_attributes_force &&
        last_tag_token.attr_count >= this._options.wrap_attributes_min_attrs &&
        (last_token.type !== TOKEN.TAG_OPEN ||
          this._is_wrap_attributes_force_expand_multiline)) {
        printer.print_newline(false);
        wrapped = true;
      }
    }
    printer.print_token(raw_token);
    wrapped = wrapped || printer.previous_token_wrapped();
    last_tag_token.has_wrapped_attrs = wrapped;
  }
  return parser_token;
};
Beautifier.prototype._handle_text = function(printer, raw_token, last_tag_token) {
  var parser_token = {
    text: raw_token.text,
    type: 'TK_CONTENT'
  };
  if (last_tag_token.custom_beautifier_name) {
    this._print_custom_beatifier_text(printer, raw_token, last_tag_token);
  } else if (last_tag_token.is_unformatted || last_tag_token.is_content_unformatted) {
    printer.add_raw_token(raw_token);
  } else {
    printer.traverse_whitespace(raw_token);
    printer.print_token(raw_token);
  }
  return parser_token;
};
Beautifier.prototype._print_custom_beatifier_text = function(printer, raw_token, last_tag_token) {
  var local = this;
  if (raw_token.text !== '') {
    var text = raw_token.text,
      _beautifier,
      script_indent_level = 1,
      pre = '',
      post = '';
    if (last_tag_token.custom_beautifier_name === 'javascript' && typeof this._js_beautify === 'function') {
      _beautifier = this._js_beautify;
    } else if (last_tag_token.custom_beautifier_name === 'css' && typeof this._css_beautify === 'function') {
      _beautifier = this._css_beautify;
    } else if (last_tag_token.custom_beautifier_name === 'html') {
      _beautifier = function(html_source, options) {
        var beautifier = new Beautifier(html_source, options, local._js_beautify, local._css_beautify);
        return beautifier.beautify();
      };
    }
    if (this._options.indent_scripts === "keep") {
      script_indent_level = 0;
    } else if (this._options.indent_scripts === "separate") {
      script_indent_level = -printer.indent_level;
    }
    var indentation = printer.get_full_indent(script_indent_level);
    text = text.replace(/\n[ \t]*$/, '');
    if (last_tag_token.custom_beautifier_name !== 'html' &&
      text[0] === '<' && text.match(/^(<!--|<!\[CDATA\[)/)) {
      var matched = /^(<!--[^\n]*|<!\[CDATA\[)(\n?)([ \t\n]*)([\s\S]*)(-->|]]>)$/.exec(text);
      if (!matched) {
        printer.add_raw_token(raw_token);
        return;
      }
      pre = indentation + matched[1] + '\n';
      text = matched[4];
      if (matched[5]) {
        post = indentation + matched[5];
      }
      text = text.replace(/\n[ \t]*$/, '');
      if (matched[2] || matched[3].indexOf('\n') !== -1) {
        matched = matched[3].match(/[ \t]+$/);
        if (matched) {
          raw_token.whitespace_before = matched[0];
        }
      }
    }
    if (text) {
      if (_beautifier) {
        var Child_options = function() {
          this.eol = '\n';
        };
        Child_options.prototype = this._options.raw_options;
        var child_options = new Child_options();
        text = _beautifier(indentation + text, child_options);
      } else {
        var white = raw_token.whitespace_before;
        if (white) {
          text = text.replace(new RegExp('\n(' + white + ')?', 'g'), '\n');
        }
        text = indentation + text.replace(/\n/g, '\n' + indentation);
      }
    }
    if (pre) {
      if (!text) {
        text = pre + post;
      } else {
        text = pre + text + '\n' + post;
      }
    }
    printer.print_newline(false);
    if (text) {
      raw_token.text = text;
      raw_token.whitespace_before = '';
      raw_token.newlines = 0;
      printer.add_raw_token(raw_token);
      printer.print_newline(true);
    }
  }
};
Beautifier.prototype._handle_tag_open = function(printer, raw_token, last_tag_token, last_token, tokens) {
  var parser_token = this._get_tag_open_token(raw_token);
  if ((last_tag_token.is_unformatted || last_tag_token.is_content_unformatted) &&
    !last_tag_token.is_empty_element &&
    raw_token.type === TOKEN.TAG_OPEN && !parser_token.is_start_tag) {
    printer.add_raw_token(raw_token);
    parser_token.start_tag_token = this._tag_stack.try_pop(parser_token.tag_name);
  } else {
    printer.traverse_whitespace(raw_token);
    this._set_tag_position(printer, raw_token, parser_token, last_tag_token, last_token);
    if (!parser_token.is_inline_element) {
      printer.set_wrap_point();
    }
    printer.print_token(raw_token);
  }
  if (parser_token.is_start_tag && this._is_wrap_attributes_force) {
    var peek_index = 0;
    var peek_token;
    do {
      peek_token = tokens.peek(peek_index);
      if (peek_token.type === TOKEN.ATTRIBUTE) {
        parser_token.attr_count += 1;
      }
      peek_index += 1;
    } while (peek_token.type !== TOKEN.EOF && peek_token.type !== TOKEN.TAG_CLOSE);
  }
  if (this._is_wrap_attributes_force_aligned || this._is_wrap_attributes_aligned_multiple || this._is_wrap_attributes_preserve_aligned) {
    parser_token.alignment_size = raw_token.text.length + 1;
  }
  if (!parser_token.tag_complete && !parser_token.is_unformatted) {
    printer.alignment_size = parser_token.alignment_size;
  }
  return parser_token;
};
var TagOpenParserToken = function(options, parent, raw_token) {
  this.parent = parent || null;
  this.text = '';
  this.type = 'TK_TAG_OPEN';
  this.tag_name = '';
  this.is_inline_element = false;
  this.is_unformatted = false;
  this.is_content_unformatted = false;
  this.is_empty_element = false;
  this.is_start_tag = false;
  this.is_end_tag = false;
  this.indent_content = false;
  this.multiline_content = false;
  this.custom_beautifier_name = null;
  this.start_tag_token = null;
  this.attr_count = 0;
  this.has_wrapped_attrs = false;
  this.alignment_size = 0;
  this.tag_complete = false;
  this.tag_start_char = '';
  this.tag_check = '';
  if (!raw_token) {
    this.tag_complete = true;
  } else {
    var tag_check_match;
    this.tag_start_char = raw_token.text[0];
    this.text = raw_token.text;
    if (this.tag_start_char === '<') {
      tag_check_match = raw_token.text.match(/^<([^\s>]*)/);
      this.tag_check = tag_check_match ? tag_check_match[1] : '';
    } else {
      tag_check_match = raw_token.text.match(/^{{~?(?:[\^]|#\*?)?([^\s}]+)/);
      this.tag_check = tag_check_match ? tag_check_match[1] : '';
      if ((raw_token.text.startsWith('{{#>') || raw_token.text.startsWith('{{~#>')) && this.tag_check[0] === '>') {
        if (this.tag_check === '>' && raw_token.next !== null) {
          this.tag_check = raw_token.next.text.split(' ')[0];
        } else {
          this.tag_check = raw_token.text.split('>')[1];
        }
      }
    }
    this.tag_check = this.tag_check.toLowerCase();
    if (raw_token.type === TOKEN.COMMENT) {
      this.tag_complete = true;
    }
    this.is_start_tag = this.tag_check.charAt(0) !== '/';
    this.tag_name = !this.is_start_tag ? this.tag_check.substr(1) : this.tag_check;
    this.is_end_tag = !this.is_start_tag ||
      (raw_token.closed && raw_token.closed.text === '/>');
    var handlebar_starts = 2;
    if (this.tag_start_char === '{' && this.text.length >= 3) {
      if (this.text.charAt(2) === '~') {
        handlebar_starts = 3;
      }
    }
    this.is_end_tag = this.is_end_tag ||
      (this.tag_start_char === '{' && (!options.indent_handlebars || this.text.length < 3 || (/[^#\^]/.test(this.text.charAt(handlebar_starts)))));
  }
};
Beautifier.prototype._get_tag_open_token = function(raw_token) {
  var parser_token = new TagOpenParserToken(this._options, this._tag_stack.get_parser_token(), raw_token);
  parser_token.alignment_size = this._options.wrap_attributes_indent_size;
  parser_token.is_end_tag = parser_token.is_end_tag ||
    in_array(parser_token.tag_check, this._options.void_elements);
  parser_token.is_empty_element = parser_token.tag_complete ||
    (parser_token.is_start_tag && parser_token.is_end_tag);
  parser_token.is_unformatted = !parser_token.tag_complete && in_array(parser_token.tag_check, this._options.unformatted);
  parser_token.is_content_unformatted = !parser_token.is_empty_element && in_array(parser_token.tag_check, this._options.content_unformatted);
  parser_token.is_inline_element = in_array(parser_token.tag_name, this._options.inline) || (this._options.inline_custom_elements && parser_token.tag_name.includes("-")) || parser_token.tag_start_char === '{';
  return parser_token;
};
Beautifier.prototype._set_tag_position = function(printer, raw_token, parser_token, last_tag_token, last_token) {
  if (!parser_token.is_empty_element) {
    if (parser_token.is_end_tag) {
      parser_token.start_tag_token = this._tag_stack.try_pop(parser_token.tag_name);
    } else {
      if (this._do_optional_end_element(parser_token)) {
        if (!parser_token.is_inline_element) {
          printer.print_newline(false);
        }
      }
      this._tag_stack.record_tag(parser_token);
      if ((parser_token.tag_name === 'script' || parser_token.tag_name === 'style') &&
        !(parser_token.is_unformatted || parser_token.is_content_unformatted)) {
        parser_token.custom_beautifier_name = get_custom_beautifier_name(parser_token.tag_check, raw_token);
      }
    }
  }
  if (in_array(parser_token.tag_check, this._options.extra_liners)) {
    printer.print_newline(false);
    if (!printer._output.just_added_blankline()) {
      printer.print_newline(true);
    }
  }
  if (parser_token.is_empty_element) {
    if (parser_token.tag_start_char === '{' && parser_token.tag_check === 'else') {
      this._tag_stack.indent_to_tag(['if', 'unless', 'each']);
      parser_token.indent_content = true;
      var foundIfOnCurrentLine = printer.current_line_has_match(/{{#if/);
      if (!foundIfOnCurrentLine) {
        printer.print_newline(false);
      }
    }
    if (parser_token.tag_name === '!--' && last_token.type === TOKEN.TAG_CLOSE &&
      last_tag_token.is_end_tag && parser_token.text.indexOf('\n') === -1) ; else {
      if (!(parser_token.is_inline_element || parser_token.is_unformatted)) {
        printer.print_newline(false);
      }
      this._calcluate_parent_multiline(printer, parser_token);
    }
  } else if (parser_token.is_end_tag) {
    var do_end_expand = false;
    do_end_expand = parser_token.start_tag_token && parser_token.start_tag_token.multiline_content;
    do_end_expand = do_end_expand || (!parser_token.is_inline_element &&
      !(last_tag_token.is_inline_element || last_tag_token.is_unformatted) &&
      !(last_token.type === TOKEN.TAG_CLOSE && parser_token.start_tag_token === last_tag_token) &&
      last_token.type !== 'TK_CONTENT'
    );
    if (parser_token.is_content_unformatted || parser_token.is_unformatted) {
      do_end_expand = false;
    }
    if (do_end_expand) {
      printer.print_newline(false);
    }
  } else {
    parser_token.indent_content = !parser_token.custom_beautifier_name;
    if (parser_token.tag_start_char === '<') {
      if (parser_token.tag_name === 'html') {
        parser_token.indent_content = this._options.indent_inner_html;
      } else if (parser_token.tag_name === 'head') {
        parser_token.indent_content = this._options.indent_head_inner_html;
      } else if (parser_token.tag_name === 'body') {
        parser_token.indent_content = this._options.indent_body_inner_html;
      }
    }
    if (!(parser_token.is_inline_element || parser_token.is_unformatted) &&
      (last_token.type !== 'TK_CONTENT' || parser_token.is_content_unformatted)) {
      printer.print_newline(false);
    }
    this._calcluate_parent_multiline(printer, parser_token);
  }
};
Beautifier.prototype._calcluate_parent_multiline = function(printer, parser_token) {
  if (parser_token.parent && printer._output.just_added_newline() &&
    !((parser_token.is_inline_element || parser_token.is_unformatted) && parser_token.parent.is_inline_element)) {
    parser_token.parent.multiline_content = true;
  }
};
var p_closers = ['address', 'article', 'aside', 'blockquote', 'details', 'div', 'dl', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hr', 'main', 'menu', 'nav', 'ol', 'p', 'pre', 'section', 'table', 'ul'];
var p_parent_excludes = ['a', 'audio', 'del', 'ins', 'map', 'noscript', 'video'];
Beautifier.prototype._do_optional_end_element = function(parser_token) {
  var result = null;
  if (parser_token.is_empty_element || !parser_token.is_start_tag || !parser_token.parent) {
    return;
  }
  if (parser_token.tag_name === 'body') {
    result = result || this._tag_stack.try_pop('head');
  } else if (parser_token.tag_name === 'li') {
    result = result || this._tag_stack.try_pop('li', ['ol', 'ul', 'menu']);
  } else if (parser_token.tag_name === 'dd' || parser_token.tag_name === 'dt') {
    result = result || this._tag_stack.try_pop('dt', ['dl']);
    result = result || this._tag_stack.try_pop('dd', ['dl']);
  } else if (parser_token.parent.tag_name === 'p' && p_closers.indexOf(parser_token.tag_name) !== -1) {
    var p_parent = parser_token.parent.parent;
    if (!p_parent || p_parent_excludes.indexOf(p_parent.tag_name) === -1) {
      result = result || this._tag_stack.try_pop('p');
    }
  } else if (parser_token.tag_name === 'rp' || parser_token.tag_name === 'rt') {
    result = result || this._tag_stack.try_pop('rt', ['ruby', 'rtc']);
    result = result || this._tag_stack.try_pop('rp', ['ruby', 'rtc']);
  } else if (parser_token.tag_name === 'optgroup') {
    result = result || this._tag_stack.try_pop('optgroup', ['select']);
  } else if (parser_token.tag_name === 'option') {
    result = result || this._tag_stack.try_pop('option', ['select', 'datalist', 'optgroup']);
  } else if (parser_token.tag_name === 'colgroup') {
    result = result || this._tag_stack.try_pop('caption', ['table']);
  } else if (parser_token.tag_name === 'thead') {
    result = result || this._tag_stack.try_pop('caption', ['table']);
    result = result || this._tag_stack.try_pop('colgroup', ['table']);
  } else if (parser_token.tag_name === 'tbody' || parser_token.tag_name === 'tfoot') {
    result = result || this._tag_stack.try_pop('caption', ['table']);
    result = result || this._tag_stack.try_pop('colgroup', ['table']);
    result = result || this._tag_stack.try_pop('thead', ['table']);
    result = result || this._tag_stack.try_pop('tbody', ['table']);
  } else if (parser_token.tag_name === 'tr') {
    result = result || this._tag_stack.try_pop('caption', ['table']);
    result = result || this._tag_stack.try_pop('colgroup', ['table']);
    result = result || this._tag_stack.try_pop('tr', ['table', 'thead', 'tbody', 'tfoot']);
  } else if (parser_token.tag_name === 'th' || parser_token.tag_name === 'td') {
    result = result || this._tag_stack.try_pop('td', ['table', 'thead', 'tbody', 'tfoot', 'tr']);
    result = result || this._tag_stack.try_pop('th', ['table', 'thead', 'tbody', 'tfoot', 'tr']);
  }
  parser_token.parent = this._tag_stack.get_parser_token();
  return result;
};
module.exports.Beautifier = Beautifier;
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var BaseOptions = (__webpack_require__(6).Options);
function Options(options) {
  BaseOptions.call(this, options, 'html');
  if (this.templating.length === 1 && this.templating[0] === 'auto') {
    this.templating = ['django', 'erb', 'handlebars', 'php'];
  }
  this.indent_inner_html = this._get_boolean('indent_inner_html');
  this.indent_body_inner_html = this._get_boolean('indent_body_inner_html', true);
  this.indent_head_inner_html = this._get_boolean('indent_head_inner_html', true);
  this.indent_handlebars = this._get_boolean('indent_handlebars', true);
  this.wrap_attributes = this._get_selection('wrap_attributes',
    ['auto', 'force', 'force-aligned', 'force-expand-multiline', 'aligned-multiple', 'preserve', 'preserve-aligned']);
  this.wrap_attributes_min_attrs = this._get_number('wrap_attributes_min_attrs', 2);
  this.wrap_attributes_indent_size = this._get_number('wrap_attributes_indent_size', this.indent_size);
  this.extra_liners = this._get_array('extra_liners', ['head', 'body', '/html']);
  this.inline = this._get_array('inline', [
    'a', 'abbr', 'area', 'audio', 'b', 'bdi', 'bdo', 'br', 'button', 'canvas', 'cite',
    'code', 'data', 'datalist', 'del', 'dfn', 'em', 'embed', 'i', 'iframe', 'img',
    'input', 'ins', 'kbd', 'keygen', 'label', 'map', 'mark', 'math', 'meter', 'noscript',
    'object', 'output', 'progress', 'q', 'ruby', 's', 'samp',  'select', 'small',
    'span', 'strong', 'sub', 'sup', 'svg', 'template', 'textarea', 'time', 'u', 'var',
    'video', 'wbr', 'text',
    'acronym', 'big', 'strike', 'tt'
  ]);
  this.inline_custom_elements = this._get_boolean('inline_custom_elements', true);
  this.void_elements = this._get_array('void_elements', [
    'area', 'base', 'br', 'col', 'embed', 'hr', 'img', 'input', 'keygen',
    'link', 'menuitem', 'meta', 'param', 'source', 'track', 'wbr',
    '!doctype', '?xml',
    'basefont', 'isindex'
  ]);
  this.unformatted = this._get_array('unformatted', []);
  this.content_unformatted = this._get_array('content_unformatted', [
    'pre', 'textarea'
  ]);
  this.unformatted_content_delimiter = this._get_characters('unformatted_content_delimiter');
  this.indent_scripts = this._get_selection('indent_scripts', ['normal', 'keep', 'separate']);
}
Options.prototype = new BaseOptions();
module.exports.Options = Options;
 }),
 (function(module, __unused_webpack_exports, __webpack_require__) {
var BaseTokenizer = (__webpack_require__(9).Tokenizer);
var BASETOKEN = (__webpack_require__(9).TOKEN);
var Directives = (__webpack_require__(13).Directives);
var TemplatablePattern = (__webpack_require__(14).TemplatablePattern);
var Pattern = (__webpack_require__(12).Pattern);
var TOKEN = {
  TAG_OPEN: 'TK_TAG_OPEN',
  TAG_CLOSE: 'TK_TAG_CLOSE',
  CONTROL_FLOW_OPEN: 'TK_CONTROL_FLOW_OPEN',
  CONTROL_FLOW_CLOSE: 'TK_CONTROL_FLOW_CLOSE',
  ATTRIBUTE: 'TK_ATTRIBUTE',
  EQUALS: 'TK_EQUALS',
  VALUE: 'TK_VALUE',
  COMMENT: 'TK_COMMENT',
  TEXT: 'TK_TEXT',
  UNKNOWN: 'TK_UNKNOWN',
  START: BASETOKEN.START,
  RAW: BASETOKEN.RAW,
  EOF: BASETOKEN.EOF
};
var directives_core = new Directives(/<\!--/, /-->/);
var Tokenizer = function(input_string, options) {
  BaseTokenizer.call(this, input_string, options);
  this._current_tag_name = '';
  var templatable_reader = new TemplatablePattern(this._input).read_options(this._options);
  var pattern_reader = new Pattern(this._input);
  this.__patterns = {
    word: templatable_reader.until(/[\n\r\t <]/),
    word_control_flow_close_excluded: templatable_reader.until(/[\n\r\t <}]/),
    single_quote: templatable_reader.until_after(/'/),
    double_quote: templatable_reader.until_after(/"/),
    attribute: templatable_reader.until(/[\n\r\t =>]|\/>/),
    element_name: templatable_reader.until(/[\n\r\t >\/]/),
    angular_control_flow_start: pattern_reader.matching(/\@[a-zA-Z]+[^({]*[({]/),
    handlebars_comment: pattern_reader.starting_with(/{{!--/).until_after(/--}}/),
    handlebars: pattern_reader.starting_with(/{{/).until_after(/}}/),
    handlebars_open: pattern_reader.until(/[\n\r\t }]/),
    handlebars_raw_close: pattern_reader.until(/}}/),
    comment: pattern_reader.starting_with(/<!--/).until_after(/-->/),
    cdata: pattern_reader.starting_with(/<!\[CDATA\[/).until_after(/]]>/),
    conditional_comment: pattern_reader.starting_with(/<!\[/).until_after(/]>/),
    processing: pattern_reader.starting_with(/<\?/).until_after(/\?>/)
  };
  if (this._options.indent_handlebars) {
    this.__patterns.word = this.__patterns.word.exclude('handlebars');
    this.__patterns.word_control_flow_close_excluded = this.__patterns.word_control_flow_close_excluded.exclude('handlebars');
  }
  this._unformatted_content_delimiter = null;
  if (this._options.unformatted_content_delimiter) {
    var literal_regexp = this._input.get_literal_regexp(this._options.unformatted_content_delimiter);
    this.__patterns.unformatted_content_delimiter =
      pattern_reader.matching(literal_regexp)
      .until_after(literal_regexp);
  }
};
Tokenizer.prototype = new BaseTokenizer();
Tokenizer.prototype._is_comment = function(current_token) {
  return false;
};
Tokenizer.prototype._is_opening = function(current_token) {
  return current_token.type === TOKEN.TAG_OPEN || current_token.type === TOKEN.CONTROL_FLOW_OPEN;
};
Tokenizer.prototype._is_closing = function(current_token, open_token) {
  return (current_token.type === TOKEN.TAG_CLOSE &&
    (open_token && (
      ((current_token.text === '>' || current_token.text === '/>') && open_token.text[0] === '<') ||
      (current_token.text === '}}' && open_token.text[0] === '{' && open_token.text[1] === '{')))
  ) || (current_token.type === TOKEN.CONTROL_FLOW_CLOSE &&
    (current_token.text === '}' && open_token.text.endsWith('{')));
};
Tokenizer.prototype._reset = function() {
  this._current_tag_name = '';
};
Tokenizer.prototype._get_next_token = function(previous_token, open_token) {
  var token = null;
  this._readWhitespace();
  var c = this._input.peek();
  if (c === null) {
    return this._create_token(TOKEN.EOF, '');
  }
  token = token || this._read_open_handlebars(c, open_token);
  token = token || this._read_attribute(c, previous_token, open_token);
  token = token || this._read_close(c, open_token);
  token = token || this._read_script_and_style(c, previous_token);
  token = token || this._read_control_flows(c, open_token);
  token = token || this._read_raw_content(c, previous_token, open_token);
  token = token || this._read_content_word(c, open_token);
  token = token || this._read_comment_or_cdata(c);
  token = token || this._read_processing(c);
  token = token || this._read_open(c, open_token);
  token = token || this._create_token(TOKEN.UNKNOWN, this._input.next());
  return token;
};
Tokenizer.prototype._read_comment_or_cdata = function(c) {
  var token = null;
  var resulting_string = null;
  var directives = null;
  if (c === '<') {
    var peek1 = this._input.peek(1);
    if (peek1 === '!') {
      resulting_string = this.__patterns.comment.read();
      if (resulting_string) {
        directives = directives_core.get_directives(resulting_string);
        if (directives && directives.ignore === 'start') {
          resulting_string += directives_core.readIgnored(this._input);
        }
      } else {
        resulting_string = this.__patterns.cdata.read();
      }
    }
    if (resulting_string) {
      token = this._create_token(TOKEN.COMMENT, resulting_string);
      token.directives = directives;
    }
  }
  return token;
};
Tokenizer.prototype._read_processing = function(c) {
  var token = null;
  var resulting_string = null;
  var directives = null;
  if (c === '<') {
    var peek1 = this._input.peek(1);
    if (peek1 === '!' || peek1 === '?') {
      resulting_string = this.__patterns.conditional_comment.read();
      resulting_string = resulting_string || this.__patterns.processing.read();
    }
    if (resulting_string) {
      token = this._create_token(TOKEN.COMMENT, resulting_string);
      token.directives = directives;
    }
  }
  return token;
};
Tokenizer.prototype._read_open = function(c, open_token) {
  var resulting_string = null;
  var token = null;
  if (!open_token || open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
    if (c === '<') {
      resulting_string = this._input.next();
      if (this._input.peek() === '/') {
        resulting_string += this._input.next();
      }
      resulting_string += this.__patterns.element_name.read();
      token = this._create_token(TOKEN.TAG_OPEN, resulting_string);
    }
  }
  return token;
};
Tokenizer.prototype._read_open_handlebars = function(c, open_token) {
  var resulting_string = null;
  var token = null;
  if (!open_token || open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
    if ((this._options.templating.includes('angular') || this._options.indent_handlebars) && c === '{' && this._input.peek(1) === '{') {
      if (this._options.indent_handlebars && this._input.peek(2) === '!') {
        resulting_string = this.__patterns.handlebars_comment.read();
        resulting_string = resulting_string || this.__patterns.handlebars.read();
        token = this._create_token(TOKEN.COMMENT, resulting_string);
      } else {
        resulting_string = this.__patterns.handlebars_open.read();
        token = this._create_token(TOKEN.TAG_OPEN, resulting_string);
      }
    }
  }
  return token;
};
Tokenizer.prototype._read_control_flows = function(c, open_token) {
  var resulting_string = '';
  var token = null;
  if (!this._options.templating.includes('angular')) {
    return token;
  }
  if (c === '@') {
    resulting_string = this.__patterns.angular_control_flow_start.read();
    if (resulting_string === '') {
      return token;
    }
    var opening_parentheses_count = resulting_string.endsWith('(') ? 1 : 0;
    var closing_parentheses_count = 0;
    while (!(resulting_string.endsWith('{') && opening_parentheses_count === closing_parentheses_count)) {
      var next_char = this._input.next();
      if (next_char === null) {
        break;
      } else if (next_char === '(') {
        openin