import type { PopperProps } from "..";
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Type
 * [PopperProps](https://github.com/themesberg/flowbite-svelte/blob/main/src/lib/types.ts#L1962)
 * ## Props
 * @prop triggeredBy
 * @prop triggerDelay = 200
 * @prop trigger = "click"
 * @prop placement = "top"
 * @prop offset = 8
 * @prop arrow = false
 * @prop yOnly = false
 * @prop strategy = "absolute"
 * @prop reference
 * @prop middlewares = [dom.flip(), dom.shift()]
 * @prop onbeforetoggle: _onbeforetoggle
 * @prop ontoggle: _ontoggle
 * @prop class: className = ""
 * @prop arrowClass = ""
 * @prop isOpen = $bindable(false)
 * @prop transitionParams
 * @prop transition = fade
 * @prop children
 * @prop ...restProps
 */
declare const Popper: import("svelte").Component<PopperProps, {}, "isOpen">;
type Popper = ReturnType<typeof Popper>;
export default Popper;
