import { tv } from "tailwind-variants";
export const checkbox = tv({
    slots: {
        base: "w-4 h-4 bg-gray-100 border-gray-300 dark:ring-offset-gray-800 focus:ring-2 me-2 rounded-sm",
        div: "flex items-center"
    },
    variants: {
        color: {
            // primary, secondary, gray, red, orange, amber, yellow, lime, green, emerald, teal, cyan, sky, blue, indigo, violet, purple, fuchsia, pink, rose
            primary: {
                base: "text-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600"
            },
            secondary: {
                base: "text-secondary-600 focus:ring-secondary-500 dark:focus:ring-secondary-600"
            },
            gray: {
                base: "text-gray-600 focus:ring-gray-600 dark:ring-offset-gray-800 dark:focus:ring-gray-600"
            },
            red: {
                base: "text-red-600 focus:ring-red-600 dark:ring-offset-red-600 dark:focus:ring-red-600"
            },
            orange: {
                base: "text-orange-600 focus:ring-orange-600 dark:ring-offset-orange-600 dark:focus:ring-orange-600"
            },
            amber: {
                base: "text-amber-600 focus:ring-amber-600 dark:ring-offset-amber-600 dark:focus:ring-amber-600"
            },
            yellow: {
                base: "text-yellow-400 focus:ring-yellow-400 dark:ring-offset-yellow-400 dark:focus:ring-yellow-400"
            },
            lime: {
                base: "text-lime-700 focus:ring-lime-700 dark:ring-offset-lime-700 dark:focus:ring-lime-700"
            },
            green: {
                base: "text-green-600 focus:ring-green-600 dark:ring-offset-green-600 dark:focus:ring-green-600"
            },
            emerald: {
                base: "text-emerald-600 focus:ring-emerald-600 dark:ring-offset-emerald-600 dark:focus:ring-emerald-600"
            },
            teal: {
                base: "text-teal-600 focus:ring-teal-600 dark:ring-offset-teal-600 dark:focus:ring-teal-600"
            },
            cyan: {
                base: "text-cyan-600 focus:ring-cyan-600 dark:ring-offset-cyan-600 dark:focus:ring-cyan-600"
            },
            sky: {
                base: "text-sky-600 focus:ring-sky-600 dark:ring-offset-sky-600 dark:focus:ring-sky-600"
            },
            blue: {
                base: "text-blue-700 focus:ring-blue-600 dark:ring-offset-blue-700 dark:focus:ring-blue-700"
            },
            indigo: {
                base: "text-indigo-700 focus:ring-indigo-700 dark:ring-offset-indigo-700 dark:focus:ring-indigo-700"
            },
            violet: {
                base: "text-violet-600 focus:ring-violet-600 dark:ring-offset-violet-600 dark:focus:ring-violet-600"
            },
            purple: {
                base: "text-purple-600 focus:ring-purple-600 dark:ring-offset-purple-600 dark:focus:ring-purple-600"
            },
            fuchsia: {
                base: "text-fuchsia-600 focus:ring-fuchsia-600 dark:ring-offset-fuchsia-600 dark:focus:ring-fuchsia-600"
            },
            pink: {
                base: "text-pink-600 focus:ring-pink-600 dark:ring-offset-pink-600 dark:focus:ring-pink-600"
            },
            rose: {
                base: "text-rose-600 focus:ring-rose-600 dark:ring-offset-rose-600 dark:focus:ring-rose-600"
            }
        },
        tinted: {
            true: { base: "dark:bg-gray-600 dark:border-gray-500" },
            false: { base: "dark:bg-gray-700 dark:border-gray-600" }
        },
        custom: {
            true: { base: "sr-only peer" }
        },
        rounded: {
            true: { base: "rounded-sm" }
        },
        inline: {
            true: {
                div: "inline-flex",
                false: "flex items-center"
            }
        },
        disabled: {
            true: {
                base: "cursor-not-allowed opacity-50 bg-gray-200 border-gray-300",
                div: "cursor-not-allowed opacity-70"
            }
        }
    },
    defaultVariants: {
        color: "primary",
        disabled: false
    }
});
export const checkboxbutton = tv({
    base: "",
    variants: {
        inline: {
            true: "inline-flex",
            false: "flex"
        },
        checked: {
            true: "outline-4 outline-green-500"
        }
    },
    defaultVariants: {
        inline: true
    }
});
