import { type BadgeProps } from "..";
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Type
 * [BadgeProps](https://github.com/themesberg/flowbite-svelte/blob/main/src/lib/types.ts#L215)
 * ## Props
 * @prop children
 * @prop icon
 * @prop badgeStatus = $bindable(true)
 * @prop color = "primary"
 * @prop large = false
 * @prop dismissable = false
 * @prop class: className
 * @prop border
 * @prop href
 * @prop target
 * @prop rounded
 * @prop transition = fade
 * @prop params
 * @prop aClass
 * @prop onclose
 * @prop ...restProps
 */
declare const Badge: import("svelte").Component<BadgeProps, {}, "badgeStatus">;
type Badge = ReturnType<typeof Badge>;
export default Badge;
