import type { Component } from 'svelte';
import type { SVGAttributes } from 'svelte/elements';
interface Props extends SVGAttributes<SVGElement> {
    Icon: Component;
    size?: 'xs' | 'sm' | 'md' | 'lg' | 'xl';
    role?: string;
    color?: string;
    ariaLabel?: string;
    strokeWidth?: string;
    class?: string;
}
/**
 * [Go to docs](https://flowbite-svelte-icons.codewithshin.com/)
 * ## Props
 * @prop Icon
 * @prop size
 * @prop role
 * @prop color = 'currentColor'
 * @prop ariaLabel
 * @prop strokeWidth
 * @prop class: classname
 * @prop ...restProps
 */
declare const IconSolid: Component<Props, {}, "">;
type IconSolid = ReturnType<typeof IconSolid>;
export default IconSolid;
