import * as parser from 'svelte-eslint-parser';
let pluginObject = null;
export function setPluginObject(plugin) {
    pluginObject = plugin;
}
const config = [
    {
        name: 'svelte:base:setup-plugin',
        plugins: {
            get svelte() {
                return pluginObject;
            }
        }
    },
    {
        name: 'svelte:base:setup-for-svelte',
        files: ['*.svelte', '**/*.svelte'],
        languageOptions: {
            parser
        },
        rules: {
            // ESLint core rules known to cause problems with `.svelte`.
            'no-inner-declarations': 'off', // The AST generated by svelte-eslint-parser will false positives in it rule because the root node of the script is not the `Program`.
            // "no-irregular-whitespace": "off",
            // Self assign is one of way to update reactive value in Svelte.
            'no-self-assign': 'off',
            // eslint-plugin-svelte rules
            'svelte/comment-directive': 'error',
            'svelte/system': 'error'
        },
        processor: 'svelte/svelte'
    },
    {
        name: 'svelte:base:setup-for-svelte-script',
        files: ['*.svelte.js', '*.svelte.ts', '**/*.svelte.js', '**/*.svelte.ts'],
        languageOptions: {
            parser
        },
        rules: {
        // eslint-plugin-svelte rules
        }
    }
];
export default config;
