/// <reference types="node" />
import { RequestOptions } from 'https';
import { UseQueryOptions, Query, QueryClient, UseMutationOptions } from 'react-query';
import { paths } from './apiSchema.generated';
import { RequestParamsType, ResponseContent } from './types';
import { HttpError } from './HttpError';
export type QueryProps<Url extends keyof Paths, Method extends keyof Paths[Url], Paths = paths> = {
    url: Url;
    method: Method;
    fetchOptions?: RequestOptions;
    options?: UseQueryOptions<ResponseContent<Url, Method, Paths>>;
} & RequestParamsType<Url, Method, Paths>;
export declare const useApiQuery: <Url extends keyof Paths, Method extends keyof Paths[Url], Paths = paths>(props: QueryProps<Url, Method, Paths>) => import("react-query").UseQueryResult<ResponseContent<Url, Method, Paths>, HttpError>;
export type MutationProps<Url extends keyof Paths, Method extends keyof Paths[Url], Paths = paths> = {
    url: Url;
    method: Method;
    fetchOptions?: RequestOptions;
    options?: UseMutationOptions<ResponseContent<Url, Method, Paths>, any, RequestParamsType<Url, Method, Paths>>;
    invalidatePrefix?: string;
};
export declare const useApiMutation: <Url extends keyof Paths, Method extends keyof Paths[Url], Paths = paths>(props: MutationProps<Url, Method, Paths>) => {
    mutate: import("react-query").UseMutateFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    mutateAsync: import("react-query").UseMutateAsyncFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    data: undefined;
    error: null;
    isError: false;
    isIdle: true;
    isLoading: false;
    isSuccess: false;
    status: "idle";
    reset: () => void;
    context: unknown;
    failureCount: number;
    isPaused: boolean;
    variables: RequestParamsType<Url, Method, Paths>;
} | {
    mutate: import("react-query").UseMutateFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    mutateAsync: import("react-query").UseMutateAsyncFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    data: undefined;
    error: null;
    isError: false;
    isIdle: false;
    isLoading: true;
    isSuccess: false;
    status: "loading";
    reset: () => void;
    context: unknown;
    failureCount: number;
    isPaused: boolean;
    variables: RequestParamsType<Url, Method, Paths>;
} | {
    mutate: import("react-query").UseMutateFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    mutateAsync: import("react-query").UseMutateAsyncFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    data: undefined;
    error: HttpError;
    isError: true;
    isIdle: false;
    isLoading: false;
    isSuccess: false;
    status: "error";
    reset: () => void;
    context: unknown;
    failureCount: number;
    isPaused: boolean;
    variables: RequestParamsType<Url, Method, Paths>;
} | {
    mutate: import("react-query").UseMutateFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    mutateAsync: import("react-query").UseMutateAsyncFunction<ResponseContent<Url, Method, Paths>, HttpError, RequestParamsType<Url, Method, Paths>, unknown>;
    data: ResponseContent<Url, Method, Paths>;
    error: null;
    isError: false;
    isIdle: false;
    isLoading: false;
    isSuccess: true;
    status: "success";
    reset: () => void;
    context: unknown;
    failureCount: number;
    isPaused: boolean;
    variables: RequestParamsType<Url, Method, Paths>;
};
export declare const matchUrlPrefix: (prefix: string) => {
    predicate: (query: Query) => boolean;
};
export declare const invalidateUrlPrefix: (queryClient: QueryClient, prefix: string) => Promise<void>;
