import React from 'react';
import { EditorView, KeyBinding } from '@codemirror/view';
import { Direction } from '@mui/material';
export type EditorProps = {
    value: string;
    onChange?: (val: string) => void;
    background?: string;
    mode: 'placeholders' | 'syntax' | 'plain';
    direction?: Direction;
    autofocus?: boolean;
    minHeight?: number | string;
    onBlur?: () => void;
    onFocus?: () => void;
    shortcuts?: KeyBinding[];
    autoScrollIntoView?: boolean;
    locale?: string;
    editorRef?: React.RefObject<EditorView | null>;
    examplePluralNum?: number;
    nested?: boolean;
    disabled?: boolean;
};
export declare const Editor: React.FC<EditorProps>;
