import { components } from '../../client/apiSchema.generated';
type ApiKeyPermissionsModel = components['schemas']['ApiKeyPermissionsModel'];
type LanguageModel = components['schemas']['LanguageModel'];
type KeyWithTranslationsModel = components['schemas']['KeyWithTranslationsModel'];
export declare const getComputedPermissions: (permissions: ApiKeyPermissionsModel | undefined, keyData: KeyWithTranslationsModel | undefined, availableLanguages: LanguageModel[] | undefined) => {
    canEditTags: boolean;
    canViewScreenshots: boolean;
    canUploadScreenshots: boolean;
    canDeleteScreenshots: boolean;
    canSubmitForm: true | {
        number: number;
        languageId: number;
        languageTag: string;
        done: boolean;
        userAssigned: boolean;
        type: "TRANSLATE" | "REVIEW";
    };
    canSendBigMeta: boolean;
    canEditPlural: boolean;
    canEditState: (language: string) => boolean;
    canEditTranslation: (language: string) => boolean;
};
export declare const useComputedPermissions: (permissions: ApiKeyPermissionsModel | undefined, keyData: KeyWithTranslationsModel | undefined, availableLanguages: LanguageModel[] | undefined) => {
    canEditTags: boolean;
    canViewScreenshots: boolean;
    canUploadScreenshots: boolean;
    canDeleteScreenshots: boolean;
    canSubmitForm: true | {
        number: number;
        languageId: number;
        languageTag: string;
        done: boolean;
        userAssigned: boolean;
        type: "TRANSLATE" | "REVIEW";
    };
    canSendBigMeta: boolean;
    canEditPlural: boolean;
    canEditState: (language: string) => boolean;
    canEditTranslation: (language: string) => boolean;
};
export {};
