import { BackendDevMiddleware, TranslatePropsInternal, HighlightInterface, LanguageDetectorMiddleware, LanguageStorageMiddleware, ChangeTranslationInterface, WrapperWrapProps, Unwrapped, KeyAndNamespacesInternal, TolgeePlugin, TolgeeInstance, TolgeeOptionsInternal, FindPositionsInterface, BackendGetRecordInternal } from '../../types';
import { EventsInstance } from '../Events/Events';
export declare function Plugins(getLanguage: () => string | undefined, getInitialOptions: () => TolgeeOptionsInternal, getAvailableLanguages: () => string[] | undefined, getFallbackNamespaces: (ns: string | undefined) => string[], getTranslationNs: (props: KeyAndNamespacesInternal) => string[], getTranslation: (props: KeyAndNamespacesInternal) => string | undefined, changeTranslation: ChangeTranslationInterface, events: EventsInstance): Readonly<{
    addPlugin: (tolgeeInstance: TolgeeInstance, plugin: TolgeePlugin) => void;
    findPositions: FindPositionsInterface;
    run(): void;
    stop(): void;
    getLanguageStorage(): LanguageStorageMiddleware | undefined;
    getInitialLanguage(): string | Promise<string | undefined> | Promise<string | Promise<string | undefined> | undefined> | undefined;
    setStoredLanguage(language: string): void | Promise<void | undefined> | undefined;
    getDevBackend(): BackendDevMiddleware | undefined;
    getBackendRecord: BackendGetRecordInternal;
    getBackendDevRecord: BackendGetRecordInternal;
    getLanguageDetector(): LanguageDetectorMiddleware | undefined;
    retranslate(): void;
    highlight: HighlightInterface;
    unwrap(text: string): Unwrapped;
    wrap(params: WrapperWrapProps): string | undefined;
    hasDevBackend(): boolean;
    formatTranslation({ formatEnabled, ...props }: {
        key: import("../../types").TranslationKey;
        defaultValue?: string | undefined;
        params?: import("../../types").TranslateParams<import("../../types").DefaultParamType> | undefined;
    } & import("../../types").TranslateOptions & {
        translation?: string | undefined;
    } & {
        formatEnabled?: boolean | undefined;
    }): string;
}>;
export type PluginsInstance = ReturnType<typeof Plugins>;
