export const mapImportFormat = (format, extension) => {
    switch (format) {
        case 'APPLE_STRINGS': {
            // apple separates translations to two separate files
            // we keep it under one format for the cli
            if (extension === '.stringsdict') {
                return 'STRINGSDICT';
            }
            else {
                return 'STRINGS';
            }
        }
        case 'JSON_TOLGEE':
            return 'JSON_ICU';
        default:
            return format !== null && format !== void 0 ? format : 'JSON_ICU';
    }
};
