var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import ansi from 'ansi-colors';
import { loadStore } from '../config/credentials.js';
function getProjectName(projectId, projectDetails) {
    var _a;
    return (_a = projectDetails === null || projectDetails === void 0 ? void 0 : projectDetails[projectId]) === null || _a === void 0 ? void 0 : _a.name;
}
function printToken(type, token, projectId, projectDetails) {
    let result = type === 'PAK' ? ansi.green('PAK') : ansi.blue('PAT');
    if (projectId !== undefined) {
        const projectName = getProjectName(projectId, projectDetails);
        result += '\t ' + ansi.red(`#${projectId}` + ' ' + (projectName !== null && projectName !== void 0 ? projectName : ''));
    }
    else {
        result += '\t ' + ansi.yellow('<all projects>');
    }
    if (token.expires) {
        result +=
            '\t ' +
                ansi.grey('expires ' + new Date(token.expires).toLocaleDateString());
    }
    else {
        result += '\t ' + ansi.grey('never expires');
    }
    console.log(result);
}
export function printApiKeyLists() {
    return __awaiter(this, void 0, void 0, function* () {
        const store = yield loadStore();
        const list = Object.entries(store);
        if (list.length === 0) {
            console.log(ansi.gray('No records\n'));
        }
        for (const [origin, server] of list) {
            console.log(ansi.white('[') + ansi.red(origin) + ansi.white(']'));
            if (server.user) {
                printToken('PAT', server.user);
            }
            if (server.projects) {
                for (const [project, token] of Object.entries(server.projects)) {
                    if (token) {
                        printToken('PAK', token, project, server.projectDetails);
                    }
                }
            }
            console.log('\n');
        }
        return;
    });
}
