var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { fileURLToPath } from 'url';
import { extname, resolve } from 'path';
import { isMainThread, parentPort, SHARE_ENV, Worker } from 'worker_threads';
import { readFileSync } from 'fs';
import internalExtractor from './extractor.js';
import { loadModule } from '../utils/moduleLoader.js';
import { createDeferred } from '../utils/deferred.js';
const FILE_TIME_LIMIT = 60 * 1000; // one minute
const IS_TSX = extname(import.meta.url) === '.ts';
// --- Worker functions
let extractor;
function handleJob(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const file = resolve(args.file);
        const code = readFileSync(file, 'utf8');
        if ('extractor' in args) {
            if (!extractor) {
                extractor = yield loadModule(args.extractor).then((mdl) => mdl.default);
            }
            return extractor(code, file, args.options);
        }
        return internalExtractor(code, file, args.parserType, args.options);
    });
}
function workerInit() {
    parentPort.on('message', (params) => {
        handleJob(params)
            .then((res) => parentPort.postMessage({ data: res }))
            .catch((e) => parentPort.postMessage({ err: e }));
    });
}
if (!isMainThread)
    workerInit();
// --- Main thread functions
let worker;
const jobQueue = [];
function createWorker() {
    let worker;
    if (IS_TSX) {
        worker = new Worker(`import('tsx/esm/api').then(({ register }) => { register(); import('${fileURLToPath(new URL(import.meta.url))}') })`, {
            env: SHARE_ENV,
            eval: true,
        });
    }
    else {
        worker = new Worker(fileURLToPath(new URL(import.meta.url)), {
            env: SHARE_ENV,
        });
    }
    let timeout;
    let currentDeferred;
    function workOrDie() {
        const job = jobQueue.shift();
        if (!job) {
            worker.terminate();
            return;
        }
        worker.postMessage(job[0]);
        currentDeferred = job[1];
        timeout = setTimeout(() => {
            worker.terminate();
            currentDeferred.reject(new Error(`Time limit for parsing ${job[0].file} exceeded`));
        }, FILE_TIME_LIMIT);
    }
    worker.on('message', (msg) => {
        if ('data' in msg) {
            currentDeferred.resolve(msg.data);
        }
        else {
            currentDeferred.reject(msg.err);
        }
        clearTimeout(timeout);
        workOrDie();
    });
    workOrDie();
    return worker;
}
export function callWorker(params) {
    return __awaiter(this, void 0, void 0, function* () {
        const deferred = createDeferred();
        jobQueue.push([params, deferred]);
        if (!worker) {
            worker = createWorker();
        }
        return deferred.promise;
    });
}
