var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { glob } from 'tinyglobby';
import { extname } from 'path';
import { callWorker } from './worker.js';
import { exitWithError } from '../utils/logger.js';
function parseVerbose(v) {
    return Array.isArray(v) ? v : v ? [] : undefined;
}
export function extractKeysFromFile(file, parserType, options, extractor) {
    return __awaiter(this, void 0, void 0, function* () {
        if (typeof extractor !== 'undefined') {
            return callWorker({
                extractor,
                file,
                options,
            });
        }
        else if (typeof parserType !== 'undefined') {
            return callWorker({
                parserType,
                file,
                options,
            });
        }
        throw new Error('Internal error: neither the parser type nor a custom extractors have been defined! Please report this.');
    });
}
export function findPossibleFrameworks(fileNames) {
    const possibleFrameworks = [];
    const extensions = new Set(fileNames.map((name) => {
        if (name.endsWith('.component.html')) {
            return '.component.html';
        }
        else {
            return extname(name);
        }
    }));
    if (extensions.has('.jsx') || extensions.has('.tsx')) {
        possibleFrameworks.push('react');
    }
    if (extensions.has('.vue')) {
        possibleFrameworks.push('vue');
    }
    if (extensions.has('.svelte')) {
        possibleFrameworks.push('svelte');
    }
    if (extensions.has('.component.html')) {
        possibleFrameworks.push('ngx');
    }
    return possibleFrameworks;
}
function detectParserType(fileNames) {
    const possibleFrameworks = findPossibleFrameworks(fileNames);
    if (possibleFrameworks.length === 1) {
        return possibleFrameworks[0];
    }
    else if (possibleFrameworks.length === 0) {
        exitWithError("Couldn't detect which framework is used, use '--parser' or 'config.parser' option");
    }
    else {
        exitWithError(`Detected multiple possible frameworks used (${possibleFrameworks.join(', ')}), use '--parser' or 'config.parser' options`);
    }
}
export function extractKeysOfFiles(opts) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        if (!((_a = opts.patterns) === null || _a === void 0 ? void 0 : _a.length)) {
            exitWithError("Missing '--patterns' or 'config.patterns' option");
        }
        const files = yield glob(opts.patterns, { onlyFiles: true });
        if (files.length === 0) {
            exitWithError('No files were matched for extraction');
        }
        let parserType = opts.parser;
        if (!parserType && !opts.extractor) {
            parserType = detectParserType(files);
        }
        const result = new Map();
        const options = {
            strictNamespace: Boolean(opts.strictNamespace),
            defaultNamespace: opts.defaultNamespace,
            verbose: parseVerbose(opts.verbose),
        };
        yield Promise.all(files.map((file) => __awaiter(this, void 0, void 0, function* () {
            const keys = yield extractKeysFromFile(file, parserType, options, opts.extractor);
            result.set(file, keys);
        })));
        return result;
    });
}
export function filterExtractionResult(data) {
    const result = Object.create(null);
    for (const { keys } of data.values()) {
        for (const key of keys) {
            const namespace = key.namespace || '';
            if (!(namespace in result)) {
                result[namespace] = new Map();
            }
            result[namespace].set(key.keyName, key.defaultValue || null);
        }
    }
    return result;
}
