const SERVICE_NAME_POSSIBILITIES = ['translateService'];
const TRANSLATE_FUNCTION_NAMES = ['translate', 'instant', 'get'];
// translateService.translate('key1', 'default-1', { ns: 'ns-1' })
export const translateMerger = {
    initial: 0 /* S.Idle */,
    step: (state, t, end) => {
        const type = t.customType;
        const token = t.token;
        switch (state) {
            case 0 /* S.Idle */:
                if (['variable', 'function.call.pipe'].includes(type) &&
                    SERVICE_NAME_POSSIBILITIES.includes(token)) {
                    return 2 /* S.ExpectDot */;
                }
                break;
            case 2 /* S.ExpectDot */:
                if (type === 'acessor.dot') {
                    return 3 /* S.ExpectCall */;
                }
                break;
            case 3 /* S.ExpectCall */:
                if (type === 'function.call' &&
                    TRANSLATE_FUNCTION_NAMES.includes(token)) {
                    return 1 /* S.ExpectBracket */;
                }
                break;
            case 1 /* S.ExpectBracket */:
                if (type === 'expression.begin') {
                    return end.MERGE_CUSTOM;
                }
        }
    },
    customType: 'trigger.translate.function',
    customMerge(tokens) {
        return {
            before: tokens.slice(0, -2),
            toMerge: tokens.slice(-2),
            after: [],
        };
    },
};
