import { parseGeneral } from '../../../../extractor/parser/tree/parseGeneral.js';
/*
 * :{ noWrap: true }:'item'
 * ^----------------------^
 */
export function parsePipeArgs(context, end) {
    const { tokens, getCurrentLine } = context;
    const line = getCurrentLine();
    const result = { type: 'array', line, values: [] };
    let token;
    while ((token = tokens.current())) {
        if (end.includes(token.customType)) {
            break;
        }
        switch (token.customType) {
            case 'operator.navigator':
                tokens.next();
                break;
            default:
                result.values.push(parseGeneral(context, {
                    end: ['operator.navigator', ...end],
                }));
        }
    }
    return result;
}
