import { parseTag } from '../../parser/tree/parseTag.js';
// <div t key="test"></div>
// ^-----------------^^^^^^
export const componentWithT = {
    trigger: 'trigger.component.with.t',
    call(context) {
        const { getCurrentLine } = context;
        const line = getCurrentLine();
        context.tokens.next();
        const { props, child } = parseTag(context);
        if (props.type !== 'dict' || !props.value['t']) {
            const result = { type: 'array', line, values: [props] };
            if (child) {
                result.values.push(child);
            }
            return result;
        }
        else {
            const result = {
                type: 'keyInfo',
                line,
                dependsOnContext: false,
                values: [],
            };
            for (const [key, value] of Object.entries(props.value)) {
                switch (key) {
                    case 'key':
                        result.keyName = value;
                        break;
                    case 'default':
                        result.defaultValue = value;
                        break;
                    case 'ns':
                        result.namespace = value;
                        break;
                    default:
                        result.values.push(value);
                }
            }
            return result;
        }
    },
};
