import { simplifyNode } from '../parser/nodeUtils.js';
function transformRecursive(root) {
    if (!root) {
        return;
    }
    switch (root.type) {
        case 'expr':
        case 'array':
            root.values.forEach((item, i) => {
                var _a, _b;
                if (item.type === 'keyInfo' && item.keyName === undefined) {
                    const nodeBefore = simplifyNode(root.values[i - 1]);
                    if (nodeBefore.type === 'dict') {
                        item.keyName = nodeBefore.value['key'];
                        item.namespace = (_a = nodeBefore.value['ns']) !== null && _a !== void 0 ? _a : item.namespace;
                        item.defaultValue =
                            (_b = nodeBefore.value['defaultValue']) !== null && _b !== void 0 ? _b : item.defaultValue;
                    }
                    else {
                        item.keyName = nodeBefore;
                    }
                }
                transformRecursive(item);
            });
            break;
        case 'dict':
            Object.values(root.value).forEach(transformRecursive);
            root.unknown.forEach(transformRecursive);
            break;
        case 'keyInfo':
            transformRecursive(root.defaultValue);
            transformRecursive(root.keyName);
            transformRecursive(root.namespace);
            root.values.forEach(transformRecursive);
            break;
        case 'nsInfo':
            transformRecursive(root.name);
            root.values.forEach(transformRecursive);
            break;
        case 'primitive':
            return;
    }
}
export const ngxTreeTransform = (root) => {
    transformRecursive(root);
    return { tree: root, report: { keys: [], warnings: [] } };
};
