import { parseGeneral } from './parseGeneral.js';
// <T keyName="key1" defaultValue="default value" />
// ^^–––––––––––––––––––––––––––––^^^^^^^^^^^^^^^
export function extractProps(context) {
    function getShortHandValue() {
        return { type: 'primitive', line: getCurrentLine(), value: true };
    }
    const { tokens, getCurrentLine } = context;
    const line = getCurrentLine();
    tokens.next();
    const result = { type: 'dict', line, value: {}, unknown: [] };
    let token;
    let state = 0 /* S.ExpectAttribute */;
    let lastKey;
    while ((token = tokens.current())) {
        const type = token.customType;
        if (type === 'tag.self-closing.end' || type === 'tag.regular.end') {
            break;
        }
        switch (state) {
            case 0 /* S.ExpectAttribute */:
                if (type === 'tag.attribute.name') {
                    lastKey = token.token;
                    state = 1 /* S.ExpectAssign */;
                    // assign in case it's shorthand
                    result.value[lastKey] = getShortHandValue();
                }
                break;
            case 1 /* S.ExpectAssign */:
                if (type === 'operator.assignment') {
                    state = 2 /* S.ExpectValue */;
                }
                else if (type === 'tag.attribute.name') {
                    // last one was shorthand
                    lastKey = token.token;
                    state = 1 /* S.ExpectAssign */;
                    // assign in case it's shorthand
                    result.value[lastKey] = getShortHandValue();
                }
                break;
            case 2 /* S.ExpectValue */:
                result.value[lastKey] = parseGeneral(context, {
                    end: [
                        'tag.attribute.name',
                        'tag.self-closing.end',
                        'tag.regular.end',
                    ],
                });
                state = 0 /* S.ExpectAttribute */;
                lastKey = undefined;
                continue;
        }
        tokens.next();
    }
    return result;
}
