export const templateStringMerger = {
    initial: 0 /* S.Idle */,
    step: (state, token, end) => {
        const type = token.customType;
        switch (state) {
            case 0 /* S.Idle */:
                if (type === 'string.template') {
                    return 1 /* S.Merging */;
                }
                else if (type === 'expression.template.begin') {
                    return 2 /* S.ExpectingExpression */;
                }
                break;
            case 1 /* S.Merging */:
                if (type === 'string.template') {
                    return 1 /* S.Merging */;
                }
                else if (type === 'expression.template.begin') {
                    return 2 /* S.ExpectingExpression */;
                }
                else {
                    return end.MERGE_WITHOUT_LAST;
                }
            case 2 /* S.ExpectingExpression */:
                if (type === 'string') {
                    return 3 /* S.ExpectingEndBrace */;
                }
                break;
            case 3 /* S.ExpectingEndBrace */:
                if (type === 'expression.template.end') {
                    return 1 /* S.Merging */;
                }
                break;
        }
    },
    customType: 'string',
    resultToken: (matched) => {
        const result = [];
        for (const token of matched) {
            if (token.customType === 'string.template') {
                // Match and remove leading whitespace except for newlines
                let value = token.token.replace(/^[^\S\n]+/gm, '');
                // Match and remove trailing whitespace except for newlines
                value = value.replace(/[^\S\n]+$/gm, '');
                // replace multiple newlines with one space
                value = value.replace(/[\n]+/gm, ' ');
                result.push(value);
            }
            else if (token.customType === 'string') {
                result.push(token.token);
            }
        }
        return { token: result.join('').trim() };
    },
};
