import unescape from 'unescape-js';
export const stringMerger = {
    initial: 0 /* S.Idle */,
    step: (state, token, end) => {
        const type = token.customType;
        switch (state) {
            case 0 /* S.Idle */:
                if (type === 'string.quote') {
                    return 1 /* S.RegularString */;
                }
                else if (type === 'string.teplate.quote') {
                    return 2 /* S.TemplateString */;
                }
                break;
            case 1 /* S.RegularString */:
                if (type === 'string.body') {
                    return 1 /* S.RegularString */;
                }
                else if (type === 'escaped.character') {
                    return 1 /* S.RegularString */;
                }
                else if (type === 'string.quote') {
                    return end.MERGE_ALL;
                }
                break;
            case 2 /* S.TemplateString */:
                if (type === 'string.template.body') {
                    return 2 /* S.TemplateString */;
                }
                else if (type === 'escaped.character') {
                    return 2 /* S.TemplateString */;
                }
                else if (type === 'string.template.quote') {
                    return end.MERGE_ALL;
                }
                break;
        }
    },
    customType: 'string',
    resultToken: (matched) => {
        const escaped = matched
            .map((t) => {
            switch (t.customType) {
                case 'string.template.body':
                case 'string.body':
                case 'escaped.character':
                    return t.token;
                default:
                    return '';
            }
        })
            .join('');
        return { token: unescape(escaped) };
    },
};
