export const commentsMerger = {
    initial: 0 /* S.Idle */,
    step: (state, token, end) => {
        const type = token.customType;
        switch (state) {
            case 0 /* S.Idle */:
                if (type === 'comment.definition') {
                    return 1 /* S.CommentStart */;
                }
                break;
            case 1 /* S.CommentStart */:
                if (type === 'comment.line') {
                    return end.MERGE_ALL;
                }
                else if (type === 'comment.block' || token.token === '\n') {
                    return 2 /* S.CommentBlock */;
                }
                break;
            case 2 /* S.CommentBlock */:
                if (type === 'comment.block' || token.token === '\n') {
                    return 2 /* S.CommentBlock */;
                }
                else if (type === 'comment.definition') {
                    return end.MERGE_ALL;
                }
                break;
        }
    },
    resultToken: (matched) => {
        return {
            token: matched
                .filter((t) => t.customType && t.customType !== 'comment.definition')
                .map((t) => t.token)
                .join(''),
            line: matched[matched.length - 1].line,
        };
    },
    customType: 'comment',
};
