var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Command, Option } from 'commander';
import { handleLoadableError } from '../client/TolgeeClient.js';
import { exitWithError, loading, success } from '../utils/logger.js';
import { extractKeysOfFiles } from '../extractor/runner.js';
const tagHandler = (config) => function () {
    return __awaiter(this, void 0, void 0, function* () {
        const opts = this.optsWithGlobals();
        let extractedKeys;
        if (opts.filterExtracted || opts.filterNotExtracted) {
            if (opts.filterExtracted && opts.filterNotExtracted) {
                exitWithError('Use either "--filter-extracted" or "--filter-not-extracted", not both');
            }
            const extracted = yield loading('Analyzing code...', extractKeysOfFiles(opts));
            const keys = [...extracted.values()].flatMap((item) => item.keys);
            extractedKeys = keys.map((key) => ({
                name: key.keyName,
                namespace: key.namespace,
            }));
        }
        const loadable = yield loading('Tagging...', opts.client.PUT('/v2/projects/{projectId}/tag-complex', {
            params: { path: { projectId: opts.client.getProjectId() } },
            body: {
                filterTag: opts.filterTag,
                filterTagNot: opts.filterNoTag,
                tagFiltered: opts.tag,
                tagOther: opts.tagOther,
                untagFiltered: opts.untag,
                untagOther: opts.untagOther,
                filterKeys: opts.filterExtracted ? extractedKeys : undefined,
                filterKeysNot: opts.filterNotExtracted ? extractedKeys : undefined,
            },
        }));
        handleLoadableError(loadable);
        success('Done!');
    });
};
export default (config) => {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    return new Command('tag')
        .description('Update tags in your project.')
        .addOption(new Option('--filter-extracted', 'Extract keys from code and filter by it.').default((_a = config.tag) === null || _a === void 0 ? void 0 : _a.filterExtracted))
        .addOption(new Option('--filter-not-extracted', 'Extract keys from code and filter them out.').default((_b = config.tag) === null || _b === void 0 ? void 0 : _b.filterNotExtracted))
        .addOption(new Option('--filter-tag <tags...>', 'Filter only keys with tag. Use * as a wildcard.').default((_c = config.tag) === null || _c === void 0 ? void 0 : _c.filterTag))
        .addOption(new Option('--filter-no-tag <tags...>', 'Filter only keys without tag. Use * as a wildcard.').default((_d = config.tag) === null || _d === void 0 ? void 0 : _d.filterNoTag))
        .addOption(new Option('--tag <tags...>', 'Add tag to filtered keys.').default((_e = config.tag) === null || _e === void 0 ? void 0 : _e.tag))
        .addOption(new Option('--tag-other <tags...>', 'Tag keys which are not filtered.').default((_f = config.tag) === null || _f === void 0 ? void 0 : _f.tagOther))
        .addOption(new Option('--untag <tags...>', 'Remove tag from filtered keys. Use * as a wildcard.').default((_g = config.tag) === null || _g === void 0 ? void 0 : _g.untag))
        .addOption(new Option('--untag-other <tags...>', 'Remove tag from keys which are not filtered. Use * as a wildcard.').default((_h = config.tag) === null || _h === void 0 ? void 0 : _h.untagOther))
        .action(tagHandler(config));
};
