var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import createClient from 'openapi-fetch';
import base32Decode from 'base32-decode';
import { API_KEY_PAK_PREFIX, USER_AGENT } from '../constants.js';
import { getApiKeyInformation } from './getApiKeyInformation.js';
import { debug, isDebugEnabled } from '../utils/logger.js';
import { errorFromLoadable } from './errorFromLoadable.js';
function parseResponse(response, parseAs) {
    return __awaiter(this, void 0, void 0, function* () {
        // handle empty content
        // note: we return `{}` because we want user truthy checks for `.data` or `.error` to succeed
        if (response.status === 204 ||
            response.headers.get('Content-Length') === '0') {
            return response.ok ? { data: {}, response } : { error: {}, response };
        }
        // parse response (falling back to .text() when necessary)
        if (response.ok) {
            // if "stream", skip parsing entirely
            if (parseAs === 'stream') {
                return { data: response.body, response };
            }
            return { data: yield response[parseAs](), response };
        }
        // handle errors
        let error = yield response.text();
        try {
            error = JSON.parse(error); // attempt to parse as JSON
        }
        catch (_a) {
            // noop
        }
        return { error, response };
    });
}
export function projectIdFromKey(key) {
    if (!key.startsWith(API_KEY_PAK_PREFIX)) {
        return undefined;
    }
    const keyBuffer = base32Decode(key.slice(API_KEY_PAK_PREFIX.length).toUpperCase(), 'RFC4648');
    const decoded = Buffer.from(keyBuffer).toString('utf8');
    return Number(decoded.split('_')[0]);
}
export function createApiClient({ baseUrl, apiKey, projectId, autoThrow = false, }) {
    const computedProjectId = projectId !== null && projectId !== void 0 ? projectId : (apiKey ? projectIdFromKey(apiKey) : undefined);
    const apiClient = createClient({
        baseUrl,
        headers: {
            'user-agent': USER_AGENT,
            'x-api-key': apiKey,
        },
    });
    apiClient.use({
        onRequest: ({ request }) => {
            debug(`[HTTP] Requesting: ${request.method} ${request.url}`);
        },
        onResponse: (_a) => __awaiter(this, [_a], void 0, function* ({ response, options }) {
            let responseText = `[HTTP] Response: ${response.url} [${response.status}]`;
            const apiVersion = response.headers.get('x-tolgee-version');
            if (apiVersion) {
                responseText += ` [${response.headers.get('x-tolgee-version')}]`;
            }
            if (!response.ok && isDebugEnabled()) {
                const clonedBody = yield response.clone().text();
                if (clonedBody) {
                    responseText += ` [${clonedBody}]`;
                }
            }
            debug(responseText);
            if (autoThrow && !response.ok) {
                const loadable = yield parseResponse(response, options.parseAs);
                throw new Error(`Tolgee request error ${response.url} ${errorFromLoadable(loadable)}`);
            }
        }),
    });
    return Object.assign(Object.assign({}, apiClient), { getProjectId() {
            return computedProjectId;
        },
        getApiKeyInfo() {
            return getApiKeyInformation(apiClient, apiKey);
        },
        getSettings() {
            return { baseUrl, apiKey, projectId, autoThrow };
        } });
}
