use std::cmp::max;

use sea_orm::DeriveIden;
use serde::{Deserialize, Serialize};
use strum::{EnumCount, EnumIter};
use ts_rs::TS;

use crate::character_data::CharacterData;

#[derive(
    PartialEq,
    Clone,
    Copy,
    Serialize,
    Deserialize,
    EnumIter,
    EnumCount,
    DeriveIden,
    Debug,
    TS,
    Hash,
    Eq,
)]
#[ts(export)]
pub enum RewardEnum {
    AncientCloseFitting,
    AncientCunningMake,
    BitingDart,
    Cleaving,
    CloseFitting,
    CunningMake,
    CurseOfWeakness,
    Darken,
    Fell,
    FlameOfHope,
    FoeSlaying,
    GleamOfTerror,
    Grievous,
    Hammering,
    HollowSteel,
    Hunted,
    IllLuck,
    IllOmen,
    Keen,
    Luminescence,
    Malice,
    MithrilArmour,
    MithrilHelm,
    MithrilShield,
    MithrilWeapon,
    Owned,
    Reinforced,
    RuneScoredArmour,
    RuneScoredHelm,
    RuneScoredShield,
    RuneScoredWeapon,
    ShadowTaint,
    StraightFlight,
    SuperiorFellElven,
    SuperiorFellNumenorean,
    SuperiorGrievousDwarven,
    SuperiorGrievousNumenorean,
    SuperiorKeenDwarven,
    SuperiorKeenElven,
    SuperiorReinforcedDwarven,
    SuperiorReinforcedElvenOrNumenorean,
    Weakening,
}

impl RewardEnum {
    pub fn decrease_load(&self, data: &CharacterData) -> u32 {
        // Mithril armour cannot be implemented here
        if matches!(self, RewardEnum::AncientCunningMake) {
            max(3, data.valor)
        } else if matches!(self, RewardEnum::CunningMake) {
            2
        } else {
            0
        }
    }

    pub fn increase_injury(&self, _data: &CharacterData) -> u32 {
        if *self == RewardEnum::SuperiorFellElven {
            4
        } else if matches!(self, RewardEnum::Fell | RewardEnum::SuperiorFellNumenorean) {
            2
        } else {
            0
        }
    }

    pub fn increase_damage(&self, _attributes: &CharacterData, combat_proficiency: u32) -> u32 {
        if *self == RewardEnum::SuperiorGrievousDwarven {
            2
        } else if matches!(
            self,
            RewardEnum::Grievous | RewardEnum::SuperiorGrievousNumenorean
        ) {
            1
        } else if matches!(self, RewardEnum::MithrilWeapon) {
            max(1, combat_proficiency)
        } else {
            0
        }
    }

    pub fn increase_parry(&self, _data: &CharacterData) -> u32 {
        if *self == RewardEnum::SuperiorReinforcedDwarven {
            2
        } else if matches!(
            self,
            RewardEnum::Reinforced | RewardEnum::SuperiorReinforcedElvenOrNumenorean
        ) {
            1
        } else {
            0
        }
    }
}
