use sea_orm::DeriveIden;
use serde::{Deserialize, Serialize};
use strum::{EnumCount, EnumIter};
use ts_rs::TS;

#[derive(
    Serialize, DeriveIden, Deserialize, Clone, Debug, Hash, Eq, PartialEq, EnumIter, EnumCount, TS,
)]
#[ts(export)]
pub enum CultureEnum {
    Barding,
    Beorning,
    DwarfOfDurinsFolk,
    DwarfOfNogrodOrBelegost,
    ElfOfLindon,
    ElfOfLorien,
    ElfOfMirkwood,
    HighElfOfRivendell,
    HobbitOfBree,
    HobbitOfTheShire,
    ManOfBree,
    RangerOfTheNorth,
    WoodmanOfWilderland,
}

impl CultureEnum {
    pub fn get_starting_eye(&self) -> u32 {
        match self {
            Self::Barding
            | Self::Beorning
            | Self::HobbitOfBree
            | Self::HobbitOfTheShire
            | Self::ManOfBree
            | Self::WoodmanOfWilderland => 0,
            Self::DwarfOfDurinsFolk | Self::DwarfOfNogrodOrBelegost => 1,
            Self::ElfOfLindon | Self::ElfOfMirkwood | Self::ElfOfLorien => 2,
            Self::RangerOfTheNorth | Self::HighElfOfRivendell => 3,
        }
    }
}
