/*************************************************************************/
/*  path_editor_plugin.h                                                 */
/*************************************************************************/
/*                       This file is part of:                           */
/*                           GODOT ENGINE                                */
/*                    http://www.godotengine.org                         */
/*************************************************************************/
/* Copyright (c) 2007-2016 Juan Linietsky, Ariel Manzur.                 */
/*                                                                       */
/* Permission is hereby granted, free of charge, to any person obtaining */
/* a copy of this software and associated documentation files (the       */
/* "Software"), to deal in the Software without restriction, including   */
/* without limitation the rights to use, copy, modify, merge, publish,   */
/* distribute, sublicense, and/or sell copies of the Software, and to    */
/* permit persons to whom the Software is furnished to do so, subject to */
/* the following conditions:                                             */
/*                                                                       */
/* The above copyright notice and this permission notice shall be        */
/* included in all copies or substantial portions of the Software.       */
/*                                                                       */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY  */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,  */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE     */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                */
/*************************************************************************/
#ifndef PATH_EDITOR_PLUGIN_H
#define PATH_EDITOR_PLUGIN_H


#include "tools/editor/spatial_editor_gizmos.h"
#include "scene/3d/path.h"
class PathSpatialGizmo  : public SpatialGizmoTool {

	OBJ_TYPE(PathSpatialGizmo,SpatialGizmoTool);

	Path* path;
	mutable Vector3 original;

public:

	virtual String get_handle_name(int p_idx) const;
	virtual Variant get_handle_value(int p_idx) const;
	virtual void set_handle(int p_idx,Camera *p_camera, const Point2& p_point);
	virtual void commit_handle(int p_idx,const Variant& p_restore,bool p_cancel=false);

	void redraw();
	PathSpatialGizmo(Path* p_path=NULL);

};

class PathEditorPlugin : public EditorPlugin {

	OBJ_TYPE( PathEditorPlugin, EditorPlugin );


	Separator *sep;
	ToolButton *curve_create;
	ToolButton *curve_edit;
	ToolButton *curve_del;
	ToolButton *curve_close;

	EditorNode *editor;


	Path *path;

	void _mode_changed(int p_idx);
    void _close_curve();
protected:
	void _notification(int p_what);
	static void _bind_methods();

public:

	Path *get_edited_path() { return path; }

	static PathEditorPlugin* singleton;
	Ref<FixedMaterial> path_material;
	Ref<FixedMaterial> path_thin_material;
	virtual bool forward_spatial_input_event(Camera* p_camera,const InputEvent& p_event);

//	virtual bool forward_input_event(const InputEvent& p_event) { return collision_polygon_editor->forward_input_event(p_event); }
	virtual bool create_spatial_gizmo(Spatial* p_spatial);
	virtual String get_name() const { return "Path"; }
	bool has_main_screen() const { return false; }
	virtual void edit(Object *p_node);
	virtual bool handles(Object *p_node) const;
	virtual void make_visible(bool p_visible);

	PathEditorPlugin(EditorNode *p_node);
	~PathEditorPlugin();

};


#endif // PATH_EDITOR_PLUGIN_H
