'use strict';

var taplo = require('@taplo/lib');

const languages = [
  {
    "name": "TOML",
    "aceMode": "toml",
    "since": "0.1.0",
    "parsers": [
      "toml"
    ],
    "linguistLanguageId": 365,
    "vscodeLanguageIds": [
      "toml"
    ],
    "extensions": [
      ".toml"
    ],
    "filenames": [
      "Cargo.lock",
      "Gopkg.lock",
      "Pipfile",
      "pdm.lock",
      "poetry.lock"
    ],
    "tmScope": "source.toml",
    "codemirrorMode": "toml",
    "codemirrorMimeType": "text/x-toml"
  }
];

const prettierOptionsDefinitions = {
  alignEntries: {
    name: "alignEntries",
    type: "boolean",
    category: "taplo",
    default: false,
    description: "Align consecutive entries vertically."
  },
  alignComments: {
    name: "alignComments",
    type: "boolean",
    category: "taplo",
    default: true,
    description: "Align consecutive comments after entries and items vertically. This applies to comments that are after entries or array items."
  },
  arrayAutoExpand: {
    name: "arrayAutoExpand",
    type: "boolean",
    category: "taplo",
    default: true,
    description: "Expand arrays to multiple lines that exceed the maximum column width."
  },
  arrayAutoCollapse: {
    name: "arrayAutoCollapse",
    type: "boolean",
    category: "taplo",
    default: true,
    description: "Collapse arrays that don't exceed the maximum column width and don't contain comments."
  },
  compactArrays: {
    name: "compactArrays",
    type: "boolean",
    category: "taplo",
    default: true,
    description: "Omit white space padding from single-line arrays."
  },
  compactInlineTables: {
    name: "compactInlineTables",
    type: "boolean",
    category: "taplo",
    default: false,
    description: "Omit white space padding from the start and end of inline tables."
  },
  compactEntries: {
    name: "compactEntries",
    type: "boolean",
    category: "taplo",
    default: false,
    description: "Omit white space around `=`."
  },
  indentTables: {
    name: "indentTables",
    type: "boolean",
    category: "taplo",
    default: false,
    description: "Indent based on tables and arrays of tables and their subtables, subtables out of order are not indented."
  },
  indentEntries: {
    name: "indentEntries",
    type: "boolean",
    category: "taplo",
    default: false,
    description: "Indent entries under tables."
  },
  reorderKeys: {
    name: "reorderKeys",
    type: "boolean",
    category: "taplo",
    default: false,
    description: "Alphabetically reorder keys that are not separated by empty lines."
  },
  allowedBlankLines: {
    name: "allowedBlankLines",
    type: "int",
    category: "taplo",
    default: 1,
    description: "The maximum number of allowed blank lines between entries and tables."
  }
};

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
const PLUGIN_NAME = "toml";
let taploIns;
function format(code, options) {
  return __async(this, null, function* () {
    if (!taploIns) {
      taploIns = yield taplo.Taplo.initialize();
    }
    return taploIns.format(code, { options });
  });
}
const TomlPlugin = {
  languages,
  parsers: {
    [PLUGIN_NAME]: {
      parse(code, options) {
        return format(code.trim(), __spreadProps(__spreadValues({}, options), {
          columnWidth: options.printWidth,
          indentString: options.useTabs ? "	" : " ".repeat(options.tabWidth),
          trailingNewline: true,
          arrayTrailingComma: options.trailingComma !== "none",
          crlf: options.endOfLine === "crlf"
        }));
      },
      astFormat: PLUGIN_NAME,
      locStart: () => -1,
      locEnd: () => -1
    }
  },
  printers: {
    [PLUGIN_NAME]: {
      print: ({ node }) => node
    }
  },
  options: prettierOptionsDefinitions
};

module.exports = TomlPlugin;
