import { PhraseyConfig } from "./config";
import { PhraseyHooks } from "./hooks";
import { PhraseyLocales } from "./locales";
import { Phrasey } from "./phrasey";
import { PhraseySchema } from "./schema";
import { PhraseyTranslations } from "./translations";
export interface PhraseyStateOptions {
    config?: PhraseyConfig;
    hooks?: PhraseyHooks;
    schema?: PhraseySchema;
    locales?: PhraseyLocales;
    translations?: PhraseyTranslations;
}
export declare class PhraseyState {
    phrasey: Phrasey;
    options?: PhraseyStateOptions | undefined;
    _config?: PhraseyConfig;
    _hooks?: PhraseyHooks;
    _schema?: PhraseySchema;
    _locales?: PhraseyLocales;
    _translations?: PhraseyTranslations;
    constructor(phrasey: Phrasey, options?: PhraseyStateOptions | undefined);
    clone(phrasey: Phrasey, options?: PhraseyStateOptions): PhraseyState;
    clone(options?: PhraseyStateOptions): PhraseyState;
    hasConfig(): boolean;
    getConfig(): PhraseyConfig;
    maybeGetConfig(): PhraseyConfig | undefined;
    setConfig(config?: PhraseyConfig): void;
    hasHooks(): boolean;
    getHooks(): PhraseyHooks;
    maybeGetHooks(): PhraseyHooks | undefined;
    setHooks(hooks?: PhraseyHooks): void;
    hasSchema(): boolean;
    getSchema(): PhraseySchema;
    maybeGetSchema(): PhraseySchema | undefined;
    setSchema(schema?: PhraseySchema): void;
    hasLocales(): boolean;
    getLocales(): PhraseyLocales;
    maybeGetLocales(): PhraseyLocales | undefined;
    setLocales(locales?: PhraseyLocales): void;
    hasTranslations(): boolean;
    getTranslations(): PhraseyTranslations;
    maybeGetTranslations(): PhraseyTranslations | undefined;
    setTranslations(translations?: PhraseyTranslations): void;
}
