"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyValidationError = exports.PhraseyError = void 0;
const utils_1 = require("./utils");
class PhraseyError extends Error {
    constructor(message, options) {
        super(message, options);
    }
    toString() {
        return `PhraseyError: ${this.message}`;
    }
}
exports.PhraseyError = PhraseyError;
class PhraseyValidationError extends Error {
    zodError;
    constructor(message, zodError) {
        super(message);
        this.zodError = zodError;
    }
    toString() {
        return `PhraseyValidationError: ${this.message}\n${this.formattedErrors}`;
    }
    get formattedErrors() {
        return utils_1.PhraseyTreeLike.build(this.zodError.errors, {
            map: (x) => `Invalid field "${x.path.join(".")}" (${x.message})`,
        });
    }
}
exports.PhraseyValidationError = PhraseyValidationError;
