"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyContentFormats = void 0;
const errors_1 = require("./errors");
const utils_1 = require("./utils");
class PhraseyContentFormats {
    static defaultPackages = {
        json: "@zyrouge/phrasey-json",
        toml: "@zyrouge/phrasey-toml",
        yaml: "@zyrouge/phrasey-yaml",
        xml: "@zyrouge/phrasey-xml",
    };
    static resolve(name) {
        const packageName = this.defaultPackages[name] ?? name;
        const pkg = (0, utils_1.PhraseySafeResolvePackage)(packageName);
        if (typeof pkg?.contentFormatter !== "object") {
            throw new errors_1.PhraseyError(`Missing implementation of "contentFormatter" in package "${name}"`);
        }
        if (typeof pkg.contentFormatter.extension !== "string") {
            throw new errors_1.PhraseyError(`Missing implementation of "contentFormatter.extension" in package "${name}"`);
        }
        if (typeof pkg.contentFormatter.serialize !== "function") {
            throw new errors_1.PhraseyError(`Missing implementation of "contentFormatter.serialize" in package "${name}"`);
        }
        if (typeof pkg.contentFormatter.deserialize !== "function") {
            throw new errors_1.PhraseyError(`Missing implementation of "contentFormatter.deserialize" in package "${name}"`);
        }
        return pkg.contentFormatter;
    }
}
exports.PhraseyContentFormats = PhraseyContentFormats;
