"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyLocaleCodesExtendedScriptCode = void 0;
const cldr_1 = require("../../../cldr");
class PhraseyLocaleCodesExtendedScriptCode {
    static parse({ code, script }, displayLocaleCode) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!script)
                return;
            const display = yield this.parseDisplay(displayLocaleCode, script);
            const native = yield this.parseDisplay(code, script);
            return {
                display,
                native,
                code: script,
            };
        });
    }
    static parseDisplay(code, script) {
        return __awaiter(this, void 0, void 0, function* () {
            const data = yield cldr_1.PhraseyCldrLocaleNamesScripts.parse(code);
            return data.main[code].localeDisplayNames.scripts[script];
        });
    }
}
exports.PhraseyLocaleCodesExtendedScriptCode = PhraseyLocaleCodesExtendedScriptCode;
