"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyLocaleCodesDetails = void 0;
const language_1 = require("./language");
const script_1 = require("./script");
const territory_1 = require("./territory");
class PhraseyLocaleCodesDetails {
    static parse(locale, displayLocaleCode) {
        return __awaiter(this, void 0, void 0, function* () {
            const language = yield language_1.PhraseyLocaleCodesExtendedLanguage.parse(locale, displayLocaleCode);
            const territory = yield territory_1.PhraseyLocaleCodesExtendedTerritory.parse(locale, displayLocaleCode);
            const script = yield script_1.PhraseyLocaleCodesExtendedScriptCode.parse(locale, displayLocaleCode);
            return { language, territory, script };
        });
    }
}
exports.PhraseyLocaleCodesDetails = PhraseyLocaleCodesDetails;
