"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyLocaleCodes = void 0;
const cldr_1 = require("../../cldr");
class PhraseyLocaleCodes {
    static parse(code) {
        return __awaiter(this, void 0, void 0, function* () {
            const languages = yield cldr_1.PhraseyCldrLocaleNamesLanguages.parse(code);
            const { language, territory, script } = languages.main[code].identity;
            return { code, language, territory, script };
        });
    }
    static parseAll() {
        return __awaiter(this, void 0, void 0, function* () {
            const availableLocales = yield cldr_1.PhraseyCldrCoreAvailableLocales.parse();
            return availableLocales.availableLocales.modern;
        });
    }
}
exports.PhraseyLocaleCodes = PhraseyLocaleCodes;
