
package io.github.zyrouge.symphony.services.i18n

@Suppress("ClassName")
open class _Translations {
    val localeCodes: List<String> = listOf(
        "be",
        "zh-Hans",
        "en",
        "fi",
        "fr",
        "de",
        "it",
        "ja",
        "ryu",
        "fa",
        "pl",
        "pt",
        "ro",
        "ru",
        "es",
        "tr",
        "uk",
        "vi",
    )
    val localeDisplayNames: Map<String, String> = mapOf(
        "be" to "Belarusian",
        "zh-Hans" to "Chinese (Simplified)",
        "en" to "English",
        "fi" to "Finnish",
        "fr" to "French",
        "de" to "German",
        "it" to "Italian",
        "ja" to "Japanese",
        "ryu" to "Okinawan",
        "fa" to "Persian",
        "pl" to "Polish",
        "pt" to "Portuguese",
        "ro" to "Romanian",
        "ru" to "Russian",
        "es" to "Spanish",
        "tr" to "Turkish",
        "uk" to "Ukrainian",
        "vi" to "Vietnamese",
    )
    val localeNativeNames: Map<String, String> = mapOf(
        "be" to "беларуская",
        "zh-Hans" to "中文 (简体)",
        "en" to "English",
        "fi" to "suomi",
        "fr" to "français",
        "de" to "Deutsch",
        "it" to "italiano",
        "ja" to "日本語",
        "ryu" to "うちなーぐち",
        "fa" to "فارسی",
        "pl" to "polski",
        "pt" to "português",
        "ro" to "română",
        "ru" to "русский",
        "es" to "español",
        "tr" to "Türkçe",
        "uk" to "українська",
        "vi" to "Tiếng Việt",
    )
}
    