export interface PhraseyResultSuccess<V> {
    success: true;
    data: V;
}
export interface PhraseyResultError<E> {
    success: false;
    error: E;
}
export type PhraseyResult<V, E> = PhraseyResultSuccess<V> | PhraseyResultError<E>;
export declare const PhraseySafeRun: <T>(fn: () => T) => PhraseyResult<T, Error>;
export declare const PhraseySafeRunAsync: <T>(fn: () => Promise<T>) => Promise<PhraseyResult<T, Error>>;
