"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyLocales = void 0;
const contentFormats_1 = require("./contentFormats");
const transformer_1 = require("./transformer");
const utils_1 = require("./utils");
const z_1 = require("./z");
__exportStar(require("@zyrouge/phrasey-locales-shared"), exports);
class PhraseyLocales {
    all;
    constructor(all) {
        this.all = all;
    }
    json() {
        return this;
    }
    static async create(path, format) {
        const locales = await transformer_1.PhraseyTransformer.transform(path, contentFormats_1.PhraseyContentFormats.resolve(format), z_1.PhraseyZLocales);
        if (!locales.success) {
            return locales;
        }
        return {
            success: true,
            data: new PhraseyLocales(locales.data),
        };
    }
    static defaultLocales() {
        const pkg = (0, utils_1.PhraseySafeResolvePackage)("@zyrouge/phrasey-locales");
        return new PhraseyLocales(pkg.PhraseyDefaultLocales);
    }
}
exports.PhraseyLocales = PhraseyLocales;
