"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InitCommand = void 0;
const commander_1 = require("commander");
const fs_extra_1 = require("fs-extra");
const path_1 = __importDefault(require("path"));
const log_1 = require("../utils/log");
exports.InitCommand = new commander_1.Command()
    .name("init")
    .description("Initialize a new project. (deprecated)")
    .action(async () => {
    const config = {
        input: {
            files: ["./i18n/**.json"],
            format: "json",
            fallback: [],
        },
        schema: {
            file: "./phrasey-schema.json",
            format: "json",
        },
        output: {
            dir: "./dist-i18n",
            format: "json",
            stringFormat: "format-string",
        },
        hooks: {
            files: [],
        },
    };
    const configFilePath = path_1.default.resolve(process.cwd(), "./phrasey.json");
    await writeJsonFile(configFilePath, config);
    log_1.log.success(`Generated config at "${configFilePath}".`);
    const schema = {
        keys: [
            {
                name: "HelloX",
                description: "Say hello to a user!",
                parameters: ["user"],
            },
        ],
    };
    const schemaFilePath = path_1.default.resolve(process.cwd(), "./phrasey-schema.json");
    await writeJsonFile(schemaFilePath, schema);
    log_1.log.success(`Generated schema at "${schemaFilePath}".`);
    const demoTranslation = {
        locale: "en",
        keys: {
            HelloX: "Hello {user}!",
        },
    };
    const demoTranslationFilePath = path_1.default.resolve(process.cwd(), "./i18n/en.json");
    await (0, fs_extra_1.ensureDir)(path_1.default.dirname(demoTranslationFilePath));
    await writeJsonFile(demoTranslationFilePath, demoTranslation);
    log_1.log.success(`Generated demo translation at "${demoTranslationFilePath}".`);
});
async function writeJsonFile(path, json) {
    const stringified = JSON.stringify(json, null, 4);
    if (await (0, fs_extra_1.exists)(path)) {
        log_1.log.error(`Existing config file at "${path}", exiting...`);
        log_1.log.ln();
        process.exit(1);
    }
    await (0, fs_extra_1.writeFile)(path, stringified);
}
