"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyLocaleBuilder = void 0;
const parsers_1 = require("./parsers");
class PhraseyLocaleBuilder {
    static build(options) {
        return __awaiter(this, void 0, void 0, function* () {
            const locales = [];
            const localeCodes = yield parsers_1.PhraseyLocaleCodes.parseAll();
            for (const code of localeCodes) {
                // "und" is used for undetermined primary language
                if (code === "und")
                    continue;
                const rawLocaleCode = yield parsers_1.PhraseyLocaleCodes.parse(code);
                const details = yield parsers_1.PhraseyLocaleCodesDetails.parse(rawLocaleCode, options.displayLocaleCode);
                const display = this.constructDisplay(details);
                const native = this.constructNative(details);
                const direction = yield parsers_1.PhraseyLocaleCodeLayout.parse(rawLocaleCode);
                locales.push({
                    display,
                    native,
                    code,
                    details,
                    direction,
                });
            }
            return locales;
        });
    }
    static constructDisplay(extended) {
        let out = `${extended.language.display}`;
        if (extended.territory) {
            out += ` (${extended.territory.display})`;
        }
        if (extended.script) {
            out += ` (${extended.script.display})`;
        }
        return out;
    }
    static constructNative(extended) {
        let out = `${extended.language.native}`;
        if (extended.territory) {
            out += ` (${extended.territory.native})`;
        }
        if (extended.script) {
            out += ` (${extended.script.native})`;
        }
        return out;
    }
}
exports.PhraseyLocaleBuilder = PhraseyLocaleBuilder;
