import { z } from "zod";
export declare const PhraseyZSchemaKey: z.ZodObject<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    parameters: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    name: string;
    description?: string | undefined;
    parameters?: string[] | undefined;
}, {
    name: string;
    description?: string | undefined;
    parameters?: string[] | undefined;
}>;
export declare const PhraseyZSchema: z.ZodObject<{
    keys: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        parameters: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        description?: string | undefined;
        parameters?: string[] | undefined;
    }, {
        name: string;
        description?: string | undefined;
        parameters?: string[] | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    keys: {
        name: string;
        description?: string | undefined;
        parameters?: string[] | undefined;
    }[];
}, {
    keys: {
        name: string;
        description?: string | undefined;
        parameters?: string[] | undefined;
    }[];
}>;
export type PhraseyZSchemaType = z.infer<typeof PhraseyZSchema>;
export type PhraseyZSchemaKeyType = z.infer<typeof PhraseyZSchemaKey>;
