"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyZConfig = exports.PhraseyZConfigLocales = exports.PhraseyZConfigHooks = exports.PhraseyZConfigHooksExpanded = exports.PhraseyZConfigOutput = exports.PhraseyZConfigInput = exports.PhraseyZConfigSchema = void 0;
const zod_1 = require("zod");
exports.PhraseyZConfigSchema = zod_1.z.object({
    file: zod_1.z.string(),
    format: zod_1.z.string(),
});
exports.PhraseyZConfigInput = zod_1.z.object({
    files: zod_1.z.union([zod_1.z.string(), zod_1.z.array(zod_1.z.string())]),
    format: zod_1.z.string(),
    fallback: zod_1.z.union([zod_1.z.string(), zod_1.z.array(zod_1.z.string())]).optional(),
});
exports.PhraseyZConfigOutput = zod_1.z.object({
    dir: zod_1.z.string(),
    format: zod_1.z.string(),
    stringFormat: zod_1.z.string(),
});
exports.PhraseyZConfigHooksExpanded = zod_1.z.object({
    path: zod_1.z.string(),
    options: zod_1.z.record(zod_1.z.any()).optional(),
});
exports.PhraseyZConfigHooks = zod_1.z.object({
    files: zod_1.z.array(zod_1.z.union([zod_1.z.string(), exports.PhraseyZConfigHooksExpanded]).transform((x) => {
        if (typeof x === "string")
            return { path: x };
        return x;
    })),
});
exports.PhraseyZConfigLocales = zod_1.z.object({
    file: zod_1.z.string(),
    format: zod_1.z.string(),
});
exports.PhraseyZConfig = zod_1.z.object({
    schema: exports.PhraseyZConfigSchema,
    input: exports.PhraseyZConfigInput,
    output: exports.PhraseyZConfigOutput.optional(),
    hooks: exports.PhraseyZConfigHooks.optional(),
    locales: exports.PhraseyZConfigLocales.optional(),
});
