import { z } from "zod";
export declare const PhraseyZConfigSchema: z.ZodObject<{
    file: z.ZodString;
    format: z.ZodString;
}, "strip", z.ZodTypeAny, {
    file: string;
    format: string;
}, {
    file: string;
    format: string;
}>;
export declare const PhraseyZConfigInput: z.ZodObject<{
    files: z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>;
    format: z.ZodString;
    fallback: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
}, "strip", z.ZodTypeAny, {
    format: string;
    files: (string | string[]) & (string | string[] | undefined);
    fallback?: string | string[] | undefined;
}, {
    format: string;
    files: (string | string[]) & (string | string[] | undefined);
    fallback?: string | string[] | undefined;
}>;
export declare const PhraseyZConfigOutput: z.ZodObject<{
    dir: z.ZodString;
    format: z.ZodString;
    stringFormat: z.ZodString;
}, "strip", z.ZodTypeAny, {
    format: string;
    dir: string;
    stringFormat: string;
}, {
    format: string;
    dir: string;
    stringFormat: string;
}>;
export declare const PhraseyZConfigHooksExpanded: z.ZodObject<{
    path: z.ZodString;
    options: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
}, "strip", z.ZodTypeAny, {
    path: string;
    options?: Record<string, any> | undefined;
}, {
    path: string;
    options?: Record<string, any> | undefined;
}>;
export declare const PhraseyZConfigHooks: z.ZodObject<{
    files: z.ZodArray<z.ZodEffects<z.ZodUnion<[z.ZodString, z.ZodObject<{
        path: z.ZodString;
        options: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    }, "strip", z.ZodTypeAny, {
        path: string;
        options?: Record<string, any> | undefined;
    }, {
        path: string;
        options?: Record<string, any> | undefined;
    }>]>, {
        path: string;
        options?: Record<string, any> | undefined;
    }, string | {
        path: string;
        options?: Record<string, any> | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    files: {
        path: string;
        options?: Record<string, any> | undefined;
    }[];
}, {
    files: (string | {
        path: string;
        options?: Record<string, any> | undefined;
    })[];
}>;
export declare const PhraseyZConfigLocales: z.ZodObject<{
    file: z.ZodString;
    format: z.ZodString;
}, "strip", z.ZodTypeAny, {
    file: string;
    format: string;
}, {
    file: string;
    format: string;
}>;
export declare const PhraseyZConfig: z.ZodObject<{
    schema: z.ZodObject<{
        file: z.ZodString;
        format: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        file: string;
        format: string;
    }, {
        file: string;
        format: string;
    }>;
    input: z.ZodObject<{
        files: z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>;
        format: z.ZodString;
        fallback: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
    }, "strip", z.ZodTypeAny, {
        format: string;
        files: (string | string[]) & (string | string[] | undefined);
        fallback?: string | string[] | undefined;
    }, {
        format: string;
        files: (string | string[]) & (string | string[] | undefined);
        fallback?: string | string[] | undefined;
    }>;
    output: z.ZodOptional<z.ZodObject<{
        dir: z.ZodString;
        format: z.ZodString;
        stringFormat: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        format: string;
        dir: string;
        stringFormat: string;
    }, {
        format: string;
        dir: string;
        stringFormat: string;
    }>>;
    hooks: z.ZodOptional<z.ZodObject<{
        files: z.ZodArray<z.ZodEffects<z.ZodUnion<[z.ZodString, z.ZodObject<{
            path: z.ZodString;
            options: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
        }, "strip", z.ZodTypeAny, {
            path: string;
            options?: Record<string, any> | undefined;
        }, {
            path: string;
            options?: Record<string, any> | undefined;
        }>]>, {
            path: string;
            options?: Record<string, any> | undefined;
        }, string | {
            path: string;
            options?: Record<string, any> | undefined;
        }>, "many">;
    }, "strip", z.ZodTypeAny, {
        files: {
            path: string;
            options?: Record<string, any> | undefined;
        }[];
    }, {
        files: (string | {
            path: string;
            options?: Record<string, any> | undefined;
        })[];
    }>>;
    locales: z.ZodOptional<z.ZodObject<{
        file: z.ZodString;
        format: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        file: string;
        format: string;
    }, {
        file: string;
        format: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    schema: {
        file: string;
        format: string;
    };
    input: {
        format: string;
        files: (string | string[]) & (string | string[] | undefined);
        fallback?: string | string[] | undefined;
    };
    output?: {
        format: string;
        dir: string;
        stringFormat: string;
    } | undefined;
    hooks?: {
        files: {
            path: string;
            options?: Record<string, any> | undefined;
        }[];
    } | undefined;
    locales?: {
        file: string;
        format: string;
    } | undefined;
}, {
    schema: {
        file: string;
        format: string;
    };
    input: {
        format: string;
        files: (string | string[]) & (string | string[] | undefined);
        fallback?: string | string[] | undefined;
    };
    output?: {
        format: string;
        dir: string;
        stringFormat: string;
    } | undefined;
    hooks?: {
        files: (string | {
            path: string;
            options?: Record<string, any> | undefined;
        })[];
    } | undefined;
    locales?: {
        file: string;
        format: string;
    } | undefined;
}>;
export type PhraseyZConfigType = z.infer<typeof PhraseyZConfig>;
export type PhraseyZConfigSchemaType = z.infer<typeof PhraseyZConfigSchema>;
export type PhraseyZConfigInputType = z.infer<typeof PhraseyZConfigInput>;
export type PhraseyZConfigOutputType = z.infer<typeof PhraseyZConfigOutput>;
export type PhraseyZConfigHooksType = z.infer<typeof PhraseyZConfigHooks>;
export type PhraseyZConfigLocalesType = z.infer<typeof PhraseyZConfigLocales>;
