"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyState = void 0;
const errors_1 = require("./errors");
const phrasey_1 = require("./phrasey");
class PhraseyState {
    phrasey;
    options;
    _config;
    _hooks;
    _schema;
    _locales;
    _translations;
    constructor(phrasey, options) {
        this.phrasey = phrasey;
        this.options = options;
        this.setConfig(options?.config);
        this.setHooks(options?.hooks);
        this.setSchema(options?.schema);
        this.setLocales(options?.locales);
        this.setTranslations(options?.translations);
    }
    clone(a0, a1) {
        let phrasey;
        let options;
        if (a0 instanceof phrasey_1.Phrasey) {
            phrasey = a0;
            options = a1;
        }
        else {
            phrasey = this.phrasey;
            options = a1 ?? a0;
        }
        return new PhraseyState(phrasey, {
            config: options?.config ?? this._config,
            hooks: options?.hooks ?? this._hooks,
            schema: options?.schema ?? this._schema,
            locales: options?.locales ?? this._locales,
            translations: options?.translations ?? this._translations,
        });
    }
    hasConfig() {
        return this._config !== undefined;
    }
    getConfig() {
        if (!this.hasConfig()) {
            throw new errors_1.PhraseyError("State does not possess config");
        }
        return this._config;
    }
    maybeGetConfig() {
        return this._config;
    }
    setConfig(config) {
        this._config = config;
    }
    hasHooks() {
        return this._hooks !== undefined;
    }
    getHooks() {
        if (!this.hasHooks()) {
            throw new errors_1.PhraseyError("State does not possess hooks");
        }
        return this._hooks;
    }
    maybeGetHooks() {
        return this._hooks;
    }
    setHooks(hooks) {
        this._hooks = hooks;
    }
    hasSchema() {
        return this._schema !== undefined;
    }
    getSchema() {
        if (!this.hasSchema()) {
            throw new errors_1.PhraseyError("State does not possess schema");
        }
        return this._schema;
    }
    maybeGetSchema() {
        return this._schema;
    }
    setSchema(schema) {
        this._schema = schema;
    }
    hasLocales() {
        return this._locales !== undefined;
    }
    getLocales() {
        if (!this.hasLocales()) {
            throw new errors_1.PhraseyError("State does not possess locales");
        }
        return this._locales;
    }
    maybeGetLocales() {
        return this._locales;
    }
    setLocales(locales) {
        this._locales = locales;
    }
    hasTranslations() {
        return this._translations !== undefined;
    }
    getTranslations() {
        if (!this.hasTranslations()) {
            throw new errors_1.PhraseyError("State does not possess translations");
        }
        return this._translations;
    }
    maybeGetTranslations() {
        return this._translations;
    }
    setTranslations(translations) {
        this._translations = translations;
    }
}
exports.PhraseyState = PhraseyState;
