/// <reference types="node" />
import { PhraseyConfig } from "./config";
import { PhraseyContentFormatter } from "./contentFormats";
import { PhraseyHooks } from "./hooks";
import { PhraseyLocales } from "./locales";
import { Phrasey, PhraseyOptions } from "./phrasey";
import { PhraseyResult } from "./result";
import { PhraseySchema } from "./schema";
import { PhraseyState } from "./state";
import { PhraseySummary } from "./summary";
import { PhraseyTranslation } from "./translation";
import { PhraseyTranslationStringFormatter } from "./translationStringFormat";
import { PhraseyTranslations } from "./translations";
import { PhraseyBuildablePipeline } from "./utils";
export interface PhraseyBuilderOptions {
    config: {
        file: string;
        format: string;
    };
    translations?: {
        skip: (path: string) => boolean;
    };
}
export interface PhraseyBuilderCreateOptions {
    phrasey: PhraseyOptions;
    builder: PhraseyBuilderOptions;
}
export interface PhraseyBuilderConstructPipelineOptions {
    loadConfig: boolean;
    loadHooks: boolean;
    loadLocales: boolean;
    loadSchema: boolean;
    loadTranslations: boolean;
    ensureTranslations: boolean;
    buildTranslations: boolean;
}
export declare class PhraseyBuilder {
    phrasey: Phrasey;
    state: PhraseyState;
    options: PhraseyBuilderOptions;
    constructor(phrasey: Phrasey, state: PhraseyState, options: PhraseyBuilderOptions);
    loadConfig(): Promise<PhraseyResult<true, Error>>;
    loadHooks(): Promise<PhraseyResult<true, Error>>;
    loadLocales(): Promise<PhraseyResult<true, Error>>;
    loadSchema(): Promise<PhraseyResult<true, Error>>;
    getInputFallbackFilePaths(): string[];
    getInputFilePaths(): NodeJS.ReadableStream;
    loadTranslations(): Promise<PhraseyResult<true, Error | Error[]>>;
    loadTranslation(path: string, formatter: PhraseyContentFormatter, globalFallback: string[]): Promise<PhraseyResult<true, Error>>;
    ensureTranslations(): Promise<PhraseyResult<true, Error | Error[]>>;
    ensureTranslation(translation: PhraseyTranslation): Promise<PhraseyResult<true, Error>>;
    buildTranslations(): Promise<PhraseyResult<true, Error | Error[]>>;
    buildTranslation(path: string, translation: PhraseyTranslation, formatter: PhraseyContentFormatter, stringFormatter: PhraseyTranslationStringFormatter): Promise<PhraseyResult<true, Error>>;
    getSummary(): PhraseySummary;
    constructBuildablePipeline(options: PhraseyBuilderConstructPipelineOptions): PhraseyBuildablePipeline;
    constructPipeline(options: PhraseyBuilderConstructPipelineOptions): import("./utils").PhraseyPipeline<true>;
    constructBuildPipeline(): import("./utils").PhraseyPipeline<true>;
    constructSummaryPipeline(): import("./utils").PhraseyPipeline<PhraseySummary>;
    get config(): PhraseyConfig;
    get hooks(): PhraseyHooks;
    get schema(): PhraseySchema;
    get locales(): PhraseyLocales;
    get translations(): PhraseyTranslations;
    static create(options: PhraseyBuilderCreateOptions): PhraseyBuilder;
    static build(options: PhraseyBuilderCreateOptions): Promise<PhraseyResult<true, Error | Error[]>>;
    static summary(options: PhraseyBuilderCreateOptions): Promise<PhraseyResult<PhraseySummary, Error | Error[]>>;
}
