package io.github.v2compose.ui.user

import android.content.Context
import androidx.compose.material3.SnackbarHostState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.ui.platform.LocalContext
import io.github.v2compose.LocalSnackbarHostState
import io.github.v2compose.ui.BaseScreenState
import kotlinx.coroutines.CoroutineScope

@Composable
fun rememberUserScreenState(
    context: Context = LocalContext.current,
    coroutineScope: CoroutineScope = rememberCoroutineScope(),
    snackbarHostState: SnackbarHostState = LocalSnackbarHostState.current,
): UserScreenState {
    return remember(context, coroutineScope, snackbarHostState) {
        UserScreenState(context, coroutineScope, snackbarHostState)
    }
}

class UserScreenState(
    context: Context,
    coroutineScope: CoroutineScope,
    snackbarHostState: SnackbarHostState,
) : BaseScreenState(context, coroutineScope, snackbarHostState) {


}